/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.Portable;
import org.mortbay.io.View;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public abstract class AbstractBuffer
implements Buffer {
    protected static final String IMMUTABLE = "IMMUTABLE";
    protected static final String READONLY = "READONLY";
    protected static final String READWRITE = "READWRITE";
    protected static final String VOLATILE = "VOLATILE";
    protected int accessType;
    protected boolean unstable;
    protected int readIndex;
    protected int writeIndex;
    protected int hashValue;
    private int hashReadIndex;
    private int hashWriteIndex;
    private int markIndex;
    protected String string;
    private View view;

    public AbstractBuffer(int access, boolean isVolatile) {
        if (access == 0 && isVolatile) {
            throw new IllegalArgumentException("IMMUTABLE && VOLATILE");
        }
        this.setMarkIndex(-1);
        this.accessType = access;
        this.unstable = isVolatile;
    }

    @Override
    public byte[] asArray() {
        byte[] bytes = new byte[this.length()];
        byte[] array = this.array();
        if (array != null) {
            Portable.arraycopy(array, this.getReadIndex(), bytes, 0, bytes.length);
        } else {
            this.peek(this.getReadIndex(), bytes, 0, this.length());
        }
        return bytes;
    }

    public ByteArrayBuffer duplicate(int access) {
        Buffer b = this.buffer();
        if (b instanceof Buffer.CaseInsensitve) {
            return new ByteArrayBuffer.CaseInsensitive(this.asArray(), 0, this.length(), access);
        }
        return new ByteArrayBuffer(this.asArray(), 0, this.length(), access);
    }

    @Override
    public Buffer asNonVolatileBuffer() {
        if (!this.isVolatile()) {
            return this;
        }
        return this.duplicate(this.accessType);
    }

    @Override
    public Buffer asImmutableBuffer() {
        if (this.isImmutable()) {
            return this;
        }
        return this.duplicate(0);
    }

    @Override
    public Buffer asReadOnlyBuffer() {
        if (this.isReadOnly()) {
            return this;
        }
        return new View(this, this.getMarkIndex(), this.getReadIndex(), this.getWriteIndex(), 1);
    }

    @Override
    public Buffer asMutableBuffer() {
        if (!this.isImmutable()) {
            return this;
        }
        Buffer b = this.buffer();
        if (b.isReadOnly()) {
            return this.duplicate(2);
        }
        return new View(b, this.getMarkIndex(), this.getReadIndex(), this.getWriteIndex(), this.accessType);
    }

    @Override
    public Buffer buffer() {
        return this;
    }

    @Override
    public void clear() {
        this.setGetIndex(0);
        this.setPutIndex(0);
    }

    @Override
    public void compact() {
        int s;
        if (this.isReadOnly()) {
            throw new IllegalStateException(READONLY);
        }
        int n = s = this.getMarkIndex() >= 0 ? this.getMarkIndex() : this.getReadIndex();
        if (s > 0) {
            byte[] array = this.array();
            int length = this.getWriteIndex() - s;
            if (length > 0) {
                if (array != null) {
                    Portable.arraycopy(this.array(), s, this.array(), 0, length);
                } else {
                    this.poke(0, this.peek(s, length));
                }
            }
            if (this.getMarkIndex() > 0) {
                this.setMarkIndex(this.getMarkIndex() - s);
            }
            this.setGetIndex(this.getReadIndex() - s);
            this.setPutIndex(this.getWriteIndex() - s);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Buffer)) {
            return false;
        }
        Buffer b = (Buffer)obj;
        if (this instanceof Buffer.CaseInsensitve || b instanceof Buffer.CaseInsensitve) {
            return this.equalsIgnoreCase(b);
        }
        if (b.length() != this.length()) {
            return false;
        }
        if (this.hashValue != 0 && obj instanceof AbstractBuffer) {
            AbstractBuffer ab = (AbstractBuffer)obj;
            if (ab.hashValue != 0 && this.hashValue != ab.hashValue) {
                return false;
            }
        }
        int i = this.length();
        while (i-- > 0) {
            byte b2;
            byte b1 = this.peek(this.getReadIndex() + i);
            if (b1 == (b2 = b.peek(b.getReadIndex() + i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsIgnoreCase(Buffer b) {
        if (b == this) {
            return true;
        }
        if (b.length() != this.length()) {
            return false;
        }
        if (this.hashValue != 0 && b instanceof AbstractBuffer) {
            AbstractBuffer ab = (AbstractBuffer)b;
            if (ab.hashValue != 0 && this.hashValue != ab.hashValue) {
                return false;
            }
        }
        int i = this.length();
        while (i-- > 0) {
            byte b2;
            byte b1 = this.peek(this.getReadIndex() + i);
            if (b1 == (b2 = b.peek(b.getReadIndex() + i))) continue;
            if (97 <= b1 && b1 <= 122) {
                b1 = (byte)(b1 - 97 + 65);
            }
            if (97 <= b2 && b2 <= 122) {
                b2 = (byte)(b2 - 97 + 65);
            }
            if (b1 == b2) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte get() {
        return this.peek(this.readIndex++);
    }

    @Override
    public int get(byte[] b, int offset, int length) {
        int gi = this.getReadIndex();
        int l = this.length();
        if (length > l) {
            length = l;
        }
        length = this.peek(gi, b, offset, length);
        this.setGetIndex(gi + length);
        return length;
    }

    @Override
    public Buffer get(int length) {
        int gi = this.getReadIndex();
        Buffer view = this.peek(gi, length);
        this.setGetIndex(gi + length);
        return view;
    }

    @Override
    public final int getReadIndex() {
        return this.readIndex;
    }

    @Override
    public boolean hasContent() {
        return this.writeIndex > this.readIndex;
    }

    public int hashCode() {
        if (this.hashValue == 0 || this.hashReadIndex != this.readIndex || this.hashWriteIndex != this.writeIndex) {
            int i = this.getWriteIndex();
            while (i-- > this.getReadIndex()) {
                byte b = this.peek(i);
                if (97 <= b && b <= 122) {
                    b = (byte)(b - 97 + 65);
                }
                this.hashValue = 31 * this.hashValue + b;
            }
            if (this.hashValue == 0) {
                this.hashValue = -1;
            }
            this.hashReadIndex = this.readIndex;
            this.hashWriteIndex = this.writeIndex;
        }
        return this.hashValue;
    }

    @Override
    public boolean isImmutable() {
        return this.accessType <= 0;
    }

    @Override
    public boolean isReadOnly() {
        return this.accessType <= 1;
    }

    @Override
    public boolean isVolatile() {
        return this.unstable;
    }

    @Override
    public int length() {
        return this.writeIndex - this.readIndex;
    }

    @Override
    public void mark() {
        this.setMarkIndex(this.readIndex - 1);
    }

    @Override
    public void mark(int offset) {
        this.setMarkIndex(this.readIndex + offset);
    }

    @Override
    public int getMarkIndex() {
        return this.markIndex;
    }

    @Override
    public byte peek() {
        return this.peek(this.readIndex);
    }

    @Override
    public Buffer peek(int index, int length) {
        if (this.view == null) {
            this.view = new View(this, -1, index, index + length, this.isReadOnly() ? 1 : 2);
        } else {
            this.view.update(this.buffer());
            this.view.setMarkIndex(-1);
            this.view.setGetIndex(0);
            this.view.setPutIndex(index + length);
            this.view.setGetIndex(index);
        }
        return this.view;
    }

    @Override
    public int poke(int index, Buffer src) {
        this.hashValue = 0;
        if (this.isReadOnly()) {
            throw new IllegalStateException(READONLY);
        }
        if (index < 0) {
            throw new IllegalArgumentException("index<0: " + index + "<0");
        }
        int length = src.length();
        if (index + length > this.capacity() && (length = this.capacity() - index) < 0) {
            throw new IllegalArgumentException("index>capacity(): " + index + ">" + this.capacity());
        }
        byte[] src_array = src.array();
        byte[] dst_array = this.array();
        if (src_array != null && dst_array != null) {
            Portable.arraycopy(src_array, src.getReadIndex(), dst_array, index, length);
        } else if (src_array != null) {
            int s = src.getReadIndex();
            for (int i = 0; i < length; ++i) {
                this.poke(index++, src_array[s++]);
            }
        } else if (dst_array != null) {
            int s = src.getReadIndex();
            for (int i = 0; i < length; ++i) {
                dst_array[index++] = src.peek(s++);
            }
        } else {
            int s = src.getReadIndex();
            for (int i = 0; i < length; ++i) {
                this.poke(index++, src.peek(s++));
            }
        }
        return length;
    }

    @Override
    public int poke(int index, byte[] b, int offset, int length) {
        this.hashValue = 0;
        if (this.isReadOnly()) {
            throw new IllegalStateException(READONLY);
        }
        if (index < 0) {
            throw new IllegalArgumentException("index<0: " + index + "<0");
        }
        if (index + length > this.capacity() && (length = this.capacity() - index) < 0) {
            throw new IllegalArgumentException("index>capacity(): " + index + ">" + this.capacity());
        }
        byte[] dst_array = this.array();
        if (dst_array != null) {
            Portable.arraycopy(b, offset, dst_array, index, length);
        } else {
            int s = offset;
            for (int i = 0; i < length; ++i) {
                this.poke(index++, b[s++]);
            }
        }
        return length;
    }

    @Override
    public int put(Buffer src) {
        int pi = this.getWriteIndex();
        int l = this.poke(pi, src);
        this.setPutIndex(pi + l);
        return l;
    }

    @Override
    public void put(byte b) {
        int pi = this.getWriteIndex();
        this.poke(pi, b);
        this.setPutIndex(pi + 1);
    }

    @Override
    public int put(byte[] b, int offset, int length) {
        int pi = this.getWriteIndex();
        int l = this.poke(pi, b, offset, length);
        this.setPutIndex(pi + l);
        return l;
    }

    @Override
    public int put(byte[] b) {
        int pi = this.getWriteIndex();
        int l = this.poke(pi, b, 0, b.length);
        this.setPutIndex(pi + l);
        return l;
    }

    @Override
    public final int getWriteIndex() {
        return this.writeIndex;
    }

    @Override
    public void reset() {
        if (this.getMarkIndex() >= 0) {
            this.setGetIndex(this.getMarkIndex());
        }
    }

    public void rewind() {
        this.setGetIndex(0);
        this.setMarkIndex(-1);
    }

    @Override
    public void setGetIndex(int getIndex) {
        this.readIndex = getIndex;
        this.hashValue = 0;
    }

    @Override
    public void setMarkIndex(int index) {
        if (index >= 0 && this.isImmutable()) {
            throw new IllegalStateException(IMMUTABLE);
        }
        this.markIndex = index;
    }

    @Override
    public void setPutIndex(int putIndex) {
        this.writeIndex = putIndex;
        this.hashValue = 0;
    }

    @Override
    public int skip(int n) {
        if (this.length() < n) {
            n = this.length();
        }
        this.setGetIndex(this.getReadIndex() + n);
        return n;
    }

    @Override
    public Buffer slice() {
        return this.peek(this.getReadIndex(), this.length());
    }

    @Override
    public Buffer sliceFromMark() {
        return this.sliceFromMark(this.getReadIndex() - this.getMarkIndex() - 1);
    }

    @Override
    public Buffer sliceFromMark(int length) {
        if (this.getMarkIndex() < 0) {
            return null;
        }
        Buffer view = this.peek(this.getMarkIndex(), length);
        this.setMarkIndex(-1);
        return view;
    }

    @Override
    public int space() {
        return this.capacity() - this.getWriteIndex();
    }

    @Override
    public String toDetailString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        buf.append(super.hashCode());
        buf.append(",");
        buf.append(this.array().hashCode());
        buf.append(",m=");
        buf.append(this.getMarkIndex());
        buf.append(",g=");
        buf.append(this.getReadIndex());
        buf.append(",p=");
        buf.append(this.getWriteIndex());
        buf.append(",c=");
        buf.append(this.capacity());
        buf.append("]={");
        if (this.getMarkIndex() >= 0) {
            for (int i = this.getMarkIndex(); i < this.getReadIndex(); ++i) {
                char c = (char)this.peek(i);
                if (this.isISOControl(c)) {
                    buf.append(c < '\u0010' ? "\\0" : "\\");
                    buf.append(Integer.toString(c, 16));
                    continue;
                }
                buf.append(c);
            }
            buf.append("}{");
        }
        int count = 0;
        for (int i = this.getReadIndex(); i < this.getWriteIndex(); ++i) {
            char c = (char)this.peek(i);
            if (this.isISOControl(c)) {
                buf.append(c < '\u0010' ? "\\0" : "\\");
                buf.append(Integer.toString(c, 16));
            } else {
                buf.append(c);
            }
            if (count++ != 50 || this.getWriteIndex() - i <= 20) continue;
            buf.append(" ... ");
            i = this.getWriteIndex() - 20;
        }
        buf.append('}');
        return buf.toString();
    }

    private boolean isISOControl(char c) {
        return c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f';
    }

    public String toString() {
        if (this.isImmutable()) {
            if (this.string == null) {
                this.string = new String(this.asArray(), 0, this.length());
            }
            return this.string;
        }
        return new String(this.asArray(), 0, this.length());
    }

    public String toDebugString() {
        return this.getClass() + "@" + super.hashCode();
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        byte[] array = this.array();
        if (array != null) {
            out.write(array, this.getReadIndex(), this.length());
        } else {
            for (int i = this.readIndex; i < this.writeIndex; ++i) {
                out.write(this.peek(i));
            }
        }
        this.clear();
    }

    @Override
    public int readFrom(InputStream in, int max) throws IOException {
        int len = 0;
        while (this.space() > 0) {
            int b = in.read();
            if (b < 0) {
                return -1;
            }
            this.put((byte)b);
            ++len;
        }
        return len;
    }
}

