/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import com.sun.javacard.Logger;
import com.sun.javacard.impl.NativeMethods;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.ServletOutputStream;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferUtil;
import org.mortbay.io.Buffers;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;
import org.mortbay.io.Portable;
import org.mortbay.io.View;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpStatus;
import org.mortbay.jetty.HttpTokens;
import org.mortbay.jetty.HttpVersions;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.util.ByteArrayOutputStream2;
import org.mortbay.util.StringUtil;
import org.mortbay.util.UrlEncoded;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class HttpGenerator {
    public static final int STATE_HEADER = 0;
    public static final int STATE_CONTENT = 2;
    public static final int STATE_FLUSHING = 3;
    public static final int STATE_END = 4;
    public static final boolean LAST = true;
    public static final boolean MORE = false;
    private static byte[] LAST_CHUNK = new byte[]{48, 13, 10, 13, 10};
    private static byte[] CONTENT_LENGTH_0 = Portable.getBytes("Content-Length: 0\r\n");
    private static byte[] CONNECTION_KEEP_ALIVE = Portable.getBytes("Connection: keep-alive\r\n");
    private static byte[] CONNECTION_CLOSE = Portable.getBytes("Connection: close\r\n");
    private static byte[] TRANSFER_ENCODING_CHUNKED = Portable.getBytes("Transfer-Encoding: chunked\r\n");
    private static byte[] SERVER = Portable.getBytes("Server: Java Card 3.0\r\n");
    private static int CHUNK_SPACE = 12;
    private static Hashtable<Integer, String> REASONS = new Hashtable(45);
    private int state = 0;
    private int version = 11;
    private int status = 200;
    private String reason;
    private long contentWritten = 0L;
    private long contentLength = -3L;
    private boolean last = false;
    private boolean head = false;
    private boolean noContent = false;
    private boolean close = false;
    private Buffers buffers;
    EndPoint endp;
    private Buffer header;
    Buffer buffer;
    Buffer content;
    private boolean bypass = false;
    private boolean needCRLF = false;
    private boolean needEOC = false;
    private boolean bufferChunked = false;
    private int headerBufferSize;
    private int contentBufferSize;
    private final HttpConnection httpConnection;

    public static String getReason(int code) {
        String reason = REASONS.get(code);
        if (reason == null) {
            reason = Integer.toString(code);
        }
        return reason;
    }

    public HttpGenerator(HttpConnection httpConnection, Buffers buffers, EndPoint io, int headerBufferSize, int contentBufferSize) {
        this.httpConnection = httpConnection;
        this.buffers = buffers;
        this.endp = io;
        this.headerBufferSize = headerBufferSize;
        this.contentBufferSize = contentBufferSize;
    }

    public void reset(boolean returnBuffers) {
        this.state = 0;
        this.version = 11;
        this.status = 200;
        this.last = false;
        this.head = false;
        this.noContent = false;
        this.close = false;
        this.contentWritten = 0L;
        this.contentLength = -3L;
        if (returnBuffers) {
            if (this.header != null) {
                this.buffers.returnBuffer(this.header);
            }
            this.header = null;
            if (this.buffer != null) {
                this.buffers.returnBuffer(this.buffer);
            }
            this.buffer = null;
        } else {
            if (this.header != null) {
                this.header.clear();
            }
            if (this.buffer != null) {
                this.buffers.returnBuffer(this.buffer);
                this.buffer = null;
            }
        }
        this.content = null;
        this.bypass = false;
        this.needCRLF = false;
        this.needEOC = false;
    }

    public void resetBuffer() {
        if (this.state >= 3) {
            throw new IllegalStateException("Flushed");
        }
        this.last = false;
        this.close = false;
        this.contentWritten = 0L;
        this.contentLength = -3L;
        this.bypass = false;
        this.content = null;
        if (this.buffer != null) {
            this.buffer.clear();
        }
    }

    public Buffer getUncheckedBuffer() {
        return this.buffer;
    }

    public int getState() {
        return this.state;
    }

    public boolean isState(int state) {
        return this.state == state;
    }

    public boolean isComplete() {
        return this.state == 4;
    }

    public boolean isCommitted() {
        return this.state != 0;
    }

    public boolean isHead() {
        return this.head;
    }

    public void setHead(boolean head) {
        this.head = head;
    }

    public boolean isPersistent() {
        return !this.close;
    }

    public void setVersion(int version) {
        if (this.state != 0) {
            throw new IllegalStateException("STATE!=START");
        }
        this.version = version;
    }

    public void setRequest(Buffer method, Buffer uri) {
        Portable.throwNotSupported();
    }

    public void setResponse(int status, String reason) {
        if (this.state != 0) {
            throw new IllegalStateException("STATE!=START");
        }
        this.status = status;
        this.reason = reason == null ? reason : UrlEncoded.encodeString(reason);
    }

    public void addContent(Buffer content, boolean last) throws IOException {
        if (this.noContent) {
            content.clear();
            return;
        }
        if (content.isImmutable()) {
            throw new IllegalArgumentException("immutable");
        }
        if (this.last || this.state == 4) {
            Logger.debug("Ignoring extra content {}" + content);
            content.clear();
            return;
        }
        if (this.content != null && this.content.length() > 0 || this.bufferChunked) {
            this.flushBuffers();
            if (this.content != null && this.content.length() > 0 || this.bufferChunked) {
                throw new IllegalStateException("FULL");
            }
        }
        this.last = last;
        this.content = content;
        this.contentWritten += (long)content.length();
        if (this.head) {
            content.clear();
            this.content = null;
        } else if (this.endp != null && this.buffer == null && content.length() > 0 && this.last) {
            this.bypass = true;
        } else {
            if (this.buffer == null) {
                this.buffer = this.buffers.getBuffer(this.contentBufferSize);
            }
            int len = this.buffer.put(this.content);
            this.content.skip(len);
            if (this.content.length() == 0) {
                this.content = null;
            }
        }
        long presetLength = this.httpConnection.getResponseFields().getLongField("Content-Length");
        if (presetLength != -1L) {
            Logger.debug("addContent()" + presetLength + "  " + this.contentWritten);
            if (this.contentWritten >= presetLength) {
                this.bypass = true;
            }
        }
    }

    public boolean addContent(byte b) throws IOException {
        if (this.noContent) {
            return false;
        }
        if (this.last || this.state == 4) {
            throw new IllegalStateException("Closed");
        }
        if (this.content != null && this.content.length() > 0 || this.bufferChunked) {
            this.flushBuffers();
            if (this.content != null && this.content.length() > 0 || this.bufferChunked) {
                throw new IllegalStateException("FULL");
            }
        }
        ++this.contentWritten;
        if (this.head) {
            return false;
        }
        if (this.buffer == null) {
            this.buffer = this.buffers.getBuffer(this.contentBufferSize);
        }
        this.buffer.put(b);
        long presetLength = this.httpConnection.getResponseFields().getLongField("Content-Length");
        if (presetLength != -1L) {
            Logger.debug("addContent()" + presetLength + "  " + this.contentWritten);
            if (this.contentWritten >= presetLength) {
                this.bypass = true;
            }
        }
        return this.buffer.space() <= (this.contentLength == -2L ? CHUNK_SPACE : 0);
    }

    int prepareUncheckedAddContent() throws IOException {
        if (this.noContent) {
            return -1;
        }
        if (this.last || this.state == 4) {
            throw new IllegalStateException("Closed");
        }
        Buffer content = this.content;
        if (content != null && content.length() > 0 || this.bufferChunked) {
            this.flushBuffers();
            if (content != null && content.length() > 0 || this.bufferChunked) {
                throw new IllegalStateException("FULL");
            }
        }
        if (this.buffer == null) {
            this.buffer = this.buffers.getBuffer(this.contentBufferSize);
        }
        this.contentWritten -= (long)this.buffer.length();
        if (this.head) {
            return Integer.MAX_VALUE;
        }
        return this.buffer.space() - (this.contentLength == -2L ? CHUNK_SPACE : 0);
    }

    void uncheckedAddContent(int b) {
        this.buffer.put((byte)b);
    }

    void completeUncheckedAddContent() {
        if (this.noContent) {
            if (this.buffer != null) {
                this.buffer.clear();
            }
            return;
        }
        this.contentWritten += (long)this.buffer.length();
        if (this.head) {
            this.buffer.clear();
        }
    }

    public boolean isBufferFull() {
        boolean full = this.state == 3 || this.bypass || this.buffer != null && this.buffer.space() == 0 || this.contentLength == -2L && this.buffer != null && this.buffer.space() < CHUNK_SPACE;
        return full;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void completeHeader(HttpFields fields, boolean allContentAdded) {
        if (this.state != 0) {
            return;
        }
        if (this.last && !allContentAdded) {
            throw new IllegalStateException("last?");
        }
        this.last |= allContentAdded;
        if (this.version == 9) {
            this.close = true;
            this.contentLength = -1L;
        } else {
            Buffer line;
            boolean has_server = false;
            if (this.version == 10) {
                this.close = true;
            }
            if (this.header == null) {
                this.header = this.buffers.getBuffer(this.headerBufferSize);
            }
            if ((line = HttpStatus.getResponseLine(this.status)) != null && this.reason == null) {
                this.header.put(line);
            } else {
                byte[] r;
                if (this.reason != null) {
                    if (this.reason.length() > this.header.capacity() / 2) {
                        this.reason = this.reason.substring(0, this.header.capacity() / 2);
                    }
                } else {
                    this.reason = HttpGenerator.getReason(this.status);
                }
                if (line == null) {
                    this.header.put(HttpVersions.HTTP_1_1_BUFFER);
                    this.header.put((byte)32);
                    this.header.put((byte)(48 + this.status / 100));
                    this.header.put((byte)(48 + this.status % 100 / 10));
                    this.header.put((byte)(48 + this.status % 10));
                    this.header.put((byte)32);
                    r = Portable.getBytes(this.reason == null ? "Unknown" : this.reason);
                    this.header.put(r, 0, r.length);
                    this.header.put(HttpTokens.CRLF);
                } else if (this.reason != null) {
                    this.header.put(line.array(), 0, HttpVersions.HTTP_1_1_BUFFER.length() + 5);
                    r = Portable.getBytes(this.reason);
                    this.header.put(r, 0, r.length);
                    this.header.put(HttpTokens.CRLF);
                } else {
                    this.reason = HttpGenerator.getReason(this.status);
                }
            }
            if (this.status == 100 || this.status == 204 || this.status == 304) {
                this.noContent = true;
                this.content = null;
                if (this.buffer != null) {
                    this.buffer.clear();
                }
            }
            HttpFields.Field content_length = null;
            HttpFields.Field transfer_encoding = null;
            HttpFields.Field connection = null;
            boolean keep_alive = false;
            if (fields != null) {
                Iterator<HttpFields.Field> iter = fields.getFields();
                block13: while (iter.hasNext()) {
                    HttpFields.Field field = iter.next();
                    switch (field.getNameOrdinal()) {
                        case 12: {
                            content_length = field;
                            this.contentLength = field.getLongValue();
                            if (this.contentLength < this.contentWritten || this.last && this.contentLength != this.contentWritten) {
                                content_length = null;
                            }
                            field.put(this.header);
                            continue block13;
                        }
                        case 16: {
                            if (BufferUtil.isPrefix(MimeTypes.MULTIPART_BYTERANGES_BUFFER, field.getValueBuffer())) {
                                this.contentLength = -4L;
                            }
                            field.put(this.header);
                            continue block13;
                        }
                        case 5: {
                            if (this.version != 11) continue block13;
                            transfer_encoding = field;
                            continue block13;
                        }
                        case 1: {
                            connection = field;
                            int connection_value = field.getValueOrdinal();
                            this.close = HttpHeaderValues.CLOSE_ORDINAL == connection_value;
                            boolean bl = keep_alive = HttpHeaderValues.KEEP_ALIVE_ORDINAL == connection_value;
                            if (keep_alive && this.version == 10) {
                                this.close = false;
                            }
                            if (!this.close || this.contentLength != -3L) continue block13;
                            this.contentLength = -1L;
                            continue block13;
                        }
                        case 48: {
                            has_server = true;
                            field.put(this.header);
                            continue block13;
                        }
                    }
                    field.put(this.header);
                }
            }
            switch ((int)this.contentLength) {
                case -3: {
                    if (this.contentWritten == 0L && (this.status < 200 || this.status == 204 || this.status == 304)) {
                        this.contentLength = 0L;
                        break;
                    }
                    if (this.last) {
                        this.contentLength = this.contentWritten;
                        if (content_length != null) break;
                        this.header.put(HttpHeaders.CONTENT_LENGTH_BUFFER);
                        this.header.put((byte)58);
                        this.header.put((byte)32);
                        BufferUtil.putDecLong(this.header, this.contentLength);
                        this.header.put(HttpTokens.CRLF);
                        break;
                    }
                    this.contentLength = this.close || this.version < 11 ? -1L : -2L;
                    break;
                }
                case 0: {
                    if (content_length != null || this.status < 200 || this.status == 204 || this.status == 304) break;
                    this.header.put(CONTENT_LENGTH_0);
                    break;
                }
                case -1: {
                    this.close = true;
                    break;
                }
                case -2: {
                    break;
                }
            }
            if (this.contentLength == -2L) {
                if (transfer_encoding != null && HttpHeaderValues.CHUNKED_ORDINAL != transfer_encoding.getValueOrdinal()) {
                    String c = transfer_encoding.getValue();
                    if (!c.endsWith("chunked")) throw new IllegalArgumentException("BAD TE");
                    transfer_encoding.put(this.header);
                } else {
                    this.header.put(TRANSFER_ENCODING_CHUNKED);
                }
            }
            if (this.close || this.contentLength == -1L) {
                if (this.version > 10 || connection != null) {
                    this.header.put(CONNECTION_CLOSE);
                }
                this.close = true;
            } else if (keep_alive && this.version == 10) {
                this.header.put(CONNECTION_KEEP_ALIVE);
            } else if (connection != null) {
                connection.put(this.header);
            }
            if (!has_server && this.status > 100) {
                this.header.put(SERVER);
            }
            this.header.put(HttpTokens.CRLF);
        }
        this.state = 2;
    }

    public void complete() throws IOException {
        if (this.state == 4) {
            return;
        }
        if (this.state == 0) {
            throw new IllegalStateException("State==HEADER");
        }
        if (this.contentLength >= 0L && this.contentLength != this.contentWritten && !this.head) {
            if (this.endp.isOpen()) {
                Logger.debug("ContentLength written==" + this.contentWritten + " != contentLength==" + this.contentLength);
            }
            this.close = true;
        }
        if (this.state != 3) {
            this.state = 3;
            if (this.contentLength == -2L) {
                this.needEOC = true;
            }
        }
        this.flushBuffers();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long flushBuffers() throws IOException {
        try {
            if (this.state == 0) {
                throw new IllegalStateException("State==HEADER");
            }
            this.prepareBuffers();
            if (this.endp == null) {
                if (this.needCRLF && this.buffer != null) {
                    this.buffer.put(HttpTokens.CRLF);
                }
                if (!this.needEOC) return 0L;
                if (this.buffer == null) return 0L;
                this.buffer.put(LAST_CHUNK);
                return 0L;
            }
            int total = 0;
            long last_len = -1L;
            while (true) {
                int len = -1;
                int to_flush = (this.header != null && this.header.length() > 0 ? 4 : 0) | (this.buffer != null && this.buffer.length() > 0 ? 2 : 0) | (this.bypass && this.content != null && this.content.length() > 0 ? 1 : 0);
                switch (to_flush) {
                    case 7: {
                        throw new IllegalStateException();
                    }
                    case 6: {
                        len = this.endp.flush(this.header, this.buffer, null);
                        break;
                    }
                    case 5: {
                        len = this.endp.flush(this.header, this.content, null);
                        break;
                    }
                    case 4: {
                        len = this.endp.flush(this.header);
                        break;
                    }
                    case 3: {
                        throw new IllegalStateException();
                    }
                    case 2: {
                        len = this.endp.flush(this.buffer);
                        break;
                    }
                    case 1: {
                        len = this.endp.flush(this.content);
                        break;
                    }
                    case 0: {
                        if (this.header != null) {
                            this.header.clear();
                        }
                        this.bypass = false;
                        this.bufferChunked = false;
                        if (this.buffer != null) {
                            this.buffer.clear();
                            if (this.contentLength == -2L) {
                                this.buffer.setPutIndex(CHUNK_SPACE);
                                this.buffer.setGetIndex(CHUNK_SPACE);
                                if (this.content != null && this.content.length() < this.buffer.space() && this.state != 3) {
                                    this.buffer.put(this.content);
                                    this.content.clear();
                                    this.content = null;
                                    return total;
                                }
                            }
                        }
                        if (!(this.needCRLF || this.needEOC || this.content != null && this.content.length() != 0)) {
                            if (this.state == 3) {
                                this.state = 4;
                            }
                            if (this.state != 4) return total;
                            if (!this.close) return total;
                            this.endp.close();
                            return total;
                        }
                        this.prepareBuffers();
                    }
                }
                if (len <= 0) {
                    if (last_len > 0L) return total;
                    return total;
                }
                last_len = len;
                total += len;
            }
        }
        catch (IOException e) {
            IOException iOException;
            Logger.debug(e);
            if (e instanceof EofException) {
                iOException = e;
                throw iOException;
            }
            iOException = new EofException(e);
            throw iOException;
        }
    }

    private void prepareBuffers() {
        if (!this.bufferChunked) {
            if (this.content != null && this.content.length() > 0 && this.buffer != null && this.buffer.space() > 0) {
                int len = this.buffer.put(this.content);
                this.content.skip(len);
                if (this.content.length() == 0) {
                    this.content = null;
                }
            }
            if (this.contentLength == -2L) {
                int size;
                int n = size = this.buffer == null ? 0 : this.buffer.length();
                if (size > 0) {
                    this.bufferChunked = true;
                    if (this.buffer.getReadIndex() == CHUNK_SPACE) {
                        this.buffer.poke(this.buffer.getReadIndex() - 2, HttpTokens.CRLF, 0, 2);
                        this.buffer.setGetIndex(this.buffer.getReadIndex() - 2);
                        BufferUtil.prependHexInt(this.buffer, size);
                        if (this.needCRLF) {
                            this.buffer.poke(this.buffer.getReadIndex() - 2, HttpTokens.CRLF, 0, 2);
                            this.buffer.setGetIndex(this.buffer.getReadIndex() - 2);
                            this.needCRLF = false;
                        }
                    } else {
                        if (this.needCRLF) {
                            if (this.header.length() > 0) {
                                throw new IllegalStateException("EOC");
                            }
                            this.header.put(HttpTokens.CRLF);
                            this.needCRLF = false;
                        }
                        BufferUtil.putHexInt(this.header, size);
                        this.header.put(HttpTokens.CRLF);
                    }
                    if (this.buffer.space() >= 2) {
                        this.buffer.put(HttpTokens.CRLF);
                    } else {
                        this.needCRLF = true;
                    }
                }
                if (this.needEOC && (this.content == null || this.content.length() == 0)) {
                    if (this.needCRLF) {
                        if (this.buffer == null && this.header.space() >= 2) {
                            this.header.put(HttpTokens.CRLF);
                            this.needCRLF = false;
                        } else if (this.buffer.space() >= 2) {
                            this.buffer.put(HttpTokens.CRLF);
                            this.needCRLF = false;
                        }
                    }
                    if (!this.needCRLF && this.needEOC) {
                        if (this.buffer == null && this.header.space() >= LAST_CHUNK.length) {
                            this.header.put(LAST_CHUNK);
                            this.bufferChunked = true;
                            this.needEOC = false;
                        } else if (this.buffer.space() >= LAST_CHUNK.length) {
                            this.buffer.put(LAST_CHUNK);
                            this.bufferChunked = true;
                            this.needEOC = false;
                        }
                    }
                }
            }
        }
        if (this.content != null && this.content.length() == 0) {
            this.content = null;
        }
    }

    public void sendError(int code, String reason, String content, boolean close) throws IOException {
        if (!this.isCommitted()) {
            this.setResponse(code, reason);
            this.close = close;
            this.completeHeader(null, false);
            if (content != null) {
                this.addContent(new View(new ByteArrayBuffer(content)), true);
            }
            this.complete();
        }
    }

    public int getContentBufferSize() {
        return this.contentBufferSize;
    }

    public void increaseContentBufferSize(int contentBufferSize) {
        if (this.buffer != null && (this.buffer.length() != 0 || this.isCommitted() || this.isComplete())) {
            throw new IllegalStateException("Can not set buffer size after response is written");
        }
        if (contentBufferSize > this.contentBufferSize) {
            this.contentBufferSize = contentBufferSize;
            if (this.buffer != null) {
                Buffer nb = this.buffers.getBuffer(this.contentBufferSize);
                nb.put(this.buffer);
                this.buffers.returnBuffer(this.buffer);
                this.buffer = nb;
            }
        }
    }

    public long getContentWritten() {
        return this.contentWritten;
    }

    static {
        REASONS.put(new Integer(100), "CONTINUE");
        REASONS.put(new Integer(101), "SWITCHING_PROTOCOLS");
        REASONS.put(new Integer(200), "OK");
        REASONS.put(new Integer(201), "CREATED");
        REASONS.put(new Integer(202), "ACCEPTED");
        REASONS.put(new Integer(203), "NON_AUTHORITATIVE_INFORMATION");
        REASONS.put(new Integer(204), "NO_CONTENT");
        REASONS.put(new Integer(205), "RESET_CONTENT");
        REASONS.put(new Integer(206), "PARTIAL_CONTENT");
        REASONS.put(new Integer(300), "MULTIPLE_CHOICES");
        REASONS.put(new Integer(301), "MOVED_PERMANENTLY");
        REASONS.put(new Integer(302), "MOVED_TEMPORARILY");
        REASONS.put(new Integer(302), "FOUND");
        REASONS.put(new Integer(303), "SEE_OTHER");
        REASONS.put(new Integer(304), "NOT_MODIFIED");
        REASONS.put(new Integer(305), "USE_PROXY");
        REASONS.put(new Integer(307), "TEMPORARY_REDIRECT");
        REASONS.put(new Integer(400), "BAD_REQUEST");
        REASONS.put(new Integer(401), "UNAUTHORIZED");
        REASONS.put(new Integer(402), "PAYMENT_REQUIRED");
        REASONS.put(new Integer(403), "FORBIDDEN");
        REASONS.put(new Integer(404), "NOT_FOUND");
        REASONS.put(new Integer(405), "METHOD_NOT_ALLOWED");
        REASONS.put(new Integer(406), "NOT_ACCEPTABLE");
        REASONS.put(new Integer(407), "PROXY_AUTHENTICATION_REQUIRED");
        REASONS.put(new Integer(408), "REQUEST_TIMEOUT");
        REASONS.put(new Integer(409), "CONFLICT");
        REASONS.put(new Integer(410), "GONE");
        REASONS.put(new Integer(411), "LENGTH_REQUIRED");
        REASONS.put(new Integer(412), "PRECONDITION_FAILED");
        REASONS.put(new Integer(413), "REQUEST_ENTITY_TOO_LARGE");
        REASONS.put(new Integer(414), "REQUEST_URI_TOO_LONG");
        REASONS.put(new Integer(415), "UNSUPPORTED_MEDIA_TYPE");
        REASONS.put(new Integer(416), "REQUESTED_RANGE_NOT_SATISFIABLE");
        REASONS.put(new Integer(417), "EXPECTATION_FAILED");
        REASONS.put(new Integer(500), "INTERNAL_SERVER_ERROR");
        REASONS.put(new Integer(501), "NOT_IMPLEMENTED");
        REASONS.put(new Integer(502), "BAD_GATEWAY");
        REASONS.put(new Integer(503), "SERVICE_UNAVAILABLE");
        REASONS.put(new Integer(504), "GATEWAY_TIMEOUT");
        REASONS.put(new Integer(505), "HTTP_VERSION_NOT_SUPPORTED");
        NativeMethods.setJCREentry(REASONS, false);
    }

    public static class OutputWriter
    extends Writer {
        Output output;
        HttpGenerator generator;
        EndPoint endpoint;
        int maxChar;
        String characterEncoding;
        Writer converter;
        ByteArrayOutputStream2 bos2;
        char[] chars;
        private int space;
        int surrogate;
        int writeChunk = 256;

        public OutputWriter(Output out) {
            this.output = out;
            this.generator = this.output.generator;
            this.endpoint = this.generator.endp;
        }

        public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
            if (encoding != null) {
                new String(new byte[0], encoding);
            }
            if (this.characterEncoding == null || !this.characterEncoding.equalsIgnoreCase(encoding)) {
                this.converter = null;
            }
            this.characterEncoding = encoding;
            this.maxChar = this.characterEncoding == null ? 256 : (StringUtil.ISO_8859_1.equalsIgnoreCase(this.characterEncoding) ? 256 : ("UTF-8".equalsIgnoreCase(this.characterEncoding) ? 128 : 0));
        }

        @Override
        public void close() throws IOException {
            this.output.close();
        }

        @Override
        public void flush() throws IOException {
            this.output.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(String s, int offset, int length) throws IOException {
            if (this.maxChar == 128) {
                this.writeUtf8(s, offset, length);
                return;
            }
            if (this.bos2 == null) {
                this.bos2 = new ByteArrayOutputStream2(this.writeChunk * 2);
            }
            if (this.converter == null) {
                Writer writer = this.converter = this.characterEncoding == null ? new OutputStreamWriter(this.bos2) : new OutputStreamWriter(this.bos2, this.characterEncoding);
            }
            if (length > 16) {
                if (this.chars == null) {
                    this.chars = new char[this.writeChunk];
                }
                int end = offset + length;
                int i = offset;
                while (i < end) {
                    int chunk = this.writeChunk;
                    int next = i + chunk;
                    if (next > end) {
                        next = end;
                        chunk = next - i;
                    }
                    new String(s).getChars(i, next, this.chars, 0);
                    i += chunk;
                    int n = 0;
                    while (n < chunk) {
                        char c = this.chars[n];
                        if (c < this.maxChar) {
                            this.bos2.writeUnchecked(c);
                            ++n;
                            continue;
                        }
                        int i0 = n++;
                        if ((n += (this.writeChunk + 5) / 6) > chunk) {
                            n = chunk;
                        }
                        this.converter.write(this.chars, i0, n - i0);
                        this.converter.flush();
                    }
                    this.output.write(this.bos2.getBuf(), 0, this.bos2.getCount());
                    this.bos2.reset();
                }
            } else {
                ByteArrayOutputStream2 byteArrayOutputStream2 = this.bos2;
                synchronized (byteArrayOutputStream2) {
                    int end = offset + length;
                    int i = offset;
                    while (i < end) {
                        int next = i + this.writeChunk;
                        if (next > end) {
                            next = end;
                        }
                        while (i < next) {
                            char c = s.charAt(i);
                            if (c < this.maxChar) {
                                this.bos2.writeUnchecked(c);
                                ++i;
                                continue;
                            }
                            int i0 = i;
                            if ((i += this.writeChunk / 2) > next) {
                                i = next;
                            }
                            this.converter.write(s, i0, i - i0);
                            this.converter.flush();
                        }
                        this.output.write(this.bos2.getBuf(), 0, this.bos2.getCount());
                        this.bos2.reset();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(char[] s, int offset, int length) throws IOException {
            if (this.maxChar == 128) {
                this.writeUtf8(s, offset, length);
            } else {
                if (this.bos2 == null) {
                    this.bos2 = new ByteArrayOutputStream2(this.writeChunk * 2);
                }
                ByteArrayOutputStream2 byteArrayOutputStream2 = this.bos2;
                synchronized (byteArrayOutputStream2) {
                    int end = offset + length;
                    int i = offset;
                    while (i < end) {
                        int next = i + this.writeChunk;
                        if (next > end) {
                            next = end;
                        }
                        while (i < next) {
                            char c = s[i];
                            if (c < this.maxChar) {
                                ++i;
                                this.bos2.writeUnchecked(c);
                                continue;
                            }
                            if (this.converter == null) {
                                this.converter = new OutputStreamWriter(this.bos2, this.characterEncoding);
                            }
                            int i0 = i;
                            if ((i += this.writeChunk / 2) > next) {
                                i = next;
                            }
                            this.converter.write(s, i0, i - i0);
                            this.converter.flush();
                        }
                        byte[] b = this.bos2.getBuf();
                        this.output.write(b, 0, this.bos2.getCount());
                        this.bos2.reset();
                    }
                }
            }
        }

        public void writeUtf8(char[] s, int offset, int length) throws IOException {
            if (this.output.closed) {
                throw new IOException("Closed");
            }
            this.space = this.generator.prepareUncheckedAddContent();
            if (this.space < 0) {
                return;
            }
            int end = offset + length;
            for (int i = offset; i < end; ++i) {
                char c;
                if (this.space < 6 && this.endpoint.isOpen()) {
                    this.generator.completeUncheckedAddContent();
                    this.output.flush();
                    this.space = this.generator.prepareUncheckedAddContent();
                }
                if ((c = s[i]) < '\ud800' || c > '\udfff') {
                    this.writeUtf8(c);
                    continue;
                }
                if (c < '\udc00') {
                    this.surrogate = c - 55296 << 10;
                    continue;
                }
                this.writeUtf8(this.surrogate + c - 56320);
            }
            this.generator.completeUncheckedAddContent();
            if (this.space == 0 && this.endpoint.isOpen()) {
                this.output.flush();
            }
        }

        public void writeUtf8(String s, int offset, int length) throws IOException {
            if (this.output.closed) {
                throw new IOException("Closed");
            }
            this.space = this.generator.prepareUncheckedAddContent();
            if (this.space < 0) {
                return;
            }
            int end = offset + length;
            for (int i = offset; i < end; ++i) {
                char c;
                if (this.space < 6 && this.endpoint.isOpen()) {
                    this.generator.completeUncheckedAddContent();
                    this.output.flush();
                    this.space = this.generator.prepareUncheckedAddContent();
                }
                if ((c = s.charAt(i)) < '\ud800' || c > '\udfff') {
                    this.writeUtf8(c);
                    continue;
                }
                if (c < '\udc00') {
                    this.surrogate = c - 55296 << 10;
                    continue;
                }
                this.writeUtf8(this.surrogate + c - 56320);
            }
            this.generator.completeUncheckedAddContent();
            if (this.space == 0 && this.endpoint.isOpen()) {
                this.output.flush();
            }
        }

        private void writeUtf8(int code) {
            if ((code & 0xFFFFFF80) == 0) {
                this.generator.uncheckedAddContent(code);
                --this.space;
            } else if ((code & 0xFFFFF800) == 0) {
                this.generator.uncheckedAddContent(0xC0 | code >> 6);
                this.generator.uncheckedAddContent(0x80 | code & 0x3F);
                this.space -= 2;
            } else if ((code & 0xFFFF0000) == 0) {
                this.generator.uncheckedAddContent(0xE0 | code >> 12);
                this.generator.uncheckedAddContent(0x80 | code >> 6 & 0x3F);
                this.generator.uncheckedAddContent(0x80 | code & 0x3F);
                this.space -= 3;
            } else if ((code & 0xFF200000) == 0) {
                this.generator.uncheckedAddContent(0xF0 | code >> 18);
                this.generator.uncheckedAddContent(0x80 | code >> 12 & 0x3F);
                this.generator.uncheckedAddContent(0x80 | code >> 6 & 0x3F);
                this.generator.uncheckedAddContent(0x80 | code & 0x3F);
                this.space -= 4;
            } else if ((code & 0xF4000000) == 0) {
                this.generator.uncheckedAddContent(0xF8 | code >> 24);
                this.generator.uncheckedAddContent(0x80 | code >> 18 & 0x3F);
                this.generator.uncheckedAddContent(0x80 | code >> 12 & 0x3F);
                this.generator.uncheckedAddContent(0x80 | code >> 6 & 0x3F);
                this.generator.uncheckedAddContent(0x80 | code & 0x3F);
                this.space -= 5;
            } else if ((code & Integer.MIN_VALUE) == 0) {
                this.generator.uncheckedAddContent(0xFC | code >> 30);
                this.generator.uncheckedAddContent(0x80 | code >> 24 & 0x3F);
                this.generator.uncheckedAddContent(0x80 | code >> 18 & 0x3F);
                this.generator.uncheckedAddContent(0x80 | code >> 12 & 0x3F);
                this.generator.uncheckedAddContent(0x80 | code >> 6 & 0x3F);
                this.generator.uncheckedAddContent(0x80 | code & 0x3F);
                this.space -= 6;
            } else {
                this.generator.uncheckedAddContent(63);
            }
        }
    }

    public static class Output
    extends ServletOutputStream {
        protected HttpGenerator generator;
        protected long maxIdleTime;
        protected ByteArrayBuffer buf1 = null;
        protected ByteArrayBuffer bufn = null;
        protected boolean closed;

        public Output(HttpGenerator generator, long maxIdleTime) {
            this.generator = generator;
            this.maxIdleTime = maxIdleTime;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        void reopen() {
            this.closed = false;
        }

        @Override
        public void flush() throws IOException {
            Buffer content = this.generator.content;
            Buffer buffer = this.generator.buffer;
            if (content != null && content.length() > 0 || buffer != null && buffer.length() > 0) {
                this.generator.flushBuffers();
                while (content != null && content.length() > 0 || buffer != null && buffer.length() > 0) {
                    if (!this.generator.endp.isBlocking()) {
                        this.generator.endp.blockWritable(this.maxIdleTime);
                    }
                    this.generator.flushBuffers();
                }
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.bufn == null) {
                this.bufn = new ByteArrayBuffer(b, off, len);
            } else {
                this.bufn.wrap(b, off, len);
            }
            this.write(this.bufn);
            this.bufn.wrap(null, 0, 0);
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (this.bufn == null) {
                this.bufn = new ByteArrayBuffer(b);
            } else {
                this.bufn.wrap(b);
            }
            this.write(this.bufn);
            this.bufn.wrap(null, 0, 0);
        }

        @Override
        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException("Closed");
            }
            while (this.generator.isBufferFull() && this.generator.endp.isOpen()) {
                if (!this.generator.endp.isBlocking()) {
                    this.generator.endp.blockWritable(this.maxIdleTime);
                }
                this.flush();
            }
            if (this.generator.addContent((byte)b)) {
                this.flush();
            }
        }

        private void write(Buffer buffer) throws IOException {
            if (this.closed) {
                throw new IOException("Closed");
            }
            while (this.generator.isBufferFull() && this.generator.endp.isOpen()) {
                if (!this.generator.endp.isBlocking()) {
                    this.generator.endp.blockWritable(this.maxIdleTime);
                }
                this.flush();
            }
            this.generator.addContent(buffer, false);
            if (this.generator.isBufferFull()) {
                this.flush();
            }
            while (buffer.length() > 0 && this.generator.endp.isOpen()) {
                if (!this.generator.endp.isBlocking()) {
                    this.generator.endp.blockWritable(this.maxIdleTime);
                }
                this.flush();
            }
        }

        @Override
        public void print(String s) throws IOException {
            this.write(s.getBytes());
        }
    }
}

