/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import com.sun.javacard.ClassLoader;
import com.sun.javacard.ContextManager;
import com.sun.javacard.Logger;
import com.sun.javacard.file.FileConnection;
import com.sun.javacard.impl.NativeMethods;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.WebServer;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.handler.HandlerWrapper;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.resource.Resource;
import org.mortbay.util.Attributes;
import org.mortbay.util.AttributesMap;
import org.mortbay.util.EmptyLists;
import org.mortbay.util.LazyList;
import org.mortbay.util.Loader;
import org.mortbay.util.URIUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class ContextHandler
extends HandlerWrapper
implements Attributes {
    private Attributes attributes;
    Attributes contextAttributes;
    private ClassLoader classLoader;
    Context context = new Context();
    String contextPath;
    private Hashtable<String, String> initParams;
    private String displayName;
    String docRoot;
    private Resource baseResource;
    MimeTypes mimeTypes;
    private Hashtable<String, String> localeEncodingMap;
    private LazyList<String> welcomeFiles;
    private ErrorHandler errorHandler;
    private String[] vhosts;
    private Vector<String> connectors;
    private LazyList<EventListener> eventListeners;
    private boolean shutdown;
    private boolean unavailable = false;
    private LazyList<ServletContextListener> contextListeners;
    LazyList<ServletContextAttributeListener> contextAttributeListeners;
    private LazyList<ServletRequestListener> requestListeners;
    private LazyList<ServletRequestAttributeListener> requestAttributeListeners;

    protected Context getContext() {
        return this.context;
    }

    public ContextHandler() {
        this.attributes = new AttributesMap();
        this.initParams = new Hashtable();
    }

    public ContextHandler(HandlerContainer parent, String contextPath) {
        this();
        this.setContextPath(contextPath);
        parent.addHandler(this);
    }

    public void setVirtualHosts(String[] vhosts) {
        this.vhosts = vhosts;
    }

    public Context getContainedContext() {
        return this.context;
    }

    public String[] getVirtualHosts() {
        return this.vhosts;
    }

    public String[] getConnectorNames() {
        if (this.connectors == null || this.connectors.size() == 0) {
            return null;
        }
        Object[] array = new String[this.connectors.size()];
        this.connectors.copyInto(array);
        return array;
    }

    public void setConnectorNames(String[] connectors) {
        if (connectors == null || connectors.length == 0) {
            this.connectors = null;
        } else {
            this.connectors = new Vector();
            for (String str : connectors) {
                this.connectors.addElement(str);
            }
        }
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return this.attributes.getAttributeNames();
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getInitParameter(String name) {
        return this.initParams.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.initParams.keys();
    }

    public Hashtable<String, String> getInitParams() {
        return this.initParams;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LazyList<EventListener> getEventListeners() {
        return this.eventListeners;
    }

    public void setEventListeners(LazyList<EventListener> eventListeners) {
        this.contextListeners = null;
        this.contextAttributeListeners = null;
        this.requestListeners = null;
        this.requestAttributeListeners = null;
        this.eventListeners = eventListeners;
        if (eventListeners != null) {
            for (EventListener listener : eventListeners) {
                if (listener instanceof ServletContextListener) {
                    this.contextListeners = LazyList.add(this.contextListeners, (ServletContextListener)listener);
                }
                if (listener instanceof ServletContextAttributeListener) {
                    this.contextAttributeListeners = LazyList.add(this.contextAttributeListeners, (ServletContextAttributeListener)listener);
                }
                if (listener instanceof ServletRequestListener) {
                    this.requestListeners = LazyList.add(this.requestListeners, (ServletRequestListener)listener);
                }
                if (!(listener instanceof ServletRequestAttributeListener)) continue;
                this.requestAttributeListeners = LazyList.add(this.requestAttributeListeners, (ServletRequestAttributeListener)listener);
            }
        }
    }

    public void addEventListener(EventListener listener) {
        this.setEventListeners(LazyList.add(this.getEventListeners(), listener));
    }

    public boolean isUnavailable() {
        return this.unavailable;
    }

    public void setUnavailable(boolean unavailable) {
        this.unavailable = unavailable;
    }

    public boolean isShutdown() {
        return !this.shutdown;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() throws Exception {
        Logger.debug("org.mortbay.jetty.handler.ContextHandler.doStart() -> ");
        this.contextAttributes = new AttributesMap();
        try {
            ContextManager.saveState();
            if (this.classLoader != null) {
                ClassLoader.setCurrentClassLoader(this.classLoader);
            }
            if (this.mimeTypes == null) {
                this.mimeTypes = new MimeTypes();
            }
            ContextManager.setCurrentContext(this.context);
            if (this.errorHandler == null) {
                this.errorHandler = new ErrorHandler();
            }
            Logger.debug("org.mortbay.jetty.handler.ContextHandler.doStart() -> About to Start the context ");
            this.startContext();
            Logger.debug("org.mortbay.jetty.handler.ContextHandler.doStart() -> Context started SUCCESS");
        }
        finally {
            ContextManager.restoreState();
        }
    }

    protected void startContext() throws Exception {
        Logger.debug("org.mortbay.jetty.handler.ContextHandler.startContext() -> begin");
        super.doStart();
        Logger.debug("org.mortbay.jetty.handler.ContextHandler.startContext() -> after doStart");
        if (this.contextListeners != null) {
            ServletContextEvent event = new ServletContextEvent(this.context);
            try {
                for (int i = 0; i < LazyList.size(this.contextListeners); ++i) {
                    LazyList.get(this.contextListeners, i).contextInitialized(event);
                }
            }
            catch (Exception e) {
                this.setUnavailable(true);
                throw e;
            }
        }
        Logger.debug("org.mortbay.jetty.handler.ContextHandler.startContext() -> end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        ContextManager.saveState();
        ContextManager.setCurrentContext(this.context);
        try {
            if (this.classLoader != null) {
                ClassLoader.setCurrentClassLoader(this.classLoader);
            }
            super.doStop();
            if (this.contextListeners != null) {
                ServletContextEvent event = new ServletContextEvent(this.context);
                int i = LazyList.size(this.contextListeners);
                while (i-- > 0) {
                    LazyList.get(this.contextListeners, i).contextDestroyed(event);
                }
            }
        }
        finally {
            ContextManager.restoreState();
        }
        this.contextAttributes.clearAttributes();
        this.contextAttributes = null;
        ContextManager.resetContexts(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        block42: {
            Request base_request;
            String old_path_info;
            String old_servlet_path;
            String old_context_path;
            Context old_context;
            block43: {
                Logger.debug("org.mortbay.jetty.handler.ContextHandler.handle() -> " + request.getRequestURI());
                boolean new_context = false;
                old_context = null;
                old_context_path = null;
                old_servlet_path = null;
                old_path_info = null;
                ClassLoader old_classloader = null;
                Request request2 = base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
                if (this.isUnavailable()) {
                    response.sendError(500);
                    return;
                }
                if (this.shutdown || dispatch == 1 && base_request.isHandled()) {
                    return;
                }
                old_context = base_request.getContext();
                ContextManager.setCurrentRequest(base_request);
                if (old_context != this.context) {
                    new_context = true;
                    if (dispatch == 1) {
                        if (target.equals(this.contextPath)) {
                            target = this.contextPath;
                            if (!target.endsWith("/")) {
                                base_request.setHandled(true);
                                if (request.getQueryString() != null) {
                                    response.sendRedirect(target + "/?" + request.getQueryString());
                                } else {
                                    response.sendRedirect(target + "/");
                                }
                                return;
                            }
                        } else if (target.startsWith(this.contextPath) && (this.contextPath.length() == 1 || target.charAt(this.contextPath.length()) == '/')) {
                            if (this.contextPath.length() > 1) {
                                target = target.substring(this.contextPath.length());
                            }
                        } else {
                            return;
                        }
                    }
                }
                try {
                    block41: {
                        old_context_path = base_request.getContextPath();
                        old_servlet_path = base_request.getServletPath();
                        old_path_info = base_request.getPathInfo();
                        base_request.setContext(this.context);
                        if (dispatch != 4 && target.startsWith("/")) {
                            if (this.contextPath.length() == 1) {
                                base_request.setContextPath("");
                            } else {
                                base_request.setContextPath(this.contextPath);
                            }
                            base_request.setServletPath(null);
                            base_request.setPathInfo(target);
                        }
                        ServletRequestEvent event = null;
                        if (new_context) {
                            int i;
                            if (this.classLoader != null) {
                                Thread.currentThread();
                                old_classloader = ClassLoader.getCurrentClassLoader();
                                ClassLoader.setCurrentClassLoader(this.classLoader);
                            }
                            if (this.requestListeners != null) {
                                event = new ServletRequestEvent(this.context, request);
                                try {
                                    for (i = 0; i < LazyList.size(this.requestListeners); ++i) {
                                        LazyList.get(this.requestListeners, i).requestInitialized(event);
                                    }
                                }
                                catch (Throwable th) {
                                    this.setUnavailable(true);
                                    response.sendError(500, th.getMessage());
                                }
                            }
                            for (i = 0; i < LazyList.size(this.requestAttributeListeners); ++i) {
                                base_request.addEventListener(LazyList.get(this.requestAttributeListeners, i));
                            }
                        }
                        try {
                            if (dispatch == 1 && this.isProtectedTarget(target)) {
                                throw new HttpException(404);
                            }
                            Handler handler = this.getHandler();
                            if (handler != null) {
                                handler.handle(target, request, response, dispatch);
                            }
                        }
                        catch (HttpException e) {
                            Logger.debug(e);
                            response.sendError(e.getStatus(), e.getReason());
                        }
                        finally {
                            if (!new_context) break block41;
                            try {
                                int i = LazyList.size(this.requestListeners);
                                while (i-- > 0) {
                                    LazyList.get(this.requestListeners, i).requestDestroyed(event);
                                }
                            }
                            catch (Throwable th) {
                                this.setUnavailable(true);
                                response.sendError(500, th.getMessage());
                            }
                            for (int i = 0; i < LazyList.size(this.requestAttributeListeners); ++i) {
                                base_request.removeEventListener(LazyList.get(this.requestAttributeListeners, i));
                            }
                        }
                    }
                    if (old_context == this.context) break block42;
                    if (this.classLoader == null) break block43;
                }
                catch (Throwable throwable) {
                    if (old_context != this.context) {
                        if (this.classLoader != null) {
                            ClassLoader.setCurrentClassLoader(old_classloader);
                        }
                        base_request.setContext(old_context);
                        base_request.setContextPath(old_context_path);
                        base_request.setServletPath(old_servlet_path);
                        base_request.setPathInfo(old_path_info);
                    }
                    throw throwable;
                }
                ClassLoader.setCurrentClassLoader(old_classloader);
            }
            base_request.setContext(old_context);
            base_request.setContextPath(old_context_path);
            base_request.setServletPath(old_servlet_path);
            base_request.setPathInfo(old_path_info);
        }
    }

    protected boolean isProtectedTarget(String target) {
        return false;
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.removeAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.setAttribute(name, value);
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public void clearAttributes() {
        this.attributes.clearAttributes();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setContextPath(String contextPath) {
        if (contextPath != null && contextPath.length() > 1 && contextPath.endsWith("/")) {
            throw new IllegalArgumentException("ends with /");
        }
        this.contextPath = contextPath;
        WebServer server = WebServer.getWebServer();
        if (server.isStarted()) {
            server.updateContextHandlerCollection();
        }
    }

    public void setInitParams(Hashtable<String, String> initParams) {
        if (initParams == null) {
            return;
        }
        this.initParams = new Hashtable();
        Enumeration<String> e = initParams.keys();
        String key = null;
        while (e.hasMoreElements()) {
            key = e.nextElement();
            this.initParams.put(key, initParams.get(key));
        }
    }

    public void setDisplayName(String servletContextName) {
        this.displayName = servletContextName;
    }

    public Resource getBaseResource() {
        if (this.baseResource == null) {
            return null;
        }
        return this.baseResource;
    }

    public String getResourceBase() {
        if (this.baseResource == null) {
            return null;
        }
        return this.baseResource.toString();
    }

    public void setBaseResource(Resource base) {
        Logger.debug("ContextHandler.setBaseResource -> " + base);
        this.baseResource = base;
        this.docRoot = null;
        try {
            FileConnection file = this.baseResource.getFile();
            if (file != null) {
                this.docRoot = file.getCanonicalPath();
                if (this.docRoot.endsWith("/")) {
                    this.docRoot = this.docRoot.substring(0, this.docRoot.length() - 1);
                }
            }
        }
        catch (Exception e) {
            Logger.debug(e);
            throw new IllegalArgumentException(base.toString());
        }
    }

    public void setResourceBase(String resourceBase) {
        try {
            this.setBaseResource(Resource.newResource(resourceBase));
        }
        catch (Exception e) {
            Logger.debug(e);
            throw new IllegalArgumentException(resourceBase);
        }
    }

    public MimeTypes getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(MimeTypes mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public void setWelcomeFiles(LazyList<String> files) {
        this.welcomeFiles = files;
    }

    public LazyList<String> getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public String toString() {
        return "ContextHandler@" + Integer.toHexString(this.hashCode()) + "{" + this.getContextPath() + "," + this.getBaseResource() + "}";
    }

    public synchronized Class<?> loadClass(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        if (this.classLoader == null) {
            return Loader.loadClass(this.getClass(), className, ((WebAppContext)this).getClassLoader());
        }
        return this.classLoader.loadClass(className);
    }

    public void addLocaleEncoding(String locale, String encoding) {
        if (this.localeEncodingMap == null) {
            this.localeEncodingMap = new Hashtable();
        }
        this.localeEncodingMap.put(locale, encoding);
    }

    public String getLocaleEncoding(Locale locale) {
        if (this.localeEncodingMap == null) {
            return null;
        }
        String encoding = this.localeEncodingMap.get(locale.toString());
        if (encoding == null) {
            encoding = this.localeEncodingMap.get(locale.getLanguage());
        }
        return encoding;
    }

    public Resource getResource(String path) throws IOException {
        if (path == null || !path.startsWith("/")) {
            throw new IOException("Invalid Path " + path);
        }
        if (this.baseResource == null) {
            return null;
        }
        try {
            path = URIUtil.canonicalPath(path);
            Resource resource = this.baseResource.addPath(path);
            return resource;
        }
        catch (Exception e) {
            Logger.debug(e);
            return null;
        }
    }

    public Vector<String> getResourcePaths(String path) {
        try {
            path = URIUtil.canonicalPath(path);
            Resource resource = this.getResource(path);
            if (resource != null && resource.exists()) {
                String[] l;
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                if ((l = resource.list()) != null) {
                    Vector<String> set = new Vector<String>();
                    for (String element : l) {
                        set.addElement(path + element);
                    }
                    return set;
                }
            }
        }
        catch (Exception e) {
            Logger.debug(e);
        }
        return EmptyLists.EMPTY_VECTOR;
    }

    public class Context
    implements ServletContext {
        public ContextHandler getContextHandler() {
            return ContextHandler.this;
        }

        @Override
        public ServletContext getContext(String uripath) {
            return WebServer.getWebServer().getContext(uripath, NativeMethods.getCurrentContext());
        }

        @Override
        public int getMajorVersion() {
            return 2;
        }

        @Override
        public String getMimeType(String file) {
            if (ContextHandler.this.mimeTypes == null) {
                return null;
            }
            Buffer mime = ContextHandler.this.mimeTypes.getMimeByExtension(file);
            if (mime != null) {
                return mime.toString();
            }
            return null;
        }

        @Override
        public int getMinorVersion() {
            return 4;
        }

        @Override
        public RequestDispatcher getNamedDispatcher(String name) {
            Logger.debug("In gateNamedDispatcher() " + name);
            if (name == null) {
                return null;
            }
            if (!(ContextHandler.this instanceof WebAppContext)) {
                return null;
            }
            boolean nameFound = false;
            LazyList<ServletMapping> servletMappings = ((WebAppContext)ContextHandler.this).getServletHandler().getServletMappings();
            for (ServletMapping mapping : servletMappings) {
                Logger.debug("Servlet Name: " + mapping.getServletName());
                if (!name.equals(mapping.getServletName())) continue;
                nameFound = true;
                break;
            }
            if (nameFound) {
                return new Dispatcher(ContextHandler.this, name);
            }
            return null;
        }

        @Override
        public String getRealPath(String path) {
            if (ContextHandler.this.docRoot == null) {
                return null;
            }
            if (path == null) {
                return null;
            }
            if (!(path = URIUtil.canonicalPath(path)).startsWith("/")) {
                path = "/" + path;
            }
            return ContextHandler.this.docRoot + path;
        }

        @Override
        public RequestDispatcher getRequestDispatcher(String uriInContext) {
            if (uriInContext == null) {
                return null;
            }
            if (!uriInContext.startsWith("/")) {
                return null;
            }
            try {
                String query = null;
                int q = 0;
                q = uriInContext.indexOf(63);
                if (q > 0) {
                    query = uriInContext.substring(q + 1);
                    uriInContext = uriInContext.substring(0, q);
                }
                if ((q = uriInContext.indexOf(59)) > 0) {
                    uriInContext = uriInContext.substring(0, q);
                }
                String pathInContext = URIUtil.canonicalPath(URIUtil.decodePath(uriInContext));
                String uri = URIUtil.addPaths(this.getContextPath(), uriInContext);
                return new Dispatcher(ContextHandler.this, uri, pathInContext, query);
            }
            catch (Exception e) {
                Logger.debug(e);
                return null;
            }
        }

        public String getResource(String path) throws IOException {
            Resource resource = ContextHandler.this.getResource(path);
            if (resource != null && resource.exists()) {
                return resource.getURL();
            }
            return null;
        }

        public Resource getResourceObject(String path) throws IOException {
            Resource resource = ContextHandler.this.getResource(path);
            if (resource != null && resource.exists()) {
                return resource;
            }
            return null;
        }

        @Override
        public InputStream getResourceAsStream(String path) {
            try {
                Resource resource = this.getResourceObject(path);
                if (resource == null) {
                    return null;
                }
                return resource.getInputStream();
            }
            catch (Exception e) {
                Logger.debug(e);
                return null;
            }
        }

        public Vector<String> getResourcePaths(String path) {
            return ContextHandler.this.getResourcePaths(path);
        }

        @Override
        public String getServerInfo() {
            return "Jetty-6.0";
        }

        @Override
        public void log(String msg) {
            Logger.debug(msg);
        }

        @Override
        public void log(String message, Throwable throwable) {
            Logger.debug(message, throwable);
        }

        @Override
        public String getInitParameter(String name) {
            return ContextHandler.this.getInitParameter(name);
        }

        @Override
        public Enumeration<String> getInitParameterNames() {
            return ContextHandler.this.getInitParameterNames();
        }

        @Override
        public synchronized Object getAttribute(String name) {
            Object o = ContextHandler.this.getAttribute(name);
            if (o == null) {
                o = ContextHandler.this.contextAttributes.getAttribute(name);
            }
            return o;
        }

        @Override
        public synchronized Enumeration<String> getAttributeNames() {
            Vector<String> set = new Vector<String>();
            Enumeration<String> e = ContextHandler.this.contextAttributes.getAttributeNames();
            while (e.hasMoreElements()) {
                set.addElement(e.nextElement());
            }
            e = ContextHandler.this.getAttributeNames();
            while (e.hasMoreElements()) {
                set.addElement(e.nextElement());
            }
            return set.elements();
        }

        @Override
        public synchronized void setAttribute(String name, Object value) {
            Object old_value;
            if (ContextHandler.this.contextAttributes == null) {
                return;
            }
            Object object = old_value = ContextHandler.this.contextAttributes == null ? null : ContextHandler.this.contextAttributes.getAttribute(name);
            if (value == null) {
                ContextHandler.this.contextAttributes.removeAttribute(name);
            } else {
                ContextHandler.this.contextAttributes.setAttribute(name, value);
            }
            if (ContextHandler.this.contextAttributeListeners != null) {
                ServletContextAttributeEvent event = new ServletContextAttributeEvent(ContextHandler.this.context, name, old_value == null ? value : old_value);
                for (int i = 0; i < LazyList.size(ContextHandler.this.contextAttributeListeners); ++i) {
                    ServletContextAttributeListener l = LazyList.get(ContextHandler.this.contextAttributeListeners, i);
                    if (old_value == null) {
                        l.attributeAdded(event);
                        continue;
                    }
                    if (value == null) {
                        l.attributeRemoved(event);
                        continue;
                    }
                    l.attributeReplaced(event);
                }
            }
        }

        @Override
        public synchronized void removeAttribute(String name) {
            Object old_value = ContextHandler.this.contextAttributes.getAttribute(name);
            ContextHandler.this.contextAttributes.removeAttribute(name);
            if (old_value != null && ContextHandler.this.contextAttributeListeners != null) {
                ServletContextAttributeEvent event = new ServletContextAttributeEvent(ContextHandler.this.context, name, old_value);
                for (int i = 0; i < LazyList.size(ContextHandler.this.contextAttributeListeners); ++i) {
                    LazyList.get(ContextHandler.this.contextAttributeListeners, i).attributeRemoved(event);
                }
            }
        }

        @Override
        public String getServletContextName() {
            String name = ContextHandler.this.getDisplayName();
            if (name == null) {
                name = ContextHandler.this.getContextPath();
            }
            return name;
        }

        public String getContextPath() {
            return ContextHandler.this.contextPath;
        }

        public String toString() {
            return "ServletContext@" + Integer.toHexString(this.hashCode()) + "{" + this.getContextPath() + "," + ContextHandler.this.getBaseResource() + "}";
        }
    }
}

