/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.IOException;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.io.ServerSecureConnection;
import javax.microedition.io.Connector;
import javax.microedition.io.SecureConnection;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.bio.SocketConnector;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class SslSocketConnector
extends SocketConnector {
    protected ServerSecureConnection serverSecureConnection;
    protected Vector<SocketConnector.Connection> connections;

    @Override
    public Object getConnection() {
        return null;
    }

    @Override
    public void open() throws IOException {
        int port = this.getPort();
        this.serverSecureConnection = port == -1 ? (ServerSecureConnection)Connector.open("ssl://") : (ServerSecureConnection)Connector.open("ssl://:" + port);
    }

    @Override
    public void close() throws IOException {
        if (this.serverSecureConnection != null) {
            this.serverSecureConnection.close();
        }
        this.serverSecureConnection = null;
    }

    @Override
    public void accept(int acceptorID) throws IOException {
        SecureConnection socket = (SecureConnection)this.serverSecureConnection.acceptAndOpen();
        this.configure(socket);
        SocketConnector.Connection connection = new SocketConnector.Connection(socket);
        connection.dispatch();
    }

    @Override
    protected Buffer newBuffer(int size) {
        return new ByteArrayBuffer(size);
    }

    @Override
    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
    }

    @Override
    public int getLocalPort() {
        if (this.serverSecureConnection == null) {
            return -1;
        }
        try {
            return this.serverSecureConnection.getLocalPort();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.connections = new Vector();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        for (SocketConnector.Connection connection : this.connections) {
            connection.close();
        }
    }

    @Override
    public boolean isIntegral(Request request) {
        return true;
    }

    @Override
    public boolean isConfidential(Request request) {
        return true;
    }
}

