/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.SessionHandler;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class Context
extends ContextHandler {
    public static final int SESSIONS = 1;
    public static final int SECURITY = 2;
    public static final int NO_SESSIONS = 0;
    public static final int NO_SECURITY = 0;
    protected SecurityHandler securityHandler;
    protected ServletHandler servletHandler;
    protected SessionHandler sessionHandler;

    public Context(HandlerContainer parent, String contextPath, int options) {
        this(parent, (options & 1) != 0 ? new SessionHandler() : null, (options & 2) != 0 ? new SecurityHandler() : null, null, null);
        this.setContextPath(contextPath);
    }

    public Context(HandlerContainer parent, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        this.sessionHandler = sessionHandler;
        this.securityHandler = securityHandler;
        ServletHandler servletHandler2 = this.servletHandler = servletHandler != null ? servletHandler : new ServletHandler();
        if (this.sessionHandler != null) {
            this.setHandler(this.sessionHandler);
            if (securityHandler != null) {
                this.sessionHandler.setHandler(this.securityHandler);
                this.securityHandler.setHandler(this.servletHandler);
            } else {
                this.sessionHandler.setHandler(this.servletHandler);
            }
        } else if (this.securityHandler != null) {
            this.setHandler(this.securityHandler);
            this.securityHandler.setHandler(this.servletHandler);
        } else {
            this.setHandler(this.servletHandler);
        }
        if (errorHandler != null) {
            this.setErrorHandler(errorHandler);
        }
        if (parent != null) {
            parent.addHandler(this);
        }
    }

    public SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    public ServletHandler getServletHandler() {
        return this.servletHandler;
    }

    public SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    public void addServlet(ServletHolder servlet, String pathSpec) {
        this.servletHandler.addServletWithMapping(servlet, pathSpec);
    }
}

