/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.PathMap;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class FilterMapping {
    private int dispatches = 1;
    private String filterName;
    private transient FilterHolder holder;
    private String[] pathSpecs;
    private String[] servletNames;

    boolean appliesTo(String path, int type) {
        if (((this.dispatches & type) != 0 || this.dispatches == 0 && type == 1) && this.pathSpecs != null) {
            for (String element : this.pathSpecs) {
                if (element == null || !PathMap.match(element, path)) continue;
                return true;
            }
        }
        return false;
    }

    boolean appliesTo(int type) {
        return ((this.dispatches & type) != 0 || this.dispatches == 0 && type == 1) && this.pathSpecs != null;
    }

    public int getDispatches() {
        return this.dispatches;
    }

    public String getFilterName() {
        return this.filterName;
    }

    FilterHolder getFilterHolder() {
        return this.holder;
    }

    public String[] getPathSpecs() {
        return this.pathSpecs;
    }

    public void setDispatches(int dispatches) {
        this.dispatches = dispatches;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    void setFilterHolder(FilterHolder holder) {
        this.holder = holder;
    }

    public void setPathSpecs(String[] pathSpecs) {
        this.pathSpecs = pathSpecs;
    }

    public void setPathSpec(String pathSpec) {
        this.pathSpecs = new String[]{pathSpec};
    }

    public String[] getServletNames() {
        return this.servletNames;
    }

    public void setServletNames(String[] servletNames) {
        this.servletNames = servletNames;
    }

    public void setServletName(String servletName) {
        this.servletNames = new String[]{servletName};
    }

    public String toString() {
        return "(F=" + this.filterName + "," + (this.pathSpecs == null ? "[]" : this.pathSpecs) + "," + (this.servletNames == null ? "[]" : this.servletNames) + "," + this.dispatches + ")";
    }
}

