/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class Utf8StringBuffer {
    StringBuffer buffer;
    int more;
    int bits;

    Utf8StringBuffer() {
        this.buffer = new StringBuffer();
    }

    Utf8StringBuffer(int capacity) {
        this.buffer = new StringBuffer(capacity);
    }

    public void append(byte b) {
        if (b > 0) {
            if (this.more > 0) {
                this.buffer.append('?');
                this.more = 0;
                this.bits = 0;
            } else {
                this.buffer.append((char)(0x7F & b));
            }
        } else if (this.more == 0) {
            if ((b & 0xC0) != 192) {
                this.buffer.append('?');
                this.more = 0;
                this.bits = 0;
            } else if ((b & 0xE0) == 192) {
                this.more = 1;
                this.bits = b & 0x1F;
            } else if ((b & 0xF0) == 224) {
                this.more = 2;
                this.bits = b & 0xF;
            } else if ((b & 0xF8) == 240) {
                this.more = 3;
                this.bits = b & 7;
            } else if ((b & 0xFC) == 248) {
                this.more = 4;
                this.bits = b & 3;
            } else if ((b & 0xFE) == 252) {
                this.more = 5;
                this.bits = b & 1;
            }
        } else if ((b & 0xC0) == 192) {
            this.buffer.append('?');
            this.more = 0;
            this.bits = 0;
        } else {
            this.bits = this.bits << 6 | b & 0x3F;
            if (--this.more == 0) {
                this.buffer.append((char)this.bits);
            }
        }
    }

    public int length() {
        return this.buffer.length();
    }

    public void reset() {
        this.buffer.setLength(0);
        this.more = 0;
        this.bits = 0;
    }

    public StringBuffer getStringBuffer() {
        return this.buffer;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

