/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.TypeArray;
import com.sun.javacard.offcardverifier.TypeBase;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.TypeNull;
import com.sun.javacard.offcardverifier.VerifierError;

public abstract class Type {
    protected Type beforeNormalization = null;
    public static final Type Byte = new TypeBase(3);
    public static final Type Short = new TypeBase(4);
    public static final Type Int = new TypeBase(5);
    public static final Type Int2 = new TypeBase(6);
    public static final Type Boolean = new TypeBase(2);
    public static final Type Void = new TypeBase(1);
    public static final Type BooleanArray = new TypeArray(Boolean);
    public static final Type ByteArray = new TypeArray(Byte);
    public static final Type ShortArray = new TypeArray(Short);
    public static final Type IntArray = new TypeArray(Int);
    public static final Type Null = new TypeNull();

    public abstract boolean isSubtype(Type var1);

    public abstract Type lub(Type var1);

    public int wordSize() {
        return 1;
    }

    public Type normalize() {
        return this;
    }

    public String toString() {
        if (this.beforeNormalization != null) {
            return this.beforeNormalization.toStringAux();
        }
        return this.toStringAux();
    }

    abstract String toStringAux();

    public static Type parseCap(Safeptr typtr) {
        TypeMethod mty = TypeMethod.parseCap(typtr);
        if (mty.args.length != 0) {
            throw new VerifierError("Type.1", typtr);
        }
        if (mty.res.equals(Void)) {
            throw new VerifierError("Type.2", typtr);
        }
        return mty.res;
    }

    public static Type parseField(int tyOfs) {
        if ((tyOfs & 0x8000) == 0) {
            return Type.parseCap(Cap.TypeDescr.at(tyOfs));
        }
        switch (tyOfs) {
            case 32770: {
                return Boolean;
            }
            case 32771: {
                return Byte;
            }
            case 32772: {
                return Short;
            }
            case 32773: {
                return Int;
            }
        }
        throw new VerifierError("Type.3", tyOfs);
    }

    public static Type parseExport(String sig) {
        TypeMethod mty = TypeMethod.parseExport(sig);
        if (mty.args.length != 0) {
            throw new VerifierError("Type.4", sig);
        }
        if (mty.res.equals(Void)) {
            throw new VerifierError("Type.5", sig);
        }
        return mty.res;
    }
}

