// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "L1CTL_Types.hh"

namespace L1CTL__Types {

/* Member functions of C++ classes */

L1ctlGprsRtsInd::L1ctlGprsRtsInd()
{
}

L1ctlGprsRtsInd::L1ctlGprsRtsInd(const INTEGER& par_fn,
    const INTEGER& par_tn,
    const INTEGER& par_usf)
  :   field_fn(par_fn),
  field_tn(par_tn),
  field_usf(par_usf)
{
}

L1ctlGprsRtsInd::L1ctlGprsRtsInd(const L1ctlGprsRtsInd& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @L1CTL_Types.L1ctlGprsRtsInd.");
if (other_value.fn().is_bound()) field_fn = other_value.fn();
else field_fn.clean_up();
if (other_value.tn().is_bound()) field_tn = other_value.tn();
else field_tn.clean_up();
if (other_value.usf().is_bound()) field_usf = other_value.usf();
else field_usf.clean_up();
}

void L1ctlGprsRtsInd::clean_up()
{
field_fn.clean_up();
field_tn.clean_up();
field_usf.clean_up();
}

const TTCN_Typedescriptor_t* L1ctlGprsRtsInd::get_descriptor() const { return &L1ctlGprsRtsInd_descr_; }
L1ctlGprsRtsInd& L1ctlGprsRtsInd::operator=(const L1ctlGprsRtsInd& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @L1CTL_Types.L1ctlGprsRtsInd.");
  if (other_value.fn().is_bound()) field_fn = other_value.fn();
  else field_fn.clean_up();
  if (other_value.tn().is_bound()) field_tn = other_value.tn();
  else field_tn.clean_up();
  if (other_value.usf().is_bound()) field_usf = other_value.usf();
  else field_usf.clean_up();
}
return *this;
}

boolean L1ctlGprsRtsInd::operator==(const L1ctlGprsRtsInd& other_value) const
{
return field_fn==other_value.field_fn
  && field_tn==other_value.field_tn
  && field_usf==other_value.field_usf;
}

boolean L1ctlGprsRtsInd::is_bound() const
{
return (field_fn.is_bound())
  || (field_tn.is_bound())
  || (field_usf.is_bound());
}
boolean L1ctlGprsRtsInd::is_value() const
{
return field_fn.is_value()
  && field_tn.is_value()
  && field_usf.is_value();
}
void L1ctlGprsRtsInd::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ fn := ");
field_fn.log();
TTCN_Logger::log_event_str(", tn := ");
field_tn.log();
TTCN_Logger::log_event_str(", usf := ");
field_usf.log();
TTCN_Logger::log_event_str(" }");
}

void L1ctlGprsRtsInd::set_implicit_omit()
{
if (fn().is_bound()) fn().set_implicit_omit();
if (tn().is_bound()) tn().set_implicit_omit();
if (usf().is_bound()) usf().set_implicit_omit();
}

void L1ctlGprsRtsInd::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @L1CTL_Types.L1ctlGprsRtsInd has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) fn().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tn().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) usf().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "fn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          fn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "usf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          usf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @L1CTL_Types.L1ctlGprsRtsInd: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@L1CTL_Types.L1ctlGprsRtsInd");
  }
}

void L1ctlGprsRtsInd::encode_text(Text_Buf& text_buf) const
{
field_fn.encode_text(text_buf);
field_tn.encode_text(text_buf);
field_usf.encode_text(text_buf);
}

void L1ctlGprsRtsInd::decode_text(Text_Buf& text_buf)
{
field_fn.decode_text(text_buf);
field_tn.decode_text(text_buf);
field_usf.decode_text(text_buf);
}

void L1ctlGprsRtsInd::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void L1ctlGprsRtsInd::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int L1ctlGprsRtsInd::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, Osmocom__Types::uint32__t_descr_.raw->forceomit);
  decoded_field_length = field_fn.RAW_decode(Osmocom__Types::uint32__t_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Osmocom__Types::uint8__t_descr_.raw->forceomit);
  decoded_field_length = field_tn.RAW_decode(Osmocom__Types::uint8__t_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, Osmocom__Types::uint8__t_descr_.raw->forceomit);
  decoded_field_length = field_usf.RAW_decode(Osmocom__Types::uint8__t_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int L1ctlGprsRtsInd::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, Osmocom__Types::uint32__t_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Osmocom__Types::uint8__t_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Osmocom__Types::uint8__t_descr_.raw);
  encoded_length += field_fn.RAW_encode(Osmocom__Types::uint32__t_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_tn.RAW_encode(Osmocom__Types::uint8__t_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_usf.RAW_encode(Osmocom__Types::uint8__t_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct L1ctlGprsRtsInd_template::single_value_struct {
INTEGER_template field_fn;
INTEGER_template field_tn;
INTEGER_template field_usf;
};

void L1ctlGprsRtsInd_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_fn = ANY_VALUE;
single_value->field_tn = ANY_VALUE;
single_value->field_usf = ANY_VALUE;
}
}
}

void L1ctlGprsRtsInd_template::copy_value(const L1ctlGprsRtsInd& other_value)
{
single_value = new single_value_struct;
if (other_value.fn().is_bound()) {
  single_value->field_fn = other_value.fn();
} else {
  single_value->field_fn.clean_up();
}
if (other_value.tn().is_bound()) {
  single_value->field_tn = other_value.tn();
} else {
  single_value->field_tn.clean_up();
}
if (other_value.usf().is_bound()) {
  single_value->field_usf = other_value.usf();
} else {
  single_value->field_usf.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void L1ctlGprsRtsInd_template::copy_template(const L1ctlGprsRtsInd_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.fn().get_selection()) {
single_value->field_fn = other_value.fn();
} else {
single_value->field_fn.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tn().get_selection()) {
single_value->field_tn = other_value.tn();
} else {
single_value->field_tn.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.usf().get_selection()) {
single_value->field_usf = other_value.usf();
} else {
single_value->field_usf.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new L1ctlGprsRtsInd_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new L1ctlGprsRtsInd_template(*other_value.implication_.precondition);
implication_.implied_template = new L1ctlGprsRtsInd_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @L1CTL_Types.L1ctlGprsRtsInd.");
break;
}
set_selection(other_value);
}

L1ctlGprsRtsInd_template::L1ctlGprsRtsInd_template()
{
}

L1ctlGprsRtsInd_template::L1ctlGprsRtsInd_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

L1ctlGprsRtsInd_template::L1ctlGprsRtsInd_template(const L1ctlGprsRtsInd& other_value)
{
copy_value(other_value);
}

L1ctlGprsRtsInd_template::L1ctlGprsRtsInd_template(const OPTIONAL<L1ctlGprsRtsInd>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const L1ctlGprsRtsInd&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @L1CTL_Types.L1ctlGprsRtsInd from an unbound optional field.");
}
}

L1ctlGprsRtsInd_template::L1ctlGprsRtsInd_template(L1ctlGprsRtsInd_template* p_precondition, L1ctlGprsRtsInd_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

L1ctlGprsRtsInd_template::L1ctlGprsRtsInd_template(Dynamic_Match_Interface<L1ctlGprsRtsInd>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<L1ctlGprsRtsInd>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

L1ctlGprsRtsInd_template::L1ctlGprsRtsInd_template(const L1ctlGprsRtsInd_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

L1ctlGprsRtsInd_template::~L1ctlGprsRtsInd_template()
{
clean_up();
}

L1ctlGprsRtsInd_template& L1ctlGprsRtsInd_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

L1ctlGprsRtsInd_template& L1ctlGprsRtsInd_template::operator=(const L1ctlGprsRtsInd& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

L1ctlGprsRtsInd_template& L1ctlGprsRtsInd_template::operator=(const OPTIONAL<L1ctlGprsRtsInd>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const L1ctlGprsRtsInd&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @L1CTL_Types.L1ctlGprsRtsInd.");
}
return *this;
}

L1ctlGprsRtsInd_template& L1ctlGprsRtsInd_template::operator=(const L1ctlGprsRtsInd_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean L1ctlGprsRtsInd_template::match(const L1ctlGprsRtsInd& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.fn().is_bound()) return FALSE;
if(!single_value->field_fn.match(other_value.fn(), legacy))return FALSE;
if(!other_value.tn().is_bound()) return FALSE;
if(!single_value->field_tn.match(other_value.tn(), legacy))return FALSE;
if(!other_value.usf().is_bound()) return FALSE;
if(!single_value->field_usf.match(other_value.usf(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @L1CTL_Types.L1ctlGprsRtsInd.");
}
return FALSE;
}

boolean L1ctlGprsRtsInd_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_fn.is_bound()
 || single_value->field_tn.is_bound()
 || single_value->field_usf.is_bound();
}

boolean L1ctlGprsRtsInd_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_fn.is_value()
 && single_value->field_tn.is_value()
 && single_value->field_usf.is_value();
}

void L1ctlGprsRtsInd_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

L1ctlGprsRtsInd L1ctlGprsRtsInd_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @L1CTL_Types.L1ctlGprsRtsInd.");
L1ctlGprsRtsInd ret_val;
if (single_value->field_fn.is_bound()) {
ret_val.fn() = single_value->field_fn.valueof();
}
if (single_value->field_tn.is_bound()) {
ret_val.tn() = single_value->field_tn.valueof();
}
if (single_value->field_usf.is_bound()) {
ret_val.usf() = single_value->field_usf.valueof();
}
return ret_val;
}

void L1ctlGprsRtsInd_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @L1CTL_Types.L1ctlGprsRtsInd.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new L1ctlGprsRtsInd_template[list_length];
}

L1ctlGprsRtsInd_template& L1ctlGprsRtsInd_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @L1CTL_Types.L1ctlGprsRtsInd.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @L1CTL_Types.L1ctlGprsRtsInd.");
return value_list.list_value[list_index];
}

INTEGER_template& L1ctlGprsRtsInd_template::fn()
{
set_specific();
return single_value->field_fn;
}

const INTEGER_template& L1ctlGprsRtsInd_template::fn() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field fn of a non-specific template of type @L1CTL_Types.L1ctlGprsRtsInd.");
return single_value->field_fn;
}

INTEGER_template& L1ctlGprsRtsInd_template::tn()
{
set_specific();
return single_value->field_tn;
}

const INTEGER_template& L1ctlGprsRtsInd_template::tn() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tn of a non-specific template of type @L1CTL_Types.L1ctlGprsRtsInd.");
return single_value->field_tn;
}

INTEGER_template& L1ctlGprsRtsInd_template::usf()
{
set_specific();
return single_value->field_usf;
}

const INTEGER_template& L1ctlGprsRtsInd_template::usf() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field usf of a non-specific template of type @L1CTL_Types.L1ctlGprsRtsInd.");
return single_value->field_usf;
}

int L1ctlGprsRtsInd_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlGprsRtsInd which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlGprsRtsInd containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlGprsRtsInd containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlGprsRtsInd containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlGprsRtsInd containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlGprsRtsInd containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlGprsRtsInd containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlGprsRtsInd containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlGprsRtsInd containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @L1CTL_Types.L1ctlGprsRtsInd.");
  }
  return 0;
}

void L1ctlGprsRtsInd_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ fn := ");
single_value->field_fn.log();
TTCN_Logger::log_event_str(", tn := ");
single_value->field_tn.log();
TTCN_Logger::log_event_str(", usf := ");
single_value->field_usf.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void L1ctlGprsRtsInd_template::log_match(const L1ctlGprsRtsInd& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_fn.match(match_value.fn(), legacy)){
TTCN_Logger::log_logmatch_info(".fn");
single_value->field_fn.log_match(match_value.fn(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tn.match(match_value.tn(), legacy)){
TTCN_Logger::log_logmatch_info(".tn");
single_value->field_tn.log_match(match_value.tn(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_usf.match(match_value.usf(), legacy)){
TTCN_Logger::log_logmatch_info(".usf");
single_value->field_usf.log_match(match_value.usf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ fn := ");
single_value->field_fn.log_match(match_value.fn(), legacy);
TTCN_Logger::log_event_str(", tn := ");
single_value->field_tn.log_match(match_value.tn(), legacy);
TTCN_Logger::log_event_str(", usf := ");
single_value->field_usf.log_match(match_value.usf(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void L1ctlGprsRtsInd_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (fn().is_bound()) fn().set_implicit_omit();
if (tn().is_bound()) tn().set_implicit_omit();
if (usf().is_bound()) usf().set_implicit_omit();
}

void L1ctlGprsRtsInd_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_fn.encode_text(text_buf);
single_value->field_tn.encode_text(text_buf);
single_value->field_usf.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @L1CTL_Types.L1ctlGprsRtsInd.");
}
}

void L1ctlGprsRtsInd_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_fn.decode_text(text_buf);
single_value->field_tn.decode_text(text_buf);
single_value->field_usf.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new L1ctlGprsRtsInd_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @L1CTL_Types.L1ctlGprsRtsInd.");
}
}

void L1ctlGprsRtsInd_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    L1ctlGprsRtsInd_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @L1CTL_Types.L1ctlGprsRtsInd has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) fn().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tn().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) usf().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "fn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          fn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "usf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          usf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @L1CTL_Types.L1ctlGprsRtsInd: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    L1ctlGprsRtsInd_template* precondition = new L1ctlGprsRtsInd_template;
    precondition->set_param(*param.get_elem(0));
    L1ctlGprsRtsInd_template* implied_template = new L1ctlGprsRtsInd_template;
    implied_template->set_param(*param.get_elem(1));
    *this = L1ctlGprsRtsInd_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@L1CTL_Types.L1ctlGprsRtsInd");
  }
  is_ifpresent = param.get_ifpresent();
}

void L1ctlGprsRtsInd_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_fn.check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlGprsRtsInd");
single_value->field_tn.check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlGprsRtsInd");
single_value->field_usf.check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlGprsRtsInd");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@L1CTL_Types.L1ctlGprsRtsInd");
}

boolean L1ctlGprsRtsInd_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean L1ctlGprsRtsInd_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void L1ctlMsgPayload::copy_value(const L1ctlMsgPayload& other_value)
{
switch (other_value.union_selection) {
case ALT_fbsb__req:
field_fbsb__req = new L1ctlFbsbReq(*other_value.field_fbsb__req);
break;
case ALT_fbsb__conf:
field_fbsb__conf = new L1ctlFbsbConf(*other_value.field_fbsb__conf);
break;
case ALT_data__ind:
field_data__ind = new L1ctlDataInd(*other_value.field_data__ind);
break;
case ALT_rach__req:
field_rach__req = new L1ctlRachReq(*other_value.field_rach__req);
break;
case ALT_dm__est__req:
field_dm__est__req = new L1ctlDmEstReq(*other_value.field_dm__est__req);
break;
case ALT_data__req:
field_data__req = new L1ctlDataReq(*other_value.field_data__req);
break;
case ALT_reset__req:
field_reset__req = new L1ctlReset(*other_value.field_reset__req);
break;
case ALT_ccch__mode__req:
field_ccch__mode__req = new L1ctlCcchModeReq(*other_value.field_ccch__mode__req);
break;
case ALT_ccch__mode__conf:
field_ccch__mode__conf = new L1ctlCcchModeConf(*other_value.field_ccch__mode__conf);
break;
case ALT_par__req:
field_par__req = new L1ctlParReq(*other_value.field_par__req);
break;
case ALT_crypto__req:
field_crypto__req = new L1CtlCryptoReq(*other_value.field_crypto__req);
break;
case ALT_tch__mode__req:
field_tch__mode__req = new L1ctlTchModeReq(*other_value.field_tch__mode__req);
break;
case ALT_tch__mode__conf:
field_tch__mode__conf = new L1ctlTchModeConf(*other_value.field_tch__mode__conf);
break;
case ALT_traffic__req:
field_traffic__req = new L1ctlTrafficReq(*other_value.field_traffic__req);
break;
case ALT_traffic__ind:
field_traffic__ind = new L1ctlTrafficReq(*other_value.field_traffic__ind);
break;
case ALT_ul__tbf__cfg__req:
field_ul__tbf__cfg__req = new L1ctlGprsUlTbfCfgReq(*other_value.field_ul__tbf__cfg__req);
break;
case ALT_dl__tbf__cfg__req:
field_dl__tbf__cfg__req = new L1ctlGprsDlTbfCfgReq(*other_value.field_dl__tbf__cfg__req);
break;
case ALT_ul__block__req:
field_ul__block__req = new L1ctlGprsUlBlockReq(*other_value.field_ul__block__req);
break;
case ALT_ul__block__cnf:
field_ul__block__cnf = new L1ctlGprsUlBlockCnf(*other_value.field_ul__block__cnf);
break;
case ALT_dl__block__ind:
field_dl__block__ind = new L1ctlGprsDlBlockInd(*other_value.field_dl__block__ind);
break;
case ALT_ext__rach__req:
field_ext__rach__req = new L1ctlExtRachReq(*other_value.field_ext__rach__req);
break;
case ALT_rts__ind:
field_rts__ind = new L1ctlGprsRtsInd(*other_value.field_rts__ind);
break;
case ALT_other:
field_other = new OCTETSTRING(*other_value.field_other);
break;
default:
TTCN_error("Assignment of an unbound union value of type @L1CTL_Types.L1ctlMsgPayload.");
}
union_selection = other_value.union_selection;
}

L1ctlMsgPayload::L1ctlMsgPayload()
{
union_selection = UNBOUND_VALUE;
}

L1ctlMsgPayload::L1ctlMsgPayload(const L1ctlMsgPayload& other_value)
: Base_Type(){
copy_value(other_value);
}

L1ctlMsgPayload::~L1ctlMsgPayload()
{
clean_up();
}

L1ctlMsgPayload& L1ctlMsgPayload::operator=(const L1ctlMsgPayload& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean L1ctlMsgPayload::operator==(const L1ctlMsgPayload& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @L1CTL_Types.L1ctlMsgPayload.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @L1CTL_Types.L1ctlMsgPayload.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_fbsb__req:
return *field_fbsb__req == *other_value.field_fbsb__req;
case ALT_fbsb__conf:
return *field_fbsb__conf == *other_value.field_fbsb__conf;
case ALT_data__ind:
return *field_data__ind == *other_value.field_data__ind;
case ALT_rach__req:
return *field_rach__req == *other_value.field_rach__req;
case ALT_dm__est__req:
return *field_dm__est__req == *other_value.field_dm__est__req;
case ALT_data__req:
return *field_data__req == *other_value.field_data__req;
case ALT_reset__req:
return *field_reset__req == *other_value.field_reset__req;
case ALT_ccch__mode__req:
return *field_ccch__mode__req == *other_value.field_ccch__mode__req;
case ALT_ccch__mode__conf:
return *field_ccch__mode__conf == *other_value.field_ccch__mode__conf;
case ALT_par__req:
return *field_par__req == *other_value.field_par__req;
case ALT_crypto__req:
return *field_crypto__req == *other_value.field_crypto__req;
case ALT_tch__mode__req:
return *field_tch__mode__req == *other_value.field_tch__mode__req;
case ALT_tch__mode__conf:
return *field_tch__mode__conf == *other_value.field_tch__mode__conf;
case ALT_traffic__req:
return *field_traffic__req == *other_value.field_traffic__req;
case ALT_traffic__ind:
return *field_traffic__ind == *other_value.field_traffic__ind;
case ALT_ul__tbf__cfg__req:
return *field_ul__tbf__cfg__req == *other_value.field_ul__tbf__cfg__req;
case ALT_dl__tbf__cfg__req:
return *field_dl__tbf__cfg__req == *other_value.field_dl__tbf__cfg__req;
case ALT_ul__block__req:
return *field_ul__block__req == *other_value.field_ul__block__req;
case ALT_ul__block__cnf:
return *field_ul__block__cnf == *other_value.field_ul__block__cnf;
case ALT_dl__block__ind:
return *field_dl__block__ind == *other_value.field_dl__block__ind;
case ALT_ext__rach__req:
return *field_ext__rach__req == *other_value.field_ext__rach__req;
case ALT_rts__ind:
return *field_rts__ind == *other_value.field_rts__ind;
case ALT_other:
return *field_other == *other_value.field_other;
default:
return FALSE;
}
}

L1ctlFbsbReq& L1ctlMsgPayload::fbsb__req()
{
if (union_selection != ALT_fbsb__req) {
clean_up();
field_fbsb__req = new L1ctlFbsbReq;
union_selection = ALT_fbsb__req;
}
return *field_fbsb__req;
}

const L1ctlFbsbReq& L1ctlMsgPayload::fbsb__req() const
{
if (union_selection != ALT_fbsb__req) TTCN_error("Using non-selected field fbsb_req in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_fbsb__req;
}

L1ctlFbsbConf& L1ctlMsgPayload::fbsb__conf()
{
if (union_selection != ALT_fbsb__conf) {
clean_up();
field_fbsb__conf = new L1ctlFbsbConf;
union_selection = ALT_fbsb__conf;
}
return *field_fbsb__conf;
}

const L1ctlFbsbConf& L1ctlMsgPayload::fbsb__conf() const
{
if (union_selection != ALT_fbsb__conf) TTCN_error("Using non-selected field fbsb_conf in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_fbsb__conf;
}

L1ctlDataInd& L1ctlMsgPayload::data__ind()
{
if (union_selection != ALT_data__ind) {
clean_up();
field_data__ind = new L1ctlDataInd;
union_selection = ALT_data__ind;
}
return *field_data__ind;
}

const L1ctlDataInd& L1ctlMsgPayload::data__ind() const
{
if (union_selection != ALT_data__ind) TTCN_error("Using non-selected field data_ind in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_data__ind;
}

L1ctlRachReq& L1ctlMsgPayload::rach__req()
{
if (union_selection != ALT_rach__req) {
clean_up();
field_rach__req = new L1ctlRachReq;
union_selection = ALT_rach__req;
}
return *field_rach__req;
}

const L1ctlRachReq& L1ctlMsgPayload::rach__req() const
{
if (union_selection != ALT_rach__req) TTCN_error("Using non-selected field rach_req in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_rach__req;
}

L1ctlDmEstReq& L1ctlMsgPayload::dm__est__req()
{
if (union_selection != ALT_dm__est__req) {
clean_up();
field_dm__est__req = new L1ctlDmEstReq;
union_selection = ALT_dm__est__req;
}
return *field_dm__est__req;
}

const L1ctlDmEstReq& L1ctlMsgPayload::dm__est__req() const
{
if (union_selection != ALT_dm__est__req) TTCN_error("Using non-selected field dm_est_req in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_dm__est__req;
}

L1ctlDataReq& L1ctlMsgPayload::data__req()
{
if (union_selection != ALT_data__req) {
clean_up();
field_data__req = new L1ctlDataReq;
union_selection = ALT_data__req;
}
return *field_data__req;
}

const L1ctlDataReq& L1ctlMsgPayload::data__req() const
{
if (union_selection != ALT_data__req) TTCN_error("Using non-selected field data_req in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_data__req;
}

L1ctlReset& L1ctlMsgPayload::reset__req()
{
if (union_selection != ALT_reset__req) {
clean_up();
field_reset__req = new L1ctlReset;
union_selection = ALT_reset__req;
}
return *field_reset__req;
}

const L1ctlReset& L1ctlMsgPayload::reset__req() const
{
if (union_selection != ALT_reset__req) TTCN_error("Using non-selected field reset_req in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_reset__req;
}

L1ctlCcchModeReq& L1ctlMsgPayload::ccch__mode__req()
{
if (union_selection != ALT_ccch__mode__req) {
clean_up();
field_ccch__mode__req = new L1ctlCcchModeReq;
union_selection = ALT_ccch__mode__req;
}
return *field_ccch__mode__req;
}

const L1ctlCcchModeReq& L1ctlMsgPayload::ccch__mode__req() const
{
if (union_selection != ALT_ccch__mode__req) TTCN_error("Using non-selected field ccch_mode_req in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_ccch__mode__req;
}

L1ctlCcchModeConf& L1ctlMsgPayload::ccch__mode__conf()
{
if (union_selection != ALT_ccch__mode__conf) {
clean_up();
field_ccch__mode__conf = new L1ctlCcchModeConf;
union_selection = ALT_ccch__mode__conf;
}
return *field_ccch__mode__conf;
}

const L1ctlCcchModeConf& L1ctlMsgPayload::ccch__mode__conf() const
{
if (union_selection != ALT_ccch__mode__conf) TTCN_error("Using non-selected field ccch_mode_conf in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_ccch__mode__conf;
}

L1ctlParReq& L1ctlMsgPayload::par__req()
{
if (union_selection != ALT_par__req) {
clean_up();
field_par__req = new L1ctlParReq;
union_selection = ALT_par__req;
}
return *field_par__req;
}

const L1ctlParReq& L1ctlMsgPayload::par__req() const
{
if (union_selection != ALT_par__req) TTCN_error("Using non-selected field par_req in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_par__req;
}

L1CtlCryptoReq& L1ctlMsgPayload::crypto__req()
{
if (union_selection != ALT_crypto__req) {
clean_up();
field_crypto__req = new L1CtlCryptoReq;
union_selection = ALT_crypto__req;
}
return *field_crypto__req;
}

const L1CtlCryptoReq& L1ctlMsgPayload::crypto__req() const
{
if (union_selection != ALT_crypto__req) TTCN_error("Using non-selected field crypto_req in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_crypto__req;
}

L1ctlTchModeReq& L1ctlMsgPayload::tch__mode__req()
{
if (union_selection != ALT_tch__mode__req) {
clean_up();
field_tch__mode__req = new L1ctlTchModeReq;
union_selection = ALT_tch__mode__req;
}
return *field_tch__mode__req;
}

const L1ctlTchModeReq& L1ctlMsgPayload::tch__mode__req() const
{
if (union_selection != ALT_tch__mode__req) TTCN_error("Using non-selected field tch_mode_req in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_tch__mode__req;
}

L1ctlTchModeConf& L1ctlMsgPayload::tch__mode__conf()
{
if (union_selection != ALT_tch__mode__conf) {
clean_up();
field_tch__mode__conf = new L1ctlTchModeConf;
union_selection = ALT_tch__mode__conf;
}
return *field_tch__mode__conf;
}

const L1ctlTchModeConf& L1ctlMsgPayload::tch__mode__conf() const
{
if (union_selection != ALT_tch__mode__conf) TTCN_error("Using non-selected field tch_mode_conf in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_tch__mode__conf;
}

L1ctlTrafficReq& L1ctlMsgPayload::traffic__req()
{
if (union_selection != ALT_traffic__req) {
clean_up();
field_traffic__req = new L1ctlTrafficReq;
union_selection = ALT_traffic__req;
}
return *field_traffic__req;
}

const L1ctlTrafficReq& L1ctlMsgPayload::traffic__req() const
{
if (union_selection != ALT_traffic__req) TTCN_error("Using non-selected field traffic_req in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_traffic__req;
}

L1ctlTrafficReq& L1ctlMsgPayload::traffic__ind()
{
if (union_selection != ALT_traffic__ind) {
clean_up();
field_traffic__ind = new L1ctlTrafficReq;
union_selection = ALT_traffic__ind;
}
return *field_traffic__ind;
}

const L1ctlTrafficReq& L1ctlMsgPayload::traffic__ind() const
{
if (union_selection != ALT_traffic__ind) TTCN_error("Using non-selected field traffic_ind in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_traffic__ind;
}

L1ctlGprsUlTbfCfgReq& L1ctlMsgPayload::ul__tbf__cfg__req()
{
if (union_selection != ALT_ul__tbf__cfg__req) {
clean_up();
field_ul__tbf__cfg__req = new L1ctlGprsUlTbfCfgReq;
union_selection = ALT_ul__tbf__cfg__req;
}
return *field_ul__tbf__cfg__req;
}

const L1ctlGprsUlTbfCfgReq& L1ctlMsgPayload::ul__tbf__cfg__req() const
{
if (union_selection != ALT_ul__tbf__cfg__req) TTCN_error("Using non-selected field ul_tbf_cfg_req in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_ul__tbf__cfg__req;
}

L1ctlGprsDlTbfCfgReq& L1ctlMsgPayload::dl__tbf__cfg__req()
{
if (union_selection != ALT_dl__tbf__cfg__req) {
clean_up();
field_dl__tbf__cfg__req = new L1ctlGprsDlTbfCfgReq;
union_selection = ALT_dl__tbf__cfg__req;
}
return *field_dl__tbf__cfg__req;
}

const L1ctlGprsDlTbfCfgReq& L1ctlMsgPayload::dl__tbf__cfg__req() const
{
if (union_selection != ALT_dl__tbf__cfg__req) TTCN_error("Using non-selected field dl_tbf_cfg_req in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_dl__tbf__cfg__req;
}

L1ctlGprsUlBlockReq& L1ctlMsgPayload::ul__block__req()
{
if (union_selection != ALT_ul__block__req) {
clean_up();
field_ul__block__req = new L1ctlGprsUlBlockReq;
union_selection = ALT_ul__block__req;
}
return *field_ul__block__req;
}

const L1ctlGprsUlBlockReq& L1ctlMsgPayload::ul__block__req() const
{
if (union_selection != ALT_ul__block__req) TTCN_error("Using non-selected field ul_block_req in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_ul__block__req;
}

L1ctlGprsUlBlockCnf& L1ctlMsgPayload::ul__block__cnf()
{
if (union_selection != ALT_ul__block__cnf) {
clean_up();
field_ul__block__cnf = new L1ctlGprsUlBlockCnf;
union_selection = ALT_ul__block__cnf;
}
return *field_ul__block__cnf;
}

const L1ctlGprsUlBlockCnf& L1ctlMsgPayload::ul__block__cnf() const
{
if (union_selection != ALT_ul__block__cnf) TTCN_error("Using non-selected field ul_block_cnf in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_ul__block__cnf;
}

L1ctlGprsDlBlockInd& L1ctlMsgPayload::dl__block__ind()
{
if (union_selection != ALT_dl__block__ind) {
clean_up();
field_dl__block__ind = new L1ctlGprsDlBlockInd;
union_selection = ALT_dl__block__ind;
}
return *field_dl__block__ind;
}

const L1ctlGprsDlBlockInd& L1ctlMsgPayload::dl__block__ind() const
{
if (union_selection != ALT_dl__block__ind) TTCN_error("Using non-selected field dl_block_ind in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_dl__block__ind;
}

L1ctlExtRachReq& L1ctlMsgPayload::ext__rach__req()
{
if (union_selection != ALT_ext__rach__req) {
clean_up();
field_ext__rach__req = new L1ctlExtRachReq;
union_selection = ALT_ext__rach__req;
}
return *field_ext__rach__req;
}

const L1ctlExtRachReq& L1ctlMsgPayload::ext__rach__req() const
{
if (union_selection != ALT_ext__rach__req) TTCN_error("Using non-selected field ext_rach_req in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_ext__rach__req;
}

L1ctlGprsRtsInd& L1ctlMsgPayload::rts__ind()
{
if (union_selection != ALT_rts__ind) {
clean_up();
field_rts__ind = new L1ctlGprsRtsInd;
union_selection = ALT_rts__ind;
}
return *field_rts__ind;
}

const L1ctlGprsRtsInd& L1ctlMsgPayload::rts__ind() const
{
if (union_selection != ALT_rts__ind) TTCN_error("Using non-selected field rts_ind in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_rts__ind;
}

OCTETSTRING& L1ctlMsgPayload::other()
{
if (union_selection != ALT_other) {
clean_up();
field_other = new OCTETSTRING;
union_selection = ALT_other;
}
return *field_other;
}

const OCTETSTRING& L1ctlMsgPayload::other() const
{
if (union_selection != ALT_other) TTCN_error("Using non-selected field other in a value of union type @L1CTL_Types.L1ctlMsgPayload.");
return *field_other;
}

boolean L1ctlMsgPayload::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @L1CTL_Types.L1ctlMsgPayload.");
return union_selection == checked_selection;
}

boolean L1ctlMsgPayload::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean L1ctlMsgPayload::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_fbsb__req: return field_fbsb__req->is_value();
case ALT_fbsb__conf: return field_fbsb__conf->is_value();
case ALT_data__ind: return field_data__ind->is_value();
case ALT_rach__req: return field_rach__req->is_value();
case ALT_dm__est__req: return field_dm__est__req->is_value();
case ALT_data__req: return field_data__req->is_value();
case ALT_reset__req: return field_reset__req->is_value();
case ALT_ccch__mode__req: return field_ccch__mode__req->is_value();
case ALT_ccch__mode__conf: return field_ccch__mode__conf->is_value();
case ALT_par__req: return field_par__req->is_value();
case ALT_crypto__req: return field_crypto__req->is_value();
case ALT_tch__mode__req: return field_tch__mode__req->is_value();
case ALT_tch__mode__conf: return field_tch__mode__conf->is_value();
case ALT_traffic__req: return field_traffic__req->is_value();
case ALT_traffic__ind: return field_traffic__ind->is_value();
case ALT_ul__tbf__cfg__req: return field_ul__tbf__cfg__req->is_value();
case ALT_dl__tbf__cfg__req: return field_dl__tbf__cfg__req->is_value();
case ALT_ul__block__req: return field_ul__block__req->is_value();
case ALT_ul__block__cnf: return field_ul__block__cnf->is_value();
case ALT_dl__block__ind: return field_dl__block__ind->is_value();
case ALT_ext__rach__req: return field_ext__rach__req->is_value();
case ALT_rts__ind: return field_rts__ind->is_value();
case ALT_other: return field_other->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void L1ctlMsgPayload::clean_up()
{
switch (union_selection) {
case ALT_fbsb__req:
  delete field_fbsb__req;
  break;
case ALT_fbsb__conf:
  delete field_fbsb__conf;
  break;
case ALT_data__ind:
  delete field_data__ind;
  break;
case ALT_rach__req:
  delete field_rach__req;
  break;
case ALT_dm__est__req:
  delete field_dm__est__req;
  break;
case ALT_data__req:
  delete field_data__req;
  break;
case ALT_reset__req:
  delete field_reset__req;
  break;
case ALT_ccch__mode__req:
  delete field_ccch__mode__req;
  break;
case ALT_ccch__mode__conf:
  delete field_ccch__mode__conf;
  break;
case ALT_par__req:
  delete field_par__req;
  break;
case ALT_crypto__req:
  delete field_crypto__req;
  break;
case ALT_tch__mode__req:
  delete field_tch__mode__req;
  break;
case ALT_tch__mode__conf:
  delete field_tch__mode__conf;
  break;
case ALT_traffic__req:
  delete field_traffic__req;
  break;
case ALT_traffic__ind:
  delete field_traffic__ind;
  break;
case ALT_ul__tbf__cfg__req:
  delete field_ul__tbf__cfg__req;
  break;
case ALT_dl__tbf__cfg__req:
  delete field_dl__tbf__cfg__req;
  break;
case ALT_ul__block__req:
  delete field_ul__block__req;
  break;
case ALT_ul__block__cnf:
  delete field_ul__block__cnf;
  break;
case ALT_dl__block__ind:
  delete field_dl__block__ind;
  break;
case ALT_ext__rach__req:
  delete field_ext__rach__req;
  break;
case ALT_rts__ind:
  delete field_rts__ind;
  break;
case ALT_other:
  delete field_other;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void L1ctlMsgPayload::log() const
{
switch (union_selection) {
case ALT_fbsb__req:
TTCN_Logger::log_event_str("{ fbsb_req := ");
field_fbsb__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_fbsb__conf:
TTCN_Logger::log_event_str("{ fbsb_conf := ");
field_fbsb__conf->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_data__ind:
TTCN_Logger::log_event_str("{ data_ind := ");
field_data__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_rach__req:
TTCN_Logger::log_event_str("{ rach_req := ");
field_rach__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_dm__est__req:
TTCN_Logger::log_event_str("{ dm_est_req := ");
field_dm__est__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_data__req:
TTCN_Logger::log_event_str("{ data_req := ");
field_data__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_reset__req:
TTCN_Logger::log_event_str("{ reset_req := ");
field_reset__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ccch__mode__req:
TTCN_Logger::log_event_str("{ ccch_mode_req := ");
field_ccch__mode__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ccch__mode__conf:
TTCN_Logger::log_event_str("{ ccch_mode_conf := ");
field_ccch__mode__conf->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_par__req:
TTCN_Logger::log_event_str("{ par_req := ");
field_par__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_crypto__req:
TTCN_Logger::log_event_str("{ crypto_req := ");
field_crypto__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_tch__mode__req:
TTCN_Logger::log_event_str("{ tch_mode_req := ");
field_tch__mode__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_tch__mode__conf:
TTCN_Logger::log_event_str("{ tch_mode_conf := ");
field_tch__mode__conf->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_traffic__req:
TTCN_Logger::log_event_str("{ traffic_req := ");
field_traffic__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_traffic__ind:
TTCN_Logger::log_event_str("{ traffic_ind := ");
field_traffic__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ul__tbf__cfg__req:
TTCN_Logger::log_event_str("{ ul_tbf_cfg_req := ");
field_ul__tbf__cfg__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_dl__tbf__cfg__req:
TTCN_Logger::log_event_str("{ dl_tbf_cfg_req := ");
field_dl__tbf__cfg__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ul__block__req:
TTCN_Logger::log_event_str("{ ul_block_req := ");
field_ul__block__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ul__block__cnf:
TTCN_Logger::log_event_str("{ ul_block_cnf := ");
field_ul__block__cnf->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_dl__block__ind:
TTCN_Logger::log_event_str("{ dl_block_ind := ");
field_dl__block__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ext__rach__req:
TTCN_Logger::log_event_str("{ ext_rach_req := ");
field_ext__rach__req->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_rts__ind:
TTCN_Logger::log_event_str("{ rts_ind := ");
field_rts__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_other:
TTCN_Logger::log_event_str("{ other := ");
field_other->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void L1ctlMsgPayload::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "fbsb_req")) {
    fbsb__req().set_param(*mp_last);
    if (!fbsb__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "fbsb_conf")) {
    fbsb__conf().set_param(*mp_last);
    if (!fbsb__conf().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "data_ind")) {
    data__ind().set_param(*mp_last);
    if (!data__ind().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "rach_req")) {
    rach__req().set_param(*mp_last);
    if (!rach__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "dm_est_req")) {
    dm__est__req().set_param(*mp_last);
    if (!dm__est__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "data_req")) {
    data__req().set_param(*mp_last);
    if (!data__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "reset_req")) {
    reset__req().set_param(*mp_last);
    if (!reset__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ccch_mode_req")) {
    ccch__mode__req().set_param(*mp_last);
    if (!ccch__mode__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ccch_mode_conf")) {
    ccch__mode__conf().set_param(*mp_last);
    if (!ccch__mode__conf().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "par_req")) {
    par__req().set_param(*mp_last);
    if (!par__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "crypto_req")) {
    crypto__req().set_param(*mp_last);
    if (!crypto__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "tch_mode_req")) {
    tch__mode__req().set_param(*mp_last);
    if (!tch__mode__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "tch_mode_conf")) {
    tch__mode__conf().set_param(*mp_last);
    if (!tch__mode__conf().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "traffic_req")) {
    traffic__req().set_param(*mp_last);
    if (!traffic__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "traffic_ind")) {
    traffic__ind().set_param(*mp_last);
    if (!traffic__ind().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ul_tbf_cfg_req")) {
    ul__tbf__cfg__req().set_param(*mp_last);
    if (!ul__tbf__cfg__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "dl_tbf_cfg_req")) {
    dl__tbf__cfg__req().set_param(*mp_last);
    if (!dl__tbf__cfg__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ul_block_req")) {
    ul__block__req().set_param(*mp_last);
    if (!ul__block__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ul_block_cnf")) {
    ul__block__cnf().set_param(*mp_last);
    if (!ul__block__cnf().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "dl_block_ind")) {
    dl__block__ind().set_param(*mp_last);
    if (!dl__block__ind().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ext_rach_req")) {
    ext__rach__req().set_param(*mp_last);
    if (!ext__rach__req().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "rts_ind")) {
    rts__ind().set_param(*mp_last);
    if (!rts__ind().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "other")) {
    other().set_param(*mp_last);
    if (!other().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @L1CTL_Types.L1ctlMsgPayload.", last_name);
}

void L1ctlMsgPayload::set_implicit_omit()
{
switch (union_selection) {
case ALT_fbsb__req:
field_fbsb__req->set_implicit_omit(); break;
case ALT_fbsb__conf:
field_fbsb__conf->set_implicit_omit(); break;
case ALT_data__ind:
field_data__ind->set_implicit_omit(); break;
case ALT_rach__req:
field_rach__req->set_implicit_omit(); break;
case ALT_dm__est__req:
field_dm__est__req->set_implicit_omit(); break;
case ALT_data__req:
field_data__req->set_implicit_omit(); break;
case ALT_reset__req:
field_reset__req->set_implicit_omit(); break;
case ALT_ccch__mode__req:
field_ccch__mode__req->set_implicit_omit(); break;
case ALT_ccch__mode__conf:
field_ccch__mode__conf->set_implicit_omit(); break;
case ALT_par__req:
field_par__req->set_implicit_omit(); break;
case ALT_crypto__req:
field_crypto__req->set_implicit_omit(); break;
case ALT_tch__mode__req:
field_tch__mode__req->set_implicit_omit(); break;
case ALT_tch__mode__conf:
field_tch__mode__conf->set_implicit_omit(); break;
case ALT_traffic__req:
field_traffic__req->set_implicit_omit(); break;
case ALT_traffic__ind:
field_traffic__ind->set_implicit_omit(); break;
case ALT_ul__tbf__cfg__req:
field_ul__tbf__cfg__req->set_implicit_omit(); break;
case ALT_dl__tbf__cfg__req:
field_dl__tbf__cfg__req->set_implicit_omit(); break;
case ALT_ul__block__req:
field_ul__block__req->set_implicit_omit(); break;
case ALT_ul__block__cnf:
field_ul__block__cnf->set_implicit_omit(); break;
case ALT_dl__block__ind:
field_dl__block__ind->set_implicit_omit(); break;
case ALT_ext__rach__req:
field_ext__rach__req->set_implicit_omit(); break;
case ALT_rts__ind:
field_rts__ind->set_implicit_omit(); break;
case ALT_other:
field_other->set_implicit_omit(); break;
default: break;
}
}

void L1ctlMsgPayload::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_fbsb__req:
field_fbsb__req->encode_text(text_buf);
break;
case ALT_fbsb__conf:
field_fbsb__conf->encode_text(text_buf);
break;
case ALT_data__ind:
field_data__ind->encode_text(text_buf);
break;
case ALT_rach__req:
field_rach__req->encode_text(text_buf);
break;
case ALT_dm__est__req:
field_dm__est__req->encode_text(text_buf);
break;
case ALT_data__req:
field_data__req->encode_text(text_buf);
break;
case ALT_reset__req:
field_reset__req->encode_text(text_buf);
break;
case ALT_ccch__mode__req:
field_ccch__mode__req->encode_text(text_buf);
break;
case ALT_ccch__mode__conf:
field_ccch__mode__conf->encode_text(text_buf);
break;
case ALT_par__req:
field_par__req->encode_text(text_buf);
break;
case ALT_crypto__req:
field_crypto__req->encode_text(text_buf);
break;
case ALT_tch__mode__req:
field_tch__mode__req->encode_text(text_buf);
break;
case ALT_tch__mode__conf:
field_tch__mode__conf->encode_text(text_buf);
break;
case ALT_traffic__req:
field_traffic__req->encode_text(text_buf);
break;
case ALT_traffic__ind:
field_traffic__ind->encode_text(text_buf);
break;
case ALT_ul__tbf__cfg__req:
field_ul__tbf__cfg__req->encode_text(text_buf);
break;
case ALT_dl__tbf__cfg__req:
field_dl__tbf__cfg__req->encode_text(text_buf);
break;
case ALT_ul__block__req:
field_ul__block__req->encode_text(text_buf);
break;
case ALT_ul__block__cnf:
field_ul__block__cnf->encode_text(text_buf);
break;
case ALT_dl__block__ind:
field_dl__block__ind->encode_text(text_buf);
break;
case ALT_ext__rach__req:
field_ext__rach__req->encode_text(text_buf);
break;
case ALT_rts__ind:
field_rts__ind->encode_text(text_buf);
break;
case ALT_other:
field_other->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @L1CTL_Types.L1ctlMsgPayload.");
}
}

void L1ctlMsgPayload::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_fbsb__req:
fbsb__req().decode_text(text_buf);
break;
case ALT_fbsb__conf:
fbsb__conf().decode_text(text_buf);
break;
case ALT_data__ind:
data__ind().decode_text(text_buf);
break;
case ALT_rach__req:
rach__req().decode_text(text_buf);
break;
case ALT_dm__est__req:
dm__est__req().decode_text(text_buf);
break;
case ALT_data__req:
data__req().decode_text(text_buf);
break;
case ALT_reset__req:
reset__req().decode_text(text_buf);
break;
case ALT_ccch__mode__req:
ccch__mode__req().decode_text(text_buf);
break;
case ALT_ccch__mode__conf:
ccch__mode__conf().decode_text(text_buf);
break;
case ALT_par__req:
par__req().decode_text(text_buf);
break;
case ALT_crypto__req:
crypto__req().decode_text(text_buf);
break;
case ALT_tch__mode__req:
tch__mode__req().decode_text(text_buf);
break;
case ALT_tch__mode__conf:
tch__mode__conf().decode_text(text_buf);
break;
case ALT_traffic__req:
traffic__req().decode_text(text_buf);
break;
case ALT_traffic__ind:
traffic__ind().decode_text(text_buf);
break;
case ALT_ul__tbf__cfg__req:
ul__tbf__cfg__req().decode_text(text_buf);
break;
case ALT_dl__tbf__cfg__req:
dl__tbf__cfg__req().decode_text(text_buf);
break;
case ALT_ul__block__req:
ul__block__req().decode_text(text_buf);
break;
case ALT_ul__block__cnf:
ul__block__cnf().decode_text(text_buf);
break;
case ALT_dl__block__ind:
dl__block__ind().decode_text(text_buf);
break;
case ALT_ext__rach__req:
ext__rach__req().decode_text(text_buf);
break;
case ALT_rts__ind:
rts__ind().decode_text(text_buf);
break;
case ALT_other:
other().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @L1CTL_Types.L1ctlMsgPayload.");
}
}

void L1ctlMsgPayload::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void L1ctlMsgPayload::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int L1ctlMsgPayload::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, L1ctlFbsbReq_descr_.raw->forceomit);
      decoded_length = fbsb__req().RAW_decode(L1ctlFbsbReq_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, L1ctlFbsbConf_descr_.raw->forceomit);
      decoded_length = fbsb__conf().RAW_decode(L1ctlFbsbConf_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, L1ctlDataInd_descr_.raw->forceomit);
      decoded_length = data__ind().RAW_decode(L1ctlDataInd_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 3: {
      RAW_Force_Omit field_force_omit(3, force_omit, L1ctlRachReq_descr_.raw->forceomit);
      decoded_length = rach__req().RAW_decode(L1ctlRachReq_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 4: {
      RAW_Force_Omit field_force_omit(4, force_omit, L1ctlDmEstReq_descr_.raw->forceomit);
      decoded_length = dm__est__req().RAW_decode(L1ctlDmEstReq_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 5: {
      RAW_Force_Omit field_force_omit(5, force_omit, L1ctlDataReq_descr_.raw->forceomit);
      decoded_length = data__req().RAW_decode(L1ctlDataReq_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 6: {
      RAW_Force_Omit field_force_omit(6, force_omit, L1ctlReset_descr_.raw->forceomit);
      decoded_length = reset__req().RAW_decode(L1ctlReset_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 7: {
      RAW_Force_Omit field_force_omit(7, force_omit, L1ctlCcchModeReq_descr_.raw->forceomit);
      decoded_length = ccch__mode__req().RAW_decode(L1ctlCcchModeReq_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 8: {
      RAW_Force_Omit field_force_omit(8, force_omit, L1ctlCcchModeConf_descr_.raw->forceomit);
      decoded_length = ccch__mode__conf().RAW_decode(L1ctlCcchModeConf_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 9: {
      RAW_Force_Omit field_force_omit(9, force_omit, L1ctlParReq_descr_.raw->forceomit);
      decoded_length = par__req().RAW_decode(L1ctlParReq_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 10: {
      RAW_Force_Omit field_force_omit(10, force_omit, L1CtlCryptoReq_descr_.raw->forceomit);
      decoded_length = crypto__req().RAW_decode(L1CtlCryptoReq_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 11: {
      RAW_Force_Omit field_force_omit(11, force_omit, L1ctlTchModeReq_descr_.raw->forceomit);
      decoded_length = tch__mode__req().RAW_decode(L1ctlTchModeReq_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 12: {
      RAW_Force_Omit field_force_omit(12, force_omit, L1ctlTchModeConf_descr_.raw->forceomit);
      decoded_length = tch__mode__conf().RAW_decode(L1ctlTchModeConf_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 13: {
      RAW_Force_Omit field_force_omit(13, force_omit, L1ctlTrafficReq_descr_.raw->forceomit);
      decoded_length = traffic__req().RAW_decode(L1ctlTrafficReq_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 14: {
      RAW_Force_Omit field_force_omit(14, force_omit, L1ctlTrafficReq_descr_.raw->forceomit);
      decoded_length = traffic__ind().RAW_decode(L1ctlTrafficReq_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 15: {
      RAW_Force_Omit field_force_omit(15, force_omit, L1ctlGprsUlTbfCfgReq_descr_.raw->forceomit);
      decoded_length = ul__tbf__cfg__req().RAW_decode(L1ctlGprsUlTbfCfgReq_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 16: {
      RAW_Force_Omit field_force_omit(16, force_omit, L1ctlGprsDlTbfCfgReq_descr_.raw->forceomit);
      decoded_length = dl__tbf__cfg__req().RAW_decode(L1ctlGprsDlTbfCfgReq_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 17: {
      RAW_Force_Omit field_force_omit(17, force_omit, L1ctlGprsUlBlockReq_descr_.raw->forceomit);
      decoded_length = ul__block__req().RAW_decode(L1ctlGprsUlBlockReq_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 18: {
      RAW_Force_Omit field_force_omit(18, force_omit, L1ctlGprsUlBlockCnf_descr_.raw->forceomit);
      decoded_length = ul__block__cnf().RAW_decode(L1ctlGprsUlBlockCnf_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 19: {
      RAW_Force_Omit field_force_omit(19, force_omit, L1ctlGprsDlBlockInd_descr_.raw->forceomit);
      decoded_length = dl__block__ind().RAW_decode(L1ctlGprsDlBlockInd_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 20: {
      RAW_Force_Omit field_force_omit(20, force_omit, L1ctlExtRachReq_descr_.raw->forceomit);
      decoded_length = ext__rach__req().RAW_decode(L1ctlExtRachReq_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 21: {
      RAW_Force_Omit field_force_omit(21, force_omit, L1ctlGprsRtsInd_descr_.raw->forceomit);
      decoded_length = rts__ind().RAW_decode(L1ctlGprsRtsInd_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 22: {
      RAW_Force_Omit field_force_omit(22, force_omit, L1ctlMsgPayload_other_descr_.raw->forceomit);
      decoded_length = other().RAW_decode(L1ctlMsgPayload_other_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, L1ctlFbsbReq_descr_.raw->forceomit);
      decoded_length = fbsb__req().RAW_decode(L1ctlFbsbReq_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, L1ctlFbsbConf_descr_.raw->forceomit);
      decoded_length = fbsb__conf().RAW_decode(L1ctlFbsbConf_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_2_force_omit(2, force_omit, L1ctlDataInd_descr_.raw->forceomit);
      decoded_length = data__ind().RAW_decode(L1ctlDataInd_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_2_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_3_force_omit(3, force_omit, L1ctlRachReq_descr_.raw->forceomit);
      decoded_length = rach__req().RAW_decode(L1ctlRachReq_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_3_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_4_force_omit(4, force_omit, L1ctlDmEstReq_descr_.raw->forceomit);
      decoded_length = dm__est__req().RAW_decode(L1ctlDmEstReq_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_4_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_5_force_omit(5, force_omit, L1ctlDataReq_descr_.raw->forceomit);
      decoded_length = data__req().RAW_decode(L1ctlDataReq_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_5_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_6_force_omit(6, force_omit, L1ctlReset_descr_.raw->forceomit);
      decoded_length = reset__req().RAW_decode(L1ctlReset_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_6_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_7_force_omit(7, force_omit, L1ctlCcchModeReq_descr_.raw->forceomit);
      decoded_length = ccch__mode__req().RAW_decode(L1ctlCcchModeReq_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_7_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_8_force_omit(8, force_omit, L1ctlCcchModeConf_descr_.raw->forceomit);
      decoded_length = ccch__mode__conf().RAW_decode(L1ctlCcchModeConf_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_8_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_9_force_omit(9, force_omit, L1ctlParReq_descr_.raw->forceomit);
      decoded_length = par__req().RAW_decode(L1ctlParReq_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_9_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_10_force_omit(10, force_omit, L1CtlCryptoReq_descr_.raw->forceomit);
      decoded_length = crypto__req().RAW_decode(L1CtlCryptoReq_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_10_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_11_force_omit(11, force_omit, L1ctlTchModeReq_descr_.raw->forceomit);
      decoded_length = tch__mode__req().RAW_decode(L1ctlTchModeReq_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_11_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_12_force_omit(12, force_omit, L1ctlTchModeConf_descr_.raw->forceomit);
      decoded_length = tch__mode__conf().RAW_decode(L1ctlTchModeConf_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_12_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_13_force_omit(13, force_omit, L1ctlTrafficReq_descr_.raw->forceomit);
      decoded_length = traffic__req().RAW_decode(L1ctlTrafficReq_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_13_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_14_force_omit(14, force_omit, L1ctlTrafficReq_descr_.raw->forceomit);
      decoded_length = traffic__ind().RAW_decode(L1ctlTrafficReq_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_14_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_15_force_omit(15, force_omit, L1ctlGprsUlTbfCfgReq_descr_.raw->forceomit);
      decoded_length = ul__tbf__cfg__req().RAW_decode(L1ctlGprsUlTbfCfgReq_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_15_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_16_force_omit(16, force_omit, L1ctlGprsDlTbfCfgReq_descr_.raw->forceomit);
      decoded_length = dl__tbf__cfg__req().RAW_decode(L1ctlGprsDlTbfCfgReq_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_16_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_17_force_omit(17, force_omit, L1ctlGprsUlBlockReq_descr_.raw->forceomit);
      decoded_length = ul__block__req().RAW_decode(L1ctlGprsUlBlockReq_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_17_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_18_force_omit(18, force_omit, L1ctlGprsUlBlockCnf_descr_.raw->forceomit);
      decoded_length = ul__block__cnf().RAW_decode(L1ctlGprsUlBlockCnf_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_18_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_19_force_omit(19, force_omit, L1ctlGprsDlBlockInd_descr_.raw->forceomit);
      decoded_length = dl__block__ind().RAW_decode(L1ctlGprsDlBlockInd_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_19_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_20_force_omit(20, force_omit, L1ctlExtRachReq_descr_.raw->forceomit);
      decoded_length = ext__rach__req().RAW_decode(L1ctlExtRachReq_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_20_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_21_force_omit(21, force_omit, L1ctlGprsRtsInd_descr_.raw->forceomit);
      decoded_length = rts__ind().RAW_decode(L1ctlGprsRtsInd_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_21_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_22_force_omit(22, force_omit, L1ctlMsgPayload_other_descr_.raw->forceomit);
      decoded_length = other().RAW_decode(L1ctlMsgPayload_other_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_22_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int L1ctlMsgPayload::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 23;  myleaf.body.node.nodes = init_nodes_of_enc_tree(23);
  memset(myleaf.body.node.nodes, 0, 23 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_fbsb__req:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, L1ctlFbsbReq_descr_.raw);
    encoded_length = field_fbsb__req->RAW_encode(L1ctlFbsbReq_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &L1ctlFbsbReq_descr_;
    break;
  case ALT_fbsb__conf:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, L1ctlFbsbConf_descr_.raw);
    encoded_length = field_fbsb__conf->RAW_encode(L1ctlFbsbConf_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &L1ctlFbsbConf_descr_;
    break;
  case ALT_data__ind:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, L1ctlDataInd_descr_.raw);
    encoded_length = field_data__ind->RAW_encode(L1ctlDataInd_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &L1ctlDataInd_descr_;
    break;
  case ALT_rach__req:
    myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 3, L1ctlRachReq_descr_.raw);
    encoded_length = field_rach__req->RAW_encode(L1ctlRachReq_descr_, *myleaf.body.node.nodes[3]);
    myleaf.body.node.nodes[3]->coding_descr = &L1ctlRachReq_descr_;
    break;
  case ALT_dm__est__req:
    myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 4, L1ctlDmEstReq_descr_.raw);
    encoded_length = field_dm__est__req->RAW_encode(L1ctlDmEstReq_descr_, *myleaf.body.node.nodes[4]);
    myleaf.body.node.nodes[4]->coding_descr = &L1ctlDmEstReq_descr_;
    break;
  case ALT_data__req:
    myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 5, L1ctlDataReq_descr_.raw);
    encoded_length = field_data__req->RAW_encode(L1ctlDataReq_descr_, *myleaf.body.node.nodes[5]);
    myleaf.body.node.nodes[5]->coding_descr = &L1ctlDataReq_descr_;
    break;
  case ALT_reset__req:
    myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 6, L1ctlReset_descr_.raw);
    encoded_length = field_reset__req->RAW_encode(L1ctlReset_descr_, *myleaf.body.node.nodes[6]);
    myleaf.body.node.nodes[6]->coding_descr = &L1ctlReset_descr_;
    break;
  case ALT_ccch__mode__req:
    myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 7, L1ctlCcchModeReq_descr_.raw);
    encoded_length = field_ccch__mode__req->RAW_encode(L1ctlCcchModeReq_descr_, *myleaf.body.node.nodes[7]);
    myleaf.body.node.nodes[7]->coding_descr = &L1ctlCcchModeReq_descr_;
    break;
  case ALT_ccch__mode__conf:
    myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 8, L1ctlCcchModeConf_descr_.raw);
    encoded_length = field_ccch__mode__conf->RAW_encode(L1ctlCcchModeConf_descr_, *myleaf.body.node.nodes[8]);
    myleaf.body.node.nodes[8]->coding_descr = &L1ctlCcchModeConf_descr_;
    break;
  case ALT_par__req:
    myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 9, L1ctlParReq_descr_.raw);
    encoded_length = field_par__req->RAW_encode(L1ctlParReq_descr_, *myleaf.body.node.nodes[9]);
    myleaf.body.node.nodes[9]->coding_descr = &L1ctlParReq_descr_;
    break;
  case ALT_crypto__req:
    myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 10, L1CtlCryptoReq_descr_.raw);
    encoded_length = field_crypto__req->RAW_encode(L1CtlCryptoReq_descr_, *myleaf.body.node.nodes[10]);
    myleaf.body.node.nodes[10]->coding_descr = &L1CtlCryptoReq_descr_;
    break;
  case ALT_tch__mode__req:
    myleaf.body.node.nodes[11] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 11, L1ctlTchModeReq_descr_.raw);
    encoded_length = field_tch__mode__req->RAW_encode(L1ctlTchModeReq_descr_, *myleaf.body.node.nodes[11]);
    myleaf.body.node.nodes[11]->coding_descr = &L1ctlTchModeReq_descr_;
    break;
  case ALT_tch__mode__conf:
    myleaf.body.node.nodes[12] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 12, L1ctlTchModeConf_descr_.raw);
    encoded_length = field_tch__mode__conf->RAW_encode(L1ctlTchModeConf_descr_, *myleaf.body.node.nodes[12]);
    myleaf.body.node.nodes[12]->coding_descr = &L1ctlTchModeConf_descr_;
    break;
  case ALT_traffic__req:
    myleaf.body.node.nodes[13] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 13, L1ctlTrafficReq_descr_.raw);
    encoded_length = field_traffic__req->RAW_encode(L1ctlTrafficReq_descr_, *myleaf.body.node.nodes[13]);
    myleaf.body.node.nodes[13]->coding_descr = &L1ctlTrafficReq_descr_;
    break;
  case ALT_traffic__ind:
    myleaf.body.node.nodes[14] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 14, L1ctlTrafficReq_descr_.raw);
    encoded_length = field_traffic__ind->RAW_encode(L1ctlTrafficReq_descr_, *myleaf.body.node.nodes[14]);
    myleaf.body.node.nodes[14]->coding_descr = &L1ctlTrafficReq_descr_;
    break;
  case ALT_ul__tbf__cfg__req:
    myleaf.body.node.nodes[15] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 15, L1ctlGprsUlTbfCfgReq_descr_.raw);
    encoded_length = field_ul__tbf__cfg__req->RAW_encode(L1ctlGprsUlTbfCfgReq_descr_, *myleaf.body.node.nodes[15]);
    myleaf.body.node.nodes[15]->coding_descr = &L1ctlGprsUlTbfCfgReq_descr_;
    break;
  case ALT_dl__tbf__cfg__req:
    myleaf.body.node.nodes[16] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 16, L1ctlGprsDlTbfCfgReq_descr_.raw);
    encoded_length = field_dl__tbf__cfg__req->RAW_encode(L1ctlGprsDlTbfCfgReq_descr_, *myleaf.body.node.nodes[16]);
    myleaf.body.node.nodes[16]->coding_descr = &L1ctlGprsDlTbfCfgReq_descr_;
    break;
  case ALT_ul__block__req:
    myleaf.body.node.nodes[17] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 17, L1ctlGprsUlBlockReq_descr_.raw);
    encoded_length = field_ul__block__req->RAW_encode(L1ctlGprsUlBlockReq_descr_, *myleaf.body.node.nodes[17]);
    myleaf.body.node.nodes[17]->coding_descr = &L1ctlGprsUlBlockReq_descr_;
    break;
  case ALT_ul__block__cnf:
    myleaf.body.node.nodes[18] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 18, L1ctlGprsUlBlockCnf_descr_.raw);
    encoded_length = field_ul__block__cnf->RAW_encode(L1ctlGprsUlBlockCnf_descr_, *myleaf.body.node.nodes[18]);
    myleaf.body.node.nodes[18]->coding_descr = &L1ctlGprsUlBlockCnf_descr_;
    break;
  case ALT_dl__block__ind:
    myleaf.body.node.nodes[19] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 19, L1ctlGprsDlBlockInd_descr_.raw);
    encoded_length = field_dl__block__ind->RAW_encode(L1ctlGprsDlBlockInd_descr_, *myleaf.body.node.nodes[19]);
    myleaf.body.node.nodes[19]->coding_descr = &L1ctlGprsDlBlockInd_descr_;
    break;
  case ALT_ext__rach__req:
    myleaf.body.node.nodes[20] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 20, L1ctlExtRachReq_descr_.raw);
    encoded_length = field_ext__rach__req->RAW_encode(L1ctlExtRachReq_descr_, *myleaf.body.node.nodes[20]);
    myleaf.body.node.nodes[20]->coding_descr = &L1ctlExtRachReq_descr_;
    break;
  case ALT_rts__ind:
    myleaf.body.node.nodes[21] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 21, L1ctlGprsRtsInd_descr_.raw);
    encoded_length = field_rts__ind->RAW_encode(L1ctlGprsRtsInd_descr_, *myleaf.body.node.nodes[21]);
    myleaf.body.node.nodes[21]->coding_descr = &L1ctlGprsRtsInd_descr_;
    break;
  case ALT_other:
    myleaf.body.node.nodes[22] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 22, L1ctlMsgPayload_other_descr_.raw);
    encoded_length = field_other->RAW_encode(L1ctlMsgPayload_other_descr_, *myleaf.body.node.nodes[22]);
    myleaf.body.node.nodes[22]->coding_descr = &L1ctlMsgPayload_other_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void L1ctlMsgPayload_template::copy_value(const L1ctlMsgPayload& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case L1ctlMsgPayload::ALT_fbsb__req:
single_value.field_fbsb__req = new L1ctlFbsbReq_template(other_value.fbsb__req());
break;
case L1ctlMsgPayload::ALT_fbsb__conf:
single_value.field_fbsb__conf = new L1ctlFbsbConf_template(other_value.fbsb__conf());
break;
case L1ctlMsgPayload::ALT_data__ind:
single_value.field_data__ind = new L1ctlDataInd_template(other_value.data__ind());
break;
case L1ctlMsgPayload::ALT_rach__req:
single_value.field_rach__req = new L1ctlRachReq_template(other_value.rach__req());
break;
case L1ctlMsgPayload::ALT_dm__est__req:
single_value.field_dm__est__req = new L1ctlDmEstReq_template(other_value.dm__est__req());
break;
case L1ctlMsgPayload::ALT_data__req:
single_value.field_data__req = new L1ctlDataReq_template(other_value.data__req());
break;
case L1ctlMsgPayload::ALT_reset__req:
single_value.field_reset__req = new L1ctlReset_template(other_value.reset__req());
break;
case L1ctlMsgPayload::ALT_ccch__mode__req:
single_value.field_ccch__mode__req = new L1ctlCcchModeReq_template(other_value.ccch__mode__req());
break;
case L1ctlMsgPayload::ALT_ccch__mode__conf:
single_value.field_ccch__mode__conf = new L1ctlCcchModeConf_template(other_value.ccch__mode__conf());
break;
case L1ctlMsgPayload::ALT_par__req:
single_value.field_par__req = new L1ctlParReq_template(other_value.par__req());
break;
case L1ctlMsgPayload::ALT_crypto__req:
single_value.field_crypto__req = new L1CtlCryptoReq_template(other_value.crypto__req());
break;
case L1ctlMsgPayload::ALT_tch__mode__req:
single_value.field_tch__mode__req = new L1ctlTchModeReq_template(other_value.tch__mode__req());
break;
case L1ctlMsgPayload::ALT_tch__mode__conf:
single_value.field_tch__mode__conf = new L1ctlTchModeConf_template(other_value.tch__mode__conf());
break;
case L1ctlMsgPayload::ALT_traffic__req:
single_value.field_traffic__req = new L1ctlTrafficReq_template(other_value.traffic__req());
break;
case L1ctlMsgPayload::ALT_traffic__ind:
single_value.field_traffic__ind = new L1ctlTrafficReq_template(other_value.traffic__ind());
break;
case L1ctlMsgPayload::ALT_ul__tbf__cfg__req:
single_value.field_ul__tbf__cfg__req = new L1ctlGprsUlTbfCfgReq_template(other_value.ul__tbf__cfg__req());
break;
case L1ctlMsgPayload::ALT_dl__tbf__cfg__req:
single_value.field_dl__tbf__cfg__req = new L1ctlGprsDlTbfCfgReq_template(other_value.dl__tbf__cfg__req());
break;
case L1ctlMsgPayload::ALT_ul__block__req:
single_value.field_ul__block__req = new L1ctlGprsUlBlockReq_template(other_value.ul__block__req());
break;
case L1ctlMsgPayload::ALT_ul__block__cnf:
single_value.field_ul__block__cnf = new L1ctlGprsUlBlockCnf_template(other_value.ul__block__cnf());
break;
case L1ctlMsgPayload::ALT_dl__block__ind:
single_value.field_dl__block__ind = new L1ctlGprsDlBlockInd_template(other_value.dl__block__ind());
break;
case L1ctlMsgPayload::ALT_ext__rach__req:
single_value.field_ext__rach__req = new L1ctlExtRachReq_template(other_value.ext__rach__req());
break;
case L1ctlMsgPayload::ALT_rts__ind:
single_value.field_rts__ind = new L1ctlGprsRtsInd_template(other_value.rts__ind());
break;
case L1ctlMsgPayload::ALT_other:
single_value.field_other = new OCTETSTRING_template(other_value.other());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @L1CTL_Types.L1ctlMsgPayload.");
}
set_selection(SPECIFIC_VALUE);
}

void L1ctlMsgPayload_template::copy_template(const L1ctlMsgPayload_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case L1ctlMsgPayload::ALT_fbsb__req:
single_value.field_fbsb__req = new L1ctlFbsbReq_template(*other_value.single_value.field_fbsb__req);
break;
case L1ctlMsgPayload::ALT_fbsb__conf:
single_value.field_fbsb__conf = new L1ctlFbsbConf_template(*other_value.single_value.field_fbsb__conf);
break;
case L1ctlMsgPayload::ALT_data__ind:
single_value.field_data__ind = new L1ctlDataInd_template(*other_value.single_value.field_data__ind);
break;
case L1ctlMsgPayload::ALT_rach__req:
single_value.field_rach__req = new L1ctlRachReq_template(*other_value.single_value.field_rach__req);
break;
case L1ctlMsgPayload::ALT_dm__est__req:
single_value.field_dm__est__req = new L1ctlDmEstReq_template(*other_value.single_value.field_dm__est__req);
break;
case L1ctlMsgPayload::ALT_data__req:
single_value.field_data__req = new L1ctlDataReq_template(*other_value.single_value.field_data__req);
break;
case L1ctlMsgPayload::ALT_reset__req:
single_value.field_reset__req = new L1ctlReset_template(*other_value.single_value.field_reset__req);
break;
case L1ctlMsgPayload::ALT_ccch__mode__req:
single_value.field_ccch__mode__req = new L1ctlCcchModeReq_template(*other_value.single_value.field_ccch__mode__req);
break;
case L1ctlMsgPayload::ALT_ccch__mode__conf:
single_value.field_ccch__mode__conf = new L1ctlCcchModeConf_template(*other_value.single_value.field_ccch__mode__conf);
break;
case L1ctlMsgPayload::ALT_par__req:
single_value.field_par__req = new L1ctlParReq_template(*other_value.single_value.field_par__req);
break;
case L1ctlMsgPayload::ALT_crypto__req:
single_value.field_crypto__req = new L1CtlCryptoReq_template(*other_value.single_value.field_crypto__req);
break;
case L1ctlMsgPayload::ALT_tch__mode__req:
single_value.field_tch__mode__req = new L1ctlTchModeReq_template(*other_value.single_value.field_tch__mode__req);
break;
case L1ctlMsgPayload::ALT_tch__mode__conf:
single_value.field_tch__mode__conf = new L1ctlTchModeConf_template(*other_value.single_value.field_tch__mode__conf);
break;
case L1ctlMsgPayload::ALT_traffic__req:
single_value.field_traffic__req = new L1ctlTrafficReq_template(*other_value.single_value.field_traffic__req);
break;
case L1ctlMsgPayload::ALT_traffic__ind:
single_value.field_traffic__ind = new L1ctlTrafficReq_template(*other_value.single_value.field_traffic__ind);
break;
case L1ctlMsgPayload::ALT_ul__tbf__cfg__req:
single_value.field_ul__tbf__cfg__req = new L1ctlGprsUlTbfCfgReq_template(*other_value.single_value.field_ul__tbf__cfg__req);
break;
case L1ctlMsgPayload::ALT_dl__tbf__cfg__req:
single_value.field_dl__tbf__cfg__req = new L1ctlGprsDlTbfCfgReq_template(*other_value.single_value.field_dl__tbf__cfg__req);
break;
case L1ctlMsgPayload::ALT_ul__block__req:
single_value.field_ul__block__req = new L1ctlGprsUlBlockReq_template(*other_value.single_value.field_ul__block__req);
break;
case L1ctlMsgPayload::ALT_ul__block__cnf:
single_value.field_ul__block__cnf = new L1ctlGprsUlBlockCnf_template(*other_value.single_value.field_ul__block__cnf);
break;
case L1ctlMsgPayload::ALT_dl__block__ind:
single_value.field_dl__block__ind = new L1ctlGprsDlBlockInd_template(*other_value.single_value.field_dl__block__ind);
break;
case L1ctlMsgPayload::ALT_ext__rach__req:
single_value.field_ext__rach__req = new L1ctlExtRachReq_template(*other_value.single_value.field_ext__rach__req);
break;
case L1ctlMsgPayload::ALT_rts__ind:
single_value.field_rts__ind = new L1ctlGprsRtsInd_template(*other_value.single_value.field_rts__ind);
break;
case L1ctlMsgPayload::ALT_other:
single_value.field_other = new OCTETSTRING_template(*other_value.single_value.field_other);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @L1CTL_Types.L1ctlMsgPayload.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new L1ctlMsgPayload_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new L1ctlMsgPayload_template(*other_value.implication_.precondition);
implication_.implied_template = new L1ctlMsgPayload_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @L1CTL_Types.L1ctlMsgPayload.");
}
set_selection(other_value);
}

L1ctlMsgPayload_template::L1ctlMsgPayload_template()
{
}

L1ctlMsgPayload_template::L1ctlMsgPayload_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

L1ctlMsgPayload_template::L1ctlMsgPayload_template(const L1ctlMsgPayload& other_value)
{
copy_value(other_value);
}

L1ctlMsgPayload_template::L1ctlMsgPayload_template(const OPTIONAL<L1ctlMsgPayload>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const L1ctlMsgPayload&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @L1CTL_Types.L1ctlMsgPayload from an unbound optional field.");
}
}

L1ctlMsgPayload_template::L1ctlMsgPayload_template(L1ctlMsgPayload_template* p_precondition, L1ctlMsgPayload_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

L1ctlMsgPayload_template::L1ctlMsgPayload_template(Dynamic_Match_Interface<L1ctlMsgPayload>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<L1ctlMsgPayload>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

L1ctlMsgPayload_template::L1ctlMsgPayload_template(const L1ctlMsgPayload_template& other_value)
: Base_Template(){
copy_template(other_value);
}

L1ctlMsgPayload_template::~L1ctlMsgPayload_template()
{
clean_up();
}

void L1ctlMsgPayload_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case L1ctlMsgPayload::ALT_fbsb__req:
delete single_value.field_fbsb__req;
break;
case L1ctlMsgPayload::ALT_fbsb__conf:
delete single_value.field_fbsb__conf;
break;
case L1ctlMsgPayload::ALT_data__ind:
delete single_value.field_data__ind;
break;
case L1ctlMsgPayload::ALT_rach__req:
delete single_value.field_rach__req;
break;
case L1ctlMsgPayload::ALT_dm__est__req:
delete single_value.field_dm__est__req;
break;
case L1ctlMsgPayload::ALT_data__req:
delete single_value.field_data__req;
break;
case L1ctlMsgPayload::ALT_reset__req:
delete single_value.field_reset__req;
break;
case L1ctlMsgPayload::ALT_ccch__mode__req:
delete single_value.field_ccch__mode__req;
break;
case L1ctlMsgPayload::ALT_ccch__mode__conf:
delete single_value.field_ccch__mode__conf;
break;
case L1ctlMsgPayload::ALT_par__req:
delete single_value.field_par__req;
break;
case L1ctlMsgPayload::ALT_crypto__req:
delete single_value.field_crypto__req;
break;
case L1ctlMsgPayload::ALT_tch__mode__req:
delete single_value.field_tch__mode__req;
break;
case L1ctlMsgPayload::ALT_tch__mode__conf:
delete single_value.field_tch__mode__conf;
break;
case L1ctlMsgPayload::ALT_traffic__req:
delete single_value.field_traffic__req;
break;
case L1ctlMsgPayload::ALT_traffic__ind:
delete single_value.field_traffic__ind;
break;
case L1ctlMsgPayload::ALT_ul__tbf__cfg__req:
delete single_value.field_ul__tbf__cfg__req;
break;
case L1ctlMsgPayload::ALT_dl__tbf__cfg__req:
delete single_value.field_dl__tbf__cfg__req;
break;
case L1ctlMsgPayload::ALT_ul__block__req:
delete single_value.field_ul__block__req;
break;
case L1ctlMsgPayload::ALT_ul__block__cnf:
delete single_value.field_ul__block__cnf;
break;
case L1ctlMsgPayload::ALT_dl__block__ind:
delete single_value.field_dl__block__ind;
break;
case L1ctlMsgPayload::ALT_ext__rach__req:
delete single_value.field_ext__rach__req;
break;
case L1ctlMsgPayload::ALT_rts__ind:
delete single_value.field_rts__ind;
break;
case L1ctlMsgPayload::ALT_other:
delete single_value.field_other;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

L1ctlMsgPayload_template& L1ctlMsgPayload_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

L1ctlMsgPayload_template& L1ctlMsgPayload_template::operator=(const L1ctlMsgPayload& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

L1ctlMsgPayload_template& L1ctlMsgPayload_template::operator=(const OPTIONAL<L1ctlMsgPayload>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const L1ctlMsgPayload&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @L1CTL_Types.L1ctlMsgPayload.");
}
return *this;
}

L1ctlMsgPayload_template& L1ctlMsgPayload_template::operator=(const L1ctlMsgPayload_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean L1ctlMsgPayload_template::match(const L1ctlMsgPayload& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
L1ctlMsgPayload::union_selection_type value_selection = other_value.get_selection();
if (value_selection == L1ctlMsgPayload::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case L1ctlMsgPayload::ALT_fbsb__req:
return single_value.field_fbsb__req->match(other_value.fbsb__req(), legacy);
case L1ctlMsgPayload::ALT_fbsb__conf:
return single_value.field_fbsb__conf->match(other_value.fbsb__conf(), legacy);
case L1ctlMsgPayload::ALT_data__ind:
return single_value.field_data__ind->match(other_value.data__ind(), legacy);
case L1ctlMsgPayload::ALT_rach__req:
return single_value.field_rach__req->match(other_value.rach__req(), legacy);
case L1ctlMsgPayload::ALT_dm__est__req:
return single_value.field_dm__est__req->match(other_value.dm__est__req(), legacy);
case L1ctlMsgPayload::ALT_data__req:
return single_value.field_data__req->match(other_value.data__req(), legacy);
case L1ctlMsgPayload::ALT_reset__req:
return single_value.field_reset__req->match(other_value.reset__req(), legacy);
case L1ctlMsgPayload::ALT_ccch__mode__req:
return single_value.field_ccch__mode__req->match(other_value.ccch__mode__req(), legacy);
case L1ctlMsgPayload::ALT_ccch__mode__conf:
return single_value.field_ccch__mode__conf->match(other_value.ccch__mode__conf(), legacy);
case L1ctlMsgPayload::ALT_par__req:
return single_value.field_par__req->match(other_value.par__req(), legacy);
case L1ctlMsgPayload::ALT_crypto__req:
return single_value.field_crypto__req->match(other_value.crypto__req(), legacy);
case L1ctlMsgPayload::ALT_tch__mode__req:
return single_value.field_tch__mode__req->match(other_value.tch__mode__req(), legacy);
case L1ctlMsgPayload::ALT_tch__mode__conf:
return single_value.field_tch__mode__conf->match(other_value.tch__mode__conf(), legacy);
case L1ctlMsgPayload::ALT_traffic__req:
return single_value.field_traffic__req->match(other_value.traffic__req(), legacy);
case L1ctlMsgPayload::ALT_traffic__ind:
return single_value.field_traffic__ind->match(other_value.traffic__ind(), legacy);
case L1ctlMsgPayload::ALT_ul__tbf__cfg__req:
return single_value.field_ul__tbf__cfg__req->match(other_value.ul__tbf__cfg__req(), legacy);
case L1ctlMsgPayload::ALT_dl__tbf__cfg__req:
return single_value.field_dl__tbf__cfg__req->match(other_value.dl__tbf__cfg__req(), legacy);
case L1ctlMsgPayload::ALT_ul__block__req:
return single_value.field_ul__block__req->match(other_value.ul__block__req(), legacy);
case L1ctlMsgPayload::ALT_ul__block__cnf:
return single_value.field_ul__block__cnf->match(other_value.ul__block__cnf(), legacy);
case L1ctlMsgPayload::ALT_dl__block__ind:
return single_value.field_dl__block__ind->match(other_value.dl__block__ind(), legacy);
case L1ctlMsgPayload::ALT_ext__rach__req:
return single_value.field_ext__rach__req->match(other_value.ext__rach__req(), legacy);
case L1ctlMsgPayload::ALT_rts__ind:
return single_value.field_rts__ind->match(other_value.rts__ind(), legacy);
case L1ctlMsgPayload::ALT_other:
return single_value.field_other->match(other_value.other(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @L1CTL_Types.L1ctlMsgPayload.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @L1CTL_Types.L1ctlMsgPayload.");
}
return FALSE;
}

boolean L1ctlMsgPayload_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case L1ctlMsgPayload::ALT_fbsb__req:
return single_value.field_fbsb__req->is_value();
case L1ctlMsgPayload::ALT_fbsb__conf:
return single_value.field_fbsb__conf->is_value();
case L1ctlMsgPayload::ALT_data__ind:
return single_value.field_data__ind->is_value();
case L1ctlMsgPayload::ALT_rach__req:
return single_value.field_rach__req->is_value();
case L1ctlMsgPayload::ALT_dm__est__req:
return single_value.field_dm__est__req->is_value();
case L1ctlMsgPayload::ALT_data__req:
return single_value.field_data__req->is_value();
case L1ctlMsgPayload::ALT_reset__req:
return single_value.field_reset__req->is_value();
case L1ctlMsgPayload::ALT_ccch__mode__req:
return single_value.field_ccch__mode__req->is_value();
case L1ctlMsgPayload::ALT_ccch__mode__conf:
return single_value.field_ccch__mode__conf->is_value();
case L1ctlMsgPayload::ALT_par__req:
return single_value.field_par__req->is_value();
case L1ctlMsgPayload::ALT_crypto__req:
return single_value.field_crypto__req->is_value();
case L1ctlMsgPayload::ALT_tch__mode__req:
return single_value.field_tch__mode__req->is_value();
case L1ctlMsgPayload::ALT_tch__mode__conf:
return single_value.field_tch__mode__conf->is_value();
case L1ctlMsgPayload::ALT_traffic__req:
return single_value.field_traffic__req->is_value();
case L1ctlMsgPayload::ALT_traffic__ind:
return single_value.field_traffic__ind->is_value();
case L1ctlMsgPayload::ALT_ul__tbf__cfg__req:
return single_value.field_ul__tbf__cfg__req->is_value();
case L1ctlMsgPayload::ALT_dl__tbf__cfg__req:
return single_value.field_dl__tbf__cfg__req->is_value();
case L1ctlMsgPayload::ALT_ul__block__req:
return single_value.field_ul__block__req->is_value();
case L1ctlMsgPayload::ALT_ul__block__cnf:
return single_value.field_ul__block__cnf->is_value();
case L1ctlMsgPayload::ALT_dl__block__ind:
return single_value.field_dl__block__ind->is_value();
case L1ctlMsgPayload::ALT_ext__rach__req:
return single_value.field_ext__rach__req->is_value();
case L1ctlMsgPayload::ALT_rts__ind:
return single_value.field_rts__ind->is_value();
case L1ctlMsgPayload::ALT_other:
return single_value.field_other->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @L1CTL_Types.L1ctlMsgPayload.");
}
}

L1ctlMsgPayload L1ctlMsgPayload_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
L1ctlMsgPayload ret_val;
switch (single_value.union_selection) {
case L1ctlMsgPayload::ALT_fbsb__req:
ret_val.fbsb__req() = single_value.field_fbsb__req->valueof();
break;
case L1ctlMsgPayload::ALT_fbsb__conf:
ret_val.fbsb__conf() = single_value.field_fbsb__conf->valueof();
break;
case L1ctlMsgPayload::ALT_data__ind:
ret_val.data__ind() = single_value.field_data__ind->valueof();
break;
case L1ctlMsgPayload::ALT_rach__req:
ret_val.rach__req() = single_value.field_rach__req->valueof();
break;
case L1ctlMsgPayload::ALT_dm__est__req:
ret_val.dm__est__req() = single_value.field_dm__est__req->valueof();
break;
case L1ctlMsgPayload::ALT_data__req:
ret_val.data__req() = single_value.field_data__req->valueof();
break;
case L1ctlMsgPayload::ALT_reset__req:
ret_val.reset__req() = single_value.field_reset__req->valueof();
break;
case L1ctlMsgPayload::ALT_ccch__mode__req:
ret_val.ccch__mode__req() = single_value.field_ccch__mode__req->valueof();
break;
case L1ctlMsgPayload::ALT_ccch__mode__conf:
ret_val.ccch__mode__conf() = single_value.field_ccch__mode__conf->valueof();
break;
case L1ctlMsgPayload::ALT_par__req:
ret_val.par__req() = single_value.field_par__req->valueof();
break;
case L1ctlMsgPayload::ALT_crypto__req:
ret_val.crypto__req() = single_value.field_crypto__req->valueof();
break;
case L1ctlMsgPayload::ALT_tch__mode__req:
ret_val.tch__mode__req() = single_value.field_tch__mode__req->valueof();
break;
case L1ctlMsgPayload::ALT_tch__mode__conf:
ret_val.tch__mode__conf() = single_value.field_tch__mode__conf->valueof();
break;
case L1ctlMsgPayload::ALT_traffic__req:
ret_val.traffic__req() = single_value.field_traffic__req->valueof();
break;
case L1ctlMsgPayload::ALT_traffic__ind:
ret_val.traffic__ind() = single_value.field_traffic__ind->valueof();
break;
case L1ctlMsgPayload::ALT_ul__tbf__cfg__req:
ret_val.ul__tbf__cfg__req() = single_value.field_ul__tbf__cfg__req->valueof();
break;
case L1ctlMsgPayload::ALT_dl__tbf__cfg__req:
ret_val.dl__tbf__cfg__req() = single_value.field_dl__tbf__cfg__req->valueof();
break;
case L1ctlMsgPayload::ALT_ul__block__req:
ret_val.ul__block__req() = single_value.field_ul__block__req->valueof();
break;
case L1ctlMsgPayload::ALT_ul__block__cnf:
ret_val.ul__block__cnf() = single_value.field_ul__block__cnf->valueof();
break;
case L1ctlMsgPayload::ALT_dl__block__ind:
ret_val.dl__block__ind() = single_value.field_dl__block__ind->valueof();
break;
case L1ctlMsgPayload::ALT_ext__rach__req:
ret_val.ext__rach__req() = single_value.field_ext__rach__req->valueof();
break;
case L1ctlMsgPayload::ALT_rts__ind:
ret_val.rts__ind() = single_value.field_rts__ind->valueof();
break;
case L1ctlMsgPayload::ALT_other:
ret_val.other() = single_value.field_other->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @L1CTL_Types.L1ctlMsgPayload.");
}
return ret_val;
}

L1ctlMsgPayload_template& L1ctlMsgPayload_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @L1CTL_Types.L1ctlMsgPayload.");
return value_list.list_value[list_index];
}
void L1ctlMsgPayload_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @L1CTL_Types.L1ctlMsgPayload.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new L1ctlMsgPayload_template[list_length];
}

L1ctlFbsbReq_template& L1ctlMsgPayload_template::fbsb__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_fbsb__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_fbsb__req = new L1ctlFbsbReq_template(ANY_VALUE);
else single_value.field_fbsb__req = new L1ctlFbsbReq_template;
single_value.union_selection = L1ctlMsgPayload::ALT_fbsb__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_fbsb__req;
}

const L1ctlFbsbReq_template& L1ctlMsgPayload_template::fbsb__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field fbsb_req in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_fbsb__req) TTCN_error("Accessing non-selected field fbsb_req in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_fbsb__req;
}

L1ctlFbsbConf_template& L1ctlMsgPayload_template::fbsb__conf()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_fbsb__conf) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_fbsb__conf = new L1ctlFbsbConf_template(ANY_VALUE);
else single_value.field_fbsb__conf = new L1ctlFbsbConf_template;
single_value.union_selection = L1ctlMsgPayload::ALT_fbsb__conf;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_fbsb__conf;
}

const L1ctlFbsbConf_template& L1ctlMsgPayload_template::fbsb__conf() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field fbsb_conf in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_fbsb__conf) TTCN_error("Accessing non-selected field fbsb_conf in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_fbsb__conf;
}

L1ctlDataInd_template& L1ctlMsgPayload_template::data__ind()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_data__ind) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_data__ind = new L1ctlDataInd_template(ANY_VALUE);
else single_value.field_data__ind = new L1ctlDataInd_template;
single_value.union_selection = L1ctlMsgPayload::ALT_data__ind;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_data__ind;
}

const L1ctlDataInd_template& L1ctlMsgPayload_template::data__ind() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field data_ind in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_data__ind) TTCN_error("Accessing non-selected field data_ind in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_data__ind;
}

L1ctlRachReq_template& L1ctlMsgPayload_template::rach__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_rach__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_rach__req = new L1ctlRachReq_template(ANY_VALUE);
else single_value.field_rach__req = new L1ctlRachReq_template;
single_value.union_selection = L1ctlMsgPayload::ALT_rach__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_rach__req;
}

const L1ctlRachReq_template& L1ctlMsgPayload_template::rach__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field rach_req in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_rach__req) TTCN_error("Accessing non-selected field rach_req in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_rach__req;
}

L1ctlDmEstReq_template& L1ctlMsgPayload_template::dm__est__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_dm__est__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_dm__est__req = new L1ctlDmEstReq_template(ANY_VALUE);
else single_value.field_dm__est__req = new L1ctlDmEstReq_template;
single_value.union_selection = L1ctlMsgPayload::ALT_dm__est__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_dm__est__req;
}

const L1ctlDmEstReq_template& L1ctlMsgPayload_template::dm__est__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field dm_est_req in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_dm__est__req) TTCN_error("Accessing non-selected field dm_est_req in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_dm__est__req;
}

L1ctlDataReq_template& L1ctlMsgPayload_template::data__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_data__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_data__req = new L1ctlDataReq_template(ANY_VALUE);
else single_value.field_data__req = new L1ctlDataReq_template;
single_value.union_selection = L1ctlMsgPayload::ALT_data__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_data__req;
}

const L1ctlDataReq_template& L1ctlMsgPayload_template::data__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field data_req in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_data__req) TTCN_error("Accessing non-selected field data_req in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_data__req;
}

L1ctlReset_template& L1ctlMsgPayload_template::reset__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_reset__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_reset__req = new L1ctlReset_template(ANY_VALUE);
else single_value.field_reset__req = new L1ctlReset_template;
single_value.union_selection = L1ctlMsgPayload::ALT_reset__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_reset__req;
}

const L1ctlReset_template& L1ctlMsgPayload_template::reset__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field reset_req in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_reset__req) TTCN_error("Accessing non-selected field reset_req in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_reset__req;
}

L1ctlCcchModeReq_template& L1ctlMsgPayload_template::ccch__mode__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_ccch__mode__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_ccch__mode__req = new L1ctlCcchModeReq_template(ANY_VALUE);
else single_value.field_ccch__mode__req = new L1ctlCcchModeReq_template;
single_value.union_selection = L1ctlMsgPayload::ALT_ccch__mode__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_ccch__mode__req;
}

const L1ctlCcchModeReq_template& L1ctlMsgPayload_template::ccch__mode__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field ccch_mode_req in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_ccch__mode__req) TTCN_error("Accessing non-selected field ccch_mode_req in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_ccch__mode__req;
}

L1ctlCcchModeConf_template& L1ctlMsgPayload_template::ccch__mode__conf()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_ccch__mode__conf) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_ccch__mode__conf = new L1ctlCcchModeConf_template(ANY_VALUE);
else single_value.field_ccch__mode__conf = new L1ctlCcchModeConf_template;
single_value.union_selection = L1ctlMsgPayload::ALT_ccch__mode__conf;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_ccch__mode__conf;
}

const L1ctlCcchModeConf_template& L1ctlMsgPayload_template::ccch__mode__conf() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field ccch_mode_conf in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_ccch__mode__conf) TTCN_error("Accessing non-selected field ccch_mode_conf in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_ccch__mode__conf;
}

L1ctlParReq_template& L1ctlMsgPayload_template::par__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_par__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_par__req = new L1ctlParReq_template(ANY_VALUE);
else single_value.field_par__req = new L1ctlParReq_template;
single_value.union_selection = L1ctlMsgPayload::ALT_par__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_par__req;
}

const L1ctlParReq_template& L1ctlMsgPayload_template::par__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field par_req in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_par__req) TTCN_error("Accessing non-selected field par_req in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_par__req;
}

L1CtlCryptoReq_template& L1ctlMsgPayload_template::crypto__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_crypto__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_crypto__req = new L1CtlCryptoReq_template(ANY_VALUE);
else single_value.field_crypto__req = new L1CtlCryptoReq_template;
single_value.union_selection = L1ctlMsgPayload::ALT_crypto__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_crypto__req;
}

const L1CtlCryptoReq_template& L1ctlMsgPayload_template::crypto__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field crypto_req in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_crypto__req) TTCN_error("Accessing non-selected field crypto_req in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_crypto__req;
}

L1ctlTchModeReq_template& L1ctlMsgPayload_template::tch__mode__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_tch__mode__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_tch__mode__req = new L1ctlTchModeReq_template(ANY_VALUE);
else single_value.field_tch__mode__req = new L1ctlTchModeReq_template;
single_value.union_selection = L1ctlMsgPayload::ALT_tch__mode__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_tch__mode__req;
}

const L1ctlTchModeReq_template& L1ctlMsgPayload_template::tch__mode__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field tch_mode_req in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_tch__mode__req) TTCN_error("Accessing non-selected field tch_mode_req in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_tch__mode__req;
}

L1ctlTchModeConf_template& L1ctlMsgPayload_template::tch__mode__conf()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_tch__mode__conf) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_tch__mode__conf = new L1ctlTchModeConf_template(ANY_VALUE);
else single_value.field_tch__mode__conf = new L1ctlTchModeConf_template;
single_value.union_selection = L1ctlMsgPayload::ALT_tch__mode__conf;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_tch__mode__conf;
}

const L1ctlTchModeConf_template& L1ctlMsgPayload_template::tch__mode__conf() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field tch_mode_conf in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_tch__mode__conf) TTCN_error("Accessing non-selected field tch_mode_conf in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_tch__mode__conf;
}

L1ctlTrafficReq_template& L1ctlMsgPayload_template::traffic__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_traffic__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_traffic__req = new L1ctlTrafficReq_template(ANY_VALUE);
else single_value.field_traffic__req = new L1ctlTrafficReq_template;
single_value.union_selection = L1ctlMsgPayload::ALT_traffic__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_traffic__req;
}

const L1ctlTrafficReq_template& L1ctlMsgPayload_template::traffic__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field traffic_req in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_traffic__req) TTCN_error("Accessing non-selected field traffic_req in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_traffic__req;
}

L1ctlTrafficReq_template& L1ctlMsgPayload_template::traffic__ind()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_traffic__ind) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_traffic__ind = new L1ctlTrafficReq_template(ANY_VALUE);
else single_value.field_traffic__ind = new L1ctlTrafficReq_template;
single_value.union_selection = L1ctlMsgPayload::ALT_traffic__ind;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_traffic__ind;
}

const L1ctlTrafficReq_template& L1ctlMsgPayload_template::traffic__ind() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field traffic_ind in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_traffic__ind) TTCN_error("Accessing non-selected field traffic_ind in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_traffic__ind;
}

L1ctlGprsUlTbfCfgReq_template& L1ctlMsgPayload_template::ul__tbf__cfg__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_ul__tbf__cfg__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_ul__tbf__cfg__req = new L1ctlGprsUlTbfCfgReq_template(ANY_VALUE);
else single_value.field_ul__tbf__cfg__req = new L1ctlGprsUlTbfCfgReq_template;
single_value.union_selection = L1ctlMsgPayload::ALT_ul__tbf__cfg__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_ul__tbf__cfg__req;
}

const L1ctlGprsUlTbfCfgReq_template& L1ctlMsgPayload_template::ul__tbf__cfg__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field ul_tbf_cfg_req in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_ul__tbf__cfg__req) TTCN_error("Accessing non-selected field ul_tbf_cfg_req in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_ul__tbf__cfg__req;
}

L1ctlGprsDlTbfCfgReq_template& L1ctlMsgPayload_template::dl__tbf__cfg__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_dl__tbf__cfg__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_dl__tbf__cfg__req = new L1ctlGprsDlTbfCfgReq_template(ANY_VALUE);
else single_value.field_dl__tbf__cfg__req = new L1ctlGprsDlTbfCfgReq_template;
single_value.union_selection = L1ctlMsgPayload::ALT_dl__tbf__cfg__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_dl__tbf__cfg__req;
}

const L1ctlGprsDlTbfCfgReq_template& L1ctlMsgPayload_template::dl__tbf__cfg__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field dl_tbf_cfg_req in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_dl__tbf__cfg__req) TTCN_error("Accessing non-selected field dl_tbf_cfg_req in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_dl__tbf__cfg__req;
}

L1ctlGprsUlBlockReq_template& L1ctlMsgPayload_template::ul__block__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_ul__block__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_ul__block__req = new L1ctlGprsUlBlockReq_template(ANY_VALUE);
else single_value.field_ul__block__req = new L1ctlGprsUlBlockReq_template;
single_value.union_selection = L1ctlMsgPayload::ALT_ul__block__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_ul__block__req;
}

const L1ctlGprsUlBlockReq_template& L1ctlMsgPayload_template::ul__block__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field ul_block_req in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_ul__block__req) TTCN_error("Accessing non-selected field ul_block_req in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_ul__block__req;
}

L1ctlGprsUlBlockCnf_template& L1ctlMsgPayload_template::ul__block__cnf()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_ul__block__cnf) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_ul__block__cnf = new L1ctlGprsUlBlockCnf_template(ANY_VALUE);
else single_value.field_ul__block__cnf = new L1ctlGprsUlBlockCnf_template;
single_value.union_selection = L1ctlMsgPayload::ALT_ul__block__cnf;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_ul__block__cnf;
}

const L1ctlGprsUlBlockCnf_template& L1ctlMsgPayload_template::ul__block__cnf() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field ul_block_cnf in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_ul__block__cnf) TTCN_error("Accessing non-selected field ul_block_cnf in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_ul__block__cnf;
}

L1ctlGprsDlBlockInd_template& L1ctlMsgPayload_template::dl__block__ind()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_dl__block__ind) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_dl__block__ind = new L1ctlGprsDlBlockInd_template(ANY_VALUE);
else single_value.field_dl__block__ind = new L1ctlGprsDlBlockInd_template;
single_value.union_selection = L1ctlMsgPayload::ALT_dl__block__ind;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_dl__block__ind;
}

const L1ctlGprsDlBlockInd_template& L1ctlMsgPayload_template::dl__block__ind() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field dl_block_ind in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_dl__block__ind) TTCN_error("Accessing non-selected field dl_block_ind in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_dl__block__ind;
}

L1ctlExtRachReq_template& L1ctlMsgPayload_template::ext__rach__req()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_ext__rach__req) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_ext__rach__req = new L1ctlExtRachReq_template(ANY_VALUE);
else single_value.field_ext__rach__req = new L1ctlExtRachReq_template;
single_value.union_selection = L1ctlMsgPayload::ALT_ext__rach__req;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_ext__rach__req;
}

const L1ctlExtRachReq_template& L1ctlMsgPayload_template::ext__rach__req() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field ext_rach_req in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_ext__rach__req) TTCN_error("Accessing non-selected field ext_rach_req in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_ext__rach__req;
}

L1ctlGprsRtsInd_template& L1ctlMsgPayload_template::rts__ind()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_rts__ind) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_rts__ind = new L1ctlGprsRtsInd_template(ANY_VALUE);
else single_value.field_rts__ind = new L1ctlGprsRtsInd_template;
single_value.union_selection = L1ctlMsgPayload::ALT_rts__ind;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_rts__ind;
}

const L1ctlGprsRtsInd_template& L1ctlMsgPayload_template::rts__ind() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field rts_ind in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_rts__ind) TTCN_error("Accessing non-selected field rts_ind in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_rts__ind;
}

OCTETSTRING_template& L1ctlMsgPayload_template::other()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != L1ctlMsgPayload::ALT_other) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_other = new OCTETSTRING_template(ANY_VALUE);
else single_value.field_other = new OCTETSTRING_template;
single_value.union_selection = L1ctlMsgPayload::ALT_other;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_other;
}

const OCTETSTRING_template& L1ctlMsgPayload_template::other() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field other in a non-specific template of union type @L1CTL_Types.L1ctlMsgPayload.");
if (single_value.union_selection != L1ctlMsgPayload::ALT_other) TTCN_error("Accessing non-selected field other in a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return *single_value.field_other;
}

boolean L1ctlMsgPayload_template::ischosen(L1ctlMsgPayload::union_selection_type checked_selection) const
{
if (checked_selection == L1ctlMsgPayload::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @L1CTL_Types.L1ctlMsgPayload.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == L1ctlMsgPayload::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @L1CTL_Types.L1ctlMsgPayload.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @L1CTL_Types.L1ctlMsgPayload containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void L1ctlMsgPayload_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case L1ctlMsgPayload::ALT_fbsb__req:
TTCN_Logger::log_event_str("{ fbsb_req := ");
single_value.field_fbsb__req->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_fbsb__conf:
TTCN_Logger::log_event_str("{ fbsb_conf := ");
single_value.field_fbsb__conf->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_data__ind:
TTCN_Logger::log_event_str("{ data_ind := ");
single_value.field_data__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_rach__req:
TTCN_Logger::log_event_str("{ rach_req := ");
single_value.field_rach__req->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_dm__est__req:
TTCN_Logger::log_event_str("{ dm_est_req := ");
single_value.field_dm__est__req->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_data__req:
TTCN_Logger::log_event_str("{ data_req := ");
single_value.field_data__req->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_reset__req:
TTCN_Logger::log_event_str("{ reset_req := ");
single_value.field_reset__req->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_ccch__mode__req:
TTCN_Logger::log_event_str("{ ccch_mode_req := ");
single_value.field_ccch__mode__req->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_ccch__mode__conf:
TTCN_Logger::log_event_str("{ ccch_mode_conf := ");
single_value.field_ccch__mode__conf->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_par__req:
TTCN_Logger::log_event_str("{ par_req := ");
single_value.field_par__req->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_crypto__req:
TTCN_Logger::log_event_str("{ crypto_req := ");
single_value.field_crypto__req->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_tch__mode__req:
TTCN_Logger::log_event_str("{ tch_mode_req := ");
single_value.field_tch__mode__req->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_tch__mode__conf:
TTCN_Logger::log_event_str("{ tch_mode_conf := ");
single_value.field_tch__mode__conf->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_traffic__req:
TTCN_Logger::log_event_str("{ traffic_req := ");
single_value.field_traffic__req->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_traffic__ind:
TTCN_Logger::log_event_str("{ traffic_ind := ");
single_value.field_traffic__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_ul__tbf__cfg__req:
TTCN_Logger::log_event_str("{ ul_tbf_cfg_req := ");
single_value.field_ul__tbf__cfg__req->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_dl__tbf__cfg__req:
TTCN_Logger::log_event_str("{ dl_tbf_cfg_req := ");
single_value.field_dl__tbf__cfg__req->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_ul__block__req:
TTCN_Logger::log_event_str("{ ul_block_req := ");
single_value.field_ul__block__req->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_ul__block__cnf:
TTCN_Logger::log_event_str("{ ul_block_cnf := ");
single_value.field_ul__block__cnf->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_dl__block__ind:
TTCN_Logger::log_event_str("{ dl_block_ind := ");
single_value.field_dl__block__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_ext__rach__req:
TTCN_Logger::log_event_str("{ ext_rach_req := ");
single_value.field_ext__rach__req->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_rts__ind:
TTCN_Logger::log_event_str("{ rts_ind := ");
single_value.field_rts__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case L1ctlMsgPayload::ALT_other:
TTCN_Logger::log_event_str("{ other := ");
single_value.field_other->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void L1ctlMsgPayload_template::log_match(const L1ctlMsgPayload& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case L1ctlMsgPayload::ALT_fbsb__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".fbsb_req");
single_value.field_fbsb__req->log_match(match_value.fbsb__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ fbsb_req := ");
single_value.field_fbsb__req->log_match(match_value.fbsb__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_fbsb__conf:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".fbsb_conf");
single_value.field_fbsb__conf->log_match(match_value.fbsb__conf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ fbsb_conf := ");
single_value.field_fbsb__conf->log_match(match_value.fbsb__conf(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_data__ind:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".data_ind");
single_value.field_data__ind->log_match(match_value.data__ind(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ data_ind := ");
single_value.field_data__ind->log_match(match_value.data__ind(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_rach__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".rach_req");
single_value.field_rach__req->log_match(match_value.rach__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ rach_req := ");
single_value.field_rach__req->log_match(match_value.rach__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_dm__est__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".dm_est_req");
single_value.field_dm__est__req->log_match(match_value.dm__est__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ dm_est_req := ");
single_value.field_dm__est__req->log_match(match_value.dm__est__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_data__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".data_req");
single_value.field_data__req->log_match(match_value.data__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ data_req := ");
single_value.field_data__req->log_match(match_value.data__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_reset__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".reset_req");
single_value.field_reset__req->log_match(match_value.reset__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ reset_req := ");
single_value.field_reset__req->log_match(match_value.reset__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_ccch__mode__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".ccch_mode_req");
single_value.field_ccch__mode__req->log_match(match_value.ccch__mode__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ ccch_mode_req := ");
single_value.field_ccch__mode__req->log_match(match_value.ccch__mode__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_ccch__mode__conf:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".ccch_mode_conf");
single_value.field_ccch__mode__conf->log_match(match_value.ccch__mode__conf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ ccch_mode_conf := ");
single_value.field_ccch__mode__conf->log_match(match_value.ccch__mode__conf(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_par__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".par_req");
single_value.field_par__req->log_match(match_value.par__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ par_req := ");
single_value.field_par__req->log_match(match_value.par__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_crypto__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".crypto_req");
single_value.field_crypto__req->log_match(match_value.crypto__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ crypto_req := ");
single_value.field_crypto__req->log_match(match_value.crypto__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_tch__mode__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".tch_mode_req");
single_value.field_tch__mode__req->log_match(match_value.tch__mode__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ tch_mode_req := ");
single_value.field_tch__mode__req->log_match(match_value.tch__mode__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_tch__mode__conf:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".tch_mode_conf");
single_value.field_tch__mode__conf->log_match(match_value.tch__mode__conf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ tch_mode_conf := ");
single_value.field_tch__mode__conf->log_match(match_value.tch__mode__conf(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_traffic__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".traffic_req");
single_value.field_traffic__req->log_match(match_value.traffic__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ traffic_req := ");
single_value.field_traffic__req->log_match(match_value.traffic__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_traffic__ind:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".traffic_ind");
single_value.field_traffic__ind->log_match(match_value.traffic__ind(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ traffic_ind := ");
single_value.field_traffic__ind->log_match(match_value.traffic__ind(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_ul__tbf__cfg__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".ul_tbf_cfg_req");
single_value.field_ul__tbf__cfg__req->log_match(match_value.ul__tbf__cfg__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ ul_tbf_cfg_req := ");
single_value.field_ul__tbf__cfg__req->log_match(match_value.ul__tbf__cfg__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_dl__tbf__cfg__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".dl_tbf_cfg_req");
single_value.field_dl__tbf__cfg__req->log_match(match_value.dl__tbf__cfg__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ dl_tbf_cfg_req := ");
single_value.field_dl__tbf__cfg__req->log_match(match_value.dl__tbf__cfg__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_ul__block__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".ul_block_req");
single_value.field_ul__block__req->log_match(match_value.ul__block__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ ul_block_req := ");
single_value.field_ul__block__req->log_match(match_value.ul__block__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_ul__block__cnf:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".ul_block_cnf");
single_value.field_ul__block__cnf->log_match(match_value.ul__block__cnf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ ul_block_cnf := ");
single_value.field_ul__block__cnf->log_match(match_value.ul__block__cnf(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_dl__block__ind:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".dl_block_ind");
single_value.field_dl__block__ind->log_match(match_value.dl__block__ind(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ dl_block_ind := ");
single_value.field_dl__block__ind->log_match(match_value.dl__block__ind(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_ext__rach__req:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".ext_rach_req");
single_value.field_ext__rach__req->log_match(match_value.ext__rach__req(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ ext_rach_req := ");
single_value.field_ext__rach__req->log_match(match_value.ext__rach__req(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_rts__ind:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".rts_ind");
single_value.field_rts__ind->log_match(match_value.rts__ind(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ rts_ind := ");
single_value.field_rts__ind->log_match(match_value.rts__ind(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case L1ctlMsgPayload::ALT_other:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".other");
single_value.field_other->log_match(match_value.other(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ other := ");
single_value.field_other->log_match(match_value.other(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void L1ctlMsgPayload_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case L1ctlMsgPayload::ALT_fbsb__req:
single_value.field_fbsb__req->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_fbsb__conf:
single_value.field_fbsb__conf->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_data__ind:
single_value.field_data__ind->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_rach__req:
single_value.field_rach__req->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_dm__est__req:
single_value.field_dm__est__req->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_data__req:
single_value.field_data__req->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_reset__req:
single_value.field_reset__req->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_ccch__mode__req:
single_value.field_ccch__mode__req->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_ccch__mode__conf:
single_value.field_ccch__mode__conf->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_par__req:
single_value.field_par__req->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_crypto__req:
single_value.field_crypto__req->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_tch__mode__req:
single_value.field_tch__mode__req->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_tch__mode__conf:
single_value.field_tch__mode__conf->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_traffic__req:
single_value.field_traffic__req->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_traffic__ind:
single_value.field_traffic__ind->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_ul__tbf__cfg__req:
single_value.field_ul__tbf__cfg__req->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_dl__tbf__cfg__req:
single_value.field_dl__tbf__cfg__req->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_ul__block__req:
single_value.field_ul__block__req->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_ul__block__cnf:
single_value.field_ul__block__cnf->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_dl__block__ind:
single_value.field_dl__block__ind->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_ext__rach__req:
single_value.field_ext__rach__req->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_rts__ind:
single_value.field_rts__ind->set_implicit_omit(); break;
case L1ctlMsgPayload::ALT_other:
single_value.field_other->set_implicit_omit(); break;
default: break;
}
}

void L1ctlMsgPayload_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case L1ctlMsgPayload::ALT_fbsb__req:
single_value.field_fbsb__req->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_fbsb__conf:
single_value.field_fbsb__conf->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_data__ind:
single_value.field_data__ind->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_rach__req:
single_value.field_rach__req->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_dm__est__req:
single_value.field_dm__est__req->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_data__req:
single_value.field_data__req->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_reset__req:
single_value.field_reset__req->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_ccch__mode__req:
single_value.field_ccch__mode__req->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_ccch__mode__conf:
single_value.field_ccch__mode__conf->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_par__req:
single_value.field_par__req->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_crypto__req:
single_value.field_crypto__req->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_tch__mode__req:
single_value.field_tch__mode__req->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_tch__mode__conf:
single_value.field_tch__mode__conf->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_traffic__req:
single_value.field_traffic__req->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_traffic__ind:
single_value.field_traffic__ind->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_ul__tbf__cfg__req:
single_value.field_ul__tbf__cfg__req->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_dl__tbf__cfg__req:
single_value.field_dl__tbf__cfg__req->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_ul__block__req:
single_value.field_ul__block__req->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_ul__block__cnf:
single_value.field_ul__block__cnf->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_dl__block__ind:
single_value.field_dl__block__ind->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_ext__rach__req:
single_value.field_ext__rach__req->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_rts__ind:
single_value.field_rts__ind->encode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_other:
single_value.field_other->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @L1CTL_Types.L1ctlMsgPayload.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @L1CTL_Types.L1ctlMsgPayload.");
}
}

void L1ctlMsgPayload_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = L1ctlMsgPayload::UNBOUND_VALUE;
L1ctlMsgPayload::union_selection_type new_selection = (L1ctlMsgPayload::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case L1ctlMsgPayload::ALT_fbsb__req:
single_value.field_fbsb__req = new L1ctlFbsbReq_template;
single_value.field_fbsb__req->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_fbsb__conf:
single_value.field_fbsb__conf = new L1ctlFbsbConf_template;
single_value.field_fbsb__conf->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_data__ind:
single_value.field_data__ind = new L1ctlDataInd_template;
single_value.field_data__ind->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_rach__req:
single_value.field_rach__req = new L1ctlRachReq_template;
single_value.field_rach__req->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_dm__est__req:
single_value.field_dm__est__req = new L1ctlDmEstReq_template;
single_value.field_dm__est__req->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_data__req:
single_value.field_data__req = new L1ctlDataReq_template;
single_value.field_data__req->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_reset__req:
single_value.field_reset__req = new L1ctlReset_template;
single_value.field_reset__req->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_ccch__mode__req:
single_value.field_ccch__mode__req = new L1ctlCcchModeReq_template;
single_value.field_ccch__mode__req->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_ccch__mode__conf:
single_value.field_ccch__mode__conf = new L1ctlCcchModeConf_template;
single_value.field_ccch__mode__conf->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_par__req:
single_value.field_par__req = new L1ctlParReq_template;
single_value.field_par__req->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_crypto__req:
single_value.field_crypto__req = new L1CtlCryptoReq_template;
single_value.field_crypto__req->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_tch__mode__req:
single_value.field_tch__mode__req = new L1ctlTchModeReq_template;
single_value.field_tch__mode__req->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_tch__mode__conf:
single_value.field_tch__mode__conf = new L1ctlTchModeConf_template;
single_value.field_tch__mode__conf->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_traffic__req:
single_value.field_traffic__req = new L1ctlTrafficReq_template;
single_value.field_traffic__req->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_traffic__ind:
single_value.field_traffic__ind = new L1ctlTrafficReq_template;
single_value.field_traffic__ind->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_ul__tbf__cfg__req:
single_value.field_ul__tbf__cfg__req = new L1ctlGprsUlTbfCfgReq_template;
single_value.field_ul__tbf__cfg__req->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_dl__tbf__cfg__req:
single_value.field_dl__tbf__cfg__req = new L1ctlGprsDlTbfCfgReq_template;
single_value.field_dl__tbf__cfg__req->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_ul__block__req:
single_value.field_ul__block__req = new L1ctlGprsUlBlockReq_template;
single_value.field_ul__block__req->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_ul__block__cnf:
single_value.field_ul__block__cnf = new L1ctlGprsUlBlockCnf_template;
single_value.field_ul__block__cnf->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_dl__block__ind:
single_value.field_dl__block__ind = new L1ctlGprsDlBlockInd_template;
single_value.field_dl__block__ind->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_ext__rach__req:
single_value.field_ext__rach__req = new L1ctlExtRachReq_template;
single_value.field_ext__rach__req->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_rts__ind:
single_value.field_rts__ind = new L1ctlGprsRtsInd_template;
single_value.field_rts__ind->decode_text(text_buf);
break;
case L1ctlMsgPayload::ALT_other:
single_value.field_other = new OCTETSTRING_template;
single_value.field_other->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @L1CTL_Types.L1ctlMsgPayload.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new L1ctlMsgPayload_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @L1CTL_Types.L1ctlMsgPayload.");
}
}

boolean L1ctlMsgPayload_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean L1ctlMsgPayload_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void L1ctlMsgPayload_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@L1CTL_Types.L1ctlMsgPayload'");
    }
    if (strcmp("fbsb_req", param_field) == 0) {
      fbsb__req().set_param(param);
      return;
    } else if (strcmp("fbsb_conf", param_field) == 0) {
      fbsb__conf().set_param(param);
      return;
    } else if (strcmp("data_ind", param_field) == 0) {
      data__ind().set_param(param);
      return;
    } else if (strcmp("rach_req", param_field) == 0) {
      rach__req().set_param(param);
      return;
    } else if (strcmp("dm_est_req", param_field) == 0) {
      dm__est__req().set_param(param);
      return;
    } else if (strcmp("data_req", param_field) == 0) {
      data__req().set_param(param);
      return;
    } else if (strcmp("reset_req", param_field) == 0) {
      reset__req().set_param(param);
      return;
    } else if (strcmp("ccch_mode_req", param_field) == 0) {
      ccch__mode__req().set_param(param);
      return;
    } else if (strcmp("ccch_mode_conf", param_field) == 0) {
      ccch__mode__conf().set_param(param);
      return;
    } else if (strcmp("par_req", param_field) == 0) {
      par__req().set_param(param);
      return;
    } else if (strcmp("crypto_req", param_field) == 0) {
      crypto__req().set_param(param);
      return;
    } else if (strcmp("tch_mode_req", param_field) == 0) {
      tch__mode__req().set_param(param);
      return;
    } else if (strcmp("tch_mode_conf", param_field) == 0) {
      tch__mode__conf().set_param(param);
      return;
    } else if (strcmp("traffic_req", param_field) == 0) {
      traffic__req().set_param(param);
      return;
    } else if (strcmp("traffic_ind", param_field) == 0) {
      traffic__ind().set_param(param);
      return;
    } else if (strcmp("ul_tbf_cfg_req", param_field) == 0) {
      ul__tbf__cfg__req().set_param(param);
      return;
    } else if (strcmp("dl_tbf_cfg_req", param_field) == 0) {
      dl__tbf__cfg__req().set_param(param);
      return;
    } else if (strcmp("ul_block_req", param_field) == 0) {
      ul__block__req().set_param(param);
      return;
    } else if (strcmp("ul_block_cnf", param_field) == 0) {
      ul__block__cnf().set_param(param);
      return;
    } else if (strcmp("dl_block_ind", param_field) == 0) {
      dl__block__ind().set_param(param);
      return;
    } else if (strcmp("ext_rach_req", param_field) == 0) {
      ext__rach__req().set_param(param);
      return;
    } else if (strcmp("rts_ind", param_field) == 0) {
      rts__ind().set_param(param);
      return;
    } else if (strcmp("other", param_field) == 0) {
      other().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@L1CTL_Types.L1ctlMsgPayload'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    L1ctlMsgPayload_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@L1CTL_Types.L1ctlMsgPayload");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "fbsb_req")) {
      fbsb__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "fbsb_conf")) {
      fbsb__conf().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "data_ind")) {
      data__ind().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "rach_req")) {
      rach__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "dm_est_req")) {
      dm__est__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "data_req")) {
      data__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "reset_req")) {
      reset__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "ccch_mode_req")) {
      ccch__mode__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "ccch_mode_conf")) {
      ccch__mode__conf().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "par_req")) {
      par__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "crypto_req")) {
      crypto__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "tch_mode_req")) {
      tch__mode__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "tch_mode_conf")) {
      tch__mode__conf().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "traffic_req")) {
      traffic__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "traffic_ind")) {
      traffic__ind().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "ul_tbf_cfg_req")) {
      ul__tbf__cfg__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "dl_tbf_cfg_req")) {
      dl__tbf__cfg__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "ul_block_req")) {
      ul__block__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "ul_block_cnf")) {
      ul__block__cnf().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "dl_block_ind")) {
      dl__block__ind().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "ext_rach_req")) {
      ext__rach__req().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "rts_ind")) {
      rts__ind().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "other")) {
      other().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @L1CTL_Types.L1ctlMsgPayload.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    L1ctlMsgPayload_template* precondition = new L1ctlMsgPayload_template;
    precondition->set_param(*m_p->get_elem(0));
    L1ctlMsgPayload_template* implied_template = new L1ctlMsgPayload_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = L1ctlMsgPayload_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@L1CTL_Types.L1ctlMsgPayload");
  }
  is_ifpresent = param.get_ifpresent();
}

void L1ctlMsgPayload_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case L1ctlMsgPayload::ALT_fbsb__req:
single_value.field_fbsb__req->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_fbsb__conf:
single_value.field_fbsb__conf->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_data__ind:
single_value.field_data__ind->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_rach__req:
single_value.field_rach__req->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_dm__est__req:
single_value.field_dm__est__req->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_data__req:
single_value.field_data__req->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_reset__req:
single_value.field_reset__req->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_ccch__mode__req:
single_value.field_ccch__mode__req->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_ccch__mode__conf:
single_value.field_ccch__mode__conf->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_par__req:
single_value.field_par__req->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_crypto__req:
single_value.field_crypto__req->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_tch__mode__req:
single_value.field_tch__mode__req->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_tch__mode__conf:
single_value.field_tch__mode__conf->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_traffic__req:
single_value.field_traffic__req->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_traffic__ind:
single_value.field_traffic__ind->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_ul__tbf__cfg__req:
single_value.field_ul__tbf__cfg__req->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_dl__tbf__cfg__req:
single_value.field_dl__tbf__cfg__req->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_ul__block__req:
single_value.field_ul__block__req->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_ul__block__cnf:
single_value.field_ul__block__cnf->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_dl__block__ind:
single_value.field_dl__block__ind->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_ext__rach__req:
single_value.field_ext__rach__req->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_rts__ind:
single_value.field_rts__ind->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
case L1ctlMsgPayload::ALT_other:
single_value.field_other->check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @L1CTL_Types.L1ctlMsgPayload.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@L1CTL_Types.L1ctlMsgPayload");
}

L1ctlMessage::L1ctlMessage()
{
}

L1ctlMessage::L1ctlMessage(const L1ctlHeader& par_header,
    const OPTIONAL< L1ctlUlInfo >& par_ul__info,
    const OPTIONAL< L1ctlDlInfo >& par_dl__info,
    const OPTIONAL< L1ctlMsgPayload >& par_payload)
  :   field_header(par_header),
  field_ul__info(par_ul__info),
  field_dl__info(par_dl__info),
  field_payload(par_payload)
{
}

L1ctlMessage::L1ctlMessage(const L1ctlMessage& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @L1CTL_Types.L1ctlMessage.");
if (other_value.header().is_bound()) field_header = other_value.header();
else field_header.clean_up();
if (other_value.ul__info().is_bound()) field_ul__info = other_value.ul__info();
else field_ul__info.clean_up();
if (other_value.dl__info().is_bound()) field_dl__info = other_value.dl__info();
else field_dl__info.clean_up();
if (other_value.payload().is_bound()) field_payload = other_value.payload();
else field_payload.clean_up();
}

void L1ctlMessage::clean_up()
{
field_header.clean_up();
field_ul__info.clean_up();
field_dl__info.clean_up();
field_payload.clean_up();
}

const TTCN_Typedescriptor_t* L1ctlMessage::get_descriptor() const { return &L1ctlMessage_descr_; }
L1ctlMessage& L1ctlMessage::operator=(const L1ctlMessage& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @L1CTL_Types.L1ctlMessage.");
  if (other_value.header().is_bound()) field_header = other_value.header();
  else field_header.clean_up();
  if (other_value.ul__info().is_bound()) field_ul__info = other_value.ul__info();
  else field_ul__info.clean_up();
  if (other_value.dl__info().is_bound()) field_dl__info = other_value.dl__info();
  else field_dl__info.clean_up();
  if (other_value.payload().is_bound()) field_payload = other_value.payload();
  else field_payload.clean_up();
}
return *this;
}

boolean L1ctlMessage::operator==(const L1ctlMessage& other_value) const
{
return field_header==other_value.field_header
  && field_ul__info==other_value.field_ul__info
  && field_dl__info==other_value.field_dl__info
  && field_payload==other_value.field_payload;
}

boolean L1ctlMessage::is_bound() const
{
return (field_header.is_bound())
  || (OPTIONAL_OMIT == field_ul__info.get_selection() || field_ul__info.is_bound())
  || (OPTIONAL_OMIT == field_dl__info.get_selection() || field_dl__info.is_bound())
  || (OPTIONAL_OMIT == field_payload.get_selection() || field_payload.is_bound());
}
boolean L1ctlMessage::is_value() const
{
return field_header.is_value()
  && (OPTIONAL_OMIT == field_ul__info.get_selection() || field_ul__info.is_value())
  && (OPTIONAL_OMIT == field_dl__info.get_selection() || field_dl__info.is_value())
  && (OPTIONAL_OMIT == field_payload.get_selection() || field_payload.is_value());
}
int L1ctlMessage::size_of() const
{
  int ret_val = 1;
  if (field_ul__info.ispresent()) ret_val++;
  if (field_dl__info.ispresent()) ret_val++;
  if (field_payload.ispresent()) ret_val++;
  return ret_val;
}

void L1ctlMessage::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ header := ");
field_header.log();
TTCN_Logger::log_event_str(", ul_info := ");
field_ul__info.log();
TTCN_Logger::log_event_str(", dl_info := ");
field_dl__info.log();
TTCN_Logger::log_event_str(", payload := ");
field_payload.log();
TTCN_Logger::log_event_str(" }");
}

void L1ctlMessage::set_implicit_omit()
{
if (header().is_bound()) header().set_implicit_omit();
if (!ul__info().is_bound()) ul__info() = OMIT_VALUE;
else ul__info().set_implicit_omit();
if (!dl__info().is_bound()) dl__info() = OMIT_VALUE;
else dl__info().set_implicit_omit();
if (!payload().is_bound()) payload() = OMIT_VALUE;
else payload().set_implicit_omit();
}

void L1ctlMessage::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @L1CTL_Types.L1ctlMessage has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) header().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ul__info().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) dl__info().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) payload().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "header")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          header().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ul_info")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ul__info().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dl_info")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dl__info().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "payload")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          payload().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @L1CTL_Types.L1ctlMessage: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@L1CTL_Types.L1ctlMessage");
  }
}

void L1ctlMessage::encode_text(Text_Buf& text_buf) const
{
field_header.encode_text(text_buf);
field_ul__info.encode_text(text_buf);
field_dl__info.encode_text(text_buf);
field_payload.encode_text(text_buf);
}

void L1ctlMessage::decode_text(Text_Buf& text_buf)
{
field_header.decode_text(text_buf);
field_ul__info.decode_text(text_buf);
field_dl__info.decode_text(text_buf);
field_payload.decode_text(text_buf);
}

void L1ctlMessage::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void L1ctlMessage::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int L1ctlMessage::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, L1ctlHeader_descr_.raw->forceomit);
  decoded_field_length = field_header.RAW_decode(L1ctlHeader_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && (field_header.msg__type() == L1ctlMsgType::L1CTL__RACH__REQ || field_header.msg__type() == L1ctlMsgType::L1CTL__EXT__RACH__REQ || field_header.msg__type() == L1ctlMsgType::L1CTL__PARAM__REQ || field_header.msg__type() == L1ctlMsgType::L1CTL__CRYPTO__REQ || field_header.msg__type() == L1ctlMsgType::L1CTL__DATA__REQ || field_header.msg__type() == L1ctlMsgType::L1CTL__DM__EST__REQ || field_header.msg__type() == L1ctlMsgType::L1CTL__DM__FREQ__REQ || field_header.msg__type() == L1ctlMsgType::L1CTL__DM__REL__REQ || field_header.msg__type() == L1ctlMsgType::L1CTL__TRAFFIC__REQ)){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_ul__info = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, L1ctlMessage_ul__info_descr_.raw->forceomit);
  decoded_field_length = field_ul__info().RAW_decode(L1ctlMessage_ul__info_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_ul__info = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_ul__info=OMIT_VALUE;
  if (limit > 0 && (field_header.msg__type() == L1ctlMsgType::L1CTL__FBSB__CONF || field_header.msg__type() == L1ctlMsgType::L1CTL__RACH__CONF || field_header.msg__type() == L1ctlMsgType::L1CTL__DATA__IND || field_header.msg__type() == L1ctlMsgType::L1CTL__DATA__CONF || field_header.msg__type() == L1ctlMsgType::L1CTL__TRAFFIC__IND || field_header.msg__type() == L1ctlMsgType::L1CTL__TRAFFIC__CONF)){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_dl__info = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, L1ctlMessage_dl__info_descr_.raw->forceomit);
  decoded_field_length = field_dl__info().RAW_decode(L1ctlMessage_dl__info_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_dl__info = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_dl__info=OMIT_VALUE;
  if (field_header.msg__type() == L1ctlMsgType::L1CTL__FBSB__REQ) selected_field = 0;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__FBSB__CONF) selected_field = 1;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__DATA__IND) selected_field = 2;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__RACH__REQ) selected_field = 3;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__DM__EST__REQ) selected_field = 4;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__DATA__REQ) selected_field = 5;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__RESET__REQ) selected_field = 6;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__CCCH__MODE__REQ) selected_field = 7;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__CCCH__MODE__CONF) selected_field = 8;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__PARAM__REQ) selected_field = 9;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__CRYPTO__REQ) selected_field = 10;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__TCH__MODE__REQ) selected_field = 11;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__TCH__MODE__CONF) selected_field = 12;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__TRAFFIC__REQ) selected_field = 13;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__TRAFFIC__IND) selected_field = 14;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__GPRS__UL__TBF__CFG__REQ) selected_field = 15;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__GPRS__DL__TBF__CFG__REQ) selected_field = 16;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__GPRS__UL__BLOCK__REQ) selected_field = 17;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__GPRS__UL__BLOCK__CNF) selected_field = 18;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__GPRS__DL__BLOCK__IND) selected_field = 19;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__EXT__RACH__REQ) selected_field = 20;
  else if (field_header.msg__type() == L1ctlMsgType::L1CTL__GPRS__RTS__IND) selected_field = 21;
  else selected_field = 22;
  if (limit > 0&& selected_field!=-1){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_payload = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, L1ctlMessage_payload_descr_.raw->forceomit);
  decoded_field_length = field_payload().RAW_decode(L1ctlMessage_payload_descr_, p_buf, limit, local_top_order, TRUE, selected_field, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_payload = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_payload=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int L1ctlMessage::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, L1ctlHeader_descr_.raw);
  if (field_ul__info.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, L1ctlMessage_ul__info_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_dl__info.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, L1ctlMessage_dl__info_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_payload.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, L1ctlMessage_payload_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  encoded_length += field_header.RAW_encode(L1ctlHeader_descr_, *myleaf.body.node.nodes[0]);
  if (field_ul__info.ispresent()) {
  encoded_length += field_ul__info().RAW_encode(L1ctlMessage_ul__info_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_dl__info.ispresent()) {
  encoded_length += field_dl__info().RAW_encode(L1ctlMessage_dl__info_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_payload.ispresent()) {
  encoded_length += field_payload().RAW_encode(L1ctlMessage_payload_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_ul__info.ispresent() && (field_header.msg__type() != L1ctlMsgType::L1CTL__RACH__REQ && field_header.msg__type() != L1ctlMsgType::L1CTL__EXT__RACH__REQ && field_header.msg__type() != L1ctlMsgType::L1CTL__PARAM__REQ && field_header.msg__type() != L1ctlMsgType::L1CTL__CRYPTO__REQ && field_header.msg__type() != L1ctlMsgType::L1CTL__DATA__REQ && field_header.msg__type() != L1ctlMsgType::L1CTL__DM__EST__REQ && field_header.msg__type() != L1ctlMsgType::L1CTL__DM__FREQ__REQ && field_header.msg__type() != L1ctlMsgType::L1CTL__DM__REL__REQ && field_header.msg__type() != L1ctlMsgType::L1CTL__TRAFFIC__REQ)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={0,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  L1ctlMsgType new_val = L1ctlMsgType::L1CTL__RACH__REQ;
  new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos1;
  pr_pos1.level=myleaf.curr_pos.level+2;
  int new_pos1[]={0,0};
  pr_pos1.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos1);
  temp_leaf = myleaf.get_node(pr_pos1);
  if(temp_leaf != NULL){
  L1ctlMsgType new_val = L1ctlMsgType::L1CTL__EXT__RACH__REQ;
  new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos2;
  pr_pos2.level=myleaf.curr_pos.level+2;
  int new_pos2[]={0,0};
  pr_pos2.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos2);
  temp_leaf = myleaf.get_node(pr_pos2);
  if(temp_leaf != NULL){
  L1ctlMsgType new_val = L1ctlMsgType::L1CTL__PARAM__REQ;
  new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos3;
  pr_pos3.level=myleaf.curr_pos.level+2;
  int new_pos3[]={0,0};
  pr_pos3.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos3);
  temp_leaf = myleaf.get_node(pr_pos3);
  if(temp_leaf != NULL){
  L1ctlMsgType new_val = L1ctlMsgType::L1CTL__CRYPTO__REQ;
  new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos4;
  pr_pos4.level=myleaf.curr_pos.level+2;
  int new_pos4[]={0,0};
  pr_pos4.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos4);
  temp_leaf = myleaf.get_node(pr_pos4);
  if(temp_leaf != NULL){
  L1ctlMsgType new_val = L1ctlMsgType::L1CTL__DATA__REQ;
  new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos5;
  pr_pos5.level=myleaf.curr_pos.level+2;
  int new_pos5[]={0,0};
  pr_pos5.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos5);
  temp_leaf = myleaf.get_node(pr_pos5);
  if(temp_leaf != NULL){
  L1ctlMsgType new_val = L1ctlMsgType::L1CTL__DM__EST__REQ;
  new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos6;
  pr_pos6.level=myleaf.curr_pos.level+2;
  int new_pos6[]={0,0};
  pr_pos6.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos6);
  temp_leaf = myleaf.get_node(pr_pos6);
  if(temp_leaf != NULL){
  L1ctlMsgType new_val = L1ctlMsgType::L1CTL__DM__FREQ__REQ;
  new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos7;
  pr_pos7.level=myleaf.curr_pos.level+2;
  int new_pos7[]={0,0};
  pr_pos7.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos7);
  temp_leaf = myleaf.get_node(pr_pos7);
  if(temp_leaf != NULL){
  L1ctlMsgType new_val = L1ctlMsgType::L1CTL__DM__REL__REQ;
  new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos8;
  pr_pos8.level=myleaf.curr_pos.level+2;
  int new_pos8[]={0,0};
  pr_pos8.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos8);
  temp_leaf = myleaf.get_node(pr_pos8);
  if(temp_leaf != NULL){
  L1ctlMsgType new_val = L1ctlMsgType::L1CTL__TRAFFIC__REQ;
  new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos8.pos);
  }
  free_tree_pos(pr_pos7.pos);
  }
  free_tree_pos(pr_pos6.pos);
  }
  free_tree_pos(pr_pos5.pos);
  }
  free_tree_pos(pr_pos4.pos);
  }
  free_tree_pos(pr_pos3.pos);
  }
  free_tree_pos(pr_pos2.pos);
  }
  free_tree_pos(pr_pos1.pos);
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_dl__info.ispresent() && (field_header.msg__type() != L1ctlMsgType::L1CTL__FBSB__CONF && field_header.msg__type() != L1ctlMsgType::L1CTL__RACH__CONF && field_header.msg__type() != L1ctlMsgType::L1CTL__DATA__IND && field_header.msg__type() != L1ctlMsgType::L1CTL__DATA__CONF && field_header.msg__type() != L1ctlMsgType::L1CTL__TRAFFIC__IND && field_header.msg__type() != L1ctlMsgType::L1CTL__TRAFFIC__CONF)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={0,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  L1ctlMsgType new_val = L1ctlMsgType::L1CTL__FBSB__CONF;
  new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos1;
  pr_pos1.level=myleaf.curr_pos.level+2;
  int new_pos1[]={0,0};
  pr_pos1.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos1);
  temp_leaf = myleaf.get_node(pr_pos1);
  if(temp_leaf != NULL){
  L1ctlMsgType new_val = L1ctlMsgType::L1CTL__RACH__CONF;
  new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos2;
  pr_pos2.level=myleaf.curr_pos.level+2;
  int new_pos2[]={0,0};
  pr_pos2.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos2);
  temp_leaf = myleaf.get_node(pr_pos2);
  if(temp_leaf != NULL){
  L1ctlMsgType new_val = L1ctlMsgType::L1CTL__DATA__IND;
  new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos3;
  pr_pos3.level=myleaf.curr_pos.level+2;
  int new_pos3[]={0,0};
  pr_pos3.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos3);
  temp_leaf = myleaf.get_node(pr_pos3);
  if(temp_leaf != NULL){
  L1ctlMsgType new_val = L1ctlMsgType::L1CTL__DATA__CONF;
  new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos4;
  pr_pos4.level=myleaf.curr_pos.level+2;
  int new_pos4[]={0,0};
  pr_pos4.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos4);
  temp_leaf = myleaf.get_node(pr_pos4);
  if(temp_leaf != NULL){
  L1ctlMsgType new_val = L1ctlMsgType::L1CTL__TRAFFIC__IND;
  new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos5;
  pr_pos5.level=myleaf.curr_pos.level+2;
  int new_pos5[]={0,0};
  pr_pos5.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos5);
  temp_leaf = myleaf.get_node(pr_pos5);
  if(temp_leaf != NULL){
  L1ctlMsgType new_val = L1ctlMsgType::L1CTL__TRAFFIC__CONF;
  new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos5.pos);
  }
  free_tree_pos(pr_pos4.pos);
  }
  free_tree_pos(pr_pos3.pos);
  }
  free_tree_pos(pr_pos2.pos);
  }
  free_tree_pos(pr_pos1.pos);
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_payload.ispresent()) {
  switch (field_payload().get_selection()) {
  case L1ctlMsgPayload::ALT_fbsb__req:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__FBSB__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__FBSB__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_fbsb__conf:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__FBSB__CONF) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__FBSB__CONF);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_data__ind:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__DATA__IND) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__DATA__IND);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_rach__req:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__RACH__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__RACH__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_dm__est__req:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__DM__EST__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__DM__EST__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_data__req:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__DATA__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__DATA__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_reset__req:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__RESET__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__RESET__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_ccch__mode__req:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__CCCH__MODE__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__CCCH__MODE__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_ccch__mode__conf:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__CCCH__MODE__CONF) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__CCCH__MODE__CONF);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_par__req:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__PARAM__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__PARAM__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_crypto__req:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__CRYPTO__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__CRYPTO__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_tch__mode__req:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__TCH__MODE__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__TCH__MODE__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_tch__mode__conf:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__TCH__MODE__CONF) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__TCH__MODE__CONF);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_traffic__req:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__TRAFFIC__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__TRAFFIC__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_traffic__ind:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__TRAFFIC__IND) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__TRAFFIC__IND);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_ul__tbf__cfg__req:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__GPRS__UL__TBF__CFG__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__GPRS__UL__TBF__CFG__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_dl__tbf__cfg__req:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__GPRS__DL__TBF__CFG__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__GPRS__DL__TBF__CFG__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_ul__block__req:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__GPRS__UL__BLOCK__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__GPRS__UL__BLOCK__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_ul__block__cnf:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__GPRS__UL__BLOCK__CNF) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__GPRS__UL__BLOCK__CNF);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_dl__block__ind:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__GPRS__DL__BLOCK__IND) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__GPRS__DL__BLOCK__IND);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_ext__rach__req:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__EXT__RACH__REQ) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__EXT__RACH__REQ);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case L1ctlMsgPayload::ALT_rts__ind:
  if (field_header.msg__type() != L1ctlMsgType::L1CTL__GPRS__RTS__IND) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 0, 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  L1ctlMsgType new_val(L1ctlMsgType::L1CTL__GPRS__RTS__IND);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
    new_val.RAW_encode(L1ctlMsgType_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  }
  return myleaf.length = encoded_length;
}

struct L1ctlMessage_template::single_value_struct {
L1ctlHeader_template field_header;
L1ctlUlInfo_template field_ul__info;
L1ctlDlInfo_template field_dl__info;
L1ctlMsgPayload_template field_payload;
};

void L1ctlMessage_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_header = ANY_VALUE;
single_value->field_ul__info = ANY_OR_OMIT;
single_value->field_dl__info = ANY_OR_OMIT;
single_value->field_payload = ANY_OR_OMIT;
}
}
}

void L1ctlMessage_template::copy_value(const L1ctlMessage& other_value)
{
single_value = new single_value_struct;
if (other_value.header().is_bound()) {
  single_value->field_header = other_value.header();
} else {
  single_value->field_header.clean_up();
}
if (other_value.ul__info().is_bound()) {
  if (other_value.ul__info().ispresent()) single_value->field_ul__info = other_value.ul__info()();
  else single_value->field_ul__info = OMIT_VALUE;
} else {
  single_value->field_ul__info.clean_up();
}
if (other_value.dl__info().is_bound()) {
  if (other_value.dl__info().ispresent()) single_value->field_dl__info = other_value.dl__info()();
  else single_value->field_dl__info = OMIT_VALUE;
} else {
  single_value->field_dl__info.clean_up();
}
if (other_value.payload().is_bound()) {
  if (other_value.payload().ispresent()) single_value->field_payload = other_value.payload()();
  else single_value->field_payload = OMIT_VALUE;
} else {
  single_value->field_payload.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void L1ctlMessage_template::copy_template(const L1ctlMessage_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.header().get_selection()) {
single_value->field_header = other_value.header();
} else {
single_value->field_header.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ul__info().get_selection()) {
single_value->field_ul__info = other_value.ul__info();
} else {
single_value->field_ul__info.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.dl__info().get_selection()) {
single_value->field_dl__info = other_value.dl__info();
} else {
single_value->field_dl__info.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.payload().get_selection()) {
single_value->field_payload = other_value.payload();
} else {
single_value->field_payload.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new L1ctlMessage_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new L1ctlMessage_template(*other_value.implication_.precondition);
implication_.implied_template = new L1ctlMessage_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @L1CTL_Types.L1ctlMessage.");
break;
}
set_selection(other_value);
}

L1ctlMessage_template::L1ctlMessage_template()
{
}

L1ctlMessage_template::L1ctlMessage_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

L1ctlMessage_template::L1ctlMessage_template(const L1ctlMessage& other_value)
{
copy_value(other_value);
}

L1ctlMessage_template::L1ctlMessage_template(const OPTIONAL<L1ctlMessage>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const L1ctlMessage&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @L1CTL_Types.L1ctlMessage from an unbound optional field.");
}
}

L1ctlMessage_template::L1ctlMessage_template(L1ctlMessage_template* p_precondition, L1ctlMessage_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

L1ctlMessage_template::L1ctlMessage_template(Dynamic_Match_Interface<L1ctlMessage>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<L1ctlMessage>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

L1ctlMessage_template::L1ctlMessage_template(const L1ctlMessage_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

L1ctlMessage_template::~L1ctlMessage_template()
{
clean_up();
}

L1ctlMessage_template& L1ctlMessage_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

L1ctlMessage_template& L1ctlMessage_template::operator=(const L1ctlMessage& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

L1ctlMessage_template& L1ctlMessage_template::operator=(const OPTIONAL<L1ctlMessage>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const L1ctlMessage&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @L1CTL_Types.L1ctlMessage.");
}
return *this;
}

L1ctlMessage_template& L1ctlMessage_template::operator=(const L1ctlMessage_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean L1ctlMessage_template::match(const L1ctlMessage& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.header().is_bound()) return FALSE;
if(!single_value->field_header.match(other_value.header(), legacy))return FALSE;
if(!other_value.ul__info().is_bound()) return FALSE;
if((other_value.ul__info().ispresent() ? !single_value->field_ul__info.match((const L1ctlUlInfo&)other_value.ul__info(), legacy) : !single_value->field_ul__info.match_omit(legacy)))return FALSE;
if(!other_value.dl__info().is_bound()) return FALSE;
if((other_value.dl__info().ispresent() ? !single_value->field_dl__info.match((const L1ctlDlInfo&)other_value.dl__info(), legacy) : !single_value->field_dl__info.match_omit(legacy)))return FALSE;
if(!other_value.payload().is_bound()) return FALSE;
if((other_value.payload().ispresent() ? !single_value->field_payload.match((const L1ctlMsgPayload&)other_value.payload(), legacy) : !single_value->field_payload.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @L1CTL_Types.L1ctlMessage.");
}
return FALSE;
}

boolean L1ctlMessage_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_header.is_bound()
 || (single_value->field_ul__info.is_omit() || single_value->field_ul__info.is_bound())
 || (single_value->field_dl__info.is_omit() || single_value->field_dl__info.is_bound())
 || (single_value->field_payload.is_omit() || single_value->field_payload.is_bound());
}

boolean L1ctlMessage_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_header.is_value()
 && (single_value->field_ul__info.is_omit() || single_value->field_ul__info.is_value())
 && (single_value->field_dl__info.is_omit() || single_value->field_dl__info.is_value())
 && (single_value->field_payload.is_omit() || single_value->field_payload.is_value());
}

void L1ctlMessage_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

L1ctlMessage L1ctlMessage_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @L1CTL_Types.L1ctlMessage.");
L1ctlMessage ret_val;
if (single_value->field_header.is_bound()) {
ret_val.header() = single_value->field_header.valueof();
}
if (single_value->field_ul__info.is_omit()) ret_val.ul__info() = OMIT_VALUE;
else if (single_value->field_ul__info.is_bound()) {
ret_val.ul__info() = single_value->field_ul__info.valueof();
}
if (single_value->field_dl__info.is_omit()) ret_val.dl__info() = OMIT_VALUE;
else if (single_value->field_dl__info.is_bound()) {
ret_val.dl__info() = single_value->field_dl__info.valueof();
}
if (single_value->field_payload.is_omit()) ret_val.payload() = OMIT_VALUE;
else if (single_value->field_payload.is_bound()) {
ret_val.payload() = single_value->field_payload.valueof();
}
return ret_val;
}

void L1ctlMessage_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @L1CTL_Types.L1ctlMessage.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new L1ctlMessage_template[list_length];
}

L1ctlMessage_template& L1ctlMessage_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @L1CTL_Types.L1ctlMessage.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @L1CTL_Types.L1ctlMessage.");
return value_list.list_value[list_index];
}

L1ctlHeader_template& L1ctlMessage_template::header()
{
set_specific();
return single_value->field_header;
}

const L1ctlHeader_template& L1ctlMessage_template::header() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field header of a non-specific template of type @L1CTL_Types.L1ctlMessage.");
return single_value->field_header;
}

L1ctlUlInfo_template& L1ctlMessage_template::ul__info()
{
set_specific();
return single_value->field_ul__info;
}

const L1ctlUlInfo_template& L1ctlMessage_template::ul__info() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ul_info of a non-specific template of type @L1CTL_Types.L1ctlMessage.");
return single_value->field_ul__info;
}

L1ctlDlInfo_template& L1ctlMessage_template::dl__info()
{
set_specific();
return single_value->field_dl__info;
}

const L1ctlDlInfo_template& L1ctlMessage_template::dl__info() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dl_info of a non-specific template of type @L1CTL_Types.L1ctlMessage.");
return single_value->field_dl__info;
}

L1ctlMsgPayload_template& L1ctlMessage_template::payload()
{
set_specific();
return single_value->field_payload;
}

const L1ctlMsgPayload_template& L1ctlMessage_template::payload() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field payload of a non-specific template of type @L1CTL_Types.L1ctlMessage.");
return single_value->field_payload;
}

int L1ctlMessage_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessage which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_ul__info.is_present()) ret_val++;
      if (single_value->field_dl__info.is_present()) ret_val++;
      if (single_value->field_payload.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessage containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessage containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessage containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessage containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessage containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessage containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessage containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessage containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @L1CTL_Types.L1ctlMessage.");
  }
  return 0;
}

void L1ctlMessage_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ header := ");
single_value->field_header.log();
TTCN_Logger::log_event_str(", ul_info := ");
single_value->field_ul__info.log();
TTCN_Logger::log_event_str(", dl_info := ");
single_value->field_dl__info.log();
TTCN_Logger::log_event_str(", payload := ");
single_value->field_payload.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void L1ctlMessage_template::log_match(const L1ctlMessage& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_header.match(match_value.header(), legacy)){
TTCN_Logger::log_logmatch_info(".header");
single_value->field_header.log_match(match_value.header(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.ul__info().ispresent()){
if(!single_value->field_ul__info.match(match_value.ul__info(), legacy)){
TTCN_Logger::log_logmatch_info(".ul_info");
single_value->field_ul__info.log_match(match_value.ul__info(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ul__info.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ul_info := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ul__info.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.dl__info().ispresent()){
if(!single_value->field_dl__info.match(match_value.dl__info(), legacy)){
TTCN_Logger::log_logmatch_info(".dl_info");
single_value->field_dl__info.log_match(match_value.dl__info(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_dl__info.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".dl_info := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_dl__info.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.payload().ispresent()){
if(!single_value->field_payload.match(match_value.payload(), legacy)){
TTCN_Logger::log_logmatch_info(".payload");
single_value->field_payload.log_match(match_value.payload(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_payload.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".payload := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_payload.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ header := ");
single_value->field_header.log_match(match_value.header(), legacy);
TTCN_Logger::log_event_str(", ul_info := ");
if (match_value.ul__info().ispresent()) {
single_value->field_ul__info.log_match(match_value.ul__info(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ul__info.log();
if (single_value->field_ul__info.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", dl_info := ");
if (match_value.dl__info().ispresent()) {
single_value->field_dl__info.log_match(match_value.dl__info(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_dl__info.log();
if (single_value->field_dl__info.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", payload := ");
if (match_value.payload().ispresent()) {
single_value->field_payload.log_match(match_value.payload(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_payload.log();
if (single_value->field_payload.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void L1ctlMessage_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (header().is_bound()) header().set_implicit_omit();
if (!ul__info().is_bound()) ul__info() = OMIT_VALUE;
else ul__info().set_implicit_omit();
if (!dl__info().is_bound()) dl__info() = OMIT_VALUE;
else dl__info().set_implicit_omit();
if (!payload().is_bound()) payload() = OMIT_VALUE;
else payload().set_implicit_omit();
}

void L1ctlMessage_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_header.encode_text(text_buf);
single_value->field_ul__info.encode_text(text_buf);
single_value->field_dl__info.encode_text(text_buf);
single_value->field_payload.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @L1CTL_Types.L1ctlMessage.");
}
}

void L1ctlMessage_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_header.decode_text(text_buf);
single_value->field_ul__info.decode_text(text_buf);
single_value->field_dl__info.decode_text(text_buf);
single_value->field_payload.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new L1ctlMessage_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @L1CTL_Types.L1ctlMessage.");
}
}

void L1ctlMessage_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    L1ctlMessage_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @L1CTL_Types.L1ctlMessage has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) header().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ul__info().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) dl__info().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) payload().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "header")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          header().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ul_info")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ul__info().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dl_info")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dl__info().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "payload")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          payload().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @L1CTL_Types.L1ctlMessage: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    L1ctlMessage_template* precondition = new L1ctlMessage_template;
    precondition->set_param(*param.get_elem(0));
    L1ctlMessage_template* implied_template = new L1ctlMessage_template;
    implied_template->set_param(*param.get_elem(1));
    *this = L1ctlMessage_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@L1CTL_Types.L1ctlMessage");
  }
  is_ifpresent = param.get_ifpresent();
}

void L1ctlMessage_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_header.check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMessage");
single_value->field_ul__info.check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMessage");
single_value->field_dl__info.check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMessage");
single_value->field_payload.check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMessage");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@L1CTL_Types.L1ctlMessage");
}

boolean L1ctlMessage_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean L1ctlMessage_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

L1ctlMessageLV::L1ctlMessageLV()
{
}

L1ctlMessageLV::L1ctlMessageLV(const INTEGER& par_len,
    const L1ctlMessage& par_msg)
  :   field_len(par_len),
  field_msg(par_msg)
{
}

L1ctlMessageLV::L1ctlMessageLV(const L1ctlMessageLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @L1CTL_Types.L1ctlMessageLV.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.msg().is_bound()) field_msg = other_value.msg();
else field_msg.clean_up();
}

void L1ctlMessageLV::clean_up()
{
field_len.clean_up();
field_msg.clean_up();
}

const TTCN_Typedescriptor_t* L1ctlMessageLV::get_descriptor() const { return &L1ctlMessageLV_descr_; }
L1ctlMessageLV& L1ctlMessageLV::operator=(const L1ctlMessageLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @L1CTL_Types.L1ctlMessageLV.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.msg().is_bound()) field_msg = other_value.msg();
  else field_msg.clean_up();
}
return *this;
}

boolean L1ctlMessageLV::operator==(const L1ctlMessageLV& other_value) const
{
return field_len==other_value.field_len
  && field_msg==other_value.field_msg;
}

boolean L1ctlMessageLV::is_bound() const
{
return (field_len.is_bound())
  || (field_msg.is_bound());
}
boolean L1ctlMessageLV::is_value() const
{
return field_len.is_value()
  && field_msg.is_value();
}
void L1ctlMessageLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", msg := ");
field_msg.log();
TTCN_Logger::log_event_str(" }");
}

void L1ctlMessageLV::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (msg().is_bound()) msg().set_implicit_omit();
}

void L1ctlMessageLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @L1CTL_Types.L1ctlMessageLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) msg().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msg")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msg().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @L1CTL_Types.L1ctlMessageLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@L1CTL_Types.L1ctlMessageLV");
  }
}

void L1ctlMessageLV::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_msg.encode_text(text_buf);
}

void L1ctlMessageLV::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_msg.decode_text(text_buf);
}

void L1ctlMessageLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void L1ctlMessageLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int L1ctlMessageLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, L1ctlMessageLV_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(L1ctlMessageLV_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(L1ctlMessageLV_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, L1ctlMessage_descr_.raw->forceomit);
  decoded_field_length = field_msg.RAW_decode(L1ctlMessage_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int L1ctlMessageLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, L1ctlMessageLV_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, L1ctlMessage_descr_.raw);
  encoded_length += 16;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &L1ctlMessageLV_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 16;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_msg.RAW_encode(L1ctlMessage_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct L1ctlMessageLV_template::single_value_struct {
INTEGER_template field_len;
L1ctlMessage_template field_msg;
};

void L1ctlMessageLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_msg = ANY_VALUE;
}
}
}

void L1ctlMessageLV_template::copy_value(const L1ctlMessageLV& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.msg().is_bound()) {
  single_value->field_msg = other_value.msg();
} else {
  single_value->field_msg.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void L1ctlMessageLV_template::copy_template(const L1ctlMessageLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.msg().get_selection()) {
single_value->field_msg = other_value.msg();
} else {
single_value->field_msg.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new L1ctlMessageLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new L1ctlMessageLV_template(*other_value.implication_.precondition);
implication_.implied_template = new L1ctlMessageLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @L1CTL_Types.L1ctlMessageLV.");
break;
}
set_selection(other_value);
}

L1ctlMessageLV_template::L1ctlMessageLV_template()
{
}

L1ctlMessageLV_template::L1ctlMessageLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

L1ctlMessageLV_template::L1ctlMessageLV_template(const L1ctlMessageLV& other_value)
{
copy_value(other_value);
}

L1ctlMessageLV_template::L1ctlMessageLV_template(const OPTIONAL<L1ctlMessageLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const L1ctlMessageLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @L1CTL_Types.L1ctlMessageLV from an unbound optional field.");
}
}

L1ctlMessageLV_template::L1ctlMessageLV_template(L1ctlMessageLV_template* p_precondition, L1ctlMessageLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

L1ctlMessageLV_template::L1ctlMessageLV_template(Dynamic_Match_Interface<L1ctlMessageLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<L1ctlMessageLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

L1ctlMessageLV_template::L1ctlMessageLV_template(const L1ctlMessageLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

L1ctlMessageLV_template::~L1ctlMessageLV_template()
{
clean_up();
}

L1ctlMessageLV_template& L1ctlMessageLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

L1ctlMessageLV_template& L1ctlMessageLV_template::operator=(const L1ctlMessageLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

L1ctlMessageLV_template& L1ctlMessageLV_template::operator=(const OPTIONAL<L1ctlMessageLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const L1ctlMessageLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @L1CTL_Types.L1ctlMessageLV.");
}
return *this;
}

L1ctlMessageLV_template& L1ctlMessageLV_template::operator=(const L1ctlMessageLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean L1ctlMessageLV_template::match(const L1ctlMessageLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.msg().is_bound()) return FALSE;
if(!single_value->field_msg.match(other_value.msg(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @L1CTL_Types.L1ctlMessageLV.");
}
return FALSE;
}

boolean L1ctlMessageLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_msg.is_bound();
}

boolean L1ctlMessageLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_msg.is_value();
}

void L1ctlMessageLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

L1ctlMessageLV L1ctlMessageLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @L1CTL_Types.L1ctlMessageLV.");
L1ctlMessageLV ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_msg.is_bound()) {
ret_val.msg() = single_value->field_msg.valueof();
}
return ret_val;
}

void L1ctlMessageLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @L1CTL_Types.L1ctlMessageLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new L1ctlMessageLV_template[list_length];
}

L1ctlMessageLV_template& L1ctlMessageLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @L1CTL_Types.L1ctlMessageLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @L1CTL_Types.L1ctlMessageLV.");
return value_list.list_value[list_index];
}

INTEGER_template& L1ctlMessageLV_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& L1ctlMessageLV_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @L1CTL_Types.L1ctlMessageLV.");
return single_value->field_len;
}

L1ctlMessage_template& L1ctlMessageLV_template::msg()
{
set_specific();
return single_value->field_msg;
}

const L1ctlMessage_template& L1ctlMessageLV_template::msg() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field msg of a non-specific template of type @L1CTL_Types.L1ctlMessageLV.");
return single_value->field_msg;
}

int L1ctlMessageLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessageLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessageLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessageLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessageLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessageLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessageLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessageLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessageLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @L1CTL_Types.L1ctlMessageLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @L1CTL_Types.L1ctlMessageLV.");
  }
  return 0;
}

void L1ctlMessageLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", msg := ");
single_value->field_msg.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void L1ctlMessageLV_template::log_match(const L1ctlMessageLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_msg.match(match_value.msg(), legacy)){
TTCN_Logger::log_logmatch_info(".msg");
single_value->field_msg.log_match(match_value.msg(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", msg := ");
single_value->field_msg.log_match(match_value.msg(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void L1ctlMessageLV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (msg().is_bound()) msg().set_implicit_omit();
}

void L1ctlMessageLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_msg.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @L1CTL_Types.L1ctlMessageLV.");
}
}

void L1ctlMessageLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_msg.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new L1ctlMessageLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @L1CTL_Types.L1ctlMessageLV.");
}
}

void L1ctlMessageLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    L1ctlMessageLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @L1CTL_Types.L1ctlMessageLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) msg().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msg")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msg().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @L1CTL_Types.L1ctlMessageLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    L1ctlMessageLV_template* precondition = new L1ctlMessageLV_template;
    precondition->set_param(*param.get_elem(0));
    L1ctlMessageLV_template* implied_template = new L1ctlMessageLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = L1ctlMessageLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@L1CTL_Types.L1ctlMessageLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void L1ctlMessageLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMessageLV");
single_value->field_msg.check_restriction(t_res, t_name ? t_name : "@L1CTL_Types.L1ctlMessageLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@L1CTL_Types.L1ctlMessageLV");
}

boolean L1ctlMessageLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean L1ctlMessageLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


/* Bodies of functions, altsteps and testcases */

void L1ctlMsgType_encoder(const L1ctlMsgType& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlMsgType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlMsgType_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlMsgType_decoder(OCTETSTRING& input_stream, L1ctlMsgType& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlMsgType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlMsgType_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlCcchMode_encoder(const L1ctlCcchMode& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlCcchMode' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlCcchMode_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlCcchMode_decoder(OCTETSTRING& input_stream, L1ctlCcchMode& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlCcchMode' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlCcchMode_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlNeighMode_encoder(const L1ctlNeighMode& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlNeighMode' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlNeighMode_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlNeighMode_decoder(OCTETSTRING& input_stream, L1ctlNeighMode& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlNeighMode' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlNeighMode_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlResetType_encoder(const L1ctlResetType& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlResetType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlResetType_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlResetType_decoder(OCTETSTRING& input_stream, L1ctlResetType& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlResetType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlResetType_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlHdrFlags_f__done_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BOOLEAN_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlHdrFlags_f__done_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BOOLEAN_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlHdrFlags_encoder(const L1ctlHdrFlags& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlHdrFlags' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlHdrFlags_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlHdrFlags_decoder(OCTETSTRING& input_stream, L1ctlHdrFlags& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlHdrFlags' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlHdrFlags_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlHeader_encoder(const L1ctlHeader& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlHeader' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlHeader_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlHeader_decoder(OCTETSTRING& input_stream, L1ctlHeader& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlHeader' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlHeader_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

L1ctlHeader_template tr__L1ctlHeader(const L1ctlMsgType_template& msg__type)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 91, TTCN_Location::LOCATION_TEMPLATE, "tr_L1ctlHeader");
L1ctlHeader_template ret_val;
ret_val.msg__type() = msg__type;
ret_val.flags() = ANY_VALUE;
ret_val.padding() = ANY_VALUE;
return ret_val;
}

L1ctlHeader_template ts__L1ctlHeader(const L1ctlMsgType_template& msg__type)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 98, TTCN_Location::LOCATION_TEMPLATE, "ts_L1ctlHeader");
L1ctlHeader_template ret_val;
ret_val.msg__type() = msg__type;
{
L1ctlHdrFlags_template& tmp_0 = ret_val.flags();
tmp_0.padding() = bs_0;
tmp_0.f__done() = FALSE;
}
ret_val.padding() = os_0;
return ret_val;
}

void L1ctlDlInfo_encoder(const L1ctlDlInfo& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlDlInfo' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlDlInfo_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlDlInfo_decoder(OCTETSTRING& input_stream, L1ctlDlInfo& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlDlInfo' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlDlInfo_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlFbsbConf_encoder(const L1ctlFbsbConf& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlFbsbConf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlFbsbConf_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlFbsbConf_decoder(OCTETSTRING& input_stream, L1ctlFbsbConf& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlFbsbConf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlFbsbConf_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlCcchModeConf_encoder(const L1ctlCcchModeConf& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlCcchModeConf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlCcchModeConf_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlCcchModeConf_decoder(OCTETSTRING& input_stream, L1ctlCcchModeConf& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlCcchModeConf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlCcchModeConf_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlTchMode_encoder(const L1ctlTchMode& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlTchMode' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlTchMode_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlTchMode_decoder(OCTETSTRING& input_stream, L1ctlTchMode& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlTchMode' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlTchMode_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlLoopMode_encoder(const L1ctlLoopMode& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlLoopMode' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlLoopMode_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlLoopMode_decoder(OCTETSTRING& input_stream, L1ctlLoopMode& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlLoopMode' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlLoopMode_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlAudioMode_tx__microphone_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BOOLEAN_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlAudioMode_tx__microphone_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BOOLEAN_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlAudioMode_tx__traffic__req_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BOOLEAN_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlAudioMode_tx__traffic__req_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BOOLEAN_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlAudioMode_rx__speaker_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BOOLEAN_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlAudioMode_rx__speaker_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BOOLEAN_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlAudioMode_rx__traffic__ind_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BOOLEAN_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlAudioMode_rx__traffic__ind_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BOOLEAN_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlAudioMode_encoder(const L1ctlAudioMode& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlAudioMode' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlAudioMode_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlAudioMode_decoder(OCTETSTRING& input_stream, L1ctlAudioMode& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlAudioMode' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlAudioMode_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlTchModeConf_amr_encoder(const L1ctlTchModeConf_amr& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlTchModeConf.amr' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlTchModeConf_amr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlTchModeConf_amr_decoder(OCTETSTRING& input_stream, L1ctlTchModeConf_amr& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlTchModeConf.amr' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlTchModeConf_amr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlTchModeConf_encoder(const L1ctlTchModeConf& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlTchModeConf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlTchModeConf_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlTchModeConf_decoder(OCTETSTRING& input_stream, L1ctlTchModeConf& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlTchModeConf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlTchModeConf_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlDataInd_payload_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlDataInd_payload_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlDataInd_payload_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlDataInd_payload_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlDataInd_encoder(const L1ctlDataInd& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlDataInd' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlDataInd_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlDataInd_decoder(OCTETSTRING& input_stream, L1ctlDataInd& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlDataInd' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlDataInd_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlUlInfo_encoder(const L1ctlUlInfo& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlUlInfo' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlUlInfo_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlUlInfo_decoder(OCTETSTRING& input_stream, L1ctlUlInfo& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlUlInfo' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlUlInfo_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlFbsbFlags_padding_encoder(const BITSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlFbsbFlags_padding_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlFbsbFlags_padding_decoder(OCTETSTRING& input_stream, BITSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlFbsbFlags_padding_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlFbsbFlags_sb_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlFbsbFlags_sb_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlFbsbFlags_sb_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlFbsbFlags_sb_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlFbsbFlags_fb1_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlFbsbFlags_fb1_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlFbsbFlags_fb1_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlFbsbFlags_fb1_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlFbsbFlags_fb0_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlFbsbFlags_fb0_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlFbsbFlags_fb0_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlFbsbFlags_fb0_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlFbsbFlags_encoder(const L1ctlFbsbFlags& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlFbsbFlags' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlFbsbFlags_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlFbsbFlags_decoder(OCTETSTRING& input_stream, L1ctlFbsbFlags& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlFbsbFlags' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlFbsbFlags_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlFbsbReq_encoder(const L1ctlFbsbReq& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlFbsbReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlFbsbReq_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlFbsbReq_decoder(OCTETSTRING& input_stream, L1ctlFbsbReq& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlFbsbReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlFbsbReq_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlCcchModeReq_encoder(const L1ctlCcchModeReq& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlCcchModeReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlCcchModeReq_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlCcchModeReq_decoder(OCTETSTRING& input_stream, L1ctlCcchModeReq& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlCcchModeReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlCcchModeReq_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlTchModeReq_amr_encoder(const L1ctlTchModeReq_amr& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlTchModeReq.amr' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlTchModeReq_amr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlTchModeReq_amr_decoder(OCTETSTRING& input_stream, L1ctlTchModeReq_amr& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlTchModeReq.amr' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlTchModeReq_amr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlTchModeReq_encoder(const L1ctlTchModeReq& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlTchModeReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlTchModeReq_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlTchModeReq_decoder(OCTETSTRING& input_stream, L1ctlTchModeReq& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlTchModeReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlTchModeReq_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlRachReq_encoder(const L1ctlRachReq& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlRachReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlRachReq_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlRachReq_decoder(OCTETSTRING& input_stream, L1ctlRachReq& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlRachReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlRachReq_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlRachSynchSeq_encoder(const L1ctlRachSynchSeq& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlRachSynchSeq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlRachSynchSeq_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlRachSynchSeq_decoder(OCTETSTRING& input_stream, L1ctlRachSynchSeq& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlRachSynchSeq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlRachSynchSeq_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlExtRachReq_encoder(const L1ctlExtRachReq& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlExtRachReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlExtRachReq_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlExtRachReq_decoder(OCTETSTRING& input_stream, L1ctlExtRachReq& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlExtRachReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlExtRachReq_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlParReq_encoder(const L1ctlParReq& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlParReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlParReq_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlParReq_decoder(OCTETSTRING& input_stream, L1ctlParReq& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlParReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlParReq_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlDataReq_l2__payload_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlDataReq_l2__payload_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlDataReq_encoder(const L1ctlDataReq& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlDataReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlDataReq_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlDataReq_decoder(OCTETSTRING& input_stream, L1ctlDataReq& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlDataReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlDataReq_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlH0_padding_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlH0_padding_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlH0_padding_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlH0_padding_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlH0_encoder(const L1ctlH0& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlH0' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlH0_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlH0_decoder(OCTETSTRING& input_stream, L1ctlH0& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlH0' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlH0_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

boolean operator==(null_type, const L1ctlMA& other_value)
{
if (other_value.val_ptr == NULL)
TTCN_error("The right operand of comparison is an unbound value of type @L1CTL_Types.L1ctlMA.");
return other_value.val_ptr->n_elements == 0;
}

void L1ctlMA_encoder(const L1ctlMA& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlMA' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlMA_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlMA_decoder(OCTETSTRING& input_stream, L1ctlMA& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlMA' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlMA_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlH1_n_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlH1_n_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlH1_n_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlH1_n_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlH1_padding_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlH1_padding_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlH1_encoder(const L1ctlH1& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlH1' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlH1_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlH1_decoder(OCTETSTRING& input_stream, L1ctlH1& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlH1' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlH1_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlH0H1_encoder(const L1ctlH0H1& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlH0H1' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlH0H1_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlH0H1_decoder(OCTETSTRING& input_stream, L1ctlH0H1& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlH0H1' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlH0H1_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlDmEstReq_encoder(const L1ctlDmEstReq& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlDmEstReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlDmEstReq_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlDmEstReq_decoder(OCTETSTRING& input_stream, L1ctlDmEstReq& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlDmEstReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlDmEstReq_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlReset_encoder(const L1ctlReset& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlReset' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlReset_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlReset_decoder(OCTETSTRING& input_stream, L1ctlReset& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlReset' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlReset_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1CtlCryptoReq_key__len_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1CtlCryptoReq_key__len_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1CtlCryptoReq_key__len_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1CtlCryptoReq_key__len_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1CtlCryptoReq_key_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1CtlCryptoReq_key_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1CtlCryptoReq_encoder(const L1CtlCryptoReq& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1CtlCryptoReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1CtlCryptoReq_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1CtlCryptoReq_decoder(OCTETSTRING& input_stream, L1CtlCryptoReq& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1CtlCryptoReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1CtlCryptoReq_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlTrafficReq_data_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlTrafficReq_data_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlTrafficReq_data_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlTrafficReq_data_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlTrafficReq_encoder(const L1ctlTrafficReq& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlTrafficReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlTrafficReq_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlTrafficReq_decoder(OCTETSTRING& input_stream, L1ctlTrafficReq& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlTrafficReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlTrafficReq_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlGprsUlTbfCfgReq_slotmask_encoder(const BITSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlGprsUlTbfCfgReq_slotmask_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlGprsUlTbfCfgReq_slotmask_decoder(OCTETSTRING& input_stream, BITSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlGprsUlTbfCfgReq_slotmask_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlGprsUlTbfCfgReq_pad_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlGprsUlTbfCfgReq_pad_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlGprsUlTbfCfgReq_pad_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlGprsUlTbfCfgReq_pad_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlGprsUlTbfCfgReq_encoder(const L1ctlGprsUlTbfCfgReq& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlGprsUlTbfCfgReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlGprsUlTbfCfgReq_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlGprsUlTbfCfgReq_decoder(OCTETSTRING& input_stream, L1ctlGprsUlTbfCfgReq& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlGprsUlTbfCfgReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlGprsUlTbfCfgReq_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlGprsDlTbfCfgReq_slotmask_encoder(const BITSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlGprsDlTbfCfgReq_slotmask_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlGprsDlTbfCfgReq_slotmask_decoder(OCTETSTRING& input_stream, BITSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlGprsDlTbfCfgReq_slotmask_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlGprsDlTbfCfgReq_pad_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlGprsDlTbfCfgReq_pad_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlGprsDlTbfCfgReq_pad_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlGprsDlTbfCfgReq_pad_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlGprsDlTbfCfgReq_encoder(const L1ctlGprsDlTbfCfgReq& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlGprsDlTbfCfgReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlGprsDlTbfCfgReq_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlGprsDlTbfCfgReq_decoder(OCTETSTRING& input_stream, L1ctlGprsDlTbfCfgReq& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlGprsDlTbfCfgReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlGprsDlTbfCfgReq_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlGprsBlockHdr_pad_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlGprsBlockHdr_pad_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlGprsBlockHdr_pad_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlGprsBlockHdr_pad_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlGprsBlockHdr_encoder(const L1ctlGprsBlockHdr& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlGprsBlockHdr' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlGprsBlockHdr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlGprsBlockHdr_decoder(OCTETSTRING& input_stream, L1ctlGprsBlockHdr& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlGprsBlockHdr' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlGprsBlockHdr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlGprsUlBlockReq_data_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlGprsUlBlockReq_data_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlGprsUlBlockReq_data_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlGprsUlBlockReq_data_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlGprsUlBlockReq_encoder(const L1ctlGprsUlBlockReq& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlGprsUlBlockReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlGprsUlBlockReq_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlGprsUlBlockReq_decoder(OCTETSTRING& input_stream, L1ctlGprsUlBlockReq& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlGprsUlBlockReq' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlGprsUlBlockReq_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlGprsUlBlockCnf_data_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlGprsUlBlockCnf_data_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlGprsUlBlockCnf_encoder(const L1ctlGprsUlBlockCnf& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlGprsUlBlockCnf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlGprsUlBlockCnf_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlGprsUlBlockCnf_decoder(OCTETSTRING& input_stream, L1ctlGprsUlBlockCnf& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlGprsUlBlockCnf' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlGprsUlBlockCnf_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlGprsDlBlockInd_meas_encoder(const L1ctlGprsDlBlockInd_meas& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlGprsDlBlockInd.meas' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlGprsDlBlockInd_meas_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlGprsDlBlockInd_meas_decoder(OCTETSTRING& input_stream, L1ctlGprsDlBlockInd_meas& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlGprsDlBlockInd.meas' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlGprsDlBlockInd_meas_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlGprsDlBlockInd_data_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlGprsDlBlockInd_data_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlGprsDlBlockInd_data_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlGprsDlBlockInd_data_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlGprsDlBlockInd_encoder(const L1ctlGprsDlBlockInd& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlGprsDlBlockInd' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlGprsDlBlockInd_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlGprsDlBlockInd_decoder(OCTETSTRING& input_stream, L1ctlGprsDlBlockInd& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlGprsDlBlockInd' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlGprsDlBlockInd_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlGprsRtsInd_encoder(const L1ctlGprsRtsInd& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlGprsRtsInd' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlGprsRtsInd_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlGprsRtsInd_decoder(OCTETSTRING& input_stream, L1ctlGprsRtsInd& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlGprsRtsInd' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlGprsRtsInd_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlMsgPayload_other_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlMsgPayload_other_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlMsgPayload_other_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlMsgPayload_other_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlMsgPayload_encoder(const L1ctlMsgPayload& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlMsgPayload' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlMsgPayload_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlMsgPayload_decoder(OCTETSTRING& input_stream, L1ctlMsgPayload& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlMsgPayload' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlMsgPayload_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlMessage_ul__info_encoder(const L1ctlUlInfo& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlUlInfo' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlMessage_ul__info_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlMessage_ul__info_decoder(OCTETSTRING& input_stream, L1ctlUlInfo& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlUlInfo' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlMessage_ul__info_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlMessage_dl__info_encoder(const L1ctlDlInfo& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlDlInfo' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlMessage_dl__info_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlMessage_dl__info_decoder(OCTETSTRING& input_stream, L1ctlDlInfo& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlDlInfo' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlMessage_dl__info_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlMessage_payload_encoder(const L1ctlMsgPayload& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlMsgPayload' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlMessage_payload_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlMessage_payload_decoder(OCTETSTRING& input_stream, L1ctlMsgPayload& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlMsgPayload' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlMessage_payload_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlMessage_encoder(const L1ctlMessage& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlMessage' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlMessage_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlMessage_decoder(OCTETSTRING& input_stream, L1ctlMessage& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlMessage' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlMessage_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

OCTETSTRING enc__L1ctlMessage(const L1ctlMessage& msg)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_L1ctlMessage(): Encoding @L1CTL_Types.L1ctlMessage: ");
msg.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_DEFAULT);
TTCN_Buffer ttcn_buffer;
msg.encode(L1ctlMessage_descr_, ttcn_buffer, TTCN_EncDec::CT_RAW, 0);
OCTETSTRING ret_val;
ttcn_buffer.get_string(ret_val);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_L1ctlMessage(): Stream after encoding: ");
ret_val.log();
TTCN_Logger::end_event();
}
return ret_val;
}

L1ctlMessage dec__L1ctlMessage(const OCTETSTRING& stream)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_L1ctlMessage(): Stream before decoding: ");
stream.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_DEFAULT);
TTCN_EncDec::clear_error();
TTCN_Buffer ttcn_buffer(stream);
L1ctlMessage ret_val;
ret_val.decode(L1ctlMessage_descr_, ttcn_buffer, TTCN_EncDec::CT_RAW);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_L1ctlMessage(): Decoded @L1CTL_Types.L1ctlMessage: ");
ret_val.log();
TTCN_Logger::end_event();
}
if (TTCN_EncDec::get_last_error_type() == TTCN_EncDec::ET_NONE) {
if (ttcn_buffer.get_pos() < ttcn_buffer.get_len()) {
ttcn_buffer.cut();
OCTETSTRING tmp_os;
ttcn_buffer.get_string(tmp_os);
TTCN_Logger::begin_event_log2str();
tmp_os.log();
CHARSTRING remaining_stream = TTCN_Logger::end_event_log2str();
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_EXTRA_DATA, "dec_L1ctlMessage(): Data remained at the end of the stream after successful decoding: %s", (const char*) remaining_stream);
}
}
return ret_val;
}

void L1ctlMessageLV_len_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlMessageLV_len_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlMessageLV_len_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlMessageLV_len_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void L1ctlMessageLV_encoder(const L1ctlMessageLV& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlMessageLV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(L1ctlMessageLV_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER L1ctlMessageLV_decoder(OCTETSTRING& input_stream, L1ctlMessageLV& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@L1CTL_Types.L1ctlMessageLV' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(L1ctlMessageLV_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

OCTETSTRING enc__L1ctlMessageLV(const L1ctlMessageLV& msg)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_L1ctlMessageLV(): Encoding @L1CTL_Types.L1ctlMessageLV: ");
msg.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_DEFAULT);
TTCN_Buffer ttcn_buffer;
msg.encode(L1ctlMessageLV_descr_, ttcn_buffer, TTCN_EncDec::CT_RAW, 0);
OCTETSTRING ret_val;
ttcn_buffer.get_string(ret_val);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_L1ctlMessageLV(): Stream after encoding: ");
ret_val.log();
TTCN_Logger::end_event();
}
return ret_val;
}

L1ctlMessageLV dec__L1ctlMessageLV(const OCTETSTRING& stream)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_L1ctlMessageLV(): Stream before decoding: ");
stream.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_DEFAULT);
TTCN_EncDec::clear_error();
TTCN_Buffer ttcn_buffer(stream);
L1ctlMessageLV ret_val;
ret_val.decode(L1ctlMessageLV_descr_, ttcn_buffer, TTCN_EncDec::CT_RAW);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_L1ctlMessageLV(): Decoded @L1CTL_Types.L1ctlMessageLV: ");
ret_val.log();
TTCN_Logger::end_event();
}
if (TTCN_EncDec::get_last_error_type() == TTCN_EncDec::ET_NONE) {
if (ttcn_buffer.get_pos() < ttcn_buffer.get_len()) {
ttcn_buffer.cut();
OCTETSTRING tmp_os;
ttcn_buffer.get_string(tmp_os);
TTCN_Logger::begin_event_log2str();
tmp_os.log();
CHARSTRING remaining_stream = TTCN_Logger::end_event_log2str();
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_EXTRA_DATA, "dec_L1ctlMessageLV(): Data remained at the end of the stream after successful decoding: %s", (const char*) remaining_stream);
}
}
return ret_val;
}

L1ctlMessage_template t__L1ctlResetReq(const L1ctlResetType_template& rst__type)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 482, TTCN_Location::LOCATION_TEMPLATE, "t_L1ctlResetReq");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__RESET__REQ));
ret_val.ul__info() = OMIT_VALUE;
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlReset_template& tmp_1 = ret_val.payload().reset__req();
tmp_1.reset__type() = rst__type;
tmp_1.padding() = os_1;
}
return ret_val;
}

L1ctlMessage_template ts__L1CTL__FBSB__REQ(const GSM__Types::GsmBandArfcn_template& arfcn, const L1ctlFbsbFlags_template& flags, const INTEGER_template& sync__info__idx, const L1ctlCcchMode_template& ccch__mode, const INTEGER_template& rxlev__exp)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 496, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_FBSB_REQ");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__FBSB__REQ));
ret_val.ul__info() = OMIT_VALUE;
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlFbsbReq_template& tmp_2 = ret_val.payload().fbsb__req();
tmp_2.arfcn() = arfcn;
tmp_2.timeout__tdma__frames() = 250;
tmp_2.freq__err__thresh1() = 10000;
tmp_2.freq__err__thresh2() = 800;
tmp_2.num__freqerr__avg() = 3;
tmp_2.flags() = flags;
tmp_2.sync__info__idx() = sync__info__idx;
tmp_2.ccch__mode() = ccch__mode;
tmp_2.rxlev__exp() = rxlev__exp;
}
return ret_val;
}

L1ctlMessage_template tr__L1CTL__FBSB__CONF(const INTEGER_template& result)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 521, TTCN_Location::LOCATION_TEMPLATE, "tr_L1CTL_FBSB_CONF");
L1ctlMessage_template ret_val;
ret_val.header() = tr__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__FBSB__CONF));
ret_val.ul__info() = OMIT_VALUE;
ret_val.dl__info() = ANY_VALUE;
{
L1ctlFbsbConf_template& tmp_3 = ret_val.payload().fbsb__conf();
tmp_3.initial__freq__err() = ANY_VALUE;
tmp_3.result() = result;
tmp_3.bsic() = ANY_VALUE;
}
return ret_val;
}

L1ctlMessage_template ts__L1CTL__CCCH__MODE__REQ(const L1ctlCcchMode_template& ccch__mode)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 535, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_CCCH_MODE_REQ");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__CCCH__MODE__REQ));
ret_val.ul__info() = OMIT_VALUE;
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlCcchModeReq_template& tmp_4 = ret_val.payload().ccch__mode__req();
tmp_4.ccch__mode() = ccch__mode;
tmp_4.padding() = os_1;
}
return ret_val;
}

L1ctlMessage_template ts__L1CTL__TCH__MODE__REQ(const L1ctlTchMode_template& tch__mode, const L1ctlAudioMode_template& audio__mode, const L1ctlLoopMode_template& loop__mode, const INTEGER_template& amr__start__codec, const BITSTRING_template& amr__codecs__bitmask)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 548, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_TCH_MODE_REQ");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__TCH__MODE__REQ));
ret_val.ul__info() = OMIT_VALUE;
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlTchModeReq_template& tmp_5 = ret_val.payload().tch__mode__req();
tmp_5.tch__mode() = tch__mode;
tmp_5.audio__mode() = audio__mode;
tmp_5.loop__mode() = loop__mode;
{
L1ctlTchModeReq_amr_template& tmp_6 = tmp_5.amr();
tmp_6.start__codec() = amr__start__codec;
tmp_6.codecs__bitmask() = amr__codecs__bitmask;
}
}
return ret_val;
}

L1ctlMessage_template tr__L1CTL__MsgType(const L1ctlMsgType_template& msg__type)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 571, TTCN_Location::LOCATION_TEMPLATE, "tr_L1CTL_MsgType");
L1ctlMessage_template ret_val;
ret_val.header() = tr__L1ctlHeader(msg__type);
ret_val.ul__info() = ANY_OR_OMIT;
ret_val.dl__info() = ANY_OR_OMIT;
ret_val.payload() = ANY_OR_OMIT;
return ret_val;
}

L1ctlMessage_template ts__L1CTL__RACH__REQ(const INTEGER_template& ra, const INTEGER_template& combined, const INTEGER_template& offset, const GSM__Types::RslChannelNr_template& chan__nr, const GSM__Types::RslLinkId_template& link__id)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 581, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_RACH_REQ");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__RACH__REQ));
{
L1ctlUlInfo_template& tmp_7 = ret_val.ul__info();
tmp_7.chan__nr() = chan__nr;
tmp_7.link__id() = link__id;
tmp_7.padding() = os_0;
}
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlRachReq_template& tmp_8 = ret_val.payload().rach__req();
tmp_8.ra() = ra;
tmp_8.combined() = combined;
tmp_8.offset() = offset;
}
return ret_val;
}

L1ctlMessage_template ts__L1CTL__EXT__RACH__REQ(const INTEGER_template& ra11, const L1ctlRachSynchSeq_template& seq, const INTEGER_template& combined, const INTEGER_template& offset)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 603, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_EXT_RACH_REQ");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__EXT__RACH__REQ));
{
L1ctlUlInfo_template& tmp_9 = ret_val.ul__info();
tmp_9.chan__nr() = GSM__Types::ts__RslChanNr__RACH(0);
tmp_9.link__id() = GSM__Types::ts__RslLinkID__DCCH(0);
tmp_9.padding() = os_0;
}
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlExtRachReq_template& tmp_10 = ret_val.payload().ext__rach__req();
tmp_10.ra11() = ra11;
tmp_10.synch__seq() = seq;
tmp_10.combined() = combined;
tmp_10.offset() = offset;
}
return ret_val;
}

L1ctlMessage_template ts__L1CTL__PAR__REQ(const INTEGER_template& ta, const INTEGER_template& tx__power)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 626, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_PAR_REQ");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__PARAM__REQ));
{
L1ctlUlInfo_template& tmp_11 = ret_val.ul__info();
tmp_11.chan__nr() = GSM__Types::ts__RslChanNr__RACH(0);
tmp_11.link__id() = GSM__Types::ts__RslLinkID__DCCH(0);
tmp_11.padding() = os_0;
}
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlParReq_template& tmp_12 = ret_val.payload().par__req();
tmp_12.ta() = ta;
tmp_12.tx__power() = tx__power;
tmp_12.padding() = os_0;
}
return ret_val;
}

L1ctlMessage_template ts__L1CTL__DM__EST__REQ(const GSM__Types::RslChannelNr_template& chan__nr, const INTEGER_template& tsc)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 646, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_DM_EST_REQ");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__DM__EST__REQ));
{
L1ctlUlInfo_template& tmp_13 = ret_val.ul__info();
tmp_13.chan__nr() = chan__nr;
tmp_13.link__id() = GSM__Types::ts__RslLinkID__DCCH(0);
tmp_13.padding() = os_0;
}
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlDmEstReq_template& tmp_14 = ret_val.payload().dm__est__req();
tmp_14.tsc() = tsc;
tmp_14.tch__mode() = L1ctlTchMode::L1CTL__CHAN__MODE__SIGN;
tmp_14.audio__mode() = t__L1CTL__AudioModeFwd;
}
ret_val.check_restriction(TR_VALUE);
return ret_val;
}

L1ctlMessage_template ts__L1CTL__DM__EST__REQ__H0(const GSM__Types::RslChannelNr_template& chan__nr, const INTEGER_template& tsc, const INTEGER_template& arfcn)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 666, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_DM_EST_REQ_H0");
L1ctlMessage_template ret_val(ts__L1CTL__DM__EST__REQ(chan__nr, tsc));
{
L1ctlH0_template& tmp_15 = ret_val.payload().dm__est__req().h0h1().h0();
tmp_15.h() = 0;
tmp_15.arfcn() = GSM__Types::ts__GsmBandArfcn(arfcn, GSM__Types::ts__GsmBandArfcn_pcs_defval, GSM__Types::ts__GsmBandArfcn_uplink_defval);
tmp_15.padding() = Osmocom__Types::f__pad__oct(os_2, 130, os_3);
}
return ret_val;
}

L1ctlMessage_template ts__L1CTL__DM__EST__REQ__H1(const GSM__Types::RslChannelNr_template& chan__nr, const INTEGER_template& tsc, const INTEGER_template& hsn, const INTEGER_template& maio, const L1ctlMA_template& ma)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 684, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_DM_EST_REQ_H1");
L1ctlMessage_template ret_val(ts__L1CTL__DM__EST__REQ(chan__nr, tsc));
{
L1ctlH1_template& tmp_16 = ret_val.payload().dm__est__req().h0h1().h1();
tmp_16.h() = 1;
tmp_16.hsn() = hsn;
tmp_16.maio() = maio;
tmp_16.n() = ma.size_of();
tmp_16.spare() = os_3;
tmp_16.ma() = ma;
tmp_16.padding() = Osmocom__Types::f__pad__oct(os_2, ((64 - ma.size_of()) * 2), os_3);
}
return ret_val;
}

L1ctlMessage_template ts__L1CTL__DM__REL__REQ(const GSM__Types::RslChannelNr_template& chan__nr)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 709, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_DM_REL_REQ");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__DM__REL__REQ));
{
L1ctlUlInfo_template& tmp_17 = ret_val.ul__info();
tmp_17.chan__nr() = chan__nr;
tmp_17.link__id() = GSM__Types::ts__RslLinkID__DCCH(0);
tmp_17.padding() = os_0;
}
ret_val.dl__info() = OMIT_VALUE;
ret_val.payload() = OMIT_VALUE;
return ret_val;
}

L1ctlMessage_template ts__L1CTL__DATA__REQ(const GSM__Types::RslChannelNr_template& chan__nr, const GSM__Types::RslLinkId_template& link__id, const OCTETSTRING& l2__data)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 721, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_DATA_REQ");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__DATA__REQ));
{
L1ctlUlInfo_template& tmp_18 = ret_val.ul__info();
tmp_18.chan__nr() = chan__nr;
tmp_18.link__id() = link__id;
tmp_18.padding() = os_0;
}
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlDataReq_template& tmp_19 = ret_val.payload().data__req();
tmp_19.l1header() = OMIT_VALUE;
tmp_19.l2__payload() = l2__data;
}
return ret_val;
}

L1ctlMessage_template ts__L1CTL__DATA__REQ__SACCH(const GSM__Types::RslChannelNr_template& chan__nr, const GSM__Types::RslLinkId_template& link__id, const GSM__RR__Types::SacchL1Header_template& l1h, const OCTETSTRING& l2__data)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 740, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_DATA_REQ_SACCH");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__DATA__REQ));
{
L1ctlUlInfo_template& tmp_20 = ret_val.ul__info();
tmp_20.chan__nr() = chan__nr;
tmp_20.link__id() = link__id;
tmp_20.padding() = os_0;
}
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlDataReq_template& tmp_21 = ret_val.payload().data__req();
tmp_21.l1header() = l1h;
tmp_21.l2__payload() = l2__data;
}
return ret_val;
}

L1ctlMessage_template ts__L1CTL__TRAFFIC__REQ(const GSM__Types::RslChannelNr_template& chan__nr, const GSM__Types::RslLinkId_template& link__id, const OCTETSTRING& frame)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 760, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_TRAFFIC_REQ");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__TRAFFIC__REQ));
{
L1ctlUlInfo_template& tmp_22 = ret_val.ul__info();
tmp_22.chan__nr() = chan__nr;
tmp_22.link__id() = link__id;
tmp_22.padding() = os_0;
}
ret_val.dl__info() = OMIT_VALUE;
ret_val.payload().traffic__req().data() = frame;
return ret_val;
}

L1ctlMessage_template ts__L1CTL__DATA__IND(const GSM__Types::RslChannelNr_template& chan__nr, const GSM__Types::RslLinkId_template& link__id, const OCTETSTRING_template& l2__data, const GSM__Types::GsmBandArfcn_template& arfcn, const INTEGER_template& fn, const INTEGER_template& rx__level, const INTEGER_template& num__biterr, const INTEGER_template& fire__crc)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 787, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_DATA_IND");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__DATA__IND));
ret_val.ul__info() = OMIT_VALUE;
{
L1ctlDlInfo_template& tmp_23 = ret_val.dl__info();
tmp_23.chan__nr() = chan__nr;
tmp_23.link__id() = link__id;
tmp_23.arfcn() = arfcn;
tmp_23.frame__nr() = fn;
tmp_23.rx__level() = rx__level;
tmp_23.snr() = 0;
tmp_23.num__biterr() = num__biterr;
tmp_23.fire__crc() = fire__crc;
}
ret_val.payload().data__ind().payload() = l2__data;
return ret_val;
}

L1ctlMessage_template tr__L1CTL__DATA__IND(const GSM__Types::RslChannelNr_template& chan__nr, const GSM__Types::RslLinkId_template& link__id, const OCTETSTRING_template& l2__data, const INTEGER_template& num__biterr, const INTEGER_template& fire__crc)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 814, TTCN_Location::LOCATION_TEMPLATE, "tr_L1CTL_DATA_IND");
L1ctlMessage_template ret_val;
ret_val.header() = tr__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__DATA__IND));
ret_val.ul__info() = OMIT_VALUE;
{
L1ctlDlInfo_template& tmp_24 = ret_val.dl__info();
tmp_24.chan__nr() = chan__nr;
tmp_24.link__id() = link__id;
tmp_24.arfcn() = ANY_VALUE;
tmp_24.frame__nr() = ANY_VALUE;
tmp_24.rx__level() = ANY_VALUE;
tmp_24.snr() = ANY_VALUE;
tmp_24.num__biterr() = num__biterr;
tmp_24.fire__crc() = fire__crc;
}
ret_val.payload().data__ind().payload() = l2__data;
return ret_val;
}

L1ctlMessage_template ts__L1CTL__DATA__CONF(const GSM__Types::RslChannelNr_template& chan__nr, const GSM__Types::RslLinkId_template& link__id, const GSM__Types::GsmBandArfcn_template& arfcn, const INTEGER_template& fn)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 840, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_DATA_CONF");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__DATA__CONF));
ret_val.ul__info() = OMIT_VALUE;
{
L1ctlDlInfo_template& tmp_25 = ret_val.dl__info();
tmp_25.chan__nr() = chan__nr;
tmp_25.link__id() = link__id;
tmp_25.arfcn() = arfcn;
tmp_25.frame__nr() = fn;
tmp_25.rx__level() = 0;
tmp_25.snr() = 0;
tmp_25.num__biterr() = 0;
tmp_25.fire__crc() = 0;
}
ret_val.payload() = OMIT_VALUE;
return ret_val;
}

L1ctlMessage_template tr__L1CTL__DATA__CONF(const GSM__Types::RslChannelNr_template& chan__nr, const GSM__Types::RslLinkId_template& link__id, const GSM__Types::GsmBandArfcn_template& arfcn, const INTEGER_template& fn)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 859, TTCN_Location::LOCATION_TEMPLATE, "tr_L1CTL_DATA_CONF");
L1ctlMessage_template ret_val;
ret_val.header() = tr__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__DATA__CONF));
ret_val.ul__info() = OMIT_VALUE;
{
L1ctlDlInfo_template& tmp_26 = ret_val.dl__info();
tmp_26.chan__nr() = chan__nr;
tmp_26.link__id() = link__id;
tmp_26.arfcn() = arfcn;
tmp_26.frame__nr() = fn;
tmp_26.rx__level() = ANY_VALUE;
tmp_26.snr() = ANY_VALUE;
tmp_26.num__biterr() = ANY_VALUE;
tmp_26.fire__crc() = ANY_VALUE;
}
ret_val.payload() = OMIT_VALUE;
return ret_val;
}

L1ctlMessage_template ts__L1CTL__TRAFFIC__CONF(const GSM__Types::RslChannelNr_template& chan__nr, const GSM__Types::RslLinkId_template& link__id, const GSM__Types::GsmBandArfcn_template& arfcn, const INTEGER_template& fn)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 880, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_TRAFFIC_CONF");
L1ctlMessage_template ret_val(ts__L1CTL__DATA__CONF(chan__nr, link__id, arfcn, fn));
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__TRAFFIC__CONF));
return ret_val;
}

L1ctlMessage_template tr__L1CTL__TRAFFIC__CONF(const GSM__Types::RslChannelNr_template& chan__nr, const GSM__Types::RslLinkId_template& link__id, const GSM__Types::GsmBandArfcn_template& arfcn, const INTEGER_template& fn)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 888, TTCN_Location::LOCATION_TEMPLATE, "tr_L1CTL_TRAFFIC_CONF");
L1ctlMessage_template ret_val(tr__L1CTL__DATA__CONF(chan__nr, link__id, arfcn, fn));
ret_val.header() = tr__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__TRAFFIC__CONF));
return ret_val;
}

L1ctlMessage_template tr__L1CTL__TRAFFIC__IND(const GSM__Types::RslChannelNr_template& chan__nr, const GSM__Types::RslLinkId_template& link__id, const OCTETSTRING_template& frame, const INTEGER_template& num__biterr, const INTEGER_template& fire__crc)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 898, TTCN_Location::LOCATION_TEMPLATE, "tr_L1CTL_TRAFFIC_IND");
L1ctlMessage_template ret_val;
ret_val.header() = tr__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__TRAFFIC__IND));
ret_val.ul__info() = OMIT_VALUE;
{
L1ctlDlInfo_template& tmp_27 = ret_val.dl__info();
tmp_27.chan__nr() = chan__nr;
tmp_27.link__id() = link__id;
tmp_27.arfcn() = ANY_VALUE;
tmp_27.frame__nr() = ANY_VALUE;
tmp_27.rx__level() = ANY_VALUE;
tmp_27.snr() = ANY_VALUE;
tmp_27.num__biterr() = num__biterr;
tmp_27.fire__crc() = fire__crc;
}
ret_val.payload().traffic__ind().data() = frame;
return ret_val;
}

L1ctlMessage_template ts__L1CTL__CRYPTO__REQ(const GSM__Types::RslChannelNr_template& chan__nr, const INTEGER_template& algo, const OCTETSTRING_template& key)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 923, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_CRYPTO_REQ");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__CRYPTO__REQ));
{
L1ctlUlInfo_template& tmp_28 = ret_val.ul__info();
tmp_28.chan__nr() = chan__nr;
tmp_28.link__id() = GSM__Types::ts__RslLinkID__DCCH(0);
tmp_28.padding() = os_0;
}
ret_val.dl__info() = OMIT_VALUE;
{
L1CtlCryptoReq_template& tmp_29 = ret_val.payload().crypto__req();
tmp_29.algo() = algo;
tmp_29.key__len() = 0;
tmp_29.key() = key;
}
return ret_val;
}

L1ctlMessage_template ts__L1CTL__GPRS__UL__TBF__CFG__REQ(const INTEGER_template& tbf__ref, const BITSTRING_template& slotmask, const INTEGER_template& start__fn)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 944, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_GPRS_UL_TBF_CFG_REQ");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__GPRS__UL__TBF__CFG__REQ));
ret_val.ul__info() = OMIT_VALUE;
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlGprsUlTbfCfgReq_template& tmp_30 = ret_val.payload().ul__tbf__cfg__req();
tmp_30.tbf__ref() = tbf__ref;
tmp_30.slotmask() = slotmask;
tmp_30.pad() = os_0;
tmp_30.start__fn() = start__fn;
}
return ret_val;
}

L1ctlMessage_template tr__L1CTL__GPRS__UL__TBF__CFG__REQ(const INTEGER_template& tbf__ref, const BITSTRING_template& slotmask, const INTEGER_template& start__fn)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 960, TTCN_Location::LOCATION_TEMPLATE, "tr_L1CTL_GPRS_UL_TBF_CFG_REQ");
L1ctlMessage_template ret_val;
ret_val.header() = tr__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__GPRS__UL__TBF__CFG__REQ));
ret_val.ul__info() = OMIT_VALUE;
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlGprsUlTbfCfgReq_template& tmp_31 = ret_val.payload().ul__tbf__cfg__req();
tmp_31.tbf__ref() = tbf__ref;
tmp_31.slotmask() = slotmask;
tmp_31.pad() = ANY_VALUE;
tmp_31.start__fn() = start__fn;
}
return ret_val;
}

L1ctlMessage_template ts__L1CTL__GPRS__DL__TBF__CFG__REQ(const INTEGER_template& tbf__ref, const BITSTRING_template& slotmask, const INTEGER_template& start__fn, const INTEGER_template& dl__tfi)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 977, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_GPRS_DL_TBF_CFG_REQ");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__GPRS__DL__TBF__CFG__REQ));
ret_val.ul__info() = OMIT_VALUE;
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlGprsDlTbfCfgReq_template& tmp_32 = ret_val.payload().dl__tbf__cfg__req();
tmp_32.tbf__ref() = tbf__ref;
tmp_32.slotmask() = slotmask;
tmp_32.dl__tfi() = dl__tfi;
tmp_32.pad() = os_3;
tmp_32.start__fn() = start__fn;
}
return ret_val;
}

L1ctlMessage_template tr__L1CTL__GPRS__DL__TBF__CFG__REQ(const INTEGER_template& tbf__ref, const BITSTRING_template& slotmask, const INTEGER_template& start__fn, const INTEGER_template& dl__tfi)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 995, TTCN_Location::LOCATION_TEMPLATE, "tr_L1CTL_GPRS_DL_TBF_CFG_REQ");
L1ctlMessage_template ret_val;
ret_val.header() = tr__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__GPRS__DL__TBF__CFG__REQ));
ret_val.ul__info() = OMIT_VALUE;
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlGprsDlTbfCfgReq_template& tmp_33 = ret_val.payload().dl__tbf__cfg__req();
tmp_33.tbf__ref() = tbf__ref;
tmp_33.slotmask() = slotmask;
tmp_33.dl__tfi() = dl__tfi;
tmp_33.pad() = ANY_VALUE;
tmp_33.start__fn() = start__fn;
}
return ret_val;
}

L1ctlMessage_template ts__L1CTL__GPRS__UL__BLOCK__REQ(const INTEGER_template& fn, const INTEGER_template& tn, const OCTETSTRING_template& data)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 1014, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_GPRS_UL_BLOCK_REQ");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__GPRS__UL__BLOCK__REQ));
ret_val.ul__info() = OMIT_VALUE;
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlGprsUlBlockReq_template& tmp_34 = ret_val.payload().ul__block__req();
{
L1ctlGprsBlockHdr_template& tmp_35 = tmp_34.hdr();
tmp_35.fn() = fn;
tmp_35.tn() = tn;
tmp_35.pad() = os_1;
}
tmp_34.data() = data;
}
return ret_val;
}

L1ctlMessage_template tr__L1CTL__GPRS__UL__BLOCK__REQ(const INTEGER_template& fn, const INTEGER_template& tn, const OCTETSTRING_template& data)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 1032, TTCN_Location::LOCATION_TEMPLATE, "tr_L1CTL_GPRS_UL_BLOCK_REQ");
L1ctlMessage_template ret_val;
ret_val.header() = tr__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__GPRS__UL__BLOCK__REQ));
ret_val.ul__info() = OMIT_VALUE;
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlGprsUlBlockReq_template& tmp_36 = ret_val.payload().ul__block__req();
{
L1ctlGprsBlockHdr_template& tmp_37 = tmp_36.hdr();
tmp_37.fn() = fn;
tmp_37.tn() = tn;
tmp_37.pad() = ANY_VALUE;
}
tmp_36.data() = data;
}
return ret_val;
}

L1ctlMessage_template ts__L1CTL__GPRS__DL__BLOCK__IND(const INTEGER_template& fn, const INTEGER_template& tn, const INTEGER_template& usf, const OCTETSTRING_template& data, const INTEGER_template& ber10k, const INTEGER_template& ci__cb, const INTEGER_template& rx__level)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 1051, TTCN_Location::LOCATION_TEMPLATE, "ts_L1CTL_GPRS_DL_BLOCK_IND");
L1ctlMessage_template ret_val;
ret_val.header() = ts__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__GPRS__DL__BLOCK__IND));
ret_val.ul__info() = OMIT_VALUE;
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlGprsDlBlockInd_template& tmp_38 = ret_val.payload().dl__block__ind();
{
L1ctlGprsBlockHdr_template& tmp_39 = tmp_38.hdr();
tmp_39.fn() = fn;
tmp_39.tn() = tn;
tmp_39.pad() = os_1;
}
{
L1ctlGprsDlBlockInd_meas_template& tmp_40 = tmp_38.meas();
tmp_40.ber10k() = ber10k;
tmp_40.ci__cb() = ci__cb;
tmp_40.rx__level() = rx__level;
}
tmp_38.usf() = usf;
tmp_38.data() = data;
}
return ret_val;
}

L1ctlMessage_template tr__L1CTL__GPRS__DL__BLOCK__IND(const INTEGER_template& fn, const INTEGER_template& tn, const INTEGER_template& usf, const OCTETSTRING_template& data, const INTEGER_template& ber10k, const INTEGER_template& ci__cb, const INTEGER_template& rx__level)
{
TTCN_Location current_location("L1CTL_Types.ttcn", 1079, TTCN_Location::LOCATION_TEMPLATE, "tr_L1CTL_GPRS_DL_BLOCK_IND");
L1ctlMessage_template ret_val;
ret_val.header() = tr__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__GPRS__DL__BLOCK__IND));
ret_val.ul__info() = OMIT_VALUE;
ret_val.dl__info() = OMIT_VALUE;
{
L1ctlGprsDlBlockInd_template& tmp_41 = ret_val.payload().dl__block__ind();
{
L1ctlGprsBlockHdr_template& tmp_42 = tmp_41.hdr();
tmp_42.fn() = fn;
tmp_42.tn() = tn;
tmp_42.pad() = ANY_VALUE;
}
{
L1ctlGprsDlBlockInd_meas_template& tmp_43 = tmp_41.meas();
tmp_43.ber10k() = ber10k;
tmp_43.ci__cb() = ci__cb;
tmp_43.rx__level() = rx__level;
}
tmp_41.usf() = usf;
tmp_41.data() = data;
}
return ret_val;
}


/* Bodies of static functions */

void pre_init_module()
{
TTCN_Location current_location("L1CTL_Types.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "L1CTL_Types");
GSM__RR__Types::module_object.pre_init_module();
module_object.add_function("enc_L1ctlMessage", (genericfunc_t)&enc__L1ctlMessage, NULL);
module_object.add_function("dec_L1ctlMessage", (genericfunc_t)&dec__L1ctlMessage, NULL);
module_object.add_function("enc_L1ctlMessageLV", (genericfunc_t)&enc__L1ctlMessageLV, NULL);
module_object.add_function("dec_L1ctlMessageLV", (genericfunc_t)&dec__L1ctlMessageLV, NULL);
current_location.update_lineno(1108);
/* L1CTL_Types.ttcn, line 1108 */
const_c__DummyUI = os_4;
}

void post_init_module()
{
TTCN_Location current_location("L1CTL_Types.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "L1CTL_Types");
GSM__RR__Types::module_object.post_init_module();
current_location.update_lineno(158);
/* L1CTL_Types.ttcn, line 158 */
template_t__L1CTL__AudioModeNone.padding() = bs_1;
template_t__L1CTL__AudioModeNone.tx__microphone() = FALSE;
template_t__L1CTL__AudioModeNone.tx__traffic__req() = FALSE;
template_t__L1CTL__AudioModeNone.rx__speaker() = FALSE;
template_t__L1CTL__AudioModeNone.rx__traffic__ind() = FALSE;
current_location.update_lineno(161);
/* L1CTL_Types.ttcn, line 161 */
template_t__L1CTL__AudioModeFwd = t__L1CTL__AudioModeNone;
template_t__L1CTL__AudioModeFwd.tx__traffic__req() = TRUE;
template_t__L1CTL__AudioModeFwd.rx__traffic__ind() = TRUE;
current_location.update_lineno(196);
/* L1CTL_Types.ttcn, line 196 */
template_t__L1CTL__FBSB__F__ALL.padding() = bs_2;
template_t__L1CTL__FBSB__F__ALL.sb() = TRUE;
template_t__L1CTL__FBSB__F__ALL.fb1() = TRUE;
template_t__L1CTL__FBSB__F__ALL.fb0() = TRUE;
current_location.update_lineno(549);
/* L1CTL_Types.ttcn, line 549 */
template_ts__L1CTL__TCH__MODE__REQ_tch__mode_defval = L1ctlTchMode::L1CTL__CHAN__MODE__SIGN;
current_location.update_lineno(550);
/* L1CTL_Types.ttcn, line 550 */
template_ts__L1CTL__TCH__MODE__REQ_audio__mode_defval = t__L1CTL__AudioModeFwd;
current_location.update_lineno(551);
/* L1CTL_Types.ttcn, line 551 */
template_ts__L1CTL__TCH__MODE__REQ_loop__mode_defval = L1ctlLoopMode::L1CTL__LOOP__MODE__OPEN;
current_location.update_lineno(552);
/* L1CTL_Types.ttcn, line 552 */
template_ts__L1CTL__TCH__MODE__REQ_amr__start__codec_defval = 0;
current_location.update_lineno(553);
/* L1CTL_Types.ttcn, line 553 */
template_ts__L1CTL__TCH__MODE__REQ_amr__codecs__bitmask_defval = bs_3;
current_location.update_lineno(579);
/* L1CTL_Types.ttcn, line 579 */
template_tr__L1CTL__CCCH__MODE__CONF = tr__L1CTL__MsgType(L1ctlMsgType_template(L1ctlMsgType::L1CTL__CCCH__MODE__CONF));
current_location.update_lineno(585);
/* L1CTL_Types.ttcn, line 585 */
template_ts__L1CTL__RACH__REQ_chan__nr_defval = GSM__Types::ts__RslChanNr__RACH(0);
current_location.update_lineno(586);
/* L1CTL_Types.ttcn, line 586 */
template_ts__L1CTL__RACH__REQ_link__id_defval = GSM__Types::ts__RslLinkID__DCCH(0);
current_location.update_lineno(779);
/* L1CTL_Types.ttcn, line 779 */
template_tr__L1CTL__RACH__CONF.header() = tr__L1ctlHeader(L1ctlMsgType_template(L1ctlMsgType::L1CTL__RACH__CONF));
template_tr__L1CTL__RACH__CONF.ul__info() = OMIT_VALUE;
template_tr__L1CTL__RACH__CONF.dl__info() = ANY_VALUE;
template_tr__L1CTL__RACH__CONF.payload() = ANY_OR_OMIT;
current_location.update_lineno(792);
/* L1CTL_Types.ttcn, line 792 */
template_ts__L1CTL__DATA__IND_fn_defval = 1337;
current_location.update_lineno(793);
/* L1CTL_Types.ttcn, line 793 */
template_ts__L1CTL__DATA__IND_rx__level_defval = 63;
current_location.update_lineno(794);
/* L1CTL_Types.ttcn, line 794 */
template_ts__L1CTL__DATA__IND_num__biterr_defval = 0;
current_location.update_lineno(795);
/* L1CTL_Types.ttcn, line 795 */
template_ts__L1CTL__DATA__IND_fire__crc_defval = 0;
current_location.update_lineno(816);
/* L1CTL_Types.ttcn, line 816 */
template_tr__L1CTL__DATA__IND_link__id_defval = ANY_VALUE;
current_location.update_lineno(817);
/* L1CTL_Types.ttcn, line 817 */
template_tr__L1CTL__DATA__IND_l2__data_defval = ANY_VALUE;
current_location.update_lineno(818);
/* L1CTL_Types.ttcn, line 818 */
template_tr__L1CTL__DATA__IND_num__biterr_defval = 0;
current_location.update_lineno(819);
/* L1CTL_Types.ttcn, line 819 */
template_tr__L1CTL__DATA__IND_fire__crc_defval = 0;
current_location.update_lineno(861);
/* L1CTL_Types.ttcn, line 861 */
template_tr__L1CTL__DATA__CONF_link__id_defval = ANY_VALUE;
current_location.update_lineno(862);
/* L1CTL_Types.ttcn, line 862 */
template_tr__L1CTL__DATA__CONF_arfcn_defval = ANY_VALUE;
current_location.update_lineno(863);
/* L1CTL_Types.ttcn, line 863 */
template_tr__L1CTL__DATA__CONF_fn_defval = ANY_VALUE;
current_location.update_lineno(890);
/* L1CTL_Types.ttcn, line 890 */
template_tr__L1CTL__TRAFFIC__CONF_link__id_defval = ANY_VALUE;
current_location.update_lineno(891);
/* L1CTL_Types.ttcn, line 891 */
template_tr__L1CTL__TRAFFIC__CONF_arfcn_defval = ANY_VALUE;
current_location.update_lineno(892);
/* L1CTL_Types.ttcn, line 892 */
template_tr__L1CTL__TRAFFIC__CONF_fn_defval = ANY_VALUE;
current_location.update_lineno(900);
/* L1CTL_Types.ttcn, line 900 */
template_tr__L1CTL__TRAFFIC__IND_link__id_defval = ANY_VALUE;
current_location.update_lineno(901);
/* L1CTL_Types.ttcn, line 901 */
template_tr__L1CTL__TRAFFIC__IND_frame_defval = ANY_VALUE;
current_location.update_lineno(902);
/* L1CTL_Types.ttcn, line 902 */
template_tr__L1CTL__TRAFFIC__IND_num__biterr_defval = ANY_VALUE;
current_location.update_lineno(903);
/* L1CTL_Types.ttcn, line 903 */
template_tr__L1CTL__TRAFFIC__IND_fire__crc_defval = ANY_VALUE;
current_location.update_lineno(946);
/* L1CTL_Types.ttcn, line 946 */
template_ts__L1CTL__GPRS__UL__TBF__CFG__REQ_slotmask_defval = bs_3;
current_location.update_lineno(947);
/* L1CTL_Types.ttcn, line 947 */
template_ts__L1CTL__GPRS__UL__TBF__CFG__REQ_start__fn_defval = Osmocom__Types::c__UINT32__MAX;
current_location.update_lineno(961);
/* L1CTL_Types.ttcn, line 961 */
template_tr__L1CTL__GPRS__UL__TBF__CFG__REQ_tbf__ref_defval = ANY_VALUE;
current_location.update_lineno(962);
/* L1CTL_Types.ttcn, line 962 */
template_tr__L1CTL__GPRS__UL__TBF__CFG__REQ_slotmask_defval = ANY_VALUE;
current_location.update_lineno(963);
/* L1CTL_Types.ttcn, line 963 */
template_tr__L1CTL__GPRS__UL__TBF__CFG__REQ_start__fn_defval = ANY_VALUE;
current_location.update_lineno(979);
/* L1CTL_Types.ttcn, line 979 */
template_ts__L1CTL__GPRS__DL__TBF__CFG__REQ_slotmask_defval = bs_3;
current_location.update_lineno(980);
/* L1CTL_Types.ttcn, line 980 */
template_ts__L1CTL__GPRS__DL__TBF__CFG__REQ_start__fn_defval = Osmocom__Types::c__UINT32__MAX;
current_location.update_lineno(981);
/* L1CTL_Types.ttcn, line 981 */
template_ts__L1CTL__GPRS__DL__TBF__CFG__REQ_dl__tfi_defval = 0;
current_location.update_lineno(996);
/* L1CTL_Types.ttcn, line 996 */
template_tr__L1CTL__GPRS__DL__TBF__CFG__REQ_tbf__ref_defval = ANY_VALUE;
current_location.update_lineno(997);
/* L1CTL_Types.ttcn, line 997 */
template_tr__L1CTL__GPRS__DL__TBF__CFG__REQ_slotmask_defval = ANY_VALUE;
current_location.update_lineno(998);
/* L1CTL_Types.ttcn, line 998 */
template_tr__L1CTL__GPRS__DL__TBF__CFG__REQ_start__fn_defval = ANY_VALUE;
current_location.update_lineno(999);
/* L1CTL_Types.ttcn, line 999 */
template_tr__L1CTL__GPRS__DL__TBF__CFG__REQ_dl__tfi_defval = ANY_VALUE;
current_location.update_lineno(1033);
/* L1CTL_Types.ttcn, line 1033 */
template_tr__L1CTL__GPRS__UL__BLOCK__REQ_fn_defval = ANY_VALUE;
current_location.update_lineno(1034);
/* L1CTL_Types.ttcn, line 1034 */
template_tr__L1CTL__GPRS__UL__BLOCK__REQ_tn_defval = ANY_VALUE;
current_location.update_lineno(1035);
/* L1CTL_Types.ttcn, line 1035 */
template_tr__L1CTL__GPRS__UL__BLOCK__REQ_data_defval = ANY_VALUE;
current_location.update_lineno(1056);
/* L1CTL_Types.ttcn, line 1056 */
template_ts__L1CTL__GPRS__DL__BLOCK__IND_ber10k_defval = 0;
current_location.update_lineno(1057);
/* L1CTL_Types.ttcn, line 1057 */
template_ts__L1CTL__GPRS__DL__BLOCK__IND_ci__cb_defval = 180;
current_location.update_lineno(1058);
/* L1CTL_Types.ttcn, line 1058 */
template_ts__L1CTL__GPRS__DL__BLOCK__IND_rx__level_defval = 63;
current_location.update_lineno(1080);
/* L1CTL_Types.ttcn, line 1080 */
template_tr__L1CTL__GPRS__DL__BLOCK__IND_fn_defval = ANY_VALUE;
current_location.update_lineno(1081);
/* L1CTL_Types.ttcn, line 1081 */
template_tr__L1CTL__GPRS__DL__BLOCK__IND_tn_defval = ANY_VALUE;
current_location.update_lineno(1082);
/* L1CTL_Types.ttcn, line 1082 */
template_tr__L1CTL__GPRS__DL__BLOCK__IND_usf_defval = ANY_VALUE;
current_location.update_lineno(1083);
/* L1CTL_Types.ttcn, line 1083 */
template_tr__L1CTL__GPRS__DL__BLOCK__IND_data_defval = ANY_VALUE;
current_location.update_lineno(1084);
/* L1CTL_Types.ttcn, line 1084 */
template_tr__L1CTL__GPRS__DL__BLOCK__IND_ber10k_defval = ANY_VALUE;
current_location.update_lineno(1085);
/* L1CTL_Types.ttcn, line 1085 */
template_tr__L1CTL__GPRS__DL__BLOCK__IND_ci__cb_defval = ANY_VALUE;
current_location.update_lineno(1086);
/* L1CTL_Types.ttcn, line 1086 */
template_tr__L1CTL__GPRS__DL__BLOCK__IND_rx__level_defval = ANY_VALUE;
}


} /* end of namespace */
