#include "ngap_codec.hh"
#include "LibNGAP_TypesAndValues.hh"
#include "LibNGAP_EncdecDeclarations.hh"
#include "loggers.hh"

int ngap_codec::encode(const NGAP__PDU__Descriptions::NGAP__PDU& ngap, OCTETSTRING &data) {
  loggers::get_instance().log_msg(">>> ngap_codec::encode: ", ngap);

  BITSTRING bs = LibNGAP__EncdecDeclarations::fx__enc__NGAP__PDU(ngap);
  if (!bs.is_bound()) {
    loggers::get_instance().error("ngap_codec::encode: Failed to encode NGAP value");
    return -1;
  }

  data = bit2oct(bs);
  return 0;
}

int ngap_codec::decode(const OCTETSTRING &p_data, NGAP__PDU__Descriptions::NGAP__PDU &ngap, params_ngap *params) {
  loggers::get_instance().log_msg(">>> ngap_codec::decode: ", p_data);

  BITSTRING bs = oct2bit(p_data);
  int result = static_cast<int>(LibNGAP__EncdecDeclarations::fx__dec__NGAP__PDU(bs, ngap));
  if (result != 0) {
    loggers::get_instance().error("ngap_codec::decode: Failed to decode NGAP PDU");
    return -1;
  }

  return 0;
}
