%%% Copyright 2025 Nomasystems, S.L. http://www.nomasystems.com
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%%  Unless required by applicable law or agreed to in writing, software
%%  distributed under the License is distributed on an "AS IS" BASIS,
%%  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License
%%% NOTE: Module generated by ndto, do not modify this file.
-module(oas_3_0_Components).

%%% EXTERNAL EXPORTS
-export([is_valid/1]).

%%%-----------------------------------------------------------------------------
%%% EXTERNAL EXPORTS
%%%-----------------------------------------------------------------------------
is_valid(Val) -> '$'(Val).

%%%-----------------------------------------------------------------------------
%%% INTERNAL FUNCTIONS
%%%-----------------------------------------------------------------------------
'$'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.additional_properties'/1,
                                    [Val]},
                                   {fun '$.pattern_properties'/1, [Val]},
                                   {fun '$.properties'/1, [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$'(_Val) ->
    {false, {'$.type', <<"Value is not an object">>}}.

'$.additional_properties'(Val) ->
    case
        sets:to_list(sets:subtract(sets:from_list(maps:keys(Val)),
                                   sets:from_list(lists:append([<<"callbacks">>,
                                                                <<"examples">>,
                                                                <<"headers">>,
                                                                <<"links">>,
                                                                <<"parameters">>,
                                                                <<"requestBodies">>,
                                                                <<"responses">>,
                                                                <<"schemas">>,
                                                                <<"securitySchemes">>],
                                                               lists:filter(fun
                                                                                (PropertyName) ->
                                                                                    lists:any(fun
                                                                                                  (Pattern) ->
                                                                                                      case
                                                                                                          re:run(PropertyName,
                                                                                                                 Pattern)
                                                                                                          of
                                                                                                          {match,
                                                                                                           _Captured} ->
                                                                                                              true;
                                                                                                          _nomatch ->
                                                                                                              false
                                                                                                      end
                                                                                              end,
                                                                                              [<<"^x-">>])
                                                                            end,
                                                                            maps:keys(Val))))))
        of
        [] -> true;
        UnsupportedKeys ->
            {false,
             {'$.additional_properties',
              erlang:list_to_binary(io_lib:format("Object has unsupported keys: ~ts",
                                                  [ndto_validation:format_properties(UnsupportedKeys)]))}}
    end.

'$.pattern_properties'(Val) ->
    case ndto_validation:'andalso'([{fun () ->
                                             case ndto_validation:find(fun
                                                                           ({PropertyName,
                                                                             PropertyValue}) ->
                                                                               Result =
                                                                                   '$.pattern_properties.^x-.any_of'(PropertyValue),
                                                                               case
                                                                                   Result
                                                                                   of
                                                                                   true ->
                                                                                       false;
                                                                                   {false,
                                                                                    {Prefix,
                                                                                     Reason}} ->
                                                                                       {true,
                                                                                        {{PropertyName,
                                                                                          PropertyValue},
                                                                                         {Prefix,
                                                                                          Reason}}}
                                                                               end
                                                                       end,
                                                                       lists:filter(fun
                                                                                        ({PropertyName,
                                                                                          _PropertyValue}) ->
                                                                                            case
                                                                                                re:run(PropertyName,
                                                                                                       <<"^x-">>)
                                                                                                of
                                                                                                {match,
                                                                                                 _Captured} ->
                                                                                                    true;
                                                                                                _nomatch ->
                                                                                                    false
                                                                                            end
                                                                                    end,
                                                                                    maps:to_list(Val)))
                                                 of
                                                 {false, none} -> true;
                                                 {true,
                                                  {{PropertyName,
                                                    _PropertyValue},
                                                   {Prefix, Reason}}} ->
                                                     {false,
                                                      {Prefix,
                                                       erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                                                           "~ts",
                                                                                           [PropertyName,
                                                                                            Reason]))}}
                                             end
                                     end,
                                     []}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.properties'(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.securitySchemes'/1,
                                    [maps:get(<<"securitySchemes">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.schemas'/1,
                                    [maps:get(<<"schemas">>, Val, undefined)]},
                                   {fun '$.properties.responses'/1,
                                    [maps:get(<<"responses">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.requestBodies'/1,
                                    [maps:get(<<"requestBodies">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.parameters'/1,
                                    [maps:get(<<"parameters">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.links'/1,
                                    [maps:get(<<"links">>, Val, undefined)]},
                                   {fun '$.properties.headers'/1,
                                    [maps:get(<<"headers">>, Val, undefined)]},
                                   {fun '$.properties.examples'/1,
                                    [maps:get(<<"examples">>, Val, undefined)]},
                                   {fun '$.properties.callbacks'/1,
                                    [maps:get(<<"callbacks">>,
                                              Val,
                                              undefined)]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.pattern_properties.^x-.any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.pattern_properties.^x-.any_of[4]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[3].any_of'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[2]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[1]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.pattern_properties.^x-.any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.pattern_properties.^x-.any_of[4]'(Val)
    when is_boolean(Val) ->
    true;
'$.pattern_properties.^x-.any_of[4]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[4].type',
      <<"Value is not a boolean">>}}.

'$.pattern_properties.^x-.any_of[3].any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.pattern_properties.^x-.any_of[3].any_of[1]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[3].any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.pattern_properties.^x-.any_of[3].any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.pattern_properties.^x-.any_of[2]'(Val)
    when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[2]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[2].type',
      <<"Value is not a string">>}}.

'$.pattern_properties.^x-.any_of[1]'(Val)
    when is_list(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[1]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[1].type',
      <<"Value is not an array">>}}.

'$.pattern_properties.^x-.any_of[0]'(Val)
    when is_map(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[0]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[0].type',
      <<"Value is not an object">>}}.

'$.pattern_properties.^x-.any_of[3].any_of[1]'(Val)
    when is_float(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[3].any_of[1]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[3].any_of[1].type',
      <<"Value is not a float">>}}.

'$.pattern_properties.^x-.any_of[3].any_of[0]'(Val)
    when is_integer(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[3].any_of[0]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[3].any_of[0].type',
      <<"Value is not an integer">>}}.

'$.properties.securitySchemes'(undefined) -> true;
'$.properties.securitySchemes'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.securitySchemes.pattern_properties'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.securitySchemes'(_Val) ->
    {false,
     {'$.properties.securitySchemes.type',
      <<"Value is not an object">>}}.

'$.properties.schemas'(undefined) -> true;
'$.properties.schemas'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.schemas.pattern_properties'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.schemas'(_Val) ->
    {false,
     {'$.properties.schemas.type',
      <<"Value is not an object">>}}.

'$.properties.responses'(undefined) -> true;
'$.properties.responses'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.responses.pattern_properties'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.responses'(_Val) ->
    {false,
     {'$.properties.responses.type',
      <<"Value is not an object">>}}.

'$.properties.requestBodies'(undefined) -> true;
'$.properties.requestBodies'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.requestBodies.pattern_properties'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.requestBodies'(_Val) ->
    {false,
     {'$.properties.requestBodies.type',
      <<"Value is not an object">>}}.

'$.properties.parameters'(undefined) -> true;
'$.properties.parameters'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.parameters.pattern_properties'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.parameters'(_Val) ->
    {false,
     {'$.properties.parameters.type',
      <<"Value is not an object">>}}.

'$.properties.links'(undefined) -> true;
'$.properties.links'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.links.pattern_properties'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.links'(_Val) ->
    {false,
     {'$.properties.links.type',
      <<"Value is not an object">>}}.

'$.properties.headers'(undefined) -> true;
'$.properties.headers'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.headers.pattern_properties'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.headers'(_Val) ->
    {false,
     {'$.properties.headers.type',
      <<"Value is not an object">>}}.

'$.properties.examples'(undefined) -> true;
'$.properties.examples'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.examples.pattern_properties'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.examples'(_Val) ->
    {false,
     {'$.properties.examples.type',
      <<"Value is not an object">>}}.

'$.properties.callbacks'(undefined) -> true;
'$.properties.callbacks'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.callbacks.pattern_properties'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.callbacks'(_Val) ->
    {false,
     {'$.properties.callbacks.type',
      <<"Value is not an object">>}}.

'$.properties.callbacks.pattern_properties'(Val) ->
    case ndto_validation:'andalso'([{fun () ->
                                             case ndto_validation:find(fun
                                                                           ({PropertyName,
                                                                             PropertyValue}) ->
                                                                               Result =
                                                                                   '$.properties.callbacks.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(PropertyValue),
                                                                               case
                                                                                   Result
                                                                                   of
                                                                                   true ->
                                                                                       false;
                                                                                   {false,
                                                                                    {Prefix,
                                                                                     Reason}} ->
                                                                                       {true,
                                                                                        {{PropertyName,
                                                                                          PropertyValue},
                                                                                         {Prefix,
                                                                                          Reason}}}
                                                                               end
                                                                       end,
                                                                       lists:filter(fun
                                                                                        ({PropertyName,
                                                                                          _PropertyValue}) ->
                                                                                            case
                                                                                                re:run(PropertyName,
                                                                                                       <<"^[a-zA-Z0-9\\.\\-_]+$">>)
                                                                                                of
                                                                                                {match,
                                                                                                 _Captured} ->
                                                                                                    true;
                                                                                                _nomatch ->
                                                                                                    false
                                                                                            end
                                                                                    end,
                                                                                    maps:to_list(Val)))
                                                 of
                                                 {false, none} -> true;
                                                 {true,
                                                  {{PropertyName,
                                                    _PropertyValue},
                                                   {Prefix, Reason}}} ->
                                                     {false,
                                                      {Prefix,
                                                       erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                                                           "~ts",
                                                                                           [PropertyName,
                                                                                            Reason]))}}
                                             end
                                     end,
                                     []}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.properties.callbacks.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.callbacks.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.callbacks.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.callbacks.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.callbacks.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.callbacks.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).

'$.properties.callbacks.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'(Val) ->
    oas_3_0_Callback:is_valid(Val).

'$.properties.examples.pattern_properties'(Val) ->
    case ndto_validation:'andalso'([{fun () ->
                                             case ndto_validation:find(fun
                                                                           ({PropertyName,
                                                                             PropertyValue}) ->
                                                                               Result =
                                                                                   '$.properties.examples.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(PropertyValue),
                                                                               case
                                                                                   Result
                                                                                   of
                                                                                   true ->
                                                                                       false;
                                                                                   {false,
                                                                                    {Prefix,
                                                                                     Reason}} ->
                                                                                       {true,
                                                                                        {{PropertyName,
                                                                                          PropertyValue},
                                                                                         {Prefix,
                                                                                          Reason}}}
                                                                               end
                                                                       end,
                                                                       lists:filter(fun
                                                                                        ({PropertyName,
                                                                                          _PropertyValue}) ->
                                                                                            case
                                                                                                re:run(PropertyName,
                                                                                                       <<"^[a-zA-Z0-9\\.\\-_]+$">>)
                                                                                                of
                                                                                                {match,
                                                                                                 _Captured} ->
                                                                                                    true;
                                                                                                _nomatch ->
                                                                                                    false
                                                                                            end
                                                                                    end,
                                                                                    maps:to_list(Val)))
                                                 of
                                                 {false, none} -> true;
                                                 {true,
                                                  {{PropertyName,
                                                    _PropertyValue},
                                                   {Prefix, Reason}}} ->
                                                     {false,
                                                      {Prefix,
                                                       erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                                                           "~ts",
                                                                                           [PropertyName,
                                                                                            Reason]))}}
                                             end
                                     end,
                                     []}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.properties.examples.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.examples.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.examples.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.examples.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.examples.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.examples.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).

'$.properties.examples.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'(Val) ->
    oas_3_0_Example:is_valid(Val).

'$.properties.headers.pattern_properties'(Val) ->
    case ndto_validation:'andalso'([{fun () ->
                                             case ndto_validation:find(fun
                                                                           ({PropertyName,
                                                                             PropertyValue}) ->
                                                                               Result =
                                                                                   '$.properties.headers.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(PropertyValue),
                                                                               case
                                                                                   Result
                                                                                   of
                                                                                   true ->
                                                                                       false;
                                                                                   {false,
                                                                                    {Prefix,
                                                                                     Reason}} ->
                                                                                       {true,
                                                                                        {{PropertyName,
                                                                                          PropertyValue},
                                                                                         {Prefix,
                                                                                          Reason}}}
                                                                               end
                                                                       end,
                                                                       lists:filter(fun
                                                                                        ({PropertyName,
                                                                                          _PropertyValue}) ->
                                                                                            case
                                                                                                re:run(PropertyName,
                                                                                                       <<"^[a-zA-Z0-9\\.\\-_]+$">>)
                                                                                                of
                                                                                                {match,
                                                                                                 _Captured} ->
                                                                                                    true;
                                                                                                _nomatch ->
                                                                                                    false
                                                                                            end
                                                                                    end,
                                                                                    maps:to_list(Val)))
                                                 of
                                                 {false, none} -> true;
                                                 {true,
                                                  {{PropertyName,
                                                    _PropertyValue},
                                                   {Prefix, Reason}}} ->
                                                     {false,
                                                      {Prefix,
                                                       erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                                                           "~ts",
                                                                                           [PropertyName,
                                                                                            Reason]))}}
                                             end
                                     end,
                                     []}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.properties.headers.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.headers.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.headers.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.headers.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.headers.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.headers.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).

'$.properties.headers.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'(Val) ->
    oas_3_0_Header:is_valid(Val).

'$.properties.links.pattern_properties'(Val) ->
    case ndto_validation:'andalso'([{fun () ->
                                             case ndto_validation:find(fun
                                                                           ({PropertyName,
                                                                             PropertyValue}) ->
                                                                               Result =
                                                                                   '$.properties.links.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(PropertyValue),
                                                                               case
                                                                                   Result
                                                                                   of
                                                                                   true ->
                                                                                       false;
                                                                                   {false,
                                                                                    {Prefix,
                                                                                     Reason}} ->
                                                                                       {true,
                                                                                        {{PropertyName,
                                                                                          PropertyValue},
                                                                                         {Prefix,
                                                                                          Reason}}}
                                                                               end
                                                                       end,
                                                                       lists:filter(fun
                                                                                        ({PropertyName,
                                                                                          _PropertyValue}) ->
                                                                                            case
                                                                                                re:run(PropertyName,
                                                                                                       <<"^[a-zA-Z0-9\\.\\-_]+$">>)
                                                                                                of
                                                                                                {match,
                                                                                                 _Captured} ->
                                                                                                    true;
                                                                                                _nomatch ->
                                                                                                    false
                                                                                            end
                                                                                    end,
                                                                                    maps:to_list(Val)))
                                                 of
                                                 {false, none} -> true;
                                                 {true,
                                                  {{PropertyName,
                                                    _PropertyValue},
                                                   {Prefix, Reason}}} ->
                                                     {false,
                                                      {Prefix,
                                                       erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                                                           "~ts",
                                                                                           [PropertyName,
                                                                                            Reason]))}}
                                             end
                                     end,
                                     []}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.properties.links.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.links.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.links.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.links.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.links.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.links.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).

'$.properties.links.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'(Val) ->
    oas_3_0_Link:is_valid(Val).

'$.properties.parameters.pattern_properties'(Val) ->
    case ndto_validation:'andalso'([{fun () ->
                                             case ndto_validation:find(fun
                                                                           ({PropertyName,
                                                                             PropertyValue}) ->
                                                                               Result =
                                                                                   '$.properties.parameters.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(PropertyValue),
                                                                               case
                                                                                   Result
                                                                                   of
                                                                                   true ->
                                                                                       false;
                                                                                   {false,
                                                                                    {Prefix,
                                                                                     Reason}} ->
                                                                                       {true,
                                                                                        {{PropertyName,
                                                                                          PropertyValue},
                                                                                         {Prefix,
                                                                                          Reason}}}
                                                                               end
                                                                       end,
                                                                       lists:filter(fun
                                                                                        ({PropertyName,
                                                                                          _PropertyValue}) ->
                                                                                            case
                                                                                                re:run(PropertyName,
                                                                                                       <<"^[a-zA-Z0-9\\.\\-_]+$">>)
                                                                                                of
                                                                                                {match,
                                                                                                 _Captured} ->
                                                                                                    true;
                                                                                                _nomatch ->
                                                                                                    false
                                                                                            end
                                                                                    end,
                                                                                    maps:to_list(Val)))
                                                 of
                                                 {false, none} -> true;
                                                 {true,
                                                  {{PropertyName,
                                                    _PropertyValue},
                                                   {Prefix, Reason}}} ->
                                                     {false,
                                                      {Prefix,
                                                       erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                                                           "~ts",
                                                                                           [PropertyName,
                                                                                            Reason]))}}
                                             end
                                     end,
                                     []}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.properties.parameters.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.parameters.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.parameters.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.parameters.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.parameters.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.parameters.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).

'$.properties.parameters.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'(Val) ->
    oas_3_0_Parameter:is_valid(Val).

'$.properties.requestBodies.pattern_properties'(Val) ->
    case ndto_validation:'andalso'([{fun () ->
                                             case ndto_validation:find(fun
                                                                           ({PropertyName,
                                                                             PropertyValue}) ->
                                                                               Result =
                                                                                   '$.properties.requestBodies.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(PropertyValue),
                                                                               case
                                                                                   Result
                                                                                   of
                                                                                   true ->
                                                                                       false;
                                                                                   {false,
                                                                                    {Prefix,
                                                                                     Reason}} ->
                                                                                       {true,
                                                                                        {{PropertyName,
                                                                                          PropertyValue},
                                                                                         {Prefix,
                                                                                          Reason}}}
                                                                               end
                                                                       end,
                                                                       lists:filter(fun
                                                                                        ({PropertyName,
                                                                                          _PropertyValue}) ->
                                                                                            case
                                                                                                re:run(PropertyName,
                                                                                                       <<"^[a-zA-Z0-9\\.\\-_]+$">>)
                                                                                                of
                                                                                                {match,
                                                                                                 _Captured} ->
                                                                                                    true;
                                                                                                _nomatch ->
                                                                                                    false
                                                                                            end
                                                                                    end,
                                                                                    maps:to_list(Val)))
                                                 of
                                                 {false, none} -> true;
                                                 {true,
                                                  {{PropertyName,
                                                    _PropertyValue},
                                                   {Prefix, Reason}}} ->
                                                     {false,
                                                      {Prefix,
                                                       erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                                                           "~ts",
                                                                                           [PropertyName,
                                                                                            Reason]))}}
                                             end
                                     end,
                                     []}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.properties.requestBodies.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.requestBodies.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.requestBodies.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.requestBodies.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.requestBodies.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.requestBodies.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).

'$.properties.requestBodies.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'(Val) ->
    oas_3_0_RequestBody:is_valid(Val).

'$.properties.responses.pattern_properties'(Val) ->
    case ndto_validation:'andalso'([{fun () ->
                                             case ndto_validation:find(fun
                                                                           ({PropertyName,
                                                                             PropertyValue}) ->
                                                                               Result =
                                                                                   '$.properties.responses.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(PropertyValue),
                                                                               case
                                                                                   Result
                                                                                   of
                                                                                   true ->
                                                                                       false;
                                                                                   {false,
                                                                                    {Prefix,
                                                                                     Reason}} ->
                                                                                       {true,
                                                                                        {{PropertyName,
                                                                                          PropertyValue},
                                                                                         {Prefix,
                                                                                          Reason}}}
                                                                               end
                                                                       end,
                                                                       lists:filter(fun
                                                                                        ({PropertyName,
                                                                                          _PropertyValue}) ->
                                                                                            case
                                                                                                re:run(PropertyName,
                                                                                                       <<"^[a-zA-Z0-9\\.\\-_]+$">>)
                                                                                                of
                                                                                                {match,
                                                                                                 _Captured} ->
                                                                                                    true;
                                                                                                _nomatch ->
                                                                                                    false
                                                                                            end
                                                                                    end,
                                                                                    maps:to_list(Val)))
                                                 of
                                                 {false, none} -> true;
                                                 {true,
                                                  {{PropertyName,
                                                    _PropertyValue},
                                                   {Prefix, Reason}}} ->
                                                     {false,
                                                      {Prefix,
                                                       erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                                                           "~ts",
                                                                                           [PropertyName,
                                                                                            Reason]))}}
                                             end
                                     end,
                                     []}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.properties.responses.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.responses.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.responses.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.responses.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.responses.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.responses.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).

'$.properties.responses.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'(Val) ->
    oas_3_0_Response:is_valid(Val).

'$.properties.schemas.pattern_properties'(Val) ->
    case ndto_validation:'andalso'([{fun () ->
                                             case ndto_validation:find(fun
                                                                           ({PropertyName,
                                                                             PropertyValue}) ->
                                                                               Result =
                                                                                   '$.properties.schemas.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(PropertyValue),
                                                                               case
                                                                                   Result
                                                                                   of
                                                                                   true ->
                                                                                       false;
                                                                                   {false,
                                                                                    {Prefix,
                                                                                     Reason}} ->
                                                                                       {true,
                                                                                        {{PropertyName,
                                                                                          PropertyValue},
                                                                                         {Prefix,
                                                                                          Reason}}}
                                                                               end
                                                                       end,
                                                                       lists:filter(fun
                                                                                        ({PropertyName,
                                                                                          _PropertyValue}) ->
                                                                                            case
                                                                                                re:run(PropertyName,
                                                                                                       <<"^[a-zA-Z0-9\\.\\-_]+$">>)
                                                                                                of
                                                                                                {match,
                                                                                                 _Captured} ->
                                                                                                    true;
                                                                                                _nomatch ->
                                                                                                    false
                                                                                            end
                                                                                    end,
                                                                                    maps:to_list(Val)))
                                                 of
                                                 {false, none} -> true;
                                                 {true,
                                                  {{PropertyName,
                                                    _PropertyValue},
                                                   {Prefix, Reason}}} ->
                                                     {false,
                                                      {Prefix,
                                                       erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                                                           "~ts",
                                                                                           [PropertyName,
                                                                                            Reason]))}}
                                             end
                                     end,
                                     []}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.properties.schemas.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.schemas.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.schemas.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.schemas.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.schemas.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.schemas.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'(Val) ->
    oas_3_0_Schema:is_valid(Val).

'$.properties.schemas.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).

'$.properties.securitySchemes.pattern_properties'(Val) ->
    case ndto_validation:'andalso'([{fun () ->
                                             case ndto_validation:find(fun
                                                                           ({PropertyName,
                                                                             PropertyValue}) ->
                                                                               Result =
                                                                                   '$.properties.securitySchemes.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(PropertyValue),
                                                                               case
                                                                                   Result
                                                                                   of
                                                                                   true ->
                                                                                       false;
                                                                                   {false,
                                                                                    {Prefix,
                                                                                     Reason}} ->
                                                                                       {true,
                                                                                        {{PropertyName,
                                                                                          PropertyValue},
                                                                                         {Prefix,
                                                                                          Reason}}}
                                                                               end
                                                                       end,
                                                                       lists:filter(fun
                                                                                        ({PropertyName,
                                                                                          _PropertyValue}) ->
                                                                                            case
                                                                                                re:run(PropertyName,
                                                                                                       <<"^[a-zA-Z0-9\\.\\-_]+$">>)
                                                                                                of
                                                                                                {match,
                                                                                                 _Captured} ->
                                                                                                    true;
                                                                                                _nomatch ->
                                                                                                    false
                                                                                            end
                                                                                    end,
                                                                                    maps:to_list(Val)))
                                                 of
                                                 {false, none} -> true;
                                                 {true,
                                                  {{PropertyName,
                                                    _PropertyValue},
                                                   {Prefix, Reason}}} ->
                                                     {false,
                                                      {Prefix,
                                                       erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                                                           "~ts",
                                                                                           [PropertyName,
                                                                                            Reason]))}}
                                             end
                                     end,
                                     []}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.properties.securitySchemes.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.securitySchemes.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.securitySchemes.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.securitySchemes.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.securitySchemes.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.securitySchemes.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[1].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).

'$.properties.securitySchemes.pattern_properties.^[a-zA-Z0-9\\.\\-_]+$.one_of[0].ref'(Val) ->
    oas_3_0_SecurityScheme:is_valid(Val).