%%% Copyright 2025 Nomasystems, S.L. http://www.nomasystems.com
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%%  Unless required by applicable law or agreed to in writing, software
%%  distributed under the License is distributed on an "AS IS" BASIS,
%%  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License
%%% NOTE: Module generated by ndto, do not modify this file.
-module(oas_3_0_MediaType).

%%% EXTERNAL EXPORTS
-export([is_valid/1]).

%%%-----------------------------------------------------------------------------
%%% EXTERNAL EXPORTS
%%%-----------------------------------------------------------------------------
is_valid(Val) -> '$'(Val).

%%%-----------------------------------------------------------------------------
%%% INTERNAL FUNCTIONS
%%%-----------------------------------------------------------------------------
'$'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.additional_properties'/1,
                                    [Val]},
                                   {fun '$.pattern_properties'/1, [Val]},
                                   {fun '$.properties'/1, [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$'(_Val) ->
    {false, {'$.type', <<"Value is not an object">>}}.

'$.additional_properties'(Val) ->
    case
        sets:to_list(sets:subtract(sets:from_list(maps:keys(Val)),
                                   sets:from_list(lists:append([<<"encoding">>,
                                                                <<"example">>,
                                                                <<"examples">>,
                                                                <<"schema">>],
                                                               lists:filter(fun
                                                                                (PropertyName) ->
                                                                                    lists:any(fun
                                                                                                  (Pattern) ->
                                                                                                      case
                                                                                                          re:run(PropertyName,
                                                                                                                 Pattern)
                                                                                                          of
                                                                                                          {match,
                                                                                                           _Captured} ->
                                                                                                              true;
                                                                                                          _nomatch ->
                                                                                                              false
                                                                                                      end
                                                                                              end,
                                                                                              [<<"^x-">>])
                                                                            end,
                                                                            maps:keys(Val))))))
        of
        [] -> true;
        UnsupportedKeys ->
            {false,
             {'$.additional_properties',
              erlang:list_to_binary(io_lib:format("Object has unsupported keys: ~ts",
                                                  [ndto_validation:format_properties(UnsupportedKeys)]))}}
    end.

'$.pattern_properties'(Val) ->
    case ndto_validation:'andalso'([{fun () ->
                                             case ndto_validation:find(fun
                                                                           ({PropertyName,
                                                                             PropertyValue}) ->
                                                                               Result =
                                                                                   '$.pattern_properties.^x-.any_of'(PropertyValue),
                                                                               case
                                                                                   Result
                                                                                   of
                                                                                   true ->
                                                                                       false;
                                                                                   {false,
                                                                                    {Prefix,
                                                                                     Reason}} ->
                                                                                       {true,
                                                                                        {{PropertyName,
                                                                                          PropertyValue},
                                                                                         {Prefix,
                                                                                          Reason}}}
                                                                               end
                                                                       end,
                                                                       lists:filter(fun
                                                                                        ({PropertyName,
                                                                                          _PropertyValue}) ->
                                                                                            case
                                                                                                re:run(PropertyName,
                                                                                                       <<"^x-">>)
                                                                                                of
                                                                                                {match,
                                                                                                 _Captured} ->
                                                                                                    true;
                                                                                                _nomatch ->
                                                                                                    false
                                                                                            end
                                                                                    end,
                                                                                    maps:to_list(Val)))
                                                 of
                                                 {false, none} -> true;
                                                 {true,
                                                  {{PropertyName,
                                                    _PropertyValue},
                                                   {Prefix, Reason}}} ->
                                                     {false,
                                                      {Prefix,
                                                       erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                                                           "~ts",
                                                                                           [PropertyName,
                                                                                            Reason]))}}
                                             end
                                     end,
                                     []}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.properties'(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.schema.one_of'/1,
                                    [maps:get(<<"schema">>, Val, undefined)]},
                                   {fun '$.properties.examples'/1,
                                    [maps:get(<<"examples">>, Val, undefined)]},
                                   {fun '$.properties.example.any_of'/1,
                                    [maps:get(<<"example">>, Val, undefined)]},
                                   {fun '$.properties.encoding'/1,
                                    [maps:get(<<"encoding">>,
                                              Val,
                                              undefined)]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.pattern_properties.^x-.any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.pattern_properties.^x-.any_of[4]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[3].any_of'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[2]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[1]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.pattern_properties.^x-.any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.pattern_properties.^x-.any_of[4]'(Val)
    when is_boolean(Val) ->
    true;
'$.pattern_properties.^x-.any_of[4]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[4].type',
      <<"Value is not a boolean">>}}.

'$.pattern_properties.^x-.any_of[3].any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.pattern_properties.^x-.any_of[3].any_of[1]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[3].any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.pattern_properties.^x-.any_of[3].any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.pattern_properties.^x-.any_of[2]'(Val)
    when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[2]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[2].type',
      <<"Value is not a string">>}}.

'$.pattern_properties.^x-.any_of[1]'(Val)
    when is_list(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[1]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[1].type',
      <<"Value is not an array">>}}.

'$.pattern_properties.^x-.any_of[0]'(Val)
    when is_map(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[0]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[0].type',
      <<"Value is not an object">>}}.

'$.pattern_properties.^x-.any_of[3].any_of[1]'(Val)
    when is_float(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[3].any_of[1]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[3].any_of[1].type',
      <<"Value is not a float">>}}.

'$.pattern_properties.^x-.any_of[3].any_of[0]'(Val)
    when is_integer(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[3].any_of[0]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[3].any_of[0].type',
      <<"Value is not an integer">>}}.

'$.properties.schema.one_of'(undefined) -> true;
'$.properties.schema.one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.schema.one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.schema.one_of[0].ref'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.schema.one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.schema.one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.examples'(undefined) -> true;
'$.properties.examples'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.examples.additional_properties.*'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.examples'(_Val) ->
    {false,
     {'$.properties.examples.type',
      <<"Value is not an object">>}}.

'$.properties.example.any_of'(undefined) -> true;
'$.properties.example.any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.properties.example.any_of[4]'/1,
                                   [Val]},
                                  {fun '$.properties.example.any_of[3].any_of'/1,
                                   [Val]},
                                  {fun '$.properties.example.any_of[2]'/1,
                                   [Val]},
                                  {fun '$.properties.example.any_of[1]'/1,
                                   [Val]},
                                  {fun '$.properties.example.any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.example.any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.properties.encoding'(undefined) -> true;
'$.properties.encoding'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.encoding.additional_properties.*'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.encoding'(_Val) ->
    {false,
     {'$.properties.encoding.type',
      <<"Value is not an object">>}}.

'$.properties.encoding.additional_properties.*'(Val) ->
    case ndto_validation:find(fun (Property) ->
                                      Result =
                                          '$.properties.encoding.additional_properties.ref'(maps:get(Property,
                                                                                                     Val)),
                                      case Result of
                                          true -> false;
                                          {false, {Prefix, Reason}} ->
                                              {true,
                                               {Property, {Prefix, Reason}}}
                                      end
                              end,
                              lists:subtract(maps:keys(Val),
                                             lists:append([],
                                                          lists:filter(fun
                                                                           (PropertyName) ->
                                                                               lists:any(fun
                                                                                             (Pattern) ->
                                                                                                 case
                                                                                                     re:run(PropertyName,
                                                                                                            Pattern)
                                                                                                     of
                                                                                                     {match,
                                                                                                      _Captured} ->
                                                                                                         true;
                                                                                                     _nomatch ->
                                                                                                         false
                                                                                                 end
                                                                                         end,
                                                                                         [])
                                                                       end,
                                                                       maps:keys(Val)))))
        of
        {false, none} -> true;
        {true, {PropertyName, {Prefix, Reason}}} ->
            {false,
             {Prefix,
              erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                  "~ts",
                                                  [PropertyName, Reason]))}}
    end.

'$.properties.encoding.additional_properties.ref'(Val) ->
    oas_3_0_Encoding:is_valid(Val).

'$.properties.example.any_of[4]'(Val)
    when is_boolean(Val) ->
    true;
'$.properties.example.any_of[4]'(_Val) ->
    {false,
     {'$.properties.example.any_of[4].type',
      <<"Value is not a boolean">>}}.

'$.properties.example.any_of[3].any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.properties.example.any_of[3].any_of[1]'/1,
                                   [Val]},
                                  {fun '$.properties.example.any_of[3].any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.example.any_of[3].any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.properties.example.any_of[2]'(Val)
    when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.example.any_of[2]'(_Val) ->
    {false,
     {'$.properties.example.any_of[2].type',
      <<"Value is not a string">>}}.

'$.properties.example.any_of[1]'(Val)
    when is_list(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.example.any_of[1]'(_Val) ->
    {false,
     {'$.properties.example.any_of[1].type',
      <<"Value is not an array">>}}.

'$.properties.example.any_of[0]'(Val)
    when is_map(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.example.any_of[0]'(_Val) ->
    {false,
     {'$.properties.example.any_of[0].type',
      <<"Value is not an object">>}}.

'$.properties.example.any_of[3].any_of[1]'(Val)
    when is_float(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.example.any_of[3].any_of[1]'(_Val) ->
    {false,
     {'$.properties.example.any_of[3].any_of[1].type',
      <<"Value is not a float">>}}.

'$.properties.example.any_of[3].any_of[0]'(Val)
    when is_integer(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.example.any_of[3].any_of[0]'(_Val) ->
    {false,
     {'$.properties.example.any_of[3].any_of[0].type',
      <<"Value is not an integer">>}}.

'$.properties.examples.additional_properties.*'(Val) ->
    case ndto_validation:find(fun (Property) ->
                                      Result =
                                          '$.properties.examples.additional_properties.one_of'(maps:get(Property,
                                                                                                        Val)),
                                      case Result of
                                          true -> false;
                                          {false, {Prefix, Reason}} ->
                                              {true,
                                               {Property, {Prefix, Reason}}}
                                      end
                              end,
                              lists:subtract(maps:keys(Val),
                                             lists:append([],
                                                          lists:filter(fun
                                                                           (PropertyName) ->
                                                                               lists:any(fun
                                                                                             (Pattern) ->
                                                                                                 case
                                                                                                     re:run(PropertyName,
                                                                                                            Pattern)
                                                                                                     of
                                                                                                     {match,
                                                                                                      _Captured} ->
                                                                                                         true;
                                                                                                     _nomatch ->
                                                                                                         false
                                                                                                 end
                                                                                         end,
                                                                                         [])
                                                                       end,
                                                                       maps:keys(Val)))))
        of
        {false, none} -> true;
        {true, {PropertyName, {Prefix, Reason}}} ->
            {false,
             {Prefix,
              erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                  "~ts",
                                                  [PropertyName, Reason]))}}
    end.

'$.properties.examples.additional_properties.one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.examples.additional_properties.one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.examples.additional_properties.one_of[0].ref'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.examples.additional_properties.one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.examples.additional_properties.one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.examples.additional_properties.one_of[1].ref'(Val) ->
    oas_3_0_Example:is_valid(Val).

'$.properties.examples.additional_properties.one_of[0].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).

'$.properties.schema.one_of[1].ref'(Val) ->
    oas_3_0_Schema:is_valid(Val).

'$.properties.schema.one_of[0].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).