%%% Copyright 2025 Nomasystems, S.L. http://www.nomasystems.com
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%%  Unless required by applicable law or agreed to in writing, software
%%  distributed under the License is distributed on an "AS IS" BASIS,
%%  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License
%%% NOTE: Module generated by ndto, do not modify this file.
-module(oas_3_0_Encoding).

%%% EXTERNAL EXPORTS
-export([is_valid/1]).

%%%-----------------------------------------------------------------------------
%%% EXTERNAL EXPORTS
%%%-----------------------------------------------------------------------------
is_valid(Val) -> '$'(Val).

%%%-----------------------------------------------------------------------------
%%% INTERNAL FUNCTIONS
%%%-----------------------------------------------------------------------------
'$'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.additional_properties'/1,
                                    [Val]},
                                   {fun '$.properties'/1, [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$'(_Val) ->
    {false, {'$.type', <<"Value is not an object">>}}.

'$.additional_properties'(Val) ->
    case
        sets:to_list(sets:subtract(sets:from_list(maps:keys(Val)),
                                   sets:from_list(lists:append([<<"allowReserved">>,
                                                                <<"contentType">>,
                                                                <<"explode">>,
                                                                <<"headers">>,
                                                                <<"style">>],
                                                               lists:filter(fun
                                                                                (PropertyName) ->
                                                                                    lists:any(fun
                                                                                                  (Pattern) ->
                                                                                                      case
                                                                                                          re:run(PropertyName,
                                                                                                                 Pattern)
                                                                                                          of
                                                                                                          {match,
                                                                                                           _Captured} ->
                                                                                                              true;
                                                                                                          _nomatch ->
                                                                                                              false
                                                                                                      end
                                                                                              end,
                                                                                              [])
                                                                            end,
                                                                            maps:keys(Val))))))
        of
        [] -> true;
        UnsupportedKeys ->
            {false,
             {'$.additional_properties',
              erlang:list_to_binary(io_lib:format("Object has unsupported keys: ~ts",
                                                  [ndto_validation:format_properties(UnsupportedKeys)]))}}
    end.

'$.properties'(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.style'/1,
                                    [maps:get(<<"style">>, Val, undefined)]},
                                   {fun '$.properties.headers'/1,
                                    [maps:get(<<"headers">>, Val, undefined)]},
                                   {fun '$.properties.explode'/1,
                                    [maps:get(<<"explode">>, Val, undefined)]},
                                   {fun '$.properties.contentType'/1,
                                    [maps:get(<<"contentType">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.allowReserved'/1,
                                    [maps:get(<<"allowReserved">>,
                                              Val,
                                              undefined)]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.properties.style'(undefined) -> true;
'$.properties.style'(<<"form">>) -> true;
'$.properties.style'(<<"spaceDelimited">>) -> true;
'$.properties.style'(<<"pipeDelimited">>) -> true;
'$.properties.style'(<<"deepObject">>) -> true;
'$.properties.style'(_Val) ->
    {false,
     {'$.properties.style',
      <<"Value is not one in the enum">>}}.

'$.properties.headers'(undefined) -> true;
'$.properties.headers'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.headers.additional_properties.*'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.headers'(_Val) ->
    {false,
     {'$.properties.headers.type',
      <<"Value is not an object">>}}.

'$.properties.explode'(undefined) -> true;
'$.properties.explode'(Val) when is_boolean(Val) ->
    true;
'$.properties.explode'(_Val) ->
    {false,
     {'$.properties.explode.type',
      <<"Value is not a boolean">>}}.

'$.properties.contentType'(undefined) -> true;
'$.properties.contentType'(Val) when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.contentType'(_Val) ->
    {false,
     {'$.properties.contentType.type',
      <<"Value is not a string">>}}.

'$.properties.allowReserved'(undefined) -> true;
'$.properties.allowReserved'(Val)
    when is_boolean(Val) ->
    true;
'$.properties.allowReserved'(_Val) ->
    {false,
     {'$.properties.allowReserved.type',
      <<"Value is not a boolean">>}}.

'$.properties.headers.additional_properties.*'(Val) ->
    case ndto_validation:find(fun (Property) ->
                                      Result =
                                          '$.properties.headers.additional_properties.one_of'(maps:get(Property,
                                                                                                       Val)),
                                      case Result of
                                          true -> false;
                                          {false, {Prefix, Reason}} ->
                                              {true,
                                               {Property, {Prefix, Reason}}}
                                      end
                              end,
                              lists:subtract(maps:keys(Val),
                                             lists:append([],
                                                          lists:filter(fun
                                                                           (PropertyName) ->
                                                                               lists:any(fun
                                                                                             (Pattern) ->
                                                                                                 case
                                                                                                     re:run(PropertyName,
                                                                                                            Pattern)
                                                                                                     of
                                                                                                     {match,
                                                                                                      _Captured} ->
                                                                                                         true;
                                                                                                     _nomatch ->
                                                                                                         false
                                                                                                 end
                                                                                         end,
                                                                                         [])
                                                                       end,
                                                                       maps:keys(Val)))))
        of
        {false, none} -> true;
        {true, {PropertyName, {Prefix, Reason}}} ->
            {false,
             {Prefix,
              erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                  "~ts",
                                                  [PropertyName, Reason]))}}
    end.

'$.properties.headers.additional_properties.one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.headers.additional_properties.one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.headers.additional_properties.one_of[0].ref'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.headers.additional_properties.one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.headers.additional_properties.one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.headers.additional_properties.one_of[1].ref'(Val) ->
    oas_3_0_Header:is_valid(Val).

'$.properties.headers.additional_properties.one_of[0].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).