%%% Copyright 2025 Nomasystems, S.L. http://www.nomasystems.com
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%%  Unless required by applicable law or agreed to in writing, software
%%  distributed under the License is distributed on an "AS IS" BASIS,
%%  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License
%%% NOTE: Module generated by ndto, do not modify this file.
-module(oas_3_0_Schema).

%%% EXTERNAL EXPORTS
-export([is_valid/1]).

%%%-----------------------------------------------------------------------------
%%% EXTERNAL EXPORTS
%%%-----------------------------------------------------------------------------
is_valid(Val) -> '$'(Val).

%%%-----------------------------------------------------------------------------
%%% INTERNAL FUNCTIONS
%%%-----------------------------------------------------------------------------
'$'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.additional_properties'/1,
                                    [Val]},
                                   {fun '$.pattern_properties'/1, [Val]},
                                   {fun '$.properties'/1, [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$'(_Val) ->
    {false, {'$.type', <<"Value is not an object">>}}.

'$.additional_properties'(Val) ->
    case
        sets:to_list(sets:subtract(sets:from_list(maps:keys(Val)),
                                   sets:from_list(lists:append([<<"discriminator">>,
                                                                <<"pattern">>,
                                                                <<"minLength">>,
                                                                <<"nullable">>,
                                                                <<"allOf">>,
                                                                <<"xml">>,
                                                                <<"oneOf">>,
                                                                <<"type">>,
                                                                <<"deprecated">>,
                                                                <<"maxItems">>,
                                                                <<"externalDocs">>,
                                                                <<"items">>,
                                                                <<"properties">>,
                                                                <<"maxProperties">>,
                                                                <<"not">>,
                                                                <<"writeOnly">>,
                                                                <<"exclusiveMinimum">>,
                                                                <<"multipleOf">>,
                                                                <<"format">>,
                                                                <<"description">>,
                                                                <<"minProperties">>,
                                                                <<"readOnly">>,
                                                                <<"maxLength">>,
                                                                <<"enum">>,
                                                                <<"maximum">>,
                                                                <<"uniqueItems">>,
                                                                <<"minItems">>,
                                                                <<"example">>,
                                                                <<"required">>,
                                                                <<"minimum">>,
                                                                <<"exclusiveMaximum">>,
                                                                <<"additionalProperties">>,
                                                                <<"title">>,
                                                                <<"anyOf">>,
                                                                <<"default">>],
                                                               lists:filter(fun
                                                                                (PropertyName) ->
                                                                                    lists:any(fun
                                                                                                  (Pattern) ->
                                                                                                      case
                                                                                                          re:run(PropertyName,
                                                                                                                 Pattern)
                                                                                                          of
                                                                                                          {match,
                                                                                                           _Captured} ->
                                                                                                              true;
                                                                                                          _nomatch ->
                                                                                                              false
                                                                                                      end
                                                                                              end,
                                                                                              [<<"^x-">>])
                                                                            end,
                                                                            maps:keys(Val))))))
        of
        [] -> true;
        UnsupportedKeys ->
            {false,
             {'$.additional_properties',
              erlang:list_to_binary(io_lib:format("Object has unsupported keys: ~ts",
                                                  [ndto_validation:format_properties(UnsupportedKeys)]))}}
    end.

'$.pattern_properties'(Val) ->
    case ndto_validation:'andalso'([{fun () ->
                                             case ndto_validation:find(fun
                                                                           ({PropertyName,
                                                                             PropertyValue}) ->
                                                                               Result =
                                                                                   '$.pattern_properties.^x-.any_of'(PropertyValue),
                                                                               case
                                                                                   Result
                                                                                   of
                                                                                   true ->
                                                                                       false;
                                                                                   {false,
                                                                                    {Prefix,
                                                                                     Reason}} ->
                                                                                       {true,
                                                                                        {{PropertyName,
                                                                                          PropertyValue},
                                                                                         {Prefix,
                                                                                          Reason}}}
                                                                               end
                                                                       end,
                                                                       lists:filter(fun
                                                                                        ({PropertyName,
                                                                                          _PropertyValue}) ->
                                                                                            case
                                                                                                re:run(PropertyName,
                                                                                                       <<"^x-">>)
                                                                                                of
                                                                                                {match,
                                                                                                 _Captured} ->
                                                                                                    true;
                                                                                                _nomatch ->
                                                                                                    false
                                                                                            end
                                                                                    end,
                                                                                    maps:to_list(Val)))
                                                 of
                                                 {false, none} -> true;
                                                 {true,
                                                  {{PropertyName,
                                                    _PropertyValue},
                                                   {Prefix, Reason}}} ->
                                                     {false,
                                                      {Prefix,
                                                       erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                                                           "~ts",
                                                                                           [PropertyName,
                                                                                            Reason]))}}
                                             end
                                     end,
                                     []}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.properties'(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.discriminator.ref'/1,
                                    [maps:get(<<"discriminator">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.pattern'/1,
                                    [maps:get(<<"pattern">>, Val, undefined)]},
                                   {fun '$.properties.minLength'/1,
                                    [maps:get(<<"minLength">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.nullable'/1,
                                    [maps:get(<<"nullable">>, Val, undefined)]},
                                   {fun '$.properties.allOf'/1,
                                    [maps:get(<<"allOf">>, Val, undefined)]},
                                   {fun '$.properties.xml.ref'/1,
                                    [maps:get(<<"xml">>, Val, undefined)]},
                                   {fun '$.properties.oneOf'/1,
                                    [maps:get(<<"oneOf">>, Val, undefined)]},
                                   {fun '$.properties.type'/1,
                                    [maps:get(<<"type">>, Val, undefined)]},
                                   {fun '$.properties.deprecated'/1,
                                    [maps:get(<<"deprecated">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.maxItems'/1,
                                    [maps:get(<<"maxItems">>, Val, undefined)]},
                                   {fun '$.properties.externalDocs.ref'/1,
                                    [maps:get(<<"externalDocs">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.items.one_of'/1,
                                    [maps:get(<<"items">>, Val, undefined)]},
                                   {fun '$.properties.properties'/1,
                                    [maps:get(<<"properties">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.maxProperties'/1,
                                    [maps:get(<<"maxProperties">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.not.one_of'/1,
                                    [maps:get(<<"not">>, Val, undefined)]},
                                   {fun '$.properties.writeOnly'/1,
                                    [maps:get(<<"writeOnly">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.exclusiveMinimum'/1,
                                    [maps:get(<<"exclusiveMinimum">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.multipleOf.any_of'/1,
                                    [maps:get(<<"multipleOf">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.format'/1,
                                    [maps:get(<<"format">>, Val, undefined)]},
                                   {fun '$.properties.description'/1,
                                    [maps:get(<<"description">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.minProperties'/1,
                                    [maps:get(<<"minProperties">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.readOnly'/1,
                                    [maps:get(<<"readOnly">>, Val, undefined)]},
                                   {fun '$.properties.maxLength'/1,
                                    [maps:get(<<"maxLength">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.enum'/1,
                                    [maps:get(<<"enum">>, Val, undefined)]},
                                   {fun '$.properties.maximum.any_of'/1,
                                    [maps:get(<<"maximum">>, Val, undefined)]},
                                   {fun '$.properties.uniqueItems'/1,
                                    [maps:get(<<"uniqueItems">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.minItems'/1,
                                    [maps:get(<<"minItems">>, Val, undefined)]},
                                   {fun '$.properties.example.any_of'/1,
                                    [maps:get(<<"example">>, Val, undefined)]},
                                   {fun '$.properties.required'/1,
                                    [maps:get(<<"required">>, Val, undefined)]},
                                   {fun '$.properties.minimum.any_of'/1,
                                    [maps:get(<<"minimum">>, Val, undefined)]},
                                   {fun '$.properties.exclusiveMaximum'/1,
                                    [maps:get(<<"exclusiveMaximum">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.additionalProperties.one_of'/1,
                                    [maps:get(<<"additionalProperties">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.title'/1,
                                    [maps:get(<<"title">>, Val, undefined)]},
                                   {fun '$.properties.anyOf'/1,
                                    [maps:get(<<"anyOf">>, Val, undefined)]},
                                   {fun '$.properties.default.any_of'/1,
                                    [maps:get(<<"default">>, Val, undefined)]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.pattern_properties.^x-.any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.pattern_properties.^x-.any_of[4]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[3].any_of'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[2]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[1]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.pattern_properties.^x-.any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.pattern_properties.^x-.any_of[4]'(Val)
    when is_boolean(Val) ->
    true;
'$.pattern_properties.^x-.any_of[4]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[4].type',
      <<"Value is not a boolean">>}}.

'$.pattern_properties.^x-.any_of[3].any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.pattern_properties.^x-.any_of[3].any_of[1]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[3].any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.pattern_properties.^x-.any_of[3].any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.pattern_properties.^x-.any_of[2]'(Val)
    when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[2]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[2].type',
      <<"Value is not a string">>}}.

'$.pattern_properties.^x-.any_of[1]'(Val)
    when is_list(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[1]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[1].type',
      <<"Value is not an array">>}}.

'$.pattern_properties.^x-.any_of[0]'(Val)
    when is_map(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[0]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[0].type',
      <<"Value is not an object">>}}.

'$.pattern_properties.^x-.any_of[3].any_of[1]'(Val)
    when is_float(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[3].any_of[1]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[3].any_of[1].type',
      <<"Value is not a float">>}}.

'$.pattern_properties.^x-.any_of[3].any_of[0]'(Val)
    when is_integer(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[3].any_of[0]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[3].any_of[0].type',
      <<"Value is not an integer">>}}.

'$.properties.discriminator.ref'(undefined) -> true;
'$.properties.discriminator.ref'(Val) ->
    oas_3_0_Discriminator:is_valid(Val).

'$.properties.pattern'(undefined) -> true;
'$.properties.pattern'(Val) when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.pattern'(_Val) ->
    {false,
     {'$.properties.pattern.type',
      <<"Value is not a string">>}}.

'$.properties.minLength'(undefined) -> true;
'$.properties.minLength'(Val) when is_integer(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.minLength.minimum'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.minLength'(_Val) ->
    {false,
     {'$.properties.minLength.type',
      <<"Value is not an integer">>}}.

'$.properties.nullable'(undefined) -> true;
'$.properties.nullable'(Val) when is_boolean(Val) ->
    true;
'$.properties.nullable'(_Val) ->
    {false,
     {'$.properties.nullable.type',
      <<"Value is not a boolean">>}}.

'$.properties.allOf'(undefined) -> true;
'$.properties.allOf'(Val) when is_list(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.allOf.items'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.allOf'(_Val) ->
    {false,
     {'$.properties.allOf.type',
      <<"Value is not an array">>}}.

'$.properties.xml.ref'(undefined) -> true;
'$.properties.xml.ref'(Val) ->
    oas_3_0_XML:is_valid(Val).

'$.properties.oneOf'(undefined) -> true;
'$.properties.oneOf'(Val) when is_list(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.oneOf.items'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.oneOf'(_Val) ->
    {false,
     {'$.properties.oneOf.type',
      <<"Value is not an array">>}}.

'$.properties.type'(undefined) -> true;
'$.properties.type'(<<"array">>) -> true;
'$.properties.type'(<<"boolean">>) -> true;
'$.properties.type'(<<"integer">>) -> true;
'$.properties.type'(<<"number">>) -> true;
'$.properties.type'(<<"object">>) -> true;
'$.properties.type'(<<"string">>) -> true;
'$.properties.type'(_Val) ->
    {false,
     {'$.properties.type',
      <<"Value is not one in the enum">>}}.

'$.properties.deprecated'(undefined) -> true;
'$.properties.deprecated'(Val) when is_boolean(Val) ->
    true;
'$.properties.deprecated'(_Val) ->
    {false,
     {'$.properties.deprecated.type',
      <<"Value is not a boolean">>}}.

'$.properties.maxItems'(undefined) -> true;
'$.properties.maxItems'(Val) when is_integer(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.maxItems.minimum'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.maxItems'(_Val) ->
    {false,
     {'$.properties.maxItems.type',
      <<"Value is not an integer">>}}.

'$.properties.externalDocs.ref'(undefined) -> true;
'$.properties.externalDocs.ref'(Val) ->
    oas_3_0_ExternalDocumentation:is_valid(Val).

'$.properties.items.one_of'(undefined) -> true;
'$.properties.items.one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.items.one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.items.one_of[0].ref'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.items.one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.items.one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.properties'(undefined) -> true;
'$.properties.properties'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.properties.additional_properties.*'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.properties'(_Val) ->
    {false,
     {'$.properties.properties.type',
      <<"Value is not an object">>}}.

'$.properties.maxProperties'(undefined) -> true;
'$.properties.maxProperties'(Val)
    when is_integer(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.maxProperties.minimum'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.maxProperties'(_Val) ->
    {false,
     {'$.properties.maxProperties.type',
      <<"Value is not an integer">>}}.

'$.properties.not.one_of'(undefined) -> true;
'$.properties.not.one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.not.one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.not.one_of[0].ref'/1, [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.not.one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.not.one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.writeOnly'(undefined) -> true;
'$.properties.writeOnly'(Val) when is_boolean(Val) ->
    true;
'$.properties.writeOnly'(_Val) ->
    {false,
     {'$.properties.writeOnly.type',
      <<"Value is not a boolean">>}}.

'$.properties.exclusiveMinimum'(undefined) -> true;
'$.properties.exclusiveMinimum'(Val)
    when is_boolean(Val) ->
    true;
'$.properties.exclusiveMinimum'(_Val) ->
    {false,
     {'$.properties.exclusiveMinimum.type',
      <<"Value is not a boolean">>}}.

'$.properties.multipleOf.any_of'(undefined) -> true;
'$.properties.multipleOf.any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.properties.multipleOf.any_of[1]'/1,
                                   [Val]},
                                  {fun '$.properties.multipleOf.any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.multipleOf.any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.properties.format'(undefined) -> true;
'$.properties.format'(Val) when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.format'(_Val) ->
    {false,
     {'$.properties.format.type',
      <<"Value is not a string">>}}.

'$.properties.description'(undefined) -> true;
'$.properties.description'(Val) when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.description'(_Val) ->
    {false,
     {'$.properties.description.type',
      <<"Value is not a string">>}}.

'$.properties.minProperties'(undefined) -> true;
'$.properties.minProperties'(Val)
    when is_integer(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.minProperties.minimum'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.minProperties'(_Val) ->
    {false,
     {'$.properties.minProperties.type',
      <<"Value is not an integer">>}}.

'$.properties.readOnly'(undefined) -> true;
'$.properties.readOnly'(Val) when is_boolean(Val) ->
    true;
'$.properties.readOnly'(_Val) ->
    {false,
     {'$.properties.readOnly.type',
      <<"Value is not a boolean">>}}.

'$.properties.maxLength'(undefined) -> true;
'$.properties.maxLength'(Val) when is_integer(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.maxLength.minimum'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.maxLength'(_Val) ->
    {false,
     {'$.properties.maxLength.type',
      <<"Value is not an integer">>}}.

'$.properties.enum'(undefined) -> true;
'$.properties.enum'(Val) when is_list(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.enum.min_items'/1,
                                    [Val]},
                                   {fun '$.properties.enum.items'/1, [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.enum'(_Val) ->
    {false,
     {'$.properties.enum.type',
      <<"Value is not an array">>}}.

'$.properties.maximum.any_of'(undefined) -> true;
'$.properties.maximum.any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.properties.maximum.any_of[1]'/1,
                                   [Val]},
                                  {fun '$.properties.maximum.any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.maximum.any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.properties.uniqueItems'(undefined) -> true;
'$.properties.uniqueItems'(Val) when is_boolean(Val) ->
    true;
'$.properties.uniqueItems'(_Val) ->
    {false,
     {'$.properties.uniqueItems.type',
      <<"Value is not a boolean">>}}.

'$.properties.minItems'(undefined) -> true;
'$.properties.minItems'(Val) when is_integer(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.minItems.minimum'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.minItems'(_Val) ->
    {false,
     {'$.properties.minItems.type',
      <<"Value is not an integer">>}}.

'$.properties.example.any_of'(undefined) -> true;
'$.properties.example.any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.properties.example.any_of[4]'/1,
                                   [Val]},
                                  {fun '$.properties.example.any_of[3].any_of'/1,
                                   [Val]},
                                  {fun '$.properties.example.any_of[2]'/1,
                                   [Val]},
                                  {fun '$.properties.example.any_of[1]'/1,
                                   [Val]},
                                  {fun '$.properties.example.any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.example.any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.properties.required'(undefined) -> true;
'$.properties.required'(Val) when is_list(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.required.unique_items'/1,
                                    [Val]},
                                   {fun '$.properties.required.min_items'/1,
                                    [Val]},
                                   {fun '$.properties.required.items'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.required'(_Val) ->
    {false,
     {'$.properties.required.type',
      <<"Value is not an array">>}}.

'$.properties.minimum.any_of'(undefined) -> true;
'$.properties.minimum.any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.properties.minimum.any_of[1]'/1,
                                   [Val]},
                                  {fun '$.properties.minimum.any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.minimum.any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.properties.exclusiveMaximum'(undefined) -> true;
'$.properties.exclusiveMaximum'(Val)
    when is_boolean(Val) ->
    true;
'$.properties.exclusiveMaximum'(_Val) ->
    {false,
     {'$.properties.exclusiveMaximum.type',
      <<"Value is not a boolean">>}}.

'$.properties.additionalProperties.one_of'(undefined) ->
    true;
'$.properties.additionalProperties.one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.additionalProperties.one_of[2].ref'/1,
                                [Val]},
                               {fun '$.properties.additionalProperties.one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.additionalProperties.one_of[0]'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.additionalProperties.one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.additionalProperties.one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.title'(undefined) -> true;
'$.properties.title'(Val) when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.title'(_Val) ->
    {false,
     {'$.properties.title.type',
      <<"Value is not a string">>}}.

'$.properties.anyOf'(undefined) -> true;
'$.properties.anyOf'(Val) when is_list(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.anyOf.items'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.anyOf'(_Val) ->
    {false,
     {'$.properties.anyOf.type',
      <<"Value is not an array">>}}.

'$.properties.default.any_of'(undefined) -> true;
'$.properties.default.any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.properties.default.any_of[4]'/1,
                                   [Val]},
                                  {fun '$.properties.default.any_of[3].any_of'/1,
                                   [Val]},
                                  {fun '$.properties.default.any_of[2]'/1,
                                   [Val]},
                                  {fun '$.properties.default.any_of[1]'/1,
                                   [Val]},
                                  {fun '$.properties.default.any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.default.any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.properties.default.any_of[4]'(Val)
    when is_boolean(Val) ->
    true;
'$.properties.default.any_of[4]'(_Val) ->
    {false,
     {'$.properties.default.any_of[4].type',
      <<"Value is not a boolean">>}}.

'$.properties.default.any_of[3].any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.properties.default.any_of[3].any_of[1]'/1,
                                   [Val]},
                                  {fun '$.properties.default.any_of[3].any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.default.any_of[3].any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.properties.default.any_of[2]'(Val)
    when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.default.any_of[2]'(_Val) ->
    {false,
     {'$.properties.default.any_of[2].type',
      <<"Value is not a string">>}}.

'$.properties.default.any_of[1]'(Val)
    when is_list(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.default.any_of[1]'(_Val) ->
    {false,
     {'$.properties.default.any_of[1].type',
      <<"Value is not an array">>}}.

'$.properties.default.any_of[0]'(Val)
    when is_map(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.default.any_of[0]'(_Val) ->
    {false,
     {'$.properties.default.any_of[0].type',
      <<"Value is not an object">>}}.

'$.properties.default.any_of[3].any_of[1]'(Val)
    when is_float(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.default.any_of[3].any_of[1]'(_Val) ->
    {false,
     {'$.properties.default.any_of[3].any_of[1].type',
      <<"Value is not a float">>}}.

'$.properties.default.any_of[3].any_of[0]'(Val)
    when is_integer(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.default.any_of[3].any_of[0]'(_Val) ->
    {false,
     {'$.properties.default.any_of[3].any_of[0].type',
      <<"Value is not an integer">>}}.

'$.properties.anyOf.items'(undefined) -> true;
'$.properties.anyOf.items'(Val) ->
    case ndto_validation:mfoldl(fun (Item, Acc) ->
                                        {'$.properties.anyOf.items[*].one_of'(Item),
                                         Acc + 1}
                                end,
                                0,
                                Val)
        of
        {true, _Acc} -> true;
        {false, Acc, {Function, Reason}} ->
            {false,
             {Function,
              erlang:list_to_binary(io_lib:format("Item ~p in ~ts is invalid. ~s",
                                                  [Acc,
                                                   "$.properties.anyOf",
                                                   Reason]))}}
    end.

'$.properties.anyOf.items[*].one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.anyOf.items[*].one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.anyOf.items[*].one_of[0].ref'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.anyOf.items[*].one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.anyOf.items[*].one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.anyOf.items[*].one_of[1].ref'(Val) ->
    oas_3_0_Schema:is_valid(Val).

'$.properties.anyOf.items[*].one_of[0].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).

'$.properties.additionalProperties.one_of[2].ref'(Val) ->
    oas_3_0_Schema:is_valid(Val).

'$.properties.additionalProperties.one_of[1].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).

'$.properties.additionalProperties.one_of[0]'(Val)
    when is_boolean(Val) ->
    true;
'$.properties.additionalProperties.one_of[0]'(_Val) ->
    {false,
     {'$.properties.additionalProperties.one_of[0].type',
      <<"Value is not a boolean">>}}.

'$.properties.minimum.any_of[1]'(Val)
    when is_float(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.minimum.any_of[1]'(_Val) ->
    {false,
     {'$.properties.minimum.any_of[1].type',
      <<"Value is not a float">>}}.

'$.properties.minimum.any_of[0]'(Val)
    when is_integer(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.minimum.any_of[0]'(_Val) ->
    {false,
     {'$.properties.minimum.any_of[0].type',
      <<"Value is not an integer">>}}.

'$.properties.required.unique_items'(Val) ->
    ArraySize = length(Val),
    case sets:size(sets:from_list(Val)) of
        ArraySize -> true;
        _ ->
            {false,
             {'$.properties.required.unique_items',
              <<"Array has non unique items">>}}
    end.

'$.properties.required.min_items'(Val)
    when length(Val) >= 1 ->
    true;
'$.properties.required.min_items'(_Val) ->
    {false,
     {'$.properties.required.min_items',
      <<"Array does not have at least 1 items">>}}.

'$.properties.required.items'(undefined) -> true;
'$.properties.required.items'(Val) ->
    case ndto_validation:mfoldl(fun (Item, Acc) ->
                                        {'$.properties.required.items[*]'(Item),
                                         Acc + 1}
                                end,
                                0,
                                Val)
        of
        {true, _Acc} -> true;
        {false, Acc, {Function, Reason}} ->
            {false,
             {Function,
              erlang:list_to_binary(io_lib:format("Item ~p in ~ts is invalid. ~s",
                                                  [Acc,
                                                   "$.properties.required",
                                                   Reason]))}}
    end.

'$.properties.required.items[*]'(Val)
    when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.required.items[*]'(_Val) ->
    {false,
     {'$.properties.required.items[*].type',
      <<"Value is not a string">>}}.

'$.properties.example.any_of[4]'(Val)
    when is_boolean(Val) ->
    true;
'$.properties.example.any_of[4]'(_Val) ->
    {false,
     {'$.properties.example.any_of[4].type',
      <<"Value is not a boolean">>}}.

'$.properties.example.any_of[3].any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.properties.example.any_of[3].any_of[1]'/1,
                                   [Val]},
                                  {fun '$.properties.example.any_of[3].any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.example.any_of[3].any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.properties.example.any_of[2]'(Val)
    when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.example.any_of[2]'(_Val) ->
    {false,
     {'$.properties.example.any_of[2].type',
      <<"Value is not a string">>}}.

'$.properties.example.any_of[1]'(Val)
    when is_list(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.example.any_of[1]'(_Val) ->
    {false,
     {'$.properties.example.any_of[1].type',
      <<"Value is not an array">>}}.

'$.properties.example.any_of[0]'(Val)
    when is_map(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.example.any_of[0]'(_Val) ->
    {false,
     {'$.properties.example.any_of[0].type',
      <<"Value is not an object">>}}.

'$.properties.example.any_of[3].any_of[1]'(Val)
    when is_float(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.example.any_of[3].any_of[1]'(_Val) ->
    {false,
     {'$.properties.example.any_of[3].any_of[1].type',
      <<"Value is not a float">>}}.

'$.properties.example.any_of[3].any_of[0]'(Val)
    when is_integer(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.example.any_of[3].any_of[0]'(_Val) ->
    {false,
     {'$.properties.example.any_of[3].any_of[0].type',
      <<"Value is not an integer">>}}.

'$.properties.minItems.minimum'(Val) when Val >= 0 ->
    true;
'$.properties.minItems.minimum'(_Val) ->
    {false,
     {'$.properties.minItems.minimum',
      <<"Value is not a number greater or equal "
        "to 0">>}}.

'$.properties.maximum.any_of[1]'(Val)
    when is_float(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.maximum.any_of[1]'(_Val) ->
    {false,
     {'$.properties.maximum.any_of[1].type',
      <<"Value is not a float">>}}.

'$.properties.maximum.any_of[0]'(Val)
    when is_integer(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.maximum.any_of[0]'(_Val) ->
    {false,
     {'$.properties.maximum.any_of[0].type',
      <<"Value is not an integer">>}}.

'$.properties.enum.min_items'(Val)
    when length(Val) >= 1 ->
    true;
'$.properties.enum.min_items'(_Val) ->
    {false,
     {'$.properties.enum.min_items',
      <<"Array does not have at least 1 items">>}}.

'$.properties.enum.items'(undefined) -> true;
'$.properties.enum.items'(Val) ->
    case ndto_validation:mfoldl(fun (Item, Acc) ->
                                        {'$.properties.enum.items[*].any_of'(Item),
                                         Acc + 1}
                                end,
                                0,
                                Val)
        of
        {true, _Acc} -> true;
        {false, Acc, {Function, Reason}} ->
            {false,
             {Function,
              erlang:list_to_binary(io_lib:format("Item ~p in ~ts is invalid. ~s",
                                                  [Acc,
                                                   "$.properties.enum",
                                                   Reason]))}}
    end.

'$.properties.enum.items[*].any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.properties.enum.items[*].any_of[4]'/1,
                                   [Val]},
                                  {fun '$.properties.enum.items[*].any_of[3].any_of'/1,
                                   [Val]},
                                  {fun '$.properties.enum.items[*].any_of[2]'/1,
                                   [Val]},
                                  {fun '$.properties.enum.items[*].any_of[1]'/1,
                                   [Val]},
                                  {fun '$.properties.enum.items[*].any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.enum.items[*].any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.properties.enum.items[*].any_of[4]'(Val)
    when is_boolean(Val) ->
    true;
'$.properties.enum.items[*].any_of[4]'(_Val) ->
    {false,
     {'$.properties.enum.items[*].any_of[4].type',
      <<"Value is not a boolean">>}}.

'$.properties.enum.items[*].any_of[3].any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.properties.enum.items[*].any_of[3].any_of[1]'/1,
                                   [Val]},
                                  {fun '$.properties.enum.items[*].any_of[3].any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.enum.items[*].any_of[3].any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.properties.enum.items[*].any_of[2]'(Val)
    when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.enum.items[*].any_of[2]'(_Val) ->
    {false,
     {'$.properties.enum.items[*].any_of[2].type',
      <<"Value is not a string">>}}.

'$.properties.enum.items[*].any_of[1]'(Val)
    when is_list(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.enum.items[*].any_of[1]'(_Val) ->
    {false,
     {'$.properties.enum.items[*].any_of[1].type',
      <<"Value is not an array">>}}.

'$.properties.enum.items[*].any_of[0]'(Val)
    when is_map(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.enum.items[*].any_of[0]'(_Val) ->
    {false,
     {'$.properties.enum.items[*].any_of[0].type',
      <<"Value is not an object">>}}.

'$.properties.enum.items[*].any_of[3].any_of[1]'(Val)
    when is_float(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.enum.items[*].any_of[3].any_of[1]'(_Val) ->
    {false,
     {'$.properties.enum.items[*].any_of[3].any_of[1].type',
      <<"Value is not a float">>}}.

'$.properties.enum.items[*].any_of[3].any_of[0]'(Val)
    when is_integer(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.enum.items[*].any_of[3].any_of[0]'(_Val) ->
    {false,
     {'$.properties.enum.items[*].any_of[3].any_of[0].type',
      <<"Value is not an integer">>}}.

'$.properties.maxLength.minimum'(Val) when Val >= 0 ->
    true;
'$.properties.maxLength.minimum'(_Val) ->
    {false,
     {'$.properties.maxLength.minimum',
      <<"Value is not a number greater or equal "
        "to 0">>}}.

'$.properties.minProperties.minimum'(Val)
    when Val >= 0 ->
    true;
'$.properties.minProperties.minimum'(_Val) ->
    {false,
     {'$.properties.minProperties.minimum',
      <<"Value is not a number greater or equal "
        "to 0">>}}.

'$.properties.multipleOf.any_of[1]'(Val)
    when is_float(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.multipleOf.any_of[1].minimum'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.multipleOf.any_of[1]'(_Val) ->
    {false,
     {'$.properties.multipleOf.any_of[1].type',
      <<"Value is not a float">>}}.

'$.properties.multipleOf.any_of[0]'(Val)
    when is_integer(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.multipleOf.any_of[0].minimum'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.multipleOf.any_of[0]'(_Val) ->
    {false,
     {'$.properties.multipleOf.any_of[0].type',
      <<"Value is not an integer">>}}.

'$.properties.multipleOf.any_of[1].minimum'(Val)
    when Val > 0 ->
    true;
'$.properties.multipleOf.any_of[1].minimum'(_Val) ->
    {false,
     {'$.properties.multipleOf.any_of[1].minimum',
      <<"Value is not a number greater than 0">>}}.

'$.properties.multipleOf.any_of[0].minimum'(Val)
    when Val > 0 ->
    true;
'$.properties.multipleOf.any_of[0].minimum'(_Val) ->
    {false,
     {'$.properties.multipleOf.any_of[0].minimum',
      <<"Value is not a number greater than 0">>}}.

'$.properties.not.one_of[1].ref'(Val) ->
    oas_3_0_Schema:is_valid(Val).

'$.properties.not.one_of[0].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).

'$.properties.maxProperties.minimum'(Val)
    when Val >= 0 ->
    true;
'$.properties.maxProperties.minimum'(_Val) ->
    {false,
     {'$.properties.maxProperties.minimum',
      <<"Value is not a number greater or equal "
        "to 0">>}}.

'$.properties.properties.additional_properties.*'(Val) ->
    case ndto_validation:find(fun (Property) ->
                                      Result =
                                          '$.properties.properties.additional_properties.one_of'(maps:get(Property,
                                                                                                          Val)),
                                      case Result of
                                          true -> false;
                                          {false, {Prefix, Reason}} ->
                                              {true,
                                               {Property, {Prefix, Reason}}}
                                      end
                              end,
                              lists:subtract(maps:keys(Val),
                                             lists:append([],
                                                          lists:filter(fun
                                                                           (PropertyName) ->
                                                                               lists:any(fun
                                                                                             (Pattern) ->
                                                                                                 case
                                                                                                     re:run(PropertyName,
                                                                                                            Pattern)
                                                                                                     of
                                                                                                     {match,
                                                                                                      _Captured} ->
                                                                                                         true;
                                                                                                     _nomatch ->
                                                                                                         false
                                                                                                 end
                                                                                         end,
                                                                                         [])
                                                                       end,
                                                                       maps:keys(Val)))))
        of
        {false, none} -> true;
        {true, {PropertyName, {Prefix, Reason}}} ->
            {false,
             {Prefix,
              erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                  "~ts",
                                                  [PropertyName, Reason]))}}
    end.

'$.properties.properties.additional_properties.one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.properties.additional_properties.one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.properties.additional_properties.one_of[0].ref'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.properties.additional_properties.one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.properties.additional_properties.one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.properties.additional_properties.one_of[1].ref'(Val) ->
    oas_3_0_Schema:is_valid(Val).

'$.properties.properties.additional_properties.one_of[0].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).

'$.properties.items.one_of[1].ref'(Val) ->
    oas_3_0_Schema:is_valid(Val).

'$.properties.items.one_of[0].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).

'$.properties.maxItems.minimum'(Val) when Val >= 0 ->
    true;
'$.properties.maxItems.minimum'(_Val) ->
    {false,
     {'$.properties.maxItems.minimum',
      <<"Value is not a number greater or equal "
        "to 0">>}}.

'$.properties.oneOf.items'(undefined) -> true;
'$.properties.oneOf.items'(Val) ->
    case ndto_validation:mfoldl(fun (Item, Acc) ->
                                        {'$.properties.oneOf.items[*].one_of'(Item),
                                         Acc + 1}
                                end,
                                0,
                                Val)
        of
        {true, _Acc} -> true;
        {false, Acc, {Function, Reason}} ->
            {false,
             {Function,
              erlang:list_to_binary(io_lib:format("Item ~p in ~ts is invalid. ~s",
                                                  [Acc,
                                                   "$.properties.oneOf",
                                                   Reason]))}}
    end.

'$.properties.oneOf.items[*].one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.oneOf.items[*].one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.oneOf.items[*].one_of[0].ref'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.oneOf.items[*].one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.oneOf.items[*].one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.oneOf.items[*].one_of[1].ref'(Val) ->
    oas_3_0_Schema:is_valid(Val).

'$.properties.oneOf.items[*].one_of[0].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).

'$.properties.allOf.items'(undefined) -> true;
'$.properties.allOf.items'(Val) ->
    case ndto_validation:mfoldl(fun (Item, Acc) ->
                                        {'$.properties.allOf.items[*].one_of'(Item),
                                         Acc + 1}
                                end,
                                0,
                                Val)
        of
        {true, _Acc} -> true;
        {false, Acc, {Function, Reason}} ->
            {false,
             {Function,
              erlang:list_to_binary(io_lib:format("Item ~p in ~ts is invalid. ~s",
                                                  [Acc,
                                                   "$.properties.allOf",
                                                   Reason]))}}
    end.

'$.properties.allOf.items[*].one_of'(Val) ->
    case
        ndto_validation:'xor'([{fun '$.properties.allOf.items[*].one_of[1].ref'/1,
                                [Val]},
                               {fun '$.properties.allOf.items[*].one_of[0].ref'/1,
                                [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.allOf.items[*].one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.properties.allOf.items[*].one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.properties.allOf.items[*].one_of[1].ref'(Val) ->
    oas_3_0_Schema:is_valid(Val).

'$.properties.allOf.items[*].one_of[0].ref'(Val) ->
    oas_3_0_Reference:is_valid(Val).

'$.properties.minLength.minimum'(Val) when Val >= 0 ->
    true;
'$.properties.minLength.minimum'(_Val) ->
    {false,
     {'$.properties.minLength.minimum',
      <<"Value is not a number greater or equal "
        "to 0">>}}.