%% Generated by the Erlang ASN.1 PER (aligned) compiler. Version: 5.3.4.1
%% Purpose: Encoding and decoding of the types in S1AP-PDU-Contents.

-module('S1AP-PDU-Contents').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("S1AP-PDU-Contents.hrl").
-asn1_info([{vsn,'5.3.4.1'},
            {module,'S1AP-PDU-Contents'},
            {options,[{i,"/obs/_temp/binpkgs/osmo-s1gw/asngen"},
 noobj,per,
 {outdir,"/obs/_temp/binpkgs/osmo-s1gw/asngen"},
 {i,"."},
 {i,"/obs/_temp/binpkgs/osmo-s1gw/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_HandoverRequired/1,
enc_HandoverCommand/1,
'enc_E-RABSubjecttoDataForwardingList'/1,
'enc_E-RABDataForwardingItem'/1,
enc_HandoverPreparationFailure/1,
enc_HandoverRequest/1,
'enc_E-RABToBeSetupListHOReq'/1,
'enc_E-RABToBeSetupItemHOReq'/1,
enc_HandoverRequestAcknowledge/1,
'enc_E-RABAdmittedList'/1,
'enc_E-RABAdmittedItem'/1,
'enc_E-RABFailedtoSetupListHOReqAck'/1,
'enc_E-RABFailedToSetupItemHOReqAck'/1,
enc_HandoverFailure/1,
enc_HandoverNotify/1,
enc_PathSwitchRequest/1,
'enc_E-RABToBeSwitchedDLList'/1,
'enc_E-RABToBeSwitchedDLItem'/1,
enc_PathSwitchRequestAcknowledge/1,
'enc_E-RABToBeSwitchedULList'/1,
'enc_E-RABToBeSwitchedULItem'/1,
'enc_E-RABToBeUpdatedList'/1,
'enc_E-RABToBeUpdatedItem'/1,
enc_PathSwitchRequestFailure/1,
enc_HandoverCancel/1,
enc_HandoverCancelAcknowledge/1,
enc_HandoverSuccess/1,
enc_ENBEarlyStatusTransfer/1,
enc_MMEEarlyStatusTransfer/1,
'enc_E-RABSetupRequest'/1,
'enc_E-RABToBeSetupListBearerSUReq'/1,
'enc_E-RABToBeSetupItemBearerSUReq'/1,
'enc_E-RABSetupResponse'/1,
'enc_E-RABSetupListBearerSURes'/1,
'enc_E-RABSetupItemBearerSURes'/1,
'enc_E-RABModifyRequest'/1,
'enc_E-RABToBeModifiedListBearerModReq'/1,
'enc_E-RABToBeModifiedItemBearerModReq'/1,
'enc_E-RABModifyResponse'/1,
'enc_E-RABModifyListBearerModRes'/1,
'enc_E-RABModifyItemBearerModRes'/1,
'enc_E-RABReleaseCommand'/1,
'enc_E-RABReleaseResponse'/1,
'enc_E-RABReleaseListBearerRelComp'/1,
'enc_E-RABReleaseItemBearerRelComp'/1,
'enc_E-RABReleaseIndication'/1,
enc_InitialContextSetupRequest/1,
'enc_E-RABToBeSetupListCtxtSUReq'/1,
'enc_E-RABToBeSetupItemCtxtSUReq'/1,
enc_InitialContextSetupResponse/1,
'enc_E-RABSetupListCtxtSURes'/1,
'enc_E-RABSetupItemCtxtSURes'/1,
enc_InitialContextSetupFailure/1,
enc_Paging/1,
enc_TAIList/1,
enc_TAIItem/1,
enc_UEContextReleaseRequest/1,
enc_UEContextReleaseCommand/1,
enc_UEContextReleaseComplete/1,
enc_UEContextModificationRequest/1,
enc_UEContextModificationResponse/1,
enc_UEContextModificationFailure/1,
enc_UERadioCapabilityMatchRequest/1,
enc_UERadioCapabilityMatchResponse/1,
enc_DownlinkNASTransport/1,
enc_InitialUEMessage/1,
enc_UplinkNASTransport/1,
enc_NASNonDeliveryIndication/1,
enc_RerouteNASRequest/1,
'enc_S1-Message'/1,
enc_NASDeliveryIndication/1,
enc_Reset/1,
enc_ResetType/1,
enc_ResetAll/1,
'enc_UE-associatedLogicalS1-ConnectionListRes'/1,
enc_ResetAcknowledge/1,
'enc_UE-associatedLogicalS1-ConnectionListResAck'/1,
enc_ErrorIndication/1,
enc_S1SetupRequest/1,
enc_S1SetupResponse/1,
enc_S1SetupFailure/1,
enc_ENBConfigurationUpdate/1,
enc_ENBConfigurationUpdateAcknowledge/1,
enc_ENBConfigurationUpdateFailure/1,
enc_MMEConfigurationUpdate/1,
enc_MMEConfigurationUpdateAcknowledge/1,
enc_MMEConfigurationUpdateFailure/1,
enc_DownlinkS1cdma2000tunnelling/1,
enc_UplinkS1cdma2000tunnelling/1,
enc_UECapabilityInfoIndication/1,
enc_ENBStatusTransfer/1,
enc_MMEStatusTransfer/1,
enc_TraceStart/1,
enc_TraceFailureIndication/1,
enc_DeactivateTrace/1,
enc_CellTrafficTrace/1,
enc_LocationReportingControl/1,
enc_LocationReportingFailureIndication/1,
enc_LocationReport/1,
enc_OverloadStart/1,
enc_OverloadStop/1,
enc_WriteReplaceWarningRequest/1,
enc_WriteReplaceWarningResponse/1,
enc_ENBDirectInformationTransfer/1,
'enc_Inter-SystemInformationTransferType'/1,
enc_MMEDirectInformationTransfer/1,
enc_ENBConfigurationTransfer/1,
enc_MMEConfigurationTransfer/1,
enc_PrivateMessage/1,
enc_KillRequest/1,
enc_KillResponse/1,
enc_PWSRestartIndication/1,
enc_PWSFailureIndication/1,
enc_DownlinkUEAssociatedLPPaTransport/1,
enc_UplinkUEAssociatedLPPaTransport/1,
enc_DownlinkNonUEAssociatedLPPaTransport/1,
enc_UplinkNonUEAssociatedLPPaTransport/1,
'enc_E-RABModificationIndication'/1,
'enc_E-RABToBeModifiedListBearerModInd'/1,
'enc_E-RABToBeModifiedItemBearerModInd'/1,
'enc_E-RABNotToBeModifiedListBearerModInd'/1,
'enc_E-RABNotToBeModifiedItemBearerModInd'/1,
enc_CSGMembershipInfo/1,
'enc_E-RABModificationConfirm'/1,
'enc_E-RABModifyListBearerModConf'/1,
'enc_E-RABModifyItemBearerModConf'/1,
enc_UEContextModificationIndication/1,
enc_UEContextModificationConfirm/1,
enc_UEContextSuspendRequest/1,
enc_UEContextSuspendResponse/1,
enc_UEContextResumeRequest/1,
'enc_E-RABFailedToResumeListResumeReq'/1,
'enc_E-RABFailedToResumeItemResumeReq'/1,
enc_UEContextResumeResponse/1,
'enc_E-RABFailedToResumeListResumeRes'/1,
'enc_E-RABFailedToResumeItemResumeRes'/1,
enc_UEContextResumeFailure/1,
enc_ConnectionEstablishmentIndication/1,
enc_RetrieveUEInformation/1,
enc_UEInformationTransfer/1,
enc_ENBCPRelocationIndication/1,
enc_MMECPRelocationIndication/1,
enc_SecondaryRATDataUsageReport/1,
enc_UERadioCapabilityIDMappingRequest/1,
enc_UERadioCapabilityIDMappingResponse/1
]).

-export([
dec_HandoverRequired/1,
dec_HandoverCommand/1,
'dec_E-RABSubjecttoDataForwardingList'/1,
'dec_E-RABDataForwardingItem'/1,
dec_HandoverPreparationFailure/1,
dec_HandoverRequest/1,
'dec_E-RABToBeSetupListHOReq'/1,
'dec_E-RABToBeSetupItemHOReq'/1,
dec_HandoverRequestAcknowledge/1,
'dec_E-RABAdmittedList'/1,
'dec_E-RABAdmittedItem'/1,
'dec_E-RABFailedtoSetupListHOReqAck'/1,
'dec_E-RABFailedToSetupItemHOReqAck'/1,
dec_HandoverFailure/1,
dec_HandoverNotify/1,
dec_PathSwitchRequest/1,
'dec_E-RABToBeSwitchedDLList'/1,
'dec_E-RABToBeSwitchedDLItem'/1,
dec_PathSwitchRequestAcknowledge/1,
'dec_E-RABToBeSwitchedULList'/1,
'dec_E-RABToBeSwitchedULItem'/1,
'dec_E-RABToBeUpdatedList'/1,
'dec_E-RABToBeUpdatedItem'/1,
dec_PathSwitchRequestFailure/1,
dec_HandoverCancel/1,
dec_HandoverCancelAcknowledge/1,
dec_HandoverSuccess/1,
dec_ENBEarlyStatusTransfer/1,
dec_MMEEarlyStatusTransfer/1,
'dec_E-RABSetupRequest'/1,
'dec_E-RABToBeSetupListBearerSUReq'/1,
'dec_E-RABToBeSetupItemBearerSUReq'/1,
'dec_E-RABSetupResponse'/1,
'dec_E-RABSetupListBearerSURes'/1,
'dec_E-RABSetupItemBearerSURes'/1,
'dec_E-RABModifyRequest'/1,
'dec_E-RABToBeModifiedListBearerModReq'/1,
'dec_E-RABToBeModifiedItemBearerModReq'/1,
'dec_E-RABModifyResponse'/1,
'dec_E-RABModifyListBearerModRes'/1,
'dec_E-RABModifyItemBearerModRes'/1,
'dec_E-RABReleaseCommand'/1,
'dec_E-RABReleaseResponse'/1,
'dec_E-RABReleaseListBearerRelComp'/1,
'dec_E-RABReleaseItemBearerRelComp'/1,
'dec_E-RABReleaseIndication'/1,
dec_InitialContextSetupRequest/1,
'dec_E-RABToBeSetupListCtxtSUReq'/1,
'dec_E-RABToBeSetupItemCtxtSUReq'/1,
dec_InitialContextSetupResponse/1,
'dec_E-RABSetupListCtxtSURes'/1,
'dec_E-RABSetupItemCtxtSURes'/1,
dec_InitialContextSetupFailure/1,
dec_Paging/1,
dec_TAIList/1,
dec_TAIItem/1,
dec_UEContextReleaseRequest/1,
dec_UEContextReleaseCommand/1,
dec_UEContextReleaseComplete/1,
dec_UEContextModificationRequest/1,
dec_UEContextModificationResponse/1,
dec_UEContextModificationFailure/1,
dec_UERadioCapabilityMatchRequest/1,
dec_UERadioCapabilityMatchResponse/1,
dec_DownlinkNASTransport/1,
dec_InitialUEMessage/1,
dec_UplinkNASTransport/1,
dec_NASNonDeliveryIndication/1,
dec_RerouteNASRequest/1,
'dec_S1-Message'/1,
dec_NASDeliveryIndication/1,
dec_Reset/1,
dec_ResetType/1,
dec_ResetAll/1,
'dec_UE-associatedLogicalS1-ConnectionListRes'/1,
dec_ResetAcknowledge/1,
'dec_UE-associatedLogicalS1-ConnectionListResAck'/1,
dec_ErrorIndication/1,
dec_S1SetupRequest/1,
dec_S1SetupResponse/1,
dec_S1SetupFailure/1,
dec_ENBConfigurationUpdate/1,
dec_ENBConfigurationUpdateAcknowledge/1,
dec_ENBConfigurationUpdateFailure/1,
dec_MMEConfigurationUpdate/1,
dec_MMEConfigurationUpdateAcknowledge/1,
dec_MMEConfigurationUpdateFailure/1,
dec_DownlinkS1cdma2000tunnelling/1,
dec_UplinkS1cdma2000tunnelling/1,
dec_UECapabilityInfoIndication/1,
dec_ENBStatusTransfer/1,
dec_MMEStatusTransfer/1,
dec_TraceStart/1,
dec_TraceFailureIndication/1,
dec_DeactivateTrace/1,
dec_CellTrafficTrace/1,
dec_LocationReportingControl/1,
dec_LocationReportingFailureIndication/1,
dec_LocationReport/1,
dec_OverloadStart/1,
dec_OverloadStop/1,
dec_WriteReplaceWarningRequest/1,
dec_WriteReplaceWarningResponse/1,
dec_ENBDirectInformationTransfer/1,
'dec_Inter-SystemInformationTransferType'/1,
dec_MMEDirectInformationTransfer/1,
dec_ENBConfigurationTransfer/1,
dec_MMEConfigurationTransfer/1,
dec_PrivateMessage/1,
dec_KillRequest/1,
dec_KillResponse/1,
dec_PWSRestartIndication/1,
dec_PWSFailureIndication/1,
dec_DownlinkUEAssociatedLPPaTransport/1,
dec_UplinkUEAssociatedLPPaTransport/1,
dec_DownlinkNonUEAssociatedLPPaTransport/1,
dec_UplinkNonUEAssociatedLPPaTransport/1,
'dec_E-RABModificationIndication'/1,
'dec_E-RABToBeModifiedListBearerModInd'/1,
'dec_E-RABToBeModifiedItemBearerModInd'/1,
'dec_E-RABNotToBeModifiedListBearerModInd'/1,
'dec_E-RABNotToBeModifiedItemBearerModInd'/1,
dec_CSGMembershipInfo/1,
'dec_E-RABModificationConfirm'/1,
'dec_E-RABModifyListBearerModConf'/1,
'dec_E-RABModifyItemBearerModConf'/1,
dec_UEContextModificationIndication/1,
dec_UEContextModificationConfirm/1,
dec_UEContextSuspendRequest/1,
dec_UEContextSuspendResponse/1,
dec_UEContextResumeRequest/1,
'dec_E-RABFailedToResumeListResumeReq'/1,
'dec_E-RABFailedToResumeItemResumeReq'/1,
dec_UEContextResumeResponse/1,
'dec_E-RABFailedToResumeListResumeRes'/1,
'dec_E-RABFailedToResumeItemResumeRes'/1,
dec_UEContextResumeFailure/1,
dec_ConnectionEstablishmentIndication/1,
dec_RetrieveUEInformation/1,
dec_UEInformationTransfer/1,
dec_ENBCPRelocationIndication/1,
dec_MMECPRelocationIndication/1,
dec_SecondaryRATDataUsageReport/1,
dec_UERadioCapabilityIDMappingRequest/1,
dec_UERadioCapabilityIDMappingResponse/1
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> per.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try complete(encode_disp(Type, Data)) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   {Result,_Rest} = decode_disp(Type, Data),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('HandoverRequired', Data) -> enc_HandoverRequired(Data);
encode_disp('HandoverCommand', Data) -> enc_HandoverCommand(Data);
encode_disp('E-RABSubjecttoDataForwardingList', Data) -> 'enc_E-RABSubjecttoDataForwardingList'(Data);
encode_disp('E-RABDataForwardingItem', Data) -> 'enc_E-RABDataForwardingItem'(Data);
encode_disp('HandoverPreparationFailure', Data) -> enc_HandoverPreparationFailure(Data);
encode_disp('HandoverRequest', Data) -> enc_HandoverRequest(Data);
encode_disp('E-RABToBeSetupListHOReq', Data) -> 'enc_E-RABToBeSetupListHOReq'(Data);
encode_disp('E-RABToBeSetupItemHOReq', Data) -> 'enc_E-RABToBeSetupItemHOReq'(Data);
encode_disp('HandoverRequestAcknowledge', Data) -> enc_HandoverRequestAcknowledge(Data);
encode_disp('E-RABAdmittedList', Data) -> 'enc_E-RABAdmittedList'(Data);
encode_disp('E-RABAdmittedItem', Data) -> 'enc_E-RABAdmittedItem'(Data);
encode_disp('E-RABFailedtoSetupListHOReqAck', Data) -> 'enc_E-RABFailedtoSetupListHOReqAck'(Data);
encode_disp('E-RABFailedToSetupItemHOReqAck', Data) -> 'enc_E-RABFailedToSetupItemHOReqAck'(Data);
encode_disp('HandoverFailure', Data) -> enc_HandoverFailure(Data);
encode_disp('HandoverNotify', Data) -> enc_HandoverNotify(Data);
encode_disp('PathSwitchRequest', Data) -> enc_PathSwitchRequest(Data);
encode_disp('E-RABToBeSwitchedDLList', Data) -> 'enc_E-RABToBeSwitchedDLList'(Data);
encode_disp('E-RABToBeSwitchedDLItem', Data) -> 'enc_E-RABToBeSwitchedDLItem'(Data);
encode_disp('PathSwitchRequestAcknowledge', Data) -> enc_PathSwitchRequestAcknowledge(Data);
encode_disp('E-RABToBeSwitchedULList', Data) -> 'enc_E-RABToBeSwitchedULList'(Data);
encode_disp('E-RABToBeSwitchedULItem', Data) -> 'enc_E-RABToBeSwitchedULItem'(Data);
encode_disp('E-RABToBeUpdatedList', Data) -> 'enc_E-RABToBeUpdatedList'(Data);
encode_disp('E-RABToBeUpdatedItem', Data) -> 'enc_E-RABToBeUpdatedItem'(Data);
encode_disp('PathSwitchRequestFailure', Data) -> enc_PathSwitchRequestFailure(Data);
encode_disp('HandoverCancel', Data) -> enc_HandoverCancel(Data);
encode_disp('HandoverCancelAcknowledge', Data) -> enc_HandoverCancelAcknowledge(Data);
encode_disp('HandoverSuccess', Data) -> enc_HandoverSuccess(Data);
encode_disp('ENBEarlyStatusTransfer', Data) -> enc_ENBEarlyStatusTransfer(Data);
encode_disp('MMEEarlyStatusTransfer', Data) -> enc_MMEEarlyStatusTransfer(Data);
encode_disp('E-RABSetupRequest', Data) -> 'enc_E-RABSetupRequest'(Data);
encode_disp('E-RABToBeSetupListBearerSUReq', Data) -> 'enc_E-RABToBeSetupListBearerSUReq'(Data);
encode_disp('E-RABToBeSetupItemBearerSUReq', Data) -> 'enc_E-RABToBeSetupItemBearerSUReq'(Data);
encode_disp('E-RABSetupResponse', Data) -> 'enc_E-RABSetupResponse'(Data);
encode_disp('E-RABSetupListBearerSURes', Data) -> 'enc_E-RABSetupListBearerSURes'(Data);
encode_disp('E-RABSetupItemBearerSURes', Data) -> 'enc_E-RABSetupItemBearerSURes'(Data);
encode_disp('E-RABModifyRequest', Data) -> 'enc_E-RABModifyRequest'(Data);
encode_disp('E-RABToBeModifiedListBearerModReq', Data) -> 'enc_E-RABToBeModifiedListBearerModReq'(Data);
encode_disp('E-RABToBeModifiedItemBearerModReq', Data) -> 'enc_E-RABToBeModifiedItemBearerModReq'(Data);
encode_disp('E-RABModifyResponse', Data) -> 'enc_E-RABModifyResponse'(Data);
encode_disp('E-RABModifyListBearerModRes', Data) -> 'enc_E-RABModifyListBearerModRes'(Data);
encode_disp('E-RABModifyItemBearerModRes', Data) -> 'enc_E-RABModifyItemBearerModRes'(Data);
encode_disp('E-RABReleaseCommand', Data) -> 'enc_E-RABReleaseCommand'(Data);
encode_disp('E-RABReleaseResponse', Data) -> 'enc_E-RABReleaseResponse'(Data);
encode_disp('E-RABReleaseListBearerRelComp', Data) -> 'enc_E-RABReleaseListBearerRelComp'(Data);
encode_disp('E-RABReleaseItemBearerRelComp', Data) -> 'enc_E-RABReleaseItemBearerRelComp'(Data);
encode_disp('E-RABReleaseIndication', Data) -> 'enc_E-RABReleaseIndication'(Data);
encode_disp('InitialContextSetupRequest', Data) -> enc_InitialContextSetupRequest(Data);
encode_disp('E-RABToBeSetupListCtxtSUReq', Data) -> 'enc_E-RABToBeSetupListCtxtSUReq'(Data);
encode_disp('E-RABToBeSetupItemCtxtSUReq', Data) -> 'enc_E-RABToBeSetupItemCtxtSUReq'(Data);
encode_disp('InitialContextSetupResponse', Data) -> enc_InitialContextSetupResponse(Data);
encode_disp('E-RABSetupListCtxtSURes', Data) -> 'enc_E-RABSetupListCtxtSURes'(Data);
encode_disp('E-RABSetupItemCtxtSURes', Data) -> 'enc_E-RABSetupItemCtxtSURes'(Data);
encode_disp('InitialContextSetupFailure', Data) -> enc_InitialContextSetupFailure(Data);
encode_disp('Paging', Data) -> enc_Paging(Data);
encode_disp('TAIList', Data) -> enc_TAIList(Data);
encode_disp('TAIItem', Data) -> enc_TAIItem(Data);
encode_disp('UEContextReleaseRequest', Data) -> enc_UEContextReleaseRequest(Data);
encode_disp('UEContextReleaseCommand', Data) -> enc_UEContextReleaseCommand(Data);
encode_disp('UEContextReleaseComplete', Data) -> enc_UEContextReleaseComplete(Data);
encode_disp('UEContextModificationRequest', Data) -> enc_UEContextModificationRequest(Data);
encode_disp('UEContextModificationResponse', Data) -> enc_UEContextModificationResponse(Data);
encode_disp('UEContextModificationFailure', Data) -> enc_UEContextModificationFailure(Data);
encode_disp('UERadioCapabilityMatchRequest', Data) -> enc_UERadioCapabilityMatchRequest(Data);
encode_disp('UERadioCapabilityMatchResponse', Data) -> enc_UERadioCapabilityMatchResponse(Data);
encode_disp('DownlinkNASTransport', Data) -> enc_DownlinkNASTransport(Data);
encode_disp('InitialUEMessage', Data) -> enc_InitialUEMessage(Data);
encode_disp('UplinkNASTransport', Data) -> enc_UplinkNASTransport(Data);
encode_disp('NASNonDeliveryIndication', Data) -> enc_NASNonDeliveryIndication(Data);
encode_disp('RerouteNASRequest', Data) -> enc_RerouteNASRequest(Data);
encode_disp('S1-Message', Data) -> 'enc_S1-Message'(Data);
encode_disp('NASDeliveryIndication', Data) -> enc_NASDeliveryIndication(Data);
encode_disp('Reset', Data) -> enc_Reset(Data);
encode_disp('ResetType', Data) -> enc_ResetType(Data);
encode_disp('ResetAll', Data) -> enc_ResetAll(Data);
encode_disp('UE-associatedLogicalS1-ConnectionListRes', Data) -> 'enc_UE-associatedLogicalS1-ConnectionListRes'(Data);
encode_disp('ResetAcknowledge', Data) -> enc_ResetAcknowledge(Data);
encode_disp('UE-associatedLogicalS1-ConnectionListResAck', Data) -> 'enc_UE-associatedLogicalS1-ConnectionListResAck'(Data);
encode_disp('ErrorIndication', Data) -> enc_ErrorIndication(Data);
encode_disp('S1SetupRequest', Data) -> enc_S1SetupRequest(Data);
encode_disp('S1SetupResponse', Data) -> enc_S1SetupResponse(Data);
encode_disp('S1SetupFailure', Data) -> enc_S1SetupFailure(Data);
encode_disp('ENBConfigurationUpdate', Data) -> enc_ENBConfigurationUpdate(Data);
encode_disp('ENBConfigurationUpdateAcknowledge', Data) -> enc_ENBConfigurationUpdateAcknowledge(Data);
encode_disp('ENBConfigurationUpdateFailure', Data) -> enc_ENBConfigurationUpdateFailure(Data);
encode_disp('MMEConfigurationUpdate', Data) -> enc_MMEConfigurationUpdate(Data);
encode_disp('MMEConfigurationUpdateAcknowledge', Data) -> enc_MMEConfigurationUpdateAcknowledge(Data);
encode_disp('MMEConfigurationUpdateFailure', Data) -> enc_MMEConfigurationUpdateFailure(Data);
encode_disp('DownlinkS1cdma2000tunnelling', Data) -> enc_DownlinkS1cdma2000tunnelling(Data);
encode_disp('UplinkS1cdma2000tunnelling', Data) -> enc_UplinkS1cdma2000tunnelling(Data);
encode_disp('UECapabilityInfoIndication', Data) -> enc_UECapabilityInfoIndication(Data);
encode_disp('ENBStatusTransfer', Data) -> enc_ENBStatusTransfer(Data);
encode_disp('MMEStatusTransfer', Data) -> enc_MMEStatusTransfer(Data);
encode_disp('TraceStart', Data) -> enc_TraceStart(Data);
encode_disp('TraceFailureIndication', Data) -> enc_TraceFailureIndication(Data);
encode_disp('DeactivateTrace', Data) -> enc_DeactivateTrace(Data);
encode_disp('CellTrafficTrace', Data) -> enc_CellTrafficTrace(Data);
encode_disp('LocationReportingControl', Data) -> enc_LocationReportingControl(Data);
encode_disp('LocationReportingFailureIndication', Data) -> enc_LocationReportingFailureIndication(Data);
encode_disp('LocationReport', Data) -> enc_LocationReport(Data);
encode_disp('OverloadStart', Data) -> enc_OverloadStart(Data);
encode_disp('OverloadStop', Data) -> enc_OverloadStop(Data);
encode_disp('WriteReplaceWarningRequest', Data) -> enc_WriteReplaceWarningRequest(Data);
encode_disp('WriteReplaceWarningResponse', Data) -> enc_WriteReplaceWarningResponse(Data);
encode_disp('ENBDirectInformationTransfer', Data) -> enc_ENBDirectInformationTransfer(Data);
encode_disp('Inter-SystemInformationTransferType', Data) -> 'enc_Inter-SystemInformationTransferType'(Data);
encode_disp('MMEDirectInformationTransfer', Data) -> enc_MMEDirectInformationTransfer(Data);
encode_disp('ENBConfigurationTransfer', Data) -> enc_ENBConfigurationTransfer(Data);
encode_disp('MMEConfigurationTransfer', Data) -> enc_MMEConfigurationTransfer(Data);
encode_disp('PrivateMessage', Data) -> enc_PrivateMessage(Data);
encode_disp('KillRequest', Data) -> enc_KillRequest(Data);
encode_disp('KillResponse', Data) -> enc_KillResponse(Data);
encode_disp('PWSRestartIndication', Data) -> enc_PWSRestartIndication(Data);
encode_disp('PWSFailureIndication', Data) -> enc_PWSFailureIndication(Data);
encode_disp('DownlinkUEAssociatedLPPaTransport', Data) -> enc_DownlinkUEAssociatedLPPaTransport(Data);
encode_disp('UplinkUEAssociatedLPPaTransport', Data) -> enc_UplinkUEAssociatedLPPaTransport(Data);
encode_disp('DownlinkNonUEAssociatedLPPaTransport', Data) -> enc_DownlinkNonUEAssociatedLPPaTransport(Data);
encode_disp('UplinkNonUEAssociatedLPPaTransport', Data) -> enc_UplinkNonUEAssociatedLPPaTransport(Data);
encode_disp('E-RABModificationIndication', Data) -> 'enc_E-RABModificationIndication'(Data);
encode_disp('E-RABToBeModifiedListBearerModInd', Data) -> 'enc_E-RABToBeModifiedListBearerModInd'(Data);
encode_disp('E-RABToBeModifiedItemBearerModInd', Data) -> 'enc_E-RABToBeModifiedItemBearerModInd'(Data);
encode_disp('E-RABNotToBeModifiedListBearerModInd', Data) -> 'enc_E-RABNotToBeModifiedListBearerModInd'(Data);
encode_disp('E-RABNotToBeModifiedItemBearerModInd', Data) -> 'enc_E-RABNotToBeModifiedItemBearerModInd'(Data);
encode_disp('CSGMembershipInfo', Data) -> enc_CSGMembershipInfo(Data);
encode_disp('E-RABModificationConfirm', Data) -> 'enc_E-RABModificationConfirm'(Data);
encode_disp('E-RABModifyListBearerModConf', Data) -> 'enc_E-RABModifyListBearerModConf'(Data);
encode_disp('E-RABModifyItemBearerModConf', Data) -> 'enc_E-RABModifyItemBearerModConf'(Data);
encode_disp('UEContextModificationIndication', Data) -> enc_UEContextModificationIndication(Data);
encode_disp('UEContextModificationConfirm', Data) -> enc_UEContextModificationConfirm(Data);
encode_disp('UEContextSuspendRequest', Data) -> enc_UEContextSuspendRequest(Data);
encode_disp('UEContextSuspendResponse', Data) -> enc_UEContextSuspendResponse(Data);
encode_disp('UEContextResumeRequest', Data) -> enc_UEContextResumeRequest(Data);
encode_disp('E-RABFailedToResumeListResumeReq', Data) -> 'enc_E-RABFailedToResumeListResumeReq'(Data);
encode_disp('E-RABFailedToResumeItemResumeReq', Data) -> 'enc_E-RABFailedToResumeItemResumeReq'(Data);
encode_disp('UEContextResumeResponse', Data) -> enc_UEContextResumeResponse(Data);
encode_disp('E-RABFailedToResumeListResumeRes', Data) -> 'enc_E-RABFailedToResumeListResumeRes'(Data);
encode_disp('E-RABFailedToResumeItemResumeRes', Data) -> 'enc_E-RABFailedToResumeItemResumeRes'(Data);
encode_disp('UEContextResumeFailure', Data) -> enc_UEContextResumeFailure(Data);
encode_disp('ConnectionEstablishmentIndication', Data) -> enc_ConnectionEstablishmentIndication(Data);
encode_disp('RetrieveUEInformation', Data) -> enc_RetrieveUEInformation(Data);
encode_disp('UEInformationTransfer', Data) -> enc_UEInformationTransfer(Data);
encode_disp('ENBCPRelocationIndication', Data) -> enc_ENBCPRelocationIndication(Data);
encode_disp('MMECPRelocationIndication', Data) -> enc_MMECPRelocationIndication(Data);
encode_disp('SecondaryRATDataUsageReport', Data) -> enc_SecondaryRATDataUsageReport(Data);
encode_disp('UERadioCapabilityIDMappingRequest', Data) -> enc_UERadioCapabilityIDMappingRequest(Data);
encode_disp('UERadioCapabilityIDMappingResponse', Data) -> enc_UERadioCapabilityIDMappingResponse(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('HandoverRequired', Data) -> dec_HandoverRequired(Data);
decode_disp('HandoverCommand', Data) -> dec_HandoverCommand(Data);
decode_disp('E-RABSubjecttoDataForwardingList', Data) -> 'dec_E-RABSubjecttoDataForwardingList'(Data);
decode_disp('E-RABDataForwardingItem', Data) -> 'dec_E-RABDataForwardingItem'(Data);
decode_disp('HandoverPreparationFailure', Data) -> dec_HandoverPreparationFailure(Data);
decode_disp('HandoverRequest', Data) -> dec_HandoverRequest(Data);
decode_disp('E-RABToBeSetupListHOReq', Data) -> 'dec_E-RABToBeSetupListHOReq'(Data);
decode_disp('E-RABToBeSetupItemHOReq', Data) -> 'dec_E-RABToBeSetupItemHOReq'(Data);
decode_disp('HandoverRequestAcknowledge', Data) -> dec_HandoverRequestAcknowledge(Data);
decode_disp('E-RABAdmittedList', Data) -> 'dec_E-RABAdmittedList'(Data);
decode_disp('E-RABAdmittedItem', Data) -> 'dec_E-RABAdmittedItem'(Data);
decode_disp('E-RABFailedtoSetupListHOReqAck', Data) -> 'dec_E-RABFailedtoSetupListHOReqAck'(Data);
decode_disp('E-RABFailedToSetupItemHOReqAck', Data) -> 'dec_E-RABFailedToSetupItemHOReqAck'(Data);
decode_disp('HandoverFailure', Data) -> dec_HandoverFailure(Data);
decode_disp('HandoverNotify', Data) -> dec_HandoverNotify(Data);
decode_disp('PathSwitchRequest', Data) -> dec_PathSwitchRequest(Data);
decode_disp('E-RABToBeSwitchedDLList', Data) -> 'dec_E-RABToBeSwitchedDLList'(Data);
decode_disp('E-RABToBeSwitchedDLItem', Data) -> 'dec_E-RABToBeSwitchedDLItem'(Data);
decode_disp('PathSwitchRequestAcknowledge', Data) -> dec_PathSwitchRequestAcknowledge(Data);
decode_disp('E-RABToBeSwitchedULList', Data) -> 'dec_E-RABToBeSwitchedULList'(Data);
decode_disp('E-RABToBeSwitchedULItem', Data) -> 'dec_E-RABToBeSwitchedULItem'(Data);
decode_disp('E-RABToBeUpdatedList', Data) -> 'dec_E-RABToBeUpdatedList'(Data);
decode_disp('E-RABToBeUpdatedItem', Data) -> 'dec_E-RABToBeUpdatedItem'(Data);
decode_disp('PathSwitchRequestFailure', Data) -> dec_PathSwitchRequestFailure(Data);
decode_disp('HandoverCancel', Data) -> dec_HandoverCancel(Data);
decode_disp('HandoverCancelAcknowledge', Data) -> dec_HandoverCancelAcknowledge(Data);
decode_disp('HandoverSuccess', Data) -> dec_HandoverSuccess(Data);
decode_disp('ENBEarlyStatusTransfer', Data) -> dec_ENBEarlyStatusTransfer(Data);
decode_disp('MMEEarlyStatusTransfer', Data) -> dec_MMEEarlyStatusTransfer(Data);
decode_disp('E-RABSetupRequest', Data) -> 'dec_E-RABSetupRequest'(Data);
decode_disp('E-RABToBeSetupListBearerSUReq', Data) -> 'dec_E-RABToBeSetupListBearerSUReq'(Data);
decode_disp('E-RABToBeSetupItemBearerSUReq', Data) -> 'dec_E-RABToBeSetupItemBearerSUReq'(Data);
decode_disp('E-RABSetupResponse', Data) -> 'dec_E-RABSetupResponse'(Data);
decode_disp('E-RABSetupListBearerSURes', Data) -> 'dec_E-RABSetupListBearerSURes'(Data);
decode_disp('E-RABSetupItemBearerSURes', Data) -> 'dec_E-RABSetupItemBearerSURes'(Data);
decode_disp('E-RABModifyRequest', Data) -> 'dec_E-RABModifyRequest'(Data);
decode_disp('E-RABToBeModifiedListBearerModReq', Data) -> 'dec_E-RABToBeModifiedListBearerModReq'(Data);
decode_disp('E-RABToBeModifiedItemBearerModReq', Data) -> 'dec_E-RABToBeModifiedItemBearerModReq'(Data);
decode_disp('E-RABModifyResponse', Data) -> 'dec_E-RABModifyResponse'(Data);
decode_disp('E-RABModifyListBearerModRes', Data) -> 'dec_E-RABModifyListBearerModRes'(Data);
decode_disp('E-RABModifyItemBearerModRes', Data) -> 'dec_E-RABModifyItemBearerModRes'(Data);
decode_disp('E-RABReleaseCommand', Data) -> 'dec_E-RABReleaseCommand'(Data);
decode_disp('E-RABReleaseResponse', Data) -> 'dec_E-RABReleaseResponse'(Data);
decode_disp('E-RABReleaseListBearerRelComp', Data) -> 'dec_E-RABReleaseListBearerRelComp'(Data);
decode_disp('E-RABReleaseItemBearerRelComp', Data) -> 'dec_E-RABReleaseItemBearerRelComp'(Data);
decode_disp('E-RABReleaseIndication', Data) -> 'dec_E-RABReleaseIndication'(Data);
decode_disp('InitialContextSetupRequest', Data) -> dec_InitialContextSetupRequest(Data);
decode_disp('E-RABToBeSetupListCtxtSUReq', Data) -> 'dec_E-RABToBeSetupListCtxtSUReq'(Data);
decode_disp('E-RABToBeSetupItemCtxtSUReq', Data) -> 'dec_E-RABToBeSetupItemCtxtSUReq'(Data);
decode_disp('InitialContextSetupResponse', Data) -> dec_InitialContextSetupResponse(Data);
decode_disp('E-RABSetupListCtxtSURes', Data) -> 'dec_E-RABSetupListCtxtSURes'(Data);
decode_disp('E-RABSetupItemCtxtSURes', Data) -> 'dec_E-RABSetupItemCtxtSURes'(Data);
decode_disp('InitialContextSetupFailure', Data) -> dec_InitialContextSetupFailure(Data);
decode_disp('Paging', Data) -> dec_Paging(Data);
decode_disp('TAIList', Data) -> dec_TAIList(Data);
decode_disp('TAIItem', Data) -> dec_TAIItem(Data);
decode_disp('UEContextReleaseRequest', Data) -> dec_UEContextReleaseRequest(Data);
decode_disp('UEContextReleaseCommand', Data) -> dec_UEContextReleaseCommand(Data);
decode_disp('UEContextReleaseComplete', Data) -> dec_UEContextReleaseComplete(Data);
decode_disp('UEContextModificationRequest', Data) -> dec_UEContextModificationRequest(Data);
decode_disp('UEContextModificationResponse', Data) -> dec_UEContextModificationResponse(Data);
decode_disp('UEContextModificationFailure', Data) -> dec_UEContextModificationFailure(Data);
decode_disp('UERadioCapabilityMatchRequest', Data) -> dec_UERadioCapabilityMatchRequest(Data);
decode_disp('UERadioCapabilityMatchResponse', Data) -> dec_UERadioCapabilityMatchResponse(Data);
decode_disp('DownlinkNASTransport', Data) -> dec_DownlinkNASTransport(Data);
decode_disp('InitialUEMessage', Data) -> dec_InitialUEMessage(Data);
decode_disp('UplinkNASTransport', Data) -> dec_UplinkNASTransport(Data);
decode_disp('NASNonDeliveryIndication', Data) -> dec_NASNonDeliveryIndication(Data);
decode_disp('RerouteNASRequest', Data) -> dec_RerouteNASRequest(Data);
decode_disp('S1-Message', Data) -> 'dec_S1-Message'(Data);
decode_disp('NASDeliveryIndication', Data) -> dec_NASDeliveryIndication(Data);
decode_disp('Reset', Data) -> dec_Reset(Data);
decode_disp('ResetType', Data) -> dec_ResetType(Data);
decode_disp('ResetAll', Data) -> dec_ResetAll(Data);
decode_disp('UE-associatedLogicalS1-ConnectionListRes', Data) -> 'dec_UE-associatedLogicalS1-ConnectionListRes'(Data);
decode_disp('ResetAcknowledge', Data) -> dec_ResetAcknowledge(Data);
decode_disp('UE-associatedLogicalS1-ConnectionListResAck', Data) -> 'dec_UE-associatedLogicalS1-ConnectionListResAck'(Data);
decode_disp('ErrorIndication', Data) -> dec_ErrorIndication(Data);
decode_disp('S1SetupRequest', Data) -> dec_S1SetupRequest(Data);
decode_disp('S1SetupResponse', Data) -> dec_S1SetupResponse(Data);
decode_disp('S1SetupFailure', Data) -> dec_S1SetupFailure(Data);
decode_disp('ENBConfigurationUpdate', Data) -> dec_ENBConfigurationUpdate(Data);
decode_disp('ENBConfigurationUpdateAcknowledge', Data) -> dec_ENBConfigurationUpdateAcknowledge(Data);
decode_disp('ENBConfigurationUpdateFailure', Data) -> dec_ENBConfigurationUpdateFailure(Data);
decode_disp('MMEConfigurationUpdate', Data) -> dec_MMEConfigurationUpdate(Data);
decode_disp('MMEConfigurationUpdateAcknowledge', Data) -> dec_MMEConfigurationUpdateAcknowledge(Data);
decode_disp('MMEConfigurationUpdateFailure', Data) -> dec_MMEConfigurationUpdateFailure(Data);
decode_disp('DownlinkS1cdma2000tunnelling', Data) -> dec_DownlinkS1cdma2000tunnelling(Data);
decode_disp('UplinkS1cdma2000tunnelling', Data) -> dec_UplinkS1cdma2000tunnelling(Data);
decode_disp('UECapabilityInfoIndication', Data) -> dec_UECapabilityInfoIndication(Data);
decode_disp('ENBStatusTransfer', Data) -> dec_ENBStatusTransfer(Data);
decode_disp('MMEStatusTransfer', Data) -> dec_MMEStatusTransfer(Data);
decode_disp('TraceStart', Data) -> dec_TraceStart(Data);
decode_disp('TraceFailureIndication', Data) -> dec_TraceFailureIndication(Data);
decode_disp('DeactivateTrace', Data) -> dec_DeactivateTrace(Data);
decode_disp('CellTrafficTrace', Data) -> dec_CellTrafficTrace(Data);
decode_disp('LocationReportingControl', Data) -> dec_LocationReportingControl(Data);
decode_disp('LocationReportingFailureIndication', Data) -> dec_LocationReportingFailureIndication(Data);
decode_disp('LocationReport', Data) -> dec_LocationReport(Data);
decode_disp('OverloadStart', Data) -> dec_OverloadStart(Data);
decode_disp('OverloadStop', Data) -> dec_OverloadStop(Data);
decode_disp('WriteReplaceWarningRequest', Data) -> dec_WriteReplaceWarningRequest(Data);
decode_disp('WriteReplaceWarningResponse', Data) -> dec_WriteReplaceWarningResponse(Data);
decode_disp('ENBDirectInformationTransfer', Data) -> dec_ENBDirectInformationTransfer(Data);
decode_disp('Inter-SystemInformationTransferType', Data) -> 'dec_Inter-SystemInformationTransferType'(Data);
decode_disp('MMEDirectInformationTransfer', Data) -> dec_MMEDirectInformationTransfer(Data);
decode_disp('ENBConfigurationTransfer', Data) -> dec_ENBConfigurationTransfer(Data);
decode_disp('MMEConfigurationTransfer', Data) -> dec_MMEConfigurationTransfer(Data);
decode_disp('PrivateMessage', Data) -> dec_PrivateMessage(Data);
decode_disp('KillRequest', Data) -> dec_KillRequest(Data);
decode_disp('KillResponse', Data) -> dec_KillResponse(Data);
decode_disp('PWSRestartIndication', Data) -> dec_PWSRestartIndication(Data);
decode_disp('PWSFailureIndication', Data) -> dec_PWSFailureIndication(Data);
decode_disp('DownlinkUEAssociatedLPPaTransport', Data) -> dec_DownlinkUEAssociatedLPPaTransport(Data);
decode_disp('UplinkUEAssociatedLPPaTransport', Data) -> dec_UplinkUEAssociatedLPPaTransport(Data);
decode_disp('DownlinkNonUEAssociatedLPPaTransport', Data) -> dec_DownlinkNonUEAssociatedLPPaTransport(Data);
decode_disp('UplinkNonUEAssociatedLPPaTransport', Data) -> dec_UplinkNonUEAssociatedLPPaTransport(Data);
decode_disp('E-RABModificationIndication', Data) -> 'dec_E-RABModificationIndication'(Data);
decode_disp('E-RABToBeModifiedListBearerModInd', Data) -> 'dec_E-RABToBeModifiedListBearerModInd'(Data);
decode_disp('E-RABToBeModifiedItemBearerModInd', Data) -> 'dec_E-RABToBeModifiedItemBearerModInd'(Data);
decode_disp('E-RABNotToBeModifiedListBearerModInd', Data) -> 'dec_E-RABNotToBeModifiedListBearerModInd'(Data);
decode_disp('E-RABNotToBeModifiedItemBearerModInd', Data) -> 'dec_E-RABNotToBeModifiedItemBearerModInd'(Data);
decode_disp('CSGMembershipInfo', Data) -> dec_CSGMembershipInfo(Data);
decode_disp('E-RABModificationConfirm', Data) -> 'dec_E-RABModificationConfirm'(Data);
decode_disp('E-RABModifyListBearerModConf', Data) -> 'dec_E-RABModifyListBearerModConf'(Data);
decode_disp('E-RABModifyItemBearerModConf', Data) -> 'dec_E-RABModifyItemBearerModConf'(Data);
decode_disp('UEContextModificationIndication', Data) -> dec_UEContextModificationIndication(Data);
decode_disp('UEContextModificationConfirm', Data) -> dec_UEContextModificationConfirm(Data);
decode_disp('UEContextSuspendRequest', Data) -> dec_UEContextSuspendRequest(Data);
decode_disp('UEContextSuspendResponse', Data) -> dec_UEContextSuspendResponse(Data);
decode_disp('UEContextResumeRequest', Data) -> dec_UEContextResumeRequest(Data);
decode_disp('E-RABFailedToResumeListResumeReq', Data) -> 'dec_E-RABFailedToResumeListResumeReq'(Data);
decode_disp('E-RABFailedToResumeItemResumeReq', Data) -> 'dec_E-RABFailedToResumeItemResumeReq'(Data);
decode_disp('UEContextResumeResponse', Data) -> dec_UEContextResumeResponse(Data);
decode_disp('E-RABFailedToResumeListResumeRes', Data) -> 'dec_E-RABFailedToResumeListResumeRes'(Data);
decode_disp('E-RABFailedToResumeItemResumeRes', Data) -> 'dec_E-RABFailedToResumeItemResumeRes'(Data);
decode_disp('UEContextResumeFailure', Data) -> dec_UEContextResumeFailure(Data);
decode_disp('ConnectionEstablishmentIndication', Data) -> dec_ConnectionEstablishmentIndication(Data);
decode_disp('RetrieveUEInformation', Data) -> dec_RetrieveUEInformation(Data);
decode_disp('UEInformationTransfer', Data) -> dec_UEInformationTransfer(Data);
decode_disp('ENBCPRelocationIndication', Data) -> dec_ENBCPRelocationIndication(Data);
decode_disp('MMECPRelocationIndication', Data) -> dec_MMECPRelocationIndication(Data);
decode_disp('SecondaryRATDataUsageReport', Data) -> dec_SecondaryRATDataUsageReport(Data);
decode_disp('UERadioCapabilityIDMappingRequest', Data) -> dec_UERadioCapabilityIDMappingRequest(Data);
decode_disp('UERadioCapabilityIDMappingResponse', Data) -> dec_UERadioCapabilityIDMappingResponse(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.
enc_HandoverRequired(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_HandoverRequired_protocolIEs(Enc2@element)
end].
enc_HandoverRequired_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_HandoverRequired_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_HandoverRequired_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value1(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_HandoverRequired(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_HandoverRequired_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'HandoverRequired',Term1},
{Res1,Bytes4}.


dec_HandoverRequired_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components2(V1@V0, V1@Buf1, []).


'dec_HandoverRequired_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value3(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_HandoverCommand(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_HandoverCommand_protocolIEs(Enc2@element)
end].
enc_HandoverCommand_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_HandoverCommand_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_HandoverCommand_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value4(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_HandoverCommand(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_HandoverCommand_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'HandoverCommand',Term1},
{Res1,Bytes4}.


dec_HandoverCommand_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components5(V1@V0, V1@Buf1, []).


'dec_HandoverCommand_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value6(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABSubjecttoDataForwardingList'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABSubjecttoDataForwardingList_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABSubjecttoDataForwardingList_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value7(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABSubjecttoDataForwardingList'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components8(V1@Add4, V1@Buf1, []).


'dec_E-RABSubjecttoDataForwardingList_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value9(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABDataForwardingItem'(Val) ->
[begin
Enc1@element = element(3, Val),
Enc2@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@element = element(5, Val),
Enc4@element = element(6, Val),
if Enc3@element =:= asn1_NOVALUE ->
if Enc4@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc4@element =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc5@element = element(7, Val),
if Enc5@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc7@element = element(2, Val),
if Enc7@element bsr 4 =:= 0 ->
<<0:1,Enc7@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc7@element)]
end
end,
begin
%% attribute dL-transportLayerAddress(2) with type BIT STRING
Enc9@element = element(3, Val),
if Enc9@element =:= asn1_NOVALUE ->
[];
true ->
begin
Enc10@bits = bit_size(Enc9@element),
Enc10@bits@sub = Enc10@bits - 1,
if 0 =< Enc10@bits@sub, Enc10@bits@sub < 160 ->
[<<0:1,Enc10@bits@sub:8>>,
align|Enc9@element];
Enc10@bits < 16384 ->
[<<1:1>>,
align,
<<2:2,Enc10@bits:14>>|Enc9@element];
true ->
[<<1:1>>,
align|encode_fragmented(Enc9@element, 1)]
end
end
end
end,
begin
%% attribute dL-gTP-TEID(3) with type OCTET STRING
Enc12@element = element(4, Val),
if Enc12@element =:= asn1_NOVALUE ->
[];
true ->
begin
Enc13@len = byte_size(Enc12@element),
if Enc13@len =:= 4 ->
[align|Enc12@element]
end
end
end
end,
begin
%% attribute uL-TransportLayerAddress(4) with type BIT STRING
Enc15@element = element(5, Val),
if Enc15@element =:= asn1_NOVALUE ->
[];
true ->
begin
Enc16@bits = bit_size(Enc15@element),
Enc16@bits@sub = Enc16@bits - 1,
if 0 =< Enc16@bits@sub, Enc16@bits@sub < 160 ->
[<<0:1,Enc16@bits@sub:8>>,
align|Enc15@element];
Enc16@bits < 16384 ->
[<<1:1>>,
align,
<<2:2,Enc16@bits:14>>|Enc15@element];
true ->
[<<1:1>>,
align|encode_fragmented(Enc15@element, 1)]
end
end
end
end,
begin
%% attribute uL-GTP-TEID(5) with type OCTET STRING
Enc18@element = element(6, Val),
if Enc18@element =:= asn1_NOVALUE ->
[];
true ->
begin
Enc19@len = byte_size(Enc18@element),
if Enc19@len =:= 4 ->
[align|Enc18@element]
end
end
end
end|begin
%% attribute iE-Extensions(6) with type SEQUENCE OF
Enc21@element = element(7, Val),
if Enc21@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABDataForwardingItem_iE-Extensions'(Enc21@element)
end
end].
'enc_E-RABDataForwardingItem_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABDataForwardingItem_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABDataForwardingItem_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension10(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABDataForwardingItem'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:5,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute dL-transportLayerAddress(2) with type BIT STRING
{Term2,Bytes4} = case (Opt bsr 4) band 1 of
1 ->
begin
{V4@V0,V4@Buf1} = case Bytes3 of
<<0:1,V4@V3:8/unsigned-unit:1,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
V4@Pad8 = bit_size(V4@Buf4) band 7,
<<_:V4@Pad8,V4@V6:V4@Add5/binary-unit:1,V4@Buf7/bitstring>> = V4@Buf4,
{V4@V6,V4@Buf7};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@V10:V4@V8/binary-unit:1,V4@Buf11/bitstring>> ->
{V4@V10,V4@Buf11};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@V11:V4@V9/binary-unit:1,V4@Buf12/bitstring>> ->
{V4@V11,V4@Buf12};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> ->
{V4@V11,V4@Buf12}  = decode_fragmented(V4@V9, V4@Buf10, 1),
{V4@V11,V4@Buf12}
end,
{V4@V3,V4@Buf4}
end,
{V4@V13,V4@Buf14}  = {list_to_bitstring([V4@V0]),V4@Buf1},
{V4@V13,V4@Buf14}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute dL-gTP-TEID(3) with type OCTET STRING
{Term3,Bytes5} = case (Opt bsr 3) band 1 of
1 ->
begin
V5@Pad2 = bit_size(Bytes4) band 7,
<<_:V5@Pad2,V5@V0:4/binary-unit:8,V5@Buf1/bitstring>> = Bytes4,
V5@Conv4 = binary:copy(V5@V0),
{V5@Conv4,V5@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute uL-TransportLayerAddress(4) with type BIT STRING
{Term4,Bytes6} = case (Opt bsr 2) band 1 of
1 ->
begin
{V6@V0,V6@Buf1} = case Bytes5 of
<<0:1,V6@V3:8/unsigned-unit:1,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
V6@Pad8 = bit_size(V6@Buf4) band 7,
<<_:V6@Pad8,V6@V6:V6@Add5/binary-unit:1,V6@Buf7/bitstring>> = V6@Buf4,
{V6@V6,V6@Buf7};
<<1:1,V6@Buf2/bitstring>> ->
V6@Pad6 = bit_size(V6@Buf2) band 7,
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:V6@Pad6,0:1,V6@V8:7,V6@V10:V6@V8/binary-unit:1,V6@Buf11/bitstring>> ->
{V6@V10,V6@Buf11};
<<_:V6@Pad6,1:1,0:1,V6@V9:14,V6@V11:V6@V9/binary-unit:1,V6@Buf12/bitstring>> ->
{V6@V11,V6@Buf12};
<<_:V6@Pad6,1:1,1:1,V6@V9:6,V6@Buf10/bitstring>> ->
{V6@V11,V6@Buf12}  = decode_fragmented(V6@V9, V6@Buf10, 1),
{V6@V11,V6@Buf12}
end,
{V6@V3,V6@Buf4}
end,
{V6@V13,V6@Buf14}  = {list_to_bitstring([V6@V0]),V6@Buf1},
{V6@V13,V6@Buf14}
end;
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% attribute uL-GTP-TEID(5) with type OCTET STRING
{Term5,Bytes7} = case (Opt bsr 1) band 1 of
1 ->
begin
V7@Pad2 = bit_size(Bytes6) band 7,
<<_:V7@Pad2,V7@V0:4/binary-unit:8,V7@Buf1/bitstring>> = Bytes6,
V7@Conv4 = binary:copy(V7@V0),
{V7@Conv4,V7@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes6}
end,

%% attribute iE-Extensions(6) with type SEQUENCE OF
{Term6,Bytes8} = case Opt band 1 of
1 ->
'dec_E-RABDataForwardingItem_iE-Extensions'(Bytes7);
0 ->
{asn1_NOVALUE,Bytes7}
end,

%% Extensions
{Extensions,Bytes9} = case Ext of
0 -> {<<>>,Bytes8};
1 ->
{V8@V0,V8@Buf1} = case Bytes8 of
<<0:1,V8@V3:6,V8@Buf4/bitstring>> ->
V8@Add5 = V8@V3 + 1,
{V8@Add5,V8@Buf4};
<<1:1,V8@Buf2/bitstring>> ->
V8@Pad6 = bit_size(V8@Buf2) band 7,
{V8@V3,V8@Buf4} = case V8@Buf2 of
<<_:V8@Pad6,0:1,V8@V8:7,V8@Buf9/bitstring>> when V8@V8 =/= 0 ->
{V8@V8,V8@Buf9};
<<_:V8@Pad6,1:1,0:1,V8@V9:14,V8@Buf10/bitstring>> when V8@V9 =/= 0 ->
{V8@V9,V8@Buf10};
<<_:V8@Pad6,1:1,1:1,V8@V9:6,V8@Buf10/bitstring>> when V8@V9 =/= 0 ->
V8@Mul11 = V8@V9 * 16384,
{V8@Mul11,V8@Buf10}
end,
{V8@V3,V8@Buf4}
end,
<<V8@V12:V8@V0/bitstring-unit:1,V8@Buf13/bitstring>> = V8@Buf1,
{V8@V12,V8@Buf13}
end,
Bytes10= skipextensions(Bytes9, 1, Extensions),
Res1 = {'E-RABDataForwardingItem',Term1,Term2,Term3,Term4,Term5,Term6},
{Res1,Bytes10}.


'dec_E-RABDataForwardingItem_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components11(V1@Add4, V1@Buf1, []).


'dec_E-RABDataForwardingItem_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension12(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_HandoverPreparationFailure(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_HandoverPreparationFailure_protocolIEs(Enc2@element)
end].
enc_HandoverPreparationFailure_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_HandoverPreparationFailure_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_HandoverPreparationFailure_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value13(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_HandoverPreparationFailure(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_HandoverPreparationFailure_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'HandoverPreparationFailure',Term1},
{Res1,Bytes4}.


dec_HandoverPreparationFailure_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components14(V1@V0, V1@Buf1, []).


'dec_HandoverPreparationFailure_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value15(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_HandoverRequest(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_HandoverRequest_protocolIEs(Enc2@element)
end].
enc_HandoverRequest_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_HandoverRequest_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_HandoverRequest_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value16(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_HandoverRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_HandoverRequest_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'HandoverRequest',Term1},
{Res1,Bytes4}.


dec_HandoverRequest_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components17(V1@V0, V1@Buf1, []).


'dec_HandoverRequest_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value18(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABToBeSetupListHOReq'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABToBeSetupListHOReq_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABToBeSetupListHOReq_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value19(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABToBeSetupListHOReq'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components20(V1@Add4, V1@Buf1, []).


'dec_E-RABToBeSetupListHOReq_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value21(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABToBeSetupItemHOReq'(Val) ->
[begin
Enc1@element = element(6, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 4 =:= 0 ->
<<0:1,Enc3@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc3@element)]
end
end,
begin
%% attribute transportLayerAddress(2) with type BIT STRING
Enc5@element = element(3, Val),
Enc6@bits = bit_size(Enc5@element),
Enc6@bits@sub = Enc6@bits - 1,
if 0 =< Enc6@bits@sub, Enc6@bits@sub < 160 ->
[<<0:1,Enc6@bits@sub:8>>,
align|Enc5@element];
Enc6@bits < 16384 ->
[<<1:1>>,
align,
<<2:2,Enc6@bits:14>>|Enc5@element];
true ->
[<<1:1>>,
align|encode_fragmented(Enc5@element, 1)]
end
end,
align,
begin
%% attribute gTP-TEID(3) with type OCTET STRING
Enc7@element = element(4, Val),
Enc8@len = byte_size(Enc7@element),
if Enc8@len =:= 4 ->
Enc7@element
end
end,
begin
%% attribute e-RABlevelQosParameters(4) with type E-RABLevelQoSParameters
Enc9@element = element(5, Val),
'S1AP-IEs':'enc_E-RABLevelQoSParameters'(Enc9@element)
end|begin
%% attribute iE-Extensions(5) with type SEQUENCE OF
Enc10@element = element(6, Val),
if Enc10@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABToBeSetupItemHOReq_iE-Extensions'(Enc10@element)
end
end].
'enc_E-RABToBeSetupItemHOReq_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABToBeSetupItemHOReq_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABToBeSetupItemHOReq_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension22(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABToBeSetupItemHOReq'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute transportLayerAddress(2) with type BIT STRING
{Term2,Bytes4} = begin
{V4@V0,V4@Buf1} = case Bytes3 of
<<0:1,V4@V3:8/unsigned-unit:1,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
V4@Pad8 = bit_size(V4@Buf4) band 7,
<<_:V4@Pad8,V4@V6:V4@Add5/binary-unit:1,V4@Buf7/bitstring>> = V4@Buf4,
{V4@V6,V4@Buf7};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@V10:V4@V8/binary-unit:1,V4@Buf11/bitstring>> ->
{V4@V10,V4@Buf11};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@V11:V4@V9/binary-unit:1,V4@Buf12/bitstring>> ->
{V4@V11,V4@Buf12};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> ->
{V4@V11,V4@Buf12}  = decode_fragmented(V4@V9, V4@Buf10, 1),
{V4@V11,V4@Buf12}
end,
{V4@V3,V4@Buf4}
end,
{V4@V13,V4@Buf14}  = {list_to_bitstring([V4@V0]),V4@Buf1},
{V4@V13,V4@Buf14}
end,

%% attribute gTP-TEID(3) with type OCTET STRING
{Term3,Bytes5} = begin
V5@Pad2 = bit_size(Bytes4) band 7,
<<_:V5@Pad2,V5@V0:4/binary-unit:8,V5@Buf1/bitstring>> = Bytes4,
V5@Conv4 = binary:copy(V5@V0),
{V5@Conv4,V5@Buf1}
end,

%% attribute e-RABlevelQosParameters(4) with type E-RABLevelQoSParameters
{Term4,Bytes6} = 'S1AP-IEs':'dec_E-RABLevelQoSParameters'(Bytes5),

%% attribute iE-Extensions(5) with type SEQUENCE OF
{Term5,Bytes7} = case Opt band 1 of
1 ->
'dec_E-RABToBeSetupItemHOReq_iE-Extensions'(Bytes6);
0 ->
{asn1_NOVALUE,Bytes6}
end,

%% Extensions
{Extensions,Bytes8} = case Ext of
0 -> {<<>>,Bytes7};
1 ->
{V6@V0,V6@Buf1} = case Bytes7 of
<<0:1,V6@V3:6,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
{V6@Add5,V6@Buf4};
<<1:1,V6@Buf2/bitstring>> ->
V6@Pad6 = bit_size(V6@Buf2) band 7,
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:V6@Pad6,0:1,V6@V8:7,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
{V6@V8,V6@Buf9};
<<_:V6@Pad6,1:1,0:1,V6@V9:14,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
{V6@V9,V6@Buf10};
<<_:V6@Pad6,1:1,1:1,V6@V9:6,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
V6@Mul11 = V6@V9 * 16384,
{V6@Mul11,V6@Buf10}
end,
{V6@V3,V6@Buf4}
end,
<<V6@V12:V6@V0/bitstring-unit:1,V6@Buf13/bitstring>> = V6@Buf1,
{V6@V12,V6@Buf13}
end,
Bytes9= skipextensions(Bytes8, 1, Extensions),
Res1 = {'E-RABToBeSetupItemHOReq',Term1,Term2,Term3,Term4,Term5},
{Res1,Bytes9}.


'dec_E-RABToBeSetupItemHOReq_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components23(V1@Add4, V1@Buf1, []).


'dec_E-RABToBeSetupItemHOReq_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension24(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_HandoverRequestAcknowledge(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_HandoverRequestAcknowledge_protocolIEs(Enc2@element)
end].
enc_HandoverRequestAcknowledge_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_HandoverRequestAcknowledge_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_HandoverRequestAcknowledge_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value25(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_HandoverRequestAcknowledge(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_HandoverRequestAcknowledge_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'HandoverRequestAcknowledge',Term1},
{Res1,Bytes4}.


dec_HandoverRequestAcknowledge_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components26(V1@V0, V1@Buf1, []).


'dec_HandoverRequestAcknowledge_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value27(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABAdmittedList'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABAdmittedList_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABAdmittedList_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value28(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABAdmittedList'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components29(V1@Add4, V1@Buf1, []).


'dec_E-RABAdmittedList_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value30(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABAdmittedItem'(Val) ->
[begin
Enc1@element = element(5, Val),
Enc2@element = element(6, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@element = element(7, Val),
Enc4@element = element(8, Val),
if Enc3@element =:= asn1_NOVALUE ->
if Enc4@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc4@element =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc5@element = element(9, Val),
if Enc5@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc7@element = element(2, Val),
if Enc7@element bsr 4 =:= 0 ->
<<0:1,Enc7@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc7@element)]
end
end,
begin
%% attribute transportLayerAddress(2) with type BIT STRING
Enc9@element = element(3, Val),
Enc10@bits = bit_size(Enc9@element),
Enc10@bits@sub = Enc10@bits - 1,
if 0 =< Enc10@bits@sub, Enc10@bits@sub < 160 ->
[<<0:1,Enc10@bits@sub:8>>,
align|Enc9@element];
Enc10@bits < 16384 ->
[<<1:1>>,
align,
<<2:2,Enc10@bits:14>>|Enc9@element];
true ->
[<<1:1>>,
align|encode_fragmented(Enc9@element, 1)]
end
end,
align,
begin
%% attribute gTP-TEID(3) with type OCTET STRING
Enc11@element = element(4, Val),
Enc12@len = byte_size(Enc11@element),
if Enc12@len =:= 4 ->
Enc11@element
end
end,
begin
%% attribute dL-transportLayerAddress(4) with type BIT STRING
Enc13@element = element(5, Val),
if Enc13@element =:= asn1_NOVALUE ->
[];
true ->
begin
Enc14@bits = bit_size(Enc13@element),
Enc14@bits@sub = Enc14@bits - 1,
if 0 =< Enc14@bits@sub, Enc14@bits@sub < 160 ->
[<<0:1,Enc14@bits@sub:8,0:7>>|Enc13@element];
Enc14@bits < 16384 ->
[<<1:1,2:9,Enc14@bits:14>>|Enc13@element];
true ->
[<<1:1,0:7>>|encode_fragmented(Enc13@element, 1)]
end
end
end
end,
begin
%% attribute dL-gTP-TEID(5) with type OCTET STRING
Enc16@element = element(6, Val),
if Enc16@element =:= asn1_NOVALUE ->
[];
true ->
begin
Enc17@len = byte_size(Enc16@element),
if Enc17@len =:= 4 ->
[align|Enc16@element]
end
end
end
end,
begin
%% attribute uL-TransportLayerAddress(6) with type BIT STRING
Enc19@element = element(7, Val),
if Enc19@element =:= asn1_NOVALUE ->
[];
true ->
begin
Enc20@bits = bit_size(Enc19@element),
Enc20@bits@sub = Enc20@bits - 1,
if 0 =< Enc20@bits@sub, Enc20@bits@sub < 160 ->
[<<0:1,Enc20@bits@sub:8>>,
align|Enc19@element];
Enc20@bits < 16384 ->
[<<1:1>>,
align,
<<2:2,Enc20@bits:14>>|Enc19@element];
true ->
[<<1:1>>,
align|encode_fragmented(Enc19@element, 1)]
end
end
end
end,
begin
%% attribute uL-GTP-TEID(7) with type OCTET STRING
Enc22@element = element(8, Val),
if Enc22@element =:= asn1_NOVALUE ->
[];
true ->
begin
Enc23@len = byte_size(Enc22@element),
if Enc23@len =:= 4 ->
[align|Enc22@element]
end
end
end
end|begin
%% attribute iE-Extensions(8) with type SEQUENCE OF
Enc25@element = element(9, Val),
if Enc25@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABAdmittedItem_iE-Extensions'(Enc25@element)
end
end].
'enc_E-RABAdmittedItem_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABAdmittedItem_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABAdmittedItem_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension10(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABAdmittedItem'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:5,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute transportLayerAddress(2) with type BIT STRING
{Term2,Bytes4} = begin
{V4@V0,V4@Buf1} = case Bytes3 of
<<0:1,V4@V3:8/unsigned-unit:1,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
V4@Pad8 = bit_size(V4@Buf4) band 7,
<<_:V4@Pad8,V4@V6:V4@Add5/binary-unit:1,V4@Buf7/bitstring>> = V4@Buf4,
{V4@V6,V4@Buf7};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@V10:V4@V8/binary-unit:1,V4@Buf11/bitstring>> ->
{V4@V10,V4@Buf11};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@V11:V4@V9/binary-unit:1,V4@Buf12/bitstring>> ->
{V4@V11,V4@Buf12};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> ->
{V4@V11,V4@Buf12}  = decode_fragmented(V4@V9, V4@Buf10, 1),
{V4@V11,V4@Buf12}
end,
{V4@V3,V4@Buf4}
end,
{V4@V13,V4@Buf14}  = {list_to_bitstring([V4@V0]),V4@Buf1},
{V4@V13,V4@Buf14}
end,

%% attribute gTP-TEID(3) with type OCTET STRING
{Term3,Bytes5} = begin
V5@Pad2 = bit_size(Bytes4) band 7,
<<_:V5@Pad2,V5@V0:4/binary-unit:8,V5@Buf1/bitstring>> = Bytes4,
V5@Conv4 = binary:copy(V5@V0),
{V5@Conv4,V5@Buf1}
end,

%% attribute dL-transportLayerAddress(4) with type BIT STRING
{Term4,Bytes6} = case (Opt bsr 4) band 1 of
1 ->
begin
{V6@V0,V6@Buf1} = case Bytes5 of
<<0:1,V6@V3:8/unsigned-unit:1,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
V6@Pad8 = bit_size(V6@Buf4) band 7,
<<_:V6@Pad8,V6@V6:V6@Add5/binary-unit:1,V6@Buf7/bitstring>> = V6@Buf4,
{V6@V6,V6@Buf7};
<<1:1,V6@Buf2/bitstring>> ->
V6@Pad6 = bit_size(V6@Buf2) band 7,
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:V6@Pad6,0:1,V6@V8:7,V6@V10:V6@V8/binary-unit:1,V6@Buf11/bitstring>> ->
{V6@V10,V6@Buf11};
<<_:V6@Pad6,1:1,0:1,V6@V9:14,V6@V11:V6@V9/binary-unit:1,V6@Buf12/bitstring>> ->
{V6@V11,V6@Buf12};
<<_:V6@Pad6,1:1,1:1,V6@V9:6,V6@Buf10/bitstring>> ->
{V6@V11,V6@Buf12}  = decode_fragmented(V6@V9, V6@Buf10, 1),
{V6@V11,V6@Buf12}
end,
{V6@V3,V6@Buf4}
end,
{V6@V13,V6@Buf14}  = {list_to_bitstring([V6@V0]),V6@Buf1},
{V6@V13,V6@Buf14}
end;
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% attribute dL-gTP-TEID(5) with type OCTET STRING
{Term5,Bytes7} = case (Opt bsr 3) band 1 of
1 ->
begin
V7@Pad2 = bit_size(Bytes6) band 7,
<<_:V7@Pad2,V7@V0:4/binary-unit:8,V7@Buf1/bitstring>> = Bytes6,
V7@Conv4 = binary:copy(V7@V0),
{V7@Conv4,V7@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes6}
end,

%% attribute uL-TransportLayerAddress(6) with type BIT STRING
{Term6,Bytes8} = case (Opt bsr 2) band 1 of
1 ->
begin
{V8@V0,V8@Buf1} = case Bytes7 of
<<0:1,V8@V3:8/unsigned-unit:1,V8@Buf4/bitstring>> ->
V8@Add5 = V8@V3 + 1,
V8@Pad8 = bit_size(V8@Buf4) band 7,
<<_:V8@Pad8,V8@V6:V8@Add5/binary-unit:1,V8@Buf7/bitstring>> = V8@Buf4,
{V8@V6,V8@Buf7};
<<1:1,V8@Buf2/bitstring>> ->
V8@Pad6 = bit_size(V8@Buf2) band 7,
{V8@V3,V8@Buf4} = case V8@Buf2 of
<<_:V8@Pad6,0:1,V8@V8:7,V8@V10:V8@V8/binary-unit:1,V8@Buf11/bitstring>> ->
{V8@V10,V8@Buf11};
<<_:V8@Pad6,1:1,0:1,V8@V9:14,V8@V11:V8@V9/binary-unit:1,V8@Buf12/bitstring>> ->
{V8@V11,V8@Buf12};
<<_:V8@Pad6,1:1,1:1,V8@V9:6,V8@Buf10/bitstring>> ->
{V8@V11,V8@Buf12}  = decode_fragmented(V8@V9, V8@Buf10, 1),
{V8@V11,V8@Buf12}
end,
{V8@V3,V8@Buf4}
end,
{V8@V13,V8@Buf14}  = {list_to_bitstring([V8@V0]),V8@Buf1},
{V8@V13,V8@Buf14}
end;
0 ->
{asn1_NOVALUE,Bytes7}
end,

%% attribute uL-GTP-TEID(7) with type OCTET STRING
{Term7,Bytes9} = case (Opt bsr 1) band 1 of
1 ->
begin
V9@Pad2 = bit_size(Bytes8) band 7,
<<_:V9@Pad2,V9@V0:4/binary-unit:8,V9@Buf1/bitstring>> = Bytes8,
V9@Conv4 = binary:copy(V9@V0),
{V9@Conv4,V9@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes8}
end,

%% attribute iE-Extensions(8) with type SEQUENCE OF
{Term8,Bytes10} = case Opt band 1 of
1 ->
'dec_E-RABAdmittedItem_iE-Extensions'(Bytes9);
0 ->
{asn1_NOVALUE,Bytes9}
end,

%% Extensions
{Extensions,Bytes11} = case Ext of
0 -> {<<>>,Bytes10};
1 ->
{V10@V0,V10@Buf1} = case Bytes10 of
<<0:1,V10@V3:6,V10@Buf4/bitstring>> ->
V10@Add5 = V10@V3 + 1,
{V10@Add5,V10@Buf4};
<<1:1,V10@Buf2/bitstring>> ->
V10@Pad6 = bit_size(V10@Buf2) band 7,
{V10@V3,V10@Buf4} = case V10@Buf2 of
<<_:V10@Pad6,0:1,V10@V8:7,V10@Buf9/bitstring>> when V10@V8 =/= 0 ->
{V10@V8,V10@Buf9};
<<_:V10@Pad6,1:1,0:1,V10@V9:14,V10@Buf10/bitstring>> when V10@V9 =/= 0 ->
{V10@V9,V10@Buf10};
<<_:V10@Pad6,1:1,1:1,V10@V9:6,V10@Buf10/bitstring>> when V10@V9 =/= 0 ->
V10@Mul11 = V10@V9 * 16384,
{V10@Mul11,V10@Buf10}
end,
{V10@V3,V10@Buf4}
end,
<<V10@V12:V10@V0/bitstring-unit:1,V10@Buf13/bitstring>> = V10@Buf1,
{V10@V12,V10@Buf13}
end,
Bytes12= skipextensions(Bytes11, 1, Extensions),
Res1 = {'E-RABAdmittedItem',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8},
{Res1,Bytes12}.


'dec_E-RABAdmittedItem_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components31(V1@Add4, V1@Buf1, []).


'dec_E-RABAdmittedItem_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension12(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABFailedtoSetupListHOReqAck'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABFailedtoSetupListHOReqAck_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABFailedtoSetupListHOReqAck_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value32(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABFailedtoSetupListHOReqAck'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components33(V1@Add4, V1@Buf1, []).


'dec_E-RABFailedtoSetupListHOReqAck_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value34(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABFailedToSetupItemHOReqAck'(Val) ->
[begin
Enc1@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 4 =:= 0 ->
<<0:1,Enc3@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc3@element)]
end
end,
begin
%% attribute cause(2) with type Cause
Enc5@element = element(3, Val),
'S1AP-IEs':enc_Cause(Enc5@element)
end|begin
%% attribute iE-Extensions(3) with type SEQUENCE OF
Enc6@element = element(4, Val),
if Enc6@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABFailedToSetupItemHOReqAck_iE-Extensions'(Enc6@element)
end
end].
'enc_E-RABFailedToSetupItemHOReqAck_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABFailedToSetupItemHOReqAck_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABFailedToSetupItemHOReqAck_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension10(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABFailedToSetupItemHOReqAck'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute cause(2) with type Cause
{Term2,Bytes4} = 'S1AP-IEs':dec_Cause(Bytes3),

%% attribute iE-Extensions(3) with type SEQUENCE OF
{Term3,Bytes5} = case Opt band 1 of
1 ->
'dec_E-RABFailedToSetupItemHOReqAck_iE-Extensions'(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V4@V0,V4@Buf1} = case Bytes5 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
V4@Mul11 = V4@V9 * 16384,
{V4@Mul11,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V12:V4@V0/bitstring-unit:1,V4@Buf13/bitstring>> = V4@Buf1,
{V4@V12,V4@Buf13}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'E-RABFailedToSetupItemHOReqAck',Term1,Term2,Term3},
{Res1,Bytes7}.


'dec_E-RABFailedToSetupItemHOReqAck_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components35(V1@Add4, V1@Buf1, []).


'dec_E-RABFailedToSetupItemHOReqAck_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension12(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_HandoverFailure(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_HandoverFailure_protocolIEs(Enc2@element)
end].
enc_HandoverFailure_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_HandoverFailure_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_HandoverFailure_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value36(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_HandoverFailure(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_HandoverFailure_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'HandoverFailure',Term1},
{Res1,Bytes4}.


dec_HandoverFailure_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components37(V1@V0, V1@Buf1, []).


'dec_HandoverFailure_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value38(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_HandoverNotify(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_HandoverNotify_protocolIEs(Enc2@element)
end].
enc_HandoverNotify_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_HandoverNotify_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_HandoverNotify_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value39(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_HandoverNotify(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_HandoverNotify_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'HandoverNotify',Term1},
{Res1,Bytes4}.


dec_HandoverNotify_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components40(V1@V0, V1@Buf1, []).


'dec_HandoverNotify_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value41(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_PathSwitchRequest(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_PathSwitchRequest_protocolIEs(Enc2@element)
end].
enc_PathSwitchRequest_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_PathSwitchRequest_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_PathSwitchRequest_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value42(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_PathSwitchRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_PathSwitchRequest_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'PathSwitchRequest',Term1},
{Res1,Bytes4}.


dec_PathSwitchRequest_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components43(V1@V0, V1@Buf1, []).


'dec_PathSwitchRequest_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value44(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABToBeSwitchedDLList'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABToBeSwitchedDLList_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABToBeSwitchedDLList_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value45(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABToBeSwitchedDLList'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components46(V1@Add4, V1@Buf1, []).


'dec_E-RABToBeSwitchedDLList_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value47(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABToBeSwitchedDLItem'(Val) ->
[begin
Enc1@element = element(5, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 4 =:= 0 ->
<<0:1,Enc3@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc3@element)]
end
end,
begin
%% attribute transportLayerAddress(2) with type BIT STRING
Enc5@element = element(3, Val),
Enc6@bits = bit_size(Enc5@element),
Enc6@bits@sub = Enc6@bits - 1,
if 0 =< Enc6@bits@sub, Enc6@bits@sub < 160 ->
[<<0:1,Enc6@bits@sub:8>>,
align|Enc5@element];
Enc6@bits < 16384 ->
[<<1:1>>,
align,
<<2:2,Enc6@bits:14>>|Enc5@element];
true ->
[<<1:1>>,
align|encode_fragmented(Enc5@element, 1)]
end
end,
align,
begin
%% attribute gTP-TEID(3) with type OCTET STRING
Enc7@element = element(4, Val),
Enc8@len = byte_size(Enc7@element),
if Enc8@len =:= 4 ->
Enc7@element
end
end|begin
%% attribute iE-Extensions(4) with type SEQUENCE OF
Enc9@element = element(5, Val),
if Enc9@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABToBeSwitchedDLItem_iE-Extensions'(Enc9@element)
end
end].
'enc_E-RABToBeSwitchedDLItem_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABToBeSwitchedDLItem_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABToBeSwitchedDLItem_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension48(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABToBeSwitchedDLItem'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute transportLayerAddress(2) with type BIT STRING
{Term2,Bytes4} = begin
{V4@V0,V4@Buf1} = case Bytes3 of
<<0:1,V4@V3:8/unsigned-unit:1,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
V4@Pad8 = bit_size(V4@Buf4) band 7,
<<_:V4@Pad8,V4@V6:V4@Add5/binary-unit:1,V4@Buf7/bitstring>> = V4@Buf4,
{V4@V6,V4@Buf7};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@V10:V4@V8/binary-unit:1,V4@Buf11/bitstring>> ->
{V4@V10,V4@Buf11};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@V11:V4@V9/binary-unit:1,V4@Buf12/bitstring>> ->
{V4@V11,V4@Buf12};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> ->
{V4@V11,V4@Buf12}  = decode_fragmented(V4@V9, V4@Buf10, 1),
{V4@V11,V4@Buf12}
end,
{V4@V3,V4@Buf4}
end,
{V4@V13,V4@Buf14}  = {list_to_bitstring([V4@V0]),V4@Buf1},
{V4@V13,V4@Buf14}
end,

%% attribute gTP-TEID(3) with type OCTET STRING
{Term3,Bytes5} = begin
V5@Pad2 = bit_size(Bytes4) band 7,
<<_:V5@Pad2,V5@V0:4/binary-unit:8,V5@Buf1/bitstring>> = Bytes4,
V5@Conv4 = binary:copy(V5@V0),
{V5@Conv4,V5@Buf1}
end,

%% attribute iE-Extensions(4) with type SEQUENCE OF
{Term4,Bytes6} = case Opt band 1 of
1 ->
'dec_E-RABToBeSwitchedDLItem_iE-Extensions'(Bytes5);
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V6@V0,V6@Buf1} = case Bytes6 of
<<0:1,V6@V3:6,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
{V6@Add5,V6@Buf4};
<<1:1,V6@Buf2/bitstring>> ->
V6@Pad6 = bit_size(V6@Buf2) band 7,
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:V6@Pad6,0:1,V6@V8:7,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
{V6@V8,V6@Buf9};
<<_:V6@Pad6,1:1,0:1,V6@V9:14,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
{V6@V9,V6@Buf10};
<<_:V6@Pad6,1:1,1:1,V6@V9:6,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
V6@Mul11 = V6@V9 * 16384,
{V6@Mul11,V6@Buf10}
end,
{V6@V3,V6@Buf4}
end,
<<V6@V12:V6@V0/bitstring-unit:1,V6@Buf13/bitstring>> = V6@Buf1,
{V6@V12,V6@Buf13}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
Res1 = {'E-RABToBeSwitchedDLItem',Term1,Term2,Term3,Term4},
{Res1,Bytes8}.


'dec_E-RABToBeSwitchedDLItem_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components49(V1@Add4, V1@Buf1, []).


'dec_E-RABToBeSwitchedDLItem_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension50(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_PathSwitchRequestAcknowledge(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_PathSwitchRequestAcknowledge_protocolIEs(Enc2@element)
end].
enc_PathSwitchRequestAcknowledge_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_PathSwitchRequestAcknowledge_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_PathSwitchRequestAcknowledge_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value51(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_PathSwitchRequestAcknowledge(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_PathSwitchRequestAcknowledge_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'PathSwitchRequestAcknowledge',Term1},
{Res1,Bytes4}.


dec_PathSwitchRequestAcknowledge_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components52(V1@V0, V1@Buf1, []).


'dec_PathSwitchRequestAcknowledge_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value53(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABToBeSwitchedULList'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABToBeSwitchedULList_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABToBeSwitchedULList_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value54(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABToBeSwitchedULList'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components55(V1@Add4, V1@Buf1, []).


'dec_E-RABToBeSwitchedULList_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value56(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABToBeSwitchedULItem'(Val) ->
[begin
Enc1@element = element(5, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 4 =:= 0 ->
<<0:1,Enc3@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc3@element)]
end
end,
begin
%% attribute transportLayerAddress(2) with type BIT STRING
Enc5@element = element(3, Val),
Enc6@bits = bit_size(Enc5@element),
Enc6@bits@sub = Enc6@bits - 1,
if 0 =< Enc6@bits@sub, Enc6@bits@sub < 160 ->
[<<0:1,Enc6@bits@sub:8>>,
align|Enc5@element];
Enc6@bits < 16384 ->
[<<1:1>>,
align,
<<2:2,Enc6@bits:14>>|Enc5@element];
true ->
[<<1:1>>,
align|encode_fragmented(Enc5@element, 1)]
end
end,
align,
begin
%% attribute gTP-TEID(3) with type OCTET STRING
Enc7@element = element(4, Val),
Enc8@len = byte_size(Enc7@element),
if Enc8@len =:= 4 ->
Enc7@element
end
end|begin
%% attribute iE-Extensions(4) with type SEQUENCE OF
Enc9@element = element(5, Val),
if Enc9@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABToBeSwitchedULItem_iE-Extensions'(Enc9@element)
end
end].
'enc_E-RABToBeSwitchedULItem_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABToBeSwitchedULItem_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABToBeSwitchedULItem_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension10(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABToBeSwitchedULItem'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute transportLayerAddress(2) with type BIT STRING
{Term2,Bytes4} = begin
{V4@V0,V4@Buf1} = case Bytes3 of
<<0:1,V4@V3:8/unsigned-unit:1,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
V4@Pad8 = bit_size(V4@Buf4) band 7,
<<_:V4@Pad8,V4@V6:V4@Add5/binary-unit:1,V4@Buf7/bitstring>> = V4@Buf4,
{V4@V6,V4@Buf7};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@V10:V4@V8/binary-unit:1,V4@Buf11/bitstring>> ->
{V4@V10,V4@Buf11};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@V11:V4@V9/binary-unit:1,V4@Buf12/bitstring>> ->
{V4@V11,V4@Buf12};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> ->
{V4@V11,V4@Buf12}  = decode_fragmented(V4@V9, V4@Buf10, 1),
{V4@V11,V4@Buf12}
end,
{V4@V3,V4@Buf4}
end,
{V4@V13,V4@Buf14}  = {list_to_bitstring([V4@V0]),V4@Buf1},
{V4@V13,V4@Buf14}
end,

%% attribute gTP-TEID(3) with type OCTET STRING
{Term3,Bytes5} = begin
V5@Pad2 = bit_size(Bytes4) band 7,
<<_:V5@Pad2,V5@V0:4/binary-unit:8,V5@Buf1/bitstring>> = Bytes4,
V5@Conv4 = binary:copy(V5@V0),
{V5@Conv4,V5@Buf1}
end,

%% attribute iE-Extensions(4) with type SEQUENCE OF
{Term4,Bytes6} = case Opt band 1 of
1 ->
'dec_E-RABToBeSwitchedULItem_iE-Extensions'(Bytes5);
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V6@V0,V6@Buf1} = case Bytes6 of
<<0:1,V6@V3:6,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
{V6@Add5,V6@Buf4};
<<1:1,V6@Buf2/bitstring>> ->
V6@Pad6 = bit_size(V6@Buf2) band 7,
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:V6@Pad6,0:1,V6@V8:7,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
{V6@V8,V6@Buf9};
<<_:V6@Pad6,1:1,0:1,V6@V9:14,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
{V6@V9,V6@Buf10};
<<_:V6@Pad6,1:1,1:1,V6@V9:6,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
V6@Mul11 = V6@V9 * 16384,
{V6@Mul11,V6@Buf10}
end,
{V6@V3,V6@Buf4}
end,
<<V6@V12:V6@V0/bitstring-unit:1,V6@Buf13/bitstring>> = V6@Buf1,
{V6@V12,V6@Buf13}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
Res1 = {'E-RABToBeSwitchedULItem',Term1,Term2,Term3,Term4},
{Res1,Bytes8}.


'dec_E-RABToBeSwitchedULItem_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components57(V1@Add4, V1@Buf1, []).


'dec_E-RABToBeSwitchedULItem_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension12(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABToBeUpdatedList'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABToBeUpdatedList_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABToBeUpdatedList_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value58(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABToBeUpdatedList'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components59(V1@Add4, V1@Buf1, []).


'dec_E-RABToBeUpdatedList_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value60(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABToBeUpdatedItem'(Val) ->
[begin
Enc1@element = element(3, Val),
Enc2@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc4@element = element(2, Val),
if Enc4@element bsr 4 =:= 0 ->
<<0:1,Enc4@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc4@element)]
end
end,
begin
%% attribute securityIndication(2) with type SecurityIndication
Enc6@element = element(3, Val),
if Enc6@element =:= asn1_NOVALUE ->
[];
true ->
'S1AP-IEs':enc_SecurityIndication(Enc6@element)
end
end|begin
%% attribute iE-Extensions(3) with type SEQUENCE OF
Enc8@element = element(4, Val),
if Enc8@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABToBeUpdatedItem_iE-Extensions'(Enc8@element)
end
end].
'enc_E-RABToBeUpdatedItem_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABToBeUpdatedItem_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABToBeUpdatedItem_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension10(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABToBeUpdatedItem'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:2,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute securityIndication(2) with type SecurityIndication
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
'S1AP-IEs':dec_SecurityIndication(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute iE-Extensions(3) with type SEQUENCE OF
{Term3,Bytes5} = case Opt band 1 of
1 ->
'dec_E-RABToBeUpdatedItem_iE-Extensions'(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V4@V0,V4@Buf1} = case Bytes5 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
V4@Mul11 = V4@V9 * 16384,
{V4@Mul11,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V12:V4@V0/bitstring-unit:1,V4@Buf13/bitstring>> = V4@Buf1,
{V4@V12,V4@Buf13}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'E-RABToBeUpdatedItem',Term1,Term2,Term3},
{Res1,Bytes7}.


'dec_E-RABToBeUpdatedItem_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components61(V1@Add4, V1@Buf1, []).


'dec_E-RABToBeUpdatedItem_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension12(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_PathSwitchRequestFailure(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_PathSwitchRequestFailure_protocolIEs(Enc2@element)
end].
enc_PathSwitchRequestFailure_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_PathSwitchRequestFailure_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_PathSwitchRequestFailure_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value62(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_PathSwitchRequestFailure(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_PathSwitchRequestFailure_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'PathSwitchRequestFailure',Term1},
{Res1,Bytes4}.


dec_PathSwitchRequestFailure_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components63(V1@V0, V1@Buf1, []).


'dec_PathSwitchRequestFailure_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value64(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_HandoverCancel(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_HandoverCancel_protocolIEs(Enc2@element)
end].
enc_HandoverCancel_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_HandoverCancel_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_HandoverCancel_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value65(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_HandoverCancel(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_HandoverCancel_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'HandoverCancel',Term1},
{Res1,Bytes4}.


dec_HandoverCancel_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components66(V1@V0, V1@Buf1, []).


'dec_HandoverCancel_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value67(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_HandoverCancelAcknowledge(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_HandoverCancelAcknowledge_protocolIEs(Enc2@element)
end].
enc_HandoverCancelAcknowledge_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_HandoverCancelAcknowledge_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_HandoverCancelAcknowledge_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value68(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_HandoverCancelAcknowledge(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_HandoverCancelAcknowledge_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'HandoverCancelAcknowledge',Term1},
{Res1,Bytes4}.


dec_HandoverCancelAcknowledge_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components69(V1@V0, V1@Buf1, []).


'dec_HandoverCancelAcknowledge_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value70(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_HandoverSuccess(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_HandoverSuccess_protocolIEs(Enc2@element)
end].
enc_HandoverSuccess_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_HandoverSuccess_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_HandoverSuccess_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value71(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_HandoverSuccess(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_HandoverSuccess_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'HandoverSuccess',Term1},
{Res1,Bytes4}.


dec_HandoverSuccess_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components72(V1@V0, V1@Buf1, []).


'dec_HandoverSuccess_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value73(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_ENBEarlyStatusTransfer(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_ENBEarlyStatusTransfer_protocolIEs(Enc2@element)
end].
enc_ENBEarlyStatusTransfer_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_ENBEarlyStatusTransfer_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_ENBEarlyStatusTransfer_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value74(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_ENBEarlyStatusTransfer(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_ENBEarlyStatusTransfer_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'ENBEarlyStatusTransfer',Term1},
{Res1,Bytes4}.


dec_ENBEarlyStatusTransfer_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components75(V1@V0, V1@Buf1, []).


'dec_ENBEarlyStatusTransfer_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value76(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_MMEEarlyStatusTransfer(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_MMEEarlyStatusTransfer_protocolIEs(Enc2@element)
end].
enc_MMEEarlyStatusTransfer_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_MMEEarlyStatusTransfer_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_MMEEarlyStatusTransfer_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value77(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_MMEEarlyStatusTransfer(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_MMEEarlyStatusTransfer_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'MMEEarlyStatusTransfer',Term1},
{Res1,Bytes4}.


dec_MMEEarlyStatusTransfer_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components78(V1@V0, V1@Buf1, []).


'dec_MMEEarlyStatusTransfer_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value79(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABSetupRequest'(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
'enc_E-RABSetupRequest_protocolIEs'(Enc2@element)
end].
'enc_E-RABSetupRequest_protocolIEs'(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_E-RABSetupRequest_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABSetupRequest_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value80(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABSetupRequest'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = 'dec_E-RABSetupRequest_protocolIEs'(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'E-RABSetupRequest',Term1},
{Res1,Bytes4}.


'dec_E-RABSetupRequest_protocolIEs'(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components81(V1@V0, V1@Buf1, []).


'dec_E-RABSetupRequest_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value82(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABToBeSetupListBearerSUReq'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABToBeSetupListBearerSUReq_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABToBeSetupListBearerSUReq_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value83(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABToBeSetupListBearerSUReq'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components84(V1@Add4, V1@Buf1, []).


'dec_E-RABToBeSetupListBearerSUReq_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value85(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABToBeSetupItemBearerSUReq'(Val) ->
[begin
Enc1@element = element(7, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 4 =:= 0 ->
<<0:1,Enc3@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc3@element)]
end
end,
begin
%% attribute e-RABlevelQoSParameters(2) with type E-RABLevelQoSParameters
Enc5@element = element(3, Val),
'S1AP-IEs':'enc_E-RABLevelQoSParameters'(Enc5@element)
end,
begin
%% attribute transportLayerAddress(3) with type BIT STRING
Enc6@element = element(4, Val),
Enc7@bits = bit_size(Enc6@element),
Enc7@bits@sub = Enc7@bits - 1,
if 0 =< Enc7@bits@sub, Enc7@bits@sub < 160 ->
[<<0:1,Enc7@bits@sub:8>>,
align|Enc6@element];
Enc7@bits < 16384 ->
[<<1:1>>,
align,
<<2:2,Enc7@bits:14>>|Enc6@element];
true ->
[<<1:1>>,
align|encode_fragmented(Enc6@element, 1)]
end
end,
align,
begin
%% attribute gTP-TEID(4) with type OCTET STRING
Enc8@element = element(5, Val),
Enc9@len = byte_size(Enc8@element),
if Enc9@len =:= 4 ->
Enc8@element
end
end,
begin
%% attribute nAS-PDU(5) with type OCTET STRING
Enc10@element = element(6, Val),
Enc11@len = byte_size(Enc10@element),
if Enc11@len < 128 ->
[Enc11@len|Enc10@element];
Enc11@len < 16384 ->
[<<2:2,Enc11@len:14>>|Enc10@element];
true ->
encode_fragmented(Enc10@element, 8)
end
end|begin
%% attribute iE-Extensions(6) with type SEQUENCE OF
Enc12@element = element(7, Val),
if Enc12@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABToBeSetupItemBearerSUReq_iE-Extensions'(Enc12@element)
end
end].
'enc_E-RABToBeSetupItemBearerSUReq_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABToBeSetupItemBearerSUReq_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABToBeSetupItemBearerSUReq_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension86(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABToBeSetupItemBearerSUReq'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute e-RABlevelQoSParameters(2) with type E-RABLevelQoSParameters
{Term2,Bytes4} = 'S1AP-IEs':'dec_E-RABLevelQoSParameters'(Bytes3),

%% attribute transportLayerAddress(3) with type BIT STRING
{Term3,Bytes5} = begin
{V4@V0,V4@Buf1} = case Bytes4 of
<<0:1,V4@V3:8/unsigned-unit:1,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
V4@Pad8 = bit_size(V4@Buf4) band 7,
<<_:V4@Pad8,V4@V6:V4@Add5/binary-unit:1,V4@Buf7/bitstring>> = V4@Buf4,
{V4@V6,V4@Buf7};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@V10:V4@V8/binary-unit:1,V4@Buf11/bitstring>> ->
{V4@V10,V4@Buf11};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@V11:V4@V9/binary-unit:1,V4@Buf12/bitstring>> ->
{V4@V11,V4@Buf12};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> ->
{V4@V11,V4@Buf12}  = decode_fragmented(V4@V9, V4@Buf10, 1),
{V4@V11,V4@Buf12}
end,
{V4@V3,V4@Buf4}
end,
{V4@V13,V4@Buf14}  = {list_to_bitstring([V4@V0]),V4@Buf1},
{V4@V13,V4@Buf14}
end,

%% attribute gTP-TEID(4) with type OCTET STRING
{Term4,Bytes6} = begin
V5@Pad2 = bit_size(Bytes5) band 7,
<<_:V5@Pad2,V5@V0:4/binary-unit:8,V5@Buf1/bitstring>> = Bytes5,
V5@Conv4 = binary:copy(V5@V0),
{V5@Conv4,V5@Buf1}
end,

%% attribute nAS-PDU(5) with type OCTET STRING
{Term5,Bytes7} = begin
{V6@V0,V6@Buf1} = case Bytes6 of
<<0:1,V6@V3:7,V6@V5:V6@V3/binary-unit:8,V6@Buf6/bitstring>> ->
{V6@V5,V6@Buf6};
<<1:1,0:1,V6@V4:14,V6@V6:V6@V4/binary-unit:8,V6@Buf7/bitstring>> ->
{V6@V6,V6@Buf7};
<<1:1,1:1,V6@V4:6,V6@Buf5/bitstring>> ->
{V6@V6,V6@Buf7}  = decode_fragmented(V6@V4, V6@Buf5, 8),
{V6@V6,V6@Buf7}
end,
V6@Conv8 = binary:copy(V6@V0),
{V6@Conv8,V6@Buf1}
end,

%% attribute iE-Extensions(6) with type SEQUENCE OF
{Term6,Bytes8} = case Opt band 1 of
1 ->
'dec_E-RABToBeSetupItemBearerSUReq_iE-Extensions'(Bytes7);
0 ->
{asn1_NOVALUE,Bytes7}
end,

%% Extensions
{Extensions,Bytes9} = case Ext of
0 -> {<<>>,Bytes8};
1 ->
{V7@V0,V7@Buf1} = case Bytes8 of
<<0:1,V7@V3:6,V7@Buf4/bitstring>> ->
V7@Add5 = V7@V3 + 1,
{V7@Add5,V7@Buf4};
<<1:1,V7@Buf2/bitstring>> ->
V7@Pad6 = bit_size(V7@Buf2) band 7,
{V7@V3,V7@Buf4} = case V7@Buf2 of
<<_:V7@Pad6,0:1,V7@V8:7,V7@Buf9/bitstring>> when V7@V8 =/= 0 ->
{V7@V8,V7@Buf9};
<<_:V7@Pad6,1:1,0:1,V7@V9:14,V7@Buf10/bitstring>> when V7@V9 =/= 0 ->
{V7@V9,V7@Buf10};
<<_:V7@Pad6,1:1,1:1,V7@V9:6,V7@Buf10/bitstring>> when V7@V9 =/= 0 ->
V7@Mul11 = V7@V9 * 16384,
{V7@Mul11,V7@Buf10}
end,
{V7@V3,V7@Buf4}
end,
<<V7@V12:V7@V0/bitstring-unit:1,V7@Buf13/bitstring>> = V7@Buf1,
{V7@V12,V7@Buf13}
end,
Bytes10= skipextensions(Bytes9, 1, Extensions),
Res1 = {'E-RABToBeSetupItemBearerSUReq',Term1,Term2,Term3,Term4,Term5,Term6},
{Res1,Bytes10}.


'dec_E-RABToBeSetupItemBearerSUReq_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components87(V1@Add4, V1@Buf1, []).


'dec_E-RABToBeSetupItemBearerSUReq_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension88(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABSetupResponse'(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
'enc_E-RABSetupResponse_protocolIEs'(Enc2@element)
end].
'enc_E-RABSetupResponse_protocolIEs'(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_E-RABSetupResponse_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABSetupResponse_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value89(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABSetupResponse'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = 'dec_E-RABSetupResponse_protocolIEs'(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'E-RABSetupResponse',Term1},
{Res1,Bytes4}.


'dec_E-RABSetupResponse_protocolIEs'(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components90(V1@V0, V1@Buf1, []).


'dec_E-RABSetupResponse_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value91(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABSetupListBearerSURes'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABSetupListBearerSURes_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABSetupListBearerSURes_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value92(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABSetupListBearerSURes'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components93(V1@Add4, V1@Buf1, []).


'dec_E-RABSetupListBearerSURes_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value94(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABSetupItemBearerSURes'(Val) ->
[begin
Enc1@element = element(5, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 4 =:= 0 ->
<<0:1,Enc3@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc3@element)]
end
end,
begin
%% attribute transportLayerAddress(2) with type BIT STRING
Enc5@element = element(3, Val),
Enc6@bits = bit_size(Enc5@element),
Enc6@bits@sub = Enc6@bits - 1,
if 0 =< Enc6@bits@sub, Enc6@bits@sub < 160 ->
[<<0:1,Enc6@bits@sub:8>>,
align|Enc5@element];
Enc6@bits < 16384 ->
[<<1:1>>,
align,
<<2:2,Enc6@bits:14>>|Enc5@element];
true ->
[<<1:1>>,
align|encode_fragmented(Enc5@element, 1)]
end
end,
align,
begin
%% attribute gTP-TEID(3) with type OCTET STRING
Enc7@element = element(4, Val),
Enc8@len = byte_size(Enc7@element),
if Enc8@len =:= 4 ->
Enc7@element
end
end|begin
%% attribute iE-Extensions(4) with type SEQUENCE OF
Enc9@element = element(5, Val),
if Enc9@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABSetupItemBearerSURes_iE-Extensions'(Enc9@element)
end
end].
'enc_E-RABSetupItemBearerSURes_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABSetupItemBearerSURes_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABSetupItemBearerSURes_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension10(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABSetupItemBearerSURes'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute transportLayerAddress(2) with type BIT STRING
{Term2,Bytes4} = begin
{V4@V0,V4@Buf1} = case Bytes3 of
<<0:1,V4@V3:8/unsigned-unit:1,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
V4@Pad8 = bit_size(V4@Buf4) band 7,
<<_:V4@Pad8,V4@V6:V4@Add5/binary-unit:1,V4@Buf7/bitstring>> = V4@Buf4,
{V4@V6,V4@Buf7};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@V10:V4@V8/binary-unit:1,V4@Buf11/bitstring>> ->
{V4@V10,V4@Buf11};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@V11:V4@V9/binary-unit:1,V4@Buf12/bitstring>> ->
{V4@V11,V4@Buf12};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> ->
{V4@V11,V4@Buf12}  = decode_fragmented(V4@V9, V4@Buf10, 1),
{V4@V11,V4@Buf12}
end,
{V4@V3,V4@Buf4}
end,
{V4@V13,V4@Buf14}  = {list_to_bitstring([V4@V0]),V4@Buf1},
{V4@V13,V4@Buf14}
end,

%% attribute gTP-TEID(3) with type OCTET STRING
{Term3,Bytes5} = begin
V5@Pad2 = bit_size(Bytes4) band 7,
<<_:V5@Pad2,V5@V0:4/binary-unit:8,V5@Buf1/bitstring>> = Bytes4,
V5@Conv4 = binary:copy(V5@V0),
{V5@Conv4,V5@Buf1}
end,

%% attribute iE-Extensions(4) with type SEQUENCE OF
{Term4,Bytes6} = case Opt band 1 of
1 ->
'dec_E-RABSetupItemBearerSURes_iE-Extensions'(Bytes5);
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V6@V0,V6@Buf1} = case Bytes6 of
<<0:1,V6@V3:6,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
{V6@Add5,V6@Buf4};
<<1:1,V6@Buf2/bitstring>> ->
V6@Pad6 = bit_size(V6@Buf2) band 7,
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:V6@Pad6,0:1,V6@V8:7,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
{V6@V8,V6@Buf9};
<<_:V6@Pad6,1:1,0:1,V6@V9:14,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
{V6@V9,V6@Buf10};
<<_:V6@Pad6,1:1,1:1,V6@V9:6,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
V6@Mul11 = V6@V9 * 16384,
{V6@Mul11,V6@Buf10}
end,
{V6@V3,V6@Buf4}
end,
<<V6@V12:V6@V0/bitstring-unit:1,V6@Buf13/bitstring>> = V6@Buf1,
{V6@V12,V6@Buf13}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
Res1 = {'E-RABSetupItemBearerSURes',Term1,Term2,Term3,Term4},
{Res1,Bytes8}.


'dec_E-RABSetupItemBearerSURes_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components95(V1@Add4, V1@Buf1, []).


'dec_E-RABSetupItemBearerSURes_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension12(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABModifyRequest'(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
'enc_E-RABModifyRequest_protocolIEs'(Enc2@element)
end].
'enc_E-RABModifyRequest_protocolIEs'(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_E-RABModifyRequest_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABModifyRequest_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value96(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABModifyRequest'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = 'dec_E-RABModifyRequest_protocolIEs'(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'E-RABModifyRequest',Term1},
{Res1,Bytes4}.


'dec_E-RABModifyRequest_protocolIEs'(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components97(V1@V0, V1@Buf1, []).


'dec_E-RABModifyRequest_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value98(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABToBeModifiedListBearerModReq'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABToBeModifiedListBearerModReq_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABToBeModifiedListBearerModReq_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value99(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABToBeModifiedListBearerModReq'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components100(V1@Add4, V1@Buf1, []).


'dec_E-RABToBeModifiedListBearerModReq_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value101(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABToBeModifiedItemBearerModReq'(Val) ->
[begin
Enc1@element = element(5, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 4 =:= 0 ->
<<0:1,Enc3@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc3@element)]
end
end,
begin
%% attribute e-RABLevelQoSParameters(2) with type E-RABLevelQoSParameters
Enc5@element = element(3, Val),
'S1AP-IEs':'enc_E-RABLevelQoSParameters'(Enc5@element)
end,
align,
begin
%% attribute nAS-PDU(3) with type OCTET STRING
Enc6@element = element(4, Val),
Enc7@len = byte_size(Enc6@element),
if Enc7@len < 128 ->
[Enc7@len|Enc6@element];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc6@element];
true ->
encode_fragmented(Enc6@element, 8)
end
end|begin
%% attribute iE-Extensions(4) with type SEQUENCE OF
Enc8@element = element(5, Val),
if Enc8@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABToBeModifiedItemBearerModReq_iE-Extensions'(Enc8@element)
end
end].
'enc_E-RABToBeModifiedItemBearerModReq_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABToBeModifiedItemBearerModReq_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABToBeModifiedItemBearerModReq_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension102(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABToBeModifiedItemBearerModReq'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute e-RABLevelQoSParameters(2) with type E-RABLevelQoSParameters
{Term2,Bytes4} = 'S1AP-IEs':'dec_E-RABLevelQoSParameters'(Bytes3),

%% attribute nAS-PDU(3) with type OCTET STRING
{Term3,Bytes5} = begin
V4@Pad3 = bit_size(Bytes4) band 7,
{V4@V0,V4@Buf1} = case Bytes4 of
<<_:V4@Pad3,0:1,V4@V5:7,V4@V7:V4@V5/binary-unit:8,V4@Buf8/bitstring>> ->
{V4@V7,V4@Buf8};
<<_:V4@Pad3,1:1,0:1,V4@V6:14,V4@V8:V4@V6/binary-unit:8,V4@Buf9/bitstring>> ->
{V4@V8,V4@Buf9};
<<_:V4@Pad3,1:1,1:1,V4@V6:6,V4@Buf7/bitstring>> ->
{V4@V8,V4@Buf9}  = decode_fragmented(V4@V6, V4@Buf7, 8),
{V4@V8,V4@Buf9}
end,
V4@Conv10 = binary:copy(V4@V0),
{V4@Conv10,V4@Buf1}
end,

%% attribute iE-Extensions(4) with type SEQUENCE OF
{Term4,Bytes6} = case Opt band 1 of
1 ->
'dec_E-RABToBeModifiedItemBearerModReq_iE-Extensions'(Bytes5);
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V5@V0,V5@Buf1} = case Bytes6 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10};
<<_:V5@Pad6,1:1,1:1,V5@V9:6,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
V5@Mul11 = V5@V9 * 16384,
{V5@Mul11,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V12:V5@V0/bitstring-unit:1,V5@Buf13/bitstring>> = V5@Buf1,
{V5@V12,V5@Buf13}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
Res1 = {'E-RABToBeModifiedItemBearerModReq',Term1,Term2,Term3,Term4},
{Res1,Bytes8}.


'dec_E-RABToBeModifiedItemBearerModReq_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components103(V1@Add4, V1@Buf1, []).


'dec_E-RABToBeModifiedItemBearerModReq_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension104(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABModifyResponse'(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
'enc_E-RABModifyResponse_protocolIEs'(Enc2@element)
end].
'enc_E-RABModifyResponse_protocolIEs'(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_E-RABModifyResponse_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABModifyResponse_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value105(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABModifyResponse'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = 'dec_E-RABModifyResponse_protocolIEs'(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'E-RABModifyResponse',Term1},
{Res1,Bytes4}.


'dec_E-RABModifyResponse_protocolIEs'(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components106(V1@V0, V1@Buf1, []).


'dec_E-RABModifyResponse_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value107(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABModifyListBearerModRes'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABModifyListBearerModRes_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABModifyListBearerModRes_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value108(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABModifyListBearerModRes'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components109(V1@Add4, V1@Buf1, []).


'dec_E-RABModifyListBearerModRes_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value110(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABModifyItemBearerModRes'(Val) ->
[begin
Enc1@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 4 =:= 0 ->
<<0:1,Enc3@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc3@element)]
end
end|begin
%% attribute iE-Extensions(2) with type SEQUENCE OF
Enc5@element = element(3, Val),
if Enc5@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABModifyItemBearerModRes_iE-Extensions'(Enc5@element)
end
end].
'enc_E-RABModifyItemBearerModRes_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABModifyItemBearerModRes_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABModifyItemBearerModRes_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension10(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABModifyItemBearerModRes'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute iE-Extensions(2) with type SEQUENCE OF
{Term2,Bytes4} = case Opt band 1 of
1 ->
'dec_E-RABModifyItemBearerModRes_iE-Extensions'(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V4@V0,V4@Buf1} = case Bytes4 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
V4@Mul11 = V4@V9 * 16384,
{V4@Mul11,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V12:V4@V0/bitstring-unit:1,V4@Buf13/bitstring>> = V4@Buf1,
{V4@V12,V4@Buf13}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
Res1 = {'E-RABModifyItemBearerModRes',Term1,Term2},
{Res1,Bytes6}.


'dec_E-RABModifyItemBearerModRes_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components111(V1@Add4, V1@Buf1, []).


'dec_E-RABModifyItemBearerModRes_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension12(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABReleaseCommand'(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
'enc_E-RABReleaseCommand_protocolIEs'(Enc2@element)
end].
'enc_E-RABReleaseCommand_protocolIEs'(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_E-RABReleaseCommand_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABReleaseCommand_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value112(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABReleaseCommand'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = 'dec_E-RABReleaseCommand_protocolIEs'(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'E-RABReleaseCommand',Term1},
{Res1,Bytes4}.


'dec_E-RABReleaseCommand_protocolIEs'(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components113(V1@V0, V1@Buf1, []).


'dec_E-RABReleaseCommand_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value114(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABReleaseResponse'(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
'enc_E-RABReleaseResponse_protocolIEs'(Enc2@element)
end].
'enc_E-RABReleaseResponse_protocolIEs'(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_E-RABReleaseResponse_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABReleaseResponse_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value115(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABReleaseResponse'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = 'dec_E-RABReleaseResponse_protocolIEs'(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'E-RABReleaseResponse',Term1},
{Res1,Bytes4}.


'dec_E-RABReleaseResponse_protocolIEs'(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components116(V1@V0, V1@Buf1, []).


'dec_E-RABReleaseResponse_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value117(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABReleaseListBearerRelComp'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABReleaseListBearerRelComp_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABReleaseListBearerRelComp_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value118(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABReleaseListBearerRelComp'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components119(V1@Add4, V1@Buf1, []).


'dec_E-RABReleaseListBearerRelComp_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value120(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABReleaseItemBearerRelComp'(Val) ->
[begin
Enc1@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 4 =:= 0 ->
<<0:1,Enc3@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc3@element)]
end
end|begin
%% attribute iE-Extensions(2) with type SEQUENCE OF
Enc5@element = element(3, Val),
if Enc5@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABReleaseItemBearerRelComp_iE-Extensions'(Enc5@element)
end
end].
'enc_E-RABReleaseItemBearerRelComp_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABReleaseItemBearerRelComp_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABReleaseItemBearerRelComp_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension10(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABReleaseItemBearerRelComp'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute iE-Extensions(2) with type SEQUENCE OF
{Term2,Bytes4} = case Opt band 1 of
1 ->
'dec_E-RABReleaseItemBearerRelComp_iE-Extensions'(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V4@V0,V4@Buf1} = case Bytes4 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
V4@Mul11 = V4@V9 * 16384,
{V4@Mul11,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V12:V4@V0/bitstring-unit:1,V4@Buf13/bitstring>> = V4@Buf1,
{V4@V12,V4@Buf13}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
Res1 = {'E-RABReleaseItemBearerRelComp',Term1,Term2},
{Res1,Bytes6}.


'dec_E-RABReleaseItemBearerRelComp_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components121(V1@Add4, V1@Buf1, []).


'dec_E-RABReleaseItemBearerRelComp_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension12(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABReleaseIndication'(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
'enc_E-RABReleaseIndication_protocolIEs'(Enc2@element)
end].
'enc_E-RABReleaseIndication_protocolIEs'(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_E-RABReleaseIndication_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABReleaseIndication_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value122(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABReleaseIndication'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = 'dec_E-RABReleaseIndication_protocolIEs'(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'E-RABReleaseIndication',Term1},
{Res1,Bytes4}.


'dec_E-RABReleaseIndication_protocolIEs'(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components123(V1@V0, V1@Buf1, []).


'dec_E-RABReleaseIndication_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value124(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_InitialContextSetupRequest(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_InitialContextSetupRequest_protocolIEs(Enc2@element)
end].
enc_InitialContextSetupRequest_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_InitialContextSetupRequest_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_InitialContextSetupRequest_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value125(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_InitialContextSetupRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_InitialContextSetupRequest_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'InitialContextSetupRequest',Term1},
{Res1,Bytes4}.


dec_InitialContextSetupRequest_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components126(V1@V0, V1@Buf1, []).


'dec_InitialContextSetupRequest_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value127(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABToBeSetupListCtxtSUReq'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABToBeSetupListCtxtSUReq_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABToBeSetupListCtxtSUReq_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value128(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABToBeSetupListCtxtSUReq'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components129(V1@Add4, V1@Buf1, []).


'dec_E-RABToBeSetupListCtxtSUReq_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value130(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABToBeSetupItemCtxtSUReq'(Val) ->
[begin
Enc1@element = element(6, Val),
Enc2@element = element(7, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc4@element = element(2, Val),
if Enc4@element bsr 4 =:= 0 ->
<<0:1,Enc4@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc4@element)]
end
end,
begin
%% attribute e-RABlevelQoSParameters(2) with type E-RABLevelQoSParameters
Enc6@element = element(3, Val),
'S1AP-IEs':'enc_E-RABLevelQoSParameters'(Enc6@element)
end,
begin
%% attribute transportLayerAddress(3) with type BIT STRING
Enc7@element = element(4, Val),
Enc8@bits = bit_size(Enc7@element),
Enc8@bits@sub = Enc8@bits - 1,
if 0 =< Enc8@bits@sub, Enc8@bits@sub < 160 ->
[<<0:1,Enc8@bits@sub:8>>,
align|Enc7@element];
Enc8@bits < 16384 ->
[<<1:1>>,
align,
<<2:2,Enc8@bits:14>>|Enc7@element];
true ->
[<<1:1>>,
align|encode_fragmented(Enc7@element, 1)]
end
end,
align,
begin
%% attribute gTP-TEID(4) with type OCTET STRING
Enc9@element = element(5, Val),
Enc10@len = byte_size(Enc9@element),
if Enc10@len =:= 4 ->
Enc9@element
end
end,
begin
%% attribute nAS-PDU(5) with type OCTET STRING
Enc11@element = element(6, Val),
if Enc11@element =:= asn1_NOVALUE ->
[];
true ->
begin
Enc12@len = byte_size(Enc11@element),
if Enc12@len < 128 ->
[Enc12@len|Enc11@element];
Enc12@len < 16384 ->
[<<2:2,Enc12@len:14>>|Enc11@element];
true ->
encode_fragmented(Enc11@element, 8)
end
end
end
end|begin
%% attribute iE-Extensions(6) with type SEQUENCE OF
Enc14@element = element(7, Val),
if Enc14@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABToBeSetupItemCtxtSUReq_iE-Extensions'(Enc14@element)
end
end].
'enc_E-RABToBeSetupItemCtxtSUReq_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABToBeSetupItemCtxtSUReq_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABToBeSetupItemCtxtSUReq_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension131(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABToBeSetupItemCtxtSUReq'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:2,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute e-RABlevelQoSParameters(2) with type E-RABLevelQoSParameters
{Term2,Bytes4} = 'S1AP-IEs':'dec_E-RABLevelQoSParameters'(Bytes3),

%% attribute transportLayerAddress(3) with type BIT STRING
{Term3,Bytes5} = begin
{V4@V0,V4@Buf1} = case Bytes4 of
<<0:1,V4@V3:8/unsigned-unit:1,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
V4@Pad8 = bit_size(V4@Buf4) band 7,
<<_:V4@Pad8,V4@V6:V4@Add5/binary-unit:1,V4@Buf7/bitstring>> = V4@Buf4,
{V4@V6,V4@Buf7};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@V10:V4@V8/binary-unit:1,V4@Buf11/bitstring>> ->
{V4@V10,V4@Buf11};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@V11:V4@V9/binary-unit:1,V4@Buf12/bitstring>> ->
{V4@V11,V4@Buf12};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> ->
{V4@V11,V4@Buf12}  = decode_fragmented(V4@V9, V4@Buf10, 1),
{V4@V11,V4@Buf12}
end,
{V4@V3,V4@Buf4}
end,
{V4@V13,V4@Buf14}  = {list_to_bitstring([V4@V0]),V4@Buf1},
{V4@V13,V4@Buf14}
end,

%% attribute gTP-TEID(4) with type OCTET STRING
{Term4,Bytes6} = begin
V5@Pad2 = bit_size(Bytes5) band 7,
<<_:V5@Pad2,V5@V0:4/binary-unit:8,V5@Buf1/bitstring>> = Bytes5,
V5@Conv4 = binary:copy(V5@V0),
{V5@Conv4,V5@Buf1}
end,

%% attribute nAS-PDU(5) with type OCTET STRING
{Term5,Bytes7} = case (Opt bsr 1) band 1 of
1 ->
begin
V6@Pad3 = bit_size(Bytes6) band 7,
{V6@V0,V6@Buf1} = case Bytes6 of
<<_:V6@Pad3,0:1,V6@V5:7,V6@V7:V6@V5/binary-unit:8,V6@Buf8/bitstring>> ->
{V6@V7,V6@Buf8};
<<_:V6@Pad3,1:1,0:1,V6@V6:14,V6@V8:V6@V6/binary-unit:8,V6@Buf9/bitstring>> ->
{V6@V8,V6@Buf9};
<<_:V6@Pad3,1:1,1:1,V6@V6:6,V6@Buf7/bitstring>> ->
{V6@V8,V6@Buf9}  = decode_fragmented(V6@V6, V6@Buf7, 8),
{V6@V8,V6@Buf9}
end,
V6@Conv10 = binary:copy(V6@V0),
{V6@Conv10,V6@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes6}
end,

%% attribute iE-Extensions(6) with type SEQUENCE OF
{Term6,Bytes8} = case Opt band 1 of
1 ->
'dec_E-RABToBeSetupItemCtxtSUReq_iE-Extensions'(Bytes7);
0 ->
{asn1_NOVALUE,Bytes7}
end,

%% Extensions
{Extensions,Bytes9} = case Ext of
0 -> {<<>>,Bytes8};
1 ->
{V7@V0,V7@Buf1} = case Bytes8 of
<<0:1,V7@V3:6,V7@Buf4/bitstring>> ->
V7@Add5 = V7@V3 + 1,
{V7@Add5,V7@Buf4};
<<1:1,V7@Buf2/bitstring>> ->
V7@Pad6 = bit_size(V7@Buf2) band 7,
{V7@V3,V7@Buf4} = case V7@Buf2 of
<<_:V7@Pad6,0:1,V7@V8:7,V7@Buf9/bitstring>> when V7@V8 =/= 0 ->
{V7@V8,V7@Buf9};
<<_:V7@Pad6,1:1,0:1,V7@V9:14,V7@Buf10/bitstring>> when V7@V9 =/= 0 ->
{V7@V9,V7@Buf10};
<<_:V7@Pad6,1:1,1:1,V7@V9:6,V7@Buf10/bitstring>> when V7@V9 =/= 0 ->
V7@Mul11 = V7@V9 * 16384,
{V7@Mul11,V7@Buf10}
end,
{V7@V3,V7@Buf4}
end,
<<V7@V12:V7@V0/bitstring-unit:1,V7@Buf13/bitstring>> = V7@Buf1,
{V7@V12,V7@Buf13}
end,
Bytes10= skipextensions(Bytes9, 1, Extensions),
Res1 = {'E-RABToBeSetupItemCtxtSUReq',Term1,Term2,Term3,Term4,Term5,Term6},
{Res1,Bytes10}.


'dec_E-RABToBeSetupItemCtxtSUReq_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components132(V1@Add4, V1@Buf1, []).


'dec_E-RABToBeSetupItemCtxtSUReq_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension133(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_InitialContextSetupResponse(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_InitialContextSetupResponse_protocolIEs(Enc2@element)
end].
enc_InitialContextSetupResponse_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_InitialContextSetupResponse_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_InitialContextSetupResponse_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value134(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_InitialContextSetupResponse(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_InitialContextSetupResponse_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'InitialContextSetupResponse',Term1},
{Res1,Bytes4}.


dec_InitialContextSetupResponse_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components135(V1@V0, V1@Buf1, []).


'dec_InitialContextSetupResponse_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value136(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABSetupListCtxtSURes'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABSetupListCtxtSURes_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABSetupListCtxtSURes_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value137(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABSetupListCtxtSURes'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components138(V1@Add4, V1@Buf1, []).


'dec_E-RABSetupListCtxtSURes_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value139(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABSetupItemCtxtSURes'(Val) ->
[begin
Enc1@element = element(5, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 4 =:= 0 ->
<<0:1,Enc3@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc3@element)]
end
end,
begin
%% attribute transportLayerAddress(2) with type BIT STRING
Enc5@element = element(3, Val),
Enc6@bits = bit_size(Enc5@element),
Enc6@bits@sub = Enc6@bits - 1,
if 0 =< Enc6@bits@sub, Enc6@bits@sub < 160 ->
[<<0:1,Enc6@bits@sub:8>>,
align|Enc5@element];
Enc6@bits < 16384 ->
[<<1:1>>,
align,
<<2:2,Enc6@bits:14>>|Enc5@element];
true ->
[<<1:1>>,
align|encode_fragmented(Enc5@element, 1)]
end
end,
align,
begin
%% attribute gTP-TEID(3) with type OCTET STRING
Enc7@element = element(4, Val),
Enc8@len = byte_size(Enc7@element),
if Enc8@len =:= 4 ->
Enc7@element
end
end|begin
%% attribute iE-Extensions(4) with type SEQUENCE OF
Enc9@element = element(5, Val),
if Enc9@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABSetupItemCtxtSURes_iE-Extensions'(Enc9@element)
end
end].
'enc_E-RABSetupItemCtxtSURes_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABSetupItemCtxtSURes_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABSetupItemCtxtSURes_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension10(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABSetupItemCtxtSURes'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute transportLayerAddress(2) with type BIT STRING
{Term2,Bytes4} = begin
{V4@V0,V4@Buf1} = case Bytes3 of
<<0:1,V4@V3:8/unsigned-unit:1,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
V4@Pad8 = bit_size(V4@Buf4) band 7,
<<_:V4@Pad8,V4@V6:V4@Add5/binary-unit:1,V4@Buf7/bitstring>> = V4@Buf4,
{V4@V6,V4@Buf7};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@V10:V4@V8/binary-unit:1,V4@Buf11/bitstring>> ->
{V4@V10,V4@Buf11};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@V11:V4@V9/binary-unit:1,V4@Buf12/bitstring>> ->
{V4@V11,V4@Buf12};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> ->
{V4@V11,V4@Buf12}  = decode_fragmented(V4@V9, V4@Buf10, 1),
{V4@V11,V4@Buf12}
end,
{V4@V3,V4@Buf4}
end,
{V4@V13,V4@Buf14}  = {list_to_bitstring([V4@V0]),V4@Buf1},
{V4@V13,V4@Buf14}
end,

%% attribute gTP-TEID(3) with type OCTET STRING
{Term3,Bytes5} = begin
V5@Pad2 = bit_size(Bytes4) band 7,
<<_:V5@Pad2,V5@V0:4/binary-unit:8,V5@Buf1/bitstring>> = Bytes4,
V5@Conv4 = binary:copy(V5@V0),
{V5@Conv4,V5@Buf1}
end,

%% attribute iE-Extensions(4) with type SEQUENCE OF
{Term4,Bytes6} = case Opt band 1 of
1 ->
'dec_E-RABSetupItemCtxtSURes_iE-Extensions'(Bytes5);
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V6@V0,V6@Buf1} = case Bytes6 of
<<0:1,V6@V3:6,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
{V6@Add5,V6@Buf4};
<<1:1,V6@Buf2/bitstring>> ->
V6@Pad6 = bit_size(V6@Buf2) band 7,
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:V6@Pad6,0:1,V6@V8:7,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
{V6@V8,V6@Buf9};
<<_:V6@Pad6,1:1,0:1,V6@V9:14,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
{V6@V9,V6@Buf10};
<<_:V6@Pad6,1:1,1:1,V6@V9:6,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
V6@Mul11 = V6@V9 * 16384,
{V6@Mul11,V6@Buf10}
end,
{V6@V3,V6@Buf4}
end,
<<V6@V12:V6@V0/bitstring-unit:1,V6@Buf13/bitstring>> = V6@Buf1,
{V6@V12,V6@Buf13}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
Res1 = {'E-RABSetupItemCtxtSURes',Term1,Term2,Term3,Term4},
{Res1,Bytes8}.


'dec_E-RABSetupItemCtxtSURes_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components140(V1@Add4, V1@Buf1, []).


'dec_E-RABSetupItemCtxtSURes_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension12(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_InitialContextSetupFailure(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_InitialContextSetupFailure_protocolIEs(Enc2@element)
end].
enc_InitialContextSetupFailure_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_InitialContextSetupFailure_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_InitialContextSetupFailure_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value141(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_InitialContextSetupFailure(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_InitialContextSetupFailure_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'InitialContextSetupFailure',Term1},
{Res1,Bytes4}.


dec_InitialContextSetupFailure_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components142(V1@V0, V1@Buf1, []).


'dec_InitialContextSetupFailure_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value143(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_Paging(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_Paging_protocolIEs(Enc2@element)
end].
enc_Paging_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_Paging_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_Paging_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value144(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_Paging(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_Paging_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'Paging',Term1},
{Res1,Bytes4}.


dec_Paging_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components145(V1@V0, V1@Buf1, []).


'dec_Paging_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value146(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_TAIList(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_TAIList_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_TAIList_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value147(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_TAIList(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components148(V1@Add4, V1@Buf1, []).


'dec_TAIList_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value149(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_TAIItem(Val) ->
[begin
Enc1@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute tAI(1) with type TAI
Enc3@element = element(2, Val),
'S1AP-IEs':enc_TAI(Enc3@element)
end|begin
%% attribute iE-Extensions(2) with type SEQUENCE OF
Enc4@element = element(3, Val),
if Enc4@element =:= asn1_NOVALUE ->
[];
true ->
'enc_TAIItem_iE-Extensions'(Enc4@element)
end
end].
'enc_TAIItem_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_TAIItem_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_TAIItem_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension10(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_TAIItem(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute tAI(1) with type TAI
{Term1,Bytes3} = 'S1AP-IEs':dec_TAI(Bytes2),

%% attribute iE-Extensions(2) with type SEQUENCE OF
{Term2,Bytes4} = case Opt band 1 of
1 ->
'dec_TAIItem_iE-Extensions'(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V3@V0,V3@Buf1} = case Bytes4 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V12:V3@V0/bitstring-unit:1,V3@Buf13/bitstring>> = V3@Buf1,
{V3@V12,V3@Buf13}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
Res1 = {'TAIItem',Term1,Term2},
{Res1,Bytes6}.


'dec_TAIItem_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components150(V1@Add4, V1@Buf1, []).


'dec_TAIItem_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension12(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UEContextReleaseRequest(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UEContextReleaseRequest_protocolIEs(Enc2@element)
end].
enc_UEContextReleaseRequest_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UEContextReleaseRequest_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UEContextReleaseRequest_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value151(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UEContextReleaseRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UEContextReleaseRequest_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UEContextReleaseRequest',Term1},
{Res1,Bytes4}.


dec_UEContextReleaseRequest_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components152(V1@V0, V1@Buf1, []).


'dec_UEContextReleaseRequest_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value153(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UEContextReleaseCommand(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UEContextReleaseCommand_protocolIEs(Enc2@element)
end].
enc_UEContextReleaseCommand_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UEContextReleaseCommand_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UEContextReleaseCommand_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value154(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UEContextReleaseCommand(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UEContextReleaseCommand_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UEContextReleaseCommand',Term1},
{Res1,Bytes4}.


dec_UEContextReleaseCommand_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components155(V1@V0, V1@Buf1, []).


'dec_UEContextReleaseCommand_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value156(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UEContextReleaseComplete(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UEContextReleaseComplete_protocolIEs(Enc2@element)
end].
enc_UEContextReleaseComplete_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UEContextReleaseComplete_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UEContextReleaseComplete_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value157(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UEContextReleaseComplete(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UEContextReleaseComplete_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UEContextReleaseComplete',Term1},
{Res1,Bytes4}.


dec_UEContextReleaseComplete_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components158(V1@V0, V1@Buf1, []).


'dec_UEContextReleaseComplete_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value159(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UEContextModificationRequest(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UEContextModificationRequest_protocolIEs(Enc2@element)
end].
enc_UEContextModificationRequest_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UEContextModificationRequest_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UEContextModificationRequest_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value160(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UEContextModificationRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UEContextModificationRequest_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UEContextModificationRequest',Term1},
{Res1,Bytes4}.


dec_UEContextModificationRequest_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components161(V1@V0, V1@Buf1, []).


'dec_UEContextModificationRequest_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value162(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UEContextModificationResponse(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UEContextModificationResponse_protocolIEs(Enc2@element)
end].
enc_UEContextModificationResponse_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UEContextModificationResponse_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UEContextModificationResponse_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value163(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UEContextModificationResponse(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UEContextModificationResponse_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UEContextModificationResponse',Term1},
{Res1,Bytes4}.


dec_UEContextModificationResponse_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components164(V1@V0, V1@Buf1, []).


'dec_UEContextModificationResponse_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value165(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UEContextModificationFailure(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UEContextModificationFailure_protocolIEs(Enc2@element)
end].
enc_UEContextModificationFailure_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UEContextModificationFailure_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UEContextModificationFailure_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value166(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UEContextModificationFailure(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UEContextModificationFailure_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UEContextModificationFailure',Term1},
{Res1,Bytes4}.


dec_UEContextModificationFailure_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components167(V1@V0, V1@Buf1, []).


'dec_UEContextModificationFailure_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value168(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UERadioCapabilityMatchRequest(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UERadioCapabilityMatchRequest_protocolIEs(Enc2@element)
end].
enc_UERadioCapabilityMatchRequest_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UERadioCapabilityMatchRequest_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UERadioCapabilityMatchRequest_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value169(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UERadioCapabilityMatchRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UERadioCapabilityMatchRequest_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UERadioCapabilityMatchRequest',Term1},
{Res1,Bytes4}.


dec_UERadioCapabilityMatchRequest_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components170(V1@V0, V1@Buf1, []).


'dec_UERadioCapabilityMatchRequest_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value171(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UERadioCapabilityMatchResponse(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UERadioCapabilityMatchResponse_protocolIEs(Enc2@element)
end].
enc_UERadioCapabilityMatchResponse_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UERadioCapabilityMatchResponse_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UERadioCapabilityMatchResponse_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value172(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UERadioCapabilityMatchResponse(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UERadioCapabilityMatchResponse_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UERadioCapabilityMatchResponse',Term1},
{Res1,Bytes4}.


dec_UERadioCapabilityMatchResponse_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components173(V1@V0, V1@Buf1, []).


'dec_UERadioCapabilityMatchResponse_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value174(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_DownlinkNASTransport(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_DownlinkNASTransport_protocolIEs(Enc2@element)
end].
enc_DownlinkNASTransport_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_DownlinkNASTransport_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_DownlinkNASTransport_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value175(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_DownlinkNASTransport(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_DownlinkNASTransport_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'DownlinkNASTransport',Term1},
{Res1,Bytes4}.


dec_DownlinkNASTransport_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components176(V1@V0, V1@Buf1, []).


'dec_DownlinkNASTransport_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value177(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_InitialUEMessage(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_InitialUEMessage_protocolIEs(Enc2@element)
end].
enc_InitialUEMessage_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_InitialUEMessage_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_InitialUEMessage_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value178(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_InitialUEMessage(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_InitialUEMessage_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'InitialUEMessage',Term1},
{Res1,Bytes4}.


dec_InitialUEMessage_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components179(V1@V0, V1@Buf1, []).


'dec_InitialUEMessage_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value180(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UplinkNASTransport(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UplinkNASTransport_protocolIEs(Enc2@element)
end].
enc_UplinkNASTransport_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UplinkNASTransport_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UplinkNASTransport_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value181(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UplinkNASTransport(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UplinkNASTransport_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UplinkNASTransport',Term1},
{Res1,Bytes4}.


dec_UplinkNASTransport_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components182(V1@V0, V1@Buf1, []).


'dec_UplinkNASTransport_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value183(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_NASNonDeliveryIndication(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_NASNonDeliveryIndication_protocolIEs(Enc2@element)
end].
enc_NASNonDeliveryIndication_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_NASNonDeliveryIndication_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_NASNonDeliveryIndication_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value184(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_NASNonDeliveryIndication(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_NASNonDeliveryIndication_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'NASNonDeliveryIndication',Term1},
{Res1,Bytes4}.


dec_NASNonDeliveryIndication_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components185(V1@V0, V1@Buf1, []).


'dec_NASNonDeliveryIndication_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value186(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_RerouteNASRequest(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_RerouteNASRequest_protocolIEs(Enc2@element)
end].
enc_RerouteNASRequest_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_RerouteNASRequest_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_RerouteNASRequest_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value187(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_RerouteNASRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_RerouteNASRequest_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'RerouteNASRequest',Term1},
{Res1,Bytes4}.


dec_RerouteNASRequest_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components188(V1@V0, V1@Buf1, []).


'dec_RerouteNASRequest_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value189(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_S1-Message'(Val) ->
Enc1@len = byte_size(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|Val];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|Val];
true ->
[align|encode_fragmented(Val, 8)]
end.


'dec_S1-Message'(Bytes) ->
begin
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@V7:V1@V5/binary-unit:8,V1@Buf8/bitstring>> ->
{V1@V7,V1@Buf8};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@V8:V1@V6/binary-unit:8,V1@Buf9/bitstring>> ->
{V1@V8,V1@Buf9};
<<_:V1@Pad3,1:1,1:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V8,V1@Buf9}  = decode_fragmented(V1@V6, V1@Buf7, 8),
{V1@V8,V1@Buf9}
end,
V1@Conv10 = binary:copy(V1@V0),
{V1@Conv10,V1@Buf1}
end.

enc_NASDeliveryIndication(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_NASDeliveryIndication_protocolIEs(Enc2@element)
end].
enc_NASDeliveryIndication_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_NASDeliveryIndication_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_NASDeliveryIndication_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value190(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_NASDeliveryIndication(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_NASDeliveryIndication_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'NASDeliveryIndication',Term1},
{Res1,Bytes4}.


dec_NASDeliveryIndication_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components191(V1@V0, V1@Buf1, []).


'dec_NASDeliveryIndication_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value192(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_Reset(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_Reset_protocolIEs(Enc2@element)
end].
enc_Reset_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_Reset_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_Reset_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value193(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_Reset(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_Reset_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'Reset',Term1},
{Res1,Bytes4}.


dec_Reset_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components194(V1@V0, V1@Buf1, []).


'dec_Reset_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value195(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_ResetType(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= 's1-Interface' ->
if ChoiceVal =:= 'reset-all' ->
<<0:1,0:1,0:1>>;
true ->
exit({error,{asn1,{illegal_enumerated,ChoiceVal}}})
end;
ChoiceTag =:= 'partOfS1-Interface' ->
[<<0:1,1:1>>|'enc_UE-associatedLogicalS1-ConnectionListRes'(ChoiceVal)]
end.


dec_ResetType(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:1/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
begin
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@Buf2/bitstring>> ->
{'reset-all',V2@Buf2};
<<1:1,V2@Buf2/bitstring>> ->
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<0:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V6,V2@Buf7};
<<1:1,V2@Buf5/bitstring>> ->
V2@Pad9 = bit_size(V2@Buf5) band 7,
{V2@V6,V2@Buf7} = case V2@Buf5 of
<<_:V2@Pad9,0:1,V2@V11:7,V2@Buf12/bitstring>> when V2@V11 =/= 0 ->
{V2@V11,V2@Buf12};
<<_:V2@Pad9,1:1,0:1,V2@V12:14,V2@Buf13/bitstring>> when V2@V12 =/= 0 ->
{V2@V12,V2@Buf13};
<<_:V2@Pad9,1:1,1:1,V2@V12:6,V2@Buf13/bitstring>> when V2@V12 =/= 0 ->
V2@Mul14 = V2@V12 * 16384,
{V2@Mul14,V2@Buf13}
end,
<<V2@V15:V2@V6/unit:8,V2@Buf16/bitstring>> = V2@Buf7,
{V2@V15,V2@Buf16}
end,
V2@Int17 = case V2@V3 of
_ -> {asn1_enum,V2@V3}
end,
{V2@Int17,V2@Buf4}
end,
{V2@V0,V2@Buf1}
end
end,
{{'s1-Interface',Val},NewBytes};
1 ->
{Val,NewBytes} = begin
'dec_UE-associatedLogicalS1-ConnectionListRes'(Bytes2)
end,
{{'partOfS1-Interface',Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10};
<<_:V1@Pad6,1:1,1:1,V1@V9:6,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
V1@Mul11 = V1@V9 * 16384,
{V1@Mul11,V1@Buf10}
end,
<<V1@V12:V1@V3/unit:8,V1@Buf13/bitstring>> = V1@Buf4,
{V1@V12,V1@Buf13}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
enc_ResetAll(Val) ->
if Val =:= 'reset-all' ->
<<0:1>>;
true ->
exit({error,{asn1,{illegal_enumerated,Val}}})
end.


dec_ResetAll(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@Buf2/bitstring>> ->
{'reset-all',V1@Buf2};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13};
<<_:V1@Pad9,1:1,1:1,V1@V12:6,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
V1@Mul14 = V1@V12 * 16384,
{V1@Mul14,V1@Buf13}
end,
<<V1@V15:V1@V6/unit:8,V1@Buf16/bitstring>> = V1@Buf7,
{V1@V15,V1@Buf16}
end,
V1@Int17 = case V1@V3 of
_ -> {asn1_enum,V1@V3}
end,
{V1@Int17,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

'enc_UE-associatedLogicalS1-ConnectionListRes'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_UE-associatedLogicalS1-ConnectionListRes_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UE-associatedLogicalS1-ConnectionListRes_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value196(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_UE-associatedLogicalS1-ConnectionListRes'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components197(V1@Add4, V1@Buf1, []).


'dec_UE-associatedLogicalS1-ConnectionListRes_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value198(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_ResetAcknowledge(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_ResetAcknowledge_protocolIEs(Enc2@element)
end].
enc_ResetAcknowledge_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_ResetAcknowledge_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_ResetAcknowledge_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value199(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_ResetAcknowledge(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_ResetAcknowledge_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'ResetAcknowledge',Term1},
{Res1,Bytes4}.


dec_ResetAcknowledge_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components200(V1@V0, V1@Buf1, []).


'dec_ResetAcknowledge_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value201(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_UE-associatedLogicalS1-ConnectionListResAck'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_UE-associatedLogicalS1-ConnectionListResAck_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UE-associatedLogicalS1-ConnectionListResAck_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value202(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_UE-associatedLogicalS1-ConnectionListResAck'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components203(V1@Add4, V1@Buf1, []).


'dec_UE-associatedLogicalS1-ConnectionListResAck_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value204(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_ErrorIndication(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_ErrorIndication_protocolIEs(Enc2@element)
end].
enc_ErrorIndication_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_ErrorIndication_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_ErrorIndication_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value205(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_ErrorIndication(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_ErrorIndication_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'ErrorIndication',Term1},
{Res1,Bytes4}.


dec_ErrorIndication_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components206(V1@V0, V1@Buf1, []).


'dec_ErrorIndication_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value207(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_S1SetupRequest(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_S1SetupRequest_protocolIEs(Enc2@element)
end].
enc_S1SetupRequest_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_S1SetupRequest_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_S1SetupRequest_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value208(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_S1SetupRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_S1SetupRequest_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'S1SetupRequest',Term1},
{Res1,Bytes4}.


dec_S1SetupRequest_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components209(V1@V0, V1@Buf1, []).


'dec_S1SetupRequest_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value210(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_S1SetupResponse(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_S1SetupResponse_protocolIEs(Enc2@element)
end].
enc_S1SetupResponse_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_S1SetupResponse_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_S1SetupResponse_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value211(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_S1SetupResponse(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_S1SetupResponse_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'S1SetupResponse',Term1},
{Res1,Bytes4}.


dec_S1SetupResponse_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components212(V1@V0, V1@Buf1, []).


'dec_S1SetupResponse_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value213(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_S1SetupFailure(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_S1SetupFailure_protocolIEs(Enc2@element)
end].
enc_S1SetupFailure_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_S1SetupFailure_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_S1SetupFailure_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value214(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_S1SetupFailure(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_S1SetupFailure_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'S1SetupFailure',Term1},
{Res1,Bytes4}.


dec_S1SetupFailure_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components215(V1@V0, V1@Buf1, []).


'dec_S1SetupFailure_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value216(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_ENBConfigurationUpdate(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_ENBConfigurationUpdate_protocolIEs(Enc2@element)
end].
enc_ENBConfigurationUpdate_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_ENBConfigurationUpdate_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_ENBConfigurationUpdate_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value217(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_ENBConfigurationUpdate(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_ENBConfigurationUpdate_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'ENBConfigurationUpdate',Term1},
{Res1,Bytes4}.


dec_ENBConfigurationUpdate_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components218(V1@V0, V1@Buf1, []).


'dec_ENBConfigurationUpdate_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value219(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_ENBConfigurationUpdateAcknowledge(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_ENBConfigurationUpdateAcknowledge_protocolIEs(Enc2@element)
end].
enc_ENBConfigurationUpdateAcknowledge_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_ENBConfigurationUpdateAcknowledge_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_ENBConfigurationUpdateAcknowledge_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value220(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_ENBConfigurationUpdateAcknowledge(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_ENBConfigurationUpdateAcknowledge_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'ENBConfigurationUpdateAcknowledge',Term1},
{Res1,Bytes4}.


dec_ENBConfigurationUpdateAcknowledge_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components221(V1@V0, V1@Buf1, []).


'dec_ENBConfigurationUpdateAcknowledge_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value222(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_ENBConfigurationUpdateFailure(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_ENBConfigurationUpdateFailure_protocolIEs(Enc2@element)
end].
enc_ENBConfigurationUpdateFailure_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_ENBConfigurationUpdateFailure_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_ENBConfigurationUpdateFailure_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value223(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_ENBConfigurationUpdateFailure(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_ENBConfigurationUpdateFailure_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'ENBConfigurationUpdateFailure',Term1},
{Res1,Bytes4}.


dec_ENBConfigurationUpdateFailure_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components224(V1@V0, V1@Buf1, []).


'dec_ENBConfigurationUpdateFailure_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value225(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_MMEConfigurationUpdate(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_MMEConfigurationUpdate_protocolIEs(Enc2@element)
end].
enc_MMEConfigurationUpdate_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_MMEConfigurationUpdate_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_MMEConfigurationUpdate_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value226(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_MMEConfigurationUpdate(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_MMEConfigurationUpdate_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'MMEConfigurationUpdate',Term1},
{Res1,Bytes4}.


dec_MMEConfigurationUpdate_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components227(V1@V0, V1@Buf1, []).


'dec_MMEConfigurationUpdate_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value228(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_MMEConfigurationUpdateAcknowledge(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_MMEConfigurationUpdateAcknowledge_protocolIEs(Enc2@element)
end].
enc_MMEConfigurationUpdateAcknowledge_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_MMEConfigurationUpdateAcknowledge_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_MMEConfigurationUpdateAcknowledge_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value229(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_MMEConfigurationUpdateAcknowledge(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_MMEConfigurationUpdateAcknowledge_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'MMEConfigurationUpdateAcknowledge',Term1},
{Res1,Bytes4}.


dec_MMEConfigurationUpdateAcknowledge_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components230(V1@V0, V1@Buf1, []).


'dec_MMEConfigurationUpdateAcknowledge_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value231(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_MMEConfigurationUpdateFailure(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_MMEConfigurationUpdateFailure_protocolIEs(Enc2@element)
end].
enc_MMEConfigurationUpdateFailure_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_MMEConfigurationUpdateFailure_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_MMEConfigurationUpdateFailure_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value232(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_MMEConfigurationUpdateFailure(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_MMEConfigurationUpdateFailure_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'MMEConfigurationUpdateFailure',Term1},
{Res1,Bytes4}.


dec_MMEConfigurationUpdateFailure_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components233(V1@V0, V1@Buf1, []).


'dec_MMEConfigurationUpdateFailure_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value234(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_DownlinkS1cdma2000tunnelling(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_DownlinkS1cdma2000tunnelling_protocolIEs(Enc2@element)
end].
enc_DownlinkS1cdma2000tunnelling_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_DownlinkS1cdma2000tunnelling_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_DownlinkS1cdma2000tunnelling_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value235(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_DownlinkS1cdma2000tunnelling(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_DownlinkS1cdma2000tunnelling_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'DownlinkS1cdma2000tunnelling',Term1},
{Res1,Bytes4}.


dec_DownlinkS1cdma2000tunnelling_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components236(V1@V0, V1@Buf1, []).


'dec_DownlinkS1cdma2000tunnelling_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value237(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UplinkS1cdma2000tunnelling(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UplinkS1cdma2000tunnelling_protocolIEs(Enc2@element)
end].
enc_UplinkS1cdma2000tunnelling_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UplinkS1cdma2000tunnelling_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UplinkS1cdma2000tunnelling_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value238(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UplinkS1cdma2000tunnelling(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UplinkS1cdma2000tunnelling_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UplinkS1cdma2000tunnelling',Term1},
{Res1,Bytes4}.


dec_UplinkS1cdma2000tunnelling_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components239(V1@V0, V1@Buf1, []).


'dec_UplinkS1cdma2000tunnelling_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value240(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UECapabilityInfoIndication(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UECapabilityInfoIndication_protocolIEs(Enc2@element)
end].
enc_UECapabilityInfoIndication_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UECapabilityInfoIndication_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UECapabilityInfoIndication_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value241(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UECapabilityInfoIndication(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UECapabilityInfoIndication_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UECapabilityInfoIndication',Term1},
{Res1,Bytes4}.


dec_UECapabilityInfoIndication_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components242(V1@V0, V1@Buf1, []).


'dec_UECapabilityInfoIndication_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value243(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_ENBStatusTransfer(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_ENBStatusTransfer_protocolIEs(Enc2@element)
end].
enc_ENBStatusTransfer_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_ENBStatusTransfer_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_ENBStatusTransfer_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value244(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_ENBStatusTransfer(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_ENBStatusTransfer_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'ENBStatusTransfer',Term1},
{Res1,Bytes4}.


dec_ENBStatusTransfer_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components245(V1@V0, V1@Buf1, []).


'dec_ENBStatusTransfer_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value246(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_MMEStatusTransfer(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_MMEStatusTransfer_protocolIEs(Enc2@element)
end].
enc_MMEStatusTransfer_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_MMEStatusTransfer_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_MMEStatusTransfer_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value247(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_MMEStatusTransfer(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_MMEStatusTransfer_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'MMEStatusTransfer',Term1},
{Res1,Bytes4}.


dec_MMEStatusTransfer_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components248(V1@V0, V1@Buf1, []).


'dec_MMEStatusTransfer_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value249(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_TraceStart(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_TraceStart_protocolIEs(Enc2@element)
end].
enc_TraceStart_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_TraceStart_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_TraceStart_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value250(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_TraceStart(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_TraceStart_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'TraceStart',Term1},
{Res1,Bytes4}.


dec_TraceStart_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components251(V1@V0, V1@Buf1, []).


'dec_TraceStart_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value252(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_TraceFailureIndication(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_TraceFailureIndication_protocolIEs(Enc2@element)
end].
enc_TraceFailureIndication_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_TraceFailureIndication_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_TraceFailureIndication_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value253(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_TraceFailureIndication(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_TraceFailureIndication_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'TraceFailureIndication',Term1},
{Res1,Bytes4}.


dec_TraceFailureIndication_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components254(V1@V0, V1@Buf1, []).


'dec_TraceFailureIndication_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value255(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_DeactivateTrace(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_DeactivateTrace_protocolIEs(Enc2@element)
end].
enc_DeactivateTrace_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_DeactivateTrace_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_DeactivateTrace_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value256(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_DeactivateTrace(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_DeactivateTrace_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'DeactivateTrace',Term1},
{Res1,Bytes4}.


dec_DeactivateTrace_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components257(V1@V0, V1@Buf1, []).


'dec_DeactivateTrace_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value258(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_CellTrafficTrace(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_CellTrafficTrace_protocolIEs(Enc2@element)
end].
enc_CellTrafficTrace_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_CellTrafficTrace_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_CellTrafficTrace_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value259(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_CellTrafficTrace(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_CellTrafficTrace_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'CellTrafficTrace',Term1},
{Res1,Bytes4}.


dec_CellTrafficTrace_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components260(V1@V0, V1@Buf1, []).


'dec_CellTrafficTrace_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value261(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_LocationReportingControl(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_LocationReportingControl_protocolIEs(Enc2@element)
end].
enc_LocationReportingControl_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_LocationReportingControl_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_LocationReportingControl_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value262(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_LocationReportingControl(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_LocationReportingControl_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'LocationReportingControl',Term1},
{Res1,Bytes4}.


dec_LocationReportingControl_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components263(V1@V0, V1@Buf1, []).


'dec_LocationReportingControl_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value264(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_LocationReportingFailureIndication(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_LocationReportingFailureIndication_protocolIEs(Enc2@element)
end].
enc_LocationReportingFailureIndication_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_LocationReportingFailureIndication_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_LocationReportingFailureIndication_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value265(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_LocationReportingFailureIndication(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_LocationReportingFailureIndication_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'LocationReportingFailureIndication',Term1},
{Res1,Bytes4}.


dec_LocationReportingFailureIndication_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components266(V1@V0, V1@Buf1, []).


'dec_LocationReportingFailureIndication_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value267(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_LocationReport(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_LocationReport_protocolIEs(Enc2@element)
end].
enc_LocationReport_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_LocationReport_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_LocationReport_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value268(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_LocationReport(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_LocationReport_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'LocationReport',Term1},
{Res1,Bytes4}.


dec_LocationReport_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components269(V1@V0, V1@Buf1, []).


'dec_LocationReport_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value270(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_OverloadStart(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_OverloadStart_protocolIEs(Enc2@element)
end].
enc_OverloadStart_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_OverloadStart_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_OverloadStart_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value271(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_OverloadStart(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_OverloadStart_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'OverloadStart',Term1},
{Res1,Bytes4}.


dec_OverloadStart_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components272(V1@V0, V1@Buf1, []).


'dec_OverloadStart_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value273(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_OverloadStop(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_OverloadStop_protocolIEs(Enc2@element)
end].
enc_OverloadStop_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_OverloadStop_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_OverloadStop_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value274(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_OverloadStop(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_OverloadStop_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'OverloadStop',Term1},
{Res1,Bytes4}.


dec_OverloadStop_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components275(V1@V0, V1@Buf1, []).


'dec_OverloadStop_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value276(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_WriteReplaceWarningRequest(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_WriteReplaceWarningRequest_protocolIEs(Enc2@element)
end].
enc_WriteReplaceWarningRequest_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_WriteReplaceWarningRequest_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_WriteReplaceWarningRequest_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value277(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_WriteReplaceWarningRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_WriteReplaceWarningRequest_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'WriteReplaceWarningRequest',Term1},
{Res1,Bytes4}.


dec_WriteReplaceWarningRequest_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components278(V1@V0, V1@Buf1, []).


'dec_WriteReplaceWarningRequest_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value279(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_WriteReplaceWarningResponse(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_WriteReplaceWarningResponse_protocolIEs(Enc2@element)
end].
enc_WriteReplaceWarningResponse_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_WriteReplaceWarningResponse_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_WriteReplaceWarningResponse_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value280(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_WriteReplaceWarningResponse(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_WriteReplaceWarningResponse_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'WriteReplaceWarningResponse',Term1},
{Res1,Bytes4}.


dec_WriteReplaceWarningResponse_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components281(V1@V0, V1@Buf1, []).


'dec_WriteReplaceWarningResponse_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value282(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_ENBDirectInformationTransfer(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_ENBDirectInformationTransfer_protocolIEs(Enc2@element)
end].
enc_ENBDirectInformationTransfer_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_ENBDirectInformationTransfer_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_ENBDirectInformationTransfer_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value283(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_ENBDirectInformationTransfer(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_ENBDirectInformationTransfer_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'ENBDirectInformationTransfer',Term1},
{Res1,Bytes4}.


dec_ENBDirectInformationTransfer_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components284(V1@V0, V1@Buf1, []).


'dec_ENBDirectInformationTransfer_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value285(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_Inter-SystemInformationTransferType'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= rIMTransfer ->
[<<0:1>>|'S1AP-IEs':enc_RIMTransfer(ChoiceVal)]
end.


'dec_Inter-SystemInformationTransferType'(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
ignore,
{0,Bytes1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
'S1AP-IEs':dec_RIMTransfer(Bytes2)
end,
{{rIMTransfer,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10};
<<_:V1@Pad6,1:1,1:1,V1@V9:6,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
V1@Mul11 = V1@V9 * 16384,
{V1@Mul11,V1@Buf10}
end,
<<V1@V12:V1@V3/unit:8,V1@Buf13/bitstring>> = V1@Buf4,
{V1@V12,V1@Buf13}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
enc_MMEDirectInformationTransfer(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_MMEDirectInformationTransfer_protocolIEs(Enc2@element)
end].
enc_MMEDirectInformationTransfer_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_MMEDirectInformationTransfer_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_MMEDirectInformationTransfer_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value286(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_MMEDirectInformationTransfer(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_MMEDirectInformationTransfer_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'MMEDirectInformationTransfer',Term1},
{Res1,Bytes4}.


dec_MMEDirectInformationTransfer_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components287(V1@V0, V1@Buf1, []).


'dec_MMEDirectInformationTransfer_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value288(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_ENBConfigurationTransfer(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_ENBConfigurationTransfer_protocolIEs(Enc2@element)
end].
enc_ENBConfigurationTransfer_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_ENBConfigurationTransfer_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_ENBConfigurationTransfer_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value289(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_ENBConfigurationTransfer(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_ENBConfigurationTransfer_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'ENBConfigurationTransfer',Term1},
{Res1,Bytes4}.


dec_ENBConfigurationTransfer_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components290(V1@V0, V1@Buf1, []).


'dec_ENBConfigurationTransfer_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value291(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_MMEConfigurationTransfer(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_MMEConfigurationTransfer_protocolIEs(Enc2@element)
end].
enc_MMEConfigurationTransfer_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_MMEConfigurationTransfer_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_MMEConfigurationTransfer_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value292(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_MMEConfigurationTransfer(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_MMEConfigurationTransfer_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'MMEConfigurationTransfer',Term1},
{Res1,Bytes4}.


dec_MMEConfigurationTransfer_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components293(V1@V0, V1@Buf1, []).


'dec_MMEConfigurationTransfer_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value294(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_PrivateMessage(Val) ->
[<<0:1>>|begin
%% attribute privateIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_PrivateMessage_privateIEs(Enc2@element)
end].
enc_PrivateMessage_privateIEs(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_PrivateMessage_privateIEs_PrivateIE-Field'(Comp) || Comp <- Val]]
end.

'enc_PrivateMessage_privateIEs_PrivateIE-Field'(Val) ->
[begin
%% attribute id(1) with type PrivateIE-ID
Enc1@element = element(2, Val),
'S1AP-CommonDataTypes':'enc_PrivateIE-ID'(Enc1@element)
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc2@element = element(3, Val),
if Enc2@element =:= reject ->
<<0:2>>;
Enc2@element =:= ignore ->
<<1:2>>;
Enc2@element =:= notify ->
<<2:2>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc2@element}}})
end
end,
align|begin
%% attribute value(3) with type ASN1_OPEN_TYPE
Enc4@element = element(4, Val),
Enc5@output = iolist_to_binary(Enc4@element),
Enc5@bin = Enc5@output,
Enc5@len = byte_size(Enc5@bin),
if Enc5@len < 128 ->
[Enc5@len|Enc5@bin];
Enc5@len < 16384 ->
[<<2:2,Enc5@len:14>>|Enc5@bin];
true ->
encode_fragmented(Enc5@bin, 8)
end
end].


dec_PrivateMessage(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute privateIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_PrivateMessage_privateIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'PrivateMessage',Term1},
{Res1,Bytes4}.


dec_PrivateMessage_privateIEs(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components295(V1@Add4, V1@Buf1, []).


'dec_PrivateMessage_privateIEs_PrivateIE-Field'(Bytes) ->

%% attribute id(1) with type PrivateIE-ID
{Term1,Bytes1} = 'S1AP-CommonDataTypes':'dec_PrivateIE-ID'(Bytes),

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
V1@Int2 = case V1@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V1@V0}}})
end,
{V1@Int2,V1@Buf1}
end,

%% attribute value(3) with type ASN1_OPEN_TYPE
{Term3,Bytes3} = begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end,
{V2@V0,V2@Buf1}
end,
Res1 = {'PrivateIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_KillRequest(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_KillRequest_protocolIEs(Enc2@element)
end].
enc_KillRequest_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_KillRequest_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_KillRequest_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value296(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_KillRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_KillRequest_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'KillRequest',Term1},
{Res1,Bytes4}.


dec_KillRequest_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components297(V1@V0, V1@Buf1, []).


'dec_KillRequest_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value298(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_KillResponse(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_KillResponse_protocolIEs(Enc2@element)
end].
enc_KillResponse_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_KillResponse_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_KillResponse_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value299(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_KillResponse(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_KillResponse_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'KillResponse',Term1},
{Res1,Bytes4}.


dec_KillResponse_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components300(V1@V0, V1@Buf1, []).


'dec_KillResponse_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value301(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_PWSRestartIndication(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_PWSRestartIndication_protocolIEs(Enc2@element)
end].
enc_PWSRestartIndication_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_PWSRestartIndication_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_PWSRestartIndication_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value302(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_PWSRestartIndication(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_PWSRestartIndication_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'PWSRestartIndication',Term1},
{Res1,Bytes4}.


dec_PWSRestartIndication_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components303(V1@V0, V1@Buf1, []).


'dec_PWSRestartIndication_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value304(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_PWSFailureIndication(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_PWSFailureIndication_protocolIEs(Enc2@element)
end].
enc_PWSFailureIndication_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_PWSFailureIndication_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_PWSFailureIndication_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value305(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_PWSFailureIndication(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_PWSFailureIndication_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'PWSFailureIndication',Term1},
{Res1,Bytes4}.


dec_PWSFailureIndication_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components306(V1@V0, V1@Buf1, []).


'dec_PWSFailureIndication_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value307(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_DownlinkUEAssociatedLPPaTransport(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_DownlinkUEAssociatedLPPaTransport_protocolIEs(Enc2@element)
end].
enc_DownlinkUEAssociatedLPPaTransport_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_DownlinkUEAssociatedLPPaTransport_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_DownlinkUEAssociatedLPPaTransport_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value308(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_DownlinkUEAssociatedLPPaTransport(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_DownlinkUEAssociatedLPPaTransport_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'DownlinkUEAssociatedLPPaTransport',Term1},
{Res1,Bytes4}.


dec_DownlinkUEAssociatedLPPaTransport_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components309(V1@V0, V1@Buf1, []).


'dec_DownlinkUEAssociatedLPPaTransport_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value310(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UplinkUEAssociatedLPPaTransport(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UplinkUEAssociatedLPPaTransport_protocolIEs(Enc2@element)
end].
enc_UplinkUEAssociatedLPPaTransport_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UplinkUEAssociatedLPPaTransport_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UplinkUEAssociatedLPPaTransport_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value311(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UplinkUEAssociatedLPPaTransport(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UplinkUEAssociatedLPPaTransport_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UplinkUEAssociatedLPPaTransport',Term1},
{Res1,Bytes4}.


dec_UplinkUEAssociatedLPPaTransport_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components312(V1@V0, V1@Buf1, []).


'dec_UplinkUEAssociatedLPPaTransport_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value313(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_DownlinkNonUEAssociatedLPPaTransport(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_DownlinkNonUEAssociatedLPPaTransport_protocolIEs(Enc2@element)
end].
enc_DownlinkNonUEAssociatedLPPaTransport_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_DownlinkNonUEAssociatedLPPaTransport_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_DownlinkNonUEAssociatedLPPaTransport_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value314(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_DownlinkNonUEAssociatedLPPaTransport(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_DownlinkNonUEAssociatedLPPaTransport_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'DownlinkNonUEAssociatedLPPaTransport',Term1},
{Res1,Bytes4}.


dec_DownlinkNonUEAssociatedLPPaTransport_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components315(V1@V0, V1@Buf1, []).


'dec_DownlinkNonUEAssociatedLPPaTransport_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value316(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UplinkNonUEAssociatedLPPaTransport(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UplinkNonUEAssociatedLPPaTransport_protocolIEs(Enc2@element)
end].
enc_UplinkNonUEAssociatedLPPaTransport_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UplinkNonUEAssociatedLPPaTransport_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UplinkNonUEAssociatedLPPaTransport_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value317(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UplinkNonUEAssociatedLPPaTransport(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UplinkNonUEAssociatedLPPaTransport_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UplinkNonUEAssociatedLPPaTransport',Term1},
{Res1,Bytes4}.


dec_UplinkNonUEAssociatedLPPaTransport_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components318(V1@V0, V1@Buf1, []).


'dec_UplinkNonUEAssociatedLPPaTransport_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value319(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABModificationIndication'(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
'enc_E-RABModificationIndication_protocolIEs'(Enc2@element)
end].
'enc_E-RABModificationIndication_protocolIEs'(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_E-RABModificationIndication_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABModificationIndication_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value320(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABModificationIndication'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = 'dec_E-RABModificationIndication_protocolIEs'(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'E-RABModificationIndication',Term1},
{Res1,Bytes4}.


'dec_E-RABModificationIndication_protocolIEs'(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components321(V1@V0, V1@Buf1, []).


'dec_E-RABModificationIndication_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value322(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABToBeModifiedListBearerModInd'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABToBeModifiedListBearerModInd_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABToBeModifiedListBearerModInd_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value323(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABToBeModifiedListBearerModInd'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components324(V1@Add4, V1@Buf1, []).


'dec_E-RABToBeModifiedListBearerModInd_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value325(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABToBeModifiedItemBearerModInd'(Val) ->
[begin
Enc1@element = element(5, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 4 =:= 0 ->
<<0:1,Enc3@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc3@element)]
end
end,
begin
%% attribute transportLayerAddress(2) with type BIT STRING
Enc5@element = element(3, Val),
Enc6@bits = bit_size(Enc5@element),
Enc6@bits@sub = Enc6@bits - 1,
if 0 =< Enc6@bits@sub, Enc6@bits@sub < 160 ->
[<<0:1,Enc6@bits@sub:8>>,
align|Enc5@element];
Enc6@bits < 16384 ->
[<<1:1>>,
align,
<<2:2,Enc6@bits:14>>|Enc5@element];
true ->
[<<1:1>>,
align|encode_fragmented(Enc5@element, 1)]
end
end,
align,
begin
%% attribute dL-GTP-TEID(3) with type OCTET STRING
Enc7@element = element(4, Val),
Enc8@len = byte_size(Enc7@element),
if Enc8@len =:= 4 ->
Enc7@element
end
end|begin
%% attribute iE-Extensions(4) with type SEQUENCE OF
Enc9@element = element(5, Val),
if Enc9@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABToBeModifiedItemBearerModInd_iE-Extensions'(Enc9@element)
end
end].
'enc_E-RABToBeModifiedItemBearerModInd_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABToBeModifiedItemBearerModInd_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABToBeModifiedItemBearerModInd_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension10(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABToBeModifiedItemBearerModInd'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute transportLayerAddress(2) with type BIT STRING
{Term2,Bytes4} = begin
{V4@V0,V4@Buf1} = case Bytes3 of
<<0:1,V4@V3:8/unsigned-unit:1,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
V4@Pad8 = bit_size(V4@Buf4) band 7,
<<_:V4@Pad8,V4@V6:V4@Add5/binary-unit:1,V4@Buf7/bitstring>> = V4@Buf4,
{V4@V6,V4@Buf7};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@V10:V4@V8/binary-unit:1,V4@Buf11/bitstring>> ->
{V4@V10,V4@Buf11};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@V11:V4@V9/binary-unit:1,V4@Buf12/bitstring>> ->
{V4@V11,V4@Buf12};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> ->
{V4@V11,V4@Buf12}  = decode_fragmented(V4@V9, V4@Buf10, 1),
{V4@V11,V4@Buf12}
end,
{V4@V3,V4@Buf4}
end,
{V4@V13,V4@Buf14}  = {list_to_bitstring([V4@V0]),V4@Buf1},
{V4@V13,V4@Buf14}
end,

%% attribute dL-GTP-TEID(3) with type OCTET STRING
{Term3,Bytes5} = begin
V5@Pad2 = bit_size(Bytes4) band 7,
<<_:V5@Pad2,V5@V0:4/binary-unit:8,V5@Buf1/bitstring>> = Bytes4,
V5@Conv4 = binary:copy(V5@V0),
{V5@Conv4,V5@Buf1}
end,

%% attribute iE-Extensions(4) with type SEQUENCE OF
{Term4,Bytes6} = case Opt band 1 of
1 ->
'dec_E-RABToBeModifiedItemBearerModInd_iE-Extensions'(Bytes5);
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V6@V0,V6@Buf1} = case Bytes6 of
<<0:1,V6@V3:6,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
{V6@Add5,V6@Buf4};
<<1:1,V6@Buf2/bitstring>> ->
V6@Pad6 = bit_size(V6@Buf2) band 7,
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:V6@Pad6,0:1,V6@V8:7,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
{V6@V8,V6@Buf9};
<<_:V6@Pad6,1:1,0:1,V6@V9:14,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
{V6@V9,V6@Buf10};
<<_:V6@Pad6,1:1,1:1,V6@V9:6,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
V6@Mul11 = V6@V9 * 16384,
{V6@Mul11,V6@Buf10}
end,
{V6@V3,V6@Buf4}
end,
<<V6@V12:V6@V0/bitstring-unit:1,V6@Buf13/bitstring>> = V6@Buf1,
{V6@V12,V6@Buf13}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
Res1 = {'E-RABToBeModifiedItemBearerModInd',Term1,Term2,Term3,Term4},
{Res1,Bytes8}.


'dec_E-RABToBeModifiedItemBearerModInd_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components326(V1@Add4, V1@Buf1, []).


'dec_E-RABToBeModifiedItemBearerModInd_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension12(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABNotToBeModifiedListBearerModInd'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABNotToBeModifiedListBearerModInd_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABNotToBeModifiedListBearerModInd_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value327(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABNotToBeModifiedListBearerModInd'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components328(V1@Add4, V1@Buf1, []).


'dec_E-RABNotToBeModifiedListBearerModInd_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value329(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABNotToBeModifiedItemBearerModInd'(Val) ->
[begin
Enc1@element = element(5, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 4 =:= 0 ->
<<0:1,Enc3@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc3@element)]
end
end,
begin
%% attribute transportLayerAddress(2) with type BIT STRING
Enc5@element = element(3, Val),
Enc6@bits = bit_size(Enc5@element),
Enc6@bits@sub = Enc6@bits - 1,
if 0 =< Enc6@bits@sub, Enc6@bits@sub < 160 ->
[<<0:1,Enc6@bits@sub:8>>,
align|Enc5@element];
Enc6@bits < 16384 ->
[<<1:1>>,
align,
<<2:2,Enc6@bits:14>>|Enc5@element];
true ->
[<<1:1>>,
align|encode_fragmented(Enc5@element, 1)]
end
end,
align,
begin
%% attribute dL-GTP-TEID(3) with type OCTET STRING
Enc7@element = element(4, Val),
Enc8@len = byte_size(Enc7@element),
if Enc8@len =:= 4 ->
Enc7@element
end
end|begin
%% attribute iE-Extensions(4) with type SEQUENCE OF
Enc9@element = element(5, Val),
if Enc9@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABNotToBeModifiedItemBearerModInd_iE-Extensions'(Enc9@element)
end
end].
'enc_E-RABNotToBeModifiedItemBearerModInd_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABNotToBeModifiedItemBearerModInd_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABNotToBeModifiedItemBearerModInd_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension10(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABNotToBeModifiedItemBearerModInd'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute transportLayerAddress(2) with type BIT STRING
{Term2,Bytes4} = begin
{V4@V0,V4@Buf1} = case Bytes3 of
<<0:1,V4@V3:8/unsigned-unit:1,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
V4@Pad8 = bit_size(V4@Buf4) band 7,
<<_:V4@Pad8,V4@V6:V4@Add5/binary-unit:1,V4@Buf7/bitstring>> = V4@Buf4,
{V4@V6,V4@Buf7};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@V10:V4@V8/binary-unit:1,V4@Buf11/bitstring>> ->
{V4@V10,V4@Buf11};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@V11:V4@V9/binary-unit:1,V4@Buf12/bitstring>> ->
{V4@V11,V4@Buf12};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> ->
{V4@V11,V4@Buf12}  = decode_fragmented(V4@V9, V4@Buf10, 1),
{V4@V11,V4@Buf12}
end,
{V4@V3,V4@Buf4}
end,
{V4@V13,V4@Buf14}  = {list_to_bitstring([V4@V0]),V4@Buf1},
{V4@V13,V4@Buf14}
end,

%% attribute dL-GTP-TEID(3) with type OCTET STRING
{Term3,Bytes5} = begin
V5@Pad2 = bit_size(Bytes4) band 7,
<<_:V5@Pad2,V5@V0:4/binary-unit:8,V5@Buf1/bitstring>> = Bytes4,
V5@Conv4 = binary:copy(V5@V0),
{V5@Conv4,V5@Buf1}
end,

%% attribute iE-Extensions(4) with type SEQUENCE OF
{Term4,Bytes6} = case Opt band 1 of
1 ->
'dec_E-RABNotToBeModifiedItemBearerModInd_iE-Extensions'(Bytes5);
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V6@V0,V6@Buf1} = case Bytes6 of
<<0:1,V6@V3:6,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
{V6@Add5,V6@Buf4};
<<1:1,V6@Buf2/bitstring>> ->
V6@Pad6 = bit_size(V6@Buf2) band 7,
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:V6@Pad6,0:1,V6@V8:7,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
{V6@V8,V6@Buf9};
<<_:V6@Pad6,1:1,0:1,V6@V9:14,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
{V6@V9,V6@Buf10};
<<_:V6@Pad6,1:1,1:1,V6@V9:6,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
V6@Mul11 = V6@V9 * 16384,
{V6@Mul11,V6@Buf10}
end,
{V6@V3,V6@Buf4}
end,
<<V6@V12:V6@V0/bitstring-unit:1,V6@Buf13/bitstring>> = V6@Buf1,
{V6@V12,V6@Buf13}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
Res1 = {'E-RABNotToBeModifiedItemBearerModInd',Term1,Term2,Term3,Term4},
{Res1,Bytes8}.


'dec_E-RABNotToBeModifiedItemBearerModInd_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components330(V1@Add4, V1@Buf1, []).


'dec_E-RABNotToBeModifiedItemBearerModInd_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension12(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_CSGMembershipInfo(Val) ->
[begin
Enc1@element = element(4, Val),
Enc2@element = element(5, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@element = element(6, Val),
%% attribute cSGMembershipStatus(1) with type ENUMERATED
Enc5@element = element(2, Val),
if Enc3@element =:= asn1_NOVALUE ->
if Enc5@element =:= member ->
<<0:1,0:1>>;
Enc5@element =:= 'not-member' ->
<<0:1,1:1>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc5@element}}})
end;
true ->
if Enc5@element =:= member ->
<<1:1,0:1>>;
Enc5@element =:= 'not-member' ->
<<1:1,1:1>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc5@element}}})
end
end
end,
align,
begin
%% attribute cSG-Id(2) with type BIT STRING
Enc7@element = element(3, Val),
Enc8@bits = bit_size(Enc7@element),
if Enc8@bits =:= 27 ->
Enc7@element
end
end,
begin
%% attribute cellAccessMode(3) with type ENUMERATED
Enc9@element = element(4, Val),
if Enc9@element =:= asn1_NOVALUE ->
[];
Enc9@element =:= hybrid ->
<<0:1>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc9@element}}})
end
end,
begin
%% attribute pLMNidentity(4) with type OCTET STRING
Enc12@element = element(5, Val),
if Enc12@element =:= asn1_NOVALUE ->
[];
true ->
begin
Enc13@len = byte_size(Enc12@element),
if Enc13@len =:= 3 ->
[align|Enc12@element]
end
end
end
end|begin
%% attribute iE-Extensions(5) with type SEQUENCE OF
Enc15@element = element(6, Val),
if Enc15@element =:= asn1_NOVALUE ->
[];
true ->
'enc_CSGMembershipInfo_iE-Extensions'(Enc15@element)
end
end].
'enc_CSGMembershipInfo_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_CSGMembershipInfo_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_CSGMembershipInfo_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension10(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_CSGMembershipInfo(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:3,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute cSGMembershipStatus(1) with type ENUMERATED
{Term1,Bytes3} = begin
<<V3@V0:1/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
V3@Int2 = case V3@V0 of
0 -> member;
1 -> 'not-member'
end,
{V3@Int2,V3@Buf1}
end,

%% attribute cSG-Id(2) with type BIT STRING
{Term2,Bytes4} = begin
V4@Pad2 = bit_size(Bytes3) band 7,
<<_:V4@Pad2,V4@V0:27/binary-unit:1,V4@Buf1/bitstring>> = Bytes3,
{V4@V4,V4@Buf5}  = {list_to_bitstring([V4@V0]),V4@Buf1},
{V4@V4,V4@Buf5}
end,

%% attribute cellAccessMode(3) with type ENUMERATED
{Term3,Bytes5} = case (Opt bsr 2) band 1 of
1 ->
begin
{V5@V0,V5@Buf1} = case Bytes4 of
<<0:1,V5@Buf2/bitstring>> ->
{'hybrid',V5@Buf2};
<<1:1,V5@Buf2/bitstring>> ->
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<0:1,V5@V6:6,V5@Buf7/bitstring>> ->
{V5@V6,V5@Buf7};
<<1:1,V5@Buf5/bitstring>> ->
V5@Pad9 = bit_size(V5@Buf5) band 7,
{V5@V6,V5@Buf7} = case V5@Buf5 of
<<_:V5@Pad9,0:1,V5@V11:7,V5@Buf12/bitstring>> when V5@V11 =/= 0 ->
{V5@V11,V5@Buf12};
<<_:V5@Pad9,1:1,0:1,V5@V12:14,V5@Buf13/bitstring>> when V5@V12 =/= 0 ->
{V5@V12,V5@Buf13};
<<_:V5@Pad9,1:1,1:1,V5@V12:6,V5@Buf13/bitstring>> when V5@V12 =/= 0 ->
V5@Mul14 = V5@V12 * 16384,
{V5@Mul14,V5@Buf13}
end,
<<V5@V15:V5@V6/unit:8,V5@Buf16/bitstring>> = V5@Buf7,
{V5@V15,V5@Buf16}
end,
V5@Int17 = case V5@V3 of
_ -> {asn1_enum,V5@V3}
end,
{V5@Int17,V5@Buf4}
end,
{V5@V0,V5@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute pLMNidentity(4) with type OCTET STRING
{Term4,Bytes6} = case (Opt bsr 1) band 1 of
1 ->
begin
V6@Pad2 = bit_size(Bytes5) band 7,
<<_:V6@Pad2,V6@V0:3/binary-unit:8,V6@Buf1/bitstring>> = Bytes5,
V6@Conv4 = binary:copy(V6@V0),
{V6@Conv4,V6@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% attribute iE-Extensions(5) with type SEQUENCE OF
{Term5,Bytes7} = case Opt band 1 of
1 ->
'dec_CSGMembershipInfo_iE-Extensions'(Bytes6);
0 ->
{asn1_NOVALUE,Bytes6}
end,

%% Extensions
{Extensions,Bytes8} = case Ext of
0 -> {<<>>,Bytes7};
1 ->
{V7@V0,V7@Buf1} = case Bytes7 of
<<0:1,V7@V3:6,V7@Buf4/bitstring>> ->
V7@Add5 = V7@V3 + 1,
{V7@Add5,V7@Buf4};
<<1:1,V7@Buf2/bitstring>> ->
V7@Pad6 = bit_size(V7@Buf2) band 7,
{V7@V3,V7@Buf4} = case V7@Buf2 of
<<_:V7@Pad6,0:1,V7@V8:7,V7@Buf9/bitstring>> when V7@V8 =/= 0 ->
{V7@V8,V7@Buf9};
<<_:V7@Pad6,1:1,0:1,V7@V9:14,V7@Buf10/bitstring>> when V7@V9 =/= 0 ->
{V7@V9,V7@Buf10};
<<_:V7@Pad6,1:1,1:1,V7@V9:6,V7@Buf10/bitstring>> when V7@V9 =/= 0 ->
V7@Mul11 = V7@V9 * 16384,
{V7@Mul11,V7@Buf10}
end,
{V7@V3,V7@Buf4}
end,
<<V7@V12:V7@V0/bitstring-unit:1,V7@Buf13/bitstring>> = V7@Buf1,
{V7@V12,V7@Buf13}
end,
Bytes9= skipextensions(Bytes8, 1, Extensions),
Res1 = {'CSGMembershipInfo',Term1,Term2,Term3,Term4,Term5},
{Res1,Bytes9}.


'dec_CSGMembershipInfo_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components331(V1@Add4, V1@Buf1, []).


'dec_CSGMembershipInfo_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension12(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABModificationConfirm'(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
'enc_E-RABModificationConfirm_protocolIEs'(Enc2@element)
end].
'enc_E-RABModificationConfirm_protocolIEs'(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_E-RABModificationConfirm_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABModificationConfirm_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value332(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABModificationConfirm'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = 'dec_E-RABModificationConfirm_protocolIEs'(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'E-RABModificationConfirm',Term1},
{Res1,Bytes4}.


'dec_E-RABModificationConfirm_protocolIEs'(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components333(V1@V0, V1@Buf1, []).


'dec_E-RABModificationConfirm_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value334(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABModifyListBearerModConf'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABModifyListBearerModConf_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABModifyListBearerModConf_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value335(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABModifyListBearerModConf'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components336(V1@Add4, V1@Buf1, []).


'dec_E-RABModifyListBearerModConf_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value337(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABModifyItemBearerModConf'(Val) ->
[begin
Enc1@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 4 =:= 0 ->
<<0:1,Enc3@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc3@element)]
end
end|begin
%% attribute iE-Extensions(2) with type SEQUENCE OF
Enc5@element = element(3, Val),
if Enc5@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABModifyItemBearerModConf_iE-Extensions'(Enc5@element)
end
end].
'enc_E-RABModifyItemBearerModConf_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABModifyItemBearerModConf_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABModifyItemBearerModConf_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension10(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABModifyItemBearerModConf'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute iE-Extensions(2) with type SEQUENCE OF
{Term2,Bytes4} = case Opt band 1 of
1 ->
'dec_E-RABModifyItemBearerModConf_iE-Extensions'(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V4@V0,V4@Buf1} = case Bytes4 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
V4@Mul11 = V4@V9 * 16384,
{V4@Mul11,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V12:V4@V0/bitstring-unit:1,V4@Buf13/bitstring>> = V4@Buf1,
{V4@V12,V4@Buf13}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
Res1 = {'E-RABModifyItemBearerModConf',Term1,Term2},
{Res1,Bytes6}.


'dec_E-RABModifyItemBearerModConf_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components338(V1@Add4, V1@Buf1, []).


'dec_E-RABModifyItemBearerModConf_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension12(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UEContextModificationIndication(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UEContextModificationIndication_protocolIEs(Enc2@element)
end].
enc_UEContextModificationIndication_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UEContextModificationIndication_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UEContextModificationIndication_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value339(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UEContextModificationIndication(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UEContextModificationIndication_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UEContextModificationIndication',Term1},
{Res1,Bytes4}.


dec_UEContextModificationIndication_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components340(V1@V0, V1@Buf1, []).


'dec_UEContextModificationIndication_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value341(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UEContextModificationConfirm(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UEContextModificationConfirm_protocolIEs(Enc2@element)
end].
enc_UEContextModificationConfirm_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UEContextModificationConfirm_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UEContextModificationConfirm_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value342(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UEContextModificationConfirm(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UEContextModificationConfirm_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UEContextModificationConfirm',Term1},
{Res1,Bytes4}.


dec_UEContextModificationConfirm_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components343(V1@V0, V1@Buf1, []).


'dec_UEContextModificationConfirm_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value344(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UEContextSuspendRequest(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UEContextSuspendRequest_protocolIEs(Enc2@element)
end].
enc_UEContextSuspendRequest_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UEContextSuspendRequest_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UEContextSuspendRequest_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value345(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UEContextSuspendRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UEContextSuspendRequest_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UEContextSuspendRequest',Term1},
{Res1,Bytes4}.


dec_UEContextSuspendRequest_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components346(V1@V0, V1@Buf1, []).


'dec_UEContextSuspendRequest_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value347(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UEContextSuspendResponse(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UEContextSuspendResponse_protocolIEs(Enc2@element)
end].
enc_UEContextSuspendResponse_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UEContextSuspendResponse_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UEContextSuspendResponse_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value348(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UEContextSuspendResponse(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UEContextSuspendResponse_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UEContextSuspendResponse',Term1},
{Res1,Bytes4}.


dec_UEContextSuspendResponse_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components349(V1@V0, V1@Buf1, []).


'dec_UEContextSuspendResponse_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value350(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UEContextResumeRequest(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UEContextResumeRequest_protocolIEs(Enc2@element)
end].
enc_UEContextResumeRequest_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UEContextResumeRequest_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UEContextResumeRequest_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value351(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UEContextResumeRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UEContextResumeRequest_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UEContextResumeRequest',Term1},
{Res1,Bytes4}.


dec_UEContextResumeRequest_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components352(V1@V0, V1@Buf1, []).


'dec_UEContextResumeRequest_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value353(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABFailedToResumeListResumeReq'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABFailedToResumeListResumeReq_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABFailedToResumeListResumeReq_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value354(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABFailedToResumeListResumeReq'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components355(V1@Add4, V1@Buf1, []).


'dec_E-RABFailedToResumeListResumeReq_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value356(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABFailedToResumeItemResumeReq'(Val) ->
[begin
Enc1@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 4 =:= 0 ->
<<0:1,Enc3@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc3@element)]
end
end,
begin
%% attribute cause(2) with type Cause
Enc5@element = element(3, Val),
'S1AP-IEs':enc_Cause(Enc5@element)
end|begin
%% attribute iE-Extensions(3) with type SEQUENCE OF
Enc6@element = element(4, Val),
if Enc6@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABFailedToResumeItemResumeReq_iE-Extensions'(Enc6@element)
end
end].
'enc_E-RABFailedToResumeItemResumeReq_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABFailedToResumeItemResumeReq_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABFailedToResumeItemResumeReq_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension10(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABFailedToResumeItemResumeReq'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute cause(2) with type Cause
{Term2,Bytes4} = 'S1AP-IEs':dec_Cause(Bytes3),

%% attribute iE-Extensions(3) with type SEQUENCE OF
{Term3,Bytes5} = case Opt band 1 of
1 ->
'dec_E-RABFailedToResumeItemResumeReq_iE-Extensions'(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V4@V0,V4@Buf1} = case Bytes5 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
V4@Mul11 = V4@V9 * 16384,
{V4@Mul11,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V12:V4@V0/bitstring-unit:1,V4@Buf13/bitstring>> = V4@Buf1,
{V4@V12,V4@Buf13}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'E-RABFailedToResumeItemResumeReq',Term1,Term2,Term3},
{Res1,Bytes7}.


'dec_E-RABFailedToResumeItemResumeReq_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components357(V1@Add4, V1@Buf1, []).


'dec_E-RABFailedToResumeItemResumeReq_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension12(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UEContextResumeResponse(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UEContextResumeResponse_protocolIEs(Enc2@element)
end].
enc_UEContextResumeResponse_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UEContextResumeResponse_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UEContextResumeResponse_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value358(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UEContextResumeResponse(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UEContextResumeResponse_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UEContextResumeResponse',Term1},
{Res1,Bytes4}.


dec_UEContextResumeResponse_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components359(V1@V0, V1@Buf1, []).


'dec_UEContextResumeResponse_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value360(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABFailedToResumeListResumeRes'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 8 =:= 0 ->
[align,
Enc1@len@sub|['enc_E-RABFailedToResumeListResumeRes_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_E-RABFailedToResumeListResumeRes_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value361(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABFailedToResumeListResumeRes'(Bytes) ->
%% Length with constraint {1,256}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components362(V1@Add4, V1@Buf1, []).


'dec_E-RABFailedToResumeListResumeRes_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value363(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

'enc_E-RABFailedToResumeItemResumeRes'(Val) ->
[begin
Enc1@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute e-RAB-ID(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 4 =:= 0 ->
<<0:1,Enc3@element:4>>;
true ->
[<<1:1>>,
align|encode_unconstrained_number(Enc3@element)]
end
end,
begin
%% attribute cause(2) with type Cause
Enc5@element = element(3, Val),
'S1AP-IEs':enc_Cause(Enc5@element)
end|begin
%% attribute iE-Extensions(3) with type SEQUENCE OF
Enc6@element = element(4, Val),
if Enc6@element =:= asn1_NOVALUE ->
[];
true ->
'enc_E-RABFailedToResumeItemResumeRes_iE-Extensions'(Enc6@element)
end
end].
'enc_E-RABFailedToResumeItemResumeRes_iE-Extensions'(Val) ->
Enc1@len = length(Val),
Enc1@len@sub = Enc1@len - 1,
if 0 =< Enc1@len@sub, Enc1@len@sub < 65535 ->
[align,
<<Enc1@len@sub:16>>|['enc_E-RABFailedToResumeItemResumeRes_iE-Extensions_ProtocolExtensionField'(Comp) || Comp <- Val]]
end.

'enc_E-RABFailedToResumeItemResumeRes_iE-Extensions_ProtocolExtensionField'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute extensionValue(3) with type Extension
Enc6@element = element(4, Val),
Enc7@output = enc_os_Extension10(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


'dec_E-RABFailedToResumeItemResumeRes'(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute e-RAB-ID(1) with type INTEGER
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:4/unsigned-unit:1,V3@Buf4/bitstring>> ->
{V3@V3,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
<<V3@V12:V3@V3/signed-unit:8,V3@Buf13/bitstring>> = V3@Buf4,
{V3@V12,V3@Buf13}
end,
{V3@V0,V3@Buf1}
end,

%% attribute cause(2) with type Cause
{Term2,Bytes4} = 'S1AP-IEs':dec_Cause(Bytes3),

%% attribute iE-Extensions(3) with type SEQUENCE OF
{Term3,Bytes5} = case Opt band 1 of
1 ->
'dec_E-RABFailedToResumeItemResumeRes_iE-Extensions'(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V4@V0,V4@Buf1} = case Bytes5 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
V4@Mul11 = V4@V9 * 16384,
{V4@Mul11,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V12:V4@V0/bitstring-unit:1,V4@Buf13/bitstring>> = V4@Buf1,
{V4@V12,V4@Buf13}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'E-RABFailedToResumeItemResumeRes',Term1,Term2,Term3},
{Res1,Bytes7}.


'dec_E-RABFailedToResumeItemResumeRes_iE-Extensions'(Bytes) ->
%% Length with constraint {1,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Add4 = V1@V0 + 1,
dec_components364(V1@Add4, V1@Buf1, []).


'dec_E-RABFailedToResumeItemResumeRes_iE-Extensions_ProtocolExtensionField'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute extensionValue(3) with type Extension
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Extension12(Tmpterm1, Term1),
Res1 = {'ProtocolExtensionField',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UEContextResumeFailure(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UEContextResumeFailure_protocolIEs(Enc2@element)
end].
enc_UEContextResumeFailure_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UEContextResumeFailure_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UEContextResumeFailure_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value365(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UEContextResumeFailure(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UEContextResumeFailure_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UEContextResumeFailure',Term1},
{Res1,Bytes4}.


dec_UEContextResumeFailure_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components366(V1@V0, V1@Buf1, []).


'dec_UEContextResumeFailure_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value367(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_ConnectionEstablishmentIndication(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_ConnectionEstablishmentIndication_protocolIEs(Enc2@element)
end].
enc_ConnectionEstablishmentIndication_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_ConnectionEstablishmentIndication_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_ConnectionEstablishmentIndication_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value368(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_ConnectionEstablishmentIndication(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_ConnectionEstablishmentIndication_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'ConnectionEstablishmentIndication',Term1},
{Res1,Bytes4}.


dec_ConnectionEstablishmentIndication_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components369(V1@V0, V1@Buf1, []).


'dec_ConnectionEstablishmentIndication_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value370(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_RetrieveUEInformation(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_RetrieveUEInformation_protocolIEs(Enc2@element)
end].
enc_RetrieveUEInformation_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_RetrieveUEInformation_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_RetrieveUEInformation_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value371(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_RetrieveUEInformation(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_RetrieveUEInformation_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'RetrieveUEInformation',Term1},
{Res1,Bytes4}.


dec_RetrieveUEInformation_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components372(V1@V0, V1@Buf1, []).


'dec_RetrieveUEInformation_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value373(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UEInformationTransfer(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UEInformationTransfer_protocolIEs(Enc2@element)
end].
enc_UEInformationTransfer_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UEInformationTransfer_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UEInformationTransfer_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value374(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UEInformationTransfer(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UEInformationTransfer_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UEInformationTransfer',Term1},
{Res1,Bytes4}.


dec_UEInformationTransfer_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components375(V1@V0, V1@Buf1, []).


'dec_UEInformationTransfer_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value376(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_ENBCPRelocationIndication(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_ENBCPRelocationIndication_protocolIEs(Enc2@element)
end].
enc_ENBCPRelocationIndication_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_ENBCPRelocationIndication_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_ENBCPRelocationIndication_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value377(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_ENBCPRelocationIndication(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_ENBCPRelocationIndication_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'ENBCPRelocationIndication',Term1},
{Res1,Bytes4}.


dec_ENBCPRelocationIndication_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components378(V1@V0, V1@Buf1, []).


'dec_ENBCPRelocationIndication_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value379(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_MMECPRelocationIndication(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_MMECPRelocationIndication_protocolIEs(Enc2@element)
end].
enc_MMECPRelocationIndication_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_MMECPRelocationIndication_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_MMECPRelocationIndication_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value380(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_MMECPRelocationIndication(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_MMECPRelocationIndication_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'MMECPRelocationIndication',Term1},
{Res1,Bytes4}.


dec_MMECPRelocationIndication_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components381(V1@V0, V1@Buf1, []).


'dec_MMECPRelocationIndication_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value382(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_SecondaryRATDataUsageReport(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_SecondaryRATDataUsageReport_protocolIEs(Enc2@element)
end].
enc_SecondaryRATDataUsageReport_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_SecondaryRATDataUsageReport_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_SecondaryRATDataUsageReport_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value383(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_SecondaryRATDataUsageReport(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_SecondaryRATDataUsageReport_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'SecondaryRATDataUsageReport',Term1},
{Res1,Bytes4}.


dec_SecondaryRATDataUsageReport_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components384(V1@V0, V1@Buf1, []).


'dec_SecondaryRATDataUsageReport_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value385(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UERadioCapabilityIDMappingRequest(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UERadioCapabilityIDMappingRequest_protocolIEs(Enc2@element)
end].
enc_UERadioCapabilityIDMappingRequest_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UERadioCapabilityIDMappingRequest_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UERadioCapabilityIDMappingRequest_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value386(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UERadioCapabilityIDMappingRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UERadioCapabilityIDMappingRequest_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UERadioCapabilityIDMappingRequest',Term1},
{Res1,Bytes4}.


dec_UERadioCapabilityIDMappingRequest_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components387(V1@V0, V1@Buf1, []).


'dec_UERadioCapabilityIDMappingRequest_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value388(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UERadioCapabilityIDMappingResponse(Val) ->
[<<0:1>>|begin
%% attribute protocolIEs(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_UERadioCapabilityIDMappingResponse_protocolIEs(Enc2@element)
end].
enc_UERadioCapabilityIDMappingResponse_protocolIEs(Val) ->
Enc1@len = length(Val),
if Enc1@len < 65536 ->
[align,
<<Enc1@len:16>>|['enc_UERadioCapabilityIDMappingResponse_protocolIEs_ProtocolIE-Field'(Comp) || Comp <- Val]]
end.

'enc_UERadioCapabilityIDMappingResponse_protocolIEs_ProtocolIE-Field'(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute id(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type Value
Enc6@element = element(4, Val),
Enc7@output = enc_os_Value389(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UERadioCapabilityIDMappingResponse(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute protocolIEs(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_UERadioCapabilityIDMappingResponse_protocolIEs(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'UERadioCapabilityIDMappingResponse',Term1},
{Res1,Bytes4}.


dec_UERadioCapabilityIDMappingResponse_protocolIEs(Bytes) ->
%% Length with constraint {0,65535}
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
dec_components390(V1@V0, V1@Buf1, []).


'dec_UERadioCapabilityIDMappingResponse_protocolIEs_ProtocolIE-Field'(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type Value
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_Value391(Tmpterm1, Term1),
Res1 = {'ProtocolIE-Field',Term1,Term2,Term3},
{Res1,Bytes3}.


%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    _ = complete(element(1, Arg)),
    ok.

dec_components100(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components100(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABToBeModifiedListBearerModReq_ProtocolIE-Field'(Bytes),
dec_components100(Num-1, Remain, [Term|Acc]).

dec_components103(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components103(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABToBeModifiedItemBearerModReq_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components103(Num-1, Remain, [Term|Acc]).

dec_components106(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components106(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABModifyResponse_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components106(Num-1, Remain, [Term|Acc]).

dec_components109(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components109(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABModifyListBearerModRes_ProtocolIE-Field'(Bytes),
dec_components109(Num-1, Remain, [Term|Acc]).

dec_components11(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components11(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABDataForwardingItem_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components11(Num-1, Remain, [Term|Acc]).

dec_components111(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components111(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABModifyItemBearerModRes_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components111(Num-1, Remain, [Term|Acc]).

dec_components113(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components113(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABReleaseCommand_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components113(Num-1, Remain, [Term|Acc]).

dec_components116(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components116(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABReleaseResponse_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components116(Num-1, Remain, [Term|Acc]).

dec_components119(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components119(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABReleaseListBearerRelComp_ProtocolIE-Field'(Bytes),
dec_components119(Num-1, Remain, [Term|Acc]).

dec_components121(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components121(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABReleaseItemBearerRelComp_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components121(Num-1, Remain, [Term|Acc]).

dec_components123(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components123(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABReleaseIndication_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components123(Num-1, Remain, [Term|Acc]).

dec_components126(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components126(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_InitialContextSetupRequest_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components126(Num-1, Remain, [Term|Acc]).

dec_components129(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components129(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABToBeSetupListCtxtSUReq_ProtocolIE-Field'(Bytes),
dec_components129(Num-1, Remain, [Term|Acc]).

dec_components132(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components132(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABToBeSetupItemCtxtSUReq_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components132(Num-1, Remain, [Term|Acc]).

dec_components135(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components135(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_InitialContextSetupResponse_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components135(Num-1, Remain, [Term|Acc]).

dec_components138(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components138(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABSetupListCtxtSURes_ProtocolIE-Field'(Bytes),
dec_components138(Num-1, Remain, [Term|Acc]).

dec_components14(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components14(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_HandoverPreparationFailure_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components14(Num-1, Remain, [Term|Acc]).

dec_components140(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components140(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABSetupItemCtxtSURes_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components140(Num-1, Remain, [Term|Acc]).

dec_components142(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components142(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_InitialContextSetupFailure_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components142(Num-1, Remain, [Term|Acc]).

dec_components145(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components145(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_Paging_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components145(Num-1, Remain, [Term|Acc]).

dec_components148(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components148(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_TAIList_ProtocolIE-Field'(Bytes),
dec_components148(Num-1, Remain, [Term|Acc]).

dec_components150(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components150(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_TAIItem_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components150(Num-1, Remain, [Term|Acc]).

dec_components152(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components152(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UEContextReleaseRequest_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components152(Num-1, Remain, [Term|Acc]).

dec_components155(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components155(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UEContextReleaseCommand_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components155(Num-1, Remain, [Term|Acc]).

dec_components158(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components158(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UEContextReleaseComplete_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components158(Num-1, Remain, [Term|Acc]).

dec_components161(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components161(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UEContextModificationRequest_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components161(Num-1, Remain, [Term|Acc]).

dec_components164(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components164(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UEContextModificationResponse_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components164(Num-1, Remain, [Term|Acc]).

dec_components167(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components167(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UEContextModificationFailure_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components167(Num-1, Remain, [Term|Acc]).

dec_components17(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components17(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_HandoverRequest_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components17(Num-1, Remain, [Term|Acc]).

dec_components170(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components170(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UERadioCapabilityMatchRequest_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components170(Num-1, Remain, [Term|Acc]).

dec_components173(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components173(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UERadioCapabilityMatchResponse_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components173(Num-1, Remain, [Term|Acc]).

dec_components176(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components176(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_DownlinkNASTransport_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components176(Num-1, Remain, [Term|Acc]).

dec_components179(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components179(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_InitialUEMessage_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components179(Num-1, Remain, [Term|Acc]).

dec_components182(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components182(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UplinkNASTransport_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components182(Num-1, Remain, [Term|Acc]).

dec_components185(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components185(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_NASNonDeliveryIndication_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components185(Num-1, Remain, [Term|Acc]).

dec_components188(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components188(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_RerouteNASRequest_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components188(Num-1, Remain, [Term|Acc]).

dec_components191(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components191(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_NASDeliveryIndication_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components191(Num-1, Remain, [Term|Acc]).

dec_components194(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components194(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_Reset_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components194(Num-1, Remain, [Term|Acc]).

dec_components197(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components197(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UE-associatedLogicalS1-ConnectionListRes_ProtocolIE-Field'(Bytes),
dec_components197(Num-1, Remain, [Term|Acc]).

dec_components2(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components2(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_HandoverRequired_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components2(Num-1, Remain, [Term|Acc]).

dec_components20(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components20(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABToBeSetupListHOReq_ProtocolIE-Field'(Bytes),
dec_components20(Num-1, Remain, [Term|Acc]).

dec_components200(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components200(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_ResetAcknowledge_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components200(Num-1, Remain, [Term|Acc]).

dec_components203(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components203(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UE-associatedLogicalS1-ConnectionListResAck_ProtocolIE-Field'(Bytes),
dec_components203(Num-1, Remain, [Term|Acc]).

dec_components206(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components206(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_ErrorIndication_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components206(Num-1, Remain, [Term|Acc]).

dec_components209(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components209(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_S1SetupRequest_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components209(Num-1, Remain, [Term|Acc]).

dec_components212(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components212(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_S1SetupResponse_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components212(Num-1, Remain, [Term|Acc]).

dec_components215(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components215(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_S1SetupFailure_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components215(Num-1, Remain, [Term|Acc]).

dec_components218(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components218(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_ENBConfigurationUpdate_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components218(Num-1, Remain, [Term|Acc]).

dec_components221(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components221(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_ENBConfigurationUpdateAcknowledge_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components221(Num-1, Remain, [Term|Acc]).

dec_components224(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components224(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_ENBConfigurationUpdateFailure_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components224(Num-1, Remain, [Term|Acc]).

dec_components227(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components227(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_MMEConfigurationUpdate_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components227(Num-1, Remain, [Term|Acc]).

dec_components23(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components23(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABToBeSetupItemHOReq_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components23(Num-1, Remain, [Term|Acc]).

dec_components230(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components230(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_MMEConfigurationUpdateAcknowledge_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components230(Num-1, Remain, [Term|Acc]).

dec_components233(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components233(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_MMEConfigurationUpdateFailure_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components233(Num-1, Remain, [Term|Acc]).

dec_components236(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components236(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_DownlinkS1cdma2000tunnelling_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components236(Num-1, Remain, [Term|Acc]).

dec_components239(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components239(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UplinkS1cdma2000tunnelling_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components239(Num-1, Remain, [Term|Acc]).

dec_components242(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components242(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UECapabilityInfoIndication_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components242(Num-1, Remain, [Term|Acc]).

dec_components245(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components245(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_ENBStatusTransfer_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components245(Num-1, Remain, [Term|Acc]).

dec_components248(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components248(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_MMEStatusTransfer_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components248(Num-1, Remain, [Term|Acc]).

dec_components251(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components251(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_TraceStart_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components251(Num-1, Remain, [Term|Acc]).

dec_components254(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components254(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_TraceFailureIndication_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components254(Num-1, Remain, [Term|Acc]).

dec_components257(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components257(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_DeactivateTrace_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components257(Num-1, Remain, [Term|Acc]).

dec_components26(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components26(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_HandoverRequestAcknowledge_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components26(Num-1, Remain, [Term|Acc]).

dec_components260(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components260(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_CellTrafficTrace_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components260(Num-1, Remain, [Term|Acc]).

dec_components263(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components263(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_LocationReportingControl_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components263(Num-1, Remain, [Term|Acc]).

dec_components266(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components266(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_LocationReportingFailureIndication_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components266(Num-1, Remain, [Term|Acc]).

dec_components269(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components269(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_LocationReport_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components269(Num-1, Remain, [Term|Acc]).

dec_components272(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components272(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_OverloadStart_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components272(Num-1, Remain, [Term|Acc]).

dec_components275(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components275(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_OverloadStop_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components275(Num-1, Remain, [Term|Acc]).

dec_components278(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components278(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_WriteReplaceWarningRequest_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components278(Num-1, Remain, [Term|Acc]).

dec_components281(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components281(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_WriteReplaceWarningResponse_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components281(Num-1, Remain, [Term|Acc]).

dec_components284(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components284(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_ENBDirectInformationTransfer_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components284(Num-1, Remain, [Term|Acc]).

dec_components287(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components287(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_MMEDirectInformationTransfer_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components287(Num-1, Remain, [Term|Acc]).

dec_components29(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components29(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABAdmittedList_ProtocolIE-Field'(Bytes),
dec_components29(Num-1, Remain, [Term|Acc]).

dec_components290(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components290(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_ENBConfigurationTransfer_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components290(Num-1, Remain, [Term|Acc]).

dec_components293(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components293(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_MMEConfigurationTransfer_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components293(Num-1, Remain, [Term|Acc]).

dec_components295(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components295(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_PrivateMessage_privateIEs_PrivateIE-Field'(Bytes),
dec_components295(Num-1, Remain, [Term|Acc]).

dec_components297(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components297(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_KillRequest_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components297(Num-1, Remain, [Term|Acc]).

dec_components300(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components300(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_KillResponse_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components300(Num-1, Remain, [Term|Acc]).

dec_components303(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components303(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_PWSRestartIndication_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components303(Num-1, Remain, [Term|Acc]).

dec_components306(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components306(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_PWSFailureIndication_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components306(Num-1, Remain, [Term|Acc]).

dec_components309(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components309(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_DownlinkUEAssociatedLPPaTransport_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components309(Num-1, Remain, [Term|Acc]).

dec_components31(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components31(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABAdmittedItem_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components31(Num-1, Remain, [Term|Acc]).

dec_components312(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components312(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UplinkUEAssociatedLPPaTransport_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components312(Num-1, Remain, [Term|Acc]).

dec_components315(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components315(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_DownlinkNonUEAssociatedLPPaTransport_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components315(Num-1, Remain, [Term|Acc]).

dec_components318(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components318(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UplinkNonUEAssociatedLPPaTransport_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components318(Num-1, Remain, [Term|Acc]).

dec_components321(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components321(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABModificationIndication_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components321(Num-1, Remain, [Term|Acc]).

dec_components324(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components324(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABToBeModifiedListBearerModInd_ProtocolIE-Field'(Bytes),
dec_components324(Num-1, Remain, [Term|Acc]).

dec_components326(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components326(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABToBeModifiedItemBearerModInd_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components326(Num-1, Remain, [Term|Acc]).

dec_components328(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components328(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABNotToBeModifiedListBearerModInd_ProtocolIE-Field'(Bytes),
dec_components328(Num-1, Remain, [Term|Acc]).

dec_components33(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components33(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABFailedtoSetupListHOReqAck_ProtocolIE-Field'(Bytes),
dec_components33(Num-1, Remain, [Term|Acc]).

dec_components330(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components330(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABNotToBeModifiedItemBearerModInd_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components330(Num-1, Remain, [Term|Acc]).

dec_components331(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components331(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_CSGMembershipInfo_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components331(Num-1, Remain, [Term|Acc]).

dec_components333(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components333(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABModificationConfirm_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components333(Num-1, Remain, [Term|Acc]).

dec_components336(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components336(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABModifyListBearerModConf_ProtocolIE-Field'(Bytes),
dec_components336(Num-1, Remain, [Term|Acc]).

dec_components338(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components338(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABModifyItemBearerModConf_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components338(Num-1, Remain, [Term|Acc]).

dec_components340(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components340(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UEContextModificationIndication_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components340(Num-1, Remain, [Term|Acc]).

dec_components343(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components343(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UEContextModificationConfirm_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components343(Num-1, Remain, [Term|Acc]).

dec_components346(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components346(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UEContextSuspendRequest_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components346(Num-1, Remain, [Term|Acc]).

dec_components349(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components349(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UEContextSuspendResponse_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components349(Num-1, Remain, [Term|Acc]).

dec_components35(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components35(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABFailedToSetupItemHOReqAck_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components35(Num-1, Remain, [Term|Acc]).

dec_components352(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components352(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UEContextResumeRequest_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components352(Num-1, Remain, [Term|Acc]).

dec_components355(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components355(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABFailedToResumeListResumeReq_ProtocolIE-Field'(Bytes),
dec_components355(Num-1, Remain, [Term|Acc]).

dec_components357(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components357(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABFailedToResumeItemResumeReq_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components357(Num-1, Remain, [Term|Acc]).

dec_components359(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components359(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UEContextResumeResponse_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components359(Num-1, Remain, [Term|Acc]).

dec_components362(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components362(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABFailedToResumeListResumeRes_ProtocolIE-Field'(Bytes),
dec_components362(Num-1, Remain, [Term|Acc]).

dec_components364(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components364(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABFailedToResumeItemResumeRes_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components364(Num-1, Remain, [Term|Acc]).

dec_components366(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components366(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UEContextResumeFailure_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components366(Num-1, Remain, [Term|Acc]).

dec_components369(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components369(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_ConnectionEstablishmentIndication_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components369(Num-1, Remain, [Term|Acc]).

dec_components37(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components37(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_HandoverFailure_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components37(Num-1, Remain, [Term|Acc]).

dec_components372(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components372(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_RetrieveUEInformation_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components372(Num-1, Remain, [Term|Acc]).

dec_components375(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components375(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UEInformationTransfer_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components375(Num-1, Remain, [Term|Acc]).

dec_components378(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components378(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_ENBCPRelocationIndication_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components378(Num-1, Remain, [Term|Acc]).

dec_components381(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components381(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_MMECPRelocationIndication_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components381(Num-1, Remain, [Term|Acc]).

dec_components384(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components384(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_SecondaryRATDataUsageReport_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components384(Num-1, Remain, [Term|Acc]).

dec_components387(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components387(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UERadioCapabilityIDMappingRequest_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components387(Num-1, Remain, [Term|Acc]).

dec_components390(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components390(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_UERadioCapabilityIDMappingResponse_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components390(Num-1, Remain, [Term|Acc]).

dec_components40(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components40(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_HandoverNotify_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components40(Num-1, Remain, [Term|Acc]).

dec_components43(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components43(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_PathSwitchRequest_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components43(Num-1, Remain, [Term|Acc]).

dec_components46(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components46(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABToBeSwitchedDLList_ProtocolIE-Field'(Bytes),
dec_components46(Num-1, Remain, [Term|Acc]).

dec_components49(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components49(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABToBeSwitchedDLItem_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components49(Num-1, Remain, [Term|Acc]).

dec_components5(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components5(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_HandoverCommand_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components5(Num-1, Remain, [Term|Acc]).

dec_components52(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components52(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_PathSwitchRequestAcknowledge_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components52(Num-1, Remain, [Term|Acc]).

dec_components55(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components55(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABToBeSwitchedULList_ProtocolIE-Field'(Bytes),
dec_components55(Num-1, Remain, [Term|Acc]).

dec_components57(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components57(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABToBeSwitchedULItem_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components57(Num-1, Remain, [Term|Acc]).

dec_components59(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components59(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABToBeUpdatedList_ProtocolIE-Field'(Bytes),
dec_components59(Num-1, Remain, [Term|Acc]).

dec_components61(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components61(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABToBeUpdatedItem_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components61(Num-1, Remain, [Term|Acc]).

dec_components63(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components63(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_PathSwitchRequestFailure_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components63(Num-1, Remain, [Term|Acc]).

dec_components66(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components66(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_HandoverCancel_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components66(Num-1, Remain, [Term|Acc]).

dec_components69(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components69(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_HandoverCancelAcknowledge_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components69(Num-1, Remain, [Term|Acc]).

dec_components72(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components72(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_HandoverSuccess_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components72(Num-1, Remain, [Term|Acc]).

dec_components75(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components75(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_ENBEarlyStatusTransfer_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components75(Num-1, Remain, [Term|Acc]).

dec_components78(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components78(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_MMEEarlyStatusTransfer_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components78(Num-1, Remain, [Term|Acc]).

dec_components8(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components8(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABSubjecttoDataForwardingList_ProtocolIE-Field'(Bytes),
dec_components8(Num-1, Remain, [Term|Acc]).

dec_components81(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components81(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABSetupRequest_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components81(Num-1, Remain, [Term|Acc]).

dec_components84(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components84(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABToBeSetupListBearerSUReq_ProtocolIE-Field'(Bytes),
dec_components84(Num-1, Remain, [Term|Acc]).

dec_components87(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components87(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABToBeSetupItemBearerSUReq_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components87(Num-1, Remain, [Term|Acc]).

dec_components90(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components90(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABSetupResponse_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components90(Num-1, Remain, [Term|Acc]).

dec_components93(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components93(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABSetupListBearerSURes_ProtocolIE-Field'(Bytes),
dec_components93(Num-1, Remain, [Term|Acc]).

dec_components95(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components95(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABSetupItemBearerSURes_iE-Extensions_ProtocolExtensionField'(Bytes),
dec_components95(Num-1, Remain, [Term|Acc]).

dec_components97(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components97(Num, Bytes, Acc) ->
{Term,Remain} = 'dec_E-RABModifyRequest_protocolIEs_ProtocolIE-Field'(Bytes),
dec_components97(Num-1, Remain, [Term|Acc]).

dec_os_Extension104(Bytes, Id) when Id =:= 185 ->
{Term,_} = 'S1AP-IEs':dec_TransportInformation(Bytes),
Term;
dec_os_Extension104(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Extension12(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Extension133(Bytes, Id) when Id =:= 156 ->
{Term,_} = 'S1AP-IEs':'dec_Correlation-ID'(Bytes),
Term;
dec_os_Extension133(Bytes, Id) when Id =:= 183 ->
{Term,_} = 'S1AP-IEs':'dec_Correlation-ID'(Bytes),
Term;
dec_os_Extension133(Bytes, Id) when Id =:= 233 ->
{Term,_} = 'S1AP-IEs':dec_BearerType(Bytes),
Term;
dec_os_Extension133(Bytes, Id) when Id =:= 305 ->
{Term,_} = 'S1AP-IEs':'dec_Ethernet-Type'(Bytes),
Term;
dec_os_Extension133(Bytes, Id) when Id =:= 332 ->
{Term,_} = 'S1AP-IEs':dec_SecurityIndication(Bytes),
Term;
dec_os_Extension133(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Extension24(Bytes, Id) when Id =:= 143 ->
{Term,_} = 'S1AP-IEs':'dec_Data-Forwarding-Not-Possible'(Bytes),
Term;
dec_os_Extension24(Bytes, Id) when Id =:= 233 ->
{Term,_} = 'S1AP-IEs':dec_BearerType(Bytes),
Term;
dec_os_Extension24(Bytes, Id) when Id =:= 305 ->
{Term,_} = 'S1AP-IEs':'dec_Ethernet-Type'(Bytes),
Term;
dec_os_Extension24(Bytes, Id) when Id =:= 332 ->
{Term,_} = 'S1AP-IEs':dec_SecurityIndication(Bytes),
Term;
dec_os_Extension24(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Extension50(Bytes, Id) when Id =:= 332 ->
{Term,_} = 'S1AP-IEs':dec_SecurityIndication(Bytes),
Term;
dec_os_Extension50(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Extension88(Bytes, Id) when Id =:= 156 ->
{Term,_} = 'S1AP-IEs':'dec_Correlation-ID'(Bytes),
Term;
dec_os_Extension88(Bytes, Id) when Id =:= 183 ->
{Term,_} = 'S1AP-IEs':'dec_Correlation-ID'(Bytes),
Term;
dec_os_Extension88(Bytes, Id) when Id =:= 233 ->
{Term,_} = 'S1AP-IEs':dec_BearerType(Bytes),
Term;
dec_os_Extension88(Bytes, Id) when Id =:= 305 ->
{Term,_} = 'S1AP-IEs':'dec_Ethernet-Type'(Bytes),
Term;
dec_os_Extension88(Bytes, Id) when Id =:= 332 ->
{Term,_} = 'S1AP-IEs':dec_SecurityIndication(Bytes),
Term;
dec_os_Extension88(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value101(Bytes, Id) when Id =:= 36 ->
{Term,_} = 'dec_E-RABToBeModifiedItemBearerModReq'(Bytes),
Term;
dec_os_Value101(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value107(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value107(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value107(Bytes, Id) when Id =:= 31 ->
{Term,_} = 'dec_E-RABModifyListBearerModRes'(Bytes),
Term;
dec_os_Value107(Bytes, Id) when Id =:= 32 ->
{Term,_} = 'S1AP-IEs':'dec_E-RABList'(Bytes),
Term;
dec_os_Value107(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value107(Bytes, Id) when Id =:= 189 ->
{Term,_} = 'S1AP-IEs':dec_UserLocationInformation(Bytes),
Term;
dec_os_Value107(Bytes, Id) when Id =:= 264 ->
{Term,_} = 'S1AP-IEs':dec_SecondaryRATDataUsageReportList(Bytes),
Term;
dec_os_Value107(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value110(Bytes, Id) when Id =:= 37 ->
{Term,_} = 'dec_E-RABModifyItemBearerModRes'(Bytes),
Term;
dec_os_Value110(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value114(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value114(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value114(Bytes, Id) when Id =:= 26 ->
{Term,_} = 'S1AP-IEs':'dec_NAS-PDU'(Bytes),
Term;
dec_os_Value114(Bytes, Id) when Id =:= 33 ->
{Term,_} = 'S1AP-IEs':'dec_E-RABList'(Bytes),
Term;
dec_os_Value114(Bytes, Id) when Id =:= 66 ->
{Term,_} = 'S1AP-IEs':dec_UEAggregateMaximumBitrate(Bytes),
Term;
dec_os_Value114(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value117(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value117(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value117(Bytes, Id) when Id =:= 34 ->
{Term,_} = 'S1AP-IEs':'dec_E-RABList'(Bytes),
Term;
dec_os_Value117(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value117(Bytes, Id) when Id =:= 69 ->
{Term,_} = 'dec_E-RABReleaseListBearerRelComp'(Bytes),
Term;
dec_os_Value117(Bytes, Id) when Id =:= 189 ->
{Term,_} = 'S1AP-IEs':dec_UserLocationInformation(Bytes),
Term;
dec_os_Value117(Bytes, Id) when Id =:= 264 ->
{Term,_} = 'S1AP-IEs':dec_SecondaryRATDataUsageReportList(Bytes),
Term;
dec_os_Value117(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value120(Bytes, Id) when Id =:= 15 ->
{Term,_} = 'dec_E-RABReleaseItemBearerRelComp'(Bytes),
Term;
dec_os_Value120(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value124(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value124(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value124(Bytes, Id) when Id =:= 110 ->
{Term,_} = 'S1AP-IEs':'dec_E-RABList'(Bytes),
Term;
dec_os_Value124(Bytes, Id) when Id =:= 189 ->
{Term,_} = 'S1AP-IEs':dec_UserLocationInformation(Bytes),
Term;
dec_os_Value124(Bytes, Id) when Id =:= 264 ->
{Term,_} = 'S1AP-IEs':dec_SecondaryRATDataUsageReportList(Bytes),
Term;
dec_os_Value124(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value127(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 24 ->
{Term,_} = 'dec_E-RABToBeSetupListCtxtSUReq'(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 25 ->
{Term,_} = 'S1AP-IEs':dec_TraceActivation(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 41 ->
{Term,_} = 'S1AP-IEs':dec_HandoverRestrictionList(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 66 ->
{Term,_} = 'S1AP-IEs':dec_UEAggregateMaximumBitrate(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 73 ->
{Term,_} = 'S1AP-IEs':dec_SecurityKey(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 74 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapability(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 75 ->
{Term,_} = 'S1AP-IEs':dec_GUMMEI(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 106 ->
{Term,_} = 'S1AP-IEs':dec_SubscriberProfileIDforRFP(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 107 ->
{Term,_} = 'S1AP-IEs':dec_UESecurityCapabilities(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 108 ->
{Term,_} = 'S1AP-IEs':dec_CSFallbackIndicator(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 124 ->
{Term,_} = 'S1AP-IEs':dec_SRVCCOperationPossible(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 146 ->
{Term,_} = 'S1AP-IEs':dec_CSGMembershipStatus(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 158 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 159 ->
{Term,_} = 'S1AP-IEs':dec_LAI(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 165 ->
{Term,_} = 'S1AP-IEs':dec_ManagementBasedMDTAllowed(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 177 ->
{Term,_} = 'S1AP-IEs':dec_MDTPLMNList(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 187 ->
{Term,_} = 'S1AP-IEs':dec_AdditionalCSFallbackIndicator(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 192 ->
{Term,_} = 'S1AP-IEs':'dec_Masked-IMEISV'(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 195 ->
{Term,_} = 'S1AP-IEs':dec_ProSeAuthorized(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 196 ->
{Term,_} = 'S1AP-IEs':dec_ExpectedUEBehaviour(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 240 ->
{Term,_} = 'S1AP-IEs':dec_V2XServicesAuthorized(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 241 ->
{Term,_} = 'S1AP-IEs':dec_UEUserPlaneCIoTSupportIndicator(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 248 ->
{Term,_} = 'S1AP-IEs':dec_UESidelinkAggregateMaximumBitrate(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 251 ->
{Term,_} = 'S1AP-IEs':dec_EnhancedCoverageRestricted(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 269 ->
{Term,_} = 'S1AP-IEs':dec_NRUESecurityCapabilities(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 271 ->
{Term,_} = 'S1AP-IEs':'dec_CE-ModeBRestricted'(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 277 ->
{Term,_} = 'S1AP-IEs':dec_AerialUEsubscriptionInformation(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 278 ->
{Term,_} = 'S1AP-IEs':'dec_Subscription-Based-UE-DifferentiationInfo'(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 283 ->
{Term,_} = 'S1AP-IEs':dec_PendingDataIndication(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 299 ->
{Term,_} = 'S1AP-IEs':dec_AdditionalRRMPriorityIndex(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 301 ->
{Term,_} = 'S1AP-IEs':'dec_IAB-Authorized'(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 306 ->
{Term,_} = 'S1AP-IEs':dec_NRV2XServicesAuthorized(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 307 ->
{Term,_} = 'S1AP-IEs':dec_NRUESidelinkAggregateMaximumBitrate(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 308 ->
{Term,_} = 'S1AP-IEs':dec_PC5QoSParameters(Bytes),
Term;
dec_os_Value127(Bytes, Id) when Id =:= 314 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapabilityID(Bytes),
Term;
dec_os_Value127(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value130(Bytes, Id) when Id =:= 52 ->
{Term,_} = 'dec_E-RABToBeSetupItemCtxtSUReq'(Bytes),
Term;
dec_os_Value130(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value136(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value136(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value136(Bytes, Id) when Id =:= 48 ->
{Term,_} = 'S1AP-IEs':'dec_E-RABList'(Bytes),
Term;
dec_os_Value136(Bytes, Id) when Id =:= 51 ->
{Term,_} = 'dec_E-RABSetupListCtxtSURes'(Bytes),
Term;
dec_os_Value136(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value136(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value139(Bytes, Id) when Id =:= 50 ->
{Term,_} = 'dec_E-RABSetupItemCtxtSURes'(Bytes),
Term;
dec_os_Value139(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value143(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value143(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value143(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value143(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value143(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value146(Bytes, Id) when Id =:= 43 ->
{Term,_} = 'S1AP-IEs':dec_UEPagingID(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 44 ->
{Term,_} = 'S1AP-IEs':dec_PagingDRX(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 46 ->
{Term,_} = dec_TAIList(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 80 ->
{Term,_} = 'S1AP-IEs':dec_UEIdentityIndexValue(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 109 ->
{Term,_} = 'S1AP-IEs':dec_CNDomain(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 128 ->
{Term,_} = 'S1AP-IEs':'dec_CSG-IdList'(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 151 ->
{Term,_} = 'S1AP-IEs':dec_PagingPriority(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 198 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapabilityForPaging(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 211 ->
{Term,_} = 'S1AP-IEs':dec_AssistanceDataForPaging(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 227 ->
{Term,_} = 'S1AP-IEs':'dec_Paging-eDRXInformation'(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 231 ->
{Term,_} = 'S1AP-IEs':'dec_Extended-UEIdentityIndexValue'(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 239 ->
{Term,_} = 'S1AP-IEs':'dec_NB-IoT-Paging-eDRXInformation'(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 244 ->
{Term,_} = 'S1AP-IEs':'dec_NB-IoT-UEIdentityIndexValue'(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 251 ->
{Term,_} = 'S1AP-IEs':dec_EnhancedCoverageRestricted(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 271 ->
{Term,_} = 'S1AP-IEs':'dec_CE-ModeBRestricted'(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 304 ->
{Term,_} = 'S1AP-IEs':dec_DataSize(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 323 ->
{Term,_} = 'S1AP-IEs':'dec_WUS-Assistance-Information'(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 324 ->
{Term,_} = 'S1AP-IEs':'dec_NB-IoT-PagingDRX'(Bytes),
Term;
dec_os_Value146(Bytes, Id) when Id =:= 331 ->
{Term,_} = 'S1AP-IEs':dec_PagingCause(Bytes),
Term;
dec_os_Value146(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value149(Bytes, Id) when Id =:= 47 ->
{Term,_} = dec_TAIItem(Bytes),
Term;
dec_os_Value149(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value15(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value15(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value15(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value15(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value15(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value153(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value153(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value153(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value153(Bytes, Id) when Id =:= 164 ->
{Term,_} = 'S1AP-IEs':dec_GWContextReleaseIndication(Bytes),
Term;
dec_os_Value153(Bytes, Id) when Id =:= 264 ->
{Term,_} = 'S1AP-IEs':dec_SecondaryRATDataUsageReportList(Bytes),
Term;
dec_os_Value153(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value156(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value156(Bytes, Id) when Id =:= 99 ->
{Term,_} = 'S1AP-IEs':'dec_UE-S1AP-IDs'(Bytes),
Term;
dec_os_Value156(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value159(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value159(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value159(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value159(Bytes, Id) when Id =:= 189 ->
{Term,_} = 'S1AP-IEs':dec_UserLocationInformation(Bytes),
Term;
dec_os_Value159(Bytes, Id) when Id =:= 212 ->
{Term,_} = 'S1AP-IEs':dec_CellIdentifierAndCELevelForCECapableUEs(Bytes),
Term;
dec_os_Value159(Bytes, Id) when Id =:= 213 ->
{Term,_} = 'S1AP-IEs':dec_InformationOnRecommendedCellsAndENBsForPaging(Bytes),
Term;
dec_os_Value159(Bytes, Id) when Id =:= 264 ->
{Term,_} = 'S1AP-IEs':dec_SecondaryRATDataUsageReportList(Bytes),
Term;
dec_os_Value159(Bytes, Id) when Id =:= 297 ->
{Term,_} = 'S1AP-IEs':dec_TimeSinceSecondaryNodeRelease(Bytes),
Term;
dec_os_Value159(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value162(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 66 ->
{Term,_} = 'S1AP-IEs':dec_UEAggregateMaximumBitrate(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 73 ->
{Term,_} = 'S1AP-IEs':dec_SecurityKey(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 106 ->
{Term,_} = 'S1AP-IEs':dec_SubscriberProfileIDforRFP(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 107 ->
{Term,_} = 'S1AP-IEs':dec_UESecurityCapabilities(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 108 ->
{Term,_} = 'S1AP-IEs':dec_CSFallbackIndicator(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 124 ->
{Term,_} = 'S1AP-IEs':dec_SRVCCOperationPossible(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 146 ->
{Term,_} = 'S1AP-IEs':dec_CSGMembershipStatus(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 159 ->
{Term,_} = 'S1AP-IEs':dec_LAI(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 187 ->
{Term,_} = 'S1AP-IEs':dec_AdditionalCSFallbackIndicator(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 195 ->
{Term,_} = 'S1AP-IEs':dec_ProSeAuthorized(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 240 ->
{Term,_} = 'S1AP-IEs':dec_V2XServicesAuthorized(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 243 ->
{Term,_} = 'S1AP-IEs':dec_SRVCCOperationNotPossible(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 248 ->
{Term,_} = 'S1AP-IEs':dec_UESidelinkAggregateMaximumBitrate(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 269 ->
{Term,_} = 'S1AP-IEs':dec_NRUESecurityCapabilities(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 277 ->
{Term,_} = 'S1AP-IEs':dec_AerialUEsubscriptionInformation(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 299 ->
{Term,_} = 'S1AP-IEs':dec_AdditionalRRMPriorityIndex(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 301 ->
{Term,_} = 'S1AP-IEs':'dec_IAB-Authorized'(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 306 ->
{Term,_} = 'S1AP-IEs':dec_NRV2XServicesAuthorized(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 307 ->
{Term,_} = 'S1AP-IEs':dec_NRUESidelinkAggregateMaximumBitrate(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 308 ->
{Term,_} = 'S1AP-IEs':dec_PC5QoSParameters(Bytes),
Term;
dec_os_Value162(Bytes, Id) when Id =:= 314 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapabilityID(Bytes),
Term;
dec_os_Value162(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value165(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value165(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value165(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value165(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value168(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value168(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value168(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value168(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value168(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value171(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value171(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value171(Bytes, Id) when Id =:= 74 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapability(Bytes),
Term;
dec_os_Value171(Bytes, Id) when Id =:= 314 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapabilityID(Bytes),
Term;
dec_os_Value171(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value174(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value174(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value174(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value174(Bytes, Id) when Id =:= 169 ->
{Term,_} = 'S1AP-IEs':dec_VoiceSupportMatchIndicator(Bytes),
Term;
dec_os_Value174(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value177(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value177(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value177(Bytes, Id) when Id =:= 26 ->
{Term,_} = 'S1AP-IEs':'dec_NAS-PDU'(Bytes),
Term;
dec_os_Value177(Bytes, Id) when Id =:= 41 ->
{Term,_} = 'S1AP-IEs':dec_HandoverRestrictionList(Bytes),
Term;
dec_os_Value177(Bytes, Id) when Id =:= 74 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapability(Bytes),
Term;
dec_os_Value177(Bytes, Id) when Id =:= 106 ->
{Term,_} = 'S1AP-IEs':dec_SubscriberProfileIDforRFP(Bytes),
Term;
dec_os_Value177(Bytes, Id) when Id =:= 124 ->
{Term,_} = 'S1AP-IEs':dec_SRVCCOperationPossible(Bytes),
Term;
dec_os_Value177(Bytes, Id) when Id =:= 192 ->
{Term,_} = 'S1AP-IEs':'dec_Masked-IMEISV'(Bytes),
Term;
dec_os_Value177(Bytes, Id) when Id =:= 249 ->
{Term,_} = 'S1AP-IEs':dec_DLNASPDUDeliveryAckRequest(Bytes),
Term;
dec_os_Value177(Bytes, Id) when Id =:= 251 ->
{Term,_} = 'S1AP-IEs':dec_EnhancedCoverageRestricted(Bytes),
Term;
dec_os_Value177(Bytes, Id) when Id =:= 269 ->
{Term,_} = 'S1AP-IEs':dec_NRUESecurityCapabilities(Bytes),
Term;
dec_os_Value177(Bytes, Id) when Id =:= 271 ->
{Term,_} = 'S1AP-IEs':'dec_CE-ModeBRestricted'(Bytes),
Term;
dec_os_Value177(Bytes, Id) when Id =:= 275 ->
{Term,_} = 'S1AP-IEs':dec_UECapabilityInfoRequest(Bytes),
Term;
dec_os_Value177(Bytes, Id) when Id =:= 278 ->
{Term,_} = 'S1AP-IEs':'dec_Subscription-Based-UE-DifferentiationInfo'(Bytes),
Term;
dec_os_Value177(Bytes, Id) when Id =:= 280 ->
{Term,_} = 'S1AP-IEs':dec_EndIndication(Bytes),
Term;
dec_os_Value177(Bytes, Id) when Id =:= 283 ->
{Term,_} = 'S1AP-IEs':dec_PendingDataIndication(Bytes),
Term;
dec_os_Value177(Bytes, Id) when Id =:= 299 ->
{Term,_} = 'S1AP-IEs':dec_AdditionalRRMPriorityIndex(Bytes),
Term;
dec_os_Value177(Bytes, Id) when Id =:= 314 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapabilityID(Bytes),
Term;
dec_os_Value177(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value18(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 1 ->
{Term,_} = 'S1AP-IEs':dec_HandoverType(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 25 ->
{Term,_} = 'S1AP-IEs':dec_TraceActivation(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 40 ->
{Term,_} = 'S1AP-IEs':dec_SecurityContext(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 41 ->
{Term,_} = 'S1AP-IEs':dec_HandoverRestrictionList(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 53 ->
{Term,_} = 'dec_E-RABToBeSetupListHOReq'(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 66 ->
{Term,_} = 'S1AP-IEs':dec_UEAggregateMaximumBitrate(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 75 ->
{Term,_} = 'S1AP-IEs':dec_GUMMEI(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 98 ->
{Term,_} = 'S1AP-IEs':dec_RequestType(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 104 ->
{Term,_} = 'S1AP-IEs':'dec_Source-ToTarget-TransparentContainer'(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 107 ->
{Term,_} = 'S1AP-IEs':dec_UESecurityCapabilities(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 124 ->
{Term,_} = 'S1AP-IEs':dec_SRVCCOperationPossible(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 127 ->
{Term,_} = 'S1AP-IEs':'dec_CSG-Id'(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 136 ->
{Term,_} = 'S1AP-IEs':'dec_NASSecurityParameterstoE-UTRAN'(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 146 ->
{Term,_} = 'S1AP-IEs':dec_CSGMembershipStatus(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 158 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 165 ->
{Term,_} = 'S1AP-IEs':dec_ManagementBasedMDTAllowed(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 177 ->
{Term,_} = 'S1AP-IEs':dec_MDTPLMNList(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 192 ->
{Term,_} = 'S1AP-IEs':'dec_Masked-IMEISV'(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 195 ->
{Term,_} = 'S1AP-IEs':dec_ProSeAuthorized(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 196 ->
{Term,_} = 'S1AP-IEs':dec_ExpectedUEBehaviour(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 240 ->
{Term,_} = 'S1AP-IEs':dec_V2XServicesAuthorized(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 241 ->
{Term,_} = 'S1AP-IEs':dec_UEUserPlaneCIoTSupportIndicator(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 248 ->
{Term,_} = 'S1AP-IEs':dec_UESidelinkAggregateMaximumBitrate(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 251 ->
{Term,_} = 'S1AP-IEs':dec_EnhancedCoverageRestricted(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 269 ->
{Term,_} = 'S1AP-IEs':dec_NRUESecurityCapabilities(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 271 ->
{Term,_} = 'S1AP-IEs':'dec_CE-ModeBRestricted'(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 277 ->
{Term,_} = 'S1AP-IEs':dec_AerialUEsubscriptionInformation(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 278 ->
{Term,_} = 'S1AP-IEs':'dec_Subscription-Based-UE-DifferentiationInfo'(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 283 ->
{Term,_} = 'S1AP-IEs':dec_PendingDataIndication(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 299 ->
{Term,_} = 'S1AP-IEs':dec_AdditionalRRMPriorityIndex(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 301 ->
{Term,_} = 'S1AP-IEs':'dec_IAB-Authorized'(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 306 ->
{Term,_} = 'S1AP-IEs':dec_NRV2XServicesAuthorized(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 307 ->
{Term,_} = 'S1AP-IEs':dec_NRUESidelinkAggregateMaximumBitrate(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 308 ->
{Term,_} = 'S1AP-IEs':dec_PC5QoSParameters(Bytes),
Term;
dec_os_Value18(Bytes, Id) when Id =:= 314 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapabilityID(Bytes),
Term;
dec_os_Value18(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value180(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 26 ->
{Term,_} = 'S1AP-IEs':'dec_NAS-PDU'(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 67 ->
{Term,_} = 'S1AP-IEs':dec_TAI(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 75 ->
{Term,_} = 'S1AP-IEs':dec_GUMMEI(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 96 ->
{Term,_} = 'S1AP-IEs':'dec_S-TMSI'(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 100 ->
{Term,_} = 'S1AP-IEs':'dec_EUTRAN-CGI'(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 127 ->
{Term,_} = 'S1AP-IEs':'dec_CSG-Id'(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 134 ->
{Term,_} = 'S1AP-IEs':'dec_RRC-Establishment-Cause'(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 145 ->
{Term,_} = 'S1AP-IEs':dec_CellAccessMode(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 155 ->
{Term,_} = 'S1AP-IEs':dec_TransportLayerAddress(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 160 ->
{Term,_} = 'S1AP-IEs':'dec_RelayNode-Indicator'(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 170 ->
{Term,_} = 'S1AP-IEs':dec_GUMMEIType(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 176 ->
{Term,_} = 'S1AP-IEs':dec_TunnelInformation(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 184 ->
{Term,_} = 'S1AP-IEs':dec_TransportLayerAddress(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 186 ->
{Term,_} = 'S1AP-IEs':'dec_LHN-ID'(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 223 ->
{Term,_} = 'S1AP-IEs':'dec_MME-Group-ID'(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 230 ->
{Term,_} = 'S1AP-IEs':'dec_UE-Usage-Type'(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 242 ->
{Term,_} = 'S1AP-IEs':'dec_CE-mode-B-SupportIndicator'(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 246 ->
{Term,_} = 'S1AP-IEs':'dec_DCN-ID'(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 250 ->
{Term,_} = 'S1AP-IEs':'dec_Coverage-Level'(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 263 ->
{Term,_} = 'S1AP-IEs':'dec_UE-Application-Layer-Measurement-Capability'(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 281 ->
{Term,_} = 'S1AP-IEs':'dec_EDT-Session'(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 302 ->
{Term,_} = 'S1AP-IEs':'dec_IAB-Node-Indication'(Bytes),
Term;
dec_os_Value180(Bytes, Id) when Id =:= 339 ->
{Term,_} = 'S1AP-IEs':'dec_LTE-NTN-TAI-Information'(Bytes),
Term;
dec_os_Value180(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value183(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value183(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value183(Bytes, Id) when Id =:= 26 ->
{Term,_} = 'S1AP-IEs':'dec_NAS-PDU'(Bytes),
Term;
dec_os_Value183(Bytes, Id) when Id =:= 67 ->
{Term,_} = 'S1AP-IEs':dec_TAI(Bytes),
Term;
dec_os_Value183(Bytes, Id) when Id =:= 100 ->
{Term,_} = 'S1AP-IEs':'dec_EUTRAN-CGI'(Bytes),
Term;
dec_os_Value183(Bytes, Id) when Id =:= 155 ->
{Term,_} = 'S1AP-IEs':dec_TransportLayerAddress(Bytes),
Term;
dec_os_Value183(Bytes, Id) when Id =:= 184 ->
{Term,_} = 'S1AP-IEs':dec_TransportLayerAddress(Bytes),
Term;
dec_os_Value183(Bytes, Id) when Id =:= 186 ->
{Term,_} = 'S1AP-IEs':'dec_LHN-ID'(Bytes),
Term;
dec_os_Value183(Bytes, Id) when Id =:= 288 ->
{Term,_} = 'S1AP-IEs':dec_PSCellInformation(Bytes),
Term;
dec_os_Value183(Bytes, Id) when Id =:= 339 ->
{Term,_} = 'S1AP-IEs':'dec_LTE-NTN-TAI-Information'(Bytes),
Term;
dec_os_Value183(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value186(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value186(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value186(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value186(Bytes, Id) when Id =:= 26 ->
{Term,_} = 'S1AP-IEs':'dec_NAS-PDU'(Bytes),
Term;
dec_os_Value186(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value189(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value189(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value189(Bytes, Id) when Id =:= 223 ->
{Term,_} = 'S1AP-IEs':'dec_MME-Group-ID'(Bytes),
Term;
dec_os_Value189(Bytes, Id) when Id =:= 224 ->
{Term,_} = 'S1AP-IEs':'dec_Additional-GUTI'(Bytes),
Term;
dec_os_Value189(Bytes, Id) when Id =:= 225 ->
{Term,_} = 'dec_S1-Message'(Bytes),
Term;
dec_os_Value189(Bytes, Id) when Id =:= 230 ->
{Term,_} = 'S1AP-IEs':'dec_UE-Usage-Type'(Bytes),
Term;
dec_os_Value189(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value192(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value192(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value192(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value195(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value195(Bytes, Id) when Id =:= 92 ->
{Term,_} = dec_ResetType(Bytes),
Term;
dec_os_Value195(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value198(Bytes, Id) when Id =:= 91 ->
{Term,_} = 'S1AP-IEs':'dec_UE-associatedLogicalS1-ConnectionItem'(Bytes),
Term;
dec_os_Value198(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value201(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value201(Bytes, Id) when Id =:= 93 ->
{Term,_} = 'dec_UE-associatedLogicalS1-ConnectionListResAck'(Bytes),
Term;
dec_os_Value201(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value204(Bytes, Id) when Id =:= 91 ->
{Term,_} = 'S1AP-IEs':'dec_UE-associatedLogicalS1-ConnectionItem'(Bytes),
Term;
dec_os_Value204(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value207(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value207(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value207(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value207(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value207(Bytes, Id) when Id =:= 96 ->
{Term,_} = 'S1AP-IEs':'dec_S-TMSI'(Bytes),
Term;
dec_os_Value207(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value21(Bytes, Id) when Id =:= 27 ->
{Term,_} = 'dec_E-RABToBeSetupItemHOReq'(Bytes),
Term;
dec_os_Value21(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value210(Bytes, Id) when Id =:= 59 ->
{Term,_} = 'S1AP-IEs':'dec_Global-ENB-ID'(Bytes),
Term;
dec_os_Value210(Bytes, Id) when Id =:= 60 ->
{Term,_} = 'S1AP-IEs':dec_ENBname(Bytes),
Term;
dec_os_Value210(Bytes, Id) when Id =:= 64 ->
{Term,_} = 'S1AP-IEs':dec_SupportedTAs(Bytes),
Term;
dec_os_Value210(Bytes, Id) when Id =:= 128 ->
{Term,_} = 'S1AP-IEs':'dec_CSG-IdList'(Bytes),
Term;
dec_os_Value210(Bytes, Id) when Id =:= 137 ->
{Term,_} = 'S1AP-IEs':dec_PagingDRX(Bytes),
Term;
dec_os_Value210(Bytes, Id) when Id =:= 228 ->
{Term,_} = 'S1AP-IEs':'dec_UE-RetentionInformation'(Bytes),
Term;
dec_os_Value210(Bytes, Id) when Id =:= 234 ->
{Term,_} = 'S1AP-IEs':'dec_NB-IoT-DefaultPagingDRX'(Bytes),
Term;
dec_os_Value210(Bytes, Id) when Id =:= 291 ->
{Term,_} = 'S1AP-IEs':dec_ConnectedengNBList(Bytes),
Term;
dec_os_Value210(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value213(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value213(Bytes, Id) when Id =:= 61 ->
{Term,_} = 'S1AP-IEs':dec_MMEname(Bytes),
Term;
dec_os_Value213(Bytes, Id) when Id =:= 87 ->
{Term,_} = 'S1AP-IEs':dec_RelativeMMECapacity(Bytes),
Term;
dec_os_Value213(Bytes, Id) when Id =:= 105 ->
{Term,_} = 'S1AP-IEs':dec_ServedGUMMEIs(Bytes),
Term;
dec_os_Value213(Bytes, Id) when Id =:= 163 ->
{Term,_} = 'S1AP-IEs':dec_MMERelaySupportIndicator(Bytes),
Term;
dec_os_Value213(Bytes, Id) when Id =:= 228 ->
{Term,_} = 'S1AP-IEs':'dec_UE-RetentionInformation'(Bytes),
Term;
dec_os_Value213(Bytes, Id) when Id =:= 247 ->
{Term,_} = 'S1AP-IEs':dec_ServedDCNs(Bytes),
Term;
dec_os_Value213(Bytes, Id) when Id =:= 303 ->
{Term,_} = 'S1AP-IEs':'dec_IAB-Supported'(Bytes),
Term;
dec_os_Value213(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value216(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value216(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value216(Bytes, Id) when Id =:= 65 ->
{Term,_} = 'S1AP-IEs':dec_TimeToWait(Bytes),
Term;
dec_os_Value216(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value219(Bytes, Id) when Id =:= 60 ->
{Term,_} = 'S1AP-IEs':dec_ENBname(Bytes),
Term;
dec_os_Value219(Bytes, Id) when Id =:= 64 ->
{Term,_} = 'S1AP-IEs':dec_SupportedTAs(Bytes),
Term;
dec_os_Value219(Bytes, Id) when Id =:= 128 ->
{Term,_} = 'S1AP-IEs':'dec_CSG-IdList'(Bytes),
Term;
dec_os_Value219(Bytes, Id) when Id =:= 137 ->
{Term,_} = 'S1AP-IEs':dec_PagingDRX(Bytes),
Term;
dec_os_Value219(Bytes, Id) when Id =:= 234 ->
{Term,_} = 'S1AP-IEs':'dec_NB-IoT-DefaultPagingDRX'(Bytes),
Term;
dec_os_Value219(Bytes, Id) when Id =:= 292 ->
{Term,_} = 'S1AP-IEs':dec_ConnectedengNBList(Bytes),
Term;
dec_os_Value219(Bytes, Id) when Id =:= 293 ->
{Term,_} = 'S1AP-IEs':dec_ConnectedengNBList(Bytes),
Term;
dec_os_Value219(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value222(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value222(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value225(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value225(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value225(Bytes, Id) when Id =:= 65 ->
{Term,_} = 'S1AP-IEs':dec_TimeToWait(Bytes),
Term;
dec_os_Value225(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value228(Bytes, Id) when Id =:= 61 ->
{Term,_} = 'S1AP-IEs':dec_MMEname(Bytes),
Term;
dec_os_Value228(Bytes, Id) when Id =:= 87 ->
{Term,_} = 'S1AP-IEs':dec_RelativeMMECapacity(Bytes),
Term;
dec_os_Value228(Bytes, Id) when Id =:= 105 ->
{Term,_} = 'S1AP-IEs':dec_ServedGUMMEIs(Bytes),
Term;
dec_os_Value228(Bytes, Id) when Id =:= 247 ->
{Term,_} = 'S1AP-IEs':dec_ServedDCNs(Bytes),
Term;
dec_os_Value228(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value231(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value231(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value234(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value234(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value234(Bytes, Id) when Id =:= 65 ->
{Term,_} = 'S1AP-IEs':dec_TimeToWait(Bytes),
Term;
dec_os_Value234(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value237(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value237(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value237(Bytes, Id) when Id =:= 12 ->
{Term,_} = 'dec_E-RABSubjecttoDataForwardingList'(Bytes),
Term;
dec_os_Value237(Bytes, Id) when Id =:= 70 ->
{Term,_} = 'S1AP-IEs':dec_Cdma2000PDU(Bytes),
Term;
dec_os_Value237(Bytes, Id) when Id =:= 71 ->
{Term,_} = 'S1AP-IEs':dec_Cdma2000RATType(Bytes),
Term;
dec_os_Value237(Bytes, Id) when Id =:= 83 ->
{Term,_} = 'S1AP-IEs':dec_Cdma2000HOStatus(Bytes),
Term;
dec_os_Value237(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value240(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value240(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value240(Bytes, Id) when Id =:= 70 ->
{Term,_} = 'S1AP-IEs':dec_Cdma2000PDU(Bytes),
Term;
dec_os_Value240(Bytes, Id) when Id =:= 71 ->
{Term,_} = 'S1AP-IEs':dec_Cdma2000RATType(Bytes),
Term;
dec_os_Value240(Bytes, Id) when Id =:= 72 ->
{Term,_} = 'S1AP-IEs':dec_Cdma2000SectorID(Bytes),
Term;
dec_os_Value240(Bytes, Id) when Id =:= 84 ->
{Term,_} = 'S1AP-IEs':dec_Cdma2000HORequiredIndication(Bytes),
Term;
dec_os_Value240(Bytes, Id) when Id =:= 97 ->
{Term,_} = 'S1AP-IEs':dec_Cdma2000OneXRAND(Bytes),
Term;
dec_os_Value240(Bytes, Id) when Id =:= 102 ->
{Term,_} = 'S1AP-IEs':dec_Cdma2000OneXSRVCCInfo(Bytes),
Term;
dec_os_Value240(Bytes, Id) when Id =:= 140 ->
{Term,_} = 'S1AP-IEs':dec_EUTRANRoundTripDelayEstimationInfo(Bytes),
Term;
dec_os_Value240(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value243(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value243(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value243(Bytes, Id) when Id =:= 74 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapability(Bytes),
Term;
dec_os_Value243(Bytes, Id) when Id =:= 198 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapabilityForPaging(Bytes),
Term;
dec_os_Value243(Bytes, Id) when Id =:= 263 ->
{Term,_} = 'S1AP-IEs':'dec_UE-Application-Layer-Measurement-Capability'(Bytes),
Term;
dec_os_Value243(Bytes, Id) when Id =:= 272 ->
{Term,_} = 'S1AP-IEs':'dec_LTE-M-Indication'(Bytes),
Term;
dec_os_Value243(Bytes, Id) when Id =:= 315 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapability(Bytes),
Term;
dec_os_Value243(Bytes, Id) when Id =:= 327 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapabilityForPaging(Bytes),
Term;
dec_os_Value243(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value246(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value246(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value246(Bytes, Id) when Id =:= 90 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-StatusTransfer-TransparentContainer'(Bytes),
Term;
dec_os_Value246(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value249(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value249(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value249(Bytes, Id) when Id =:= 90 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-StatusTransfer-TransparentContainer'(Bytes),
Term;
dec_os_Value249(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value252(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value252(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value252(Bytes, Id) when Id =:= 25 ->
{Term,_} = 'S1AP-IEs':dec_TraceActivation(Bytes),
Term;
dec_os_Value252(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value255(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value255(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value255(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value255(Bytes, Id) when Id =:= 86 ->
{Term,_} = 'S1AP-IEs':'dec_E-UTRAN-Trace-ID'(Bytes),
Term;
dec_os_Value255(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value258(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value258(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value258(Bytes, Id) when Id =:= 86 ->
{Term,_} = 'S1AP-IEs':'dec_E-UTRAN-Trace-ID'(Bytes),
Term;
dec_os_Value258(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value261(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value261(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value261(Bytes, Id) when Id =:= 86 ->
{Term,_} = 'S1AP-IEs':'dec_E-UTRAN-Trace-ID'(Bytes),
Term;
dec_os_Value261(Bytes, Id) when Id =:= 100 ->
{Term,_} = 'S1AP-IEs':'dec_EUTRAN-CGI'(Bytes),
Term;
dec_os_Value261(Bytes, Id) when Id =:= 131 ->
{Term,_} = 'S1AP-IEs':dec_TransportLayerAddress(Bytes),
Term;
dec_os_Value261(Bytes, Id) when Id =:= 166 ->
{Term,_} = 'S1AP-IEs':dec_PrivacyIndicator(Bytes),
Term;
dec_os_Value261(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value264(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value264(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value264(Bytes, Id) when Id =:= 98 ->
{Term,_} = 'S1AP-IEs':dec_RequestType(Bytes),
Term;
dec_os_Value264(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value267(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value267(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value267(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value267(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value27(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value27(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value27(Bytes, Id) when Id =:= 18 ->
{Term,_} = 'dec_E-RABAdmittedList'(Bytes),
Term;
dec_os_Value27(Bytes, Id) when Id =:= 19 ->
{Term,_} = 'dec_E-RABFailedtoSetupListHOReqAck'(Bytes),
Term;
dec_os_Value27(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value27(Bytes, Id) when Id =:= 123 ->
{Term,_} = 'S1AP-IEs':'dec_Target-ToSource-TransparentContainer'(Bytes),
Term;
dec_os_Value27(Bytes, Id) when Id =:= 127 ->
{Term,_} = 'S1AP-IEs':'dec_CSG-Id'(Bytes),
Term;
dec_os_Value27(Bytes, Id) when Id =:= 145 ->
{Term,_} = 'S1AP-IEs':dec_CellAccessMode(Bytes),
Term;
dec_os_Value27(Bytes, Id) when Id =:= 242 ->
{Term,_} = 'S1AP-IEs':'dec_CE-mode-B-SupportIndicator'(Bytes),
Term;
dec_os_Value27(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value270(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value270(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value270(Bytes, Id) when Id =:= 67 ->
{Term,_} = 'S1AP-IEs':dec_TAI(Bytes),
Term;
dec_os_Value270(Bytes, Id) when Id =:= 98 ->
{Term,_} = 'S1AP-IEs':dec_RequestType(Bytes),
Term;
dec_os_Value270(Bytes, Id) when Id =:= 100 ->
{Term,_} = 'S1AP-IEs':'dec_EUTRAN-CGI'(Bytes),
Term;
dec_os_Value270(Bytes, Id) when Id =:= 288 ->
{Term,_} = 'S1AP-IEs':dec_PSCellInformation(Bytes),
Term;
dec_os_Value270(Bytes, Id) when Id =:= 339 ->
{Term,_} = 'S1AP-IEs':'dec_LTE-NTN-TAI-Information'(Bytes),
Term;
dec_os_Value270(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value273(Bytes, Id) when Id =:= 101 ->
{Term,_} = 'S1AP-IEs':dec_OverloadResponse(Bytes),
Term;
dec_os_Value273(Bytes, Id) when Id =:= 154 ->
{Term,_} = 'S1AP-IEs':dec_GUMMEIList(Bytes),
Term;
dec_os_Value273(Bytes, Id) when Id =:= 161 ->
{Term,_} = 'S1AP-IEs':dec_TrafficLoadReductionIndication(Bytes),
Term;
dec_os_Value273(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value276(Bytes, Id) when Id =:= 154 ->
{Term,_} = 'S1AP-IEs':dec_GUMMEIList(Bytes),
Term;
dec_os_Value276(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value279(Bytes, Id) when Id =:= 111 ->
{Term,_} = 'S1AP-IEs':dec_MessageIdentifier(Bytes),
Term;
dec_os_Value279(Bytes, Id) when Id =:= 112 ->
{Term,_} = 'S1AP-IEs':dec_SerialNumber(Bytes),
Term;
dec_os_Value279(Bytes, Id) when Id =:= 113 ->
{Term,_} = 'S1AP-IEs':dec_WarningAreaList(Bytes),
Term;
dec_os_Value279(Bytes, Id) when Id =:= 114 ->
{Term,_} = 'S1AP-IEs':dec_RepetitionPeriod(Bytes),
Term;
dec_os_Value279(Bytes, Id) when Id =:= 115 ->
{Term,_} = 'S1AP-IEs':dec_NumberofBroadcastRequest(Bytes),
Term;
dec_os_Value279(Bytes, Id) when Id =:= 116 ->
{Term,_} = 'S1AP-IEs':dec_WarningType(Bytes),
Term;
dec_os_Value279(Bytes, Id) when Id =:= 117 ->
{Term,_} = 'S1AP-IEs':dec_WarningSecurityInfo(Bytes),
Term;
dec_os_Value279(Bytes, Id) when Id =:= 118 ->
{Term,_} = 'S1AP-IEs':dec_DataCodingScheme(Bytes),
Term;
dec_os_Value279(Bytes, Id) when Id =:= 119 ->
{Term,_} = 'S1AP-IEs':dec_WarningMessageContents(Bytes),
Term;
dec_os_Value279(Bytes, Id) when Id =:= 142 ->
{Term,_} = 'S1AP-IEs':dec_ConcurrentWarningMessageIndicator(Bytes),
Term;
dec_os_Value279(Bytes, Id) when Id =:= 144 ->
{Term,_} = 'S1AP-IEs':dec_ExtendedRepetitionPeriod(Bytes),
Term;
dec_os_Value279(Bytes, Id) when Id =:= 286 ->
{Term,_} = 'S1AP-IEs':dec_WarningAreaCoordinates(Bytes),
Term;
dec_os_Value279(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value282(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value282(Bytes, Id) when Id =:= 111 ->
{Term,_} = 'S1AP-IEs':dec_MessageIdentifier(Bytes),
Term;
dec_os_Value282(Bytes, Id) when Id =:= 112 ->
{Term,_} = 'S1AP-IEs':dec_SerialNumber(Bytes),
Term;
dec_os_Value282(Bytes, Id) when Id =:= 120 ->
{Term,_} = 'S1AP-IEs':dec_BroadcastCompletedAreaList(Bytes),
Term;
dec_os_Value282(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value285(Bytes, Id) when Id =:= 121 ->
{Term,_} = 'dec_Inter-SystemInformationTransferType'(Bytes),
Term;
dec_os_Value285(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value288(Bytes, Id) when Id =:= 122 ->
{Term,_} = 'dec_Inter-SystemInformationTransferType'(Bytes),
Term;
dec_os_Value288(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value291(Bytes, Id) when Id =:= 129 ->
{Term,_} = 'S1AP-IEs':dec_SONConfigurationTransfer(Bytes),
Term;
dec_os_Value291(Bytes, Id) when Id =:= 294 ->
{Term,_} = 'S1AP-IEs':'dec_EN-DCSONConfigurationTransfer'(Bytes),
Term;
dec_os_Value291(Bytes, Id) when Id =:= 310 ->
{Term,_} = 'S1AP-IEs':dec_IntersystemSONConfigurationTransfer(Bytes),
Term;
dec_os_Value291(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value294(Bytes, Id) when Id =:= 130 ->
{Term,_} = 'S1AP-IEs':dec_SONConfigurationTransfer(Bytes),
Term;
dec_os_Value294(Bytes, Id) when Id =:= 295 ->
{Term,_} = 'S1AP-IEs':'dec_EN-DCSONConfigurationTransfer'(Bytes),
Term;
dec_os_Value294(Bytes, Id) when Id =:= 309 ->
{Term,_} = 'S1AP-IEs':dec_IntersystemSONConfigurationTransfer(Bytes),
Term;
dec_os_Value294(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value298(Bytes, Id) when Id =:= 111 ->
{Term,_} = 'S1AP-IEs':dec_MessageIdentifier(Bytes),
Term;
dec_os_Value298(Bytes, Id) when Id =:= 112 ->
{Term,_} = 'S1AP-IEs':dec_SerialNumber(Bytes),
Term;
dec_os_Value298(Bytes, Id) when Id =:= 113 ->
{Term,_} = 'S1AP-IEs':dec_WarningAreaList(Bytes),
Term;
dec_os_Value298(Bytes, Id) when Id =:= 191 ->
{Term,_} = 'S1AP-IEs':dec_KillAllWarningMessages(Bytes),
Term;
dec_os_Value298(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value3(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value3(Bytes, Id) when Id =:= 1 ->
{Term,_} = 'S1AP-IEs':dec_HandoverType(Bytes),
Term;
dec_os_Value3(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value3(Bytes, Id) when Id =:= 4 ->
{Term,_} = 'S1AP-IEs':dec_TargetID(Bytes),
Term;
dec_os_Value3(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value3(Bytes, Id) when Id =:= 79 ->
{Term,_} = 'S1AP-IEs':'dec_Direct-Forwarding-Path-Availability'(Bytes),
Term;
dec_os_Value3(Bytes, Id) when Id =:= 104 ->
{Term,_} = 'S1AP-IEs':'dec_Source-ToTarget-TransparentContainer'(Bytes),
Term;
dec_os_Value3(Bytes, Id) when Id =:= 125 ->
{Term,_} = 'S1AP-IEs':dec_SRVCCHOIndication(Bytes),
Term;
dec_os_Value3(Bytes, Id) when Id =:= 127 ->
{Term,_} = 'S1AP-IEs':'dec_CSG-Id'(Bytes),
Term;
dec_os_Value3(Bytes, Id) when Id =:= 132 ->
{Term,_} = 'S1AP-IEs':dec_MSClassmark2(Bytes),
Term;
dec_os_Value3(Bytes, Id) when Id =:= 133 ->
{Term,_} = 'S1AP-IEs':dec_MSClassmark3(Bytes),
Term;
dec_os_Value3(Bytes, Id) when Id =:= 138 ->
{Term,_} = 'S1AP-IEs':'dec_Source-ToTarget-TransparentContainer'(Bytes),
Term;
dec_os_Value3(Bytes, Id) when Id =:= 145 ->
{Term,_} = 'S1AP-IEs':dec_CellAccessMode(Bytes),
Term;
dec_os_Value3(Bytes, Id) when Id =:= 150 ->
{Term,_} = 'S1AP-IEs':'dec_PS-ServiceNotAvailable'(Bytes),
Term;
dec_os_Value3(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value30(Bytes, Id) when Id =:= 20 ->
{Term,_} = 'dec_E-RABAdmittedItem'(Bytes),
Term;
dec_os_Value30(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value301(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value301(Bytes, Id) when Id =:= 111 ->
{Term,_} = 'S1AP-IEs':dec_MessageIdentifier(Bytes),
Term;
dec_os_Value301(Bytes, Id) when Id =:= 112 ->
{Term,_} = 'S1AP-IEs':dec_SerialNumber(Bytes),
Term;
dec_os_Value301(Bytes, Id) when Id =:= 141 ->
{Term,_} = 'S1AP-IEs':dec_BroadcastCancelledAreaList(Bytes),
Term;
dec_os_Value301(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value304(Bytes, Id) when Id =:= 59 ->
{Term,_} = 'S1AP-IEs':'dec_Global-ENB-ID'(Bytes),
Term;
dec_os_Value304(Bytes, Id) when Id =:= 182 ->
{Term,_} = 'S1AP-IEs':dec_ECGIListForRestart(Bytes),
Term;
dec_os_Value304(Bytes, Id) when Id =:= 188 ->
{Term,_} = 'S1AP-IEs':dec_TAIListForRestart(Bytes),
Term;
dec_os_Value304(Bytes, Id) when Id =:= 190 ->
{Term,_} = 'S1AP-IEs':dec_EmergencyAreaIDListForRestart(Bytes),
Term;
dec_os_Value304(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value307(Bytes, Id) when Id =:= 59 ->
{Term,_} = 'S1AP-IEs':'dec_Global-ENB-ID'(Bytes),
Term;
dec_os_Value307(Bytes, Id) when Id =:= 222 ->
{Term,_} = 'S1AP-IEs':dec_PWSfailedECGIList(Bytes),
Term;
dec_os_Value307(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value310(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value310(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value310(Bytes, Id) when Id =:= 147 ->
{Term,_} = 'S1AP-IEs':'dec_LPPa-PDU'(Bytes),
Term;
dec_os_Value310(Bytes, Id) when Id =:= 148 ->
{Term,_} = 'S1AP-IEs':'dec_Routing-ID'(Bytes),
Term;
dec_os_Value310(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value313(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value313(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value313(Bytes, Id) when Id =:= 147 ->
{Term,_} = 'S1AP-IEs':'dec_LPPa-PDU'(Bytes),
Term;
dec_os_Value313(Bytes, Id) when Id =:= 148 ->
{Term,_} = 'S1AP-IEs':'dec_Routing-ID'(Bytes),
Term;
dec_os_Value313(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value316(Bytes, Id) when Id =:= 147 ->
{Term,_} = 'S1AP-IEs':'dec_LPPa-PDU'(Bytes),
Term;
dec_os_Value316(Bytes, Id) when Id =:= 148 ->
{Term,_} = 'S1AP-IEs':'dec_Routing-ID'(Bytes),
Term;
dec_os_Value316(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value319(Bytes, Id) when Id =:= 147 ->
{Term,_} = 'S1AP-IEs':'dec_LPPa-PDU'(Bytes),
Term;
dec_os_Value319(Bytes, Id) when Id =:= 148 ->
{Term,_} = 'S1AP-IEs':'dec_Routing-ID'(Bytes),
Term;
dec_os_Value319(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value322(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value322(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value322(Bytes, Id) when Id =:= 176 ->
{Term,_} = 'S1AP-IEs':dec_TunnelInformation(Bytes),
Term;
dec_os_Value322(Bytes, Id) when Id =:= 189 ->
{Term,_} = 'S1AP-IEs':dec_UserLocationInformation(Bytes),
Term;
dec_os_Value322(Bytes, Id) when Id =:= 199 ->
{Term,_} = 'dec_E-RABToBeModifiedListBearerModInd'(Bytes),
Term;
dec_os_Value322(Bytes, Id) when Id =:= 201 ->
{Term,_} = 'dec_E-RABNotToBeModifiedListBearerModInd'(Bytes),
Term;
dec_os_Value322(Bytes, Id) when Id =:= 226 ->
{Term,_} = dec_CSGMembershipInfo(Bytes),
Term;
dec_os_Value322(Bytes, Id) when Id =:= 264 ->
{Term,_} = 'S1AP-IEs':dec_SecondaryRATDataUsageReportList(Bytes),
Term;
dec_os_Value322(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value325(Bytes, Id) when Id =:= 200 ->
{Term,_} = 'dec_E-RABToBeModifiedItemBearerModInd'(Bytes),
Term;
dec_os_Value325(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value329(Bytes, Id) when Id =:= 202 ->
{Term,_} = 'dec_E-RABNotToBeModifiedItemBearerModInd'(Bytes),
Term;
dec_os_Value329(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value334(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value334(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value334(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value334(Bytes, Id) when Id =:= 146 ->
{Term,_} = 'S1AP-IEs':dec_CSGMembershipStatus(Bytes),
Term;
dec_os_Value334(Bytes, Id) when Id =:= 203 ->
{Term,_} = 'dec_E-RABModifyListBearerModConf'(Bytes),
Term;
dec_os_Value334(Bytes, Id) when Id =:= 205 ->
{Term,_} = 'S1AP-IEs':'dec_E-RABList'(Bytes),
Term;
dec_os_Value334(Bytes, Id) when Id =:= 210 ->
{Term,_} = 'S1AP-IEs':'dec_E-RABList'(Bytes),
Term;
dec_os_Value334(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value337(Bytes, Id) when Id =:= 204 ->
{Term,_} = 'dec_E-RABModifyItemBearerModConf'(Bytes),
Term;
dec_os_Value337(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value34(Bytes, Id) when Id =:= 21 ->
{Term,_} = 'dec_E-RABFailedToSetupItemHOReqAck'(Bytes),
Term;
dec_os_Value34(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value341(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value341(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value341(Bytes, Id) when Id =:= 226 ->
{Term,_} = dec_CSGMembershipInfo(Bytes),
Term;
dec_os_Value341(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value344(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value344(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value344(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value344(Bytes, Id) when Id =:= 146 ->
{Term,_} = 'S1AP-IEs':dec_CSGMembershipStatus(Bytes),
Term;
dec_os_Value344(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value347(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value347(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value347(Bytes, Id) when Id =:= 189 ->
{Term,_} = 'S1AP-IEs':dec_UserLocationInformation(Bytes),
Term;
dec_os_Value347(Bytes, Id) when Id =:= 212 ->
{Term,_} = 'S1AP-IEs':dec_CellIdentifierAndCELevelForCECapableUEs(Bytes),
Term;
dec_os_Value347(Bytes, Id) when Id =:= 213 ->
{Term,_} = 'S1AP-IEs':dec_InformationOnRecommendedCellsAndENBsForPaging(Bytes),
Term;
dec_os_Value347(Bytes, Id) when Id =:= 264 ->
{Term,_} = 'S1AP-IEs':dec_SecondaryRATDataUsageReportList(Bytes),
Term;
dec_os_Value347(Bytes, Id) when Id =:= 297 ->
{Term,_} = 'S1AP-IEs':dec_TimeSinceSecondaryNodeRelease(Bytes),
Term;
dec_os_Value347(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value350(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value350(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value350(Bytes, Id) when Id =:= 40 ->
{Term,_} = 'S1AP-IEs':dec_SecurityContext(Bytes),
Term;
dec_os_Value350(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value350(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value353(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value353(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value353(Bytes, Id) when Id =:= 235 ->
{Term,_} = 'dec_E-RABFailedToResumeListResumeReq'(Bytes),
Term;
dec_os_Value353(Bytes, Id) when Id =:= 245 ->
{Term,_} = 'S1AP-IEs':'dec_RRC-Establishment-Cause'(Bytes),
Term;
dec_os_Value353(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value356(Bytes, Id) when Id =:= 236 ->
{Term,_} = 'dec_E-RABFailedToResumeItemResumeReq'(Bytes),
Term;
dec_os_Value356(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value360(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value360(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value360(Bytes, Id) when Id =:= 40 ->
{Term,_} = 'S1AP-IEs':dec_SecurityContext(Bytes),
Term;
dec_os_Value360(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value360(Bytes, Id) when Id =:= 237 ->
{Term,_} = 'dec_E-RABFailedToResumeListResumeRes'(Bytes),
Term;
dec_os_Value360(Bytes, Id) when Id =:= 283 ->
{Term,_} = 'S1AP-IEs':dec_PendingDataIndication(Bytes),
Term;
dec_os_Value360(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value363(Bytes, Id) when Id =:= 238 ->
{Term,_} = 'dec_E-RABFailedToResumeItemResumeRes'(Bytes),
Term;
dec_os_Value363(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value367(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value367(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value367(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value367(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value367(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value370(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value370(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value370(Bytes, Id) when Id =:= 74 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapability(Bytes),
Term;
dec_os_Value370(Bytes, Id) when Id =:= 192 ->
{Term,_} = 'S1AP-IEs':'dec_Masked-IMEISV'(Bytes),
Term;
dec_os_Value370(Bytes, Id) when Id =:= 251 ->
{Term,_} = 'S1AP-IEs':dec_EnhancedCoverageRestricted(Bytes),
Term;
dec_os_Value370(Bytes, Id) when Id =:= 252 ->
{Term,_} = 'S1AP-IEs':'dec_E-RABLevelQoSParameters'(Bytes),
Term;
dec_os_Value370(Bytes, Id) when Id =:= 253 ->
{Term,_} = 'S1AP-IEs':'dec_DL-CP-SecurityInformation'(Bytes),
Term;
dec_os_Value370(Bytes, Id) when Id =:= 271 ->
{Term,_} = 'S1AP-IEs':'dec_CE-ModeBRestricted'(Bytes),
Term;
dec_os_Value370(Bytes, Id) when Id =:= 278 ->
{Term,_} = 'S1AP-IEs':'dec_Subscription-Based-UE-DifferentiationInfo'(Bytes),
Term;
dec_os_Value370(Bytes, Id) when Id =:= 280 ->
{Term,_} = 'S1AP-IEs':dec_EndIndication(Bytes),
Term;
dec_os_Value370(Bytes, Id) when Id =:= 314 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapabilityID(Bytes),
Term;
dec_os_Value370(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value373(Bytes, Id) when Id =:= 96 ->
{Term,_} = 'S1AP-IEs':'dec_S-TMSI'(Bytes),
Term;
dec_os_Value373(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value376(Bytes, Id) when Id =:= 74 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapability(Bytes),
Term;
dec_os_Value376(Bytes, Id) when Id =:= 96 ->
{Term,_} = 'S1AP-IEs':'dec_S-TMSI'(Bytes),
Term;
dec_os_Value376(Bytes, Id) when Id =:= 192 ->
{Term,_} = 'S1AP-IEs':'dec_Masked-IMEISV'(Bytes),
Term;
dec_os_Value376(Bytes, Id) when Id =:= 252 ->
{Term,_} = 'S1AP-IEs':'dec_E-RABLevelQoSParameters'(Bytes),
Term;
dec_os_Value376(Bytes, Id) when Id =:= 278 ->
{Term,_} = 'S1AP-IEs':'dec_Subscription-Based-UE-DifferentiationInfo'(Bytes),
Term;
dec_os_Value376(Bytes, Id) when Id =:= 283 ->
{Term,_} = 'S1AP-IEs':dec_PendingDataIndication(Bytes),
Term;
dec_os_Value376(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value379(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value379(Bytes, Id) when Id =:= 67 ->
{Term,_} = 'S1AP-IEs':dec_TAI(Bytes),
Term;
dec_os_Value379(Bytes, Id) when Id =:= 96 ->
{Term,_} = 'S1AP-IEs':'dec_S-TMSI'(Bytes),
Term;
dec_os_Value379(Bytes, Id) when Id =:= 100 ->
{Term,_} = 'S1AP-IEs':'dec_EUTRAN-CGI'(Bytes),
Term;
dec_os_Value379(Bytes, Id) when Id =:= 254 ->
{Term,_} = 'S1AP-IEs':'dec_UL-CP-SecurityInformation'(Bytes),
Term;
dec_os_Value379(Bytes, Id) when Id =:= 339 ->
{Term,_} = 'S1AP-IEs':'dec_LTE-NTN-TAI-Information'(Bytes),
Term;
dec_os_Value379(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value38(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value38(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value38(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value38(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value382(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value382(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value382(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value385(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value385(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value385(Bytes, Id) when Id =:= 189 ->
{Term,_} = 'S1AP-IEs':dec_UserLocationInformation(Bytes),
Term;
dec_os_Value385(Bytes, Id) when Id =:= 264 ->
{Term,_} = 'S1AP-IEs':dec_SecondaryRATDataUsageReportList(Bytes),
Term;
dec_os_Value385(Bytes, Id) when Id =:= 266 ->
{Term,_} = 'S1AP-IEs':dec_HandoverFlag(Bytes),
Term;
dec_os_Value385(Bytes, Id) when Id =:= 297 ->
{Term,_} = 'S1AP-IEs':dec_TimeSinceSecondaryNodeRelease(Bytes),
Term;
dec_os_Value385(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value388(Bytes, Id) when Id =:= 314 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapabilityID(Bytes),
Term;
dec_os_Value388(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value391(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value391(Bytes, Id) when Id =:= 74 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapability(Bytes),
Term;
dec_os_Value391(Bytes, Id) when Id =:= 314 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapabilityID(Bytes),
Term;
dec_os_Value391(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value41(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value41(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value41(Bytes, Id) when Id =:= 67 ->
{Term,_} = 'S1AP-IEs':dec_TAI(Bytes),
Term;
dec_os_Value41(Bytes, Id) when Id =:= 100 ->
{Term,_} = 'S1AP-IEs':'dec_EUTRAN-CGI'(Bytes),
Term;
dec_os_Value41(Bytes, Id) when Id =:= 176 ->
{Term,_} = 'S1AP-IEs':dec_TunnelInformation(Bytes),
Term;
dec_os_Value41(Bytes, Id) when Id =:= 186 ->
{Term,_} = 'S1AP-IEs':'dec_LHN-ID'(Bytes),
Term;
dec_os_Value41(Bytes, Id) when Id =:= 288 ->
{Term,_} = 'S1AP-IEs':dec_PSCellInformation(Bytes),
Term;
dec_os_Value41(Bytes, Id) when Id =:= 320 ->
{Term,_} = 'S1AP-IEs':dec_NotifySourceeNB(Bytes),
Term;
dec_os_Value41(Bytes, Id) when Id =:= 339 ->
{Term,_} = 'S1AP-IEs':'dec_LTE-NTN-TAI-Information'(Bytes),
Term;
dec_os_Value41(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value44(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value44(Bytes, Id) when Id =:= 22 ->
{Term,_} = 'dec_E-RABToBeSwitchedDLList'(Bytes),
Term;
dec_os_Value44(Bytes, Id) when Id =:= 67 ->
{Term,_} = 'S1AP-IEs':dec_TAI(Bytes),
Term;
dec_os_Value44(Bytes, Id) when Id =:= 88 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value44(Bytes, Id) when Id =:= 100 ->
{Term,_} = 'S1AP-IEs':'dec_EUTRAN-CGI'(Bytes),
Term;
dec_os_Value44(Bytes, Id) when Id =:= 107 ->
{Term,_} = 'S1AP-IEs':dec_UESecurityCapabilities(Bytes),
Term;
dec_os_Value44(Bytes, Id) when Id =:= 127 ->
{Term,_} = 'S1AP-IEs':'dec_CSG-Id'(Bytes),
Term;
dec_os_Value44(Bytes, Id) when Id =:= 145 ->
{Term,_} = 'S1AP-IEs':dec_CellAccessMode(Bytes),
Term;
dec_os_Value44(Bytes, Id) when Id =:= 146 ->
{Term,_} = 'S1AP-IEs':dec_CSGMembershipStatus(Bytes),
Term;
dec_os_Value44(Bytes, Id) when Id =:= 157 ->
{Term,_} = 'S1AP-IEs':dec_GUMMEI(Bytes),
Term;
dec_os_Value44(Bytes, Id) when Id =:= 176 ->
{Term,_} = 'S1AP-IEs':dec_TunnelInformation(Bytes),
Term;
dec_os_Value44(Bytes, Id) when Id =:= 186 ->
{Term,_} = 'S1AP-IEs':'dec_LHN-ID'(Bytes),
Term;
dec_os_Value44(Bytes, Id) when Id =:= 245 ->
{Term,_} = 'S1AP-IEs':'dec_RRC-Establishment-Cause'(Bytes),
Term;
dec_os_Value44(Bytes, Id) when Id =:= 269 ->
{Term,_} = 'S1AP-IEs':dec_NRUESecurityCapabilities(Bytes),
Term;
dec_os_Value44(Bytes, Id) when Id =:= 288 ->
{Term,_} = 'S1AP-IEs':dec_PSCellInformation(Bytes),
Term;
dec_os_Value44(Bytes, Id) when Id =:= 339 ->
{Term,_} = 'S1AP-IEs':'dec_LTE-NTN-TAI-Information'(Bytes),
Term;
dec_os_Value44(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value47(Bytes, Id) when Id =:= 23 ->
{Term,_} = 'dec_E-RABToBeSwitchedDLItem'(Bytes),
Term;
dec_os_Value47(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value53(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 33 ->
{Term,_} = 'S1AP-IEs':'dec_E-RABList'(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 40 ->
{Term,_} = 'S1AP-IEs':dec_SecurityContext(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 41 ->
{Term,_} = 'S1AP-IEs':dec_HandoverRestrictionList(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 66 ->
{Term,_} = 'S1AP-IEs':dec_UEAggregateMaximumBitrate(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 95 ->
{Term,_} = 'dec_E-RABToBeSwitchedULList'(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 107 ->
{Term,_} = 'S1AP-IEs':dec_UESecurityCapabilities(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 146 ->
{Term,_} = 'S1AP-IEs':dec_CSGMembershipStatus(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 158 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 195 ->
{Term,_} = 'S1AP-IEs':dec_ProSeAuthorized(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 240 ->
{Term,_} = 'S1AP-IEs':dec_V2XServicesAuthorized(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 241 ->
{Term,_} = 'S1AP-IEs':dec_UEUserPlaneCIoTSupportIndicator(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 248 ->
{Term,_} = 'S1AP-IEs':dec_UESidelinkAggregateMaximumBitrate(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 251 ->
{Term,_} = 'S1AP-IEs':dec_EnhancedCoverageRestricted(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 269 ->
{Term,_} = 'S1AP-IEs':dec_NRUESecurityCapabilities(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 271 ->
{Term,_} = 'S1AP-IEs':'dec_CE-ModeBRestricted'(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 277 ->
{Term,_} = 'S1AP-IEs':dec_AerialUEsubscriptionInformation(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 278 ->
{Term,_} = 'S1AP-IEs':'dec_Subscription-Based-UE-DifferentiationInfo'(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 283 ->
{Term,_} = 'S1AP-IEs':dec_PendingDataIndication(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 299 ->
{Term,_} = 'S1AP-IEs':dec_AdditionalRRMPriorityIndex(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 306 ->
{Term,_} = 'S1AP-IEs':dec_NRV2XServicesAuthorized(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 307 ->
{Term,_} = 'S1AP-IEs':dec_NRUESidelinkAggregateMaximumBitrate(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 308 ->
{Term,_} = 'S1AP-IEs':dec_PC5QoSParameters(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 314 ->
{Term,_} = 'S1AP-IEs':dec_UERadioCapabilityID(Bytes),
Term;
dec_os_Value53(Bytes, Id) when Id =:= 341 ->
{Term,_} = 'dec_E-RABToBeUpdatedList'(Bytes),
Term;
dec_os_Value53(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value56(Bytes, Id) when Id =:= 94 ->
{Term,_} = 'dec_E-RABToBeSwitchedULItem'(Bytes),
Term;
dec_os_Value56(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value6(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value6(Bytes, Id) when Id =:= 1 ->
{Term,_} = 'S1AP-IEs':dec_HandoverType(Bytes),
Term;
dec_os_Value6(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value6(Bytes, Id) when Id =:= 12 ->
{Term,_} = 'dec_E-RABSubjecttoDataForwardingList'(Bytes),
Term;
dec_os_Value6(Bytes, Id) when Id =:= 13 ->
{Term,_} = 'S1AP-IEs':'dec_E-RABList'(Bytes),
Term;
dec_os_Value6(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value6(Bytes, Id) when Id =:= 123 ->
{Term,_} = 'S1AP-IEs':'dec_Target-ToSource-TransparentContainer'(Bytes),
Term;
dec_os_Value6(Bytes, Id) when Id =:= 135 ->
{Term,_} = 'S1AP-IEs':'dec_NASSecurityParametersfromE-UTRAN'(Bytes),
Term;
dec_os_Value6(Bytes, Id) when Id =:= 139 ->
{Term,_} = 'S1AP-IEs':'dec_Target-ToSource-TransparentContainer'(Bytes),
Term;
dec_os_Value6(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value60(Bytes, Id) when Id =:= 342 ->
{Term,_} = 'dec_E-RABToBeUpdatedItem'(Bytes),
Term;
dec_os_Value60(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value64(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value64(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value64(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value64(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value64(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value67(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value67(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-IEs':dec_Cause(Bytes),
Term;
dec_os_Value67(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value67(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value70(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value70(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value70(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value70(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value73(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value73(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value73(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value76(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value76(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value76(Bytes, Id) when Id =:= 321 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-EarlyStatusTransfer-TransparentContainer'(Bytes),
Term;
dec_os_Value76(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value79(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value79(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value79(Bytes, Id) when Id =:= 321 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-EarlyStatusTransfer-TransparentContainer'(Bytes),
Term;
dec_os_Value79(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value82(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value82(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value82(Bytes, Id) when Id =:= 16 ->
{Term,_} = 'dec_E-RABToBeSetupListBearerSUReq'(Bytes),
Term;
dec_os_Value82(Bytes, Id) when Id =:= 66 ->
{Term,_} = 'S1AP-IEs':dec_UEAggregateMaximumBitrate(Bytes),
Term;
dec_os_Value82(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value85(Bytes, Id) when Id =:= 17 ->
{Term,_} = 'dec_E-RABToBeSetupItemBearerSUReq'(Bytes),
Term;
dec_os_Value85(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value9(Bytes, Id) when Id =:= 14 ->
{Term,_} = 'dec_E-RABDataForwardingItem'(Bytes),
Term;
dec_os_Value9(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value91(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value91(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value91(Bytes, Id) when Id =:= 28 ->
{Term,_} = 'dec_E-RABSetupListBearerSURes'(Bytes),
Term;
dec_os_Value91(Bytes, Id) when Id =:= 29 ->
{Term,_} = 'S1AP-IEs':'dec_E-RABList'(Bytes),
Term;
dec_os_Value91(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-IEs':dec_CriticalityDiagnostics(Bytes),
Term;
dec_os_Value91(Bytes, Id) when Id =:= 189 ->
{Term,_} = 'S1AP-IEs':dec_UserLocationInformation(Bytes),
Term;
dec_os_Value91(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value94(Bytes, Id) when Id =:= 39 ->
{Term,_} = 'dec_E-RABSetupItemBearerSURes'(Bytes),
Term;
dec_os_Value94(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_Value98(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-IEs':'dec_MME-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value98(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-IEs':'dec_ENB-UE-S1AP-ID'(Bytes),
Term;
dec_os_Value98(Bytes, Id) when Id =:= 30 ->
{Term,_} = 'dec_E-RABToBeModifiedListBearerModReq'(Bytes),
Term;
dec_os_Value98(Bytes, Id) when Id =:= 66 ->
{Term,_} = 'S1AP-IEs':dec_UEAggregateMaximumBitrate(Bytes),
Term;
dec_os_Value98(Bytes, Id) when Id =:= 268 ->
{Term,_} = 'S1AP-IEs':dec_SecondaryRATDataUsageRequest(Bytes),
Term;
dec_os_Value98(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


enc_os_Extension10(Val, Id) ->
open_type_to_binary(Val).

enc_os_Extension102(Val, Id) ->
if Id =:= 185 ->
'S1AP-IEs':enc_TransportInformation(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Extension131(Val, Id) ->
if Id =:= 156 ->
'S1AP-IEs':'enc_Correlation-ID'(Val);
Id =:= 183 ->
'S1AP-IEs':'enc_Correlation-ID'(Val);
Id =:= 233 ->
'S1AP-IEs':enc_BearerType(Val);
Id =:= 305 ->
'S1AP-IEs':'enc_Ethernet-Type'(Val);
Id =:= 332 ->
'S1AP-IEs':enc_SecurityIndication(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Extension22(Val, Id) ->
if Id =:= 143 ->
'S1AP-IEs':'enc_Data-Forwarding-Not-Possible'(Val);
Id =:= 233 ->
'S1AP-IEs':enc_BearerType(Val);
Id =:= 305 ->
'S1AP-IEs':'enc_Ethernet-Type'(Val);
Id =:= 332 ->
'S1AP-IEs':enc_SecurityIndication(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Extension48(Val, Id) ->
if Id =:= 332 ->
'S1AP-IEs':enc_SecurityIndication(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Extension86(Val, Id) ->
if Id =:= 156 ->
'S1AP-IEs':'enc_Correlation-ID'(Val);
Id =:= 183 ->
'S1AP-IEs':'enc_Correlation-ID'(Val);
Id =:= 233 ->
'S1AP-IEs':enc_BearerType(Val);
Id =:= 305 ->
'S1AP-IEs':'enc_Ethernet-Type'(Val);
Id =:= 332 ->
'S1AP-IEs':enc_SecurityIndication(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value1(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 1 ->
'S1AP-IEs':enc_HandoverType(Val);
Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 4 ->
'S1AP-IEs':enc_TargetID(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 79 ->
'S1AP-IEs':'enc_Direct-Forwarding-Path-Availability'(Val);
Id =:= 104 ->
'S1AP-IEs':'enc_Source-ToTarget-TransparentContainer'(Val);
Id =:= 125 ->
'S1AP-IEs':enc_SRVCCHOIndication(Val);
Id =:= 127 ->
'S1AP-IEs':'enc_CSG-Id'(Val);
Id =:= 132 ->
'S1AP-IEs':enc_MSClassmark2(Val);
Id =:= 133 ->
'S1AP-IEs':enc_MSClassmark3(Val);
Id =:= 138 ->
'S1AP-IEs':'enc_Source-ToTarget-TransparentContainer'(Val);
Id =:= 145 ->
'S1AP-IEs':enc_CellAccessMode(Val);
Id =:= 150 ->
'S1AP-IEs':'enc_PS-ServiceNotAvailable'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value105(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 31 ->
'enc_E-RABModifyListBearerModRes'(Val);
Id =:= 32 ->
'S1AP-IEs':'enc_E-RABList'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 189 ->
'S1AP-IEs':enc_UserLocationInformation(Val);
Id =:= 264 ->
'S1AP-IEs':enc_SecondaryRATDataUsageReportList(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value108(Val, Id) ->
if Id =:= 37 ->
'enc_E-RABModifyItemBearerModRes'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value112(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 26 ->
'S1AP-IEs':'enc_NAS-PDU'(Val);
Id =:= 33 ->
'S1AP-IEs':'enc_E-RABList'(Val);
Id =:= 66 ->
'S1AP-IEs':enc_UEAggregateMaximumBitrate(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value115(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 34 ->
'S1AP-IEs':'enc_E-RABList'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 69 ->
'enc_E-RABReleaseListBearerRelComp'(Val);
Id =:= 189 ->
'S1AP-IEs':enc_UserLocationInformation(Val);
Id =:= 264 ->
'S1AP-IEs':enc_SecondaryRATDataUsageReportList(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value118(Val, Id) ->
if Id =:= 15 ->
'enc_E-RABReleaseItemBearerRelComp'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value122(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 110 ->
'S1AP-IEs':'enc_E-RABList'(Val);
Id =:= 189 ->
'S1AP-IEs':enc_UserLocationInformation(Val);
Id =:= 264 ->
'S1AP-IEs':enc_SecondaryRATDataUsageReportList(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value125(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 24 ->
'enc_E-RABToBeSetupListCtxtSUReq'(Val);
Id =:= 25 ->
'S1AP-IEs':enc_TraceActivation(Val);
Id =:= 41 ->
'S1AP-IEs':enc_HandoverRestrictionList(Val);
Id =:= 66 ->
'S1AP-IEs':enc_UEAggregateMaximumBitrate(Val);
Id =:= 73 ->
'S1AP-IEs':enc_SecurityKey(Val);
Id =:= 74 ->
'S1AP-IEs':enc_UERadioCapability(Val);
Id =:= 75 ->
'S1AP-IEs':enc_GUMMEI(Val);
Id =:= 106 ->
'S1AP-IEs':enc_SubscriberProfileIDforRFP(Val);
Id =:= 107 ->
'S1AP-IEs':enc_UESecurityCapabilities(Val);
Id =:= 108 ->
'S1AP-IEs':enc_CSFallbackIndicator(Val);
Id =:= 124 ->
'S1AP-IEs':enc_SRVCCOperationPossible(Val);
Id =:= 146 ->
'S1AP-IEs':enc_CSGMembershipStatus(Val);
Id =:= 158 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 159 ->
'S1AP-IEs':enc_LAI(Val);
Id =:= 165 ->
'S1AP-IEs':enc_ManagementBasedMDTAllowed(Val);
Id =:= 177 ->
'S1AP-IEs':enc_MDTPLMNList(Val);
Id =:= 187 ->
'S1AP-IEs':enc_AdditionalCSFallbackIndicator(Val);
Id =:= 192 ->
'S1AP-IEs':'enc_Masked-IMEISV'(Val);
Id =:= 195 ->
'S1AP-IEs':enc_ProSeAuthorized(Val);
Id =:= 196 ->
'S1AP-IEs':enc_ExpectedUEBehaviour(Val);
Id =:= 240 ->
'S1AP-IEs':enc_V2XServicesAuthorized(Val);
Id =:= 241 ->
'S1AP-IEs':enc_UEUserPlaneCIoTSupportIndicator(Val);
Id =:= 248 ->
'S1AP-IEs':enc_UESidelinkAggregateMaximumBitrate(Val);
Id =:= 251 ->
'S1AP-IEs':enc_EnhancedCoverageRestricted(Val);
Id =:= 269 ->
'S1AP-IEs':enc_NRUESecurityCapabilities(Val);
Id =:= 271 ->
'S1AP-IEs':'enc_CE-ModeBRestricted'(Val);
Id =:= 277 ->
'S1AP-IEs':enc_AerialUEsubscriptionInformation(Val);
Id =:= 278 ->
'S1AP-IEs':'enc_Subscription-Based-UE-DifferentiationInfo'(Val);
Id =:= 283 ->
'S1AP-IEs':enc_PendingDataIndication(Val);
Id =:= 299 ->
'S1AP-IEs':enc_AdditionalRRMPriorityIndex(Val);
Id =:= 301 ->
'S1AP-IEs':'enc_IAB-Authorized'(Val);
Id =:= 306 ->
'S1AP-IEs':enc_NRV2XServicesAuthorized(Val);
Id =:= 307 ->
'S1AP-IEs':enc_NRUESidelinkAggregateMaximumBitrate(Val);
Id =:= 308 ->
'S1AP-IEs':enc_PC5QoSParameters(Val);
Id =:= 314 ->
'S1AP-IEs':enc_UERadioCapabilityID(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value128(Val, Id) ->
if Id =:= 52 ->
'enc_E-RABToBeSetupItemCtxtSUReq'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value13(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value134(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 48 ->
'S1AP-IEs':'enc_E-RABList'(Val);
Id =:= 51 ->
'enc_E-RABSetupListCtxtSURes'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value137(Val, Id) ->
if Id =:= 50 ->
'enc_E-RABSetupItemCtxtSURes'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value141(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value144(Val, Id) ->
if Id =:= 43 ->
'S1AP-IEs':enc_UEPagingID(Val);
Id =:= 44 ->
'S1AP-IEs':enc_PagingDRX(Val);
Id =:= 46 ->
enc_TAIList(Val);
Id =:= 80 ->
'S1AP-IEs':enc_UEIdentityIndexValue(Val);
Id =:= 109 ->
'S1AP-IEs':enc_CNDomain(Val);
Id =:= 128 ->
'S1AP-IEs':'enc_CSG-IdList'(Val);
Id =:= 151 ->
'S1AP-IEs':enc_PagingPriority(Val);
Id =:= 198 ->
'S1AP-IEs':enc_UERadioCapabilityForPaging(Val);
Id =:= 211 ->
'S1AP-IEs':enc_AssistanceDataForPaging(Val);
Id =:= 227 ->
'S1AP-IEs':'enc_Paging-eDRXInformation'(Val);
Id =:= 231 ->
'S1AP-IEs':'enc_Extended-UEIdentityIndexValue'(Val);
Id =:= 239 ->
'S1AP-IEs':'enc_NB-IoT-Paging-eDRXInformation'(Val);
Id =:= 244 ->
'S1AP-IEs':'enc_NB-IoT-UEIdentityIndexValue'(Val);
Id =:= 251 ->
'S1AP-IEs':enc_EnhancedCoverageRestricted(Val);
Id =:= 271 ->
'S1AP-IEs':'enc_CE-ModeBRestricted'(Val);
Id =:= 304 ->
'S1AP-IEs':enc_DataSize(Val);
Id =:= 323 ->
'S1AP-IEs':'enc_WUS-Assistance-Information'(Val);
Id =:= 324 ->
'S1AP-IEs':'enc_NB-IoT-PagingDRX'(Val);
Id =:= 331 ->
'S1AP-IEs':enc_PagingCause(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value147(Val, Id) ->
if Id =:= 47 ->
enc_TAIItem(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value151(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 164 ->
'S1AP-IEs':enc_GWContextReleaseIndication(Val);
Id =:= 264 ->
'S1AP-IEs':enc_SecondaryRATDataUsageReportList(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value154(Val, Id) ->
if Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 99 ->
'S1AP-IEs':'enc_UE-S1AP-IDs'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value157(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 189 ->
'S1AP-IEs':enc_UserLocationInformation(Val);
Id =:= 212 ->
'S1AP-IEs':enc_CellIdentifierAndCELevelForCECapableUEs(Val);
Id =:= 213 ->
'S1AP-IEs':enc_InformationOnRecommendedCellsAndENBsForPaging(Val);
Id =:= 264 ->
'S1AP-IEs':enc_SecondaryRATDataUsageReportList(Val);
Id =:= 297 ->
'S1AP-IEs':enc_TimeSinceSecondaryNodeRelease(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value16(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 1 ->
'S1AP-IEs':enc_HandoverType(Val);
Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 25 ->
'S1AP-IEs':enc_TraceActivation(Val);
Id =:= 40 ->
'S1AP-IEs':enc_SecurityContext(Val);
Id =:= 41 ->
'S1AP-IEs':enc_HandoverRestrictionList(Val);
Id =:= 53 ->
'enc_E-RABToBeSetupListHOReq'(Val);
Id =:= 66 ->
'S1AP-IEs':enc_UEAggregateMaximumBitrate(Val);
Id =:= 75 ->
'S1AP-IEs':enc_GUMMEI(Val);
Id =:= 98 ->
'S1AP-IEs':enc_RequestType(Val);
Id =:= 104 ->
'S1AP-IEs':'enc_Source-ToTarget-TransparentContainer'(Val);
Id =:= 107 ->
'S1AP-IEs':enc_UESecurityCapabilities(Val);
Id =:= 124 ->
'S1AP-IEs':enc_SRVCCOperationPossible(Val);
Id =:= 127 ->
'S1AP-IEs':'enc_CSG-Id'(Val);
Id =:= 136 ->
'S1AP-IEs':'enc_NASSecurityParameterstoE-UTRAN'(Val);
Id =:= 146 ->
'S1AP-IEs':enc_CSGMembershipStatus(Val);
Id =:= 158 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 165 ->
'S1AP-IEs':enc_ManagementBasedMDTAllowed(Val);
Id =:= 177 ->
'S1AP-IEs':enc_MDTPLMNList(Val);
Id =:= 192 ->
'S1AP-IEs':'enc_Masked-IMEISV'(Val);
Id =:= 195 ->
'S1AP-IEs':enc_ProSeAuthorized(Val);
Id =:= 196 ->
'S1AP-IEs':enc_ExpectedUEBehaviour(Val);
Id =:= 240 ->
'S1AP-IEs':enc_V2XServicesAuthorized(Val);
Id =:= 241 ->
'S1AP-IEs':enc_UEUserPlaneCIoTSupportIndicator(Val);
Id =:= 248 ->
'S1AP-IEs':enc_UESidelinkAggregateMaximumBitrate(Val);
Id =:= 251 ->
'S1AP-IEs':enc_EnhancedCoverageRestricted(Val);
Id =:= 269 ->
'S1AP-IEs':enc_NRUESecurityCapabilities(Val);
Id =:= 271 ->
'S1AP-IEs':'enc_CE-ModeBRestricted'(Val);
Id =:= 277 ->
'S1AP-IEs':enc_AerialUEsubscriptionInformation(Val);
Id =:= 278 ->
'S1AP-IEs':'enc_Subscription-Based-UE-DifferentiationInfo'(Val);
Id =:= 283 ->
'S1AP-IEs':enc_PendingDataIndication(Val);
Id =:= 299 ->
'S1AP-IEs':enc_AdditionalRRMPriorityIndex(Val);
Id =:= 301 ->
'S1AP-IEs':'enc_IAB-Authorized'(Val);
Id =:= 306 ->
'S1AP-IEs':enc_NRV2XServicesAuthorized(Val);
Id =:= 307 ->
'S1AP-IEs':enc_NRUESidelinkAggregateMaximumBitrate(Val);
Id =:= 308 ->
'S1AP-IEs':enc_PC5QoSParameters(Val);
Id =:= 314 ->
'S1AP-IEs':enc_UERadioCapabilityID(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value160(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 66 ->
'S1AP-IEs':enc_UEAggregateMaximumBitrate(Val);
Id =:= 73 ->
'S1AP-IEs':enc_SecurityKey(Val);
Id =:= 106 ->
'S1AP-IEs':enc_SubscriberProfileIDforRFP(Val);
Id =:= 107 ->
'S1AP-IEs':enc_UESecurityCapabilities(Val);
Id =:= 108 ->
'S1AP-IEs':enc_CSFallbackIndicator(Val);
Id =:= 124 ->
'S1AP-IEs':enc_SRVCCOperationPossible(Val);
Id =:= 146 ->
'S1AP-IEs':enc_CSGMembershipStatus(Val);
Id =:= 159 ->
'S1AP-IEs':enc_LAI(Val);
Id =:= 187 ->
'S1AP-IEs':enc_AdditionalCSFallbackIndicator(Val);
Id =:= 195 ->
'S1AP-IEs':enc_ProSeAuthorized(Val);
Id =:= 240 ->
'S1AP-IEs':enc_V2XServicesAuthorized(Val);
Id =:= 243 ->
'S1AP-IEs':enc_SRVCCOperationNotPossible(Val);
Id =:= 248 ->
'S1AP-IEs':enc_UESidelinkAggregateMaximumBitrate(Val);
Id =:= 269 ->
'S1AP-IEs':enc_NRUESecurityCapabilities(Val);
Id =:= 277 ->
'S1AP-IEs':enc_AerialUEsubscriptionInformation(Val);
Id =:= 299 ->
'S1AP-IEs':enc_AdditionalRRMPriorityIndex(Val);
Id =:= 301 ->
'S1AP-IEs':'enc_IAB-Authorized'(Val);
Id =:= 306 ->
'S1AP-IEs':enc_NRV2XServicesAuthorized(Val);
Id =:= 307 ->
'S1AP-IEs':enc_NRUESidelinkAggregateMaximumBitrate(Val);
Id =:= 308 ->
'S1AP-IEs':enc_PC5QoSParameters(Val);
Id =:= 314 ->
'S1AP-IEs':enc_UERadioCapabilityID(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value163(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value166(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value169(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 74 ->
'S1AP-IEs':enc_UERadioCapability(Val);
Id =:= 314 ->
'S1AP-IEs':enc_UERadioCapabilityID(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value172(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 169 ->
'S1AP-IEs':enc_VoiceSupportMatchIndicator(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value175(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 26 ->
'S1AP-IEs':'enc_NAS-PDU'(Val);
Id =:= 41 ->
'S1AP-IEs':enc_HandoverRestrictionList(Val);
Id =:= 74 ->
'S1AP-IEs':enc_UERadioCapability(Val);
Id =:= 106 ->
'S1AP-IEs':enc_SubscriberProfileIDforRFP(Val);
Id =:= 124 ->
'S1AP-IEs':enc_SRVCCOperationPossible(Val);
Id =:= 192 ->
'S1AP-IEs':'enc_Masked-IMEISV'(Val);
Id =:= 249 ->
'S1AP-IEs':enc_DLNASPDUDeliveryAckRequest(Val);
Id =:= 251 ->
'S1AP-IEs':enc_EnhancedCoverageRestricted(Val);
Id =:= 269 ->
'S1AP-IEs':enc_NRUESecurityCapabilities(Val);
Id =:= 271 ->
'S1AP-IEs':'enc_CE-ModeBRestricted'(Val);
Id =:= 275 ->
'S1AP-IEs':enc_UECapabilityInfoRequest(Val);
Id =:= 278 ->
'S1AP-IEs':'enc_Subscription-Based-UE-DifferentiationInfo'(Val);
Id =:= 280 ->
'S1AP-IEs':enc_EndIndication(Val);
Id =:= 283 ->
'S1AP-IEs':enc_PendingDataIndication(Val);
Id =:= 299 ->
'S1AP-IEs':enc_AdditionalRRMPriorityIndex(Val);
Id =:= 314 ->
'S1AP-IEs':enc_UERadioCapabilityID(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value178(Val, Id) ->
if Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 26 ->
'S1AP-IEs':'enc_NAS-PDU'(Val);
Id =:= 67 ->
'S1AP-IEs':enc_TAI(Val);
Id =:= 75 ->
'S1AP-IEs':enc_GUMMEI(Val);
Id =:= 96 ->
'S1AP-IEs':'enc_S-TMSI'(Val);
Id =:= 100 ->
'S1AP-IEs':'enc_EUTRAN-CGI'(Val);
Id =:= 127 ->
'S1AP-IEs':'enc_CSG-Id'(Val);
Id =:= 134 ->
'S1AP-IEs':'enc_RRC-Establishment-Cause'(Val);
Id =:= 145 ->
'S1AP-IEs':enc_CellAccessMode(Val);
Id =:= 155 ->
'S1AP-IEs':enc_TransportLayerAddress(Val);
Id =:= 160 ->
'S1AP-IEs':'enc_RelayNode-Indicator'(Val);
Id =:= 170 ->
'S1AP-IEs':enc_GUMMEIType(Val);
Id =:= 176 ->
'S1AP-IEs':enc_TunnelInformation(Val);
Id =:= 184 ->
'S1AP-IEs':enc_TransportLayerAddress(Val);
Id =:= 186 ->
'S1AP-IEs':'enc_LHN-ID'(Val);
Id =:= 223 ->
'S1AP-IEs':'enc_MME-Group-ID'(Val);
Id =:= 230 ->
'S1AP-IEs':'enc_UE-Usage-Type'(Val);
Id =:= 242 ->
'S1AP-IEs':'enc_CE-mode-B-SupportIndicator'(Val);
Id =:= 246 ->
'S1AP-IEs':'enc_DCN-ID'(Val);
Id =:= 250 ->
'S1AP-IEs':'enc_Coverage-Level'(Val);
Id =:= 263 ->
'S1AP-IEs':'enc_UE-Application-Layer-Measurement-Capability'(Val);
Id =:= 281 ->
'S1AP-IEs':'enc_EDT-Session'(Val);
Id =:= 302 ->
'S1AP-IEs':'enc_IAB-Node-Indication'(Val);
Id =:= 339 ->
'S1AP-IEs':'enc_LTE-NTN-TAI-Information'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value181(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 26 ->
'S1AP-IEs':'enc_NAS-PDU'(Val);
Id =:= 67 ->
'S1AP-IEs':enc_TAI(Val);
Id =:= 100 ->
'S1AP-IEs':'enc_EUTRAN-CGI'(Val);
Id =:= 155 ->
'S1AP-IEs':enc_TransportLayerAddress(Val);
Id =:= 184 ->
'S1AP-IEs':enc_TransportLayerAddress(Val);
Id =:= 186 ->
'S1AP-IEs':'enc_LHN-ID'(Val);
Id =:= 288 ->
'S1AP-IEs':enc_PSCellInformation(Val);
Id =:= 339 ->
'S1AP-IEs':'enc_LTE-NTN-TAI-Information'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value184(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 26 ->
'S1AP-IEs':'enc_NAS-PDU'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value187(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 223 ->
'S1AP-IEs':'enc_MME-Group-ID'(Val);
Id =:= 224 ->
'S1AP-IEs':'enc_Additional-GUTI'(Val);
Id =:= 225 ->
'enc_S1-Message'(Val);
Id =:= 230 ->
'S1AP-IEs':'enc_UE-Usage-Type'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value19(Val, Id) ->
if Id =:= 27 ->
'enc_E-RABToBeSetupItemHOReq'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value190(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value193(Val, Id) ->
if Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 92 ->
enc_ResetType(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value196(Val, Id) ->
if Id =:= 91 ->
'S1AP-IEs':'enc_UE-associatedLogicalS1-ConnectionItem'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value199(Val, Id) ->
if Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 93 ->
'enc_UE-associatedLogicalS1-ConnectionListResAck'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value202(Val, Id) ->
if Id =:= 91 ->
'S1AP-IEs':'enc_UE-associatedLogicalS1-ConnectionItem'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value205(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 96 ->
'S1AP-IEs':'enc_S-TMSI'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value208(Val, Id) ->
if Id =:= 59 ->
'S1AP-IEs':'enc_Global-ENB-ID'(Val);
Id =:= 60 ->
'S1AP-IEs':enc_ENBname(Val);
Id =:= 64 ->
'S1AP-IEs':enc_SupportedTAs(Val);
Id =:= 128 ->
'S1AP-IEs':'enc_CSG-IdList'(Val);
Id =:= 137 ->
'S1AP-IEs':enc_PagingDRX(Val);
Id =:= 228 ->
'S1AP-IEs':'enc_UE-RetentionInformation'(Val);
Id =:= 234 ->
'S1AP-IEs':'enc_NB-IoT-DefaultPagingDRX'(Val);
Id =:= 291 ->
'S1AP-IEs':enc_ConnectedengNBList(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value211(Val, Id) ->
if Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 61 ->
'S1AP-IEs':enc_MMEname(Val);
Id =:= 87 ->
'S1AP-IEs':enc_RelativeMMECapacity(Val);
Id =:= 105 ->
'S1AP-IEs':enc_ServedGUMMEIs(Val);
Id =:= 163 ->
'S1AP-IEs':enc_MMERelaySupportIndicator(Val);
Id =:= 228 ->
'S1AP-IEs':'enc_UE-RetentionInformation'(Val);
Id =:= 247 ->
'S1AP-IEs':enc_ServedDCNs(Val);
Id =:= 303 ->
'S1AP-IEs':'enc_IAB-Supported'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value214(Val, Id) ->
if Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 65 ->
'S1AP-IEs':enc_TimeToWait(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value217(Val, Id) ->
if Id =:= 60 ->
'S1AP-IEs':enc_ENBname(Val);
Id =:= 64 ->
'S1AP-IEs':enc_SupportedTAs(Val);
Id =:= 128 ->
'S1AP-IEs':'enc_CSG-IdList'(Val);
Id =:= 137 ->
'S1AP-IEs':enc_PagingDRX(Val);
Id =:= 234 ->
'S1AP-IEs':'enc_NB-IoT-DefaultPagingDRX'(Val);
Id =:= 292 ->
'S1AP-IEs':enc_ConnectedengNBList(Val);
Id =:= 293 ->
'S1AP-IEs':enc_ConnectedengNBList(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value220(Val, Id) ->
if Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value223(Val, Id) ->
if Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 65 ->
'S1AP-IEs':enc_TimeToWait(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value226(Val, Id) ->
if Id =:= 61 ->
'S1AP-IEs':enc_MMEname(Val);
Id =:= 87 ->
'S1AP-IEs':enc_RelativeMMECapacity(Val);
Id =:= 105 ->
'S1AP-IEs':enc_ServedGUMMEIs(Val);
Id =:= 247 ->
'S1AP-IEs':enc_ServedDCNs(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value229(Val, Id) ->
if Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value232(Val, Id) ->
if Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 65 ->
'S1AP-IEs':enc_TimeToWait(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value235(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 12 ->
'enc_E-RABSubjecttoDataForwardingList'(Val);
Id =:= 70 ->
'S1AP-IEs':enc_Cdma2000PDU(Val);
Id =:= 71 ->
'S1AP-IEs':enc_Cdma2000RATType(Val);
Id =:= 83 ->
'S1AP-IEs':enc_Cdma2000HOStatus(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value238(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 70 ->
'S1AP-IEs':enc_Cdma2000PDU(Val);
Id =:= 71 ->
'S1AP-IEs':enc_Cdma2000RATType(Val);
Id =:= 72 ->
'S1AP-IEs':enc_Cdma2000SectorID(Val);
Id =:= 84 ->
'S1AP-IEs':enc_Cdma2000HORequiredIndication(Val);
Id =:= 97 ->
'S1AP-IEs':enc_Cdma2000OneXRAND(Val);
Id =:= 102 ->
'S1AP-IEs':enc_Cdma2000OneXSRVCCInfo(Val);
Id =:= 140 ->
'S1AP-IEs':enc_EUTRANRoundTripDelayEstimationInfo(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value241(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 74 ->
'S1AP-IEs':enc_UERadioCapability(Val);
Id =:= 198 ->
'S1AP-IEs':enc_UERadioCapabilityForPaging(Val);
Id =:= 263 ->
'S1AP-IEs':'enc_UE-Application-Layer-Measurement-Capability'(Val);
Id =:= 272 ->
'S1AP-IEs':'enc_LTE-M-Indication'(Val);
Id =:= 315 ->
'S1AP-IEs':enc_UERadioCapability(Val);
Id =:= 327 ->
'S1AP-IEs':enc_UERadioCapabilityForPaging(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value244(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 90 ->
'S1AP-IEs':'enc_ENB-StatusTransfer-TransparentContainer'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value247(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 90 ->
'S1AP-IEs':'enc_ENB-StatusTransfer-TransparentContainer'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value25(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 18 ->
'enc_E-RABAdmittedList'(Val);
Id =:= 19 ->
'enc_E-RABFailedtoSetupListHOReqAck'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 123 ->
'S1AP-IEs':'enc_Target-ToSource-TransparentContainer'(Val);
Id =:= 127 ->
'S1AP-IEs':'enc_CSG-Id'(Val);
Id =:= 145 ->
'S1AP-IEs':enc_CellAccessMode(Val);
Id =:= 242 ->
'S1AP-IEs':'enc_CE-mode-B-SupportIndicator'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value250(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 25 ->
'S1AP-IEs':enc_TraceActivation(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value253(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 86 ->
'S1AP-IEs':'enc_E-UTRAN-Trace-ID'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value256(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 86 ->
'S1AP-IEs':'enc_E-UTRAN-Trace-ID'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value259(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 86 ->
'S1AP-IEs':'enc_E-UTRAN-Trace-ID'(Val);
Id =:= 100 ->
'S1AP-IEs':'enc_EUTRAN-CGI'(Val);
Id =:= 131 ->
'S1AP-IEs':enc_TransportLayerAddress(Val);
Id =:= 166 ->
'S1AP-IEs':enc_PrivacyIndicator(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value262(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 98 ->
'S1AP-IEs':enc_RequestType(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value265(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value268(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 67 ->
'S1AP-IEs':enc_TAI(Val);
Id =:= 98 ->
'S1AP-IEs':enc_RequestType(Val);
Id =:= 100 ->
'S1AP-IEs':'enc_EUTRAN-CGI'(Val);
Id =:= 288 ->
'S1AP-IEs':enc_PSCellInformation(Val);
Id =:= 339 ->
'S1AP-IEs':'enc_LTE-NTN-TAI-Information'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value271(Val, Id) ->
if Id =:= 101 ->
'S1AP-IEs':enc_OverloadResponse(Val);
Id =:= 154 ->
'S1AP-IEs':enc_GUMMEIList(Val);
Id =:= 161 ->
'S1AP-IEs':enc_TrafficLoadReductionIndication(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value274(Val, Id) ->
if Id =:= 154 ->
'S1AP-IEs':enc_GUMMEIList(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value277(Val, Id) ->
if Id =:= 111 ->
'S1AP-IEs':enc_MessageIdentifier(Val);
Id =:= 112 ->
'S1AP-IEs':enc_SerialNumber(Val);
Id =:= 113 ->
'S1AP-IEs':enc_WarningAreaList(Val);
Id =:= 114 ->
'S1AP-IEs':enc_RepetitionPeriod(Val);
Id =:= 115 ->
'S1AP-IEs':enc_NumberofBroadcastRequest(Val);
Id =:= 116 ->
'S1AP-IEs':enc_WarningType(Val);
Id =:= 117 ->
'S1AP-IEs':enc_WarningSecurityInfo(Val);
Id =:= 118 ->
'S1AP-IEs':enc_DataCodingScheme(Val);
Id =:= 119 ->
'S1AP-IEs':enc_WarningMessageContents(Val);
Id =:= 142 ->
'S1AP-IEs':enc_ConcurrentWarningMessageIndicator(Val);
Id =:= 144 ->
'S1AP-IEs':enc_ExtendedRepetitionPeriod(Val);
Id =:= 286 ->
'S1AP-IEs':enc_WarningAreaCoordinates(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value28(Val, Id) ->
if Id =:= 20 ->
'enc_E-RABAdmittedItem'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value280(Val, Id) ->
if Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 111 ->
'S1AP-IEs':enc_MessageIdentifier(Val);
Id =:= 112 ->
'S1AP-IEs':enc_SerialNumber(Val);
Id =:= 120 ->
'S1AP-IEs':enc_BroadcastCompletedAreaList(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value283(Val, Id) ->
if Id =:= 121 ->
'enc_Inter-SystemInformationTransferType'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value286(Val, Id) ->
if Id =:= 122 ->
'enc_Inter-SystemInformationTransferType'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value289(Val, Id) ->
if Id =:= 129 ->
'S1AP-IEs':enc_SONConfigurationTransfer(Val);
Id =:= 294 ->
'S1AP-IEs':'enc_EN-DCSONConfigurationTransfer'(Val);
Id =:= 310 ->
'S1AP-IEs':enc_IntersystemSONConfigurationTransfer(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value292(Val, Id) ->
if Id =:= 130 ->
'S1AP-IEs':enc_SONConfigurationTransfer(Val);
Id =:= 295 ->
'S1AP-IEs':'enc_EN-DCSONConfigurationTransfer'(Val);
Id =:= 309 ->
'S1AP-IEs':enc_IntersystemSONConfigurationTransfer(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value296(Val, Id) ->
if Id =:= 111 ->
'S1AP-IEs':enc_MessageIdentifier(Val);
Id =:= 112 ->
'S1AP-IEs':enc_SerialNumber(Val);
Id =:= 113 ->
'S1AP-IEs':enc_WarningAreaList(Val);
Id =:= 191 ->
'S1AP-IEs':enc_KillAllWarningMessages(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value299(Val, Id) ->
if Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 111 ->
'S1AP-IEs':enc_MessageIdentifier(Val);
Id =:= 112 ->
'S1AP-IEs':enc_SerialNumber(Val);
Id =:= 141 ->
'S1AP-IEs':enc_BroadcastCancelledAreaList(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value302(Val, Id) ->
if Id =:= 59 ->
'S1AP-IEs':'enc_Global-ENB-ID'(Val);
Id =:= 182 ->
'S1AP-IEs':enc_ECGIListForRestart(Val);
Id =:= 188 ->
'S1AP-IEs':enc_TAIListForRestart(Val);
Id =:= 190 ->
'S1AP-IEs':enc_EmergencyAreaIDListForRestart(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value305(Val, Id) ->
if Id =:= 59 ->
'S1AP-IEs':'enc_Global-ENB-ID'(Val);
Id =:= 222 ->
'S1AP-IEs':enc_PWSfailedECGIList(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value308(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 147 ->
'S1AP-IEs':'enc_LPPa-PDU'(Val);
Id =:= 148 ->
'S1AP-IEs':'enc_Routing-ID'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value311(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 147 ->
'S1AP-IEs':'enc_LPPa-PDU'(Val);
Id =:= 148 ->
'S1AP-IEs':'enc_Routing-ID'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value314(Val, Id) ->
if Id =:= 147 ->
'S1AP-IEs':'enc_LPPa-PDU'(Val);
Id =:= 148 ->
'S1AP-IEs':'enc_Routing-ID'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value317(Val, Id) ->
if Id =:= 147 ->
'S1AP-IEs':'enc_LPPa-PDU'(Val);
Id =:= 148 ->
'S1AP-IEs':'enc_Routing-ID'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value32(Val, Id) ->
if Id =:= 21 ->
'enc_E-RABFailedToSetupItemHOReqAck'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value320(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 176 ->
'S1AP-IEs':enc_TunnelInformation(Val);
Id =:= 189 ->
'S1AP-IEs':enc_UserLocationInformation(Val);
Id =:= 199 ->
'enc_E-RABToBeModifiedListBearerModInd'(Val);
Id =:= 201 ->
'enc_E-RABNotToBeModifiedListBearerModInd'(Val);
Id =:= 226 ->
enc_CSGMembershipInfo(Val);
Id =:= 264 ->
'S1AP-IEs':enc_SecondaryRATDataUsageReportList(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value323(Val, Id) ->
if Id =:= 200 ->
'enc_E-RABToBeModifiedItemBearerModInd'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value327(Val, Id) ->
if Id =:= 202 ->
'enc_E-RABNotToBeModifiedItemBearerModInd'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value332(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 146 ->
'S1AP-IEs':enc_CSGMembershipStatus(Val);
Id =:= 203 ->
'enc_E-RABModifyListBearerModConf'(Val);
Id =:= 205 ->
'S1AP-IEs':'enc_E-RABList'(Val);
Id =:= 210 ->
'S1AP-IEs':'enc_E-RABList'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value335(Val, Id) ->
if Id =:= 204 ->
'enc_E-RABModifyItemBearerModConf'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value339(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 226 ->
enc_CSGMembershipInfo(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value342(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 146 ->
'S1AP-IEs':enc_CSGMembershipStatus(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value345(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 189 ->
'S1AP-IEs':enc_UserLocationInformation(Val);
Id =:= 212 ->
'S1AP-IEs':enc_CellIdentifierAndCELevelForCECapableUEs(Val);
Id =:= 213 ->
'S1AP-IEs':enc_InformationOnRecommendedCellsAndENBsForPaging(Val);
Id =:= 264 ->
'S1AP-IEs':enc_SecondaryRATDataUsageReportList(Val);
Id =:= 297 ->
'S1AP-IEs':enc_TimeSinceSecondaryNodeRelease(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value348(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 40 ->
'S1AP-IEs':enc_SecurityContext(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value351(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 235 ->
'enc_E-RABFailedToResumeListResumeReq'(Val);
Id =:= 245 ->
'S1AP-IEs':'enc_RRC-Establishment-Cause'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value354(Val, Id) ->
if Id =:= 236 ->
'enc_E-RABFailedToResumeItemResumeReq'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value358(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 40 ->
'S1AP-IEs':enc_SecurityContext(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 237 ->
'enc_E-RABFailedToResumeListResumeRes'(Val);
Id =:= 283 ->
'S1AP-IEs':enc_PendingDataIndication(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value36(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value361(Val, Id) ->
if Id =:= 238 ->
'enc_E-RABFailedToResumeItemResumeRes'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value365(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value368(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 74 ->
'S1AP-IEs':enc_UERadioCapability(Val);
Id =:= 192 ->
'S1AP-IEs':'enc_Masked-IMEISV'(Val);
Id =:= 251 ->
'S1AP-IEs':enc_EnhancedCoverageRestricted(Val);
Id =:= 252 ->
'S1AP-IEs':'enc_E-RABLevelQoSParameters'(Val);
Id =:= 253 ->
'S1AP-IEs':'enc_DL-CP-SecurityInformation'(Val);
Id =:= 271 ->
'S1AP-IEs':'enc_CE-ModeBRestricted'(Val);
Id =:= 278 ->
'S1AP-IEs':'enc_Subscription-Based-UE-DifferentiationInfo'(Val);
Id =:= 280 ->
'S1AP-IEs':enc_EndIndication(Val);
Id =:= 314 ->
'S1AP-IEs':enc_UERadioCapabilityID(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value371(Val, Id) ->
if Id =:= 96 ->
'S1AP-IEs':'enc_S-TMSI'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value374(Val, Id) ->
if Id =:= 74 ->
'S1AP-IEs':enc_UERadioCapability(Val);
Id =:= 96 ->
'S1AP-IEs':'enc_S-TMSI'(Val);
Id =:= 192 ->
'S1AP-IEs':'enc_Masked-IMEISV'(Val);
Id =:= 252 ->
'S1AP-IEs':'enc_E-RABLevelQoSParameters'(Val);
Id =:= 278 ->
'S1AP-IEs':'enc_Subscription-Based-UE-DifferentiationInfo'(Val);
Id =:= 283 ->
'S1AP-IEs':enc_PendingDataIndication(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value377(Val, Id) ->
if Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 67 ->
'S1AP-IEs':enc_TAI(Val);
Id =:= 96 ->
'S1AP-IEs':'enc_S-TMSI'(Val);
Id =:= 100 ->
'S1AP-IEs':'enc_EUTRAN-CGI'(Val);
Id =:= 254 ->
'S1AP-IEs':'enc_UL-CP-SecurityInformation'(Val);
Id =:= 339 ->
'S1AP-IEs':'enc_LTE-NTN-TAI-Information'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value380(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value383(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 189 ->
'S1AP-IEs':enc_UserLocationInformation(Val);
Id =:= 264 ->
'S1AP-IEs':enc_SecondaryRATDataUsageReportList(Val);
Id =:= 266 ->
'S1AP-IEs':enc_HandoverFlag(Val);
Id =:= 297 ->
'S1AP-IEs':enc_TimeSinceSecondaryNodeRelease(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value386(Val, Id) ->
if Id =:= 314 ->
'S1AP-IEs':enc_UERadioCapabilityID(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value389(Val, Id) ->
if Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 74 ->
'S1AP-IEs':enc_UERadioCapability(Val);
Id =:= 314 ->
'S1AP-IEs':enc_UERadioCapabilityID(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value39(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 67 ->
'S1AP-IEs':enc_TAI(Val);
Id =:= 100 ->
'S1AP-IEs':'enc_EUTRAN-CGI'(Val);
Id =:= 176 ->
'S1AP-IEs':enc_TunnelInformation(Val);
Id =:= 186 ->
'S1AP-IEs':'enc_LHN-ID'(Val);
Id =:= 288 ->
'S1AP-IEs':enc_PSCellInformation(Val);
Id =:= 320 ->
'S1AP-IEs':enc_NotifySourceeNB(Val);
Id =:= 339 ->
'S1AP-IEs':'enc_LTE-NTN-TAI-Information'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value4(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 1 ->
'S1AP-IEs':enc_HandoverType(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 12 ->
'enc_E-RABSubjecttoDataForwardingList'(Val);
Id =:= 13 ->
'S1AP-IEs':'enc_E-RABList'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 123 ->
'S1AP-IEs':'enc_Target-ToSource-TransparentContainer'(Val);
Id =:= 135 ->
'S1AP-IEs':'enc_NASSecurityParametersfromE-UTRAN'(Val);
Id =:= 139 ->
'S1AP-IEs':'enc_Target-ToSource-TransparentContainer'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value42(Val, Id) ->
if Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 22 ->
'enc_E-RABToBeSwitchedDLList'(Val);
Id =:= 67 ->
'S1AP-IEs':enc_TAI(Val);
Id =:= 88 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 100 ->
'S1AP-IEs':'enc_EUTRAN-CGI'(Val);
Id =:= 107 ->
'S1AP-IEs':enc_UESecurityCapabilities(Val);
Id =:= 127 ->
'S1AP-IEs':'enc_CSG-Id'(Val);
Id =:= 145 ->
'S1AP-IEs':enc_CellAccessMode(Val);
Id =:= 146 ->
'S1AP-IEs':enc_CSGMembershipStatus(Val);
Id =:= 157 ->
'S1AP-IEs':enc_GUMMEI(Val);
Id =:= 176 ->
'S1AP-IEs':enc_TunnelInformation(Val);
Id =:= 186 ->
'S1AP-IEs':'enc_LHN-ID'(Val);
Id =:= 245 ->
'S1AP-IEs':'enc_RRC-Establishment-Cause'(Val);
Id =:= 269 ->
'S1AP-IEs':enc_NRUESecurityCapabilities(Val);
Id =:= 288 ->
'S1AP-IEs':enc_PSCellInformation(Val);
Id =:= 339 ->
'S1AP-IEs':'enc_LTE-NTN-TAI-Information'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value45(Val, Id) ->
if Id =:= 23 ->
'enc_E-RABToBeSwitchedDLItem'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value51(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 33 ->
'S1AP-IEs':'enc_E-RABList'(Val);
Id =:= 40 ->
'S1AP-IEs':enc_SecurityContext(Val);
Id =:= 41 ->
'S1AP-IEs':enc_HandoverRestrictionList(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 66 ->
'S1AP-IEs':enc_UEAggregateMaximumBitrate(Val);
Id =:= 95 ->
'enc_E-RABToBeSwitchedULList'(Val);
Id =:= 107 ->
'S1AP-IEs':enc_UESecurityCapabilities(Val);
Id =:= 146 ->
'S1AP-IEs':enc_CSGMembershipStatus(Val);
Id =:= 158 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 195 ->
'S1AP-IEs':enc_ProSeAuthorized(Val);
Id =:= 240 ->
'S1AP-IEs':enc_V2XServicesAuthorized(Val);
Id =:= 241 ->
'S1AP-IEs':enc_UEUserPlaneCIoTSupportIndicator(Val);
Id =:= 248 ->
'S1AP-IEs':enc_UESidelinkAggregateMaximumBitrate(Val);
Id =:= 251 ->
'S1AP-IEs':enc_EnhancedCoverageRestricted(Val);
Id =:= 269 ->
'S1AP-IEs':enc_NRUESecurityCapabilities(Val);
Id =:= 271 ->
'S1AP-IEs':'enc_CE-ModeBRestricted'(Val);
Id =:= 277 ->
'S1AP-IEs':enc_AerialUEsubscriptionInformation(Val);
Id =:= 278 ->
'S1AP-IEs':'enc_Subscription-Based-UE-DifferentiationInfo'(Val);
Id =:= 283 ->
'S1AP-IEs':enc_PendingDataIndication(Val);
Id =:= 299 ->
'S1AP-IEs':enc_AdditionalRRMPriorityIndex(Val);
Id =:= 306 ->
'S1AP-IEs':enc_NRV2XServicesAuthorized(Val);
Id =:= 307 ->
'S1AP-IEs':enc_NRUESidelinkAggregateMaximumBitrate(Val);
Id =:= 308 ->
'S1AP-IEs':enc_PC5QoSParameters(Val);
Id =:= 314 ->
'S1AP-IEs':enc_UERadioCapabilityID(Val);
Id =:= 341 ->
'enc_E-RABToBeUpdatedList'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value54(Val, Id) ->
if Id =:= 94 ->
'enc_E-RABToBeSwitchedULItem'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value58(Val, Id) ->
if Id =:= 342 ->
'enc_E-RABToBeUpdatedItem'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value62(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value65(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 2 ->
'S1AP-IEs':enc_Cause(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value68(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value7(Val, Id) ->
if Id =:= 14 ->
'enc_E-RABDataForwardingItem'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value71(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value74(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 321 ->
'S1AP-IEs':'enc_ENB-EarlyStatusTransfer-TransparentContainer'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value77(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 321 ->
'S1AP-IEs':'enc_ENB-EarlyStatusTransfer-TransparentContainer'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value80(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 16 ->
'enc_E-RABToBeSetupListBearerSUReq'(Val);
Id =:= 66 ->
'S1AP-IEs':enc_UEAggregateMaximumBitrate(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value83(Val, Id) ->
if Id =:= 17 ->
'enc_E-RABToBeSetupItemBearerSUReq'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value89(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 28 ->
'enc_E-RABSetupListBearerSURes'(Val);
Id =:= 29 ->
'S1AP-IEs':'enc_E-RABList'(Val);
Id =:= 58 ->
'S1AP-IEs':enc_CriticalityDiagnostics(Val);
Id =:= 189 ->
'S1AP-IEs':enc_UserLocationInformation(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value92(Val, Id) ->
if Id =:= 39 ->
'enc_E-RABSetupItemBearerSURes'(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value96(Val, Id) ->
if Id =:= 0 ->
'S1AP-IEs':'enc_MME-UE-S1AP-ID'(Val);
Id =:= 8 ->
'S1AP-IEs':'enc_ENB-UE-S1AP-ID'(Val);
Id =:= 30 ->
'enc_E-RABToBeModifiedListBearerModReq'(Val);
Id =:= 66 ->
'S1AP-IEs':enc_UEAggregateMaximumBitrate(Val);
Id =:= 268 ->
'S1AP-IEs':enc_SecondaryRATDataUsageRequest(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_Value99(Val, Id) ->
if Id =:= 36 ->
'enc_E-RABToBeModifiedItemBearerModReq'(Val);
true ->
open_type_to_binary(Val)
end.

align(Bin) when is_binary(Bin) ->
    Bin;
align(BitStr) when is_bitstring(BitStr) ->
    AlignBits = bit_size(BitStr) rem 8,
    <<_:AlignBits,Rest/binary>> = BitStr,
    Rest.

complete(L0) ->
    L = complete(L0, []),
    case list_to_bitstring(L) of
        <<>> ->
            <<0>>;
        Bin ->
            Bin
    end.

complete([], Bits, []) ->
    case Bits band 7 of
        0 ->
            [];
        N ->
            [<<0:(8 - N)>>]
    end;
complete([], Bits, [H | More]) ->
    complete(H, Bits, More);
complete([align | T], Bits, More) ->
    case Bits band 7 of
        0 ->
            complete(T, More);
        1 ->
            [<<0:7>> | complete(T, More)];
        2 ->
            [<<0:6>> | complete(T, More)];
        3 ->
            [<<0:5>> | complete(T, More)];
        4 ->
            [<<0:4>> | complete(T, More)];
        5 ->
            [<<0:3>> | complete(T, More)];
        6 ->
            [<<0:2>> | complete(T, More)];
        7 ->
            [<<0:1>> | complete(T, More)]
    end;
complete([[] | T], Bits, More) ->
    complete(T, Bits, More);
complete([[_ | _] = H], Bits, More) ->
    complete(H, Bits, More);
complete([[_ | _] = H | T], Bits, More) ->
    complete(H, Bits, [T | More]);
complete([H | T], Bits, More) when is_integer(H); is_binary(H) ->
    [H | complete(T, Bits, More)];
complete([H | T], Bits, More) ->
    [H | complete(T, Bits + bit_size(H), More)];
complete(Bin, Bits, More) when is_binary(Bin) ->
    [Bin | complete([], Bits, More)];
complete(Bin, Bits, More) ->
    [Bin | complete([], Bits + bit_size(Bin), More)].

complete([], []) ->
    [];
complete([], [H | More]) ->
    complete(H, More);
complete([align | T], More) ->
    complete(T, More);
complete([[] | T], More) ->
    complete(T, More);
complete([[_ | _] = H], More) ->
    complete(H, More);
complete([[_ | _] = H | T], More) ->
    complete(H, [T | More]);
complete([H | T], More) when is_integer(H); is_binary(H) ->
    [H | complete(T, More)];
complete([H | T], More) ->
    [H | complete(T, bit_size(H), More)];
complete(Bin, More) when is_binary(Bin) ->
    [Bin | complete([], More)];
complete(Bin, More) ->
    [Bin | complete([], bit_size(Bin), More)].

decode_fragmented(SegSz0, Buf0, Unit) ->
    SegSz = SegSz0 * Unit * 16384,
    <<Res:SegSz/bitstring,Buf/bitstring>> = Buf0,
    decode_fragmented_1(Buf, Unit, Res).

decode_fragmented_1(<<0:1,N:7,Buf0/bitstring>>, Unit, Res) ->
    Sz = N * Unit,
    <<S:Sz/bitstring,Buf/bitstring>> = Buf0,
    {<<Res/bitstring,S/bitstring>>, Buf};
decode_fragmented_1(<<1:1,0:1,N:14,Buf0/bitstring>>, Unit, Res) ->
    Sz = N * Unit,
    <<S:Sz/bitstring,Buf/bitstring>> = Buf0,
    {<<Res/bitstring,S/bitstring>>, Buf};
decode_fragmented_1(<<1:1,1:1,SegSz0:6,Buf0/bitstring>>, Unit, Res0) ->
    SegSz = SegSz0 * Unit * 16384,
    <<Frag:SegSz/bitstring,Buf/bitstring>> = Buf0,
    Res = <<Res0/bitstring,Frag/bitstring>>,
    decode_fragmented_1(Buf, Unit, Res).

decode_length(Buffer) ->
    case align(Buffer) of
        <<0:1,Oct:7,Rest/binary>> ->
            {Oct, Rest};
        <<2:2,Val:14,Rest/binary>> ->
            {Val, Rest};
        <<3:2,_Val:14,_Rest/binary>> ->
            exit({error, {asn1, {decode_length, {nyi, above_16k}}}})
    end.

encode_fragmented(Bin, Unit) ->
    encode_fragmented_1(Bin, Unit, 4).

encode_fragmented_1(Bin, Unit, N) ->
    SegSz = Unit * N * 16384,
    case Bin of
        <<B:SegSz/bitstring,T/bitstring>> ->
            [<<3:2,N:6>>, B | encode_fragmented_1(T, Unit, N)];
        _ when N > 1 ->
            encode_fragmented_1(Bin, Unit, N - 1);
        _ ->
            case bit_size(Bin) div Unit of
                Len when Len < 128 ->
                    [Len, Bin];
                Len when Len < 16384 ->
                    [<<2:2,Len:14>>, Bin]
            end
    end.

encode_unconstrained_number(Val) when not is_integer(Val) ->
    exit({error, {asn1, {illegal_integer, Val}}});
encode_unconstrained_number(Val) when Val >= 0 ->
    if
        Val < 128 ->
            [1, Val];
        Val < 256 ->
            [<<2,0>>, Val];
        true ->
            case binary:encode_unsigned(Val) of
                <<0:1,_/bitstring>> = Bin ->
                    case byte_size(Bin) of
                        Sz when Sz < 128 ->
                            [Sz, Bin];
                        Sz when Sz < 16384 ->
                            [<<2:2,Sz:14>>, Bin]
                    end;
                <<1:1,_/bitstring>> = Bin ->
                    case byte_size(Bin) + 1 of
                        Sz when Sz < 128 ->
                            [Sz, 0, Bin];
                        Sz when Sz < 16384 ->
                            [<<2:2,Sz:14,0:8>>, Bin]
                    end
            end
    end;
encode_unconstrained_number(Val) ->
    Oct = enint(Val, []),
    Len = length(Oct),
    if
        Len < 128 ->
            [Len | Oct];
        Len < 16384 ->
            [<<2:2,Len:14>> | Oct]
    end.

enint(-1, [B1 | T]) when B1 > 127 ->
    [B1 | T];
enint(N, Acc) ->
    enint(N bsr 8, [N band 255 | Acc]).

open_type_to_binary({asn1_OPENTYPE, Bin}) when is_binary(Bin) ->
    Bin.

skipextensions(Bytes0, Nr, ExtensionBitstr)
    when is_bitstring(ExtensionBitstr) ->
    Prev = Nr - 1,
    case ExtensionBitstr of
        <<_:Prev,1:1,_/bitstring>> ->
            {Len, Bytes1} = decode_length(Bytes0),
            <<_:Len/binary,Bytes2/bitstring>> = Bytes1,
            skipextensions(Bytes2, Nr + 1, ExtensionBitstr);
        <<_:Prev,0:1,_/bitstring>> ->
            skipextensions(Bytes0, Nr + 1, ExtensionBitstr);
        _ ->
            Bytes0
    end.
