<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>
<tagfile doxygen_version="1.9.8">
  <compound kind="file">
    <name>datagram.h</name>
    <path>include/osmocom/netif/</path>
    <filename>datagram_8h.html</filename>
    <member kind="function">
      <type>struct osmo_dgram_tx *</type>
      <name>osmo_dgram_tx_create</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gadeaa837f3df8382bd7a50e668b9d3a61</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_destroy</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gaad6f9ca0688cd4a8a95ec6002f52ded5</anchor>
      <arglist>(struct osmo_dgram_tx *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_set_addr</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga94fe94f64f1285715db36eb1f2e9deaa</anchor>
      <arglist>(struct osmo_dgram_tx *conn, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_set_port</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga48d7e39656886b52aa176fc1b14c84cf</anchor>
      <arglist>(struct osmo_dgram_tx *conn, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_set_local_addr</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga6c843f43db5439f8f0ba38f72dbb1a20</anchor>
      <arglist>(struct osmo_dgram_tx *conn, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_set_local_port</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gae2962232548d41621520c6c71da423a5</anchor>
      <arglist>(struct osmo_dgram_tx *conn, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_set_data</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga095ce94e65f1607026c37c12e6f5e9c0</anchor>
      <arglist>(struct osmo_dgram_tx *conn, void *data)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_dgram_tx_open</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga8d712623df3862e55ad248dc5ecd626c</anchor>
      <arglist>(struct osmo_dgram_tx *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_close</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga0eb580467681e8fa91be35a83a74f132</anchor>
      <arglist>(struct osmo_dgram_tx *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_send</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gad4638b9943090f5bf1a7b75fa8efde46</anchor>
      <arglist>(struct osmo_dgram_tx *conn, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_dgram_rx *</type>
      <name>osmo_dgram_rx_create</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gad7af9f04fe4847b0e2eefe35fa05a8b8</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_rx_set_addr</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gad378ba5cc66ee0c27a277906d8434e31</anchor>
      <arglist>(struct osmo_dgram_rx *conn, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_rx_set_port</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gafbd947def18d8e34062876433ac05e91</anchor>
      <arglist>(struct osmo_dgram_rx *conn, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_rx_set_read_cb</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga5a0f7221b8583aac5153f167c4e2177d</anchor>
      <arglist>(struct osmo_dgram_rx *conn, int(*read_cb)(struct osmo_dgram_rx *conn))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_rx_destroy</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga6e4b92b9c7f210d1cb3782425d0bdac0</anchor>
      <arglist>(struct osmo_dgram_rx *conn)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_dgram_rx_open</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gaf558e9c2f02216ed95db039ddaf31050</anchor>
      <arglist>(struct osmo_dgram_rx *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_rx_close</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga01efa7269834a745d80910a64c6f61c0</anchor>
      <arglist>(struct osmo_dgram_rx *conn)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_dgram_rx_recv</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga16d69e998c663cdec0b76560a2d8cfb9</anchor>
      <arglist>(struct osmo_dgram_rx *conn, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_dgram *</type>
      <name>osmo_dgram_create</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga56ee60c89f1a3bc975ab0ede5b71ff15</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_destroy</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga01fb36f8c19b2b64705d8263f7f53f59</anchor>
      <arglist>(struct osmo_dgram *conn)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_dgram_open</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gac65de108c52dba83b178d6453e9fb545</anchor>
      <arglist>(struct osmo_dgram *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_close</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga46db4acbfc35668e35601338d64364ed</anchor>
      <arglist>(struct osmo_dgram *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_local_addr</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gaf21d974e14fa22f910313b240d31d40f</anchor>
      <arglist>(struct osmo_dgram *conn, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_remote_addr</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga6677ee8d976d2e1bed8e0c01e103c18f</anchor>
      <arglist>(struct osmo_dgram *conn, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_local_port</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga9180ae9a36a9927d4bdb49cdc5708b1f</anchor>
      <arglist>(struct osmo_dgram *conn, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_remote_port</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga27bf4c1d8e4c30ef7b4ec49665d6fc90</anchor>
      <arglist>(struct osmo_dgram *conn, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_read_cb</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga6b6ef2f02e3d260f1e84a2ecf8c67b5a</anchor>
      <arglist>(struct osmo_dgram *conn, int(*read_cb)(struct osmo_dgram *conn))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_data</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gaa6a5fbd5f227d15cefe6b234fefb3b4d</anchor>
      <arglist>(struct osmo_dgram *conn, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>osmo_dgram_get_data</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga36d7e1f26af3308b51f95e06d1c742d7</anchor>
      <arglist>(struct osmo_dgram *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_send</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga66d6c9d5f0243a4f7ed458c62d8e20dd</anchor>
      <arglist>(struct osmo_dgram *conn, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_dgram_recv</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gaae58d13a6fd634ebfddd486d0d428c5e</anchor>
      <arglist>(struct osmo_dgram *conn, struct msgb *msg)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>jibuf.h</name>
    <path>include/osmocom/netif/</path>
    <filename>jibuf_8h.html</filename>
    <class kind="struct">osmo_jibuf</class>
    <member kind="function">
      <type>struct osmo_jibuf *</type>
      <name>osmo_jibuf_alloc</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>ga20592f230f9d1233752fd318996f2c9d</anchor>
      <arglist>(void *talloc_ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_jibuf_delete</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>gacdac7beaf3d97543718ddfa33123fb7e</anchor>
      <arglist>(struct osmo_jibuf *jb)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_jibuf_enqueue</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>ga522165ddc51578436ae2d26691fa7ec0</anchor>
      <arglist>(struct osmo_jibuf *jb, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>osmo_jibuf_empty</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>gae73a3b805b83f453339adeee9cdfaba4</anchor>
      <arglist>(struct osmo_jibuf *jb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_jibuf_set_min_delay</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>gabcd63f39049bc4d6b3541a674b78963d</anchor>
      <arglist>(struct osmo_jibuf *jb, uint32_t min_delay)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_jibuf_set_max_delay</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>ga5e84571c3348525b6ad647a22cd2581d</anchor>
      <arglist>(struct osmo_jibuf *jb, uint32_t max_delay)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_jibuf_enable_skew_compensation</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>ga096e87b2dbdade72c35d51a51fe57839</anchor>
      <arglist>(struct osmo_jibuf *jb, bool enable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_jibuf_set_dequeue_cb</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>ga3a8213fe8bed42d649fcb1c8d13e23d8</anchor>
      <arglist>(struct osmo_jibuf *jb, osmo_jibuf_dequeue_cb dequeue_cb, void *cb_data)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>osmux.h</name>
    <path>include/osmocom/netif/</path>
    <filename>osmux_8h.html</filename>
    <class kind="struct">osmux_hdr</class>
    <class kind="struct">osmux_in_handle</class>
    <class kind="struct">osmux_out_handle</class>
    <member kind="function">
      <type>int</type>
      <name>osmux_snprintf</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>gaf654e092ca97dd764f59905a2ed21650</anchor>
      <arglist>(char *buf, size_t size, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>struct osmux_in_handle *</type>
      <name>osmux_xfrm_input_alloc</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>gad61cdde332496df6d7350d147e50b8be</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_input_init</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga96230b0431d5d4d91f2dd57a9c85c366</anchor>
      <arglist>(struct osmux_in_handle *h) OSMO_DEPRECATED(&quot;Use osmux_xfrm_input_alloc() instead&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_input_fini</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga13655a3bdc68f5e96ad1fe1c03dc235e</anchor>
      <arglist>(struct osmux_in_handle *h) OSMO_DEPRECATED(&quot;Use talloc_free() instead&quot;)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmux_xfrm_input</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga9c7d30c0d7d9bc0caf744799d629d4cc</anchor>
      <arglist>(struct osmux_in_handle *h, struct msgb *msg, int ccid)</arglist>
    </member>
    <member kind="function">
      <type>struct osmux_out_handle *</type>
      <name>osmux_xfrm_output_alloc</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga41a217bffa1b0ac095c98ab0fab82c25</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_init</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga90d58246bcd24a6126898cd6c47dddf4</anchor>
      <arglist>(struct osmux_out_handle *h, uint32_t rtp_ssrc) OSMO_DEPRECATED(&quot;Use osmux_xfrm_output_alloc() and osmux_xfrm_output_set_rtp_*() instead&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_init2</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>gaa076e54fa0d249721a4c7b174a8ed2d1</anchor>
      <arglist>(struct osmux_out_handle *h, uint32_t rtp_ssrc, uint8_t rtp_payload_type) OSMO_DEPRECATED(&quot;Use osmux_xfrm_output_alloc() and osmux_xfrm_output_set_rtp_*() instead&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_set_rtp_ssrc</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga08151bad3c12df245d4c0e4f9c4ca966</anchor>
      <arglist>(struct osmux_out_handle *h, uint32_t rtp_ssrc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_set_rtp_pl_type</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga0d96c8a544e0ff56576615e0b2ac7774</anchor>
      <arglist>(struct osmux_out_handle *h, uint32_t rtp_payload_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_set_tx_cb</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga3936e43e881d0992648937417969ead1</anchor>
      <arglist>(struct osmux_out_handle *h, void(*tx_cb)(struct msgb *msg, void *data), void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_set_rtp_msgb_alloc_cb</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga97187827e1f793f2392e54585343db32</anchor>
      <arglist>(struct osmux_out_handle *h, rtp_msgb_alloc_cb_t cb, void *cb_data)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmux_xfrm_output_sched</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>gafee78ee4522a9caa238301d7b913dfd6</anchor>
      <arglist>(struct osmux_out_handle *h, struct osmux_hdr *osmuxh)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_flush</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>gaaac410425f6470396ae9db53ebb8dc44</anchor>
      <arglist>(struct osmux_out_handle *h)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stream.h</name>
    <path>include/osmocom/netif/</path>
    <filename>stream_8h.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>OSMO_STREAM_SCTP_MSG_FLAGS_NOTIFICATION</name>
      <anchorfile>stream_8h.html</anchorfile>
      <anchor>a123b7866ed4985a81246bfede79a8ea9</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>msgb_sctp_ppid</name>
      <anchorfile>stream_8h.html</anchorfile>
      <anchor>a2693c0cc5c6222dd9ed42c8c4bf8aec8</anchor>
      <arglist>(msg)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>msgb_sctp_stream</name>
      <anchorfile>stream_8h.html</anchorfile>
      <anchor>ac2c359892ad63309b59a4b402f6a3e81</anchor>
      <arglist>(msg)</arglist>
    </member>
    <member kind="typedef">
      <type>int(*</type>
      <name>osmo_stream_srv_read_cb2_t</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga5b6beeb3ec1effa8afa948deb7a4fc15</anchor>
      <arglist>)(struct osmo_stream_srv *conn, int res, struct msgb *msg)</arglist>
    </member>
    <member kind="typedef">
      <type>int(*</type>
      <name>osmo_stream_cli_read_cb2_t</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga113d99fd2e25ce01e98db0a6aa21c89c</anchor>
      <arglist>)(struct osmo_stream_cli *cli, int res, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_stream_srv_link *</type>
      <name>osmo_stream_srv_link_create</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gaad262988c7ac365566f03843c560f892</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_destroy</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga882acaaa5935422b0e09a2ce8c8019ec</anchor>
      <arglist>(struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_name</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gadef998825a4739660b198151fcee4201</anchor>
      <arglist>(struct osmo_stream_srv_link *link, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osmo_stream_srv_link_get_name</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga67520942e5a404a0b3a6960b8a161de8</anchor>
      <arglist>(const struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_nodelay</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga41e8ad2c761aaa00313aa11d1f29a3ed</anchor>
      <arglist>(struct osmo_stream_srv_link *link, bool nodelay)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_priority</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga3bfcfe6f09fa8f87dacb7ea215c64bae</anchor>
      <arglist>(struct osmo_stream_srv_link *link, int sk_prio)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_ip_dscp</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga53be410e4b8cf79e850b8cd5c01b4c78</anchor>
      <arglist>(struct osmo_stream_srv_link *link, uint8_t ip_dscp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_addr</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gacece90116484e34540def69b05c66f57</anchor>
      <arglist>(struct osmo_stream_srv_link *link, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_addrs</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gaadabca7d23c52c39e291bf7e05f0055b</anchor>
      <arglist>(struct osmo_stream_srv_link *link, const char **addr, size_t addrcnt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_port</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga76bbbafd1d8dc9c9ebffd301503b6dd9</anchor>
      <arglist>(struct osmo_stream_srv_link *link, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_proto</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga2508987133a93863d2a50103004b0f36</anchor>
      <arglist>(struct osmo_stream_srv_link *link, uint16_t proto)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_type</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga1903f9aa2e6f9283ebcf20f573b1d970</anchor>
      <arglist>(struct osmo_stream_srv_link *link, int type)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_domain</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga9629b516297c31f34af48e4630973dab</anchor>
      <arglist>(struct osmo_stream_srv_link *link, int domain)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_accept_cb</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga1eea525d4e1e7a24c9c08881994ceb7e</anchor>
      <arglist>(struct osmo_stream_srv_link *link, int(*accept_cb)(struct osmo_stream_srv_link *link, int fd))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_data</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga5ef0f0c85a52c08e8c10d36a8f44e392</anchor>
      <arglist>(struct osmo_stream_srv_link *link, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>osmo_stream_srv_link_get_data</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gacb5d68c2a6a9663f99266c70747bce04</anchor>
      <arglist>(struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_tx_queue_max_length</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gad88e9249699c53894cb34c099b5e0c4b</anchor>
      <arglist>(struct osmo_stream_srv_link *link, unsigned int size)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>osmo_stream_srv_link_get_sockname</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga7d7b6af7df24e90dc758a088bae6316d</anchor>
      <arglist>(const struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_fd *</type>
      <name>osmo_stream_srv_link_get_ofd</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga7b8981351a154c357fcefd39c31ad42a</anchor>
      <arglist>(struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_get_fd</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gae2ef09bc8da55db30d967563dfc6561a</anchor>
      <arglist>(const struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_msgb_alloc_info</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga925981abcacca9f9a3375d511309cb32</anchor>
      <arglist>(struct osmo_stream_srv_link *link, unsigned int size, unsigned int headroom)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>osmo_stream_srv_link_is_opened</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga28243be108ed0302b0f5a9d1dfc96b22</anchor>
      <arglist>(const struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_open</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga603b89074d3e8c0fb44144ab1864f0d4</anchor>
      <arglist>(struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_close</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gad325d97b09c724e830c98d76b890520d</anchor>
      <arglist>(struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_param</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga759bceb4ce155f88e3e7817ce4c9449d</anchor>
      <arglist>(struct osmo_stream_srv_link *link, enum osmo_stream_srv_link_param par, void *val, size_t val_len)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_stream_srv *</type>
      <name>osmo_stream_srv_create</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga136b426790b6322f58f89059b88aaa0b</anchor>
      <arglist>(void *ctx, struct osmo_stream_srv_link *link, int fd, osmo_stream_srv_read_cb_t read_cb, osmo_stream_srv_closed_cb_t closed_cb, void *data)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_stream_srv *</type>
      <name>osmo_stream_srv_create2</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga8be283e1a143e346b4d6ccf33cbb9b98</anchor>
      <arglist>(void *ctx, struct osmo_stream_srv_link *link, int fd, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_name</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga196834d254fd94922d6be91b7b5b1ed3</anchor>
      <arglist>(struct osmo_stream_srv *conn, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_name_f</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga7af35085592c1dbaf2a3b6be1b49bef2</anchor>
      <arglist>(struct osmo_stream_srv *conn, const char *fmt,...)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osmo_stream_srv_get_name</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gad34dc0f7ebf7c84653514566e431a1d2</anchor>
      <arglist>(const struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_read_cb</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gad0d7b7e236826c52f10a7b4f50009d01</anchor>
      <arglist>(struct osmo_stream_srv *conn, osmo_stream_srv_read_cb2_t read_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_closed_cb</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gaed83d9686289eee534d77a61b96fbd90</anchor>
      <arglist>(struct osmo_stream_srv *conn, osmo_stream_srv_closed_cb_t closed_cb)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>osmo_stream_srv_get_data</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gae2a0ef01097d964c71e38600b4c078d5</anchor>
      <arglist>(struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_stream_srv_link *</type>
      <name>osmo_stream_srv_get_master</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga9cf689935bf6ffac4f86f56219d73c8e</anchor>
      <arglist>(struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osmo_stream_srv_get_sockname</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga4f176a35751509dc741fbd2b52f45b22</anchor>
      <arglist>(const struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_fd *</type>
      <name>osmo_stream_srv_get_ofd</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga47bbca4f12717db2e6158eefe6310b9b</anchor>
      <arglist>(struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_get_fd</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga803c8ba415f66cc1029b3899cc53b807</anchor>
      <arglist>(const struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_io_fd *</type>
      <name>osmo_stream_srv_get_iofd</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga9e00a9172d5b2708afa269d52c118eff</anchor>
      <arglist>(const struct osmo_stream_srv *srv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_destroy</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga47f18e063f64f22cb74d58d8b7243bed</anchor>
      <arglist>(struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_flush_and_destroy</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga8390ce6740e56eb22215e1c5805c95f1</anchor>
      <arglist>(struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_data</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga9891663b20714d72f992e44ad1e92eea</anchor>
      <arglist>(struct osmo_stream_srv *conn, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_segmentation_cb</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga560a6d868bf95bf2f3a4b716bfd5cac9</anchor>
      <arglist>(struct osmo_stream_srv *conn, osmo_stream_srv_segmentation_cb_t segmentation_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_segmentation_cb2</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga348c4560f69403fc3a3dfcbe874c2593</anchor>
      <arglist>(struct osmo_stream_srv *conn, osmo_stream_srv_segmentation_cb2_t segmentation_cb2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_send</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gaa1589994cf6eab27742cafee6b7fb491</anchor>
      <arglist>(struct osmo_stream_srv *conn, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_recv</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gac86242c41223c525c770ff7e7515d83e</anchor>
      <arglist>(struct osmo_stream_srv *conn, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_set_param</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga0e7adb8aef2f007144d4df24b21fbfe4</anchor>
      <arglist>(struct osmo_stream_srv *conn, enum osmo_stream_srv_param par, void *val, size_t val_len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_name</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaeb712dc553735736047f9b11d9583baa</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_name_f</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gacf917820669504d5f2856eaf74508921</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char *fmt,...)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osmo_stream_cli_get_name</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga0967921ed380123e3f54fd35375741bf</anchor>
      <arglist>(const struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_nodelay</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaa196e78db6ca32abb1473566b4f1b04b</anchor>
      <arglist>(struct osmo_stream_cli *cli, bool nodelay)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_priority</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gac3ec56e61ce062300ad1df73a5f2c7f8</anchor>
      <arglist>(struct osmo_stream_cli *cli, int sk_prio)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_ip_dscp</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga18526a340625c84a69ccc067ce2cda58</anchor>
      <arglist>(struct osmo_stream_cli *cli, uint8_t ip_dscp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_addr</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga0038e937cf0f36c59e0e3991523219a1</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_addrs</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaab1e7ef0ccc88e124c5f7bbb5e46c29c</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char **addr, size_t addrcnt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_port</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gab8b9f65bebfeb83c6e33d102e9439770</anchor>
      <arglist>(struct osmo_stream_cli *cli, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_type</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga5e5c4c9aacc1cd1d303c0295018594cb</anchor>
      <arglist>(struct osmo_stream_cli *cli, int type)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_domain</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga33ce730fc91ebade9b7188fa220656c6</anchor>
      <arglist>(struct osmo_stream_cli *cli, int domain)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_proto</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga91d57aa94a370520540d7272af66a23b</anchor>
      <arglist>(struct osmo_stream_cli *cli, uint16_t proto)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_local_addr</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga70420e7c664cc4c4e69ac4d3476e7f53</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_local_addrs</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga090fc3fcd1706b815ef5a729921c100e</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char **addr, size_t addrcnt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_local_port</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga4d83e3cf7fdf7eb354c2015ff9bed98a</anchor>
      <arglist>(struct osmo_stream_cli *cli, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_data</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga5e94c511d537f63337912bb50fb2dc28</anchor>
      <arglist>(struct osmo_stream_cli *cli, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_reconnect_timeout</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gade74792afe35f31dd2584c888db3dd62</anchor>
      <arglist>(struct osmo_stream_cli *cli, int timeout)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>osmo_stream_cli_get_data</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga606a53840677f3f5200887dc92f5de4d</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_tx_queue_max_length</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga889f96540a1a2271a40dee063eaf5e9d</anchor>
      <arglist>(struct osmo_stream_cli *cli, unsigned int size)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>osmo_stream_cli_get_sockname</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaecd148ae11f2f619aa52dd2900a15827</anchor>
      <arglist>(const struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_fd *</type>
      <name>osmo_stream_cli_get_ofd</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga0615daa4aac253a3d530f35fddbc68bd</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_get_fd</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaffc6ac3b28d87c910294a2f522a1eaab</anchor>
      <arglist>(const struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_io_fd *</type>
      <name>osmo_stream_cli_get_iofd</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gac32d0489dd05ab89fb0c54dfd360d5b3</anchor>
      <arglist>(const struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_connect_cb</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga6a7d4b7df43a3f0487d343fe3cd0c6a7</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_connect_cb_t connect_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_disconnect_cb</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga6640b82a47028434455471bb52d9f577</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_disconnect_cb_t disconnect_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_read_cb</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga798f23db7e2e1d999775589db8a73d03</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_read_cb_t read_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_read_cb2</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga7892eb77d40f08a254f654786d0b996b</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_read_cb2_t read_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_segmentation_cb</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gab6094559935824750d82b9164ed76910</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_segmentation_cb_t segmentation_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_segmentation_cb2</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaf62f1dbe4570d8ffd00b3bdc3f28d24b</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_segmentation_cb2_t segmentation_cb2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_reconnect</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga11d2615f6197f33073ba7245e5ba95ee</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>osmo_stream_cli_is_connected</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga79a09e9c9b8cc98991cd5eebdb41ed57</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_stream_cli *</type>
      <name>osmo_stream_cli_create</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga1754a498abc27577a8e0b3b0f236c05b</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_destroy</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga9d0dac2f390c660c85fa347765f4f45a</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_open</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga86b4b9c8e563f8426d3cdae803e3ec38</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_open2</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga127866794591d16a0eb7244f2fe666ef</anchor>
      <arglist>(struct osmo_stream_cli *cli, int reconnect)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_close</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gad217c1c1b83ac852e090afd49146db19</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_send</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaacf415b97e1184baadeee5c60387422b</anchor>
      <arglist>(struct osmo_stream_cli *cli, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_recv</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga06f9743c19068bb720a4949ae8467243</anchor>
      <arglist>(struct osmo_stream_cli *cli, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_clear_tx_queue</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gafa39b1dcc139ad12cbc38d51049bf14f</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_param</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga0638e98001fa4bdd36533718472dfac7</anchor>
      <arglist>(struct osmo_stream_cli *cli, enum osmo_stream_cli_param par, void *val, size_t val_len)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>datagram.c</name>
    <path>src/</path>
    <filename>datagram_8c.html</filename>
    <includes id="datagram_8h" name="datagram.h" local="no" import="no" module="no" objc="no">osmocom/netif/datagram.h</includes>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_close</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga0eb580467681e8fa91be35a83a74f132</anchor>
      <arglist>(struct osmo_dgram_tx *conn)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_dgram_tx *</type>
      <name>osmo_dgram_tx_create</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gadeaa837f3df8382bd7a50e668b9d3a61</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_set_addr</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga94fe94f64f1285715db36eb1f2e9deaa</anchor>
      <arglist>(struct osmo_dgram_tx *conn, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_set_port</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga48d7e39656886b52aa176fc1b14c84cf</anchor>
      <arglist>(struct osmo_dgram_tx *conn, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_set_local_addr</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga6c843f43db5439f8f0ba38f72dbb1a20</anchor>
      <arglist>(struct osmo_dgram_tx *conn, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_set_local_port</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gae2962232548d41621520c6c71da423a5</anchor>
      <arglist>(struct osmo_dgram_tx *conn, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_set_data</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga095ce94e65f1607026c37c12e6f5e9c0</anchor>
      <arglist>(struct osmo_dgram_tx *conn, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_destroy</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gaad6f9ca0688cd4a8a95ec6002f52ded5</anchor>
      <arglist>(struct osmo_dgram_tx *conn)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_dgram_tx_open</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga8d712623df3862e55ad248dc5ecd626c</anchor>
      <arglist>(struct osmo_dgram_tx *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_send</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gad4638b9943090f5bf1a7b75fa8efde46</anchor>
      <arglist>(struct osmo_dgram_tx *conn, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_dgram_rx_recv</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga16d69e998c663cdec0b76560a2d8cfb9</anchor>
      <arglist>(struct osmo_dgram_rx *conn, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_dgram_rx *</type>
      <name>osmo_dgram_rx_create</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gad7af9f04fe4847b0e2eefe35fa05a8b8</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_rx_set_addr</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gad378ba5cc66ee0c27a277906d8434e31</anchor>
      <arglist>(struct osmo_dgram_rx *conn, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_rx_set_port</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gafbd947def18d8e34062876433ac05e91</anchor>
      <arglist>(struct osmo_dgram_rx *conn, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_rx_set_read_cb</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga5a0f7221b8583aac5153f167c4e2177d</anchor>
      <arglist>(struct osmo_dgram_rx *conn, int(*read_cb)(struct osmo_dgram_rx *conn))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_rx_destroy</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga6e4b92b9c7f210d1cb3782425d0bdac0</anchor>
      <arglist>(struct osmo_dgram_rx *conn)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_dgram_rx_open</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gaf558e9c2f02216ed95db039ddaf31050</anchor>
      <arglist>(struct osmo_dgram_rx *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_rx_close</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga01efa7269834a745d80910a64c6f61c0</anchor>
      <arglist>(struct osmo_dgram_rx *conn)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_dgram *</type>
      <name>osmo_dgram_create</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga56ee60c89f1a3bc975ab0ede5b71ff15</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_destroy</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga01fb36f8c19b2b64705d8263f7f53f59</anchor>
      <arglist>(struct osmo_dgram *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_local_addr</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gaf21d974e14fa22f910313b240d31d40f</anchor>
      <arglist>(struct osmo_dgram *conn, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_remote_addr</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga6677ee8d976d2e1bed8e0c01e103c18f</anchor>
      <arglist>(struct osmo_dgram *conn, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_local_port</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga9180ae9a36a9927d4bdb49cdc5708b1f</anchor>
      <arglist>(struct osmo_dgram *conn, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_remote_port</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga27bf4c1d8e4c30ef7b4ec49665d6fc90</anchor>
      <arglist>(struct osmo_dgram *conn, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_read_cb</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga6b6ef2f02e3d260f1e84a2ecf8c67b5a</anchor>
      <arglist>(struct osmo_dgram *conn, int(*read_cb)(struct osmo_dgram *conn))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_data</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gaa6a5fbd5f227d15cefe6b234fefb3b4d</anchor>
      <arglist>(struct osmo_dgram *conn, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>osmo_dgram_get_data</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga36d7e1f26af3308b51f95e06d1c742d7</anchor>
      <arglist>(struct osmo_dgram *conn)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_dgram_open</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gac65de108c52dba83b178d6453e9fb545</anchor>
      <arglist>(struct osmo_dgram *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_close</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga46db4acbfc35668e35601338d64364ed</anchor>
      <arglist>(struct osmo_dgram *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_send</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga66d6c9d5f0243a4f7ed458c62d8e20dd</anchor>
      <arglist>(struct osmo_dgram *conn, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_dgram_recv</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gaae58d13a6fd634ebfddd486d0d428c5e</anchor>
      <arglist>(struct osmo_dgram *conn, struct msgb *msg)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>jibuf.c</name>
    <path>src/</path>
    <filename>jibuf_8c.html</filename>
    <includes id="jibuf_8h" name="jibuf.h" local="no" import="no" module="no" objc="no">osmocom/netif/jibuf.h</includes>
    <member kind="function">
      <type>struct osmo_jibuf *</type>
      <name>osmo_jibuf_alloc</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>ga20592f230f9d1233752fd318996f2c9d</anchor>
      <arglist>(void *talloc_ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_jibuf_delete</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>gacdac7beaf3d97543718ddfa33123fb7e</anchor>
      <arglist>(struct osmo_jibuf *jb)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_jibuf_enqueue</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>ga522165ddc51578436ae2d26691fa7ec0</anchor>
      <arglist>(struct osmo_jibuf *jb, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>osmo_jibuf_empty</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>gae73a3b805b83f453339adeee9cdfaba4</anchor>
      <arglist>(struct osmo_jibuf *jb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_jibuf_set_min_delay</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>gabcd63f39049bc4d6b3541a674b78963d</anchor>
      <arglist>(struct osmo_jibuf *jb, uint32_t min_delay)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_jibuf_set_max_delay</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>ga5e84571c3348525b6ad647a22cd2581d</anchor>
      <arglist>(struct osmo_jibuf *jb, uint32_t max_delay)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_jibuf_enable_skew_compensation</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>ga096e87b2dbdade72c35d51a51fe57839</anchor>
      <arglist>(struct osmo_jibuf *jb, bool enable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_jibuf_set_dequeue_cb</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>ga3a8213fe8bed42d649fcb1c8d13e23d8</anchor>
      <arglist>(struct osmo_jibuf *jb, osmo_jibuf_dequeue_cb dequeue_cb, void *cb_data)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>osmux.c</name>
    <path>src/</path>
    <filename>osmux_8c.html</filename>
    <includes id="osmux_8h" name="osmux.h" local="no" import="no" module="no" objc="no">osmocom/netif/osmux.h</includes>
    <member kind="function">
      <type>int</type>
      <name>osmux_snprintf</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>gaf654e092ca97dd764f59905a2ed21650</anchor>
      <arglist>(char *buf, size_t size, struct msgb *msg)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>osmux_input.c</name>
    <path>src/</path>
    <filename>osmux__input_8c.html</filename>
    <includes id="osmux_8h" name="osmux.h" local="no" import="no" module="no" objc="no">osmocom/netif/osmux.h</includes>
    <member kind="function">
      <type>int</type>
      <name>osmux_xfrm_input</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga9c7d30c0d7d9bc0caf744799d629d4cc</anchor>
      <arglist>(struct osmux_in_handle *h, struct msgb *msg, int ccid)</arglist>
    </member>
    <member kind="function">
      <type>struct osmux_in_handle *</type>
      <name>osmux_xfrm_input_alloc</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>gad61cdde332496df6d7350d147e50b8be</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_input_init</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga96230b0431d5d4d91f2dd57a9c85c366</anchor>
      <arglist>(struct osmux_in_handle *h) OSMO_DEPRECATED(&quot;Use osmux_xfrm_input_alloc() instead&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_input_fini</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga13655a3bdc68f5e96ad1fe1c03dc235e</anchor>
      <arglist>(struct osmux_in_handle *h) OSMO_DEPRECATED(&quot;Use talloc_free() instead&quot;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>osmux_output.c</name>
    <path>src/</path>
    <filename>osmux__output_8c.html</filename>
    <includes id="osmux_8h" name="osmux.h" local="no" import="no" module="no" objc="no">osmocom/netif/osmux.h</includes>
    <member kind="function">
      <type>int</type>
      <name>osmux_xfrm_output_sched</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>gafee78ee4522a9caa238301d7b913dfd6</anchor>
      <arglist>(struct osmux_out_handle *h, struct osmux_hdr *osmuxh)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_flush</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>gaaac410425f6470396ae9db53ebb8dc44</anchor>
      <arglist>(struct osmux_out_handle *h)</arglist>
    </member>
    <member kind="function">
      <type>struct osmux_out_handle *</type>
      <name>osmux_xfrm_output_alloc</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga41a217bffa1b0ac095c98ab0fab82c25</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_init2</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>gaa076e54fa0d249721a4c7b174a8ed2d1</anchor>
      <arglist>(struct osmux_out_handle *h, uint32_t rtp_ssrc, uint8_t rtp_payload_type) OSMO_DEPRECATED(&quot;Use osmux_xfrm_output_alloc() and osmux_xfrm_output_set_rtp_*() instead&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_init</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga90d58246bcd24a6126898cd6c47dddf4</anchor>
      <arglist>(struct osmux_out_handle *h, uint32_t rtp_ssrc) OSMO_DEPRECATED(&quot;Use osmux_xfrm_output_alloc() and osmux_xfrm_output_set_rtp_*() instead&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_set_tx_cb</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga3936e43e881d0992648937417969ead1</anchor>
      <arglist>(struct osmux_out_handle *h, void(*tx_cb)(struct msgb *msg, void *data), void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_set_rtp_msgb_alloc_cb</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga97187827e1f793f2392e54585343db32</anchor>
      <arglist>(struct osmux_out_handle *h, rtp_msgb_alloc_cb_t cb, void *cb_data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_set_rtp_ssrc</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga08151bad3c12df245d4c0e4f9c4ca966</anchor>
      <arglist>(struct osmux_out_handle *h, uint32_t rtp_ssrc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_set_rtp_pl_type</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga0d96c8a544e0ff56576615e0b2ac7774</anchor>
      <arglist>(struct osmux_out_handle *h, uint32_t rtp_payload_type)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stream_cli.c</name>
    <path>src/</path>
    <filename>stream__cli_8c.html</filename>
    <includes id="stream_8h" name="stream.h" local="no" import="no" module="no" objc="no">osmocom/netif/stream.h</includes>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_close</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gad217c1c1b83ac852e090afd49146db19</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_reconnect</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga11d2615f6197f33073ba7245e5ba95ee</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>osmo_stream_cli_is_connected</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga79a09e9c9b8cc98991cd5eebdb41ed57</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_get_fd</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaffc6ac3b28d87c910294a2f522a1eaab</anchor>
      <arglist>(const struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_io_fd *</type>
      <name>osmo_stream_cli_get_iofd</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gac32d0489dd05ab89fb0c54dfd360d5b3</anchor>
      <arglist>(const struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_stream_cli *</type>
      <name>osmo_stream_cli_create</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga1754a498abc27577a8e0b3b0f236c05b</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_name</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaeb712dc553735736047f9b11d9583baa</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_name_f</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gacf917820669504d5f2856eaf74508921</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char *fmt,...)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osmo_stream_cli_get_name</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga0967921ed380123e3f54fd35375741bf</anchor>
      <arglist>(const struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_addr</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga0038e937cf0f36c59e0e3991523219a1</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_addrs</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaab1e7ef0ccc88e124c5f7bbb5e46c29c</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char **addr, size_t addrcnt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_port</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gab8b9f65bebfeb83c6e33d102e9439770</anchor>
      <arglist>(struct osmo_stream_cli *cli, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_local_port</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga4d83e3cf7fdf7eb354c2015ff9bed98a</anchor>
      <arglist>(struct osmo_stream_cli *cli, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_local_addr</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga70420e7c664cc4c4e69ac4d3476e7f53</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_local_addrs</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga090fc3fcd1706b815ef5a729921c100e</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char **addr, size_t addrcnt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_proto</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga91d57aa94a370520540d7272af66a23b</anchor>
      <arglist>(struct osmo_stream_cli *cli, uint16_t proto)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_segmentation_cb</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gab6094559935824750d82b9164ed76910</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_segmentation_cb_t segmentation_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_segmentation_cb2</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaf62f1dbe4570d8ffd00b3bdc3f28d24b</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_segmentation_cb2_t segmentation_cb2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_type</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga5e5c4c9aacc1cd1d303c0295018594cb</anchor>
      <arglist>(struct osmo_stream_cli *cli, int type)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_domain</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga33ce730fc91ebade9b7188fa220656c6</anchor>
      <arglist>(struct osmo_stream_cli *cli, int domain)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_reconnect_timeout</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gade74792afe35f31dd2584c888db3dd62</anchor>
      <arglist>(struct osmo_stream_cli *cli, int timeout)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_data</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga5e94c511d537f63337912bb50fb2dc28</anchor>
      <arglist>(struct osmo_stream_cli *cli, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>osmo_stream_cli_get_data</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga606a53840677f3f5200887dc92f5de4d</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_tx_queue_max_length</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga889f96540a1a2271a40dee063eaf5e9d</anchor>
      <arglist>(struct osmo_stream_cli *cli, unsigned int size)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>osmo_stream_cli_get_sockname</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaecd148ae11f2f619aa52dd2900a15827</anchor>
      <arglist>(const struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_fd *</type>
      <name>osmo_stream_cli_get_ofd</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga0615daa4aac253a3d530f35fddbc68bd</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_connect_cb</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga6a7d4b7df43a3f0487d343fe3cd0c6a7</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_connect_cb_t connect_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_disconnect_cb</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga6640b82a47028434455471bb52d9f577</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_disconnect_cb_t disconnect_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_read_cb</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga798f23db7e2e1d999775589db8a73d03</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_read_cb_t read_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_read_cb2</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga7892eb77d40f08a254f654786d0b996b</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_read_cb2_t read_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_destroy</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga9d0dac2f390c660c85fa347765f4f45a</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_open2</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga127866794591d16a0eb7244f2fe666ef</anchor>
      <arglist>(struct osmo_stream_cli *cli, int reconnect)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_nodelay</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaa196e78db6ca32abb1473566b4f1b04b</anchor>
      <arglist>(struct osmo_stream_cli *cli, bool nodelay)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_priority</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gac3ec56e61ce062300ad1df73a5f2c7f8</anchor>
      <arglist>(struct osmo_stream_cli *cli, int sk_prio)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_ip_dscp</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga18526a340625c84a69ccc067ce2cda58</anchor>
      <arglist>(struct osmo_stream_cli *cli, uint8_t ip_dscp)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_open</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga86b4b9c8e563f8426d3cdae803e3ec38</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_send</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaacf415b97e1184baadeee5c60387422b</anchor>
      <arglist>(struct osmo_stream_cli *cli, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_recv</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga06f9743c19068bb720a4949ae8467243</anchor>
      <arglist>(struct osmo_stream_cli *cli, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_clear_tx_queue</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gafa39b1dcc139ad12cbc38d51049bf14f</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_param</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga0638e98001fa4bdd36533718472dfac7</anchor>
      <arglist>(struct osmo_stream_cli *cli, enum osmo_stream_cli_param par, void *val, size_t val_len)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stream_srv.c</name>
    <path>src/</path>
    <filename>stream__srv_8c.html</filename>
    <includes id="stream_8h" name="stream.h" local="no" import="no" module="no" objc="no">osmocom/netif/stream.h</includes>
    <member kind="function">
      <type>struct osmo_stream_srv_link *</type>
      <name>osmo_stream_srv_link_create</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gaad262988c7ac365566f03843c560f892</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_name</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gadef998825a4739660b198151fcee4201</anchor>
      <arglist>(struct osmo_stream_srv_link *link, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osmo_stream_srv_link_get_name</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga67520942e5a404a0b3a6960b8a161de8</anchor>
      <arglist>(const struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_nodelay</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga41e8ad2c761aaa00313aa11d1f29a3ed</anchor>
      <arglist>(struct osmo_stream_srv_link *link, bool nodelay)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_priority</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga3bfcfe6f09fa8f87dacb7ea215c64bae</anchor>
      <arglist>(struct osmo_stream_srv_link *link, int sk_prio)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_ip_dscp</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga53be410e4b8cf79e850b8cd5c01b4c78</anchor>
      <arglist>(struct osmo_stream_srv_link *link, uint8_t ip_dscp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_addr</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gacece90116484e34540def69b05c66f57</anchor>
      <arglist>(struct osmo_stream_srv_link *link, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_addrs</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gaadabca7d23c52c39e291bf7e05f0055b</anchor>
      <arglist>(struct osmo_stream_srv_link *link, const char **addr, size_t addrcnt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_port</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga76bbbafd1d8dc9c9ebffd301503b6dd9</anchor>
      <arglist>(struct osmo_stream_srv_link *link, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_proto</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga2508987133a93863d2a50103004b0f36</anchor>
      <arglist>(struct osmo_stream_srv_link *link, uint16_t proto)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_type</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga1903f9aa2e6f9283ebcf20f573b1d970</anchor>
      <arglist>(struct osmo_stream_srv_link *link, int type)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_domain</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga9629b516297c31f34af48e4630973dab</anchor>
      <arglist>(struct osmo_stream_srv_link *link, int domain)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_data</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga5ef0f0c85a52c08e8c10d36a8f44e392</anchor>
      <arglist>(struct osmo_stream_srv_link *link, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>osmo_stream_srv_link_get_data</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gacb5d68c2a6a9663f99266c70747bce04</anchor>
      <arglist>(struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_tx_queue_max_length</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gad88e9249699c53894cb34c099b5e0c4b</anchor>
      <arglist>(struct osmo_stream_srv_link *link, unsigned int size)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>osmo_stream_srv_link_get_sockname</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga7d7b6af7df24e90dc758a088bae6316d</anchor>
      <arglist>(const struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_fd *</type>
      <name>osmo_stream_srv_link_get_ofd</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga7b8981351a154c357fcefd39c31ad42a</anchor>
      <arglist>(struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_get_fd</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gae2ef09bc8da55db30d967563dfc6561a</anchor>
      <arglist>(const struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_accept_cb</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga1eea525d4e1e7a24c9c08881994ceb7e</anchor>
      <arglist>(struct osmo_stream_srv_link *link, int(*accept_cb)(struct osmo_stream_srv_link *link, int fd))</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_msgb_alloc_info</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga925981abcacca9f9a3375d511309cb32</anchor>
      <arglist>(struct osmo_stream_srv_link *link, unsigned int size, unsigned int headroom)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_destroy</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga882acaaa5935422b0e09a2ce8c8019ec</anchor>
      <arglist>(struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_open</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga603b89074d3e8c0fb44144ab1864f0d4</anchor>
      <arglist>(struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>osmo_stream_srv_link_is_opened</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga28243be108ed0302b0f5a9d1dfc96b22</anchor>
      <arglist>(const struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_close</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gad325d97b09c724e830c98d76b890520d</anchor>
      <arglist>(struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_param</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga759bceb4ce155f88e3e7817ce4c9449d</anchor>
      <arglist>(struct osmo_stream_srv_link *link, enum osmo_stream_srv_link_param par, void *val, size_t val_len)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_stream_srv *</type>
      <name>osmo_stream_srv_create</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga136b426790b6322f58f89059b88aaa0b</anchor>
      <arglist>(void *ctx, struct osmo_stream_srv_link *link, int fd, osmo_stream_srv_read_cb_t read_cb, osmo_stream_srv_closed_cb_t closed_cb, void *data)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_stream_srv *</type>
      <name>osmo_stream_srv_create2</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga8be283e1a143e346b4d6ccf33cbb9b98</anchor>
      <arglist>(void *ctx, struct osmo_stream_srv_link *link, int fd, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_name</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga196834d254fd94922d6be91b7b5b1ed3</anchor>
      <arglist>(struct osmo_stream_srv *conn, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_name_f</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga7af35085592c1dbaf2a3b6be1b49bef2</anchor>
      <arglist>(struct osmo_stream_srv *conn, const char *fmt,...)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osmo_stream_srv_get_name</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gad34dc0f7ebf7c84653514566e431a1d2</anchor>
      <arglist>(const struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_read_cb</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gad0d7b7e236826c52f10a7b4f50009d01</anchor>
      <arglist>(struct osmo_stream_srv *conn, osmo_stream_srv_read_cb2_t read_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_closed_cb</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gaed83d9686289eee534d77a61b96fbd90</anchor>
      <arglist>(struct osmo_stream_srv *conn, osmo_stream_srv_closed_cb_t closed_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_flush_and_destroy</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga8390ce6740e56eb22215e1c5805c95f1</anchor>
      <arglist>(struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_data</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga9891663b20714d72f992e44ad1e92eea</anchor>
      <arglist>(struct osmo_stream_srv *conn, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_segmentation_cb</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga560a6d868bf95bf2f3a4b716bfd5cac9</anchor>
      <arglist>(struct osmo_stream_srv *conn, osmo_stream_srv_segmentation_cb_t segmentation_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_segmentation_cb2</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga348c4560f69403fc3a3dfcbe874c2593</anchor>
      <arglist>(struct osmo_stream_srv *conn, osmo_stream_srv_segmentation_cb2_t segmentation_cb2)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>osmo_stream_srv_get_data</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gae2a0ef01097d964c71e38600b4c078d5</anchor>
      <arglist>(struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osmo_stream_srv_get_sockname</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga4f176a35751509dc741fbd2b52f45b22</anchor>
      <arglist>(const struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_fd *</type>
      <name>osmo_stream_srv_get_ofd</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga47bbca4f12717db2e6158eefe6310b9b</anchor>
      <arglist>(struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_get_fd</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga803c8ba415f66cc1029b3899cc53b807</anchor>
      <arglist>(const struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_io_fd *</type>
      <name>osmo_stream_srv_get_iofd</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga9e00a9172d5b2708afa269d52c118eff</anchor>
      <arglist>(const struct osmo_stream_srv *srv)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_stream_srv_link *</type>
      <name>osmo_stream_srv_get_master</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga9cf689935bf6ffac4f86f56219d73c8e</anchor>
      <arglist>(struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_destroy</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga47f18e063f64f22cb74d58d8b7243bed</anchor>
      <arglist>(struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_send</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gaa1589994cf6eab27742cafee6b7fb491</anchor>
      <arglist>(struct osmo_stream_srv *conn, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_recv</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gac86242c41223c525c770ff7e7515d83e</anchor>
      <arglist>(struct osmo_stream_srv *conn, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_set_param</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga0e7adb8aef2f007144d4df24b21fbfe4</anchor>
      <arglist>(struct osmo_stream_srv *conn, enum osmo_stream_srv_param par, void *val, size_t val_len)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>amr_hdr</name>
    <filename>structamr__hdr.html</filename>
  </compound>
  <compound kind="struct">
    <name>amr_hdr_bwe</name>
    <filename>structamr__hdr__bwe.html</filename>
  </compound>
  <compound kind="struct">
    <name>ipa_head</name>
    <filename>structipa__head.html</filename>
  </compound>
  <compound kind="struct">
    <name>ipa_head_ext</name>
    <filename>structipa__head__ext.html</filename>
  </compound>
  <compound kind="struct">
    <name>osmo_ipa_msgb_cb</name>
    <filename>structosmo__ipa__msgb__cb.html</filename>
  </compound>
  <compound kind="struct">
    <name>osmo_jibuf</name>
    <filename>structosmo__jibuf.html</filename>
  </compound>
  <compound kind="struct">
    <name>osmo_twjit_rr_info</name>
    <filename>structosmo__twjit__rr__info.html</filename>
    <member kind="variable">
      <type>uint32_t</type>
      <name>ssrc</name>
      <anchorfile>structosmo__twjit__rr__info.html</anchorfile>
      <anchor>a95023909bd6410be60a3ec0fb4e34981</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>rx_packets</name>
      <anchorfile>structosmo__twjit__rr__info.html</anchorfile>
      <anchor>a5f3d83ca8470d45943991164b22969e7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>base_seq</name>
      <anchorfile>structosmo__twjit__rr__info.html</anchorfile>
      <anchor>a55a2069db2d025292d2f54d14abfa0db</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>max_seq_ext</name>
      <anchorfile>structosmo__twjit__rr__info.html</anchorfile>
      <anchor>aac5a9bf8abb41a803da8592cee7e3148</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>expected_pkt</name>
      <anchorfile>structosmo__twjit__rr__info.html</anchorfile>
      <anchor>ad31676a36b0ba3634ecbd3b93aac8c5e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>jitter_accum</name>
      <anchorfile>structosmo__twjit__rr__info.html</anchorfile>
      <anchor>a87354c21b9215ee56d87dcb5a7606a78</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>osmo_twjit_stats</name>
    <filename>structosmo__twjit__stats.html</filename>
  </compound>
  <compound kind="struct">
    <name>osmo_twrtp_stats</name>
    <filename>structosmo__twrtp__stats.html</filename>
  </compound>
  <compound kind="struct">
    <name>osmux_hdr</name>
    <filename>structosmux__hdr.html</filename>
  </compound>
  <compound kind="struct">
    <name>osmux_in_handle</name>
    <filename>structosmux__in__handle.html</filename>
    <member kind="variable">
      <type>uint8_t</type>
      <name>osmux_seq</name>
      <anchorfile>structosmux__in__handle.html</anchorfile>
      <anchor>a1ba076a41ef9c3413665b7444c6521cc</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>osmux_out_handle</name>
    <filename>structosmux__out__handle.html</filename>
  </compound>
  <compound kind="struct">
    <name>rtcp_hdr</name>
    <filename>structrtcp__hdr.html</filename>
  </compound>
  <compound kind="struct">
    <name>rtcp_rr_block</name>
    <filename>structrtcp__rr__block.html</filename>
  </compound>
  <compound kind="struct">
    <name>rtcp_sr_block</name>
    <filename>structrtcp__sr__block.html</filename>
  </compound>
  <compound kind="struct">
    <name>rtcp_sr_rr_hdr</name>
    <filename>structrtcp__sr__rr__hdr.html</filename>
  </compound>
  <compound kind="struct">
    <name>rtp_hdr</name>
    <filename>structrtp__hdr.html</filename>
  </compound>
  <compound kind="struct">
    <name>rtp_x_hdr</name>
    <filename>structrtp__x__hdr.html</filename>
  </compound>
  <compound kind="group">
    <name>datagram</name>
    <title>Osmocom Datagram Socket</title>
    <filename>group__datagram.html</filename>
    <file>datagram.h</file>
    <file>datagram.c</file>
    <member kind="function">
      <type>struct osmo_dgram_tx *</type>
      <name>osmo_dgram_tx_create</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gadeaa837f3df8382bd7a50e668b9d3a61</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_destroy</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gaad6f9ca0688cd4a8a95ec6002f52ded5</anchor>
      <arglist>(struct osmo_dgram_tx *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_set_addr</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga94fe94f64f1285715db36eb1f2e9deaa</anchor>
      <arglist>(struct osmo_dgram_tx *conn, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_set_port</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga48d7e39656886b52aa176fc1b14c84cf</anchor>
      <arglist>(struct osmo_dgram_tx *conn, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_set_local_addr</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga6c843f43db5439f8f0ba38f72dbb1a20</anchor>
      <arglist>(struct osmo_dgram_tx *conn, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_set_local_port</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gae2962232548d41621520c6c71da423a5</anchor>
      <arglist>(struct osmo_dgram_tx *conn, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_set_data</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga095ce94e65f1607026c37c12e6f5e9c0</anchor>
      <arglist>(struct osmo_dgram_tx *conn, void *data)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_dgram_tx_open</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga8d712623df3862e55ad248dc5ecd626c</anchor>
      <arglist>(struct osmo_dgram_tx *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_close</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga0eb580467681e8fa91be35a83a74f132</anchor>
      <arglist>(struct osmo_dgram_tx *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_tx_send</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gad4638b9943090f5bf1a7b75fa8efde46</anchor>
      <arglist>(struct osmo_dgram_tx *conn, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_dgram_rx *</type>
      <name>osmo_dgram_rx_create</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gad7af9f04fe4847b0e2eefe35fa05a8b8</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_rx_set_addr</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gad378ba5cc66ee0c27a277906d8434e31</anchor>
      <arglist>(struct osmo_dgram_rx *conn, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_rx_set_port</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gafbd947def18d8e34062876433ac05e91</anchor>
      <arglist>(struct osmo_dgram_rx *conn, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_rx_set_read_cb</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga5a0f7221b8583aac5153f167c4e2177d</anchor>
      <arglist>(struct osmo_dgram_rx *conn, int(*read_cb)(struct osmo_dgram_rx *conn))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_rx_destroy</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga6e4b92b9c7f210d1cb3782425d0bdac0</anchor>
      <arglist>(struct osmo_dgram_rx *conn)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_dgram_rx_open</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gaf558e9c2f02216ed95db039ddaf31050</anchor>
      <arglist>(struct osmo_dgram_rx *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_rx_close</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga01efa7269834a745d80910a64c6f61c0</anchor>
      <arglist>(struct osmo_dgram_rx *conn)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_dgram_rx_recv</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga16d69e998c663cdec0b76560a2d8cfb9</anchor>
      <arglist>(struct osmo_dgram_rx *conn, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_dgram *</type>
      <name>osmo_dgram_create</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga56ee60c89f1a3bc975ab0ede5b71ff15</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_destroy</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga01fb36f8c19b2b64705d8263f7f53f59</anchor>
      <arglist>(struct osmo_dgram *conn)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_dgram_open</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gac65de108c52dba83b178d6453e9fb545</anchor>
      <arglist>(struct osmo_dgram *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_close</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga46db4acbfc35668e35601338d64364ed</anchor>
      <arglist>(struct osmo_dgram *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_local_addr</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gaf21d974e14fa22f910313b240d31d40f</anchor>
      <arglist>(struct osmo_dgram *conn, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_remote_addr</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga6677ee8d976d2e1bed8e0c01e103c18f</anchor>
      <arglist>(struct osmo_dgram *conn, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_local_port</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga9180ae9a36a9927d4bdb49cdc5708b1f</anchor>
      <arglist>(struct osmo_dgram *conn, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_remote_port</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga27bf4c1d8e4c30ef7b4ec49665d6fc90</anchor>
      <arglist>(struct osmo_dgram *conn, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_read_cb</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga6b6ef2f02e3d260f1e84a2ecf8c67b5a</anchor>
      <arglist>(struct osmo_dgram *conn, int(*read_cb)(struct osmo_dgram *conn))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_set_data</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gaa6a5fbd5f227d15cefe6b234fefb3b4d</anchor>
      <arglist>(struct osmo_dgram *conn, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>osmo_dgram_get_data</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga36d7e1f26af3308b51f95e06d1c742d7</anchor>
      <arglist>(struct osmo_dgram *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_dgram_send</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>ga66d6c9d5f0243a4f7ed458c62d8e20dd</anchor>
      <arglist>(struct osmo_dgram *conn, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_dgram_recv</name>
      <anchorfile>group__datagram.html</anchorfile>
      <anchor>gaae58d13a6fd634ebfddd486d0d428c5e</anchor>
      <arglist>(struct osmo_dgram *conn, struct msgb *msg)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>jibuf</name>
    <title>Osmocom Jitter Buffer</title>
    <filename>group__jibuf.html</filename>
    <file>jibuf.h</file>
    <class kind="struct">osmo_jibuf</class>
    <member kind="function">
      <type>struct osmo_jibuf *</type>
      <name>osmo_jibuf_alloc</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>ga20592f230f9d1233752fd318996f2c9d</anchor>
      <arglist>(void *talloc_ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_jibuf_delete</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>gacdac7beaf3d97543718ddfa33123fb7e</anchor>
      <arglist>(struct osmo_jibuf *jb)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_jibuf_enqueue</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>ga522165ddc51578436ae2d26691fa7ec0</anchor>
      <arglist>(struct osmo_jibuf *jb, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>osmo_jibuf_empty</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>gae73a3b805b83f453339adeee9cdfaba4</anchor>
      <arglist>(struct osmo_jibuf *jb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_jibuf_set_min_delay</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>gabcd63f39049bc4d6b3541a674b78963d</anchor>
      <arglist>(struct osmo_jibuf *jb, uint32_t min_delay)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_jibuf_set_max_delay</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>ga5e84571c3348525b6ad647a22cd2581d</anchor>
      <arglist>(struct osmo_jibuf *jb, uint32_t max_delay)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_jibuf_enable_skew_compensation</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>ga096e87b2dbdade72c35d51a51fe57839</anchor>
      <arglist>(struct osmo_jibuf *jb, bool enable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_jibuf_set_dequeue_cb</name>
      <anchorfile>group__jibuf.html</anchorfile>
      <anchor>ga3a8213fe8bed42d649fcb1c8d13e23d8</anchor>
      <arglist>(struct osmo_jibuf *jb, osmo_jibuf_dequeue_cb dequeue_cb, void *cb_data)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>stream_srv</name>
    <title>Osmocom Stream Server</title>
    <filename>group__stream__srv.html</filename>
    <member kind="typedef">
      <type>int(*</type>
      <name>osmo_stream_srv_read_cb2_t</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga5b6beeb3ec1effa8afa948deb7a4fc15</anchor>
      <arglist>)(struct osmo_stream_srv *conn, int res, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_stream_srv_link *</type>
      <name>osmo_stream_srv_link_create</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gaad262988c7ac365566f03843c560f892</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_destroy</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga882acaaa5935422b0e09a2ce8c8019ec</anchor>
      <arglist>(struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_name</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gadef998825a4739660b198151fcee4201</anchor>
      <arglist>(struct osmo_stream_srv_link *link, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osmo_stream_srv_link_get_name</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga67520942e5a404a0b3a6960b8a161de8</anchor>
      <arglist>(const struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_nodelay</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga41e8ad2c761aaa00313aa11d1f29a3ed</anchor>
      <arglist>(struct osmo_stream_srv_link *link, bool nodelay)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_priority</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga3bfcfe6f09fa8f87dacb7ea215c64bae</anchor>
      <arglist>(struct osmo_stream_srv_link *link, int sk_prio)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_ip_dscp</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga53be410e4b8cf79e850b8cd5c01b4c78</anchor>
      <arglist>(struct osmo_stream_srv_link *link, uint8_t ip_dscp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_addr</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gacece90116484e34540def69b05c66f57</anchor>
      <arglist>(struct osmo_stream_srv_link *link, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_addrs</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gaadabca7d23c52c39e291bf7e05f0055b</anchor>
      <arglist>(struct osmo_stream_srv_link *link, const char **addr, size_t addrcnt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_port</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga76bbbafd1d8dc9c9ebffd301503b6dd9</anchor>
      <arglist>(struct osmo_stream_srv_link *link, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_proto</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga2508987133a93863d2a50103004b0f36</anchor>
      <arglist>(struct osmo_stream_srv_link *link, uint16_t proto)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_type</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga1903f9aa2e6f9283ebcf20f573b1d970</anchor>
      <arglist>(struct osmo_stream_srv_link *link, int type)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_domain</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga9629b516297c31f34af48e4630973dab</anchor>
      <arglist>(struct osmo_stream_srv_link *link, int domain)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_accept_cb</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga1eea525d4e1e7a24c9c08881994ceb7e</anchor>
      <arglist>(struct osmo_stream_srv_link *link, int(*accept_cb)(struct osmo_stream_srv_link *link, int fd))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_set_data</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga5ef0f0c85a52c08e8c10d36a8f44e392</anchor>
      <arglist>(struct osmo_stream_srv_link *link, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>osmo_stream_srv_link_get_data</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gacb5d68c2a6a9663f99266c70747bce04</anchor>
      <arglist>(struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_tx_queue_max_length</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gad88e9249699c53894cb34c099b5e0c4b</anchor>
      <arglist>(struct osmo_stream_srv_link *link, unsigned int size)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>osmo_stream_srv_link_get_sockname</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga7d7b6af7df24e90dc758a088bae6316d</anchor>
      <arglist>(const struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_fd *</type>
      <name>osmo_stream_srv_link_get_ofd</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga7b8981351a154c357fcefd39c31ad42a</anchor>
      <arglist>(struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_get_fd</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gae2ef09bc8da55db30d967563dfc6561a</anchor>
      <arglist>(const struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_msgb_alloc_info</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga925981abcacca9f9a3375d511309cb32</anchor>
      <arglist>(struct osmo_stream_srv_link *link, unsigned int size, unsigned int headroom)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>osmo_stream_srv_link_is_opened</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga28243be108ed0302b0f5a9d1dfc96b22</anchor>
      <arglist>(const struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_open</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga603b89074d3e8c0fb44144ab1864f0d4</anchor>
      <arglist>(struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_link_close</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gad325d97b09c724e830c98d76b890520d</anchor>
      <arglist>(struct osmo_stream_srv_link *link)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_link_set_param</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga759bceb4ce155f88e3e7817ce4c9449d</anchor>
      <arglist>(struct osmo_stream_srv_link *link, enum osmo_stream_srv_link_param par, void *val, size_t val_len)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_stream_srv *</type>
      <name>osmo_stream_srv_create</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga136b426790b6322f58f89059b88aaa0b</anchor>
      <arglist>(void *ctx, struct osmo_stream_srv_link *link, int fd, osmo_stream_srv_read_cb_t read_cb, osmo_stream_srv_closed_cb_t closed_cb, void *data)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_stream_srv *</type>
      <name>osmo_stream_srv_create2</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga8be283e1a143e346b4d6ccf33cbb9b98</anchor>
      <arglist>(void *ctx, struct osmo_stream_srv_link *link, int fd, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_name</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga196834d254fd94922d6be91b7b5b1ed3</anchor>
      <arglist>(struct osmo_stream_srv *conn, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_name_f</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga7af35085592c1dbaf2a3b6be1b49bef2</anchor>
      <arglist>(struct osmo_stream_srv *conn, const char *fmt,...)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osmo_stream_srv_get_name</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gad34dc0f7ebf7c84653514566e431a1d2</anchor>
      <arglist>(const struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_read_cb</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gad0d7b7e236826c52f10a7b4f50009d01</anchor>
      <arglist>(struct osmo_stream_srv *conn, osmo_stream_srv_read_cb2_t read_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_closed_cb</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gaed83d9686289eee534d77a61b96fbd90</anchor>
      <arglist>(struct osmo_stream_srv *conn, osmo_stream_srv_closed_cb_t closed_cb)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>osmo_stream_srv_get_data</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gae2a0ef01097d964c71e38600b4c078d5</anchor>
      <arglist>(struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_stream_srv_link *</type>
      <name>osmo_stream_srv_get_master</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga9cf689935bf6ffac4f86f56219d73c8e</anchor>
      <arglist>(struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osmo_stream_srv_get_sockname</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga4f176a35751509dc741fbd2b52f45b22</anchor>
      <arglist>(const struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_fd *</type>
      <name>osmo_stream_srv_get_ofd</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga47bbca4f12717db2e6158eefe6310b9b</anchor>
      <arglist>(struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_get_fd</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga803c8ba415f66cc1029b3899cc53b807</anchor>
      <arglist>(const struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_io_fd *</type>
      <name>osmo_stream_srv_get_iofd</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga9e00a9172d5b2708afa269d52c118eff</anchor>
      <arglist>(const struct osmo_stream_srv *srv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_destroy</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga47f18e063f64f22cb74d58d8b7243bed</anchor>
      <arglist>(struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_flush_and_destroy</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga8390ce6740e56eb22215e1c5805c95f1</anchor>
      <arglist>(struct osmo_stream_srv *conn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_data</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga9891663b20714d72f992e44ad1e92eea</anchor>
      <arglist>(struct osmo_stream_srv *conn, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_segmentation_cb</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga560a6d868bf95bf2f3a4b716bfd5cac9</anchor>
      <arglist>(struct osmo_stream_srv *conn, osmo_stream_srv_segmentation_cb_t segmentation_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_set_segmentation_cb2</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga348c4560f69403fc3a3dfcbe874c2593</anchor>
      <arglist>(struct osmo_stream_srv *conn, osmo_stream_srv_segmentation_cb2_t segmentation_cb2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_srv_send</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gaa1589994cf6eab27742cafee6b7fb491</anchor>
      <arglist>(struct osmo_stream_srv *conn, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_recv</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>gac86242c41223c525c770ff7e7515d83e</anchor>
      <arglist>(struct osmo_stream_srv *conn, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_srv_set_param</name>
      <anchorfile>group__stream__srv.html</anchorfile>
      <anchor>ga0e7adb8aef2f007144d4df24b21fbfe4</anchor>
      <arglist>(struct osmo_stream_srv *conn, enum osmo_stream_srv_param par, void *val, size_t val_len)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>stream_cli</name>
    <title>Osmocom Stream Client</title>
    <filename>group__stream__cli.html</filename>
    <member kind="typedef">
      <type>int(*</type>
      <name>osmo_stream_cli_read_cb2_t</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga113d99fd2e25ce01e98db0a6aa21c89c</anchor>
      <arglist>)(struct osmo_stream_cli *cli, int res, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_name</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaeb712dc553735736047f9b11d9583baa</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_name_f</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gacf917820669504d5f2856eaf74508921</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char *fmt,...)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>osmo_stream_cli_get_name</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga0967921ed380123e3f54fd35375741bf</anchor>
      <arglist>(const struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_nodelay</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaa196e78db6ca32abb1473566b4f1b04b</anchor>
      <arglist>(struct osmo_stream_cli *cli, bool nodelay)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_priority</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gac3ec56e61ce062300ad1df73a5f2c7f8</anchor>
      <arglist>(struct osmo_stream_cli *cli, int sk_prio)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_ip_dscp</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga18526a340625c84a69ccc067ce2cda58</anchor>
      <arglist>(struct osmo_stream_cli *cli, uint8_t ip_dscp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_addr</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga0038e937cf0f36c59e0e3991523219a1</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_addrs</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaab1e7ef0ccc88e124c5f7bbb5e46c29c</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char **addr, size_t addrcnt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_port</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gab8b9f65bebfeb83c6e33d102e9439770</anchor>
      <arglist>(struct osmo_stream_cli *cli, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_type</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga5e5c4c9aacc1cd1d303c0295018594cb</anchor>
      <arglist>(struct osmo_stream_cli *cli, int type)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_domain</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga33ce730fc91ebade9b7188fa220656c6</anchor>
      <arglist>(struct osmo_stream_cli *cli, int domain)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_proto</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga91d57aa94a370520540d7272af66a23b</anchor>
      <arglist>(struct osmo_stream_cli *cli, uint16_t proto)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_local_addr</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga70420e7c664cc4c4e69ac4d3476e7f53</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char *addr)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_local_addrs</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga090fc3fcd1706b815ef5a729921c100e</anchor>
      <arglist>(struct osmo_stream_cli *cli, const char **addr, size_t addrcnt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_local_port</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga4d83e3cf7fdf7eb354c2015ff9bed98a</anchor>
      <arglist>(struct osmo_stream_cli *cli, uint16_t port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_data</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga5e94c511d537f63337912bb50fb2dc28</anchor>
      <arglist>(struct osmo_stream_cli *cli, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_reconnect_timeout</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gade74792afe35f31dd2584c888db3dd62</anchor>
      <arglist>(struct osmo_stream_cli *cli, int timeout)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>osmo_stream_cli_get_data</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga606a53840677f3f5200887dc92f5de4d</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_tx_queue_max_length</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga889f96540a1a2271a40dee063eaf5e9d</anchor>
      <arglist>(struct osmo_stream_cli *cli, unsigned int size)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>osmo_stream_cli_get_sockname</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaecd148ae11f2f619aa52dd2900a15827</anchor>
      <arglist>(const struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_fd *</type>
      <name>osmo_stream_cli_get_ofd</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga0615daa4aac253a3d530f35fddbc68bd</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_get_fd</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaffc6ac3b28d87c910294a2f522a1eaab</anchor>
      <arglist>(const struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_io_fd *</type>
      <name>osmo_stream_cli_get_iofd</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gac32d0489dd05ab89fb0c54dfd360d5b3</anchor>
      <arglist>(const struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_connect_cb</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga6a7d4b7df43a3f0487d343fe3cd0c6a7</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_connect_cb_t connect_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_disconnect_cb</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga6640b82a47028434455471bb52d9f577</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_disconnect_cb_t disconnect_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_read_cb</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga798f23db7e2e1d999775589db8a73d03</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_read_cb_t read_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_read_cb2</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga7892eb77d40f08a254f654786d0b996b</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_read_cb2_t read_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_segmentation_cb</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gab6094559935824750d82b9164ed76910</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_segmentation_cb_t segmentation_cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_set_segmentation_cb2</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaf62f1dbe4570d8ffd00b3bdc3f28d24b</anchor>
      <arglist>(struct osmo_stream_cli *cli, osmo_stream_cli_segmentation_cb2_t segmentation_cb2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_reconnect</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga11d2615f6197f33073ba7245e5ba95ee</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>osmo_stream_cli_is_connected</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga79a09e9c9b8cc98991cd5eebdb41ed57</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_stream_cli *</type>
      <name>osmo_stream_cli_create</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga1754a498abc27577a8e0b3b0f236c05b</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_destroy</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga9d0dac2f390c660c85fa347765f4f45a</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_open</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga86b4b9c8e563f8426d3cdae803e3ec38</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_open2</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga127866794591d16a0eb7244f2fe666ef</anchor>
      <arglist>(struct osmo_stream_cli *cli, int reconnect)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_close</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gad217c1c1b83ac852e090afd49146db19</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_send</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gaacf415b97e1184baadeee5c60387422b</anchor>
      <arglist>(struct osmo_stream_cli *cli, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_recv</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga06f9743c19068bb720a4949ae8467243</anchor>
      <arglist>(struct osmo_stream_cli *cli, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_stream_cli_clear_tx_queue</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>gafa39b1dcc139ad12cbc38d51049bf14f</anchor>
      <arglist>(struct osmo_stream_cli *cli)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_stream_cli_set_param</name>
      <anchorfile>group__stream__cli.html</anchorfile>
      <anchor>ga0638e98001fa4bdd36533718472dfac7</anchor>
      <arglist>(struct osmo_stream_cli *cli, enum osmo_stream_cli_param par, void *val, size_t val_len)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>twjit</name>
    <title>Themyscira Wireless RTP jitter buffer implementation</title>
    <filename>group__twjit.html</filename>
    <class kind="struct">osmo_twjit_stats</class>
    <class kind="struct">osmo_twjit_rr_info</class>
    <member kind="function">
      <type>struct osmo_twjit_config *</type>
      <name>osmo_twjit_config_alloc</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>ga259b383e11fc673da0e931a806c20f91</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_twjit_config_free</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>gaeaa7314c9ee2efbdce688cc13b63b463</anchor>
      <arglist>(struct osmo_twjit_config *conf)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twjit_config_set_buffer_depth</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>ga4e56a380bf9751aaf6f6fc323c747c2c</anchor>
      <arglist>(struct osmo_twjit_config *conf, uint16_t bd_start, uint16_t bd_hiwat)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twjit_config_set_thinning_int</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>ga8c272a9f3344a110dce9e6d66d505493</anchor>
      <arglist>(struct osmo_twjit_config *conf, uint16_t thinning_int)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twjit_config_set_max_future_sec</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>ga55d8b223908b5a638ec62983fcfc7706</anchor>
      <arglist>(struct osmo_twjit_config *conf, uint16_t max_future_sec)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twjit_config_set_start_min_delta</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>ga8df47e86d7ead591db87da21c73e8dda</anchor>
      <arglist>(struct osmo_twjit_config *conf, uint16_t delta_ms)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twjit_config_set_start_max_delta</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>ga260c4ebd28ed8592c4b04fc9cadc2935</anchor>
      <arglist>(struct osmo_twjit_config *conf, uint16_t delta_ms)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twjit_config_set_handover_on_marker</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>ga63204cb283949fd8c4417142616f6591</anchor>
      <arglist>(struct osmo_twjit_config *conf, bool hom)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_twjit *</type>
      <name>osmo_twjit_create</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>ga77a05c62c2cc131b4ca8a00cf8ecca62</anchor>
      <arglist>(void *ctx, uint16_t clock_khz, uint16_t quantum_ms, const struct osmo_twjit_config *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_twjit_destroy</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>ga7c28897aed4b25c3ede1a67fc5e6ae95</anchor>
      <arglist>(struct osmo_twjit *twjit)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twjit_set_config</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>ga930cda4155d06b50b87fcdc1785e7bec</anchor>
      <arglist>(struct osmo_twjit *twjit, const struct osmo_twjit_config *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_twjit_reset</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>ga76bed8e0f9d9a23d8d6fea1d8b62abbf</anchor>
      <arglist>(struct osmo_twjit *twjit)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_twjit_input</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>gaf3383fd56f33f86d21aa41afe318c064</anchor>
      <arglist>(struct osmo_twjit *twjit, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>struct msgb *</type>
      <name>osmo_twjit_output</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>gaad365cac430364b862957f46eaaca391</anchor>
      <arglist>(struct osmo_twjit *twjit)</arglist>
    </member>
    <member kind="function">
      <type>const struct osmo_twjit_stats *</type>
      <name>osmo_twjit_get_stats</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>gaeb5d008cacb7d8329c0f0fffb4463504</anchor>
      <arglist>(struct osmo_twjit *twjit)</arglist>
    </member>
    <member kind="function">
      <type>const struct osmo_twjit_rr_info *</type>
      <name>osmo_twjit_get_rr_info</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>ga40f81a7ab7af3942e540a50bb367ae56</anchor>
      <arglist>(struct osmo_twjit *twjit)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>osmo_twjit_rr_info_valid</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>ga7a0b80aa4271d55bbb720a73ab4db421</anchor>
      <arglist>(struct osmo_twjit *twjit)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twjit_config_write</name>
      <anchorfile>group__twjit.html</anchorfile>
      <anchor>gaec23d0393bcf6a30efc503e167afff1b</anchor>
      <arglist>(struct vty *vty, const struct osmo_twjit_config *conf, const char *prefix)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>twrtp</name>
    <title>Themyscira Wireless RTP endpoint implementation</title>
    <filename>group__twrtp.html</filename>
    <class kind="struct">osmo_twrtp_stats</class>
    <member kind="function">
      <type>struct osmo_twrtp *</type>
      <name>osmo_twrtp_create</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>gacf8121473c5a45b5710a0b95d8e16575</anchor>
      <arglist>(void *ctx, uint16_t clock_khz, uint16_t quantum_ms, bool random_ts_seq, const struct osmo_twjit_config *twjit_config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_twrtp_destroy</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>ga5630b784627262f27ca75b524e094a73</anchor>
      <arglist>(struct osmo_twrtp *endp)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twrtp_supply_fds</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>ga1d22a40f737ead143bfca1d75259aba2</anchor>
      <arglist>(struct osmo_twrtp *endp, int rtp_fd, int rtcp_fd)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twrtp_bind_local</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>gaaebac4722d129a840d35a3d0c0aa63a7</anchor>
      <arglist>(struct osmo_twrtp *endp, const struct osmo_sockaddr *rtp_addr, bool bind_rtcp)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twrtp_set_remote</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>gaa712a64e760d07cc5c22cbf2d5772ce9</anchor>
      <arglist>(struct osmo_twrtp *endp, const struct osmo_sockaddr *rtp_addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_twrtp_twjit_rx_ctrl</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>gaaf8aa5a57b46f846b865cb370b36a52e</anchor>
      <arglist>(struct osmo_twrtp *endp, bool rx_enable)</arglist>
    </member>
    <member kind="function">
      <type>struct msgb *</type>
      <name>osmo_twrtp_twjit_rx_poll</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>gacaa8b25a610a5ed982eba709a516c3e2</anchor>
      <arglist>(struct osmo_twrtp *endp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_twrtp_set_raw_rx_cb</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>ga98fce03a5a6dd6a58759c43b3ecb536b</anchor>
      <arglist>(struct osmo_twrtp *endp, osmo_twrtp_raw_rx_cb cb, void *user_data)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twrtp_tx_quantum</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>gae20168f9074f530ae0d9270697fadaeb</anchor>
      <arglist>(struct osmo_twrtp *endp, const uint8_t *payload, unsigned payload_len, uint8_t payload_type, bool marker, bool auto_marker, bool send_rtcp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_twrtp_tx_skip</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>ga971ca670aa852281620c69cbd69a57e8</anchor>
      <arglist>(struct osmo_twrtp *endp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_twrtp_tx_restart</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>ga2e365e51cc37adb56a77b9c2bfa26683</anchor>
      <arglist>(struct osmo_twrtp *endp)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twrtp_tx_forward</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>ga2907d4ec5bdd2bbb32f37d72b3275d94</anchor>
      <arglist>(struct osmo_twrtp *endp, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twrtp_set_sdes</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>ga8072fe44546bcfe663a06ae56efa4db8</anchor>
      <arglist>(struct osmo_twrtp *endp, const char *cname, const char *name, const char *email, const char *phone, const char *loc, const char *tool, const char *note)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_twrtp_set_auto_rtcp_interval</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>ga6b1118cac2c6362a7de38d4aba7eb2c6</anchor>
      <arglist>(struct osmo_twrtp *endp, uint16_t interval)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twrtp_send_rtcp_rr</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>gab331b2461929cbfd4f26b34b11060fd9</anchor>
      <arglist>(struct osmo_twrtp *endp)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_twjit *</type>
      <name>osmo_twrtp_get_twjit</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>gaa2cb81a157a22376b0c51ffc2421760e</anchor>
      <arglist>(struct osmo_twrtp *endp)</arglist>
    </member>
    <member kind="function">
      <type>const struct osmo_twrtp_stats *</type>
      <name>osmo_twrtp_get_stats</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>gaaee07c8c0e31f8551868079a18cb29cf</anchor>
      <arglist>(struct osmo_twrtp *endp)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>osmo_twrtp_got_rtcp_rr</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>gab5cb8eab0ff864174338d6e8cab24b2b</anchor>
      <arglist>(struct osmo_twrtp *endp)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osmo_twrtp_rr_lost_word</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>ga1476c1b31757949bbc7777bee60e5666</anchor>
      <arglist>(struct osmo_twrtp *endp)</arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>osmo_twrtp_rr_lost_cumulative</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>ga0cb9e5f4ea6238a051d3fc51cb39e6fa</anchor>
      <arglist>(struct osmo_twrtp *endp)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osmo_twrtp_rr_jitter_last</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>gafe2455fdfebeda8f4b810ceae34311b1</anchor>
      <arglist>(struct osmo_twrtp *endp)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>osmo_twrtp_rr_jitter_max</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>gacd7e9922bc1682c51befe67e8fccbbd0</anchor>
      <arglist>(struct osmo_twrtp *endp)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twrtp_get_rtp_fd</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>ga059c9fdc8016d0e872d226f7980fd872</anchor>
      <arglist>(struct osmo_twrtp *endp)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twrtp_get_rtcp_fd</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>gadf5ed8a54818f6705d1e036c3ddd9cf5</anchor>
      <arglist>(struct osmo_twrtp *endp)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twrtp_set_dscp</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>ga4fb17a2a0eb8d531c934d6e129e45265</anchor>
      <arglist>(struct osmo_twrtp *endp, uint8_t dscp)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_twrtp_set_socket_prio</name>
      <anchorfile>group__twrtp.html</anchorfile>
      <anchor>ga85635115eb97f0400ca9698dc1e6fb41</anchor>
      <arglist>(struct osmo_twrtp *endp, int prio)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>osmux</name>
    <title>Osmocom Multiplex Protocol</title>
    <filename>group__osmux.html</filename>
    <file>osmux.h</file>
    <file>osmux.c</file>
    <file>osmux_input.c</file>
    <file>osmux_output.c</file>
    <class kind="struct">osmux_hdr</class>
    <class kind="struct">osmux_in_handle</class>
    <class kind="struct">osmux_out_handle</class>
    <member kind="function">
      <type>int</type>
      <name>osmux_snprintf</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>gaf654e092ca97dd764f59905a2ed21650</anchor>
      <arglist>(char *buf, size_t size, struct msgb *msg)</arglist>
    </member>
    <member kind="function">
      <type>struct osmux_in_handle *</type>
      <name>osmux_xfrm_input_alloc</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>gad61cdde332496df6d7350d147e50b8be</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_input_init</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga96230b0431d5d4d91f2dd57a9c85c366</anchor>
      <arglist>(struct osmux_in_handle *h) OSMO_DEPRECATED(&quot;Use osmux_xfrm_input_alloc() instead&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_input_fini</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga13655a3bdc68f5e96ad1fe1c03dc235e</anchor>
      <arglist>(struct osmux_in_handle *h) OSMO_DEPRECATED(&quot;Use talloc_free() instead&quot;)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmux_xfrm_input</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga9c7d30c0d7d9bc0caf744799d629d4cc</anchor>
      <arglist>(struct osmux_in_handle *h, struct msgb *msg, int ccid)</arglist>
    </member>
    <member kind="function">
      <type>struct osmux_out_handle *</type>
      <name>osmux_xfrm_output_alloc</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga41a217bffa1b0ac095c98ab0fab82c25</anchor>
      <arglist>(void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_init</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga90d58246bcd24a6126898cd6c47dddf4</anchor>
      <arglist>(struct osmux_out_handle *h, uint32_t rtp_ssrc) OSMO_DEPRECATED(&quot;Use osmux_xfrm_output_alloc() and osmux_xfrm_output_set_rtp_*() instead&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_init2</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>gaa076e54fa0d249721a4c7b174a8ed2d1</anchor>
      <arglist>(struct osmux_out_handle *h, uint32_t rtp_ssrc, uint8_t rtp_payload_type) OSMO_DEPRECATED(&quot;Use osmux_xfrm_output_alloc() and osmux_xfrm_output_set_rtp_*() instead&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_set_rtp_ssrc</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga08151bad3c12df245d4c0e4f9c4ca966</anchor>
      <arglist>(struct osmux_out_handle *h, uint32_t rtp_ssrc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_set_rtp_pl_type</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga0d96c8a544e0ff56576615e0b2ac7774</anchor>
      <arglist>(struct osmux_out_handle *h, uint32_t rtp_payload_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_set_tx_cb</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga3936e43e881d0992648937417969ead1</anchor>
      <arglist>(struct osmux_out_handle *h, void(*tx_cb)(struct msgb *msg, void *data), void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_set_rtp_msgb_alloc_cb</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>ga97187827e1f793f2392e54585343db32</anchor>
      <arglist>(struct osmux_out_handle *h, rtp_msgb_alloc_cb_t cb, void *cb_data)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmux_xfrm_output_sched</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>gafee78ee4522a9caa238301d7b913dfd6</anchor>
      <arglist>(struct osmux_out_handle *h, struct osmux_hdr *osmuxh)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmux_xfrm_output_flush</name>
      <anchorfile>group__osmux.html</anchorfile>
      <anchor>gaaac410425f6470396ae9db53ebb8dc44</anchor>
      <arglist>(struct osmux_out_handle *h)</arglist>
    </member>
  </compound>
</tagfile>
