#pragma once

#include <complex.h>
#include <stdint.h>

#include <osmocom/core/msgb.h>
#include <osmocom/sigtran/osmo_ss7.h>

struct xua_msg;

#define TCAP_PC_WILDCARD 0xffffffff
#define TCAP_SSN_WILDCARD 0

/* FIXME: have it here for now until decided if it's an optional dependency or not */
#define WITH_TCAP_LOADSHARING

struct tcap_range {
    struct hlist_node list;
    struct osmo_ss7_asp *asp;
    uint32_t tid_start;
    uint32_t tid_end;
    uint32_t pc;
    uint8_t ssn;
};

extern struct osmo_tdef *tcap_T_defs;
extern size_t tcap_T_defs_s;

/* IPA entry point */
int ipa_rx_msg_osmo_ext_tcap_routing(struct osmo_ss7_asp *asp, struct msgb *msg);

bool tcap_range_matches(const struct tcap_range *tcrng, uint32_t tid);
bool tcap_range_overlaps(const struct tcap_range *a, uint32_t tid_min, uint32_t tid_max);

struct tcap_range *tcap_range_alloc(struct osmo_ss7_as *as, struct osmo_ss7_asp *asp,
				    uint32_t tid_start, uint32_t tid_end, uint32_t pc, uint8_t ssn);
void tcap_range_free(struct tcap_range *tcrng);

/* Traffic ASP -> AS -> STP (Rx path) From TCAP Routing AS, only used for connection tracking */
int ss7_asp_tcap_rx_sccp(struct osmo_ss7_as *as, struct osmo_ss7_asp *asp, uint32_t opc, uint32_t dpc, struct msgb *sccp_msg);

/* Traffic STP -> AS -> ASP (Tx path) Loadshare towards the TCAP routing AS */
int ss7_as_select_asp_loadshare_tcap(struct osmo_ss7_asp **asp, struct osmo_ss7_as *as, struct xua_msg *xua);

/* When the ASP got removed */
void tcap_asp_down(struct osmo_ss7_asp *asp);

void tcap_enable(struct osmo_ss7_as *as);
void tcap_disable(struct osmo_ss7_as *as);
