#!/usr/bin/python3
import argparse

def inc_addr(addr_str, inc):
    li = addr_str.split(".")
    num_0 = (int(li[0]) << (3*8))
    num_1 = (int(li[1]) << (2*8))
    num_2 = (int(li[2]) << (1*8))
    num_3 = int(li[3])
    num = num_0 | num_1 | num_2 | num_3
    num += inc
    li[0] = str((num >> (3*8)) & 0xff)
    li[1] = str((num >> (2*8)) & 0xff)
    li[2] = str((num >> (1*8)) & 0xff)
    li[3] = str(num & 0xff)
    return ".".join(li)

parser = argparse.ArgumentParser()

parser.add_argument('--num-streams',
        type=int,
        default=200000,
        help="The number of streams (UE sessions).")
parser.add_argument('--num-addrs',
        type=int,
        default=100,
        help="The number of src IP addresses.")
parser.add_argument('--gtp-local-port',
        type=int,
        default=2152,
        help="The GTPU local port, 2152 by default")
parser.add_argument('--gtp-local-addr',
        type=str,
        default='172.16.32.2',
        help='The first GTPU local IP address in the concurrent list')
parser.add_argument('--ue-addr',
        type=str,
        default='193.0.0.0',
        help='The first UE IP address in the concurrent list')

args = parser.parse_args()

streams_per_tun = (args.num_streams // args.num_addrs)
total_ue_addr_end = inc_addr(args.ue_addr, args.num_streams - 1)
print("# num-streams: %d, num-addrs: %d, UE sessions per GTPU address: %d" %(args.num_streams,  args.num_addrs, streams_per_tun))
print("# start UE addr: %s, end UE addr: %s" %(args.ue_addr, total_ue_addr_end))

for addr_idx in range(args.num_addrs):
        gtp_local_addr = inc_addr(args.gtp_local_addr, addr_idx)
        ue_addr_start = '193.%d.0.0' % addr_idx
        ue_addr_end = inc_addr(ue_addr_start, streams_per_tun - 1)
        print("gtp local %s\t%d ue-ip-range %s\t%s" % (gtp_local_addr, args.gtp_local_port, ue_addr_start, ue_addr_end))
