#!/bin/bash -xe

SCRIPT_DIR=$( cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )
HOSTNAME="$(hostname)"

case $HOSTNAME in
gtplab2)
        TREX_BIN="/opt/trex/t-rex-64"
        ;;
c240-1)
        # Crashes at startup with "t-rex-64"
        TREX_BIN="/opt/trex/t-rex-64-o"
        ;;
epyc1)
        # Crashes at startup with "t-rex-64"
        TREX_BIN="/opt/trex/t-rex-64-o"
        ;;
*)
        echo "UNEXPECTED HOSTNAME: $(hostname)"
        exit 1
        ;;
esac

sudo sysctl -w vm.nr_hugepages=4096

cd /opt/trex
sudo $TREX_BIN -i --astf --software --tso-disable --no-scapy-server --cfg "${SCRIPT_DIR}/trex_cfg_$HOSTNAME.yaml" --no-ofed-check
