#!/bin/bash -xe

SCRIPT_DIR=$( cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )

# see https://trex-tgn.cisco.com/trex/doc/trex_astf.html#_gtpu_traffic_tutorials

NUM_STREAMS=200000
NUM_ADDRS=100

set +x
echo "To start the test, run: >"
echo "tunnel --type gtpu;"
echo "tunnels_topo load -f ${SCRIPT_DIR}/gtpu_topo.py -t num-streams=${NUM_STREAMS},num-addrs=${NUM_ADDRS};"
echo "start -f ${SCRIPT_DIR}/udp_simple.py -m 50000 -d 600 -t num-streams=${NUM_STREAMS},num-addrs=${NUM_ADDRS},num-pkts-ul=1,num-pkts-dl=1,dir=ul;"
echo ""
printf "Once the test finished, run: >\ntunnel --type gtpu --off;\n stats\n"
set -x
# Needs to be executed from /opt/trex ...
cd /opt/trex/
/opt/trex/trex-console

# Troubleshooting:
# > portattr
# > service
# > ping -p 0 -d 172.16.32.1 -n 3
# > ping -p 1 -d 172.16.31.2 -n 3
# > service --off
# > tunnels_topo show
