#!/bin/bash -xe

SCRIPT_DIR=$( cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )

NUM_ENB=100
# Interface towards UPF:
ADDR_GW_CN="172.16.31.200"

case $(hostname) in
gtplab1)
        IFACE_RAN="enp2s0f1np1"
        IFACE_CN="enp2s0f0np0"
        MAC_RAN_PEER="ec:0d:9a:8a:27:52"
        MAC_CN_PEER="ec:0d:9a:8a:27:53"
        ;;
c240-2)
        IFACE_RAN="ens2f0np0"
        IFACE_CN="ens2f1np1"
        # TRex peer is epyc1's Mellanox NIC:
        MAC_RAN_PEER="b8:ce:f6:fe:62:e0"
        MAC_CN_PEER="b8:ce:f6:fe:62:e1"
        # Adapt Rx/Tx Queues and IRQs to Numa Node of device:
        # cat /sys/class/net/$IFACE_RAN/device/numa_node
        # 0
        # cat /sys/class/net/$IFACE_RAN/device/local_cpulist
        # 0-19
        sudo ethtool -L $IFACE_RAN combined 20
        sudo ethtool -L $IFACE_CN combined 20
        sudo "$SCRIPT_DIR/../../../../../scripts/set_irq_affinity_cpulist.sh" 0-19 $IFACE_RAN
        sudo "$SCRIPT_DIR/../../../../../scripts/set_irq_affinity_cpulist.sh" 0-19 $IFACE_CN
        ;;
epyc1)
        IFACE_RAN="enp129s0f0np0"
        IFACE_CN="enp129s0f1np1"
        # TRex peer is c240-1 Mellanox NIC:
        MAC_RAN_PEER="88:e9:a4:3b:f0:48"
        MAC_CN_PEER="88:e9:a4:3b:f0:49"
        ;;
*)
        echo "UNEXPECTED HOSTNAME: $(hostname)"
        exit 1
        ;;
esac

# Disable ethernet flow control:
sudo ethtool -A $IFACE_RAN autoneg off rx off tx off
sudo ethtool -A $IFACE_CN autoneg off rx off tx off
# Disable GRO / LRO:
sudo ethtool -K $IFACE_RAN gro off lro off
sudo ethtool -K $IFACE_CN gro off lro off
# Increase NIC buffers:
sudo ethtool -G $IFACE_RAN rx 8192 tx 8192
sudo ethtool -G $IFACE_CN rx 8192 tx 8192

# Enable IP forwarding:
sudo sysctl -w net.ipv4.ip_forward=1

# Increase UDP buffer memory:
sudo sysctl -w net.ipv4.udp_mem="763563 900000000 1000000000"
sudo sysctl -w net.core.optmem_max=16000000
sudo sysctl -w net.core.rmem_max=2000000000
sudo sysctl -w net.core.rmem_default=2000000000
sudo sysctl -w net.core.wmem_max=2000000000
sudo sysctl -w net.core.wmem_default=2000000000
sudo sysctl -w net.core.netdev_max_backlog=2000
sudo sysctl -w net.core.netdev_budget=600

# Set up UPF address:
sudo ip addr add 172.16.32.1/24 dev $IFACE_RAN || true
sudo ip link set up dev $IFACE_RAN || true
sudo ip addr add 172.16.31.2/24 dev $IFACE_CN || true
sudo ip link set up dev $IFACE_CN || true

# TRex doesn't answer ARPs, so we need to set up the peers:
for i in $(seq "2" "$((NUM_ENB + 1))"); do
        # Delete needed to potentially drop incomplet entries created when trying to Tx traffic:
        sudo ip neigh del "$(printf "172.16.32.%u" "$i")" lladdr $MAC_RAN_PEER nud permanent dev $IFACE_RAN || true
        sudo ip neigh add "$(printf "172.16.32.%u" "$i")" lladdr $MAC_RAN_PEER nud permanent dev $IFACE_RAN || true
done
sudo ip neigh del 172.16.31.200 lladdr $MAC_CN_PEER nud permanent dev $IFACE_CN || true
sudo ip neigh add 172.16.31.200 lladdr $MAC_CN_PEER nud permanent dev $IFACE_CN || true

# Add route towards HTTP server on the CN side, aka "the Internet"
sudo ip route add 48.0.0.0/16 via $ADDR_GW_CN dev $IFACE_CN || true

# Apply host specific iface names:
sed -i "s/TEMPLATE_IFACE_RAN/$IFACE_RAN/g" "${SCRIPT_DIR}/eupf.yaml"
sed -i "s/TEMPLATE_IFACE_CN/$IFACE_CN/g" "${SCRIPT_DIR}/eupf.yaml"
