/*!
 * \file      NG_NAS_EncDec.cc
 * \brief     CC file for NG_NAS encode/decode functions.
 * \author    ETSI TTF041
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */

#include "NG_NAS_EncdecDeclarations.hh"
#include "NG_NAS_MsgContainers.hh"
#include "NG_NAS_TypeDefs.hh"
#include "EAP_TypeDefs.hh"

namespace NG__NAS__EncdecDeclarations {

  /****************************************************
   * @desc    External function to encode a ... type
   * @param   value to encode
   * @return  encoded value
   ****************************************************/

  BITSTRING fx__enc__NG__NAS__UL__Message__Type(const NG__NAS__MsgContainers::NG__NAS__UL__Message__Type &p){return int2bit(0,0);}
  BITSTRING fx__enc__NG__NAS__DL__Message__Type(const NG__NAS__MsgContainers::NG__NAS__DL__Message__Type &p){return int2bit(0,0);}
  BITSTRING fx__enc__IntraN1TransparentContainer(const NG__NAS__TypeDefs::IntraN1TransparentContainer &p){return int2bit(0,0);}
  BITSTRING fx__enc__CIoTSmallDataContainer(const NG__NAS__TypeDefs::CIoTSmallDataContainer &p){return int2bit(0,0);}
  BITSTRING fx__enc__EAP__Message__Type(const EAP__TypeDefs::EAP__Message__Type &p){return int2bit(0,0);}

  /****************************************************
   * @desc    External function to decode a ... type
   * @param   value to encode
   * @return  encoded value
   ****************************************************/
  INTEGER fx__dec__NG__NAS__UL__Message__Type(BITSTRING &b, NG__NAS__MsgContainers::NG__NAS__UL__Message__Type &p) {return -1;}
  INTEGER fx__dec__NG__NAS__DL__Message__Type(BITSTRING &b, NG__NAS__MsgContainers::NG__NAS__DL__Message__Type &p) {return -1;}
  INTEGER fx__dec__IntraN1TransparentContainer(BITSTRING &b, NG__NAS__TypeDefs::IntraN1TransparentContainer &p) {return -1;}
  INTEGER fx__dec__CIoTSmallDataContainer(BITSTRING &b, NG__NAS__TypeDefs::CIoTSmallDataContainer &p) {return -1;}
  INTEGER fx__dec__EAP__Message__Type(BITSTRING &b, EAP__TypeDefs::EAP__Message__Type &p) {return -1;}


} // namespace NG__NAS__EncdecDeclarations


