#pragma once

#include "NG_NasEmu_CtrlAspTypes.hh"


#include "layer.hh"
#include "params.hh"

namespace NG__NasEmu__CtrlAspTypes {
  class NG__NAS__CTRL__REQ;
  class NG__NAS__CTRL__CNF;
}

namespace NG__NasEmu__CtrlAspTypes {

  //class HttpPort : public HttpPort_BASE {
  class NG__NASCTRL__PORT : public NG__NASCTRL__PORT_BASE {
    params _cfg_params;
    params _layer_params;
    layer* _layer;
    std::string _time_key;
  public:
    NG__NASCTRL__PORT(const char *par_port_name);
    ~NG__NASCTRL__PORT();

    void set_parameter(const char *parameter_name, const char *parameter_value);
    void receiveMsg (const NG__NasEmu__CtrlAspTypes::NG__NAS__CTRL__CNF& p_ind, const params& p_params);

  private:
    /* void Handle_Fd_Event(int fd, boolean is_readable,
       boolean is_writable, boolean is_error); */
    void Handle_Fd_Event_Error(int fd);
    void Handle_Fd_Event_Writable(int fd);
    void Handle_Fd_Event_Readable(int fd);
    /* void Handle_Timeout(double time_since_last_call); */

  protected:
    void user_map(const char *system_port);
    void user_unmap(const char *system_port);

    void user_start();
    void user_stop();

  protected:
    void outgoing_send(const NG__NasEmu__CtrlAspTypes::NG__NAS__CTRL__REQ& send_par);
  }; // End of class NG__NASCTRL__PORT

} // End of namespace NG__NasEmu__CtrlAspTypes

