/*!
 * \file      ngap_layer.hh
 * \brief     Header file for NGAP protocol layer.
 * \author    ETSI TTF041
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "ngap_codec.hh"
#include "t_layer.hh"

namespace LibNGAP__Interface {
  class NGAPPort; //! Forward declaration of TITAN class
} // namespace NGAP__TestSystem

/*!
 * \class ngap_layer
 * \brief  This class provides description of ITS NGAP protocol layer
 */
class ngap_layer : public t_layer<LibNGAP__Interface::NGAPPort> {
  params_ngap _params; //! Layer parameters
  ngap_codec  _codec;  //! NGAP codec
public:              //! \publicsection
  /*!
   * \brief Default constructor
   *        Create a new instance of the ngap_layer class
   */
  explicit ngap_layer() : t_layer<LibNGAP__Interface::NGAPPort>(), _params(), _codec(){};
  /*!
   * \brief Specialised constructor
   *        Create a new instance of the ngap_layer class
   * \param[in] p_type \todo
   * \param[in] p_param \todo
   */
  ngap_layer(const std::string &p_type, const std::string &param);
  /*!
   * \brief Default destructor
   */
  virtual ~ngap_layer(){};

  /*!
   * \fn void sendMsg(const LibItsCam__TestSystem::CamReq& p_ngap_req, params& p_params);
   * \brief Send CA message to the lower layers
   * \param[in] p_ngap_req The CA message to be sent
   * \param[in] p_params Some parameters to overwrite default value of the lower layers parameters
   */
  void sendMsg(const NGAP__PDU__Descriptions::NGAP__PDU& p_ngap, params &p_params);

  /*!
   * \virtual
   * \fn void send_data(OCTETSTRING& data, params& params);
   * \brief Send bytes formated data to the lower layers
   * \param[in] p_data The data to be sent
   * \param[in] p_params Some parameters to overwrite default value of the lower layers parameters
   */
  virtual void send_data(OCTETSTRING &data, params &params);
  /*!
   * \virtual
   * \fn void receive_data(OCTETSTRING& data, params& params);
   * \brief Receive bytes formated data from the lower layers
   * \param[in] p_data The bytes formated data received
   * \param[in] p_params Some lower layers parameters values when data was received
   */
  virtual void receive_data(OCTETSTRING &data, params &info);

//  int enable_secured_mode(const std::string &p_certificate_id, const boolean p_enforce_security);

//  int disable_secured_mode();

}; // End of class ngap_layer
