/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.T1Exception;

public class T1Block {
    byte t1NAD;
    byte t1PCB;
    short t1LEN;
    byte[] t1INF = new byte[32];
    byte t1LRC;
    static final int MAX_INF_SIZE = 32;
    static final int BLOCK_OVERHEAD_SIZE = 4;
    public static final byte NULL_ADDRESS = 0;
    public static final byte S_RESYNC_REQ = -64;
    public static final byte S_RESYNC_RES = -32;
    public static final byte S_IFS_REQ = -63;
    public static final byte S_IFS_RES = -31;
    public static final byte S_ABORT_REQ = -62;
    public static final byte S_ABORT_RES = -30;
    public static final byte S_WTX_REQ = -61;
    public static final byte S_WTX_RES = -29;
    public static final byte TYPE_IBLOCK = 0;
    public static final byte TYPE_RBLOCK = -128;
    public static final byte TYPE_SBLOCK = -64;
    public static final byte SEQUENCE_MASK = 64;
    public static final byte CHAINING_MASK = 32;
    public static final byte BLOCK_MASK = -64;
    public static final byte IBLOCK_MASK = -128;
    public static final byte RECV_MASK = 16;
    public static final byte PARITY_MASK = 1;
    public static final byte ERROR_MASK = 2;
    public static final byte CARD_ADDR = 2;
    public static final byte HOST_ADDR = 1;
    public static final int OFFSET_NAD = 0;
    public static final int OFFSET_PCB = 1;
    public static final int OFFSET_LEN = 2;
    public static final int OFFSET_INF = 3;

    public void setIBlock(byte src, byte dst, boolean seqFlag, boolean chainingFlag, byte[] infoData, int infoSize) throws T1Exception {
        this.setIBlock(src, dst, seqFlag, chainingFlag, infoData, 0, infoSize);
    }

    public void setIBlock(byte src, byte dst, boolean seqFlag, boolean chainingFlag, byte[] infoData, int infoOffset, int infoSize) throws T1Exception {
        if (infoSize > 32 || infoSize < 0) {
            throw new T1Exception(-128);
        }
        this.t1NAD = (byte)(dst << 4 | src);
        this.t1PCB = 0;
        if (seqFlag) {
            this.t1PCB = (byte)(this.t1PCB | 0x40);
        }
        if (!chainingFlag) {
            this.t1PCB = (byte)(this.t1PCB | 0x20);
        }
        this.t1LEN = (short)infoSize;
        try {
            if (infoSize > 0) {
                System.arraycopy(infoData, infoOffset, this.t1INF, 0, infoSize);
            }
        }
        catch (Exception ex) {
            throw new T1Exception(-128);
        }
        this.t1LRC = this.computeLRC();
    }

    public void setRBlock(byte src, byte dst, boolean seqFlag) throws T1Exception {
        this.t1NAD = (byte)(dst << 4 | src);
        this.t1PCB = (byte)-128;
        if (seqFlag) {
            this.t1PCB = (byte)(this.t1PCB | 0x10);
        }
        this.t1LEN = 0;
        this.t1LRC = this.computeLRC();
    }

    public void setSBlock(byte src, byte dst, int ctrlType, int infData) throws T1Exception {
        this.t1NAD = (byte)(dst << 4 | src);
        this.t1PCB = (byte)-64;
        this.t1PCB = (byte)(this.t1PCB | ctrlType);
        switch (ctrlType) {
            case -63: 
            case -61: 
            case -31: 
            case -29: {
                this.t1LEN = 1;
                this.t1INF[0] = (byte)infData;
                break;
            }
            case -64: 
            case -62: 
            case -32: 
            case -30: {
                this.t1LEN = 0;
                break;
            }
            default: {
                throw new T1Exception(-125);
            }
        }
        this.t1LRC = this.computeLRC();
    }

    byte computeLRC() {
        byte lrcVal = 0;
        lrcVal = (byte)(lrcVal ^ this.t1NAD);
        lrcVal = (byte)(lrcVal ^ this.t1PCB);
        lrcVal = (byte)(lrcVal ^ (byte)this.t1LEN);
        for (int i = 0; i < this.t1LEN; ++i) {
            lrcVal = (byte)(lrcVal ^ this.t1INF[i]);
        }
        return lrcVal;
    }

    public byte[] toByteArray() {
        byte[] blockData = new byte[this.t1LEN + 4];
        blockData[0] = this.t1NAD;
        blockData[1] = this.t1PCB;
        blockData[2] = (byte)this.t1LEN;
        System.arraycopy(this.t1INF, 0, blockData, 3, this.t1LEN);
        blockData[3 + this.t1LEN] = this.t1LRC;
        return blockData;
    }

    public static T1Block readBlock(byte[] buffer, int offset, int len) throws T1Exception {
        T1Block newBlock = null;
        newBlock.readBlockInstance(buffer, offset, len);
        if (!newBlock.checkBlock()) {
            throw new T1Exception(-126);
        }
        return newBlock;
    }

    public void readBlockInstance(byte[] buffer, int offset, int len) throws T1Exception {
        if ((buffer[offset + 2] & 0xFF) != len - 4) {
            throw new T1Exception(-126);
        }
        this.t1NAD = buffer[offset + 0];
        this.t1PCB = buffer[offset + 1];
        this.t1LEN = buffer[offset + 2];
        try {
            System.arraycopy(buffer, offset + 3, this.t1INF, 0, this.t1LEN);
            this.t1LRC = buffer[offset + 3 + this.t1LEN];
        }
        catch (Exception ex) {
            throw new T1Exception(-126);
        }
        if (!this.checkBlock()) {
            throw new T1Exception(-126);
        }
    }

    public boolean checkBlock() {
        return T1Block.checkBlock(this);
    }

    public static boolean checkBlock(T1Block theBlock) {
        byte lrcVal = 0;
        lrcVal = (byte)(lrcVal ^ theBlock.t1NAD);
        lrcVal = (byte)(lrcVal ^ theBlock.t1PCB);
        lrcVal = (byte)(lrcVal ^ (byte)(theBlock.t1LEN & 0xFF));
        for (int i = 0; i < theBlock.t1LEN; ++i) {
            lrcVal = (byte)(lrcVal ^ theBlock.t1INF[i]);
        }
        return (lrcVal = (byte)(lrcVal ^ theBlock.t1LRC)) == 0;
    }

    public byte getBlockType() {
        byte blockType = (byte)(this.t1PCB & 0xFFFFFFC0);
        if (blockType == 64) {
            blockType = (byte)(blockType & 0xFFFFFF80);
        }
        return blockType;
    }

    public byte[] getINFBytes() {
        return this.t1INF;
    }

    public int getIntINF() {
        return this.t1INF[0] & 0xFF;
    }

    public int getLEN() {
        return this.t1LEN & 0xFF;
    }

    public boolean isLastBlock() {
        byte type = this.getBlockType();
        if (type != 0) {
            return true;
        }
        byte chainFlag = (byte)(this.t1PCB & 0x20);
        return chainFlag == 0;
    }

    public boolean getSequence() {
        byte type = this.getBlockType();
        switch (type) {
            case 0: {
                byte value = (byte)(this.t1PCB & 0x40);
                return value != 0;
            }
            case -128: {
                byte value = (byte)(this.t1PCB & 0x10);
                return value != 0;
            }
        }
        return false;
    }

    public byte getSBlockType() {
        byte type = this.getBlockType();
        if (type != -64) {
            return -1;
        }
        return this.t1PCB;
    }

    private String getIBlockStr() {
        boolean lb = this.isLastBlock();
        boolean sq = this.getSequence();
        String strOut = "I(";
        strOut = lb ? strOut + "0, " : strOut + "1, ";
        strOut = sq ? strOut + "1)" : strOut + "0)";
        return strOut;
    }

    private String getRBlockStr() {
        boolean sq = this.getSequence();
        String strOut = "R(";
        strOut = sq ? strOut + "1)" : strOut + "0)";
        return strOut;
    }

    private String getSBlockStr() {
        String strOut = "S(";
        byte st = (byte)(this.t1PCB & 0xE3);
        switch (st) {
            case -63: {
                strOut = strOut + "IFS_REQ";
                break;
            }
            case -31: {
                strOut = strOut + "IFS_RES";
                break;
            }
            case -61: {
                strOut = strOut + "WTX_REQ";
                break;
            }
            case -29: {
                strOut = strOut + "WTX_RES";
                break;
            }
            case -62: {
                strOut = strOut + "ABORT_REQ";
                break;
            }
            case -30: {
                strOut = strOut + "ABORT_RES";
                break;
            }
            case -64: {
                strOut = strOut + "RESYNC_REQ";
                break;
            }
            case -32: {
                strOut = strOut + "RESYNC_RES";
            }
        }
        strOut = strOut + ")";
        return strOut;
    }

    public String toString() {
        String retStr = "";
        switch (this.getBlockType()) {
            case 0: {
                retStr = this.getIBlockStr();
                break;
            }
            case -128: {
                retStr = this.getRBlockStr();
                break;
            }
            case -64: {
                retStr = this.getSBlockStr();
            }
        }
        retStr = retStr + ": " + "NAD:" + Integer.toHexString(this.t1NAD & 0xFF) + " LEN:" + Integer.toHexString(this.t1LEN & 0xFF);
        return retStr;
    }
}

