/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cm.impl.jcrd;

import com.sun.javacard.cm.impl.jcrd.FormatErrorException;
import com.sun.javacard.cm.impl.jcrd.Util;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class UserRole {
    public static final String HOLDER_GLOBAL_AUTH_URI = "sio:///standard/auth/holder/global/";
    public static final String HOLDER_SESSION_AUTH_URI = "sio:///standard/auth/holder/session/";
    public static final String USER_SESSION_AUTH_URI = "sio:///standard/auth/user/session/";
    private Vector<String> mappedToAuthURIs;
    private String roleName;
    private boolean authURIsSet = false;

    public UserRole(String name) {
        this.roleName = name;
    }

    public String getUserRoleName() {
        return this.roleName;
    }

    public boolean setAuthURIs(String URIList) throws FormatErrorException {
        if (this.authURIsSet) {
            return false;
        }
        this.mappedToAuthURIs = Util.getStringVector(URIList);
        for (String uri : this.mappedToAuthURIs) {
            if (uri.startsWith(HOLDER_GLOBAL_AUTH_URI) && uri.endsWith("/*")) {
                Util.fatalError("4106", uri);
            }
            if (uri.startsWith(HOLDER_GLOBAL_AUTH_URI) || uri.startsWith(HOLDER_SESSION_AUTH_URI) || uri.startsWith(USER_SESSION_AUTH_URI)) continue;
            Util.fatalError("4135", uri);
        }
        this.authURIsSet = true;
        return true;
    }

    public Vector<String> getAuthURIs() {
        return this.mappedToAuthURIs;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.mappedToAuthURIs != null) {
            sb.append("\t\t\tUser Authenticator URIs\n");
            for (String auri : this.mappedToAuthURIs) {
                sb.append("\t\t\t    " + auri + "\n");
            }
        }
        return sb.toString();
    }
}

