/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.util;

import com.sun.javacard.Logger;
import com.sun.javacard.impl.NativeMethods;
import javacard.framework.AID;

public class APDUUtil {
    private static final int FIXED_RID_LENGTH = 10;
    private static final int MAX_PIX_LENGTH = 22;
    private static final String aidAuthority = "//aid/";

    public static boolean isValidAID(String aid) {
        if (!aid.startsWith(aidAuthority)) {
            Logger.debug("Invalid AID. does not start with //aid/");
            return false;
        }
        String aidSubStr = aid.substring(aidAuthority.length());
        int lastIndexofSlash = aidSubStr.lastIndexOf(47);
        if (lastIndexofSlash == -1) {
            Logger.debug("Missing PIX in " + aid);
            return false;
        }
        if (lastIndexofSlash != aidSubStr.indexOf(47)) {
            Logger.debug("Invalid AID " + aid);
            return false;
        }
        String RID = aidSubStr.substring(0, lastIndexofSlash);
        String PIX = aidSubStr.substring(lastIndexofSlash + 1);
        if (RID.length() != 10) {
            Logger.debug("Invalid RID " + RID + " in " + aid);
            return false;
        }
        if (RID.startsWith("-")) {
            Logger.debug("RID starts with a \"-\" in  " + aid);
            return false;
        }
        if (!APDUUtil.isValidHexadecimalNumber(RID)) {
            Logger.debug("RID is not a valid hexadecimal number in " + aid);
            return false;
        }
        if (PIX.equals("-")) {
            return true;
        }
        if (PIX.length() == 0) {
            Logger.debug("Empty PIX in " + aid);
            return false;
        }
        if (PIX.startsWith("-")) {
            Logger.debug("PIX starts with a \"-\" in  " + aid);
            return false;
        }
        if (PIX.length() % 2 != 0 || PIX.length() > 22) {
            Logger.debug("Invalid PIX length in  " + aid);
            return false;
        }
        if (!APDUUtil.isValidHexadecimalNumber(PIX)) {
            Logger.debug("PIX is not a valid hexadecimal number in " + aid);
            return false;
        }
        return true;
    }

    public static boolean isValidHexadecimalNumber(String number) {
        for (int startIndex = 0; startIndex < number.length(); startIndex += 2) {
            String smallNumber = number.substring(startIndex, startIndex + 2);
            try {
                Integer.parseInt(smallNumber, 16);
                continue;
            }
            catch (NumberFormatException e) {
                Logger.debug(e.toString());
                return false;
            }
        }
        return true;
    }

    public static byte[] getAIDAsByteArray(String aid) {
        int aidByteArrayLength = 0;
        String aidSubStr = aid.substring(aidAuthority.length());
        int lastIndexofSlash = aidSubStr.lastIndexOf(47);
        String RID = aidSubStr.substring(0, lastIndexofSlash);
        String PIX = aidSubStr.substring(lastIndexofSlash + 1);
        aidByteArrayLength = !PIX.equals("-") ? RID.length() / 2 + PIX.length() / 2 : RID.length() / 2;
        byte[] aidArray = new byte[aidByteArrayLength];
        int offset = APDUUtil.getByteArrayForString(RID, aidArray, 0);
        if (!PIX.equals("-")) {
            APDUUtil.getByteArrayForString(PIX, aidArray, offset);
        }
        return aidArray;
    }

    public static int getByteArrayForString(String number, byte[] outputArray, int offset) {
        int length = number.length();
        if (length % 2 != 0) {
            Logger.debug("Invalid hexadecimal number  " + number);
            throw new NumberFormatException();
        }
        for (int startIndex = 0; startIndex < number.length(); startIndex += 2) {
            String smallNumber = number.substring(startIndex, startIndex + 2);
            outputArray[offset++] = (byte)Integer.parseInt(smallNumber, 16);
        }
        return offset;
    }

    public static String getStringForByteArray(byte[] input) {
        StringBuffer sb = new StringBuffer();
        for (byte num : input) {
            sb.append(Integer.toHexString(num & 0xFF));
        }
        return sb.toString().toLowerCase();
    }

    public static String getURIForAID(AID aid) {
        StringBuffer sb = new StringBuffer();
        byte[] aidBytes = new byte[16];
        NativeMethods.transferOwnershipUsingSecondObject(aidBytes, aid);
        int aidLength = aid.getBytes(aidBytes, (short)0);
        sb.append(aidAuthority);
        for (int i = 0; i < aidLength; ++i) {
            int num = aidBytes[i] & 0xFF;
            if (num < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(num).toUpperCase());
            if (i != 4) continue;
            sb.append("/");
        }
        if (aidLength == 5) {
            sb.append("-");
        }
        return (String)NativeMethods.transferOwnershipToPreviousContext(sb.toString());
    }

    public static AID getAIDForURI(String uri) {
        byte[] aidBytes = APDUUtil.getAIDAsByteArray(uri);
        NativeMethods.setGloballyAccessible(aidBytes);
        return new AID(aidBytes, 0, (byte)aidBytes.length);
    }
}

