/*
 * Decompiled with CFR 0.152.
 */
package javacardx.io;

import com.sun.javacard.URI;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.security.URIPermission;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public final class ConnectorPermission
extends URIPermission {
    public static final String ACTION_CONNECT = "connect";
    public static final String ACTION_LISTEN = "listen";
    public static final String ACTION_ACCEPT = "accept";
    public static final String ACTION_READ = "read";
    public static final String ACTION_WRITE = "write";
    private String[] possibleActions;

    public ConnectorPermission(String url, String actions) {
        super(url, actions);
        if (actions == null) {
            throw new NullPointerException();
        }
        if (this.getActions().equals("")) {
            throw new IllegalArgumentException();
        }
        if (!url.equals("*")) {
            URI uriObj = URI.create(url);
            String scheme = uriObj.getScheme();
            if (scheme == null || scheme.equals("")) {
                throw new IllegalArgumentException("The uri does not have a scheme");
            }
            if (!(scheme.equals("file") || scheme.equals("http") || scheme.equals("https") || scheme.equals("socket") || scheme.equals("ssl"))) {
                throw new IllegalArgumentException("invalid scheme");
            }
        }
    }

    @Override
    protected String[] getPossibleActions() {
        if (this.possibleActions == null) {
            this.possibleActions = new String[]{ACTION_ACCEPT, ACTION_CONNECT, ACTION_LISTEN, ACTION_READ, ACTION_WRITE};
        }
        return this.possibleActions;
    }
}

