/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io;

import java.io.IOException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class ByteArrayEndPoint
implements EndPoint {
    byte[] inBytes;
    ByteArrayBuffer inBuffer;
    ByteArrayBuffer outBuffer;
    boolean closed;

    public ByteArrayEndPoint() {
    }

    public ByteArrayEndPoint(byte[] input, int outputSize) {
        this.inBytes = input;
        this.inBuffer = new ByteArrayBuffer(input);
        this.outBuffer = new ByteArrayBuffer(outputSize);
    }

    public ByteArrayBuffer getIn() {
        return this.inBuffer;
    }

    public void setIn(ByteArrayBuffer in) {
        this.inBuffer = in;
    }

    public ByteArrayBuffer getOut() {
        return this.outBuffer;
    }

    public void setOut(ByteArrayBuffer out) {
        this.outBuffer = out;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public void blockReadable(long millisecs) {
    }

    @Override
    public void blockWritable(long millisecs) {
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public int fill(Buffer buffer) throws IOException {
        if (this.closed) {
            throw new IOException("CLOSED");
        }
        if (this.inBuffer.length() <= 0) {
            return -1;
        }
        int len = buffer.put(this.inBuffer);
        this.inBuffer.skip(len);
        return len;
    }

    @Override
    public int flush(Buffer buffer) throws IOException {
        if (this.closed) {
            throw new IOException("CLOSED");
        }
        int len = this.outBuffer.put(buffer);
        buffer.skip(len);
        return len;
    }

    @Override
    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        int len;
        if (this.closed) {
            throw new IOException("CLOSED");
        }
        int flushed = 0;
        if (header != null && header.length() > 0) {
            len = this.outBuffer.put(header);
            header.skip(len);
            flushed += len;
        }
        if (header == null || header.length() == 0) {
            if (buffer != null && buffer.length() > 0) {
                len = this.outBuffer.put(buffer);
                buffer.skip(len);
                flushed += len;
            }
            if ((buffer == null || buffer.length() == 0) && trailer != null && trailer.length() > 0) {
                len = this.outBuffer.put(trailer);
                trailer.skip(len);
                flushed += len;
            }
        }
        return flushed;
    }

    public void reset() {
        this.closed = false;
        this.inBuffer.clear();
        this.outBuffer.clear();
        if (this.inBytes != null) {
            this.inBuffer.setPutIndex(this.inBytes.length);
        }
    }

    @Override
    public String getLocalAddr() {
        return null;
    }

    @Override
    public String getLocalHost() {
        return null;
    }

    @Override
    public int getLocalPort() {
        return 0;
    }

    @Override
    public String getRemoteAddr() {
        return null;
    }

    @Override
    public String getRemoteHost() {
        return null;
    }

    @Override
    public int getRemotePort() {
        return 0;
    }

    @Override
    public Object getConnection() {
        return this.inBytes;
    }
}

