/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import com.sun.javacard.impl.NativeMethods;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.http.Cookie;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferUtil;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpURI;
import org.mortbay.jetty.WebServer;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class HttpFieldsWrapper {
    HttpFields httpFields;
    String ServerName;
    private int port;
    int portNumber = -1;
    String serverName = null;

    public HttpFieldsWrapper(HttpFields fields) {
        this.httpFields = fields;
    }

    public long getLongField(String name) throws NumberFormatException {
        return this.httpFields.getLongField(name);
    }

    public long getLongField(Buffer name) throws NumberFormatException {
        return this.httpFields.getLongField(name);
    }

    public String getStringField(String name) {
        String fieldValue = this.httpFields.getStringField(name);
        return this.returnStringAfterTransfer(fieldValue);
    }

    public String getStringField(Buffer name) {
        String fieldValue = this.httpFields.getStringField(name);
        return this.returnStringAfterTransfer(fieldValue);
    }

    public boolean containsKey(Buffer name) {
        return this.httpFields.containsKey(name);
    }

    public boolean containsKey(String name) {
        return this.httpFields.containsKey(name);
    }

    public Enumeration<String> getValues(String name) {
        Enumeration<String> values = this.httpFields.getValues(name);
        return this.processEnumeration(values);
    }

    public Enumeration<String> getValues(Buffer name) {
        Enumeration<String> values = this.httpFields.getValues(name);
        return this.processEnumeration(values);
    }

    public Enumeration<String> getValues(String name, String separators) {
        Enumeration<String> values = this.httpFields.getValues(name, separators);
        return this.processEnumeration(values);
    }

    public Enumeration<String> getFieldNames() {
        Enumeration<String> fieldNames = this.httpFields.getFieldNames();
        return this.processEnumeration(fieldNames);
    }

    public long getDateField(String name) {
        return this.httpFields.getDateField(name);
    }

    public int getServerPort(HttpURI uri, HttpConnection connection, String scheme) {
        if (this.port <= 0) {
            if (this.serverName == null) {
                this.getServerName(uri, connection);
            }
            if (this.port <= 0) {
                this.port = this.serverName != null && uri != null ? uri.getPort() : connection.getLocalPort();
            }
        }
        if (this.port <= 0) {
            if (scheme.equalsIgnoreCase("https")) {
                return 443;
            }
            return 80;
        }
        return this.port;
    }

    public String getServerName(HttpURI uri, HttpConnection connection) {
        if (this.serverName != null) {
            return this.returnStringAfterTransfer(this.serverName);
        }
        this.serverName = uri.getHost();
        this.port = uri.getPort();
        if (this.serverName != null) {
            return this.returnStringAfterTransfer(this.serverName);
        }
        Buffer hostPort = this.httpFields.get(HttpHeaders.HOST_BUFFER);
        if (hostPort != null) {
            int i = hostPort.length();
            while (i-- > 0) {
                if (hostPort.peek(hostPort.getReadIndex() + i) != 58) continue;
                this.serverName = hostPort.peek(hostPort.getReadIndex(), i).toString();
                this.port = BufferUtil.toInt(hostPort.peek(hostPort.getReadIndex() + i + 1, hostPort.length() - i - 1));
                return this.returnStringAfterTransfer(this.serverName);
            }
            if (this.serverName == null || this.port < 0) {
                this.serverName = hostPort.toString();
                this.port = 0;
            }
            return this.returnStringAfterTransfer(this.serverName);
        }
        if (connection != null) {
            this.serverName = this.getLocalName(connection);
            this.port = this.getLocalPort(connection);
            if (this.serverName != null && !"0.0.0.0".equals(this.serverName)) {
                return this.returnStringAfterTransfer(this.serverName);
            }
        }
        this.serverName = WebServer.getWebServer().getHostName();
        return this.returnStringAfterTransfer(this.serverName);
    }

    String getLocalName(HttpConnection connection) {
        return connection.getLocalName();
    }

    int getLocalPort(HttpConnection connection) {
        return connection.getLocalPort();
    }

    public Buffer get(Buffer name) {
        return this.httpFields.get(name);
    }

    public void remove(String name) {
        this.httpFields.remove(name);
    }

    public void remove(Buffer name) {
        this.httpFields.remove(name);
    }

    public void put(String name, String value) {
        this.httpFields.put(name, value);
    }

    public void put(Buffer name, String value) {
        this.httpFields.put(name, value);
    }

    public void put(Buffer name, Buffer value) {
        this.httpFields.put(name, value);
    }

    public void put(Buffer buffer) {
        this.httpFields.put(buffer);
    }

    public void add(String name, String value) throws IllegalArgumentException {
        this.httpFields.add(name, value);
    }

    public void add(Buffer name, Buffer value) throws IllegalArgumentException {
        this.httpFields.add(name, value);
    }

    public void putLongField(String name, long value) {
        this.httpFields.putLongField(name, value);
    }

    public void addLongField(String name, long value) {
        this.httpFields.addLongField(name, value);
    }

    public void addLongField(Buffer name, long value) {
        this.httpFields.addLongField(name, value);
    }

    public void putDateField(String name, long date) {
        this.httpFields.putDateField(name, date);
    }

    public void addDateField(String name, long date) {
        this.httpFields.addDateField(name, date);
    }

    public void addSetCookie(Cookie cookie) {
        this.httpFields.addSetCookie(cookie);
    }

    public void write(Writer writer) throws IOException {
        this.httpFields.write(writer);
    }

    public void clear() {
        this.httpFields.clear();
    }

    public void destroy() {
        this.httpFields.destroy();
    }

    public String toString() {
        String str = this.httpFields.toString();
        return this.returnStringAfterTransfer(str);
    }

    public Vector<String> qualityList(Enumeration<String> e) {
        Vector<String> list = HttpFields.qualityList(e);
        this.giveObjectToCallingContext(list);
        return list;
    }

    private Enumeration<String> processEnumeration(Enumeration<String> e) {
        Vector<String> values = new Vector<String>();
        if (e != null) {
            while (e.hasMoreElements()) {
                values.addElement(e.nextElement());
            }
            this.giveObjectToCallingContext(values);
            return values.elements();
        }
        return null;
    }

    private String returnStringAfterTransfer(String str) {
        this.giveObjectToCallingContext(str);
        return str;
    }

    private void giveObjectToCallingContext(Object obj) {
        if (obj != null) {
            NativeMethods.transferOwnershipToPreviousContext(obj);
        }
    }
}

