/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.util.MultiMap;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.URIUtil;
import org.mortbay.util.UrlEncoded;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class HttpURI {
    private static byte[] empty = new byte[0];
    private static final int START = 0;
    private static final int AUTH_OR_PATH = 1;
    private static final int SCHEME_OR_PATH = 2;
    private static final int AUTH = 4;
    private static final int PORT = 5;
    private static final int PATH = 6;
    private static final int PARAM = 7;
    private static final int QUERY = 8;
    boolean partial = false;
    byte[] raw = empty;
    String rawString;
    int scheme;
    int authority;
    int host;
    int port;
    int path;
    int param;
    int query;
    int fragment;
    int end;

    public HttpURI() {
    }

    public HttpURI(boolean parsePartialAuth) {
        this.partial = parsePartialAuth;
    }

    public HttpURI(String raw) {
        this.rawString = raw;
        byte[] b = raw.getBytes();
        this.parse(b, 0, b.length);
    }

    public HttpURI(byte[] raw, int offset, int length) {
        this.parse2(raw, offset, length);
    }

    public void parse(String raw) {
        byte[] b = raw.getBytes();
        this.parse2(b, 0, b.length);
        this.rawString = raw;
    }

    public void parse(byte[] raw, int offset, int length) {
        this.rawString = null;
        this.parse2(raw, offset, length);
    }

    private void parse2(byte[] raw, int offset, int length) {
        this.raw = raw;
        int i = offset;
        int e = offset + length;
        int state = 0;
        int m = offset;
        this.end = offset + length;
        this.scheme = offset;
        this.authority = offset;
        this.host = offset;
        this.port = offset;
        this.path = offset;
        this.param = this.end;
        this.query = this.end;
        this.fragment = this.end;
        while (i < e) {
            int c = 0xFF & this.raw[i];
            int s = i++;
            switch (state) {
                case 0: {
                    m = s;
                    if (c == 47) {
                        state = 1;
                        break;
                    }
                    if (this.isLetterOrDigit((char)c)) {
                        state = 2;
                        break;
                    }
                    if (c == 59) {
                        this.param = s;
                        state = 7;
                        break;
                    }
                    if (c == 63) {
                        this.param = s;
                        this.query = s;
                        state = 8;
                        break;
                    }
                    if (c == 35) {
                        this.param = s;
                        this.query = s;
                        this.fragment = s;
                        break;
                    }
                    throw new IllegalArgumentException(new String(this.raw, offset, length));
                }
                case 1: {
                    if ((this.partial || this.scheme != this.authority) && c == 47) {
                        this.host = i;
                        this.port = this.end;
                        this.path = this.end;
                        state = 4;
                        break;
                    }
                    if (c == 59 || c == 63 || c == 35) {
                        --i;
                        state = 6;
                        break;
                    }
                    this.host = m;
                    this.port = m;
                    state = 6;
                    break;
                }
                case 2: {
                    if (length > 6 && c == 116) {
                        if (this.raw[offset + 3] == 58) {
                            s = offset + 3;
                            i = offset + 4;
                            c = 58;
                        } else if (this.raw[offset + 4] == 58) {
                            s = offset + 4;
                            i = offset + 5;
                            c = 58;
                        } else if (this.raw[offset + 5] == 58) {
                            s = offset + 5;
                            i = offset + 6;
                            c = 58;
                        }
                    }
                    if (c == 58) {
                        this.authority = m = i++;
                        this.path = m;
                        c = (char)(0xFF & this.raw[i]);
                        if (c == 47) {
                            state = 1;
                            break;
                        }
                        this.host = m;
                        this.port = m;
                        state = 6;
                        break;
                    }
                    if (c == 47) {
                        state = 6;
                        break;
                    }
                    if (c == 59) {
                        this.param = s;
                        state = 7;
                        break;
                    }
                    if (c == 63) {
                        this.param = s;
                        this.query = s;
                        state = 8;
                        break;
                    }
                    if (c != 35) break;
                    this.param = s;
                    this.query = s;
                    this.fragment = s;
                    break;
                }
                case 4: {
                    if (c == 47) {
                        this.port = this.path = (m = s);
                        state = 6;
                        break;
                    }
                    if (c == 64) {
                        this.host = i;
                        break;
                    }
                    if (c != 58) break;
                    this.port = s;
                    state = 5;
                    break;
                }
                case 5: {
                    if (c != 47) break;
                    this.path = m = s;
                    if (this.port <= this.authority) {
                        this.port = this.path;
                    }
                    state = 6;
                    break;
                }
                case 6: {
                    if (c == 59) {
                        this.param = s;
                        state = 7;
                        break;
                    }
                    if (c == 63) {
                        this.param = s;
                        this.query = s;
                        state = 8;
                        break;
                    }
                    if (c != 35) break;
                    this.param = s;
                    this.query = s;
                    this.fragment = s;
                    break;
                }
                case 7: {
                    if (c == 63) {
                        this.query = s;
                        state = 8;
                        break;
                    }
                    if (c != 35) break;
                    this.query = s;
                    this.fragment = s;
                    break;
                }
                case 8: {
                    if (c != 35) break;
                    this.fragment = s;
                }
            }
        }
    }

    private boolean isLetterOrDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public String getScheme() {
        if (this.scheme == this.authority) {
            return null;
        }
        int l = this.authority - this.scheme;
        if (l == 5 && this.raw[this.scheme] == 104 && this.raw[this.scheme + 1] == 116 && this.raw[this.scheme + 2] == 116 && this.raw[this.scheme + 3] == 112) {
            return "http";
        }
        if (l == 6 && this.raw[this.scheme] == 104 && this.raw[this.scheme + 1] == 116 && this.raw[this.scheme + 2] == 116 && this.raw[this.scheme + 3] == 112 && this.raw[this.scheme + 4] == 115) {
            return "https";
        }
        return new String(this.raw, this.scheme, this.authority - this.scheme - 1);
    }

    public String getAuthority() {
        if (this.authority == this.path) {
            return null;
        }
        return new String(this.raw, this.authority, this.path - this.authority);
    }

    public String getHost() {
        if (this.host == this.port) {
            return null;
        }
        return new String(this.raw, this.host, this.port - this.host);
    }

    public int getPort() {
        if (this.port == this.path) {
            return -1;
        }
        return TypeUtil.parseInt(this.raw, this.port + 1, this.path - this.port - 1, 10);
    }

    public String getPath() {
        if (this.path == this.param) {
            return null;
        }
        return new String(this.raw, this.path, this.param - this.path);
    }

    public String getDecodedPath() {
        if (this.path == this.param) {
            return null;
        }
        return URIUtil.decodePath(this.raw, this.path, this.param - this.path);
    }

    public String getPathAndParam() {
        if (this.path == this.query) {
            return null;
        }
        return new String(this.raw, this.path, this.query - this.path);
    }

    public String getParam() {
        if (this.param == this.query) {
            return null;
        }
        return new String(this.raw, this.param + 1, this.query - this.param - 1);
    }

    public String getQuery() {
        if (this.query == this.fragment) {
            return null;
        }
        return new String(this.raw, this.query + 1, this.fragment - this.query - 1);
    }

    public String getFragment() {
        if (this.fragment == this.end) {
            return null;
        }
        return new String(this.raw, this.fragment + 1, this.end - this.fragment - 1);
    }

    public void decodeQueryTo(MultiMap<String> parameters, String encoding) {
        if (this.query == this.fragment) {
            return;
        }
        UrlEncoded.decodeUtf8To(this.raw, this.query + 1, this.fragment - this.query - 1, parameters);
    }

    public void clear() {
        this.end = 0;
        this.fragment = 0;
        this.query = 0;
        this.param = 0;
        this.path = 0;
        this.port = 0;
        this.host = 0;
        this.authority = 0;
        this.scheme = 0;
        this.raw = empty;
        this.rawString = "";
    }

    public String toString() {
        if (this.rawString == null) {
            this.rawString = new String(this.raw, this.scheme, this.end - this.scheme);
        }
        return this.rawString;
    }
}

