/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.Hashtable;
import java.util.StringTokenizer;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.util.LazyList;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class PathMap<T> {
    private static final String PATH_SEPARATORS = ":,";
    Hashtable<String, Entry<T>> prefixMap = new Hashtable();
    Hashtable<String, Entry<T>> suffixMap = new Hashtable();
    Hashtable<String, Entry<T>> exactMap = new Hashtable();
    LazyList<Entry<T>> defaultSingletonList = null;
    Entry<T> prefixDefault = null;
    Entry<T> defaultEntry = null;

    public synchronized T put(String pathSpec, T object) {
        StringTokenizer tok = new StringTokenizer(pathSpec, PATH_SEPARATORS);
        T old = null;
        while (tok.hasMoreTokens()) {
            String spec = tok.nextToken();
            if (!spec.startsWith("/") && !spec.startsWith("*.")) {
                throw new IllegalArgumentException("PathSpec " + spec + ". must start with '/' or '*.'");
            }
            Entry<T> entry = new Entry<T>(spec, object);
            if (spec.equals("/*")) {
                this.prefixDefault = entry;
                continue;
            }
            if (spec.endsWith("/*")) {
                String mapped = spec.substring(0, spec.length() - 2);
                entry.setMapped(mapped);
                this.prefixMap.put(mapped, entry);
                this.exactMap.put(mapped, entry);
                this.exactMap.put(spec.substring(0, spec.length() - 1), entry);
                continue;
            }
            if (spec.startsWith("*.")) {
                this.suffixMap.put(spec.substring(2), entry);
                continue;
            }
            if (spec.equals("/")) {
                this.defaultEntry = entry;
                this.defaultSingletonList = LazyList.add(this.defaultSingletonList, this.defaultEntry);
                continue;
            }
            entry.setMapped(spec);
            this.exactMap.put(spec, entry);
        }
        return old;
    }

    public T match(String path) {
        Entry<T> entry = this.getMatch(path);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Entry<T> getMatch(String path) {
        Entry<T> entry = null;
        if (path == null) {
            return null;
        }
        int l = path.length();
        entry = this.exactMap.get(path);
        if (entry != null) {
            return entry;
        }
        int i = l;
        while ((i = path.lastIndexOf(47, i - 1)) >= 0) {
            entry = this.prefixMap.get(new String(path.getBytes(), 0, i));
            if (entry == null) continue;
            return entry;
        }
        if (this.prefixDefault != null) {
            return this.prefixDefault;
        }
        i = 0;
        while ((i = path.indexOf(46, i + 1)) > 0) {
            entry = this.suffixMap.get(new String(path.getBytes(), i + 1, l - i - 1));
            if (entry == null) continue;
            return entry;
        }
        return this.defaultEntry;
    }

    public LazyList<Entry<T>> getLazyMatches(String path) {
        LazyList<Entry<T>> entries = null;
        if (path == null) {
            return null;
        }
        int pathLength = path.length();
        Entry<T> entry = this.exactMap.get(new String(path.getBytes(), 0, pathLength));
        if (entry != null) {
            entries = LazyList.add(entries, entry);
        }
        int i = pathLength - 1;
        while ((i = path.lastIndexOf(47, i - 1)) >= 0) {
            entry = this.prefixMap.get(new String(path.getBytes(), 0, i));
            if (entry == null) continue;
            entries = LazyList.add(entries, entry);
        }
        if (this.prefixDefault != null) {
            entries = LazyList.add(entries, this.prefixDefault);
        }
        i = 0;
        while ((i = path.indexOf(46, i + 1)) > 0) {
            entry = this.suffixMap.get(new String(path.getBytes(), i + 1, pathLength - i - 1));
            if (entry == null) continue;
            entries = LazyList.add(entries, entry);
        }
        if (this.defaultEntry != null) {
            if (entries == null) {
                return this.defaultSingletonList;
            }
            entries = LazyList.add(entries, this.defaultEntry);
        }
        return entries;
    }

    public synchronized T remove(String pathSpec) {
        if (pathSpec != null) {
            String spec = pathSpec;
            if (spec.equals("/*")) {
                this.prefixDefault = null;
            } else if (spec.endsWith("/*")) {
                this.prefixMap.remove(spec.substring(0, spec.length() - 2));
                this.exactMap.remove(spec.substring(0, spec.length() - 1));
                this.exactMap.remove(spec.substring(0, spec.length() - 2));
            } else if (spec.startsWith("*.")) {
                this.suffixMap.remove(spec.substring(2));
            } else if (spec.equals("/")) {
                this.defaultEntry = null;
                this.defaultSingletonList = null;
            } else {
                this.exactMap.remove(spec);
            }
        }
        return null;
    }

    public void clear() {
        this.exactMap = new Hashtable();
        this.prefixMap = new Hashtable();
        this.suffixMap = new Hashtable();
        this.prefixDefault = null;
        this.defaultEntry = null;
        this.defaultSingletonList = null;
    }

    public static boolean match(String pathSpec, String path) throws IllegalArgumentException {
        if (pathSpec.indexOf("*") != -1) {
            char c = pathSpec.charAt(0);
            if (c == '/') {
                if (PathMap.isPathWildcardMatch(pathSpec, path)) {
                    return true;
                }
            } else if (c == '*') {
                return PathMap.regionMatches(path, path.length() - pathSpec.length() + 1, pathSpec, 1, pathSpec.length() - 1);
            }
            return false;
        }
        return pathSpec.compareTo(path) == 0;
    }

    private static boolean isPathWildcardMatch(String pathSpec, String path) {
        int cpl = pathSpec.length() - 2;
        return pathSpec.endsWith("/*") && PathMap.regionMatches(path, 0, pathSpec, 0, cpl) && (path.length() == cpl || '/' == path.charAt(cpl));
    }

    private static boolean regionMatches(String str1, int offset1, String str2, int offset2, int length) {
        if (offset1 < 0 || offset2 < 0 || offset1 + length > str1.length() || offset2 + length > str2.length()) {
            return false;
        }
        String substr1 = str1.substring(offset1, offset1 + length);
        String substr2 = str2.substring(offset2, offset2 + length);
        return substr1.equals(substr2);
    }

    public static String pathMatch(String pathSpec, String path) {
        char c = pathSpec.charAt(0);
        if (c == '/') {
            if (pathSpec.length() == 1) {
                return path;
            }
            if (pathSpec.equals(path)) {
                return path;
            }
            if (PathMap.isPathWildcardMatch(pathSpec, path)) {
                return path.substring(0, pathSpec.length() - 2);
            }
        } else if (c == '*' && PathMap.regionMatches(path, path.length() - (pathSpec.length() - 1), pathSpec, 1, pathSpec.length() - 1)) {
            return path;
        }
        return null;
    }

    public static String pathInfo(String pathSpec, String path) {
        char c = pathSpec.charAt(0);
        if (c == '/') {
            if (pathSpec.length() == 1) {
                return null;
            }
            if (pathSpec.equals(path)) {
                return null;
            }
            if (PathMap.isPathWildcardMatch(pathSpec, path)) {
                if (path.length() == pathSpec.length() - 2) {
                    return null;
                }
                return path.substring(pathSpec.length() - 2);
            }
        }
        return null;
    }

    public static String relativePath(String base, String pathSpec, String path) {
        String info = PathMap.pathInfo(pathSpec, path);
        if (info == null) {
            info = path;
        }
        if (info.startsWith("./")) {
            info = info.substring(2);
        }
        path = base.endsWith("/") ? (info.startsWith("/") ? base + info.substring(1) : base + info) : (info.startsWith("/") ? base + info : base + "/" + info);
        return path;
    }

    public static class Entry<E> {
        private String key;
        private E value;
        private String mapped;
        private transient String string;

        Entry(String key, E value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public E getValue() {
            return this.value;
        }

        public String toString() {
            if (this.string == null) {
                this.string = this.key + "=" + this.value;
            }
            return this.string;
        }

        public String getMapped() {
            return this.mapped;
        }

        void setMapped(String mapped) {
            this.mapped = mapped;
        }
    }
}

