/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class DateCache {
    private static long hitWindow = 3600L;
    private static long MaxMisses = 10L;
    private String formatString;
    private String tzFormatString;
    private String secFormatString;
    private String secFormatString0;
    private String secFormatString1;
    private boolean millis = false;
    private long misses = 0L;
    private long lastMinutes = -1L;
    private long lastSeconds = -1L;
    private String lastResult = null;

    public DateCache() {
        this("EEE MMM dd HH:mm:ss zzz yyyy");
    }

    public DateCache(String format) {
        this.formatString = format;
        this.setTimeZone(TimeZone.getDefault());
    }

    public DateCache(String format, Locale l) {
        this.formatString = format;
        this.setTimeZone(TimeZone.getDefault());
    }

    public void setTimeZone(TimeZone tz) {
        this.setTzFormatString(tz);
        this.lastSeconds = -1L;
        this.lastMinutes = -1L;
    }

    public void setTimeZoneID(String timeZoneId) {
        this.setTimeZone(TimeZone.getTimeZone(timeZoneId));
    }

    private void setTzFormatString(TimeZone tz) {
        int zIndex = this.formatString.indexOf("ZZZ");
        if (zIndex >= 0) {
            String ss1 = this.formatString.substring(0, zIndex);
            String ss2 = this.formatString.substring(zIndex + 3);
            int tzOffset = tz.getRawOffset();
            StringBuffer sb = new StringBuffer(this.formatString.length() + 10);
            sb.append(ss1);
            sb.append("'");
            if (tzOffset >= 0) {
                sb.append('+');
            } else {
                tzOffset = -tzOffset;
                sb.append('-');
            }
            int raw = tzOffset / 60000;
            int hr = raw / 60;
            int min = raw % 60;
            if (hr < 10) {
                sb.append('0');
            }
            sb.append(hr);
            if (min < 10) {
                sb.append('0');
            }
            sb.append(min);
            sb.append('\'');
            sb.append(ss2);
            this.tzFormatString = sb.toString();
        } else {
            this.tzFormatString = this.formatString;
        }
        this.setMinFormatString();
    }

    private void setMinFormatString() {
        int i = this.tzFormatString.indexOf("ss.SSS");
        if (i >= 0) {
            this.millis = true;
        } else {
            i = this.tzFormatString.indexOf("ss");
        }
    }

    public synchronized String format(Date inDate) {
        return this.format(inDate.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String format(long inDate) {
        StringBuffer sb;
        long seconds = inDate / 1000L;
        if (seconds < this.lastSeconds || this.lastSeconds > 0L && seconds > this.lastSeconds + hitWindow) {
            ++this.misses;
            if (this.misses < MaxMisses) {
                Date d = new Date(inDate);
                return d.toString();
            }
        } else if (this.misses > 0L) {
            --this.misses;
        }
        if (this.lastSeconds == seconds && !this.millis) {
            return this.lastResult;
        }
        Date d = new Date(inDate);
        long minutes = seconds / 60L;
        if (this.lastMinutes != minutes) {
            int l;
            int i;
            this.lastMinutes = minutes;
            this.secFormatString = d.toString();
            if (this.millis) {
                i = this.secFormatString.indexOf("ss.SSS");
                l = 6;
            } else {
                i = this.secFormatString.indexOf("ss");
                l = 2;
            }
            this.secFormatString0 = this.secFormatString.substring(0, i);
            this.secFormatString1 = this.secFormatString.substring(i + l);
        }
        this.lastSeconds = seconds;
        StringBuffer stringBuffer = sb = new StringBuffer(this.secFormatString.length());
        synchronized (stringBuffer) {
            sb.append(this.secFormatString0);
            int s = (int)(seconds % 60L);
            if (s < 10) {
                sb.append('0');
            }
            sb.append(s);
            if (this.millis) {
                long millis = inDate % 1000L;
                if (millis < 10L) {
                    sb.append(".00");
                } else if (millis < 100L) {
                    sb.append(".0");
                } else {
                    sb.append('.');
                }
                sb.append(millis);
            }
            sb.append(this.secFormatString1);
            this.lastResult = sb.toString();
        }
        return this.lastResult;
    }

    public void format(long inDate, StringBuffer buffer) {
        buffer.append(this.format(inDate));
    }

    public String getFormatString() {
        return this.formatString;
    }

    public String now() {
        return this.format(System.currentTimeMillis());
    }
}

