/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class SingletonList<T> {
    T o;

    private SingletonList(T o) {
        this.o = o;
    }

    public static <T> SingletonList<T> newSingletonList(T o) {
        return new SingletonList<T>(o);
    }

    public Object get(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException("index " + i);
        }
        return this.o;
    }

    public int size() {
        return 1;
    }

    public Iterator<T> iterator() {
        return new SIterator();
    }

    private class SIterator<E>
    implements Iterator<E> {
        int i;

        SIterator() {
            this.i = 0;
        }

        SIterator(int i) {
            if (i < 0 || i > 1) {
                throw new IndexOutOfBoundsException("index " + i);
            }
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.i == 0;
        }

        public boolean hasPrevious() {
            return this.i == 1;
        }

        @Override
        public E next() {
            if (this.i != 0) {
                throw new NoSuchElementException();
            }
            ++this.i;
            return (E)SingletonList.this.o;
        }

        public E previous() {
            if (this.i != 1) {
                throw new NoSuchElementException();
            }
            --this.i;
            return (E)SingletonList.this.o;
        }
    }
}

