/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.CPInfo;
import com.sun.javacard.components.caputils.Util;
import java.io.ByteArrayOutputStream;

public class CPUtf8Info
extends CPInfo {
    public static final int tag = 1;
    short length;
    byte[] value;

    public CPUtf8Info() {
    }

    public CPUtf8Info(byte[] valueArray, int offset, short valueLength) {
        this.length = valueLength;
        this.value = new byte[valueLength];
        System.arraycopy(valueArray, offset, this.value, 0, valueLength);
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof CPUtf8Info)) {
            return false;
        }
        return this.length == ((CPUtf8Info)otherObj).length && Util.compareByteArrays(this.value, ((CPUtf8Info)otherObj).value);
    }

    @Override
    void write(ByteArrayOutputStream bos) {
        bos.write(1);
        byte[] lengthBytes = Util.getShortBytes(this.length);
        bos.write(lengthBytes, 0, 2);
        bos.write(this.value, 0, this.length);
    }

    @Override
    void print() {
        System.out.println("\tCONSTANT_Utf8_info");
        byte[] lengthBytes = Util.getShortBytes(this.length);
        Util.printArray("\t\tUtf8 Length (" + this.length + "): ", lengthBytes, 2);
        String str = new String(this.value);
        Util.printArray("\t\tUtf8 bytes (" + str + "): ", this.value, this.length);
    }
}

