/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.ParseException;
import com.sun.javacard.jcasm.Parser;
import com.sun.javacard.jcasm.cap.CapFile;
import com.sun.javacard.jcasm.cap.CapLinker;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Main {
    public static boolean noBanner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        int i;
        File outputFile = null;
        String inputFile = null;
        Globals.mode = 1;
        for (i = 0; i < argv.length && argv[i].startsWith("-"); ++i) {
            if (argv[i].equals("-debug")) {
                Globals.debug = true;
                try {
                    Globals.debugLevel = Integer.decode(argv[++i]);
                }
                catch (NumberFormatException e) {
                    Main.usage(true);
                }
                continue;
            }
            if (argv[i].equals("-help")) {
                Main.usage(false);
                System.exit(0);
                continue;
            }
            if (argv[i].equals("-nobanner")) {
                noBanner = true;
                continue;
            }
            if (argv[i].equals("-o")) {
                if (++i < argv.length) {
                    outputFile = new File(argv[i]);
                    continue;
                }
                Main.usage(true);
                continue;
            }
            if (argv[i].startsWith("-o")) {
                outputFile = new File(argv[i].substring(2));
                continue;
            }
            if (argv[i].equals("-version")) {
                Main.banner();
                System.exit(0);
                continue;
            }
            if (argv[i].equals("--")) {
                ++i;
                break;
            }
            Object[] args = new Object[]{argv[i]};
            Msg.error("main.1", args);
            Main.usage(true);
        }
        if (i < argv.length) {
            inputFile = argv[i++];
        } else {
            Main.usage(true);
        }
        File iFile = new File(inputFile);
        String cName = null;
        try {
            cName = iFile.getCanonicalPath();
        }
        catch (IOException e) {
            cName = "";
        }
        if (Globals.debug) {
            String dName = null;
            int lastSep = cName.lastIndexOf(File.pathSeparatorChar);
            dName = lastSep == -1 ? "debug.cap" : cName.substring(0, lastSep) + "debug.cap";
        }
        if (!noBanner) {
            Main.banner();
        }
        Parser parser = null;
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(inputFile));
            parser = new Parser(bis);
            Parser.inputSpec = inputFile;
        }
        catch (FileNotFoundException e) {
            Object[] arguments = new Object[]{inputFile};
            Msg.error("main.16", arguments);
            System.exit(1);
        }
        JCPackage pack = null;
        try {
            pack = Parser.PackageDeclaration();
        }
        catch (ParseException e) {
            System.err.println(e);
            ++Globals.errors;
        }
        if (Globals.errors == 0) {
            CapFile cap = new CapFile(pack);
            if (Globals.errors == 0) {
                CapLinker.link(pack);
                if (Globals.errors == 0) {
                    try {
                        if (outputFile == null) {
                            outputFile = new File("a.jar");
                        }
                        ConversionProfile cp = new ConversionProfile();
                        cp.classes = null;
                        cap.gen(outputFile, cp, null);
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        ++Globals.errors;
                    }
                }
            }
        }
        if (Globals.errors != 0) {
            try {
                outputFile.delete();
            }
            finally {
                System.exit(Globals.errors);
            }
        }
    }

    private static void usage(boolean isError) {
        Msg.info("main.10", null);
        Msg.info("main.11", null);
        System.err.println("");
        for (int i = 12; i < 16; ++i) {
            Msg.info("main." + i, null);
        }
        if (isError) {
            System.exit(1);
        }
    }

    private static void banner() {
        Msg.info(ToolsVersion.getToolName(8) + ToolsVersion.getVersion(8));
        Msg.info(ToolsVersion.getCopyrightBanner());
    }
}

