/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcbytecodeprofiler.cryptoanalyzer.TypeClass;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionTableEntry {
    protected JCMethod parent;
    protected String startBlock;
    protected int startOffset;
    protected String endBlock;
    protected int endOffset;
    protected String catchBlock;
    public int catchOffset;
    protected Operand index;
    public TypeClass catchType = new TypeClass(0);
    protected boolean isOuterMost;

    ExceptionTableEntry(JCMethod parent, String startBlock, Operand startOffset, String endBlock, Operand endOffset, String catchBlock, Operand catchOffset, Operand index) {
        this.parent = parent;
        this.startBlock = startBlock.toLowerCase();
        if (startOffset != null) {
            this.startOffset = startOffset.getValue();
        }
        this.endBlock = endBlock.toLowerCase();
        if (endOffset != null) {
            this.endOffset = endOffset.getValue();
        }
        this.catchBlock = catchBlock.toLowerCase();
        if (catchOffset != null) {
            this.catchOffset = catchOffset.getValue();
        }
        this.index = index;
    }

    public int getStartOffset() {
        return this.startOffset + this.base();
    }

    public int getActiveLength() {
        return this.endOffset - this.startOffset;
    }

    public int getHandlerOffset() {
        return this.catchOffset + this.base();
    }

    public int getCatchIndex() {
        int catchIndex = 0;
        catchIndex = Globals.mode == 1 ? 0 : 65535;
        if (this.index.getType() == 8) {
            if (Globals.mode == 1) {
                catchIndex = this.index.getValue();
            } else {
                Info info = this.index.resolve();
                if (info.isResolved()) {
                    JCClass jCClass = (JCClass)info.resolve();
                } else {
                    catchIndex = this.index.getValue();
                }
            }
        }
        return catchIndex;
    }

    public boolean isOuterMost() {
        return this.isOuterMost;
    }

    public void fixup(Hashtable<String, Integer> symbolTable) {
        assert (symbolTable != null) : "symbolTable != null";
        if (this.startBlock != null) {
            this.startOffset = this.lookup(symbolTable, this.startBlock);
        }
        if (this.endBlock != null) {
            this.endOffset = this.lookup(symbolTable, this.endBlock);
        }
        if (this.catchBlock != null) {
            this.catchOffset = this.lookup(symbolTable, this.catchBlock);
        }
        if (this.endOffset < this.startOffset) {
            Object[] arguments = new Object[]{this.parent.getName()};
            Msg.error("exceptiontable.1", arguments);
        }
    }

    private int lookup(Hashtable<String, Integer> symbolTable, String symbol) {
        Integer datum = symbolTable.get(symbol);
        if (datum == null) {
            Object[] arguments = new Object[]{symbol, this.parent.getName()};
            Msg.error("exceptiontable.0", arguments);
            return 0;
        }
        return datum;
    }

    public static int size() {
        return 8;
    }

    public byte[] toByteArray() {
        byte[] array = new byte[ExceptionTableEntry.size()];
        int length = this.endOffset - this.startOffset;
        array[0] = (byte)(this.startOffset + this.base() >> 8);
        array[1] = (byte)(this.startOffset + this.base() & 0xFF);
        array[2] = (byte)(length >> 8 | (this.isOuterMost ? 128 : 0));
        array[3] = (byte)(length & 0xFF);
        array[4] = (byte)(this.catchOffset + this.base() >> 8);
        array[5] = (byte)(this.catchOffset + this.base() & 0xFF);
        int cpIndex = this.index.getValue();
        if (Globals.mode == 1) {
            array[6] = (byte)(cpIndex >> 8 & 0xFF);
            array[7] = (byte)(cpIndex & 0xFF);
        } else if (this.index.getType() == 8) {
            Info info = this.index.resolve();
            if (info.isResolved()) {
                JCClass jclass = (JCClass)info.resolve();
                array[6] = (byte)(jclass.getRelocAddr() >> 8);
                array[7] = (byte)(jclass.getRelocAddr() & 0xFF);
            } else {
                array[6] = (byte)(cpIndex >> 8 & 0xFF);
                array[7] = (byte)(cpIndex & 0xFF);
            }
        }
        return array;
    }

    private int base() {
        int base = this.parent.getMethodHeader().length;
        if (this.parent.isRelocated()) {
            base += this.parent.getRelocAddr();
        }
        return base;
    }

    public boolean isInstructionInTryCatchBlock() {
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int length = this.endOffset - this.startOffset;
        int n = this.isOuterMost ? 32768 : 0;
        sb.append(Msg.toHexString((short)(this.startOffset + this.base())) + " ");
        sb.append(Msg.toHexString((short)(length |= n)) + " ");
        sb.append(Msg.toHexString((short)(this.catchOffset + this.base())) + " ");
        if (this.index.getType() == 8) {
            Info info = this.index.resolve();
            if (info.isResolved()) {
                JCClass jclass = (JCClass)info.resolve();
                if (jclass.isRelocated()) {
                    sb.append(Msg.toHexString((short)jclass.getRelocAddr()));
                } else {
                    sb.append(Msg.toHexString((short)0));
                }
            } else {
                sb.append(Msg.toHexString((short)this.index.getValue()));
            }
        } else {
            sb.append(Msg.toHexString((short)0));
        }
        sb.append(";");
        return sb.toString();
    }
}

