/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.aram;

import fr.bmartel.aram.AramUtils;
import fr.bmartel.aram.RuleEntry;
import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.security.RandomData;
import org.globalplatform.Application;

public class AccessRuleMaster
extends Applet
implements Application {
    public static final byte INS_STORE_DATA = -30;
    public static final byte INS_GET_DATA = -54;
    public static final short SIZE_AID = 16;
    public static final short SIZE_HASH = 32;
    public static final short SIZE_RULE = 162;
    public static final byte COMMAND_STORE_REF_AR_DO = -16;
    public static final byte COMMAND_DELETE = -15;
    public static final byte COMMAND_UPDATE_REFRESH_TAG = -14;
    public static final byte COMMAND_LOCK_ARAM = -95;
    public static final byte COMMAND_UNLOCK_ARAM = -94;
    public static final short APDU_CHUNK = 255;
    private byte[] refreshTag = new byte[8];
    private short dataOffset;
    private short nextLength;
    private short currentNext;
    private boolean aram_lock_status;

    private AccessRuleMaster() {
    }

    public static void install(byte[] bArray, short bOffset, byte bLength) {
        new AccessRuleMaster().register();
    }

    public void process(APDU apdu) {
        if (this.selectingApplet()) {
            return;
        }
        byte[] buffer = apdu.getBuffer();
        if ((byte)(buffer[0] & 0xFFFFFFFC) != -128) {
            ISOException.throwIt((short)28160);
        }
        switch (buffer[1]) {
            case -30: {
                if (apdu.setIncomingAndReceive() != (short)(buffer[4] & 0xFF)) {
                    ISOException.throwIt((short)26368);
                }
                if (this.aram_lock_status) {
                    ISOException.throwIt((short)27010);
                }
                this.processCmdStoreData(APDU.getCurrentAPDUBuffer());
                break;
            }
            case -54: {
                this.processCmdGetData();
                break;
            }
            default: {
                ISOException.throwIt((short)27904);
            }
        }
    }

    private void processCmdGetData() {
        byte[] buf = APDU.getCurrentAPDUBuffer();
        if (buf[2] == -1 && buf[3] == 64) {
            this.processGetAll();
        } else if (buf[2] == -1 && buf[3] == 80) {
            this.processGetSpecific();
        } else if (buf[2] == -33 && buf[3] == 32) {
            this.processGetRefreshTag();
        } else if (buf[2] == -1 && buf[3] == 96) {
            this.processGetNext();
        } else {
            ISOException.throwIt((short)27270);
        }
    }

    private void processGetAll() {
        RuleEntry entry;
        byte[] buf = APDU.getCurrentAPDUBuffer();
        buf[0] = -1;
        buf[1] = 64;
        short offset = 2;
        if (entry == null) {
            short s = offset;
            offset = (short)(offset + 1);
            buf[s] = 0;
            APDU.getCurrentAPDU().setOutgoingAndSend((short)0, (short)3);
        } else {
            this.dataOffset = 0;
            for (entry = RuleEntry.getFirst(); entry != null; entry = entry.getNext()) {
                short len = AramUtils.buildRefArDo(this.dataOffset, (short)(this.dataOffset + 255), buf, (short)(offset + 1), entry);
                offset = (short)(offset + len);
            }
            offset = (short)(offset + 1);
            short length = (short)(offset - 3);
            this.currentNext = 1;
            this.nextLength = length;
            if (length < 128) {
                buf[2] = (byte)length;
                this.dataOffset = (short)-3;
                APDU.getCurrentAPDU().setOutgoingAndSend((short)0, offset);
            } else if (length < 255) {
                Util.arrayCopy((byte[])buf, (short)3, (byte[])buf, (short)4, (short)((short)(buf.length - 4)));
                buf[2] = -127;
                buf[3] = (byte)length;
                this.dataOffset = (short)-4;
                APDU.getCurrentAPDU().setOutgoingAndSend((short)0, (short)(offset + 1));
            } else if (length < Short.MAX_VALUE) {
                Util.arrayCopy((byte[])buf, (short)2, (byte[])buf, (short)4, (short)((short)(buf.length - 4)));
                buf[2] = -126;
                buf[3] = (byte)(length >> 8 & 0xFF);
                buf[4] = (byte)(length & 0xFF);
                this.dataOffset = (short)-5;
                APDU.getCurrentAPDU().setOutgoingAndSend((short)0, (short)255);
            } else {
                ISOException.throwIt((short)27012);
            }
        }
    }

    private void processGetSpecific() {
        byte[] buf = APDU.getCurrentAPDUBuffer();
        APDU apdu = APDU.getCurrentAPDU();
        if (apdu.setIncomingAndReceive() != (short)(buf[4] & 0xFF)) {
            ISOException.throwIt((short)26368);
        }
        int ofs = 5;
        this.checkTLV(buf, (short)(ofs + 1), (byte)-31, (short)52);
        short ofsAidRefDo = (short)(ofs + 3);
        short ofsHashRefDo = this.checkTLV(buf, (short)(ofs + 3), (byte)79, (short)16);
        this.checkTLV(buf, ofsHashRefDo, (byte)-63, (short)32);
        RuleEntry re = RuleEntry.searchAidHash(buf, (short)(ofsAidRefDo + 2), buf[(short)(ofsAidRefDo + 1)], (short)(ofsHashRefDo + 2), buf[(short)(ofsHashRefDo + 1)]);
        if (re == null) {
            ISOException.throwIt((short)27272);
        }
        buf[0] = -1;
        buf[1] = 80;
        short len = AramUtils.buildRefArDo((short)0, (short)255, buf, (short)3, re);
        buf[2] = (byte)len;
        APDU.getCurrentAPDU().setOutgoingAndSend((short)0, (short)(len + 3));
    }

    private void processGetRefreshTag() {
        byte[] buf = APDU.getCurrentAPDUBuffer();
        buf[0] = -33;
        buf[1] = 32;
        buf[2] = 8;
        Util.arrayCopy((byte[])this.refreshTag, (short)0, (byte[])buf, (short)3, (short)8);
        APDU.getCurrentAPDU().setOutgoingAndSend((short)0, (short)11);
    }

    private void processGetNext() {
        short next = (short)(this.nextLength / 255);
        if (this.nextLength % 255 != 0) {
            next = (short)(next + 1);
        }
        if (this.currentNext < next) {
            byte[] buf = APDU.getCurrentAPDUBuffer();
            RuleEntry entry = RuleEntry.getFirst();
            short offset = 0;
            this.dataOffset = (short)(this.dataOffset + 255);
            short currentLength = 0;
            short diff = (short)(this.nextLength - this.currentNext * 255);
            if (diff > 255) {
                currentLength = 255;
            } else {
                short header = (short)(255 - (short)(this.dataOffset % 255));
                currentLength = (short)(diff + header);
            }
            while (entry != null) {
                short len = AramUtils.buildRefArDo(this.dataOffset, (short)(this.dataOffset + 255), buf, offset, entry);
                offset = (short)(offset + len);
                entry = entry.getNext();
            }
            this.currentNext = (short)(this.currentNext + 1);
            APDU.getCurrentAPDU().setOutgoingAndSend((short)0, currentLength);
        } else {
            ISOException.throwIt((short)27272);
        }
    }

    private void processCmdStoreData(byte[] buf) {
        if (buf[2] == -112 && buf[3] == 0) {
            int ofs = 5;
            if (buf[ofs] == -16) {
                this.storeArDo(buf);
            } else if (buf[ofs] == -15) {
                this.deleteArDo(buf);
            } else if (buf[ofs] == -14) {
                this.updateRefreshTag();
            } else {
                if (buf[ofs] == -95) {
                    this.aram_lock_status = true;
                    return;
                }
                if (buf[ofs] == -94) {
                    this.aram_lock_status = false;
                    return;
                }
                ISOException.throwIt((short)27012);
            }
        } else {
            ISOException.throwIt((short)27270);
        }
    }

    private void storeArDo(byte[] buf) {
        short ofs = 5;
        this.checkTLV(buf, ofs, (byte)-16, (short)218);
        this.checkTLV(buf, (short)(ofs + 2), (byte)-30, (short)216);
        this.checkTLV(buf, (short)(ofs + 4), (byte)-31, (short)52);
        short ofsAidRefDo = (short)(ofs + 6);
        short ofsHashRefDo = this.checkTLV(buf, (short)(ofs + 6), (byte)79, (short)16);
        short ofsArDo = this.checkTLV(buf, ofsHashRefDo, (byte)-63, (short)32);
        this.checkTLV(buf, ofsArDo, (byte)-29, (short)162);
        JCSystem.beginTransaction();
        RuleEntry pe = RuleEntry.getInstance();
        pe.setAid(buf, (short)(ofsAidRefDo + 2), buf[(short)(ofsAidRefDo + 1)]);
        pe.setHash(buf, (short)(ofsHashRefDo + 2), buf[(short)(ofsHashRefDo + 1)]);
        pe.setRule(buf, (short)(ofsArDo + 2), buf[(short)(ofsArDo + 1)]);
        JCSystem.commitTransaction();
    }

    private void deleteArDo(byte[] buf) {
        short ofs = 5;
        this.checkTLV(buf, ofs, (byte)-15, (short)216);
        if (buf[(short)(ofs + 1)] == 0) {
            RuleEntry.deleteAll();
        } else if (buf[(short)(ofs + 2)] == 79) {
            this.checkTLV(buf, (short)(ofs + 2), (byte)79, (short)16);
            short ofsAidRefDo = (short)(ofs + 2);
            RuleEntry re = RuleEntry.searchAid(buf, (short)(ofsAidRefDo + 2), buf[(short)(ofsAidRefDo + 1)]);
            if (re == null) {
                ISOException.throwIt((short)27272);
            }
            RuleEntry.deleteAid(buf, (short)(ofsAidRefDo + 2), buf[(short)(ofsAidRefDo + 1)]);
        } else if (buf[(short)(ofs + 2)] == -31) {
            this.checkTLV(buf, (short)(ofs + 2), (byte)-31, (short)52);
            short ofsAidRefDo = (short)(ofs + 4);
            short ofsHashRefDo = this.checkTLV(buf, (short)(ofs + 4), (byte)79, (short)16);
            this.checkTLV(buf, ofsHashRefDo, (byte)-63, (short)32);
            RuleEntry re = RuleEntry.searchAidHash(buf, (short)(ofsAidRefDo + 2), buf[(short)(ofsAidRefDo + 1)], (short)(ofsHashRefDo + 2), buf[(short)(ofsHashRefDo + 1)]);
            if (re == null) {
                ISOException.throwIt((short)27272);
            }
            RuleEntry.deleteAidHash(buf, (short)(ofsAidRefDo + 2), buf[(short)(ofsAidRefDo + 1)], (short)(ofsHashRefDo + 2), buf[(short)(ofsHashRefDo + 1)]);
        } else if (buf[(short)(ofs + 2)] == -30) {
            this.checkTLV(buf, (short)(ofs + 2), (byte)-30, (short)216);
            this.checkTLV(buf, (short)(ofs + 4), (byte)-31, (short)52);
            short ofsAidRefDo = (short)(ofs + 6);
            short ofsHashRefDo = this.checkTLV(buf, (short)(ofs + 6), (byte)79, (short)16);
            short ofsArDo = this.checkTLV(buf, ofsHashRefDo, (byte)-63, (short)32);
            this.checkTLV(buf, ofsArDo, (byte)-29, (short)162);
            if (buf[(short)(ofsArDo + 1)] > 2) {
                RuleEntry re = RuleEntry.searchAidHashRule(buf, (short)(ofsAidRefDo + 2), buf[(short)(ofsAidRefDo + 1)], (short)(ofsHashRefDo + 2), buf[(short)(ofsHashRefDo + 1)], (short)(ofsArDo + 2), buf[(short)(ofsArDo + 1)]);
                if (re == null) {
                    ISOException.throwIt((short)27272);
                }
                RuleEntry.deleteAidHashRule(buf, (short)(ofsAidRefDo + 2), buf[(short)(ofsAidRefDo + 1)], (short)(ofsHashRefDo + 2), buf[(short)(ofsHashRefDo + 1)], (short)(ofsArDo + 2), buf[(short)(ofsArDo + 1)]);
            } else {
                RuleEntry re = RuleEntry.searchAidHash(buf, (short)(ofsAidRefDo + 2), buf[(short)(ofsAidRefDo + 1)], (short)(ofsHashRefDo + 2), buf[(short)(ofsHashRefDo + 1)]);
                if (re == null) {
                    ISOException.throwIt((short)27272);
                }
                RuleEntry.deleteAidHash(buf, (short)(ofsAidRefDo + 2), buf[(short)(ofsAidRefDo + 1)], (short)(ofsHashRefDo + 2), buf[(short)(ofsHashRefDo + 1)]);
            }
        }
    }

    private void updateRefreshTag() {
        RandomData rnd = RandomData.getInstance((byte)2);
        rnd.generateData(this.refreshTag, (short)0, (short)8);
    }

    short checkTLV(byte[] buffer, short ofs, byte tag, short maxLen) {
        short s = ofs;
        ofs = (short)(ofs + 1);
        if (buffer[s] != tag) {
            ISOException.throwIt((short)27012);
        }
        short s2 = ofs;
        ofs = (short)(ofs + 1);
        short len = buffer[s2];
        if (len > maxLen) {
            ISOException.throwIt((short)27012);
        }
        return (short)(ofs + len);
    }

    public void processData(byte[] data, short ofs, short len) {
        this.processCmdStoreData(data);
    }
}

