/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.AttributeInfo;
import com.sun.javacard.components.caputils.Util;
import java.io.ByteArrayOutputStream;
import java.util.Objects;
import java.util.Vector;

public class ClassMemberInfo {
    short accessFlags;
    short nameIndex;
    short descriptorIndex;
    short attributeCount = 0;
    Vector<AttributeInfo> attributes = new Vector();

    public void setAccessFlags(short flags) {
        this.accessFlags = flags;
    }

    public void setNameIndex(short index) {
        this.nameIndex = index;
    }

    public void setDescriptorIndex(short index) {
        this.descriptorIndex = index;
    }

    public void addAttribute(AttributeInfo attrInfo) {
        this.attributes.add(attrInfo);
        this.attributeCount = (short)(this.attributeCount + 1);
    }

    public boolean equals(Object cmInfo) {
        if (!(cmInfo instanceof ClassMemberInfo)) {
            return false;
        }
        if (this.attributeCount != ((ClassMemberInfo)cmInfo).attributeCount) {
            return false;
        }
        int numAttributes = this.attributes.size();
        for (int i = 0; i < numAttributes; ++i) {
            AttributeInfo attr2;
            AttributeInfo attr1 = this.attributes.elementAt(i);
            if (attr1.equals(attr2 = ((ClassMemberInfo)cmInfo).attributes.elementAt(i))) continue;
            return false;
        }
        return this.accessFlags == ((ClassMemberInfo)cmInfo).accessFlags && this.descriptorIndex == ((ClassMemberInfo)cmInfo).descriptorIndex && this.nameIndex == ((ClassMemberInfo)cmInfo).nameIndex;
    }

    public int hashCode() {
        int hash = 3;
        hash = 13 * hash + this.accessFlags;
        hash = 13 * hash + this.nameIndex;
        hash = 13 * hash + this.descriptorIndex;
        hash = 13 * hash + this.attributeCount;
        hash = 13 * hash + Objects.hashCode(this.attributes);
        return hash;
    }

    void write(ByteArrayOutputStream bos) {
        byte[] accessFlagsBytes = Util.getShortBytes(this.accessFlags);
        bos.write(accessFlagsBytes, 0, 2);
        byte[] nameIndexBytes = Util.getShortBytes(this.nameIndex);
        bos.write(nameIndexBytes, 0, 2);
        byte[] descIndexBytes = Util.getShortBytes(this.descriptorIndex);
        bos.write(descIndexBytes, 0, 2);
        byte[] attrCountBytes = Util.getShortBytes(this.attributeCount);
        bos.write(attrCountBytes, 0, 2);
        for (int j = 0; j < this.attributeCount; ++j) {
            this.attributes.elementAt(j).write(bos);
        }
    }

    void print(int i, String str) {
        System.out.println(str + " number: " + (i + 1));
        byte[] accessFlagsBytes = Util.getShortBytes(this.accessFlags);
        Util.printArray("\tAccess Flags: ", accessFlagsBytes, 2);
        byte[] nameIndexBytes = Util.getShortBytes(this.nameIndex);
        Util.printArray("\tName index: ", nameIndexBytes, 2);
        byte[] descIndexBytes = Util.getShortBytes(this.descriptorIndex);
        Util.printArray("\tDescriptor index: ", descIndexBytes, 2);
        byte[] attrCountBytes = Util.getShortBytes(this.attributeCount);
        Util.printArray("\tAttribute Count (" + this.attributeCount + "): ", attrCountBytes, 2);
        for (int j = 0; j < this.attributeCount; ++j) {
            this.attributes.elementAt(j).print("\t");
        }
    }
}

