/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.CadClientInterface;
import com.sun.javacard.apduio.CadPCSCClient;
import com.sun.javacard.apduio.CadT0Client;
import com.sun.javacard.apduio.CadT1Client;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public abstract class CadDevice {
    protected static ResourceBundle _messages = PropertyResourceBundle.getBundle("com/sun/javacard/apduio/MessagesBundle");
    protected InputStream in;
    protected OutputStream out;
    protected boolean debug = false;
    public static final byte PROTOCOL_T0 = 0;
    public static final byte PROTOCOL_T1 = 1;
    public static final byte PROTOCOL_TCL = 91;
    public static final byte PROTOCOL_PCSC = -85;
    protected byte deviceProtocol;

    protected CadDevice(byte by, InputStream inputStream, OutputStream outputStream) {
        this.in = inputStream;
        this.out = outputStream;
        int n = Integer.getInteger("apduIODebug", 0);
        if ((n & 1) == 1) {
            this.debug = true;
        }
        this.deviceProtocol = by;
    }

    protected CadDevice(byte by) {
        int n = Integer.getInteger("apduIODebug", 0);
        if ((n & 1) == 1) {
            this.debug = true;
        }
        this.deviceProtocol = by;
    }

    public byte getDeviceProtocol() {
        return this.deviceProtocol;
    }

    public static CadClientInterface getCadClientInstance(byte by, InputStream inputStream, OutputStream outputStream) {
        CadDevice cadDevice;
        switch (by) {
            case 0: {
                cadDevice = new CadT0Client(inputStream, outputStream);
                break;
            }
            case 1: {
                cadDevice = new CadT1Client(inputStream, outputStream);
                break;
            }
            case -85: {
                cadDevice = new CadPCSCClient(0);
                break;
            }
            default: {
                return null;
            }
        }
        return cadDevice;
    }

    public static CadClientInterface getPCSCClientInstance(int n) {
        return new CadPCSCClient(n);
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.out.flush();
        this.out.close();
        this.out = null;
    }
}

