/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.ExportedClass;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;

class Classref {
    static int Object;
    static int Throwable;
    static int Shareable;

    Classref() {
    }

    static void check(int ref) {
        if (Classref.isExternal(ref)) {
            Classref.checkExternal(ref);
        } else {
            Classref.checkInternal(ref);
        }
    }

    static int checkAndGetAccessFlags(int ref) {
        if (!Classref.isExternal(ref)) {
            ClassDescriptor cdesc = Classref.checkInternal(ref);
            return cdesc.flags();
        }
        EfClass ec = Classref.checkExternal(ref);
        int flags = 0;
        if ((ec.accessFlag & 1) != 0) {
            flags |= 1;
        }
        if ((ec.accessFlag & 0x10) != 0) {
            flags |= 0x10;
        }
        if ((ec.accessFlag & 0x200) != 0) {
            flags |= 0x40;
        }
        if ((ec.accessFlag & 0x400) != 0) {
            flags |= 0x80;
        }
        return flags;
    }

    static EfClass checkExternal(int ref) {
        int pkgTok = Classref.packageToken(ref);
        int clsTok = Classref.classToken(ref);
        ExportFile ef = Cap.Import.importPackage(pkgTok);
        if (ef == null) {
            throw new VerifierError("Classref.2", ref, pkgTok);
        }
        int i = 0;
        while (i < ef.classes.length) {
            EfClass ec = ef.classes[i];
            if (ec.token == clsTok) {
                return ec;
            }
            ++i;
        }
        throw new VerifierError("Classref.3", ref, clsTok);
    }

    static ClassDescriptor checkInternal(int ref) {
        ClassDescriptor p = Cap.Descriptor.firstClassDescriptor();
        int i = Cap.Descriptor.classCount();
        while (i > 0) {
            if (ref == p.thisClass()) {
                return p;
            }
            --i;
            p.next();
        }
        throw new VerifierError("Classref.1", ref);
    }

    static int classToken(int cr) {
        return cr & 0xFF;
    }

    static EfClass exportclassForExternal(int ref) {
        int pkgTok = Classref.packageToken(ref);
        int clsTok = Classref.classToken(ref);
        ExportFile ef = Cap.Import.exportfileForPackageToken(pkgTok);
        if (ef == null) {
            throw new VerifierError("Classref.4", ref, pkgTok);
        }
        int i = 0;
        while (i < ef.classes.length) {
            EfClass ec = ef.classes[i];
            if (ec.token == clsTok) {
                return ec;
            }
            ++i;
        }
        throw new VerifierError("Classref.5", ref, clsTok);
    }

    static EfClass exportclassForName(String classname) {
        int lastslash = classname.lastIndexOf(47);
        if (lastslash == -1) {
            throw new VerifierError("Classref.6", classname);
        }
        String pkgname = classname.substring(0, lastslash);
        int pkgtok = Cap.Import.tokenForPackage(pkgname);
        ExportFile ef = Cap.Import.exportfileForPackageToken(pkgtok);
        int i = 0;
        while (i < ef.classes.length) {
            EfClass ec = ef.classes[i];
            if (classname.equals(ec.thisName())) {
                return ec;
            }
            ++i;
        }
        return null;
    }

    static boolean extendsInterface(int ref1, int ref2) {
        if (ref1 == ref2) {
            return true;
        }
        if (Classref.isExternal(ref1)) {
            if (!Classref.isExternal(ref2)) {
                return false;
            }
            EfClass ec1 = Classref.exportclassForExternal(ref1);
            EfClass ec2 = Classref.exportclassForExternal(ref2);
            int i = 0;
            while (i < ec1.interfaces.length) {
                if (ec1.interfaceName(i).equals(ec2.thisName())) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        ClassInfo cinfo = Cap.Class.infoOfs(ref1);
        int i = 0;
        while (i < cinfo.interfaceCount()) {
            if (cinfo.superinterface(i) == ref2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static int forExportToken(int token) {
        ExportedClass ecls = Cap.Export.firstExportedClass();
        int t = 0;
        while (t < Cap.Export.classCount()) {
            if (t == token) {
                return ecls.classOffset();
            }
            ecls.next();
            ++t;
        }
        throw new VerifierError("Classref.8", token);
    }

    static boolean implementsInterface(int ref1, int ref2) {
        if (Classref.isExternal(ref1)) {
            if (!Classref.isExternal(ref2)) {
                return false;
            }
            EfClass ec1 = Classref.exportclassForExternal(ref1);
            EfClass ec2 = Classref.exportclassForExternal(ref2);
            int i = 0;
            while (i < ec1.interfaces.length) {
                if (ec1.interfaceName(i).equals(ec2.thisName())) {
                    return true;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < ec1.supers.length) {
                EfClass sup = Classref.exportclassForName(ec1.superName(i2));
                if (sup != null) {
                    int j = 0;
                    while (i2 < sup.interfaces.length) {
                        if (sup.interfaceName(j).equals(ec2.thisName())) {
                            return true;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            return false;
        }
        ClassDescriptor cdescr = Classref.checkInternal(ref1);
        int i = 0;
        while (i < cdescr.interfaceCount()) {
            if (Classref.extendsInterface(cdescr.interfaceRef(i), ref2)) {
                return true;
            }
            ++i;
        }
        if ((cdescr.flags() & 0x40) != 0) {
            return false;
        }
        int superref = Cap.Class.infoOfs(ref1).superclass();
        if (superref == 65535) {
            return false;
        }
        return Classref.implementsInterface(superref, ref2);
    }

    static void initialize() {
        Object = Classref.refForName("java/lang/Object");
        Throwable = Classref.refForName("java/lang/Throwable");
        try {
            Shareable = Classref.refForName("javacard/framework/Shareable");
        }
        catch (VerifierError verifierError) {
            Messages.println("Classref.100");
            ++Messages.numWarning;
            Shareable = -1;
        }
    }

    static boolean isExternal(int cr) {
        return (cr & 0x8000) != 0;
    }

    static boolean isSameOrSuper(int ref1, int ref2) {
        if (ref1 == ref2) {
            return true;
        }
        if (!Classref.isExternal(ref1)) {
            return ref2 == Cap.Class.infoOfs(ref1).superclass();
        }
        if (!Classref.isExternal(ref2)) {
            return false;
        }
        EfClass ec1 = Classref.exportclassForExternal(ref1);
        EfClass ec2 = Classref.exportclassForExternal(ref2);
        int i = 0;
        while (i < ec1.supers.length) {
            if (ec1.superName(i).equals(ec2.thisName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean isSubclass(int ref1, int ref2) {
        while (!Classref.isExternal(ref1)) {
            if (ref1 == ref2) {
                return true;
            }
            ref1 = Cap.Class.infoOfs(ref1).superclass();
        }
        if (ref1 == ref2) {
            return true;
        }
        if (!Classref.isExternal(ref2)) {
            return false;
        }
        EfClass ec1 = Classref.exportclassForExternal(ref1);
        EfClass ec2 = Classref.exportclassForExternal(ref2);
        int i = 0;
        while (i < ec1.supers.length) {
            if (ec1.superName(i).equals(ec2.thisName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static int lub(int ref1, int ref2) {
        EfClass ec2;
        String ec2name;
        while (!Classref.isExternal(ref1) && !Classref.isExternal(ref2)) {
            if (ref1 == ref2) {
                return ref1;
            }
            if (Classref.isSubclass(ref1, ref2)) {
                return ref2;
            }
            if (Classref.isSubclass(ref2, ref1)) {
                return ref1;
            }
            ref1 = Cap.Class.infoOfs(ref1).superclass();
            ref2 = Cap.Class.infoOfs(ref2).superclass();
        }
        while (!Classref.isExternal(ref1)) {
            ref1 = Cap.Class.infoOfs(ref1).superclass();
        }
        while (!Classref.isExternal(ref2)) {
            ref2 = Cap.Class.infoOfs(ref2).superclass();
        }
        if (ref1 == ref2) {
            return ref1;
        }
        EfClass ec1 = Classref.exportclassForExternal(ref1);
        String ec1name = ec1.thisName();
        if (ec1name.equals(ec2name = (ec2 = Classref.exportclassForExternal(ref2)).thisName())) {
            return ref1;
        }
        int i = 0;
        while (i < ec1.supers.length) {
            if (ec1.superName(i).equals(ec2name)) {
                return ref2;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < ec2.supers.length) {
            if (ec2.superName(i2).equals(ec1name)) {
                return ref1;
            }
            ++i2;
        }
        int[] supclasses = new int[ec1.supers.length + ec2.supers.length];
        int numSupclasses = 0;
        int i3 = 0;
        while (i3 < ec1.supers.length) {
            String sup1 = ec1.superName(i3);
            int j = 0;
            while (j < ec2.supers.length) {
                if (sup1.equals(ec2.superName(j))) {
                    supclasses[numSupclasses] = Classref.refForName(sup1);
                    ++numSupclasses;
                    break;
                }
                ++j;
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < numSupclasses) {
            int c = supclasses[i4];
            int j = 0;
            while (j < numSupclasses && Classref.isSubclass(c, supclasses[j])) {
                ++j;
            }
            if (j == numSupclasses) {
                return c;
            }
            ++i4;
        }
        throw new VerifierError("Classref.9", (Object)ec1.thisName(), (Object)ec2.thisName());
    }

    static int numberOfMethods(int ref) {
        if (Classref.isExternal(ref)) {
            return Classref.checkExternal((int)ref).methods.length;
        }
        return Classref.checkInternal(ref).methodCount();
    }

    static int packageToken(int cr) {
        return cr >> 8 & 0x7F;
    }

    static String pretty(int ref) {
        if (Classref.isExternal(ref)) {
            EfClass ec = Classref.checkExternal(ref);
            return ec.thisName().replace('/', '.');
        }
        return Messages.format("Classref.10", ref);
    }

    static int refForName(String classname) {
        int lastslash = classname.lastIndexOf(47);
        if (lastslash == -1) {
            throw new VerifierError("Classref.6", classname);
        }
        String pkgname = classname.substring(0, lastslash);
        if (Cap.Export != null && pkgname.equals(Cap.Export.exportfile.thisName())) {
            int i = 0;
            while (i < Cap.Export.exportfile.classes.length) {
                EfClass ec = Cap.Export.exportfile.classes[i];
                if (classname.equals(ec.thisName())) {
                    return Classref.forExportToken(ec.token);
                }
                ++i;
            }
        }
        int pkgtok = Cap.Import.tokenForPackage(pkgname);
        ExportFile ef = Cap.Import.exportfileForPackageToken(pkgtok);
        int i = 0;
        while (i < ef.classes.length) {
            EfClass ec = ef.classes[i];
            if (classname.equals(ec.thisName())) {
                return 0x8000 | pkgtok << 8 | ec.token;
            }
            ++i;
        }
        throw new VerifierError("Classref.7", (Object)classname, (Object)pkgname);
    }

    static EfClass toExportClass(int ref) {
        if (Classref.isExternal(ref)) {
            return Classref.checkExternal(ref);
        }
        ClassDescriptor cdesc = Classref.checkInternal(ref);
        if (cdesc.token() == 255) {
            return null;
        }
        return Cap.Export.exportclassForToken(cdesc.token());
    }

    static int totalInstanceSize(int ref) {
        if (Classref.isExternal(ref)) {
            EfClass ec = Classref.checkExternal(ref);
            int size = ec.declaredInstanceSize();
            int i = 0;
            while (i < ec.supers.length) {
                size += Classref.exportclassForName(ec.superName(i)).declaredInstanceSize();
                ++i;
            }
            return size;
        }
        ClassInfo cinfo = Cap.Class.infoOfs(ref);
        if ((cinfo.flags() & 8) != 0) {
            return 0;
        }
        if (cinfo.superclass() == 65535) {
            return cinfo.declaredInstanceSize();
        }
        return Classref.totalInstanceSize(cinfo.superclass()) + cinfo.declaredInstanceSize();
    }
}

