/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.AIDintf;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.PackageInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Package;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.File;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;

class ImportComponent
extends Safeptr {
    private Vector importedPackages;
    private BitSet referencedImportedPackages;
    private int numImportedPackages;
    private static Vector exportFiles = new Vector();

    ImportComponent(byte[] data) {
        super(data, "Import");
    }

    void checkUnreferencedPackages() {
        int pkgTok = 0;
        while (pkgTok < this.numImportedPackages) {
            if (!this.referencedImportedPackages.get(pkgTok)) {
                Messages.println("ImportComponent.105", ((ExportFile)this.importedPackages.get(pkgTok)).thisName());
                ++Messages.numWarning;
            }
            ++pkgTok;
        }
    }

    int count() {
        return this.u1(0);
    }

    ExportFile exportfileForPackageToken(int pkgTok) {
        if (this.referencedImportedPackages != null) {
            this.referencedImportedPackages.set(pkgTok);
        }
        return (ExportFile)this.importedPackages.get(pkgTok);
    }

    static Vector findAllExportByAid(PackageInfo p) {
        Vector<ExportFile> result = new Vector<ExportFile>(4);
        Enumeration e = exportFiles.elements();
        while (e.hasMoreElements()) {
            ExportFile ef = (ExportFile)e.nextElement();
            EfConstant_Package pkg = ef.thisPackage();
            if (!AID.same((AIDintf)p, pkg.AID)) continue;
            result.add(ef);
        }
        return result;
    }

    static ExportFile findExportByAid(PackageInfo p) {
        ExportFile result = null;
        Enumeration e = exportFiles.elements();
        while (e.hasMoreElements()) {
            ExportFile ef = (ExportFile)e.nextElement();
            EfConstant_Package pkg = ef.thisPackage();
            if (!AID.same((AIDintf)p, pkg.AID)) continue;
            if (result == null) {
                result = ef;
                continue;
            }
            throw new VerifierError("ImportComponent.7", (Object)result.file, (Object)ef.file);
        }
        return result;
    }

    static ExportFile findExportByAidAndVersion(PackageInfo p) {
        Enumeration e = exportFiles.elements();
        while (e.hasMoreElements()) {
            ExportFile ef = (ExportFile)e.nextElement();
            EfConstant_Package pkg = ef.thisPackage();
            if (!AID.same((AIDintf)p, pkg.AID) || p.majorVersion() != pkg.majorVersion || p.minorVersion() != pkg.minorVersion) continue;
            return ef;
        }
        return null;
    }

    static ExportFile findExportByName(String pkgname) {
        Enumeration e = exportFiles.elements();
        while (e.hasMoreElements()) {
            ExportFile ef = (ExportFile)e.nextElement();
            if (!pkgname.equals(ef.thisName())) continue;
            return ef;
        }
        return null;
    }

    ExportFile importPackage(int pkgTok) {
        if (pkgTok >= 0 && pkgTok < this.numImportedPackages) {
            if (this.referencedImportedPackages != null) {
                this.referencedImportedPackages.set(pkgTok);
            }
            return (ExportFile)this.importedPackages.get(pkgTok);
        }
        return null;
    }

    void initialize() {
        this.referencedImportedPackages = new BitSet(this.count());
    }

    PackageInfo packageInfo() {
        return new PackageInfo(this.offset(1));
    }

    static void readExportFile(File name) {
        ExportFile ef = ExportFile.readFromFile(name);
        ef.verify();
        exportFiles.add(ef);
        if (Verifier.verbose >= 2) {
            Messages.println("ImportComponent.104", name, ef.thisName(), ef.thisPackage().majorVersion, ef.thisPackage().minorVersion);
        }
    }

    int tokenForPackage(String pkgname) {
        ExportFile e;
        int i = 0;
        while (i < this.importedPackages.size()) {
            e = (ExportFile)this.importedPackages.get(i);
            if (pkgname.equals(e.thisName())) {
                if (this.referencedImportedPackages != null) {
                    this.referencedImportedPackages.set(i);
                }
                return i;
            }
            ++i;
        }
        e = ImportComponent.findExportByName(pkgname);
        if (e == null) {
            throw new VerifierError("ImportComponent.6", pkgname);
        }
        this.importedPackages.add(e);
        return this.importedPackages.size() - 1;
    }

    void verify() {
        int count;
        if (Verifier.verbose >= 2) {
            Messages.println("ImportComponent.100");
        }
        if ((count = this.count()) >= 128) {
            throw new VerifierError("ImportComponent.1", count);
        }
        this.importedPackages = new Vector(count);
        this.numImportedPackages = 0;
        PackageInfo pkg = this.packageInfo();
        int i = 0;
        while (i < count) {
            if (!AID.isValid(pkg)) {
                throw new VerifierError("ImportComponent.2", AID.pretty(pkg));
            }
            ExportFile ef = ImportComponent.findExportByAid(pkg);
            if (ef == null) {
                throw new VerifierError("ImportComponent.3", AID.pretty(pkg));
            }
            EfConstant_Package epkg = ef.thisPackage();
            if (pkg.majorVersion() != epkg.majorVersion || pkg.minorVersion() > epkg.minorVersion) {
                throw new VerifierError("ImportComponent.4", ef.thisName(), AID.pretty(pkg), pkg.majorVersion(), pkg.minorVersion(), epkg.majorVersion, epkg.minorVersion);
            }
            if (Verifier.verbose >= 1) {
                if (pkg.minorVersion() == epkg.minorVersion) {
                    Messages.println("ImportComponent.101", ef.thisName(), AID.pretty(pkg), pkg.majorVersion(), pkg.minorVersion());
                } else {
                    Messages.println("ImportComponent.102", ef.thisName(), AID.pretty(pkg), pkg.majorVersion(), pkg.minorVersion(), epkg.majorVersion, epkg.minorVersion);
                }
                Messages.println("ImportComponent.103", ef.file);
            }
            this.importedPackages.add(ef);
            ++this.numImportedPackages;
            pkg.next();
            ++i;
        }
        if (!pkg.atComponentEnd()) {
            throw new VerifierError("ImportComponent.5");
        }
    }
}

