/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.File;

class VerifyExp {
    static int verbose = 1;
    static boolean printTrace = false;

    VerifyExp() {
    }

    public static void main(String[] argv) {
        String ef_name;
        boolean banner = true;
        int i = 0;
        while (i < argv.length && argv[i].length() > 0 && argv[i].charAt(0) == '-') {
            String s = argv[i];
            if (s.equals("-verbose")) {
                ++verbose;
            } else if (s.equals("-nobanner")) {
                banner = false;
            } else if (s.equals("-help")) {
                VerifyExp.printUsageAndExit();
            } else if (s.equals("-version")) {
                Messages.println("MainExp.3");
                System.exit(2);
            } else {
                VerifyExp.printUsageAndExit();
            }
            ++i;
        }
        if (i + 1 != argv.length) {
            VerifyExp.printUsageAndExit();
        }
        if (verbose >= 1 && banner) {
            Messages.println("MainExp.3");
        }
        if (!(ef_name = argv[i]).endsWith(".exp")) {
            VerifyExp.printUsageAndExit();
        }
        File ef_file = new File(ef_name);
        if (verbose >= 1) {
            Messages.println("MainExp.4", ef_name);
        }
        try {
            ExportFile ef = ExportFile.readFromFile(ef_file);
            ef.verify();
        }
        catch (VerifierError e) {
            Messages.printTo(System.err);
            Messages.println("MainExp.2", Messages.numWarning, (Object)e.getMessage(), (Object)Messages.format("MainExp.6"));
            System.exit(2);
        }
        Messages.println("MainExp.5", Messages.numWarning);
    }

    private static void printUsageAndExit() {
        Messages.printTo(System.err);
        Messages.println("MainExp.1");
        System.exit(2);
    }
}

