/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcwde;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.jcwde.Globals;
import com.sun.javacard.jcwde.MaskedApplets;
import com.sun.javacard.jcwde.SimAPDU;
import com.sun.javacard.jcwde.SimChannelManager;
import com.sun.javacard.jcwde.SimSystem;
import com.sun.javacard.jcwde.SimulationException;
import java.text.MessageFormat;
import javacard.framework.JCWDEDispatcher;

public class Main
implements Runnable {
    int port;
    String configFile;
    static boolean nobanner;
    static boolean verbose;
    static byte transportProtocol;
    public static final byte MAX_LOGICAL_CHANNELS = 20;

    public Main(int port, String configFile) {
        this.port = port;
        this.configFile = configFile;
        Main.banner();
        SimAPDU.port = port;
        Object[] msg1Args = new Object[]{new Integer(port)};
        if (transportProtocol == 0) {
            System.out.println(MessageFormat.format(Globals._messages.getString("main.listening.t0"), msg1Args));
        } else {
            System.out.println(MessageFormat.format(Globals._messages.getString("main.listening.t1"), msg1Args));
        }
        MaskedApplets.readConfigFile(configFile);
    }

    public void run() {
        try {
            SimSystem.init(transportProtocol);
            SimChannelManager.init((byte)20);
            JCWDEDispatcher.main();
        }
        catch (SimulationException e) {
            System.err.println(Globals._messages.getString("Exception"));
            throw e;
        }
        System.err.println(Globals._messages.getString("DispatcherTerminated"));
    }

    public static void main(String[] argv) {
        Main jcwde = null;
        String configFileParam = null;
        int port = 9025;
        transportProtocol = 1;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-p")) {
                try {
                    port = Integer.parseInt(argv[++i]);
                }
                catch (NumberFormatException e) {
                    Main.usage(true);
                    System.exit(1);
                }
                continue;
            }
            if (argv[i].equals("-help")) {
                Main.usage(false);
                System.exit(0);
                continue;
            }
            if (argv[i].equals("-nobanner")) {
                nobanner = true;
                continue;
            }
            if (argv[i].equals("-version")) {
                Main.banner();
                System.exit(0);
                continue;
            }
            if (argv[i].equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (argv[i].equals("-t0")) {
                transportProtocol = 0;
                continue;
            }
            if (i + 1 == argv.length) {
                configFileParam = argv[i];
                continue;
            }
            Main.usage(true);
            System.exit(1);
        }
        if (configFileParam == null) {
            Main.usage(true);
            System.exit(1);
        }
        try {
            jcwde = new Main(port, configFileParam);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        try {
            jcwde.run();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
    }

    private static void banner() {
        if (nobanner) {
            return;
        }
        System.out.println(ToolsVersion.getProductName() + " " + ToolsVersion.getToolName(9) + ", " + ToolsVersion.getVersionString() + " " + ToolsVersion.getVersion(9));
        System.out.println(ToolsVersion.getCopyrightBanner());
    }

    private static void usage(boolean isError) {
        if (isError) {
            System.err.println(Globals._messages.getString("main.usage"));
        } else {
            System.out.println(Globals._messages.getString("main.usage"));
        }
    }
}

