/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcwde;

import com.sun.javacard.apduio.CadEvent;
import com.sun.javacard.apduio.CadServerListener;
import com.sun.javacard.apduio.CadT1Dual;
import com.sun.javacard.apduio.ServerT0Protocol;
import com.sun.javacard.apduio.T1Exception;
import com.sun.javacard.impl.Constants;
import com.sun.javacard.jcwde.Globals;
import com.sun.javacard.jcwde.SimulationException;
import com.sun.javacard.jcwde.T1Open;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class SimAPDU
implements CadServerListener,
Constants {
    private static final short BUFFER_OVERFLOW = -16383;
    private static final short READ_ERROR = -16381;
    private static final short WRITE_ERROR = -16380;
    private static final short INVALID_GET_RESPONSE = -16378;
    private static final byte ACK_NONE = 0;
    private static final byte ACK_INS = 1;
    private static final byte ACK_NOT_INS = 2;
    private static final byte GET_RESPONSE_CLA = 0;
    private static final byte GET_RESPONSE_INS = -64;
    private static final byte GET_RESPONSE_P1 = 0;
    private static final byte GET_RESPONSE_P2 = 0;
    private static boolean invalidGetResponse = false;
    public static int port = 0;
    public static ServerSocket srvSock = null;
    public static ServerSocket srvSock_contactless = null;
    protected static ServerT0Protocol _t0protocol;
    protected static SimAPDU _simApdu;
    private static byte[] t0APDUBuffer;
    private static byte[] t0ScratchAPDUBuffer;
    private static short apduStatus;
    private static byte[] command;
    private static byte[] t1APDUBuffer;
    private static short[] t1Len;
    private static boolean[] t1Last;
    static CadT1Dual cadt1dual;
    private static final byte T1_EVENT_NONE = 0;
    private static final byte T1_EVENT_POWERUP = 1;
    private static final byte T1_EVENT_POWERDOWN = 2;

    static ServerT0Protocol t0protocol() {
        if (_t0protocol == null) {
            try {
                byte[] atr = new byte[]{59, -16, 17, 0, -1, 0};
                Socket sock = srvSock.accept();
                sock.setTcpNoDelay(true);
                BufferedInputStream bin = new BufferedInputStream(sock.getInputStream());
                BufferedOutputStream bos = new BufferedOutputStream(sock.getOutputStream());
                _t0protocol = new ServerT0Protocol((InputStream)bin, (OutputStream)bos);
                _simApdu = new SimAPDU();
                _t0protocol.addCadServerListener((CadServerListener)_simApdu);
                _t0protocol.sendATR(atr);
            }
            catch (Exception e) {
                System.err.println(e);
                throw new SimulationException();
            }
        }
        return _t0protocol;
    }

    public void powerUp(CadEvent evt) {
    }

    public void powerDown(CadEvent evt) {
        System.out.println(Globals._messages.getString("PowerDown"));
        System.exit(0);
    }

    static CadT1Dual getCadT1Dual() {
        if (cadt1dual == null) {
            try {
                Socket sock = srvSock.accept();
                cadt1dual = new CadT1Dual(sock);
                byte[] atr0 = new byte[]{59, -16, 17, 0, -1, 0};
                cadt1dual.setContactedATR(atr0);
                byte[] atr1 = new byte[]{59, -16, 17, 0, -1, 1};
                cadt1dual.setContactlessATR(atr1);
                _simApdu = new SimAPDU();
                cadt1dual.addCadServerListener((CadServerListener)_simApdu);
                new Thread(new T1Open(cadt1dual, srvSock_contactless)).start();
            }
            catch (Exception e) {
                System.err.println(e);
                throw new SimulationException();
            }
        }
        return cadt1dual;
    }

    public static short t1SndBlockRcvAck(short offset, short length, boolean isLastBlock, boolean switchInterfaces) {
        try {
            short status = SimAPDU.getCadT1Dual().t1SndBlockRcvAck(t1APDUBuffer, (int)offset, (int)length, isLastBlock, switchInterfaces);
            return status;
        }
        catch (T1Exception t1e) {
            return (short)(t1e.getStatus() & 0xFFFF);
        }
    }

    public static short t1RcvBlock(short offset, short dataLimit) {
        try {
            CadT1Dual cadObj = SimAPDU.getCadT1Dual();
            short status = cadObj.t1RcvBlock(t1APDUBuffer, t1Len, offset, dataLimit);
            if (status > -1) {
                CadT1Dual.placeDataInBuffer((CadT1Dual)cadObj, (byte[])t1APDUBuffer, (short[])t1Len, (short)offset, (short)dataLimit);
                return t1Len[0];
            }
            return status;
        }
        catch (T1Exception t1e) {
            return (short)(t1e.getStatus() & 0xFFFF);
        }
    }

    public static short t1RcvBlockDiscardData(short numBytesExpected, short numBytesReceived) {
        try {
            CadT1Dual cadObj = SimAPDU.getCadT1Dual();
            while (!SimAPDU.t1LastBlockReceived()) {
                short status = cadObj.t1RcvBlock(null, t1Len, numBytesExpected, numBytesReceived);
                if (status <= -1) {
                    return status;
                }
                CadT1Dual.discardIncomingGetLe((CadT1Dual)cadObj, (short[])t1Len, (short)numBytesExpected, (short)numBytesReceived);
                numBytesReceived = (short)(numBytesReceived + t1Len[0]);
            }
        }
        catch (T1Exception t1e) {
            return (short)(t1e.getStatus() & 0xFFFF);
        }
        if (numBytesReceived != numBytesExpected && t1Len[1] < 0) {
            return -2;
        }
        if (numBytesReceived == numBytesExpected) {
            return -1;
        }
        return t1Len[1];
    }

    public static short t1Abort() {
        try {
            boolean result = SimAPDU.getCadT1Dual().t1Abort();
            if (!result) {
                return -1;
            }
            return 0;
        }
        catch (T1Exception t1e) {
            return (short)(t1e.getStatus() & 0xFFFF);
        }
    }

    public static short t1Wait() {
        try {
            boolean result = SimAPDU.getCadT1Dual().t1Wait();
            if (!result) {
                return -1;
            }
            return 0;
        }
        catch (T1Exception t1e) {
            return (short)(t1e.getStatus() & 0xFFFF);
        }
    }

    public static byte t1GetNAD() {
        SimAPDU.getCadT1Dual();
        return CadT1Dual.t1GetNAD();
    }

    public static boolean t1LastBlockReceived() {
        return SimAPDU.getCadT1Dual().t1LastBlockReceived();
    }

    public static short t1GetIFSC() {
        return SimAPDU.getCadT1Dual().t1GetIFSC();
    }

    public static short t1GetIFSD() {
        return SimAPDU.getCadT1Dual().t1GetIFSD();
    }

    public static byte getActiveInterface() {
        if (cadt1dual == null) {
            return 0;
        }
        return SimAPDU.getCadT1Dual().getActiveInterface();
    }

    public static byte getSecondaryInterfaceEvent() {
        if (cadt1dual == null) {
            return 0;
        }
        return SimAPDU.getCadT1Dual().getSecondaryInterfaceEvent();
    }

    public static byte[] t1InitAPDUBuffer() {
        try {
            srvSock = new ServerSocket(port);
            srvSock_contactless = new ServerSocket(port + 1);
        }
        catch (Exception iE) {
            System.err.println(iE);
            System.err.println(Globals._messages.getString("BadSocket") + port);
            throw new SimulationException();
        }
        return t1APDUBuffer;
    }

    public static short t0RcvCommand() {
        if (SimAPDU.t0protocol().t0RcvCommand(t0ScratchAPDUBuffer) != 0) {
            return -16381;
        }
        System.arraycopy(t0ScratchAPDUBuffer, 0, command, 0, 5);
        return 0;
    }

    public static short t0SndStatusRcvCommand() {
        if (invalidGetResponse) {
            invalidGetResponse = false;
            System.arraycopy(command, 0, t0ScratchAPDUBuffer, 0, 5);
        } else {
            if (SimAPDU.t0protocol().t0SndStatusRcvCommand(t0ScratchAPDUBuffer, apduStatus) != 0) {
                return -16381;
            }
            System.arraycopy(t0ScratchAPDUBuffer, 0, command, 0, 5);
        }
        return 0;
    }

    public static short t0RcvData(short offset) {
        byte status = 0;
        short receiveLen = (short)(command[4] & 0xFF);
        short receiveSpace = (short)(133 - offset);
        if (receiveLen > receiveSpace) {
            receiveLen = receiveSpace;
            while (true) {
                short s = receiveSpace;
                receiveSpace = (short)(s - 1);
                if (s != 0 && status == 0) {
                    short s2 = offset;
                    offset = (short)(offset + 1);
                    status = SimAPDU.t0protocol().t0RcvData(t0ScratchAPDUBuffer, s2, (short)1, ~command[1]);
                    continue;
                }
                break;
            }
        } else {
            status = SimAPDU.t0protocol().t0RcvData(t0ScratchAPDUBuffer, offset, receiveLen, command[1]);
        }
        SimAPDU.command[4] = (byte)(command[4] - receiveLen);
        if (status == 0) {
            return receiveLen;
        }
        return -16381;
    }

    public static short t0SndData(byte[] data, short offset, short length, byte procByteType) {
        switch (procByteType) {
            case 0: {
                if (SimAPDU.t0protocol().t0SndData(data, offset, length) == 0) break;
                return -16380;
            }
            case 1: {
                if (SimAPDU.t0protocol().t0SndData(data, offset, length, command[1]) == 0) break;
                return -16380;
            }
            case 2: {
                if (SimAPDU.t0protocol().t0SndData(data, offset, length, ~command[1]) == 0) break;
                return -16380;
            }
            default: {
                return -16380;
            }
        }
        return 0;
    }

    public static short t0SndGetResponse(byte channelId) {
        if (SimAPDU.t0protocol().t0SndStatusRcvCommand(command, apduStatus) != 0) {
            return -16381;
        }
        if ((byte)(command[0] & 0xFFFFFFFC) != 0 || command[1] != -64 || command[2] != 0 || command[3] != 0) {
            invalidGetResponse = true;
            return -16378;
        }
        if ((command[0] & 3) != channelId) {
            invalidGetResponse = true;
            return -16378;
        }
        return (short)(command[4] & 0xFF);
    }

    public static short t0Wait() {
        if (SimAPDU.t0protocol().t0SndData(t0ScratchAPDUBuffer, (short)0, (short)0, (byte)96) != 0) {
            return -16380;
        }
        return 0;
    }

    public static byte[] t0InitAPDUBuffer() {
        try {
            srvSock = new ServerSocket(port);
        }
        catch (Exception iE) {
            System.err.println(iE);
            System.err.println(Globals._messages.getString("BadSocket") + port);
            throw new SimulationException();
        }
        return t0APDUBuffer;
    }

    public static byte[] t0InitScratchAPDUBuffer() {
        return t0ScratchAPDUBuffer;
    }

    public static void t0CopyToAPDUBuffer(short offset, short length) {
        System.arraycopy(t0ScratchAPDUBuffer, offset, t0APDUBuffer, offset, length);
    }

    public static short t0SetStatus(short sw1Sw2) {
        apduStatus = sw1Sw2;
        return 0;
    }

    static {
        t0APDUBuffer = new byte[133];
        t0ScratchAPDUBuffer = new byte[133];
        apduStatus = 0;
        command = new byte[5];
        t1APDUBuffer = new byte[133];
        t1Len = new short[2];
        t1Last = new boolean[1];
        cadt1dual = null;
    }
}

