/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework.service;

import com.sun.javacard.impl.NativeMethods;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.Vector;
import javacard.framework.SystemException;

class RMINativeMethods {
    private static final short BYTE_SIZE = 1;
    private static final short SHORT_SIZE = 2;
    private static final short INT_SIZE = 4;
    private static final short SIGNATURE_ERROR = 3;
    private static final short OTHER_ERROR = -1;
    private static final short OBJECT_ERROR = 1;
    private static final short PARAM_RESOURCES_ERROR = 4;
    private static final short METHOD_NOT_FOUND_ERROR = -253;
    private static final short OBJECT_NOT_FOUND_ERROR = -255;
    private static short errorCode = 0;
    private static Vector remoteMethods = new Vector();
    private static Hashtable methodHashtable = new Hashtable();
    private static Hashtable anticollisionStringTable = new Hashtable();
    private static Vector packageTable = new Vector();
    private static final short VOID_TYPE = 1;
    private static final short BOOLEAN_TYPE = 2;
    private static final short BYTE_TYPE = 3;
    private static final short SHORT_TYPE = 4;
    private static final short INT_TYPE = 5;
    private static final short OBJECT_TYPE = 6;
    private static final short BOOLEAN_ARRAY_TYPE = 10;
    private static final short BYTE_ARRAY_TYPE = 11;
    private static final short SHORT_ARRAY_TYPE = 12;
    private static final short INT_ARRAY_TYPE = 13;

    RMINativeMethods() {
    }

    public static void rmi_invoker_void(int remote_method_info, short objID, byte[] buffer, byte offset) throws Throwable {
        RMINativeMethods.rmi_invoker_common(remote_method_info, objID, buffer, offset);
    }

    public static boolean rmi_invoker_boolean(int remote_method_info, short objID, byte[] buffer, byte offset) throws Throwable {
        return (Boolean)RMINativeMethods.rmi_invoker_common(remote_method_info, objID, buffer, offset);
    }

    public static byte rmi_invoker_byte(int remote_method_info, short objID, byte[] buffer, byte offset) throws Throwable {
        return (Byte)RMINativeMethods.rmi_invoker_common(remote_method_info, objID, buffer, offset);
    }

    public static short rmi_invoker_short(int remote_method_info, short objID, byte[] buffer, byte offset) throws Throwable {
        return (Short)RMINativeMethods.rmi_invoker_common(remote_method_info, objID, buffer, offset);
    }

    public static int rmi_invoker_int(int remote_method_info, short objID, byte[] buffer, byte offset) throws Throwable {
        return (Integer)RMINativeMethods.rmi_invoker_common(remote_method_info, objID, buffer, offset);
    }

    public static Object rmi_invoker_reference(int remote_method_info, short objID, byte[] buffer, byte offset) throws Throwable {
        return RMINativeMethods.rmi_invoker_common(remote_method_info, objID, buffer, offset);
    }

    public static Object rmi_invoker_array(int remote_method_info, short objID, byte[] buffer, byte offset) throws Throwable {
        return RMINativeMethods.rmi_invoker_common(remote_method_info, objID, buffer, offset);
    }

    private static Object rmi_invoker_common(int remote_method_info, short objID, byte[] buffer, byte offset) throws Throwable {
        Object remoteObj = NativeMethods.getObject(objID);
        Method method = (Method)remoteMethods.get(remote_method_info);
        Object[] args = RMINativeMethods.parseData(buffer, offset, method);
        Object result = null;
        try {
            result = method.invoke(remoteObj, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            SystemException.throwIt((short)-1);
        }
        return result;
    }

    public static void deleteAllTempArrays() {
    }

    public static boolean isAPIException(Throwable ex) {
        return ex.getClass().getName().startsWith("java");
    }

    public static short getRemoteMethodInfo(short objectID, short methodHash) {
        Method method = null;
        Object object = NativeMethods.getObject(objectID);
        if (object == null) {
            return -255;
        }
        String className = object.getClass().getName();
        method = (Method)methodHashtable.get(className + new Short(methodHash));
        if (method == null) {
            return -253;
        }
        if (!remoteMethods.contains(method)) {
            remoteMethods.add(method);
        }
        return (short)remoteMethods.indexOf(method);
    }

    public static short getReturnType(int remote_method_info) {
        try {
            Class<?> classType = ((Method)remoteMethods.get(remote_method_info)).getReturnType();
            return RMINativeMethods.decode(classType);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static byte getRemoteInterfaceNumber(Remote remoteObj) {
        boolean count = false;
        Class<?> superFinder = remoteObj.getClass();
        return (byte)RMINativeMethods.getInterfaces(superFinder).size();
    }

    private static boolean isRemote(Class thisclass) {
        boolean found = false;
        try {
            found = Class.forName("java.rmi.Remote").isAssignableFrom(thisclass);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return found;
    }

    public static void setRMIErrorCode(short value) {
        errorCode = value;
    }

    public static short getRMIErrorCode() {
        return errorCode;
    }

    public static short getPackageName(Object data, byte[] buffer, short offset) {
        return RMINativeMethods.copyString(offset, buffer, data.getClass().getPackage().getName().replace('.', '/'));
    }

    public static short getClassName(Remote data, byte[] buffer, short offset) {
        Class<?> thisClass = data.getClass();
        boolean found = false;
        while (!found) {
            Class<?>[] temp = thisClass.getInterfaces();
            for (int i = 0; i < temp.length; i = (int)((short)(i + 1))) {
                if (!RMINativeMethods.isRemote(temp[i])) continue;
                found = true;
                break;
            }
            if (found) break;
            thisClass = thisClass.getSuperclass();
        }
        String name = thisClass.getName();
        return RMINativeMethods.copyString(offset, buffer, name.substring(name.lastIndexOf(".") + 1));
    }

    public static byte getPkgIDForRemoteInterface(Remote data, int i) {
        Class thisInterface = RMINativeMethods.getRemoteInterface(data, i);
        Package pkg = thisInterface.getPackage();
        if (packageTable.indexOf(pkg) == -1) {
            packageTable.add(pkg);
        }
        return (byte)packageTable.indexOf(pkg);
    }

    public static short getPkgNameForRemoteInterface(Remote data, int i, byte[] buffer, short offset) {
        Class thisInterface = RMINativeMethods.getRemoteInterface(data, i);
        return RMINativeMethods.copyString(offset, buffer, thisInterface.getPackage().getName().replace('.', '/'));
    }

    public static short getRemoteInterfaceName(Remote data, int i, byte[] buffer, short offset) {
        String name = RMINativeMethods.getRemoteInterface(data, i).getName();
        return RMINativeMethods.copyString(offset, buffer, name.substring(name.lastIndexOf(".") + 1));
    }

    private static Class getRemoteInterface(Remote data, int i) {
        boolean listSize = false;
        boolean remoteCounter = false;
        boolean index = false;
        Class<?> superFinder = data.getClass();
        Vector interfaces = RMINativeMethods.getInterfaces(superFinder);
        if (i > interfaces.size() || i < 0) {
            RMINativeMethods.setRMIErrorCode((short)-1);
            throw new SystemException(-1);
        }
        return (Class)interfaces.get(i);
    }

    private static Vector getInterfaces(Class superFinder) {
        Vector remotes = new Vector();
        while (!superFinder.getName().equals("java.lang.Object")) {
            Class<?>[] temp = superFinder.getInterfaces();
            for (int i = 0; i < temp.length; i = (int)((short)(i + 1))) {
                if (!RMINativeMethods.isRemote(temp[i]) || temp[i].getName().equals("java.rmi.Remote") || remotes.contains(temp[i])) continue;
                remotes.add(temp[i]);
            }
            superFinder = superFinder.getSuperclass();
        }
        return remotes;
    }

    public static short writeArray(Object data, byte[] buffer, short offset) throws SystemException {
        Class<?> datatype = data.getClass();
        short type = RMINativeMethods.decode(datatype);
        switch (type) {
            case 10: {
                boolean[] ztemp = (boolean[])data;
                buffer[offset] = (byte)ztemp.length;
                offset = (short)(offset + 1);
                int i = 0;
                while (i < ztemp.length) {
                    buffer[offset] = ztemp[i] ? (byte)1 : 0;
                    i = (short)(i + 1);
                    offset = (short)(offset + 1);
                }
                break;
            }
            case 11: {
                byte[] btemp = (byte[])data;
                buffer[offset] = (byte)btemp.length;
                offset = (short)(offset + 1);
                System.arraycopy(btemp, 0, buffer, offset, btemp.length);
                offset = (short)(offset + btemp.length);
                break;
            }
            case 12: {
                short[] svalue = (short[])data;
                buffer[offset] = (byte)svalue.length;
                offset = (short)(offset + 1);
                int count = 0;
                while (count < svalue.length) {
                    for (int k = 0; k < 2; k = (int)((short)(k + 1))) {
                        int shift = (2 - k - 1) * 8;
                        buffer[offset + k] = (byte)((svalue[count] & 255 << shift) >>> shift);
                    }
                    count = (short)(count + 1);
                    offset = (short)(offset + 2);
                }
                break;
            }
            case 13: {
                int[] ivalue = (int[])data;
                buffer[offset] = (byte)ivalue.length;
                offset = (short)(offset + 1);
                int count = 0;
                while (count < ivalue.length) {
                    for (int k = 0; k < 4; k = (int)((short)(k + 1))) {
                        int shift = (4 - k - 1) * 8;
                        buffer[offset + k] = (byte)((ivalue[count] & 255 << shift) >>> shift);
                    }
                    count = (short)(count + 1);
                    offset = (short)(offset + 4);
                }
                break;
            }
            default: {
                SystemException.throwIt((short)1);
            }
        }
        return offset;
    }

    public static short getAnticollisionString(Remote remoteObj, byte[] buffer, byte offset) {
        Class<?> classKey = remoteObj.getClass();
        String aCS = (String)anticollisionStringTable.get(classKey.getName());
        if (aCS == null) {
            aCS = RMINativeMethods.generateACS(classKey);
            anticollisionStringTable.put(classKey.getName(), aCS);
        }
        return RMINativeMethods.copyString(offset, buffer, aCS);
    }

    private static String generateACS(Class classKey) {
        int stringIndex = 0;
        boolean unique = false;
        short methodID = 0;
        String acs = "";
        Vector<Short> store = new Vector<Short>();
        Vector<Method> methods = new Vector<Method>();
        Vector<String> strings = new Vector<String>();
        Class superFinder = classKey;
        int i = 0;
        while (!superFinder.getName().equals("java.lang.Object")) {
            Method[] classMethods = superFinder.getDeclaredMethods();
            for (int j = 0; j < classMethods.length; j = (int)((short)(j + 1))) {
                String nameStr = classMethods[j].getName() + RMINativeMethods.getDescriptor(classMethods[j]);
                if (strings.contains(nameStr)) continue;
                methods.add(classMethods[j]);
                strings.add(nameStr);
            }
            superFinder = superFinder.getSuperclass();
            i = (short)(i + 1);
        }
        block2: while (!unique) {
            if (!store.isEmpty()) {
                store.removeAllElements();
            }
            unique = true;
            for (i = 0; i < methods.size(); i = (int)((short)(i + 1))) {
                methodID = RMINativeMethods.generateMethodID(acs + (String)strings.elementAt(i));
                if (store.indexOf(new Short(methodID)) >= 0) {
                    unique = false;
                    stringIndex = (byte)(stringIndex + 1);
                    acs = Integer.toString(stringIndex);
                    continue block2;
                }
                store.add(new Short(methodID));
            }
        }
        String preffix = classKey.getName();
        for (int i2 = 0; i2 < methods.size(); i2 = (int)((short)(i2 + 1))) {
            if (methodHashtable.get(preffix + store.elementAt(i2)) != null) continue;
            methodHashtable.put(preffix + store.elementAt(i2), methods.elementAt(i2));
        }
        return acs;
    }

    private static short copyString(short offset, byte[] buffer, String string) {
        byte length = 0;
        try {
            byte[] temp = string.getBytes("UTF-8");
            buffer[offset] = length = (byte)temp.length;
            offset = (short)(offset + 1);
            System.arraycopy(temp, 0, buffer, offset, length);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return (short)(offset + length);
    }

    /*
     * Unable to fully structure code
     */
    private static Object[] parseData(byte[] buffer, short offset, Method method) throws Exception {
        parameters = method.getParameterTypes();
        args = new Object[parameters.length];
        j = offset;
lbl4:
        // 5 sources

        try {
            for (i = 0; i < parameters.length; i = (int)((short)(i + 1))) {
                block18: {
                    block19: {
                        block16: {
                            block17: {
                                block14: {
                                    block15: {
                                        block12: {
                                            block13: {
                                                if (parameters[i].toString().equals("boolean")) {
                                                    args[i] = buffer[j] == 0 ? new Boolean("false") : new Boolean("true");
                                                    j = (short)(j + 1);
                                                    continue;
                                                }
                                                if (parameters[i].toString().equals("byte")) {
                                                    args[i] = new Byte(buffer[j]);
                                                    j = (short)(j + 1);
                                                    continue;
                                                }
                                                if (parameters[i].toString().equals("short")) {
                                                    args[i] = new Short(new DataInputStream(new ByteArrayInputStream(buffer, j, 2)).readShort());
                                                    j = (short)(j + 2);
                                                    continue;
                                                }
                                                if (parameters[i].toString().equals("int")) {
                                                    args[i] = new Integer(new DataInputStream(new ByteArrayInputStream(buffer, j, 4)).readInt());
                                                    j = (short)(j + 4);
                                                    continue;
                                                }
                                                if (!parameters[i].getName().equals("[Z")) break block12;
                                                if (buffer[j] == -1) break block13;
                                                args[i] = new boolean[buffer[j]];
                                                j = (short)(j + 1);
                                                k = 0;
                                                while (k < ((boolean[])args[i]).length) {
                                                    ((boolean[])args[i])[k] = buffer[j] == 1;
                                                    k = (short)(k + 1);
                                                    j = (short)(j + 1);
                                                }
                                                ** GOTO lbl4
                                            }
                                            args[i] = null;
                                            j = (short)(j + 1);
                                            continue;
                                        }
                                        if (!parameters[i].getName().equals("[B")) break block14;
                                        if (buffer[j] == -1) break block15;
                                        args[i] = new byte[buffer[j]];
                                        j = (short)(j + 1);
                                        k = 0;
                                        while (k < ((byte[])args[i]).length) {
                                            ((byte[])args[i])[k] = buffer[j];
                                            k = (short)(k + 1);
                                            j = (short)(j + 1);
                                        }
                                        ** GOTO lbl4
                                    }
                                    args[i] = null;
                                    j = (short)(j + 1);
                                    continue;
                                }
                                if (!parameters[i].getName().equals("[S")) break block16;
                                if (buffer[j] == -1) break block17;
                                args[i] = new short[buffer[j]];
                                j = (short)(j + 1);
                                for (k = 0; k < ((short[])args[i]).length; k = (int)((short)(k + 1))) {
                                    ((short[])args[i])[k] = new DataInputStream(new ByteArrayInputStream(buffer, j, 2)).readShort();
                                    j = (short)(j + 2);
                                }
                                ** GOTO lbl4
                            }
                            args[i] = null;
                            j = (short)(j + 1);
                            continue;
                        }
                        if (!parameters[i].getName().equals("[I")) break block18;
                        if (buffer[j] == -1) break block19;
                        args[i] = new int[buffer[j]];
                        j = (short)(j + 1);
                        for (k = 0; k < ((int[])args[i]).length; k = (int)((short)(k + 1))) {
                            ((int[])args[i])[k] = new DataInputStream(new ByteArrayInputStream(buffer, j, 4)).readInt();
                            j = (short)(j + 4);
                        }
                        ** GOTO lbl4
                    }
                    args[i] = null;
                    j = (short)(j + 1);
                    continue;
                }
                RMINativeMethods.setRMIErrorCode((short)3);
                throw new SystemException(3);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            RMINativeMethods.setRMIErrorCode((short)3);
            throw new SystemException(3);
        }
        paramLength = (short)(buffer[4] - 4);
        if (paramLength != j - offset) {
            RMINativeMethods.setRMIErrorCode((short)3);
            throw new SystemException(3);
        }
        return args;
    }

    private static String getDescriptor(Method method) {
        Class<?>[] params = method.getParameterTypes();
        Class<?> ret_type = method.getReturnType();
        StringBuffer descriptor = new StringBuffer("(");
        for (int i = 0; i < params.length; ++i) {
            String pName = params[i].getName();
            if ("boolean".equals(pName)) {
                descriptor.append("Z");
                continue;
            }
            if ("byte".equals(pName)) {
                descriptor.append("B");
                continue;
            }
            if ("short".equals(pName)) {
                descriptor.append("S");
                continue;
            }
            if ("int".equals(pName)) {
                descriptor.append("I");
                continue;
            }
            descriptor.append(pName);
        }
        descriptor.append(")");
        String rName = ret_type.getName();
        if ("boolean".equals(rName)) {
            descriptor.append("Z");
        } else if ("byte".equals(rName)) {
            descriptor.append("B");
        } else if ("short".equals(rName)) {
            descriptor.append("S");
        } else if ("int".equals(rName)) {
            descriptor.append("I");
        } else if ("void".equals(rName)) {
            descriptor.append("V");
        } else if ("[Z".equals(rName)) {
            descriptor.append("[Z");
        } else if ("[B".equals(rName)) {
            descriptor.append("[B");
        } else if ("[S".equals(rName)) {
            descriptor.append("[S");
        } else if ("[I".equals(rName)) {
            descriptor.append("[I");
        } else {
            descriptor.append("L");
            descriptor.append(rName.replace('.', '/'));
            descriptor.append(";");
        }
        return descriptor.toString();
    }

    private static short generateMethodID(String string) throws SecurityException {
        int hash = 0;
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA");
            byte[] value = string.getBytes("UTF-8");
            byte[] hasharray = sha.digest(value);
            hash = hasharray.length >= 2 ? (int)((short)(hasharray[0] << 8 | hasharray[1] & 0xFF)) : -1;
        }
        catch (IOException ignore) {
            hash = -1;
        }
        catch (NoSuchAlgorithmException complain) {
            throw new SecurityException(complain.getMessage());
        }
        return (short)hash;
    }

    private static short decode(Class classType) throws SystemException {
        int returnType = 0;
        returnType = classType.getName().equals("void") ? 1 : (classType.getName().equals("boolean") ? 2 : (classType.getName().equals("byte") ? 3 : (classType.getName().equals("short") ? 4 : (classType.getName().equals("int") ? 5 : (classType.getName().equals("[Z") ? 10 : (classType.getName().equals("[B") ? 11 : (classType.getName().equals("[S") ? 12 : (classType.getName().equals("[I") ? 13 : 6))))))));
        return (short)returnType;
    }
}

