/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy;

import com.sun.javacard.debugproxy.Packet;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class ProxyListener
extends Thread {
    public static byte[] JDWP_HANDSHAKE = "JDWP-Handshake".getBytes();
    public static final int METHOD_BASE_SHIFT = 15;
    public static final int METHOD_BASE_BITS = 98304;
    public static final int METHOD_BASE_ONE_FLAG = 2;
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 2;
    protected static int method_index_base = 0;
    protected int verbose = 0;
    protected Map<String, Packet> waitingQueue = new HashMap<String, Packet>(8, 0.75f);
    protected List<Packet> packetQueue = Collections.synchronizedList(new LinkedList());
    protected boolean timeToQuit = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newPacket(Packet packet) {
        if (packet == null) {
            this.quit();
            List<Packet> list = this.packetQueue;
            synchronized (list) {
                this.packetQueue.notify();
            }
            return;
        }
        List<Packet> list = this.packetQueue;
        synchronized (list) {
            this.packetQueue.add(packet);
            this.packetQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet waitForPacket() {
        List<Packet> list = this.packetQueue;
        synchronized (list) {
            while (!this.timeToQuit && this.packetQueue.size() == 0) {
                try {
                    this.packetQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.timeToQuit) {
            return null;
        }
        return this.packetQueue.remove(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replyReceived(Packet packet) {
        Packet packet22 = null;
        if (packet == null) {
            this.quit();
            Map<String, Packet> map = this.waitingQueue;
            synchronized (map) {
                for (Packet packet22 : this.waitingQueue.values()) {
                    packet22.notify();
                }
            }
            return;
        }
        String string = String.valueOf(packet.id);
        Object object = this.waitingQueue;
        synchronized (object) {
            packet22 = this.waitingQueue.get(string);
            if (packet22 != null) {
                this.waitingQueue.remove(string);
            }
        }
        if (packet22 == null) {
            System.err.println("Received reply with no sender!");
            return;
        }
        packet22.errorCode = packet.errorCode;
        packet22.data = packet.data;
        packet22.replied = true;
        object = packet22;
        synchronized (object) {
            packet22.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForReply(Packet packet) {
        Packet packet2 = packet;
        synchronized (packet2) {
            while (!this.timeToQuit && !packet.replied) {
                try {
                    packet.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!packet.replied) {
                throw new RuntimeException();
            }
        }
    }

    public void verbose(int n) {
        this.verbose = n;
    }

    public abstract void send(Packet var1) throws IOException;

    public abstract void quit();

    protected void log(int n, String string) {
        if (this.verbose >= n) {
            System.out.print(string);
        }
    }

    protected void loge(int n, String string) {
        if (this.verbose == n) {
            this.log(n, string);
        }
    }
}

