/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.installer;

import com.sun.javacard.impl.AppTable;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PackageMgr;
import com.sun.javacard.installer.AppletComponent;
import com.sun.javacard.installer.ClassComponent;
import com.sun.javacard.installer.Component;
import com.sun.javacard.installer.ConstantPoolComponent;
import com.sun.javacard.installer.DirectoryComponent;
import com.sun.javacard.installer.ExportComponent;
import com.sun.javacard.installer.HeaderComponent;
import com.sun.javacard.installer.ImportComponent;
import com.sun.javacard.installer.InstallerException;
import com.sun.javacard.installer.MethodComponent;
import com.sun.javacard.installer.ReferenceLocationComponent;
import com.sun.javacard.installer.StaticFieldComponent;
import javacard.framework.APDU;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;

class Installer
extends Component {
    private static boolean installerRunning;
    static Component[] f_linkers;
    static byte[] f_downloadOrder;

    static {
        byte[] byArray = new byte[12];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 4;
        byArray[4] = 3;
        byArray[5] = 9;
        byArray[6] = 5;
        byArray[7] = 6;
        byArray[8] = 7;
        byArray[9] = 10;
        byArray[10] = 8;
        f_downloadOrder = byArray;
    }

    protected Installer() {
        if (installerRunning) {
            ISOException.throwIt((short)27904);
        }
        installerRunning = true;
        f_linkers = new Component[11];
        Installer.f_linkers[1] = new HeaderComponent();
        Installer.f_linkers[2] = new DirectoryComponent();
        Installer.f_linkers[3] = new AppletComponent();
        Installer.f_linkers[4] = new ImportComponent();
        Installer.f_linkers[5] = new ConstantPoolComponent();
        Installer.f_linkers[6] = new ClassComponent();
        Installer.f_linkers[7] = new MethodComponent();
        Installer.f_linkers[8] = new StaticFieldComponent();
        Installer.f_linkers[9] = new ReferenceLocationComponent();
        Installer.f_linkers[10] = new ExportComponent();
    }

    void install(APDU apdu) {
        try {
            this.verifyAPDUOrder(apdu);
            Component.g_buffer = apdu.getBuffer();
            Component.g_ins = Component.g_buffer[1];
            Component.g_p1 = Component.g_buffer[2];
            Component.g_p2 = Component.g_buffer[3];
            Component.g_lc = Component.g_buffer[4];
            Component.g_dataOffset = (short)5;
            if (Component.g_ins == -76 || Component.g_ins == -72) {
                Component.g_dataSize = apdu.setIncomingAndReceive();
            }
            switch (Component.g_ins) {
                case -80: {
                    Component.resetLinker();
                    break;
                }
                case -78: 
                case -76: 
                case -68: {
                    if (Component.g_p1 < 1 || Component.g_p1 > 10) {
                        InstallerException.throwIt((short)25654);
                    }
                    if (Component.g_ins == -78) {
                        f_linkers[Component.g_p1].init();
                        break;
                    }
                    if (Component.g_ins == -76) {
                        f_linkers[Component.g_p1].process();
                        break;
                    }
                    f_linkers[Component.g_p1].postProcess();
                    break;
                }
                case -70: {
                    if (Component.g_cpHandle != 0) {
                        NativeMethods.restore(Component.g_cpHandle);
                    }
                    boolean doCommit = false;
                    if (JCSystem.getTransactionDepth() == 0) {
                        JCSystem.beginTransaction();
                        doCommit = true;
                    }
                    AppTable.commit();
                    if (PackageMgr.g_newPackage != null) {
                        NativeMethods.installDebugInfo(Component.g_pkgAIDLength, Component.g_pkgAID, Component.g_componentAddresses);
                    }
                    PackageMgr.commit();
                    if (doCommit) {
                        JCSystem.commitTransaction();
                    }
                    break;
                }
                case -72: {
                    AppletComponent.create(apdu);
                    break;
                }
                case -66: {
                    PackageMgr.cleanup();
                    Component.echoError((short)25615);
                    break;
                }
                default: {
                    ISOException.throwIt((short)27904);
                    break;
                }
            }
        }
        catch (ISOException e) {
            PackageMgr.cleanup();
            short reason = e.getReason();
            if (reason != -28672) {
                ISOException.throwIt(reason);
            } else {
                Component.echoError(reason);
            }
        }
        catch (InstallerException e) {
            PackageMgr.cleanup();
            Component.echoError(e.getReason());
        }
        catch (Exception exception) {
            PackageMgr.cleanup();
            Component.echoError((short)25636);
        }
    }

    void verifyAPDUOrder(APDU apdu) throws InstallerException {
        byte m_ins = apdu.getBuffer()[1];
        byte m_tag = apdu.getBuffer()[2];
        if (m_ins == -80) {
            return;
        }
        if (Component.g_currentState == -1) {
            InstallerException.throwIt((short)25633);
        }
        switch (m_ins) {
            case -78: 
            case -76: 
            case -68: {
                if (m_tag == Component.g_p1 || Component.g_p1 < 1) break;
                if (f_downloadOrder[m_tag] < f_downloadOrder[Component.g_p1]) {
                    InstallerException.throwIt((short)25634);
                }
                if (f_downloadOrder[m_tag] > (byte)(f_downloadOrder[Component.g_p1] + 1)) {
                    if (m_tag == 6) {
                        if ((Component.g_capFlags & 4) == 0) {
                            break;
                        }
                    } else if (m_tag == 5) {
                        if ((Component.g_capFlags & 2) == 0) {
                            break;
                        }
                    } else {
                        InstallerException.throwIt((short)25634);
                    }
                }
                if (Component.g_loadComplete[Component.g_p1]) break;
                InstallerException.throwIt((short)25634);
                break;
            }
            case -80: 
            case -72: 
            case -70: {
                if (Component.g_currentState == 0) break;
                InstallerException.throwIt((short)25637);
                break;
            }
            default: {
                InstallerException.throwIt((short)27904);
            }
            case -66: 
        }
    }
}

