/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework;

import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PackedBoolean;
import com.sun.javacard.impl.PrivAccess;
import javacard.framework.APDUException;
import javacard.framework.JCSystem;
import javacard.framework.Util;

public final class APDU {
    private static final short BUFFERSIZE = 37;
    private static final byte IFSC = 1;
    private static final short IFSD = 258;
    private static APDU theAPDU;
    private byte[] buffer = NativeMethods.t0InitAPDUBuffer();
    private static byte[] ramVars;
    private static final byte LE = 0;
    private static final byte LR = 1;
    private static final byte LC = 2;
    private static final byte PRE_READ_LENGTH = 3;
    private static final byte RAM_VARS_LENGTH = 4;
    private static final short BUFFER_OVERFLOW = -16383;
    private static final short READ_ERROR = -16381;
    private static final short WRITE_ERROR = -16380;
    private static final short INVALID_GET_RESPONSE = -16378;
    private static final byte ACK_NONE = 0;
    private static final byte ACK_INS = 1;
    private static final byte ACK_NOT_INS = 2;
    private PackedBoolean thePackedBoolean;
    private byte incomingFlag;
    private byte outgoingFlag;
    private byte outgoingLenSetFlag;
    private byte lrIs256Flag;
    private byte sendInProgressFlag;
    private byte noChainingFlag;
    private byte noGetResponseFlag;
    public static final byte PROTOCOL_T0 = 0;
    public static final byte PROTOCOL_T1 = 1;

    APDU() {
        ramVars = JCSystem.makeTransientByteArray((short)4, (byte)1);
        this.thePackedBoolean = PrivAccess.getPackedBoolean();
        this.incomingFlag = this.thePackedBoolean.allocate();
        this.sendInProgressFlag = this.thePackedBoolean.allocate();
        this.outgoingFlag = this.thePackedBoolean.allocate();
        this.outgoingLenSetFlag = this.thePackedBoolean.allocate();
        this.lrIs256Flag = this.thePackedBoolean.allocate();
        this.noChainingFlag = this.thePackedBoolean.allocate();
        this.noGetResponseFlag = this.thePackedBoolean.allocate();
        theAPDU = this;
    }

    void complete(short status) throws APDUException {
        short result;
        Util.arrayFillNonAtomic(this.buffer, (short)0, (short)37, (byte)0);
        if (!this.getNoGetResponseFlag() && this.getSendInProgressFlag()) {
            short Le = (byte)this.getLe();
            short sendLen = 32;
            while (Le > 0) {
                if (Le < 32) {
                    sendLen = Le;
                }
                if ((result = NativeMethods.t0SndData(this.buffer, (short)0, sendLen, (byte)0)) != 0) {
                    APDUException.throwIt((short)4);
                }
                Le = (short)(Le - sendLen);
            }
        }
        this.buffer[0] = (byte)(status >> 8);
        this.buffer[1] = (byte)status;
        if (status == 0) {
            result = NativeMethods.t0RcvCommand();
        } else {
            NativeMethods.t0SetStatus(status);
            result = NativeMethods.t0SndStatusRcvCommand();
        }
        if (result != 0) {
            APDUException.throwIt((short)4);
        }
        this.resetAPDU();
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public static short getInBlockSize() {
        return 1;
    }

    private boolean getIncomingFlag() {
        return this.thePackedBoolean.get(this.incomingFlag);
    }

    private byte getLc() {
        return ramVars[2];
    }

    private short getLe() {
        if (ramVars[0] == 0) {
            return 256;
        }
        return (short)(ramVars[0] & 0xFF);
    }

    private short getLr() {
        if (this.getLrIs256Flag()) {
            return 256;
        }
        return (short)(ramVars[1] & 0xFF);
    }

    private boolean getLrIs256Flag() {
        return this.thePackedBoolean.get(this.lrIs256Flag);
    }

    public byte getNAD() {
        return 0;
    }

    boolean getNoChainingFlag() {
        return this.thePackedBoolean.get(this.noChainingFlag);
    }

    private boolean getNoGetResponseFlag() {
        return this.thePackedBoolean.get(this.noGetResponseFlag);
    }

    public static short getOutBlockSize() {
        return 258;
    }

    private boolean getOutgoingFlag() {
        return this.thePackedBoolean.get(this.outgoingFlag);
    }

    private boolean getOutgoingLenSetFlag() {
        return this.thePackedBoolean.get(this.outgoingLenSetFlag);
    }

    private byte getPreReadLength() {
        return ramVars[3];
    }

    public static byte getProtocol() {
        return 0;
    }

    private boolean getSendInProgressFlag() {
        return this.thePackedBoolean.get(this.sendInProgressFlag);
    }

    public short receiveBytes(short bOff) throws APDUException {
        short pre;
        if (!this.getIncomingFlag() || this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        short Lc = (short)(this.getLc() & 0xFF);
        if (bOff < 0 || Lc >= 1 && (short)(bOff + 1) >= 37) {
            APDUException.throwIt((short)2);
        }
        if ((pre = (short)(this.getPreReadLength() & 0xFF)) != 0) {
            this.setPreReadLength((byte)0);
            return pre;
        }
        if (Lc != 0) {
            short len = NativeMethods.t0RcvData(bOff);
            if (len < 0) {
                APDUException.throwIt((short)4);
            }
            this.setLc((byte)(Lc - len));
            return len;
        }
        return 0;
    }

    void resetAPDU() {
        this.setLe(this.buffer[4]);
        this.setLc((byte)0);
        this.setLr((byte)0);
        this.resetIncomingFlag();
        this.resetOutgoingFlag();
        this.resetOutgoingLenSetFlag();
        this.resetSendInProgressFlag();
        this.resetLrIs256Flag();
        this.resetNoChainingFlag();
        this.resetNoGetResponseFlag();
        this.setPreReadLength((byte)0);
    }

    private void resetIncomingFlag() {
        this.thePackedBoolean.reset(this.incomingFlag);
    }

    private void resetLrIs256Flag() {
        this.thePackedBoolean.reset(this.lrIs256Flag);
    }

    private void resetNoChainingFlag() {
        this.thePackedBoolean.reset(this.noChainingFlag);
    }

    private void resetNoGetResponseFlag() {
        this.thePackedBoolean.reset(this.noGetResponseFlag);
    }

    private void resetOutgoingFlag() {
        this.thePackedBoolean.reset(this.outgoingFlag);
    }

    private void resetOutgoingLenSetFlag() {
        this.thePackedBoolean.reset(this.outgoingLenSetFlag);
    }

    private void resetSendInProgressFlag() {
        this.thePackedBoolean.reset(this.sendInProgressFlag);
    }

    private short send61xx(short len) {
        short expLen = len;
        do {
            NativeMethods.t0SetStatus((short)(24832 + (len & 0xFF)));
            short newLen = NativeMethods.t0SndGetResponse();
            if (newLen == -16378) {
                this.setNoGetResponseFlag();
                APDUException.throwIt((short)170);
                continue;
            }
            if (newLen > 0) {
                APDU.ramVars[0] = (byte)newLen;
                expLen = this.getLe();
                continue;
            }
            APDUException.throwIt((short)4);
        } while (expLen > len);
        this.resetSendInProgressFlag();
        return expLen;
    }

    /*
     * Unable to fully structure code
     */
    public void sendBytes(short bOff, short len) throws APDUException {
        block15: {
            if (bOff < 0 || len < 0 || (short)(bOff + len) > 37) {
                APDUException.throwIt((short)2);
            }
            if (!this.getOutgoingLenSetFlag() || this.getNoGetResponseFlag()) {
                APDUException.throwIt((short)1);
            }
            if (len == 0) {
                return;
            }
            Lr = this.getLr();
            if (len > Lr) {
                APDUException.throwIt((short)1);
            }
            Le = this.getLe();
            if (!this.getNoChainingFlag()) ** GOTO lbl49
            if (this.getIncomingFlag() || Lr < Le) {
                Le = this.send61xx(Lr);
                this.resetIncomingFlag();
            }
            while (len > Le) {
                if (!this.getSendInProgressFlag()) {
                    result = NativeMethods.t0SndData(this.buffer, bOff, Le, (byte)1);
                    this.setSendInProgressFlag();
                } else {
                    result = NativeMethods.t0SndData(this.buffer, bOff, Le, (byte)0);
                }
                if (result != 0) {
                    APDUException.throwIt((short)4);
                }
                bOff = (short)(bOff + Le);
                len = (short)(len - Le);
                Lr = (short)(Lr - Le);
                Le = this.send61xx(Lr);
            }
            if (!this.getSendInProgressFlag()) {
                result = NativeMethods.t0SndData(this.buffer, bOff, len, (byte)1);
                this.setSendInProgressFlag();
            } else {
                result = NativeMethods.t0SndData(this.buffer, bOff, len, (byte)0);
            }
            if (result != 0) {
                APDUException.throwIt((short)4);
            }
            Lr = (short)(Lr - len);
            Le = (short)(Le - len);
            break block15;
lbl-1000:
            // 1 sources

            {
                temp = len;
                if (len != Lr || this.getIncomingFlag() || Lr != Le || this.getSendInProgressFlag()) {
                    temp = this.send61xx(len);
                    this.resetIncomingFlag();
                }
                result = NativeMethods.t0SndData(this.buffer, bOff, temp, (byte)1);
                this.setSendInProgressFlag();
                if (result != 0) {
                    APDUException.throwIt((short)4);
                }
                bOff = (short)(bOff + temp);
                len = (short)(len - temp);
                Le = Lr = (short)(Lr - temp);
lbl49:
                // 2 sources

                ** while (len > 0)
            }
        }
        this.setLe((byte)Le);
        this.setLr((byte)Lr);
    }

    public void sendBytesLong(byte[] outData, short bOff, short len) throws APDUException {
        short sendLength = (short)this.buffer.length;
        while (len > 0) {
            if (len < sendLength) {
                sendLength = len;
            }
            Util.arrayCopy(outData, bOff, this.buffer, (short)0, sendLength);
            this.sendBytes((short)0, sendLength);
            len = (short)(len - sendLength);
            bOff = (short)(bOff + sendLength);
        }
    }

    private void setIncoming() throws APDUException {
        if (this.getPreReadLength() != 0) {
            return;
        }
        if (this.getIncomingFlag() || this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        this.setIncomingFlag();
        byte Lc = (byte)this.getLe();
        this.setLc(Lc);
        this.setLe((byte)0);
    }

    public short setIncomingAndReceive() throws APDUException {
        this.setIncoming();
        return this.receiveBytes((short)5);
    }

    private void setIncomingFlag() {
        this.thePackedBoolean.set(this.incomingFlag);
    }

    private void setLc(byte data) {
        APDU.ramVars[2] = data;
    }

    private void setLe(byte data) {
        APDU.ramVars[0] = data;
    }

    private void setLr(byte data) {
        APDU.ramVars[1] = data;
    }

    private void setLrIs256Flag() {
        this.thePackedBoolean.set(this.lrIs256Flag);
    }

    private void setNoChainingFlag() {
        this.thePackedBoolean.set(this.noChainingFlag);
    }

    private void setNoGetResponseFlag() {
        this.thePackedBoolean.set(this.noGetResponseFlag);
    }

    public short setOutgoing() throws APDUException {
        if (this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        this.setOutgoingFlag();
        return this.getLe();
    }

    public void setOutgoingAndSend(short bOff, short len) throws APDUException {
        this.setOutgoing();
        this.setOutgoingLength(len);
        this.sendBytes(bOff, len);
    }

    private void setOutgoingFlag() {
        this.thePackedBoolean.set(this.outgoingFlag);
    }

    private void setOutgoingLenSetFlag() {
        this.thePackedBoolean.set(this.outgoingLenSetFlag);
    }

    public void setOutgoingLength(short len) throws APDUException {
        if (!this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        if (this.getOutgoingLenSetFlag()) {
            APDUException.throwIt((short)1);
        }
        if (len > 256 || len < 0) {
            APDUException.throwIt((short)3);
        }
        this.setOutgoingLenSetFlag();
        this.setLr((byte)len);
        if (len == 256) {
            this.setLrIs256Flag();
        }
    }

    public short setOutgoingNoChaining() throws APDUException {
        if (this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        this.setOutgoingFlag();
        this.setNoChainingFlag();
        return this.getLe();
    }

    private void setPreReadLength(byte data) {
        APDU.ramVars[3] = data;
    }

    private void setSendInProgressFlag() {
        this.thePackedBoolean.set(this.sendInProgressFlag);
    }

    void undoIncomingAndReceive() {
        this.setPreReadLength((byte)(this.buffer[4] - this.getLc()));
    }

    public static void waitExtension() throws APDUException {
        short result;
        if (theAPDU.getNoChainingFlag()) {
            APDUException.throwIt((short)1);
        }
        if ((result = NativeMethods.t0Wait()) != 0) {
            APDUException.throwIt((short)4);
        }
    }
}

