/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.attributes;

import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JLineNumberRecord;
import com.sun.javacard.classfile.constants.JConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

public class JLineNumberTableAttr
extends JAttribute {
    private JLineNumberRecord[] records;

    JLineNumberTableAttr(JConstantPool cp) {
        super(cp);
    }

    JLineNumberRecord[] getJLineNumberRecords() {
        return this.records;
    }

    public int getLineNumber(int pc) {
        int line_number = -1;
        int distance = -1;
        int i = 0;
        while (i < this.records.length) {
            JLineNumberRecord record = this.records[i];
            if (record.getStartPc() <= pc) {
                if (distance == -1) {
                    distance = pc - record.getStartPc();
                    line_number = record.getSourceLineNumber();
                } else if (pc - record.getStartPc() < distance) {
                    distance = pc - record.getStartPc();
                    line_number = record.getSourceLineNumber();
                }
            }
            ++i;
        }
        return line_number;
    }

    public void parse(DataInputStream dis) throws IOException {
        int attri_length = dis.readInt();
        int length = dis.readUnsignedShort();
        this.records = new JLineNumberRecord[length];
        int i = 0;
        while (i < length) {
            int pc = dis.readUnsignedShort();
            int line_number = dis.readUnsignedShort();
            this.records[i] = new JLineNumberRecord(pc, line_number);
            ++i;
        }
    }
}

